/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.framework.validator.beanvalidation.impl;

import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.eas.scm.framework.validator.beanvalidation.IPropertyValidator;
import com.kingdee.eas.scm.framework.validator.beanvalidation.IPropertyValidatorDescription;
import com.kingdee.eas.scm.framework.validator.beanvalidation.PropertyValidationError;
import com.kingdee.eas.scm.framework.validator.beanvalidation.desc.SizeValidatorDesc;
import com.kingdee.eas.scm.framework.validator.beanvalidation.impl.AbstractPropertyValidator;
import com.kingdee.eas.scm.framework.validator.beanvalidation.impl.ObjectTypeUtils;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Map;

public class SizeValidator
extends AbstractPropertyValidator
implements IPropertyValidator {
    @Override
    protected PropertyValidationError doValidation(IObjectValue bean, IPropertyValidatorDescription propertyDesc) {
        Object fieldValue = this.getPropertyValue(bean, propertyDesc);
        PropertyValidationError error = null;
        if (null == fieldValue) {
            error = this.getErrorInfo(bean, propertyDesc);
            error.setErrorType(PropertyValidationError.ERRORTYPE.ISNULL);
            return error;
        }
        SizeValidatorDesc desc = (SizeValidatorDesc)propertyDesc;
        int min = desc.getMin() >= 0 ? desc.getMin() : 0;
        int max = desc.getMax() >= min ? desc.getMax() : min;
        int length = -1;
        if (ObjectTypeUtils.isString(fieldValue)) {
            String t = (String)fieldValue;
            length = t.length();
        } else if (fieldValue instanceof IObjectCollection) {
            IObjectCollection collection = (IObjectCollection)fieldValue;
            length = collection.size();
        } else if (fieldValue instanceof Collection) {
            Collection collection = (Collection)fieldValue;
            length = collection.size();
        } else if (fieldValue instanceof Map) {
            Map map = (Map)fieldValue;
            length = map.size();
        } else if (fieldValue.getClass().isArray()) {
            length = Array.getLength(fieldValue);
        }
        if (length >= 0 && (length > max || length < min)) {
            error = this.getErrorInfo(bean, desc);
            error.setReplaceParam(new Object[]{String.valueOf(min), String.valueOf(max)});
        }
        return error;
    }

    @Override
    protected PropertyValidationError.ERRORTYPE errorType() {
        return PropertyValidationError.ERRORTYPE.OUTOFSIZE;
    }
}

