/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.dt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.StringUtils;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.codingrule.CodingRuleException;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.basedata.assistant.client.AssistantClientUtils;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.im.dt.CarFactory;
import com.kingdee.eas.scm.im.dt.CarInfo;
import com.kingdee.eas.scm.im.dt.client.AbstractCarEditUI;
import com.kingdee.eas.scm.im.dt.util.client.DeliveryLineClientUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Date;
import org.apache.log4j.Logger;

public class CarEditUI
extends AbstractCarEditUI {
    private static final Logger logger = CoreUIObject.getLogger(CarEditUI.class);
    public static final String UI_RESOURCE = "com.kingdee.eas.scm.im.dt.client.JhResource";
    public static final String UI_CAPTION = "CarQueryF7WindowTitle";
    private static final BigDecimal ZERO = new BigDecimal("0.00");

    @Override
    public void storeFields() {
        this.setAutoNumber("ControlUnit");
        super.storeFields();
    }

    public void onLoad() throws Exception {
        this.setUpTitle();
        super.onLoad();
        this.btnFirst.setVisible(true);
        this.btnPre.setVisible(true);
        this.btnNext.setVisible(true);
        this.btnLast.setVisible(true);
        this.separatorFW1.setVisible(false);
        this.separatorFW2.setVisible(false);
        this.separatorFW3.setVisible(false);
        this.btnPrint.setVisible(false);
        this.btnPrintPreview.setVisible(false);
        this.initHeadControl();
    }

    private void initHeadControl() {
        this.txtName.setMaxLength(255);
        this.txtNumber.setMaxLength(80);
        this.txtType.setMaxLength(80);
        this.txtWeight.setRemoveingZeroInDispaly(false);
        this.txtWeight.setPrecision(2);
        this.txtWeight.setHorizontalAlignment(4);
        this.txtVolume.setRemoveingZeroInDispaly(false);
        this.txtVolume.setPrecision(3);
        this.txtVolume.setHorizontalAlignment(4);
    }

    protected IObjectValue createNewData() {
        CarInfo info = new CarInfo();
        info.setCreator(SysContext.getSysContext().getCurrentUserInfo());
        info.setCU(SysContext.getSysContext().getCurrentCtrlUnit());
        Date now = SCMClientUtils.getServerDate2();
        info.setCreateTime(new Timestamp(now.getTime()));
        info.setVolume(ZERO);
        info.setWeight(ZERO);
        info.setIsInternal(false);
        return info;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return CarFactory.getRemoteInstance();
    }

    protected void setFieldsNull(AbstractObjectValue newData) {
        CarInfo info = (CarInfo)newData;
        info.setNumber(null);
        info.setName(null);
    }

    private void setUpTitle() {
        AssistantClientUtils.setupUITitle((CoreUIObject)this, (String)EASResource.getString((String)UI_RESOURCE, (String)UI_CAPTION));
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        BigDecimal mil;
        if (this.txtNumber.getText() == null || this.txtNumber.getText().trim().equals("")) {
            MsgBox.showError((Component)((Object)this), (String)DeliveryLineClientUtils.getResource("CarNumberIsNull"));
            this.txtNumber.requestFocus();
            SysUtil.abort();
        }
        if (this.txtName.getEditor().getItem() == null || this.txtName.getEditor().getItem().toString().trim().equals("")) {
            MsgBox.showError((Component)((Object)this), (String)DeliveryLineClientUtils.getResource("CarNameIsNull"));
            this.txtName.requestFocus();
            SysUtil.abort();
        }
        if (this.txtType.getText() == null || this.txtType.getText().trim().equals("")) {
            MsgBox.showError((Component)((Object)this), (String)DeliveryLineClientUtils.getResource("TypeIsNull"));
            this.txtType.requestFocus();
            SysUtil.abort();
        }
        if (this.txtWeight.getBigDecimalValue() != null && (mil = this.txtWeight.getBigDecimalValue()).compareTo(ZERO) < 0) {
            MsgBox.showError((Component)((Object)this), (String)DeliveryLineClientUtils.getResource("WeightIsNotSmall"));
            this.txtWeight.requestFocus();
            SysUtil.abort();
        }
        if (this.txtVolume.getBigDecimalValue() != null && (mil = this.txtVolume.getBigDecimalValue()).compareTo(ZERO) < 0) {
            MsgBox.showError((Component)((Object)this), (String)DeliveryLineClientUtils.getResource("VolumeIsNotSmall"));
            this.txtVolume.requestFocus();
            SysUtil.abort();
        }
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("CU"));
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("driver.*"));
        return sic;
    }

    @Override
    public void loadFields() {
        try {
            this.setAutoNumber("ControlUnit");
            super.loadFields();
            this.setTxtNumberStatus("ControlUnit");
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        if (this.txtNumber.getText() == null || this.txtNumber.getText().trim().length() == 0) {
            this.txtNumber.setText(this.getNewNumber());
        }
        super.actionSubmit_actionPerformed(e);
    }

    protected void setAutoNumber(String orgType) {
        if (this.editData.getNumber() == null || this.editData.getNumber().trim().length() == 0) {
            try {
                String companyID = null;
                if (!StringUtils.isEmpty((String)orgType) && !"NONE".equalsIgnoreCase(orgType) && SysContext.getSysContext().getCurrentOrgUnit(OrgType.getEnum((String)orgType)) != null) {
                    companyID = SysContext.getSysContext().getCurrentOrgUnit(OrgType.getEnum((String)orgType)).getString("id");
                } else if (SysContext.getSysContext().getCurrentOrgUnit() != null) {
                    companyID = SysContext.getSysContext().getCurrentOrgUnit().getString("id");
                }
                ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getRemoteInstance();
                if (iCodingRuleManager.isExist((IObjectValue)this.editData, companyID) && iCodingRuleManager.isAddView((IObjectValue)this.editData, companyID)) {
                    String number = iCodingRuleManager.getNumber((IObjectValue)this.editData, companyID);
                    this.editData.setNumber(number);
                    this.txtNumber.setText(number);
                }
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        }
    }

    public boolean checkBeforeWindowClosing() {
        boolean b = super.checkBeforeWindowClosing();
        if (this.isModify() && b) {
            this.recycleNumberByOrg((IObjectValue)this.editData, "ControlUnit", this.editData.getString("number"));
        }
        return b;
    }

    public void checkModified() throws Exception {
        if (this.isModify()) {
            String message = EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Confirm_Save_Check");
            int result = MsgBox.showConfirm3((Component)((Object)this), (String)message);
            if (result == 0) {
                if (!this.isModifySave()) {
                    ActionEvent event = new ActionEvent(this.btnSubmit, 1001, this.btnSubmit.getActionCommand());
                    this.actionSubmit.actionPerformed(event);
                    if (this.actionSubmit.isInvokeFailed()) {
                        this.recycleNumberByOrg((IObjectValue)this.editData, "ControlUnit", this.editData.getString("number"));
                        SysUtil.abort();
                    }
                } else {
                    this.actionSave.setDaemonRun(false);
                    ActionEvent event = new ActionEvent(this.btnSave, 1001, this.btnSave.getActionCommand());
                    this.actionSave.actionPerformed(event);
                    if (this.actionSave.isInvokeFailed()) {
                        this.recycleNumberByOrg((IObjectValue)this.editData, "ControlUnit", this.editData.getString("number"));
                        SysUtil.abort();
                    }
                }
            } else if (result == 2) {
                SysUtil.abort();
            }
        }
    }

    public String getNewNumber() throws CodingRuleException, EASBizException, BOSException {
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getRemoteInstance();
        String strCompanyID = iCodingRuleManager.getCurrentAppOUID(this.getDataObject());
        String orgNumber = null;
        if (iCodingRuleManager.isExist((IObjectValue)this.editData, strCompanyID)) {
            orgNumber = iCodingRuleManager.getNumber((IObjectValue)this.editData, strCompanyID);
        }
        return orgNumber;
    }

    protected void removeByPK(IObjectPK pk) throws Exception {
        CarInfo editData = this.editData;
        super.removeByPK(pk);
        this.recycleNumberByOrg((IObjectValue)editData, "ControlUnit", editData.getString("number"));
    }

    protected void recycleNumberByOrg(IObjectValue editData, String orgType, String number) {
        if (!StringUtils.isEmpty((String)number)) {
            try {
                String companyID = null;
                ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getRemoteInstance();
                if (!StringUtils.isEmpty((String)orgType) && !"NONE".equalsIgnoreCase(orgType) && SysContext.getSysContext().getCurrentOrgUnit(OrgType.getEnum((String)orgType)) != null) {
                    companyID = SysContext.getSysContext().getCurrentOrgUnit(OrgType.getEnum((String)orgType)).getString("id");
                } else if (SysContext.getSysContext().getCurrentOrgUnit() != null) {
                    companyID = SysContext.getSysContext().getCurrentOrgUnit().getString("id");
                }
                if (!StringUtils.isEmpty(companyID) && iCodingRuleManager.isExist(editData, companyID) && iCodingRuleManager.isUseIntermitNumber(editData, companyID)) {
                    iCodingRuleManager.recycleNumber(editData, companyID, number);
                }
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        }
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        super.actionEdit_actionPerformed(e);
        this.setTxtNumberStatus("ControlUnit");
    }

    private void setTxtNumberStatus(String orgType) {
        try {
            String companyID = null;
            if (!StringUtils.isEmpty((String)orgType) && !"NONE".equalsIgnoreCase(orgType) && SysContext.getSysContext().getCurrentOrgUnit(OrgType.getEnum((String)orgType)) != null) {
                companyID = SysContext.getSysContext().getCurrentOrgUnit(OrgType.getEnum((String)orgType)).getString("id");
            } else if (SysContext.getSysContext().getCurrentOrgUnit() != null) {
                companyID = SysContext.getSysContext().getCurrentOrgUnit().getString("id");
            }
            ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getRemoteInstance();
            if (iCodingRuleManager.isExist((IObjectValue)this.editData, companyID)) {
                if (iCodingRuleManager.isModifiable((IObjectValue)this.editData, companyID)) {
                    this.txtNumber.setEnabled(true);
                } else {
                    this.txtNumber.setEnabled(false);
                }
            }
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }
}

