/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.dt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.BizDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.IDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.extendcontrols.ext.IFilterInfoProducer;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectManager;
import com.kingdee.bos.ctrl.kdf.table.KDTSortManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.render.ObjectValueRender;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.StringUtils;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.codingrule.CodingRuleException;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.TransportOrgUnitInfo;
import com.kingdee.eas.basedata.org.client.f7.NewOrgUnitFilterInfoProducer;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.BillEntryBaseInfo;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.service.SCMServiceFactory;
import com.kingdee.eas.scm.common.util.PrecisionUtil;
import com.kingdee.eas.scm.common.util.SortUtil;
import com.kingdee.eas.scm.im.dt.CarCollection;
import com.kingdee.eas.scm.im.dt.CarInfo;
import com.kingdee.eas.scm.im.dt.CarrierCarEntryInfo;
import com.kingdee.eas.scm.im.dt.CarrierDriverEntryInfo;
import com.kingdee.eas.scm.im.dt.CarrierFactory;
import com.kingdee.eas.scm.im.dt.CarrierInfo;
import com.kingdee.eas.scm.im.dt.DriverCollection;
import com.kingdee.eas.scm.im.dt.DriverFactory;
import com.kingdee.eas.scm.im.dt.DriverInfo;
import com.kingdee.eas.scm.im.dt.client.AbstractCarrierEditUI;
import com.kingdee.eas.scm.im.dt.util.DtUtils;
import com.kingdee.eas.scm.im.dt.util.client.DeliveryLineClientUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class CarrierEditUI
extends AbstractCarrierEditUI
implements DataChangeListener,
KDTEditListener,
ChangeListener {
    private static final Logger logger = CoreUIObject.getLogger(CarrierEditUI.class);
    private static final String TB_NUMBER = "number";
    private static final String TB_NAME = "name";
    private static final String TB_TYPE = "type";
    private static final String TB_WEIGHT = "weight";
    private static final String TB_VOLUME = "volume";
    private static final String TB_DRIVER = "driver";
    private static final String TB_NOTE = "note";
    private static final String TB_DR_NUMBER = "number";
    private static final String TB_DR_NAME = "name";
    private static final String TB_DR_CELL = "cell";
    private static final String TB_DR_PHONE = "phone";
    private static final String TB_DR_IDCARD = "idcard";
    private static final String TB_DR_ADDRESS = "address";
    private static final String TB_DR_NOTE = "note";
    public static final String UI_RESOURCE = "com.kingdee.eas.scm.im.dt.client.JhResource";
    KDBizPromptBox prmtCar = new KDBizPromptBox();
    KDBizPromptBox prmtDriver = new KDBizPromptBox();
    boolean isCarPage = true;
    KDTable kdTable = this.kdtEntry;
    private OrgUnitInfo[] mainOrgs = null;
    TransportOrgUnitInfo senderTransport = null;
    private OrgUnitInfo mainOrg = null;
    private int idxDefaultMainOrg = -1;
    private boolean isSubmitedAddNew = false;

    public CarrierEditUI() throws Exception {
        this.btnAddLine.setIcon(EASResource.getIcon((String)"imgTbtn_addline"));
        this.btnInsertLine.setIcon(EASResource.getIcon((String)"imgTbtn_insert"));
        this.btnRemoveLine.setIcon(EASResource.getIcon((String)"imgTbtn_deleteline"));
    }

    protected void removeListeners() {
        this.kdtEntry.removeKDTEditListener((KDTEditListener)this);
        this.kdtDriverEntry.removeKDTEditListener((KDTEditListener)this);
        this.prmtCar.removeChangeListener((ChangeListener)this);
        this.prmtDriver.removeChangeListener((ChangeListener)this);
        this.prmtTransport.removeDataChangeListener((DataChangeListener)this);
    }

    protected void addListeners() {
        this.kdtEntry.addKDTEditListener((KDTEditListener)this);
        this.kdtDriverEntry.addKDTEditListener((KDTEditListener)this);
        this.prmtCar.addChangeListener((ChangeListener)this);
        this.prmtDriver.addChangeListener((ChangeListener)this);
        this.prmtTransport.addDataChangeListener((DataChangeListener)this);
    }

    @Override
    public void loadFields() {
        try {
            this.removeListeners();
            this.setAutoNumber("Transport");
            this.dataBinder.loadFields();
            this.updateButtonStatus();
            TransportOrgUnitInfo transportOrg = (TransportOrgUnitInfo)this.prmtTransport.getData();
            if (transportOrg != null && !transportOrg.isIsBizUnit()) {
                this.prmtTransport.setValue(null);
            }
            this.setSupplier();
            this.addListeners();
            this.setTxtNumberStatus("Transport");
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    protected void setAutoNumberByOrg(String orgType) {
        if (this.editData.getNumber() == null) {
            try {
                String companyID = null;
                if (!StringUtils.isEmpty((String)orgType) && !"NONE".equalsIgnoreCase(orgType) && SysContext.getSysContext().getCurrentOrgUnit(OrgType.getEnum((String)orgType)) != null) {
                    companyID = SysContext.getSysContext().getCurrentOrgUnit(OrgType.getEnum((String)orgType)).getString("id");
                } else if (SysContext.getSysContext().getCurrentOrgUnit() != null) {
                    companyID = SysContext.getSysContext().getCurrentOrgUnit().getString("id");
                }
                ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getRemoteInstance();
                if (iCodingRuleManager.isExist((IObjectValue)this.editData, companyID)) {
                    if (iCodingRuleManager.isAddView((IObjectValue)this.editData, companyID)) {
                        this.editData.setNumber(iCodingRuleManager.getNumber((IObjectValue)this.editData, companyID));
                    }
                    this.txtNumber.setEnabled(false);
                }
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        } else if (this.editData.getNumber().trim().length() > 0) {
            this.txtNumber.setText(this.editData.getNumber());
        }
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Transport;
    }

    public KDBizPromptBox getMainOrgUnit() {
        return this.prmtTransport;
    }

    protected KDBizPromptBox getMainBizOrg() {
        return this.prmtTransport;
    }

    protected void removeByPK(IObjectPK pk) throws Exception {
        CarrierInfo editData = this.editData;
        super.removeByPK(pk);
        this.recycleNumberByOrg((IObjectValue)editData, "Transport", editData.getString("number"));
    }

    protected void recycleNumberByOrg(IObjectValue editData, String orgType, String number) {
        if (!StringUtils.isEmpty((String)number)) {
            try {
                String companyID = null;
                ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getRemoteInstance();
                if (!StringUtils.isEmpty((String)orgType) && !"NONE".equalsIgnoreCase(orgType) && SysContext.getSysContext().getCurrentOrgUnit(OrgType.getEnum((String)orgType)) != null) {
                    companyID = SysContext.getSysContext().getCurrentOrgUnit(OrgType.getEnum((String)orgType)).getString("id");
                } else if (SysContext.getSysContext().getCurrentOrgUnit() != null) {
                    companyID = SysContext.getSysContext().getCurrentOrgUnit().getString("id");
                }
                if (!StringUtils.isEmpty(companyID) && iCodingRuleManager.isExist(editData, companyID) && iCodingRuleManager.isUseIntermitNumber(editData, companyID)) {
                    iCodingRuleManager.recycleNumber(editData, companyID, number);
                }
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        }
    }

    protected void setFieldsNull(AbstractObjectValue newData) {
        super.setFieldsNull(newData);
        newData.put("number", null);
        CarrierInfo info = (CarrierInfo)newData;
        info.setNumber(null);
        info.setSupplier(null);
    }

    protected void updateButtonStatus() {
        this.actionSave.setVisible(false);
        this.menuItemSave.setVisible(false);
        this.actionCancel.setEnabled(false);
        this.actionCancelCancel.setEnabled(false);
        if (this.getOprtState().equals("ADDNEW")) {
            this.actionAddLine.setEnabled(true);
            this.actionInsertLine.setEnabled(true);
            this.actionRemoveLine.setEnabled(true);
            this.actionEdit.setEnabled(false);
        } else if (this.getOprtState().equals("EDIT")) {
            this.actionAddLine.setEnabled(true);
            this.actionInsertLine.setEnabled(true);
            this.actionRemoveLine.setEnabled(true);
            this.actionEdit.setEnabled(false);
        } else if (this.getOprtState().equals("VIEW")) {
            this.actionAddLine.setEnabled(false);
            this.actionInsertLine.setEnabled(false);
            this.actionRemoveLine.setEnabled(false);
            this.actionEdit.setEnabled(true);
        }
    }

    private void setTxtNumberStatus(String orgType) {
        try {
            String companyID = null;
            if (!StringUtils.isEmpty((String)orgType) && !"NONE".equalsIgnoreCase(orgType) && SysContext.getSysContext().getCurrentOrgUnit(OrgType.getEnum((String)orgType)) != null) {
                companyID = SysContext.getSysContext().getCurrentOrgUnit(OrgType.getEnum((String)orgType)).getString("id");
            } else if (SysContext.getSysContext().getCurrentOrgUnit() != null) {
                companyID = SysContext.getSysContext().getCurrentOrgUnit().getString("id");
            }
            ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getRemoteInstance();
            if (iCodingRuleManager.isExist((IObjectValue)this.editData, companyID)) {
                if (iCodingRuleManager.isModifiable((IObjectValue)this.editData, companyID)) {
                    this.txtNumber.setEnabled(true);
                } else {
                    this.txtNumber.setEnabled(false);
                }
            }
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public boolean isModify() {
        if (this.isSubmitedAddNew) {
            return false;
        }
        return super.isModify();
    }

    protected void afterSubmitAddNew() {
        this.isSubmitedAddNew = true;
        this.initOldData((IObjectValue)this.editData);
        super.afterSubmitAddNew();
    }

    protected void afterSubmitPrint() {
        this.initOldData((IObjectValue)this.editData);
        super.afterSubmitPrint();
    }

    protected void setAutoNumber(String orgType) {
        if (this.editData.getNumber() == null || this.editData.getNumber().trim().length() == 0) {
            try {
                String companyID = null;
                if (!StringUtils.isEmpty((String)orgType) && !"NONE".equalsIgnoreCase(orgType) && SysContext.getSysContext().getCurrentOrgUnit(OrgType.getEnum((String)orgType)) != null) {
                    companyID = SysContext.getSysContext().getCurrentOrgUnit(OrgType.getEnum((String)orgType)).getString("id");
                } else if (SysContext.getSysContext().getCurrentOrgUnit() != null) {
                    companyID = SysContext.getSysContext().getCurrentOrgUnit().getString("id");
                }
                ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getRemoteInstance();
                if (iCodingRuleManager.isExist((IObjectValue)this.editData, companyID) && iCodingRuleManager.isAddView((IObjectValue)this.editData, companyID)) {
                    String number = iCodingRuleManager.getNumber((IObjectValue)this.editData, companyID);
                    this.editData.setNumber(number);
                    this.txtNumber.setText(number);
                }
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        }
    }

    public boolean checkBeforeWindowClosing() {
        boolean b = super.checkBeforeWindowClosing();
        if (this.isModify() && b) {
            this.recycleNumberByOrg((IObjectValue)this.editData, "Transport", this.editData.getString("number"));
        }
        return b;
    }

    public void checkModified() throws Exception {
        if (this.isModify()) {
            String message = EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Confirm_Save_Check");
            int result = MsgBox.showConfirm3((Component)((Object)this), (String)message);
            if (result == 0) {
                if (!this.isModifySave()) {
                    ActionEvent event = new ActionEvent(this.btnSubmit, 1001, this.btnSubmit.getActionCommand());
                    this.actionSubmit.actionPerformed(event);
                    if (this.actionSubmit.isInvokeFailed()) {
                        this.recycleNumberByOrg((IObjectValue)this.editData, "Transport", this.editData.getString("number"));
                        SysUtil.abort();
                    }
                } else {
                    this.actionSave.setDaemonRun(false);
                    ActionEvent event = new ActionEvent(this.btnSave, 1001, this.btnSave.getActionCommand());
                    this.actionSave.actionPerformed(event);
                    if (this.actionSave.isInvokeFailed()) {
                        this.recycleNumberByOrg((IObjectValue)this.editData, "Transport", this.editData.getString("number"));
                        SysUtil.abort();
                    }
                }
            } else if (result == 2) {
                SysUtil.abort();
            }
        }
    }

    protected KDTable getDetailTable() {
        return this.kdtEntry;
    }

    protected void beforeStoreFields(ActionEvent e) throws Exception {
        Object obj;
        int i;
        this.setAutoNumber("Transport");
        if (e == null || e.getSource() == this.btnSave || e.getSource() == this.menuItemSave) {
            return;
        }
        if (this.txtNumber.getText() == null || this.txtNumber.getText().trim().equals("")) {
            MsgBox.showError((Component)((Object)this), (String)DeliveryLineClientUtils.getResource("NumberIsNull"));
            this.txtNumber.requestFocus();
            SysUtil.abort();
        }
        if (this.prmtTransport.getData() == null) {
            MsgBox.showError((Component)((Object)this), (String)DeliveryLineClientUtils.getResource("TransportOrgIsNull"));
            this.prmtTransport.requestFocus();
            SysUtil.abort();
        }
        if (this.prmtSupplier.getData() == null) {
            MsgBox.showError((Component)((Object)this), (String)DeliveryLineClientUtils.getResource("SupplierIsNull"));
            this.prmtSupplier.requestFocus();
            SysUtil.abort();
        }
        HashSet<String> indexSet = new HashSet<String>();
        int n = this.kdtEntry.getRowCount();
        for (i = 0; i < n; ++i) {
            if (this.kdtEntry.getCell(i, "number").getValue() == null || !((obj = this.kdtEntry.getCell(i, "number").getValue()) instanceof CarInfo)) continue;
            indexSet.add(((CarInfo)obj).getId().toString());
        }
        if (indexSet.size() < n) {
            MsgBox.showError((Component)((Object)this), (String)DeliveryLineClientUtils.getResource("CarNumberIsSame"));
            SysUtil.abort();
        }
        indexSet = new HashSet();
        n = this.kdtDriverEntry.getRowCount();
        for (i = 0; i < n; ++i) {
            if (this.kdtDriverEntry.getCell(i, "number").getValue() == null || !((obj = this.kdtDriverEntry.getCell(i, "number").getValue()) instanceof DriverInfo)) continue;
            indexSet.add(((DriverInfo)obj).getId().toString());
        }
        if (indexSet.size() < n) {
            MsgBox.showError((Component)((Object)this), (String)DeliveryLineClientUtils.getResource("DriverNumberIsSame"));
            SysUtil.abort();
        }
        super.beforeStoreFields(e);
    }

    public void onLoad() throws Exception {
        this.initKDTEntry();
        super.onLoad();
        if (this.getMainBizOrg() != null) {
            this.setMainBizOrgF7(this.getMainBizOrg(), this.getMainBizOrgType());
            this.getMainBizOrg().setRequired(true);
        }
        this.initHeadControl();
    }

    protected void setMainBizOrgF7(KDBizPromptBox bizOrgUnitBox, OrgType orgType) {
        NewOrgUnitFilterInfoProducer iProducer = new NewOrgUnitFilterInfoProducer(orgType, this.getPermissionItem(this.getOprtState()));
        bizOrgUnitBox.setFilterInfoProducer((IFilterInfoProducer)iProducer);
        bizOrgUnitBox.setCommitFormat("$number$;$code$");
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnFirst.setVisible(true);
        this.btnPre.setVisible(true);
        this.btnNext.setVisible(true);
        this.btnLast.setVisible(true);
        this.separatorFW1.setVisible(false);
        this.separatorFW2.setVisible(false);
        this.separatorFW3.setVisible(false);
        this.btnPrint.setVisible(false);
        this.btnPrintPreview.setVisible(false);
    }

    private void initHeadControl() {
        this.prmtSupplier.setFilterInfoProducer(DtUtils.getNoCUFilterProducer());
        NewOrgUnitFilterInfoProducer iProducer = new NewOrgUnitFilterInfoProducer(OrgType.Transport, this.getPermissionItem(this.getOprtState()));
        FilterInfo filter = iProducer.getFilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("isBizUnit", (Object)new Integer(1), CompareType.EQUALS));
        this.prmtTransport.setFilterInfoProducer((IFilterInfoProducer)iProducer);
    }

    protected String getPermissionItem(String status) {
        if ("ADDNEW".equals(status)) {
            return "carrier_addnew";
        }
        return null;
    }

    private void initKDTEntry() {
        this.kdtEntry.checkParsed();
        if (this.kdtEntry.getActionMap() != null) {
            this.getDetailTable().getActionMap().remove("Paste");
        }
        this.kdtDriverEntry.checkParsed();
        if (this.kdtDriverEntry.getActionMap() != null) {
            this.kdtDriverEntry.getActionMap().remove("Paste");
        }
        KDTSortManager sortManager = new KDTSortManager(this.kdtEntry);
        sortManager.setSortAuto(true);
        this.kdtEntry.getColumn("number").setSortable(true);
        sortManager = new KDTSortManager(this.kdtDriverEntry);
        sortManager.setSortAuto(true);
        this.kdtDriverEntry.getColumn("number").setSortable(true);
        ObjectValueRender avr = new ObjectValueRender();
        avr.setFormat((IDataFormat)new BizDataFormat("$number$"));
        this.prmtCar.setEnabledMultiSelection(true);
        DtUtils.setDefaultF7Editor(this.prmtCar, "com.kingdee.eas.scm.im.dt.app.CarQuery", this.kdtEntry, "number");
        this.kdtEntry.getColumn("number").setRenderer((IBasicRender)avr);
        this.prmtDriver.setEnabledMultiSelection(true);
        DtUtils.setDefaultF7Editor(this.prmtDriver, "com.kingdee.eas.scm.im.dt.app.DriverQuery", this.kdtDriverEntry, "number");
        this.kdtDriverEntry.getColumn("number").setRenderer((IBasicRender)avr);
        KDFormattedTextField txtDecimal = new KDFormattedTextField(1);
        KDTDefaultCellEditor editorDecimal = new KDTDefaultCellEditor((JTextField)txtDecimal);
        txtDecimal.setHorizontalAlignment(4);
        txtDecimal.setPrecision(4);
        txtDecimal.setSupportedEmpty(true);
        txtDecimal.setNegatived(false);
        DtUtils.setDefaultDecimalEditor(txtDecimal, editorDecimal, this.kdtEntry, TB_WEIGHT);
        String formatString = PrecisionUtil.getFormatString((int)2);
        this.kdtEntry.getColumn(TB_WEIGHT).getStyleAttributes().setNumberFormat(formatString);
        DtUtils.setDefaultDecimalEditor(txtDecimal, editorDecimal, this.kdtEntry, TB_VOLUME);
        formatString = PrecisionUtil.getFormatString((int)3);
        this.kdtEntry.getColumn(TB_VOLUME).getStyleAttributes().setNumberFormat(formatString);
    }

    public void kdtEntry_Changed(KDTEditEvent e) throws Exception {
        if (e.getOldValue() == null && e.getValue() == null || e.getOldValue() != null && e.getOldValue().equals(e.getValue())) {
            return;
        }
        int rowIndex = e.getRowIndex();
        int colIndex = e.getColIndex();
        if (this.kdtEntry.getColumnIndex("number") == colIndex) {
            CarInfo car = null;
            if (this.kdtEntry.getCell(rowIndex, "number").getValue() instanceof Object[]) {
                Object[] objs = (Object[])this.kdtEntry.getCell(rowIndex, "number").getValue();
                if (objs == null) {
                    return;
                }
                car = (CarInfo)objs[0];
            } else {
                car = (CarInfo)this.kdtEntry.getCell(rowIndex, "number").getValue();
            }
            if (car != null) {
                this.kdtEntry.getCell(rowIndex, "name").setValue((Object)car.getName());
                this.kdtEntry.getCell(rowIndex, TB_TYPE).setValue((Object)car.getType());
                this.kdtEntry.getCell(rowIndex, TB_WEIGHT).setValue((Object)car.getWeight());
                this.kdtEntry.getCell(rowIndex, TB_VOLUME).setValue((Object)car.getVolume());
                String driverName = null;
                DriverInfo driverInfo = car.getDriver();
                if (driverInfo != null) {
                    driverInfo = DriverFactory.getRemoteInstance().getDriverInfo((IObjectPK)new ObjectUuidPK(driverInfo.getId().toString()));
                    driverName = driverInfo.getName();
                }
                this.kdtEntry.getCell(rowIndex, TB_DRIVER).setValue(driverName);
                this.kdtEntry.getCell(rowIndex, "note").setValue((Object)car.getDescription());
            } else {
                this.kdtEntry.getCell(rowIndex, "name").setValue(null);
                this.kdtEntry.getCell(rowIndex, TB_TYPE).setValue(null);
                this.kdtEntry.getCell(rowIndex, TB_WEIGHT).setValue(null);
                this.kdtEntry.getCell(rowIndex, TB_VOLUME).setValue(null);
                this.kdtEntry.getCell(rowIndex, TB_DRIVER).setValue(null);
                this.kdtEntry.getCell(rowIndex, "note").setValue(null);
            }
        }
    }

    public void kdtDriverEntry_Changed(KDTEditEvent e) throws Exception {
        if (e.getOldValue() == null && e.getValue() == null || e.getOldValue() != null && e.getOldValue().equals(e.getValue())) {
            return;
        }
        int rowIndex = e.getRowIndex();
        int colIndex = e.getColIndex();
        if (this.kdtDriverEntry.getColumnIndex("number") == colIndex) {
            DriverInfo driver = null;
            if (this.kdtDriverEntry.getCell(rowIndex, "number").getValue() instanceof Object[]) {
                Object[] objs = (Object[])this.kdtDriverEntry.getCell(rowIndex, "number").getValue();
                if (objs == null) {
                    return;
                }
                driver = (DriverInfo)objs[0];
            } else {
                driver = (DriverInfo)this.kdtDriverEntry.getCell(rowIndex, "number").getValue();
            }
            if (driver != null) {
                this.kdtDriverEntry.getCell(rowIndex, "name").setValue((Object)driver.getName());
                this.kdtDriverEntry.getCell(rowIndex, TB_DR_CELL).setValue((Object)driver.getCell());
                this.kdtDriverEntry.getCell(rowIndex, TB_DR_PHONE).setValue((Object)driver.getPhone());
                this.kdtDriverEntry.getCell(rowIndex, TB_DR_IDCARD).setValue((Object)driver.getIdCardNO());
                this.kdtDriverEntry.getCell(rowIndex, TB_DR_ADDRESS).setValue((Object)driver.getAddress());
                this.kdtDriverEntry.getCell(rowIndex, "note").setValue((Object)driver.getDescription());
            } else {
                this.kdtDriverEntry.getCell(rowIndex, "name").setValue(null);
                this.kdtDriverEntry.getCell(rowIndex, TB_DR_CELL).setValue(null);
                this.kdtDriverEntry.getCell(rowIndex, TB_DR_PHONE).setValue(null);
                this.kdtDriverEntry.getCell(rowIndex, TB_DR_IDCARD).setValue(null);
                this.kdtDriverEntry.getCell(rowIndex, TB_DR_ADDRESS).setValue(null);
                this.kdtDriverEntry.getCell(rowIndex, "note").setValue(null);
            }
        }
    }

    protected IObjectValue createNewData() {
        CarrierInfo info = new CarrierInfo();
        Date now = SCMClientUtils.getServerDate2();
        UserInfo user = SysContext.getSysContext().getCurrentUserInfo();
        info.setCreator(user);
        info.setCreateTime(new Timestamp(now.getTime()));
        this.senderTransport = (TransportOrgUnitInfo)this.getDefaultMainBizOrg();
        info.setTransport(this.senderTransport);
        CarrierCarEntryInfo entry = new CarrierCarEntryInfo();
        info.getEntry().add(entry);
        CarrierDriverEntryInfo driverEntry = new CarrierDriverEntryInfo();
        info.getDriverEntry().add(driverEntry);
        return info;
    }

    protected final OrgUnitInfo getDefaultMainBizOrg() {
        OrgUnitInfo currentMainOrg;
        if (this.mainOrg != null) {
            return this.mainOrg;
        }
        if (this.idxDefaultMainOrg > -1) {
            return this.mainOrgs[this.idxDefaultMainOrg];
        }
        if (this.mainOrgs == null) {
            try {
                ObjectStringPK userPK = new ObjectStringPK(SysContext.getSysContext().getCurrentUserInfo().getId().toString());
                this.mainOrgs = SCMServiceFactory.getPermissionService().getAuthorizedBizOrgUnits((IObjectPK)userPK, this.getMainBizOrgType(), this.getPermissionItem("ADDNEW"));
                if (this.mainOrgs == null) {
                    this.mainOrgs = new OrgUnitInfo[0];
                    return null;
                }
                if (this.mainOrgs.length > 0) {
                    this.mainOrgs = (OrgUnitInfo[])SortUtil.sortDataByNumber((DataBaseInfo[])this.mainOrgs, (boolean)true);
                }
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        }
        if ((currentMainOrg = SysContext.getSysContext().getCurrentOrgUnit(this.getMainBizOrgType())) != null && this.mainOrgs.length > 0) {
            for (int i = 0; i < this.mainOrgs.length; ++i) {
                if (!currentMainOrg.getId().toString().equals(this.mainOrgs[i].getId().toString())) continue;
                this.idxDefaultMainOrg = i;
                return currentMainOrg;
            }
        }
        if (this.mainOrgs != null && this.mainOrgs.length > 0) {
            this.idxDefaultMainOrg = 0;
            this.getUIContext().put(this.getMainBizOrgType(), this.mainOrgs[0]);
            this.initUIMainOrgContext(this.mainOrgs[0].getId().toString());
            return this.mainOrgs[0];
        }
        return null;
    }

    protected IObjectValue createNewDetailData(KDTable table) {
        BillEntryBaseInfo info = null;
        this.changeTable();
        info = this.isCarPage ? new CarrierCarEntryInfo() : new CarrierDriverEntryInfo();
        return info;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return CarrierFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext());
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("entry.car.id"));
        sic.add(new SelectorItemInfo("entry.car.number"));
        sic.add(new SelectorItemInfo("driverEntry.driver.id"));
        sic.add(new SelectorItemInfo("driverEntry.driver.number"));
        sic.add(new SelectorItemInfo("*"));
        return sic;
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddNew_actionPerformed(e);
        this.setMainBizOrgF7(this.getMainBizOrg(), this.getMainBizOrgType());
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        super.actionEdit_actionPerformed(e);
        this.updateButtonStatus();
        this.setTxtNumberStatus("Transport");
    }

    public void actionSubmit_actionPerformed(ActionEvent arg0) throws Exception {
        IObjectCollection collection;
        IObjectValue detailData;
        int i;
        for (i = this.kdtEntry.getRowCount() - 1; i >= 0; --i) {
            if (this.kdtEntry.getCell(i, "number").getValue() != null) continue;
            this.kdtEntry.getSelectManager().select(i, 0, i, 0, 2);
            detailData = (IObjectValue)this.kdtEntry.getRow(i).getUserObject();
            this.kdtEntry.removeRow(i);
            collection = (IObjectCollection)this.kdtEntry.getUserObject();
            if (collection == null) {
                logger.error((Object)"collection not be binded to table");
                continue;
            }
            if (detailData == null) continue;
            collection.removeObject(detailData);
        }
        for (i = this.kdtDriverEntry.getRowCount() - 1; i >= 0; --i) {
            if (this.kdtDriverEntry.getCell(i, "number").getValue() != null) continue;
            this.kdtDriverEntry.getSelectManager().select(i, 0, i, 0, 2);
            detailData = (IObjectValue)this.kdtDriverEntry.getRow(i).getUserObject();
            this.kdtDriverEntry.removeRow(i);
            collection = (IObjectCollection)this.kdtDriverEntry.getUserObject();
            if (collection == null) {
                logger.error((Object)"collection not be binded to table");
                continue;
            }
            if (detailData == null) continue;
            collection.removeObject(detailData);
        }
        if (this.txtNumber.getText() == null || this.txtNumber.getText().trim().length() == 0) {
            this.txtNumber.setText(this.getNewNumber());
        }
        super.actionSubmit_actionPerformed(arg0);
    }

    public String getNewNumber() throws CodingRuleException, EASBizException, BOSException {
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getRemoteInstance();
        String strCompanyID = iCodingRuleManager.getCurrentAppOUID(this.getDataObject());
        String orgNumber = null;
        if (iCodingRuleManager.isExist((IObjectValue)this.editData, strCompanyID)) {
            orgNumber = iCodingRuleManager.getNumber((IObjectValue)this.editData, strCompanyID);
        }
        return orgNumber;
    }

    protected void showSubmitSuccess() {
        this.setMessageText(MessageFormat.format(DeliveryLineClientUtils.getResource("CarrierMsg_Save_OK"), this.editData.getNumber()));
        this.setIsShowTextOnly(false);
        this.setShowMessagePolicy(0);
        this.showMessage();
    }

    protected void loadLineFields(KDTable table, IRow row, IObjectValue obj) {
        this.dataBinder.loadLineFields(table, row, obj);
    }

    @Override
    public void actionAddLine_actionPerformed(ActionEvent e) throws Exception {
        this.changeTable();
        IObjectValue entry = this.createNewDetailData(this.kdTable);
        IRow row = this.kdTable.addRow();
        this.loadLineFields(this.kdTable, row, entry);
    }

    protected final boolean isTableColumnSelected(KDTable table) {
        KDTSelectBlock block;
        return table.getSelectManager().size() > 0 && ((block = table.getSelectManager().get()).getMode() == 4 || block.getMode() == 8);
    }

    @Override
    public void actionInsertLine_actionPerformed(ActionEvent e) throws Exception {
        this.changeTable();
        IObjectValue entry = this.createNewDetailData(this.kdTable);
        IRow row = null;
        if (this.kdTable.getSelectManager().size() > 0) {
            int top = this.kdTable.getSelectManager().get().getTop();
            row = this.isTableColumnSelected(this.kdTable) ? this.kdTable.addRow() : this.kdTable.addRow(top);
        } else {
            row = this.kdTable.addRow();
        }
        this.loadLineFields(this.kdTable, row, entry);
    }

    protected void afterRemoveLine(KDTable table, IObjectValue lineData) {
    }

    @Override
    public void actionRemoveLine_actionPerformed(ActionEvent e) throws Exception {
        this.changeTable();
        if (this.kdTable.getSelectManager().size() == 0 || this.isTableColumnSelected(this.kdTable)) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_NoneEntry"));
            return;
        }
        if (this.confirmRemove()) {
            KDTSelectManager selectManager = this.kdTable.getSelectManager();
            int size = selectManager.size();
            KDTSelectBlock selectBlock = null;
            HashSet<Integer> indexSet = new HashSet<Integer>();
            for (int blockIndex = 0; blockIndex < size; ++blockIndex) {
                selectBlock = selectManager.get(blockIndex);
                int top = selectBlock.getBeginRow();
                int bottom = selectBlock.getEndRow();
                if (this.kdTable.getRow(top) == null) {
                    MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_NoneEntry"));
                    return;
                }
                for (int i = top; i <= bottom; ++i) {
                    indexSet.add(new Integer(i));
                }
            }
            Object[] indexArr = new Integer[indexSet.size()];
            Object[] indexObj = indexSet.toArray();
            System.arraycopy(indexObj, 0, indexArr, 0, indexArr.length);
            Arrays.sort(indexArr);
            for (int i = indexArr.length - 1; i >= 0; --i) {
                int index;
                int rowIndex = Integer.parseInt(String.valueOf(indexArr[i]));
                IObjectValue detailData = (IObjectValue)this.kdTable.getRow(rowIndex).getUserObject();
                this.kdTable.removeRow(rowIndex);
                IObjectCollection collection = (IObjectCollection)this.kdTable.getUserObject();
                if (collection == null) {
                    logger.error((Object)"collection not be binded to table");
                } else if (detailData != null && (index = this.getCollectionIndex(collection, detailData)) >= 0 && collection.size() > index) {
                    collection.removeObject(index);
                }
                this.afterRemoveLine(this.kdTable, detailData);
            }
            if (this.kdTable.getRow(0) != null) {
                this.kdTable.getSelectManager().select(0, 0);
            }
        }
    }

    private int getCollectionIndex(IObjectCollection collection, IObjectValue obj) {
        int index = -1;
        if (collection == null) {
            return index;
        }
        for (int i = collection.size() - 1; i >= 0; --i) {
            if (obj != collection.getObject(i)) continue;
            index = i;
            return index;
        }
        return index;
    }

    public void actionCopy_actionPerformed(ActionEvent e) throws Exception {
        super.actionCopy_actionPerformed(e);
        this.editData.setCU(SysContext.getSysContext().getCurrentCtrlUnit());
    }

    private void changeTable() {
        if (this.kDTabbedPane1.isVisibleAt(0)) {
            this.isCarPage = true;
            this.kdTable = this.kdtEntry;
        } else {
            this.isCarPage = false;
            this.kdTable = this.kdtDriverEntry;
        }
    }

    public void editCanceled(KDTEditEvent e) {
    }

    public void editStarted(KDTEditEvent e) {
    }

    public void editStarting(KDTEditEvent e) {
    }

    public void editStopped(KDTEditEvent e) {
        try {
            Object source = e.getSource();
            Object oldValue = e.getOldValue();
            Object newValue = e.getValue();
            if (oldValue == null && newValue != null || oldValue != null && !oldValue.equals(newValue)) {
                if (this.kdtEntry.equals(source)) {
                    this.kdtEntry_Changed(e);
                } else if (this.kdtDriverEntry.equals(source)) {
                    this.kdtDriverEntry_Changed(e);
                }
            }
        }
        catch (Exception e1) {
            this.handUIException(e1);
        }
    }

    public void editStopping(KDTEditEvent e) {
    }

    public void editValueChanged(KDTEditEvent e) {
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        block30: {
            int i;
            Object[] objs;
            Object source;
            block29: {
                int i2;
                Object[] objs2;
                source = e.getSource();
                if (!source.equals(this.prmtCar)) break block29;
                int beginRow = this.kdtEntry.getSelectManager().get().getBeginRow();
                Object obj = this.prmtCar.getValue();
                if (obj == null) {
                    this.kdtEntry.getCell(beginRow, "number").setValue(null);
                    this.kdtEntry.getCell(beginRow, "name").setValue(null);
                    this.kdtEntry.getCell(beginRow, TB_TYPE).setValue(null);
                    this.kdtEntry.getCell(beginRow, TB_WEIGHT).setValue(null);
                    this.kdtEntry.getCell(beginRow, TB_VOLUME).setValue(null);
                    this.kdtEntry.getCell(beginRow, TB_DRIVER).setValue(null);
                    this.kdtEntry.getCell(beginRow, "note").setValue(null);
                    return;
                }
                CarCollection entrys = new CarCollection();
                if (obj instanceof CarInfo) {
                    entrys.add((CarInfo)obj);
                } else if (obj instanceof Object[]) {
                    objs2 = (Object[])obj;
                    for (i2 = 0; i2 < objs2.length; ++i2) {
                        if (objs2[i2] == null) continue;
                        entrys.add((CarInfo)objs2[i2]);
                    }
                } else if (obj instanceof CarInfo[]) {
                    objs2 = (CarInfo[])obj;
                    for (i2 = 0; i2 < objs2.length; ++i2) {
                        if (objs2[i2] == null) continue;
                        entrys.add((CarInfo)objs2[i2]);
                    }
                } else {
                    return;
                }
                if (entrys.size() == 0) {
                    return;
                }
                int n = entrys.size();
                for (int i3 = 0; i3 < n; ++i3) {
                    if (entrys.get(i3).getId() == null) continue;
                    CarInfo info = entrys.get(i3);
                    if (i3 > 0) {
                        this.kdtEntry.addRow(beginRow + i3);
                    }
                    CarrierCarEntryInfo carEntryInfo = new CarrierCarEntryInfo();
                    carEntryInfo.setCar(info);
                    IRow currentRow = this.kdtEntry.getRow(beginRow + i3);
                    CarrierCarEntryInfo oldCarEntryInfo = (CarrierCarEntryInfo)currentRow.getUserObject();
                    if (oldCarEntryInfo != null && this.editData.getEntry().contains(oldCarEntryInfo)) {
                        this.editData.getEntry().remove(oldCarEntryInfo);
                    }
                    this.loadLineFields(this.kdtEntry, currentRow, (IObjectValue)carEntryInfo);
                    String driverName = null;
                    DriverInfo driverInfo = info.getDriver();
                    if (driverInfo != null) {
                        try {
                            driverInfo = DriverFactory.getRemoteInstance().getDriverInfo((IObjectPK)new ObjectUuidPK(driverInfo.getId().toString()));
                        }
                        catch (Exception ex) {
                            this.handUIException(ex);
                        }
                        driverName = driverInfo.getName();
                    }
                    this.kdtEntry.getCell(beginRow + i3, TB_DRIVER).setValue((Object)driverName);
                }
                break block30;
            }
            if (!source.equals(this.prmtDriver)) break block30;
            int beginRow = this.kdtDriverEntry.getSelectManager().get().getBeginRow();
            Object obj = this.prmtDriver.getValue();
            if (obj == null) {
                this.kdtDriverEntry.getCell(beginRow, "number").setValue(null);
                this.kdtDriverEntry.getCell(beginRow, "name").setValue(null);
                this.kdtDriverEntry.getCell(beginRow, TB_DR_CELL).setValue(null);
                this.kdtDriverEntry.getCell(beginRow, TB_DR_PHONE).setValue(null);
                this.kdtDriverEntry.getCell(beginRow, TB_DR_IDCARD).setValue(null);
                this.kdtDriverEntry.getCell(beginRow, TB_DR_ADDRESS).setValue(null);
                this.kdtDriverEntry.getCell(beginRow, "note").setValue(null);
                return;
            }
            DriverCollection entrys = new DriverCollection();
            if (obj instanceof DriverInfo) {
                entrys.add((DriverInfo)obj);
            } else if (obj instanceof Object[]) {
                objs = (Object[])obj;
                for (i = 0; i < objs.length; ++i) {
                    if (objs[i] == null) continue;
                    entrys.add((DriverInfo)objs[i]);
                }
            } else if (obj instanceof DriverInfo[]) {
                objs = (DriverInfo[])obj;
                for (i = 0; i < objs.length; ++i) {
                    if (objs[i] == null) continue;
                    entrys.add((DriverInfo)objs[i]);
                }
            } else {
                return;
            }
            if (entrys.size() == 0) {
                return;
            }
            int n = entrys.size();
            for (int i4 = 0; i4 < n; ++i4) {
                if (entrys.get(i4).getId() == null) continue;
                DriverInfo info = entrys.get(i4);
                if (i4 > 0) {
                    this.kdtDriverEntry.addRow(beginRow + i4);
                }
                CarrierDriverEntryInfo carEntryInfo = new CarrierDriverEntryInfo();
                carEntryInfo.setDriver(info);
                IRow currentRow = this.kdtDriverEntry.getRow(beginRow + i4);
                CarrierDriverEntryInfo oldCarEntryInfo = (CarrierDriverEntryInfo)currentRow.getUserObject();
                if (oldCarEntryInfo != null && this.editData.getDriverEntry().contains(oldCarEntryInfo)) {
                    this.editData.getDriverEntry().remove(oldCarEntryInfo);
                }
                this.loadLineFields(this.kdtDriverEntry, currentRow, (IObjectValue)carEntryInfo);
            }
        }
    }

    public void dataChanged(DataChangeEvent e) {
        Object source = e.getSource();
        if (e.getOldValue() != null && e.getOldValue().equals(e.getNewValue())) {
            return;
        }
        if (source.equals(this.prmtTransport)) {
            this.prmtSupplier.setValue(null);
            this.setSupplier();
        }
    }

    private void setSupplier() {
        String cu = null;
        TransportOrgUnitInfo transportOrg = null;
        if (this.prmtTransport.getValue() != null && (transportOrg = (TransportOrgUnitInfo)this.prmtTransport.getData()).getCU() != null) {
            cu = transportOrg.getCU().getId().toString();
        }
        if (cu == null) {
            return;
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT FDataBaseDID FROM ").append("t_bd_databasedassign").append(" WHERE ");
        sql.append("FBOSObjectType = '").append("37C67DFC").append("' ").append(" AND ");
        sql.append("FAssignCUID = '").append(cu.toString()).append("' ");
        sql.append(" union all(");
        sql.append("select fid from ").append("T_BD_Supplier");
        sql.append(" where fcontrolunitid ='").append(cu.toString()).append("'");
        sql.append(")");
        filterInfo.getFilterItems().add(new FilterItemInfo("supplier.id", (Object)sql.toString(), CompareType.INNER));
        viewInfo.setFilter(filterInfo);
        this.prmtSupplier.setEntityViewInfo(viewInfo);
    }
}

