/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.dt.client;

import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.StringUtils;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.commonquery.CustomerParams;
import com.kingdee.eas.base.commonquery.QueryPanelCollection;
import com.kingdee.eas.base.commonquery.QueryPanelInfo;
import com.kingdee.eas.base.commonquery.QuerySolutionInfo;
import com.kingdee.eas.base.commonquery.XMLBean;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.CustomerQueryPanel;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.TransportOrgUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.FrameWorkUtils;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.scm.common.client.SCMGroupClientUtils;
import com.kingdee.eas.scm.common.util.PrecisionUtil;
import com.kingdee.eas.scm.im.dt.CarrierFactory;
import com.kingdee.eas.scm.im.dt.client.AbstractCarrierListUI;
import com.kingdee.eas.scm.im.dt.client.CarrierEditUI;
import com.kingdee.eas.scm.im.dt.client.CarrierFilterUI;
import com.kingdee.eas.scm.im.dt.util.DtUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class CarrierListUI
extends AbstractCarrierListUI {
    private static final Logger logger = CoreUIObject.getLogger(CarrierListUI.class);
    private static final String[] mergeCols = new String[]{"number", "transport.name", "supplier.name"};
    private CarrierFilterUI filterUI = null;
    private CommonQueryDialog dialog = null;
    private static final String TB_WEIGHT = "car.weight";
    private static final String TB_VOLUME = "car.volume";
    public static final String UI_RESOURCE = "com.kingdee.eas.scm.im.dt.client.JhResource";

    protected ICoreBase getBizInterface() throws Exception {
        return CarrierFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext());
    }

    protected String getEditUIName() {
        return CarrierEditUI.class.getName();
    }

    protected String getKeyFieldName() {
        return "id";
    }

    protected String getEditUIModal() {
        return "com.kingdee.eas.base.uiframe.client.UIModelDialogFactory";
    }

    protected String[] getCountQueryFields() {
        return new String[]{"id"};
    }

    protected boolean initDefaultFilter() {
        return true;
    }

    private void setMergeColumn() {
        String[] mergeColumnKeys = mergeCols;
        if (mergeColumnKeys != null && mergeColumnKeys.length > 0) {
            this.tblMain.checkParsed();
            this.tblMain.getGroupManager().setGroup(true);
            for (int i = 0; i < mergeColumnKeys.length; ++i) {
                this.tblMain.getColumn(mergeColumnKeys[i]).setGroup(true);
                this.tblMain.getColumn(mergeColumnKeys[i]).setMergeable(true);
            }
        }
    }

    protected void beforeExcutQuery(EntityViewInfo ev) {
        if (ev == null) {
            return;
        }
        FilterInfo filter = ev.getFilter();
        if (filter == null) {
            filter = new FilterInfo();
        }
        String orgID = "-1";
        TransportOrgUnitInfo orgInfo = SysContext.getSysContext().getCurrentTransportUnit();
        if (orgInfo != null) {
            orgID = orgInfo.getId().toString();
        }
        filter.getFilterItems().add(new FilterItemInfo("transport.id", (Object)orgID));
        ev.setFilter(filter);
        super.beforeExcutQuery(ev);
    }

    public void onLoad() throws Exception {
        this.setMergeColumn();
        this.menuItemImportData.setVisible(false);
        super.onLoad();
        KDFormattedTextField txtQty = new KDFormattedTextField(1);
        KDTDefaultCellEditor editorQty = new KDTDefaultCellEditor((JTextField)txtQty);
        txtQty.setHorizontalAlignment(4);
        txtQty.setPrecision(4);
        txtQty.setSupportedEmpty(true);
        txtQty.setNegatived(false);
        DtUtils.setDefaultDecimalEditor(txtQty, editorQty, this.tblMain, TB_WEIGHT);
        DtUtils.setDefaultDecimalEditor(txtQty, editorQty, this.tblMain, TB_VOLUME);
        String formatString = PrecisionUtil.getFormatString((int)2);
        this.tblMain.getColumn(TB_WEIGHT).getStyleAttributes().setNumberFormat(formatString);
        formatString = PrecisionUtil.getFormatString((int)3);
        this.tblMain.getColumn(TB_VOLUME).getStyleAttributes().setNumberFormat(formatString);
    }

    protected CommonQueryDialog initCommonQueryDialog() {
        if (this.dialog != null) {
            return this.dialog;
        }
        this.dialog = super.initCommonQueryDialog();
        try {
            this.dialog.setShowFilter(true);
            this.dialog.setShowSorter(true);
            this.dialog.setHeight(424);
            this.dialog.setWidth(500);
            this.dialog.addUserPanel((KDPanel)this.getFilterUI());
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        return this.dialog;
    }

    protected CustomerQueryPanel getFilterUI() throws Exception {
        if (this.filterUI == null) {
            this.filterUI = new CarrierFilterUI();
        }
        return this.filterUI;
    }

    protected void Remove() throws Exception {
        CoreBaseInfo editData = this.getBizInterface().getValue((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)this.getSelectedKeyValue())));
        super.Remove();
        this.recycleNumberByOrg((IObjectValue)editData, "Transport", editData.getString("number"));
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.getEnum((String)"Transport");
    }

    protected void recycleNumberByOrg(IObjectValue editData, String orgType, String number) {
        if (!StringUtils.isEmpty((String)number)) {
            try {
                String companyID = null;
                ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getRemoteInstance();
                if (!StringUtils.isEmpty((String)orgType) && !"NONE".equalsIgnoreCase(orgType) && SysContext.getSysContext().getCurrentOrgUnit(OrgType.getEnum((String)orgType)) != null) {
                    companyID = SysContext.getSysContext().getCurrentOrgUnit(OrgType.getEnum((String)orgType)).getString("id");
                } else if (SysContext.getSysContext().getCurrentOrgUnit() != null) {
                    companyID = SysContext.getSysContext().getCurrentOrgUnit().getString("id");
                }
                if (!StringUtils.isEmpty(companyID) && iCodingRuleManager.isExist(editData, companyID) && iCodingRuleManager.isUseIntermitNumber(editData, companyID)) {
                    iCodingRuleManager.recycleNumber(editData, companyID, number);
                }
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        }
    }

    protected IObjectPK getOrgPK(ItemAction action) {
        IObjectPK pk = this.getOrgPK();
        if (pk != null) {
            return pk;
        }
        if (this.getMainOrgContext() != null && this.getMainOrgContext().get((Object)this.getMainBizOrgType()) != null && (pk = new ObjectStringPK(((OrgUnitInfo)this.getMainOrgContext().get((Object)this.getMainBizOrgType())).getId().toString())) != null) {
            return pk;
        }
        return super.getOrgPK(action);
    }

    public IObjectPK getOrgPK() {
        if (this.tblMain == null) {
            return null;
        }
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        if (selectRows.length > 0) {
            Object keyValue;
            int rowIndex = selectRows[0];
            IRow row = this.tblMain.getRow(rowIndex);
            if (row == null) {
                return null;
            }
            ICell cell = row.getCell("transport.id");
            if (cell == null) {
                MsgBox.showError((String)"TableSelectionHelper: the transport.id is not right.");
                SysUtil.abort();
            }
            if ((keyValue = cell.getValue()) != null) {
                return new ObjectStringPK(keyValue.toString());
            }
        }
        return null;
    }

    protected List getMainBizOrgs(QuerySolutionInfo solution) {
        ArrayList<String> list = new ArrayList<String>();
        if (solution != null) {
            OrgUnitInfo[] orgUnitInfos = this.getMainOrgFromSolution(solution);
            if (orgUnitInfos != null && orgUnitInfos.length >= 1) {
                this.getUIContext().put(this.getMainBizOrgType(), orgUnitInfos[0]);
                for (int i = 0; i < orgUnitInfos.length; ++i) {
                    if (orgUnitInfos[i] == null) continue;
                    list.add(orgUnitInfos[i].getId().toString());
                }
            } else {
                this.getUIContext().put(this.getMainBizOrgType(), null);
                if (this.getMainOrgContext() != null) {
                    FrameWorkUtils.setCurrentOrgUnit((Context)this.getMainOrgContext(), null);
                }
            }
        } else if (this.getUIContext().get(this.getMainBizOrgType()) != null) {
            list.add(((OrgUnitInfo)this.getUIContext().get(this.getMainBizOrgType())).getId().toString());
        }
        return list;
    }

    private OrgUnitInfo[] getMainOrgFromSolution(QuerySolutionInfo solution) {
        if (solution != null) {
            QueryPanelCollection queryPanelCollection = solution.getQueryPanelInfo();
            int size = queryPanelCollection.size();
            for (int i = 0; i < size; ++i) {
                String params;
                QueryPanelInfo queryPanelInfo = queryPanelCollection.get(i);
                if (queryPanelInfo.getPanelClassName() == null || queryPanelInfo.getPanelClassName().equalsIgnoreCase("com.kingdee.eas.base.commonquery.client.CommonFilterPanel") || queryPanelInfo.getPanelClassName().equalsIgnoreCase("com.kingdee.eas.base.commonquery.client.CommonSorterPanel") || (params = queryPanelInfo.getCustomerParams()) == null) continue;
                CustomerParams cp = new CustomerParams();
                try {
                    ArrayList al = XMLBean.TransStrToAL((String)params);
                    Iterator j = al.iterator();
                    XMLBean xb = null;
                    while (j.hasNext()) {
                        xb = (XMLBean)j.next();
                        cp.addCustomerParam(xb.getName(), xb.getValue());
                    }
                    String orgs = cp.getCustomerParam("transport.id");
                    if (orgs != null) {
                        return SCMGroupClientUtils.getOrgUnitInfos((String)orgs);
                    }
                    continue;
                }
                catch (Exception e) {
                    logger.error((Object)e);
                }
            }
        }
        return null;
    }

    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrint_actionPerformed(e);
        IObjectPK pk = LogUtil.beginLog(null, (String)"1", (BOSObjectType)new BOSObjectType("27126401"), null, (String)EASResource.getString((String)UI_RESOURCE, (String)"carrier"), (String)"carrier_print");
        LogUtil.afterLog(null, (IObjectPK)pk);
    }

    public void actionPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrintPreview_actionPerformed(e);
        IObjectPK pk = LogUtil.beginLog(null, (String)"1", (BOSObjectType)new BOSObjectType("27126401"), null, (String)EASResource.getString((String)UI_RESOURCE, (String)"carrier"), (String)"carrier_print");
        LogUtil.afterLog(null, (IObjectPK)pk);
    }
}

