/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.dt.client;

import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.extendcontrols.ext.CommonF7KDTableListener;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.mm.common.client.UIHelper;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.client.ISCMBillStatusControl;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.client.SCMCommonF7KDTableListener;
import com.kingdee.eas.scm.common.filter.CompositeFilterElement;
import com.kingdee.eas.scm.common.filter.FilterElement;
import com.kingdee.eas.scm.common.filter.RangeFilterElement;
import com.kingdee.eas.scm.common.filter.SingleFilterElement;
import com.kingdee.eas.scm.common.util.SCMQueryFormat;
import com.kingdee.eas.scm.common.verify.VerifyItem;
import com.kingdee.eas.scm.common.verify.VerifyType;
import com.kingdee.eas.scm.im.dt.DistributionTypeEnum;
import com.kingdee.eas.scm.im.dt.TransportTypeEnum;
import com.kingdee.eas.scm.im.dt.client.AbstractCarryBillFilterUI;
import com.kingdee.eas.scm.im.dt.util.DtUtils;
import com.kingdee.eas.scm.im.dt.util.client.CarryBillClientUtils;
import java.awt.Component;
import org.apache.log4j.Logger;

public class CarryBillFilterUI
extends AbstractCarryBillFilterUI
implements ISCMBillStatusControl {
    private static final Logger logger = CoreUIObject.getLogger(CarryBillFilterUI.class);

    public CarryBillFilterUI() throws Exception {
        this.getElementsInfo();
    }

    private void getElementsInfo() {
        CompositeFilterElement elements = new CompositeFilterElement(0);
        elements.add((FilterElement)new RangeFilterElement("number", (Component)this.prmtNumberFrom, (Component)this.prmtNumberTo));
        CompositeFilterElement dateElements = new CompositeFilterElement(0);
        dateElements.add((FilterElement)new RangeFilterElement("bizDate", (Component)this.pkBizDateFrom, (Component)this.pkBizDateTo));
        dateElements.addVerifyItem(new VerifyItem(VerifyType.LESS_EQUAL_TYPE, SCMClientUtils.getResource((String)"CompareDate")));
        elements.add((FilterElement)dateElements);
        elements.add((FilterElement)new SingleFilterElement("distributionType", (Component)this.cbxDistributionType, (Object)DistributionTypeEnum.isNull));
        SingleFilterElement mainOrgElement = new SingleFilterElement("transportOrgUnit.number", (Component)this.prmtTransportOrgUnit);
        mainOrgElement.addVerifyItem(new VerifyItem(VerifyType.REQUIRED_TYPE, CarryBillClientUtils.getResource("transportOrgUnitCantNull")));
        elements.add((FilterElement)mainOrgElement);
        elements.add((FilterElement)new SingleFilterElement("sendLine.number", (Component)this.prmtCarryLine));
        elements.add((FilterElement)new SingleFilterElement("mainCarrier.number", (Component)this.prmtCarrier));
        elements.add((FilterElement)new SingleFilterElement("transportType", (Component)this.cbxTransportType, (Object)TransportTypeEnum.isNull));
        elements.add((FilterElement)new RangeFilterElement("sourceBillType.number", (Component)this.prmtSourceBillTypeFrom, (Component)this.prmtSourceBillTypeTo));
        elements.add((FilterElement)new RangeFilterElement("entry.sourceBillNumber", (Component)this.txtSourceNumberFrom, (Component)this.txtSourceNumberTo));
        elements.add((FilterElement)new RangeFilterElement("material.number", (Component)this.prmtMaterialFrom, (Component)this.prmtMaterialTo));
        elements.add((FilterElement)new SingleFilterElement("consignor.number", (Component)this.prmtConsignor));
        elements.add((FilterElement)new SingleFilterElement("sendStorage.number", (Component)this.prmtSendStorage));
        elements.add((FilterElement)new SingleFilterElement("consignee.number", (Component)this.prmtConsignee));
        elements.add((FilterElement)new SingleFilterElement("receiveStorage.number", (Component)this.prmtReceiveStorage));
        elements.add((FilterElement)new SingleFilterElement("baseStatus", (Component)this.cbxBaseStatus, (Object)BillBaseStatusEnum.NULL));
        this.getFilterManager().setElement((FilterElement)elements);
        this.getFilterManager().setMainOrgElement((FilterElement)mainOrgElement, "transportOrgUnit.id");
        this.setBizSupplierF7(this.prmtCarrier, null);
        this.setBizMaterialF7(this.prmtMaterialFrom, false, null);
        this.setBizMaterialF7(this.prmtMaterialTo, false, null);
        this.setNeedMainOrgF7s(new KDBizPromptBox[]{this.prmtCarrier, this.prmtMaterialFrom, this.prmtMaterialTo});
        UIHelper.registerProjectF7ForFilter((KDBizPromptBox)this.getMainBizOrgF7(), (KDBizPromptBox)this.prmtProjectNumFrom);
        UIHelper.registerProjectF7ForFilter((KDBizPromptBox)this.getMainBizOrgF7(), (KDBizPromptBox)this.prmtProjectNumTo);
        elements.add((FilterElement)new RangeFilterElement("project.number", (Component)this.prmtProjectNumFrom, (Component)this.prmtProjectNumTo));
        UIHelper.registerTrackNumberF7ForFilter((KDBizPromptBox)this.getMainBizOrgF7(), (KDBizPromptBox)this.prmtTrackNumFrom);
        UIHelper.registerTrackNumberF7ForFilter((KDBizPromptBox)this.getMainBizOrgF7(), (KDBizPromptBox)this.prmtTrackNumTo);
        elements.add((FilterElement)new RangeFilterElement("trackNumber.number", (Component)this.prmtTrackNumFrom, (Component)this.prmtTrackNumTo));
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.setF7Filter();
        this.setDefaultValue();
        if (this.getMainBizOrgF7().getText() != null) {
            this.mainOrgChanged();
        }
    }

    public KDBizPromptBox getMainBizOrgF7() {
        return this.prmtTransportOrgUnit;
    }

    protected String getViewPermission() {
        return "carryBill_view";
    }

    private void setF7Filter() throws Exception {
        EntityViewInfo viewNumber = DtUtils.getBizTransportFilter();
        this.prmtNumberFrom.setEntityViewInfo(viewNumber);
        this.prmtNumberTo.setEntityViewInfo(viewNumber);
        this.prmtNumberFrom.addCommonF7KDTableListener((CommonF7KDTableListener)new SCMCommonF7KDTableListener("baseStatus"));
        this.prmtNumberTo.addCommonF7KDTableListener((CommonF7KDTableListener)new SCMCommonF7KDTableListener("baseStatus"));
        this.setBillNumberF7s(new KDBizPromptBox[]{this.prmtNumberFrom, this.prmtNumberTo});
        this.prmtReceiveStorage.setEnabledMultiSelection(true);
        this.prmtSendStorage.setEnabledMultiSelection(true);
        this.prmtConsignee.setEnabledMultiSelection(true);
        this.prmtConsignor.setEnabledMultiSelection(true);
        this.setStorageFilter(this.prmtReceiveStorage);
        this.setStorageFilter(this.prmtSendStorage);
        this.prmtConsignee.setFilterInfoProducer(DtUtils.getNoCUFilterProducer());
        this.prmtConsignor.setFilterInfoProducer(DtUtils.getNoCUFilterProducer());
    }

    protected void setDefaultValue() {
        SCMQueryFormat.formatStartTime((KDDatePicker)this.pkBizDateFrom);
        SCMQueryFormat.formatEndTime((KDDatePicker)this.pkBizDateTo);
        SCMQueryFormat.formatBillStatus((ISCMBillStatusControl)this, (KDComboBox)this.cbxBaseStatus);
    }

    private void setStorageFilter(KDBizPromptBox PrmtStorage) {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("isBizUnit", (Object)new Integer(1), CompareType.EQUALS));
        view.setFilter(filterInfo);
        PrmtStorage.setEntityViewInfo(view);
    }
}

