/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.dt.client;

import com.kingdee.bos.appframework.databinding.ComponentProperty;
import com.kingdee.bos.appframework.databinding.DataBinder;
import com.kingdee.bos.appframework.databinding.DataComponentMap;
import com.kingdee.bos.appframework.databinding.Field;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.IKDTextComponent;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.bot.BOTMappingFactory;
import com.kingdee.bos.metadata.bot.BOTMappingInfo;
import com.kingdee.bos.metadata.bot.BOTRelationInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.org.TransportOrgUnitInfo;
import com.kingdee.eas.scm.common.ISCMBotpFacade;
import com.kingdee.eas.scm.common.SCMBotpFacadeFactory;
import com.kingdee.eas.scm.common.SCMFetchDataCondition;
import com.kingdee.eas.scm.common.botputils.SCMBotpUtils;
import com.kingdee.eas.scm.common.botputils.client.SCMBotpClientUtils;
import com.kingdee.eas.scm.common.client.SCMBillEditUI;
import com.kingdee.eas.scm.im.dt.client.AbstractDtBillEditUI;
import com.kingdee.eas.scm.im.dt.util.DtUtils;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class DtBillEditUI
extends AbstractDtBillEditUI {
    private static final Logger logger = CoreUIObject.getLogger(DtBillEditUI.class);
    protected TransportOrgUnitInfo tou = null;
    protected CompanyOrgUnitInfo touTOcou = null;
    protected CompanyOrgUnitInfo cou = null;
    protected List canList = null;
    protected List cannotList = null;
    protected Map headFieldsIsLock = new LinkedHashMap();
    protected Map entryFieldsIsLock = new LinkedHashMap();

    public void onLoad() throws Exception {
        this.getDetailTable().checkParsed();
        this.initHeadBeforeOnLoad();
        this.initEntryBeforeOnLoad();
        this.setHeadFieldsIsLock(this.headFieldsIsLock);
        this.setEntryFieldsIsLock(this.entryFieldsIsLock);
        super.onLoad();
        this.actionUnAudit.setVisible(true);
        this.btnUnAudit.setVisible(true);
        this.menuItemUnAudit.setVisible(true);
        this.actionMaterialView.setEnabled(false);
        this.btnMaterialView.setVisible(false);
        this.menuItemMaterialView.setVisible(false);
        this.actionQueryByMaterial.setEnabled(false);
        this.btnQueryByMaterial.setVisible(false);
        this.menuItemQueryByMaterial.setVisible(false);
        this.actionQueryGeneralInventory.setEnabled(false);
        this.btnQueryGeneralInventory.setVisible(false);
        this.menuItemQueryGeneralInventory.setVisible(false);
        this.workbtnBizProcess.setVisible(true);
        this.menuSubmitOption.setVisible(true);
        this.chkMenuItemSubmitAndAddNew.setVisible(true);
    }

    public Map getHeadFieldsIsLock() {
        return this.headFieldsIsLock;
    }

    public void setHeadFieldsIsLock(Map headFieldsIsLock) {
        DataComponentMap dcMap = this.dataBinder.getDataComponentMap();
        ArrayList headerFields = dcMap.getHeaderFields();
        for (int i = 0; i < headerFields.size(); ++i) {
            Field field = (Field)headerFields.get(i);
            ComponentProperty cp = dcMap.getComponentProperty(field.toString());
            headFieldsIsLock.put(field, ((IKDTextComponent)cp.getComponent()).isEnabled());
        }
    }

    public Map getEntryFieldsIsLock() {
        return this.entryFieldsIsLock;
    }

    public void setEntryFieldsIsLock(Map entryFieldsIsLock) {
        KDTable table = this.getDetailTable();
        int size = table.getColumnCount();
        for (int i = 0; i < size; ++i) {
            entryFieldsIsLock.put(table.getColumn(i).getKey(), table.getColumn(i).getStyleAttributes().isLocked());
        }
    }

    protected void initHeadBeforeOnLoad() throws Exception {
    }

    protected void initEntryBeforeOnLoad() throws Exception {
    }

    protected void loadFieldsBefore() throws Exception {
        this.initFetchData();
        this.removeListeners();
    }

    protected void loadFieldsAfter() throws Exception {
        this.tou = this.editData.getTransportOrgUnit();
        this.cou = this.editData.getCompanyOrgUnit();
        if (this.touTOcou == null) {
            this.touTOcou = DtUtils.getCompanyInfo(null, this.tou);
        }
        if (this.cou == null) {
            this.cou = this.touTOcou;
        }
        for (int i = 0; i < ((IObjectCollection)this.editData.get("entry")).size(); ++i) {
            this.setColumnControl(i, true);
        }
        if (this.getDetailTable().getRowCount() == 0) {
            this.addLine(this.getDetailTable());
        }
        this.initBotpControl();
        this.syncOldData((IObjectValue)this.editData);
        this.addListeners();
    }

    protected void initBotpControl() throws Exception {
        if (!this.isBotpBill()) {
            SCMBotpClientUtils.setTableDefaultEditable((DataBinder)this.dataBinder, (KDTable)this.getDetailTable(), (Map)this.getHeadFieldsIsLock(), (Map)this.getEntryFieldsIsLock());
            if (this.tou != null) {
                this.setNumEditableWhenUnitChange(this.tou.getId().toString());
            }
            return;
        }
        if (this.getDetailTable().getColumn("material") != null) {
            // empty if block
        }
        String srcObjectID = this.editData.getSourceBillId();
        String destObjectID = this.editData.getId().toString();
        ISCMBotpFacade ibf = SCMBotpFacadeFactory.getRemoteInstance();
        BOTMappingInfo mapping = ibf.getBOTMappingInfo(srcObjectID, destObjectID);
        if (mapping == null && this.getMakeRelations() != null && this.getMakeRelations().size() > 0) {
            BOTRelationInfo relation = this.getMakeRelations().get(0);
            mapping = BOTMappingFactory.getRemoteInstance().getBOTMappingInfo((IObjectPK)new ObjectUuidPK(relation.getBOTMappingID()));
        }
        if (mapping != null) {
            this.canList = SCMBotpUtils.getBillPropertiesCanModify((BOTMappingInfo)mapping);
            this.cannotList = SCMBotpUtils.getBillPropertiesCannotModify((BOTMappingInfo)mapping);
            SCMBotpClientUtils.setEditableByList((SCMBillEditUI)this, (DataBinder)this.dataBinder, (List)this.cannotList, (List)this.canList);
        }
    }

    protected void storeFieldsBefore() throws Exception {
    }

    protected void storeFieldsAfter() throws Exception {
        IObjectCollection entry = (IObjectCollection)this.editData.get("entry");
        if (this.editData != null && entry != null) {
            for (int i = entry.size() - 1; i >= 0; --i) {
                if (entry.getObject(i).get("material") != null) continue;
            }
        }
        String remark = null;
        if (this.editData != null && entry != null) {
            for (int i = 0; i < entry.size(); ++i) {
                if (entry.getObject(i) == null || entry.getObject(i).get("remark") == null || (remark = entry.getObject(i).get("remark").toString()).length() < 255) continue;
                entry.getObject(i).put("remark", (Object)remark.substring(0, 255));
            }
        }
    }

    protected void removeListeners() {
    }

    protected void addListeners() {
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Transport;
    }

    protected void setColumnProperty(MaterialInfo materialInfo, int rowIndex, int colIndex, boolean isOnload) throws Exception {
        this.setColumnData(rowIndex, isOnload);
        this.setColumnControl(rowIndex, isOnload);
    }

    protected void setColumnData(int rowIndex, boolean isOnload) throws Exception {
    }

    protected void setColumnControl(int rowIndex, boolean isOnload) throws Exception {
    }

    protected SCMFetchDataCondition buildCondition() {
        SCMFetchDataCondition condition = new SCMFetchDataCondition();
        condition.setFetchMaterial(true);
        condition.setFetchID(true);
        condition.setFetchNumber(true);
        condition.setFetchName(true);
        condition.setFetchBaseUnit(true);
        condition.setFetchAssistUnit(true);
        condition.setFetchAsstAttrType(true);
        condition.setFetchPricePrecision(true);
        condition.setFetchUnitPrecision(true);
        condition.setFetchBaseUnitPrecision(true);
        condition.setFetchAsstUnitPrecision(true);
        IObjectCollection entry = (IObjectCollection)this.editData.get("entry");
        String[] materialPKs = new String[entry.size()];
        String[] unitPKs = new String[entry.size()];
        String[] baseUnitPKs = new String[entry.size()];
        String[] asstUnitPKs = new String[entry.size()];
        String[] storageOrgPKs = new String[entry.size()];
        HashSet<String> set = new HashSet<String>();
        for (int i = 0; i < entry.size(); ++i) {
            MeasureUnitInfo assisttUnit;
            MeasureUnitInfo baseUnit;
            MaterialInfo material = (MaterialInfo)entry.getObject(i).get("material");
            if (material != null) {
                materialPKs[i] = material.getId().toString();
                set.add(material.getId().toString());
            } else if (entry.size() == 1) {
                materialPKs = null;
            }
            StorageOrgUnitInfo sou = (StorageOrgUnitInfo)entry.getObject(i).get("sendStorage");
            if (sou != null) {
                storageOrgPKs[i] = sou.getId().toString();
                condition.setSou(sou);
                condition.setFetchMaterialInventory(true);
            } else if (entry.size() == 1) {
                storageOrgPKs = null;
            }
            MeasureUnitInfo unit = (MeasureUnitInfo)entry.getObject(i).get("unit");
            if (unit != null) {
                unitPKs[i] = unit.getId().toString();
            }
            if ((baseUnit = (MeasureUnitInfo)entry.getObject(i).get("baseUnit")) != null) {
                baseUnitPKs[i] = baseUnit.getId().toString();
            }
            if ((assisttUnit = (MeasureUnitInfo)entry.getObject(i).get("assistUnit")) == null) continue;
            asstUnitPKs[i] = assisttUnit.getId().toString();
        }
        condition.setMaterialPKs(materialPKs);
        condition.setUnitPKs(unitPKs);
        condition.setBaseUnitPKs(baseUnitPKs);
        condition.setAsstUnitPKs(asstUnitPKs);
        condition.setStorageOrgPKs(storageOrgPKs);
        condition.setSet(set);
        return condition;
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddNew_actionPerformed(e);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        super.actionEdit_actionPerformed(e);
        this.initBotpControl();
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        super.actionRemove_actionPerformed(e);
    }

    protected void afterMainOrgChanged(String arg0, String arg1) {
        super.afterMainOrgChanged(arg0, arg1);
    }
}

