/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.dt.client;

import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.ITransportOrgUnit;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.TransportOrgUnitFactory;
import com.kingdee.eas.basedata.org.TransportOrgUnitInfo;
import com.kingdee.eas.scm.common.client.ISCMBillStatusControl;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.filter.CompositeFilterElement;
import com.kingdee.eas.scm.common.filter.FilterElement;
import com.kingdee.eas.scm.common.filter.RangeFilterElement;
import com.kingdee.eas.scm.common.filter.SingleFilterElement;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.common.verify.VerifyItem;
import com.kingdee.eas.scm.common.verify.VerifyType;
import com.kingdee.eas.scm.im.dt.BillStatusEnum;
import com.kingdee.eas.scm.im.dt.CarrierInfo;
import com.kingdee.eas.scm.im.dt.CarryBillFacadeFactory;
import com.kingdee.eas.scm.im.dt.TransportTypeEnum;
import com.kingdee.eas.scm.im.dt.client.AbstractFeeLimitFilterUI;
import com.kingdee.eas.scm.im.dt.util.DtUtils;
import com.kingdee.eas.scm.im.dt.util.client.CarryBillClientUtils;
import com.kingdee.eas.util.client.ExceptionHandler;
import java.awt.Component;
import java.sql.Timestamp;
import java.util.Set;
import org.apache.log4j.Logger;

public class FeeLimitFilterUI
extends AbstractFeeLimitFilterUI
implements ISCMBillStatusControl {
    private static final Logger logger = CoreUIObject.getLogger(FeeLimitFilterUI.class);
    private DataChangeListener carrierFromListener;
    private DataChangeListener carrierToListener;

    public FeeLimitFilterUI() throws Exception {
        this.getElementsInfo();
    }

    private void getElementsInfo() {
        CompositeFilterElement elements = new CompositeFilterElement(0);
        elements.add((FilterElement)new RangeFilterElement("number", (Component)this.prmtFeeLimitFrom, (Component)this.prmtFeeLimitTo));
        SingleFilterElement transportOrgUnitElement = new SingleFilterElement("transportOrg.number", (Component)this.prmtTransportOrgUnit);
        transportOrgUnitElement.addVerifyItem(new VerifyItem(VerifyType.REQUIRED_TYPE, CarryBillClientUtils.getResource("transportOrgUnitCantNull")));
        elements.add((FilterElement)transportOrgUnitElement);
        RangeFilterElement beginDateElement = new RangeFilterElement("beginDate", (Component)this.pkBeginDateFrom, (Component)this.pkBeginDateTo);
        beginDateElement.addVerifyItem(new VerifyItem(VerifyType.LESS_EQUAL_TYPE, SCMClientUtils.getResource((String)"CompareDate")));
        beginDateElement.setDefaultValue((Object)new Timestamp[]{SCMUtils.getSCMQueryTime(null, (String)"startDate"), SCMUtils.getSCMQueryTime(null, (String)"endDate")});
        elements.add((FilterElement)beginDateElement);
        RangeFilterElement endDateElement = new RangeFilterElement("endDate", (Component)this.pkEndDateFrom, (Component)this.pkEndDateTo);
        endDateElement.addVerifyItem(new VerifyItem(VerifyType.LESS_EQUAL_TYPE, SCMClientUtils.getResource((String)"CompareDate")));
        elements.add((FilterElement)endDateElement);
        elements.add((FilterElement)new SingleFilterElement("status", (Component)this.comboStatus, (Object)BillStatusEnum.isNull));
        elements.add((FilterElement)new RangeFilterElement("feeItem.number", (Component)this.prmtFeeItemFrom, (Component)this.prmtFeeItemTo));
        elements.add((FilterElement)new RangeFilterElement("entry.carrier.number", (Component)this.prmtCarrierFrom, (Component)this.prmtCarrierTo));
        elements.add((FilterElement)new RangeFilterElement("deliveryLine.number", (Component)this.prmtDeliveryLineFrom, (Component)this.prmtDeliveryLineTo));
        elements.add((FilterElement)new SingleFilterElement("entry.transType", (Component)this.comboTransportType, (Object)TransportTypeEnum.isNull));
        this.getFilterManager().setElement((FilterElement)elements);
        this.getFilterManager().setMainOrgElement((FilterElement)transportOrgUnitElement, "transportOrg.id");
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.setDefaultValue();
        this.comboStatus.removeItem((Object)BillStatusEnum.newbill);
        if (this.getMainBizOrgF7().getText() != null) {
            this.mainOrgChanged();
        }
        this.setF7Filter();
        this.addListeners();
    }

    public KDBizPromptBox getMainBizOrgF7() {
        return this.prmtTransportOrgUnit;
    }

    protected String getViewPermission() {
        return "feeLimit_view";
    }

    private void setF7Filter() {
        EntityViewInfo viewInfo = this.getCarrierViewInfo();
        if (viewInfo != null) {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("*"));
            sic.add(new SelectorItemInfo("supplier.name"));
            sic.add(new SelectorItemInfo("supplier.number"));
            this.prmtCarrierFrom.setSelectorCollection(sic);
            this.prmtCarrierTo.setSelectorCollection(sic);
            this.prmtCarrierFrom.setEntityViewInfo(viewInfo);
            this.prmtCarrierTo.setEntityViewInfo(viewInfo);
        }
    }

    protected void setDefaultValue() {
    }

    private void addListeners() {
        if (this.carrierFromListener == null) {
            this.carrierFromListener = new DataChangeListener(){

                public void dataChanged(DataChangeEvent eventObj) {
                    FeeLimitFilterUI.this.setCarrier(FeeLimitFilterUI.this.prmtCarrierFrom);
                }
            };
        }
        if (this.carrierToListener == null) {
            this.carrierToListener = new DataChangeListener(){

                public void dataChanged(DataChangeEvent eventObj) {
                    FeeLimitFilterUI.this.setCarrier(FeeLimitFilterUI.this.prmtCarrierTo);
                }
            };
        }
        this.prmtCarrierFrom.addDataChangeListener(this.carrierFromListener);
        this.prmtCarrierTo.addDataChangeListener(this.carrierToListener);
    }

    private void removeListeners() {
        if (this.carrierFromListener != null) {
            this.prmtCarrierFrom.removeDataChangeListener(this.carrierFromListener);
        }
        if (this.prmtCarrierTo != null) {
            this.prmtCarrierTo.removeDataChangeListener(this.carrierToListener);
        }
    }

    private void setCarrier(KDBizPromptBox prmtCarrier) {
        CarrierInfo carrier = (CarrierInfo)prmtCarrier.getValue();
        if (carrier != null) {
            this.removeListeners();
            this.addListeners();
        }
    }

    private EntityViewInfo getCarrierViewInfo() {
        EntityViewInfo viewInfo;
        block5: {
            OrgUnitInfo tou = (OrgUnitInfo)this.prmtTransportOrgUnit.getValue();
            viewInfo = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            if (tou != null && tou.getId() != null) {
                try {
                    Set set = CarryBillFacadeFactory.getRemoteInstance().getCarriers(tou.getId().toString());
                    if (set.size() > 0) {
                        filter.getFilterItems().add(new FilterItemInfo("id in (SELECT fid FROM T_DT_Carrier where FTransportID = '" + tou.getId().toString() + "')"));
                        viewInfo.setFilter(filter);
                        break block5;
                    }
                    filter.getFilterItems().add(new FilterItemInfo("id", (Object)"111111111111111111111111111=", CompareType.EQUALS));
                    viewInfo.setFilter(filter);
                }
                catch (Exception e) {
                    ExceptionHandler.handle((Throwable)e);
                }
            } else {
                filter.getFilterItems().add(new FilterItemInfo("id", (Object)"111111111111111111111111111=", CompareType.EQUALS));
                viewInfo.setFilter(filter);
            }
        }
        return viewInfo;
    }

    public void mainOrgChanged(OrgUnitCollection mainOrgs) {
        super.mainOrgChanged(mainOrgs);
        this.prmtCarrierFrom.setValue(null);
        this.prmtCarrierTo.setValue(null);
        this.setF7Filter();
    }

    public void afterMainOrgChanged(String ids) {
        super.afterMainOrgChanged(ids);
        this.prmtFeeItemFrom.setValue(null);
        this.prmtFeeItemTo.setValue(null);
        TransportOrgUnitInfo tou = new TransportOrgUnitInfo();
        try {
            ITransportOrgUnit tof = TransportOrgUnitFactory.getRemoteInstance();
            BOSUuid uuid = BOSUuid.read((String)ids);
            ObjectUuidPK pk = new ObjectUuidPK(uuid);
            tou = tof.getTransportOrgUnitInfo((IObjectPK)pk);
            CompanyOrgUnitInfo touTOcou = DtUtils.getCompanyInfo(null, tou);
            DtUtils.setExpenseTypeFilter(this.prmtFeeItemFrom, (CoreUIObject)this, true, "FeeLimit", touTOcou, false);
            DtUtils.setExpenseTypeFilter(this.prmtFeeItemTo, (CoreUIObject)this, true, "FeeLimit", touTOcou, false);
            this.prmtFeeItemFrom.setDisplayFormat("$name$");
            this.prmtFeeItemTo.setDisplayFormat("$name$");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

