/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.dt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.appframework.databinding.DataBinder;
import com.kingdee.bos.ctrl.extendcontrols.BizDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.IDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.data.impl.BOSQueryDelegate;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.render.ObjectValueRender;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.print.IPrintActionListener;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.KDNoteHelper;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.bot.BOTMappingInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitFactory;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.TransportOrgUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.EntryBaseStatusEnum;
import com.kingdee.eas.scm.common.ISCMBotpFacade;
import com.kingdee.eas.scm.common.SCMBotpFacadeFactory;
import com.kingdee.eas.scm.common.SCMFetchDataCondition;
import com.kingdee.eas.scm.common.botputils.client.SCMBotpClientUtils;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.util.MultiDataSourceDataProviderProxy;
import com.kingdee.eas.scm.common.util.PrecisionUtil;
import com.kingdee.eas.scm.common.util.SCMCommonDataProvider;
import com.kingdee.eas.scm.common.util.SCMSlaveCommonDataProvider;
import com.kingdee.eas.scm.im.dt.CarryBillEntryInfo;
import com.kingdee.eas.scm.im.dt.CarryBillFactory;
import com.kingdee.eas.scm.im.dt.CarryBillInfo;
import com.kingdee.eas.scm.im.dt.DeliveryLineInfo;
import com.kingdee.eas.scm.im.dt.DistributionTypeEnum;
import com.kingdee.eas.scm.im.dt.LogisticsFeeAgent;
import com.kingdee.eas.scm.im.dt.LogisticsFeeEntryAgent;
import com.kingdee.eas.scm.im.dt.LogisticsFeeEntryInfo;
import com.kingdee.eas.scm.im.dt.LogisticsFeeFactory;
import com.kingdee.eas.scm.im.dt.LogisticsFeeInfo;
import com.kingdee.eas.scm.im.dt.TransportTypeEnum;
import com.kingdee.eas.scm.im.dt.client.AbstractLogisticsFeeEditUI;
import com.kingdee.eas.scm.im.dt.util.DtUtils;
import com.kingdee.eas.scm.im.dt.util.client.LogisticsFeeClientUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class LogisticsFeeEditUI
extends AbstractLogisticsFeeEditUI
implements KDTEditListener,
DataChangeListener {
    private static final Logger logger = CoreUIObject.getLogger(LogisticsFeeEditUI.class);
    KDBizPromptBox prmtMaterial = new KDBizPromptBox();
    KDBizPromptBox prmtEntryBalancer = new KDBizPromptBox();
    KDBizPromptBox prmtUnit = new KDBizPromptBox();
    KDBizPromptBox prmtDetailLine = new KDBizPromptBox();
    KDBizPromptBox prmtFeeItem = new KDBizPromptBox();
    private static final String TB_BALANCER = "balancer";
    private static final String TB_DETAILLINE = "detailLine";
    private static final String TB_DETAILBEGIN = "detailBegin";
    private static final String TB_DETAILEND = "detailEnd";
    private static final String TB_FEEITEM = "feeItem";
    private static final String TB_TRANSPORTTYPE = "transportType";
    private static final String TB_MATERIAL = "material";
    private static final String TB_MATERIALNAME = "materialName";
    private static final String TB_UNIT = "unit";
    private static final String TB_QTY = "qty";
    private static final String TB_BALANCEQTY = "balanceQty";
    private static final String TB_BASEUNIT = "baseUnit";
    private static final String TB_BASEQTY = "baseQty";
    private static final String TB_ASSISTUNIT = "assistUnit";
    private static final String TB_ASSISTQTY = "assistQty";
    private static final String TB_RATINGPRICE = "ratingPrice";
    private static final String TB_RATINGAMT = "ratingAmt";
    private static final String TB_BALANCEPRICE = "balancePrice";
    private static final String TB_BALANCEAMT = "balanceAmt";
    private static final String TB_TOTALAPQTY = "totalApQty";
    private static final String TB_TOTALAPAMT = "totalApAmt";
    private static final String TB_ASSOCIATEQTY = "associateQty";
    private static final String TB_ENTRYSTATUS = "entryStatus";
    private static final String[] TBS_QTY = new String[]{"qty", "balanceQty", "totalApQty"};
    private static final String[] TBS_BASEQTY = new String[]{"associateQty"};
    private static final String[] TBS_PRICE = new String[]{"ratingPrice", "balancePrice"};
    private static final String[] TBS_AMT = new String[]{"ratingAmt", "balanceAmt", "totalApAmt"};

    public LogisticsFeeEditUI() throws Exception {
        this.setEnabled(true);
        this.txtDescription.setMaxLength(255);
    }

    protected IObjectValue createNewData() {
        LogisticsFeeAgent info = null;
        try {
            info = LogisticsFeeAgent.create();
            this.tou = (TransportOrgUnitInfo)this.getDefaultMainBizOrg();
            this.touTOcou = DtUtils.getCompanyInfo(null, this.tou);
            info.setBillType(SCMClientUtils.getBillType((String)"emdfS9tk/UGnMuPbpL799kY+1VI="));
            info.setDistributionType(DistributionTypeEnum.SALE_TRANSPORTATION);
            Date now = SCMClientUtils.getServerDate2();
            UserInfo user = SysContext.getSysContext().getCurrentUserInfo();
            info.setCreator(user);
            info.setCreateTime(new Timestamp(now.getTime()));
            info.setBizDate(now);
            info.setTransportOrgUnit(this.tou);
            info.setCompanyOrgUnit(this.touTOcou);
            info.setBaseStatus(BillBaseStatusEnum.ADD);
            LogisticsFeeEntryInfo entry = (LogisticsFeeEntryInfo)this.createNewDetailData(this.kdtEntry);
            info.getEntry().add(entry);
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        return info;
    }

    protected IObjectValue createNewDetailData(KDTable table) {
        LogisticsFeeEntryAgent entry = null;
        try {
            entry = LogisticsFeeEntryAgent.create();
            entry.setTransportType(TransportTypeEnum.CAR);
            entry.setQty(DtUtils.ZERO);
            entry.setBalanceQty(DtUtils.ZERO);
            entry.setBaseQty(DtUtils.ZERO);
            entry.setRatingPrice(DtUtils.ZERO);
            entry.setRatingAmt(DtUtils.ZERO);
            entry.setBalancePrice(DtUtils.ZERO);
            entry.setBalanceAmt(DtUtils.ZERO);
            entry.setTotalApQty(DtUtils.ZERO);
            entry.setTotalApAmt(DtUtils.ZERO);
            entry.setAssociateQty(DtUtils.ZERO);
            entry.setBaseStatus(EntryBaseStatusEnum.ADD);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        return entry;
    }

    protected KDTable getDetailTable() {
        return this.kdtEntry;
    }

    public KDTextField getNumTextField() {
        return this.txtNumber;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return LogisticsFeeFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext());
    }

    @Override
    public void loadFields() {
        try {
            this.loadFieldsBefore();
            super.loadFields();
            this.loadFieldsAfter();
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    @Override
    protected void loadFieldsAfter() throws Exception {
        super.loadFieldsAfter();
        this.setFilterForCompany();
    }

    private void setFilterForCompany() throws Exception {
        String cbID;
        HashSet<String> couSet = new HashSet<String>();
        if (this.touTOcou != null) {
            couSet.add(this.touTOcou.getId().toString());
        }
        if (this.editData.getSourceBillType() != null && this.editData.getSourceBillType().getId().toString().equals("18b7FpLNSrmaD8V9SPcOhkY+1VI=") && !StringUtils.isEmpty((String)(cbID = this.editData.getSourceBillId()))) {
            String oql = "SELECT id, entry.id, entry.sendCompany, entry.receiveCompany WHERE id = '" + cbID + "'";
            CarryBillInfo cbInfo = CarryBillFactory.getRemoteInstance().getCarryBillInfo(oql);
            int n = cbInfo.getEntry().size();
            for (int i = 0; i < n; ++i) {
                CarryBillEntryInfo entry = cbInfo.getEntry().get(i);
                if (entry.getSendCompany() != null) {
                    couSet.add(entry.getSendCompany().getId().toString());
                }
                if (entry.getReceiveCompany() == null) continue;
                couSet.add(entry.getReceiveCompany().getId().toString());
            }
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("companyOrgUnit.id", couSet, CompareType.INCLUDE));
        view.setFilter(filter);
        this.prmtCompany.setEntityViewInfo(view);
    }

    @Override
    protected void loadFieldsBefore() throws Exception {
        super.loadFieldsBefore();
    }

    @Override
    public void onLoad() throws Exception {
        super.onLoad();
        this.btnPrint.setVisible(true);
        this.btnPrintPreview.setVisible(true);
        if (!this.isAutoNumber) {
            this.txtNumber.setEditable(true);
            this.txtNumber.setEnabled(true);
            this.txtNumber.setRequired(true);
            this.txtNumber.requestFocus();
        }
        this.txtDescription.setMaxLength(255);
        SCMClientUtils.setEntriesTableStrLength((KDTable)this.kdtEntry, (String[])new String[]{"entry.remark"}, (int)255);
        this.setMainOrgCtrl();
        this.actionCopyLine.setVisible(false);
        this.actionCopyLine.setEnabled(false);
    }

    public void onShow() throws Exception {
        super.onShow();
        this.setMainOrgCtrl();
    }

    protected void setMainOrgCtrl() throws Exception {
        if (!this.getOprtState().equals("ADDNEW") || this.isBotpBill()) {
            this.prmtTransportOrgUnit.setAccessAuthority(0);
            this.prmtTransportOrgUnit.setEnabled(false);
            this.prmtTransportOrgUnit.setEditable(false);
            this.prmtTransportOrgUnit.setRequired(false);
        }
    }

    @Override
    protected void initEntryBeforeOnLoad() throws Exception {
        super.initEntryBeforeOnLoad();
        KDFormattedTextField txtDecimal = new KDFormattedTextField(1);
        KDTDefaultCellEditor editorDecimal = new KDTDefaultCellEditor((JTextField)txtDecimal);
        KDFormattedTextField txtPriceDecimal = new KDFormattedTextField(1);
        KDTDefaultCellEditor editorPriceDecimal = new KDTDefaultCellEditor((JTextField)txtPriceDecimal);
        txtDecimal.setHorizontalAlignment(4);
        txtDecimal.setPrecision(4);
        txtDecimal.setSupportedEmpty(true);
        txtDecimal.setNegatived(false);
        int precision = 6;
        txtPriceDecimal.setHorizontalAlignment(4);
        txtPriceDecimal.setPrecision(precision);
        txtPriceDecimal.setSupportedEmpty(true);
        txtPriceDecimal.setNegatived(false);
        DtUtils.setDefaultDecimalEditor(txtDecimal, editorDecimal, this.kdtEntry, TBS_QTY);
        DtUtils.setDefaultDecimalEditor(txtDecimal, editorDecimal, this.kdtEntry, TBS_BASEQTY);
        LogisticsFeeEditUI.setDefaultDecimalEditor(txtPriceDecimal, editorPriceDecimal, this.kdtEntry, TBS_PRICE);
        DtUtils.setDefaultDecimalEditor(txtDecimal, editorDecimal, this.kdtEntry, TBS_AMT);
        ObjectValueRender avr = new ObjectValueRender();
        avr.setFormat((IDataFormat)new BizDataFormat("$number$"));
        DtUtils.setDefaultF7Editor(this.prmtMaterial, "com.kingdee.eas.basedata.master.material.app.F7MaterialQuery", this.kdtEntry, TB_MATERIAL);
        this.kdtEntry.getColumn(TB_MATERIAL).setRenderer((IBasicRender)avr);
        this.prmtMaterial.setEnabledMultiSelection(true);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("MATERIALGROUPSTANDARD.ID", (Object)"dR8lnQEPEADgAAWKwKgSxZeb4R8="));
        view.setFilter(filter);
        this.prmtMaterial.setEntityViewInfo(view);
        DtUtils.setDefaultF7Editor(this.prmtEntryBalancer, "com.kingdee.eas.basedata.master.cssp.app.F7CarrierQueryWithDefaultStandard", this.kdtEntry, TB_BALANCER);
        DtUtils.setDefaultF7Editor(this.prmtUnit, "com.kingdee.eas.basedata.master.material.app.F7MultiMeasureUnitQuery", this.kdtEntry, TB_UNIT);
        DtUtils.setDefaultF7Editor(this.prmtDetailLine, "com.kingdee.eas.scm.im.dt.app.DeliveryLineQuery", this.kdtEntry, TB_DETAILLINE);
        DtUtils.setDefaultF7Editor(this.prmtFeeItem, "com.kingdee.eas.cp.bc.app.ExpenseTypeQuery", this.kdtEntry, TB_FEEITEM);
        KDComboBox cbTranportType = new KDComboBox();
        cbTranportType.addItems(TransportTypeEnum.getEnumList().toArray());
        this.kdtEntry.getColumn(TB_TRANSPORTTYPE).setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)cbTranportType));
        KDComboBox cbEntryStatus = new KDComboBox();
        cbEntryStatus.addItems(EntryBaseStatusEnum.getEnumList().toArray());
        this.kdtEntry.getColumn(TB_ENTRYSTATUS).setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)cbEntryStatus));
        SCMClientUtils.setNecessColorInTable((KDTable)this.kdtEntry, (String)TB_BALANCER, (boolean)true);
    }

    @Override
    protected void initHeadBeforeOnLoad() throws Exception {
        super.initHeadBeforeOnLoad();
    }

    @Override
    public void storeFields() {
        try {
            this.storeFieldsBefore();
            super.storeFields();
            this.storeFieldsAfter();
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    @Override
    protected void storeFieldsAfter() throws Exception {
        IObjectCollection entry = (IObjectCollection)this.editData.get("entry");
        if (this.editData != null && entry != null) {
            for (int i = entry.size() - 1; i > 0; --i) {
                if (entry.getObject(i).get(TB_FEEITEM) != null) continue;
                entry.removeObject(i);
            }
        }
    }

    @Override
    protected void storeFieldsBefore() throws Exception {
        super.storeFieldsBefore();
    }

    protected void beforeStoreFields(ActionEvent e) throws Exception {
        KDTable table;
        Date bizDate;
        CompanyOrgUnitInfo companyOrgUnit;
        super.beforeStoreFields(e);
        if (e == null || e.getSource() == this.btnSave || e.getSource() == this.menuItemSave) {
            return;
        }
        TransportOrgUnitInfo transportOrgUnit = (TransportOrgUnitInfo)this.prmtTransportOrgUnit.getValue();
        if (transportOrgUnit == null) {
            MsgBox.showError((Component)((Object)this), (String)LogisticsFeeClientUtils.getResource("TransportOrgUnitCantNull"));
            this.prmtTransportOrgUnit.requestFocus();
            SysUtil.abort();
        }
        if ((companyOrgUnit = (CompanyOrgUnitInfo)this.prmtCompany.getValue()) == null) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.scm.im.IMAutoGenerateResource", (String)"5_LogisticsFeeEditUI"));
            this.prmtCompany.requestFocus();
            SysUtil.abort();
        }
        if ((bizDate = (Date)this.pkBizDate.getValue()) == null) {
            MsgBox.showError((Component)((Object)this), (String)LogisticsFeeClientUtils.getResource("BizDateCantNull"));
            this.pkBizDate.requestFocus();
            SysUtil.abort();
        }
        if ((table = this.getDetailTable()).getRowCount() == 0) {
            MsgBox.showError((Component)((Object)this), (String)LogisticsFeeClientUtils.getResource("EntryCountMustPositive"));
            SysUtil.abort();
        }
        for (int i = 0; i < table.getRowCount(); ++i) {
            BigDecimal balanceQty;
            BigDecimal qty;
            MeasureUnitInfo unit;
            DeliveryLineInfo detailLine;
            SupplierInfo balancer = (SupplierInfo)table.getCell(i, TB_BALANCER).getValue();
            if (balancer == null) {
                MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.scm.im.IMAutoGenerateResource", (String)"6_LogisticsFeeEditUI"));
                table.getEditManager().editCellAt(i, table.getColumnIndex(TB_BALANCER));
                SysUtil.abort();
            }
            if ((detailLine = (DeliveryLineInfo)table.getCell(i, TB_DETAILLINE).getValue()) == null) {
                MsgBox.showError((Component)((Object)this), (String)LogisticsFeeClientUtils.getResource("DetailLineCantNull"));
                table.getEditManager().editCellAt(i, table.getColumnIndex(TB_DETAILLINE));
                SysUtil.abort();
            }
            if ((unit = (MeasureUnitInfo)table.getCell(i, TB_UNIT).getValue()) == null) {
                MsgBox.showError((Component)((Object)this), (String)LogisticsFeeClientUtils.getResource("UnitCantNull"));
                table.getEditManager().editCellAt(i, table.getColumnIndex(TB_UNIT));
                SysUtil.abort();
            }
            if ((qty = (BigDecimal)table.getCell(i, TB_QTY).getValue()) == null || qty.compareTo(DtUtils.ZERO) <= 0) {
                MsgBox.showError((Component)((Object)this), (String)LogisticsFeeClientUtils.getResource("QtyMustPositive"));
                table.getEditManager().editCellAt(i, table.getColumnIndex(TB_QTY));
                SysUtil.abort();
            }
            if ((balanceQty = (BigDecimal)table.getCell(i, TB_BALANCEQTY).getValue()) != null && balanceQty.compareTo(DtUtils.ZERO) > 0) continue;
            MsgBox.showError((Component)((Object)this), (String)LogisticsFeeClientUtils.getResource("BalanceQtyMustPositive"));
            table.getEditManager().editCellAt(i, table.getColumnIndex(TB_BALANCEQTY));
            SysUtil.abort();
        }
    }

    protected KDBizPromptBox getMainBizOrg() {
        return this.prmtTransportOrgUnit;
    }

    public KDBizPromptBox getMainOrgUnit() {
        return this.prmtTransportOrgUnit;
    }

    @Override
    protected OrgType getMainBizOrgType() {
        return OrgType.Transport;
    }

    protected String getPermissionItem(String status) {
        if ("ADDNEW".equals(status)) {
            return "logisticsFee_addnew";
        }
        return null;
    }

    protected void setFieldsNull(AbstractObjectValue newData) {
        super.setFieldsNull(newData);
        LogisticsFeeInfo info = (LogisticsFeeInfo)newData;
        for (int i = 0; i < info.getEntry().size(); ++i) {
            info.getEntry().get(i).setTotalApQty(DtUtils.ZERO);
            info.getEntry().get(i).setTotalApAmt(DtUtils.ZERO);
            info.getEntry().get(i).setAssociateQty(DtUtils.ZERO);
            info.getEntry().get(i).setBaseStatus(EntryBaseStatusEnum.ADD);
        }
    }

    public void editStarting(KDTEditEvent e) {
    }

    public void editStarted(KDTEditEvent e) {
    }

    public void editValueChanged(KDTEditEvent e) {
    }

    public void editStopping(KDTEditEvent e) {
    }

    public void editStopped(KDTEditEvent e) {
        try {
            this.tableValueChanged(e);
        }
        catch (Exception ex) {
            this.handUIException(ex);
        }
    }

    public void editCanceled(KDTEditEvent e) {
    }

    @Override
    protected void setColumnControl(int rowIndex, boolean isOnload) throws Exception {
        super.setColumnControl(rowIndex, isOnload);
        KDTable table = this.getDetailTable();
        int qtyPrecision = 4;
        int baseQtyPrecision = 4;
        int pricePrecision = 4;
        int amountPrecision = 4;
        if (this.touTOcou != null) {
            String oql = "SELECT id, number,name, baseCurrency.id, baseCurrency.precision WHERE id = '" + this.touTOcou.getId().toString() + "'";
            this.touTOcou = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo(oql);
            amountPrecision = this.touTOcou.getBaseCurrency().getPrecision();
        }
        DtUtils.changePrecision(this.kdtEntry, rowIndex, TBS_AMT, amountPrecision, false);
        MaterialInfo material = (MaterialInfo)table.getCell(rowIndex, TB_MATERIAL).getValue();
        if (material == null) {
            return;
        }
        MeasureUnitInfo unit = null;
        MeasureUnitInfo baseUnit = null;
        unit = (MeasureUnitInfo)table.getCell(rowIndex, TB_UNIT).getValue();
        baseUnit = material.getBaseUnit();
        if (unit != null) {
            if (this.fetchData.getUnitPrecision(material.getId().toString(), unit.getId().toString()) == null) {
                MultiMeasureUnitInfo mmuUnit = MultiMeasureUnitFactory.getRemoteInstance().getMultiUnit(material.getId().toString(), unit.getId().toString());
                this.fetchData.putUnitPrecision(material.getId().toString(), unit.getId().toString(), mmuUnit.getQtyPrecision());
                qtyPrecision = mmuUnit.getQtyPrecision();
            } else {
                qtyPrecision = this.fetchData.getUnitPrecision(material.getId().toString(), unit.getId().toString());
            }
        }
        DtUtils.changePrecision(this.kdtEntry, rowIndex, TBS_QTY, qtyPrecision, false);
        if (baseUnit != null) {
            if (this.fetchData.getUnitPrecision(material.getId().toString(), baseUnit.getId().toString()) == null) {
                MultiMeasureUnitInfo mmuBaseUnit = MultiMeasureUnitFactory.getRemoteInstance().getMultiUnit(material.getId().toString(), baseUnit.getId().toString());
                this.fetchData.putUnitPrecision(material.getId().toString(), baseUnit.getId().toString(), mmuBaseUnit.getQtyPrecision());
                baseQtyPrecision = mmuBaseUnit.getQtyPrecision();
            } else {
                baseQtyPrecision = this.fetchData.getUnitPrecision(material.getId().toString(), baseUnit.getId().toString());
            }
        }
        DtUtils.changePrecision(this.kdtEntry, rowIndex, TBS_BASEQTY, baseQtyPrecision, false);
        pricePrecision = 6;
        DtUtils.changePrecision(this.kdtEntry, rowIndex, TBS_PRICE, pricePrecision, false);
    }

    @Override
    protected void setColumnData(int rowIndex, boolean isOnload) throws Exception {
        super.setColumnData(rowIndex, isOnload);
    }

    private void tableValueChanged(KDTEditEvent e) throws Exception {
        BigDecimal balanceAmt;
        int scale;
        BigDecimal balancePrice;
        BigDecimal balanceQty;
        KDTable table = (KDTable)e.getSource();
        Object oldValue = e.getOldValue();
        Object newValue = e.getValue();
        if (oldValue == null && newValue == null || oldValue != null && oldValue.equals(newValue)) {
            return;
        }
        int selectRow = e.getRowIndex();
        int selectCol = e.getColIndex();
        String selectColName = table.getColumnKey(selectCol);
        if (TB_BALANCEQTY.equals(selectColName)) {
            balanceQty = (BigDecimal)table.getCell(selectRow, TB_BALANCEQTY).getValue();
            balanceQty = balanceQty == null ? DtUtils.ZERO : balanceQty;
            balancePrice = (BigDecimal)table.getCell(selectRow, TB_BALANCEPRICE).getValue();
            balancePrice = balancePrice == null ? DtUtils.ZERO : balancePrice;
            scale = DtUtils.getCellScale(table, selectRow, TB_BALANCEAMT);
            balanceAmt = balanceQty.multiply(balancePrice).setScale(scale, 4);
            table.getCell(selectRow, TB_BALANCEAMT).setValue((Object)balanceAmt);
            BigDecimal ratingPrice = (BigDecimal)table.getCell(selectRow, TB_RATINGPRICE).getValue();
            ratingPrice = ratingPrice == null ? DtUtils.ZERO : ratingPrice;
            scale = DtUtils.getCellScale(table, selectRow, TB_RATINGAMT);
            BigDecimal ratingAmt = balanceQty.multiply(ratingPrice).setScale(scale, 4);
            table.getCell(selectRow, TB_RATINGAMT).setValue((Object)ratingAmt);
        }
        if (TB_BALANCEPRICE.equals(selectColName)) {
            balanceQty = (BigDecimal)table.getCell(selectRow, TB_BALANCEQTY).getValue();
            balanceQty = balanceQty == null ? DtUtils.ZERO : balanceQty;
            balancePrice = (BigDecimal)table.getCell(selectRow, TB_BALANCEPRICE).getValue();
            balancePrice = balancePrice == null ? DtUtils.ZERO : balancePrice;
            scale = DtUtils.getCellScale(table, selectRow, TB_BALANCEAMT);
            balanceAmt = balanceQty.multiply(balancePrice).setScale(scale, 4);
            table.getCell(selectRow, TB_BALANCEAMT).setValue((Object)balanceAmt);
        }
        if (TB_BALANCEAMT.equals(selectColName)) {
            balanceQty = (BigDecimal)table.getCell(selectRow, TB_BALANCEQTY).getValue();
            if (balanceQty == null || balanceQty.compareTo(DtUtils.ZERO) == 0) {
                return;
            }
            BigDecimal balanceAmt2 = (BigDecimal)table.getCell(selectRow, TB_BALANCEAMT).getValue();
            balanceAmt2 = balanceAmt2 == null ? DtUtils.ZERO : balanceAmt2;
            scale = DtUtils.getCellScale(table, selectRow, TB_BALANCEPRICE);
            BigDecimal balancePrice2 = balanceAmt2.divide(balanceQty, scale, 4);
            table.getCell(selectRow, TB_BALANCEPRICE).setValue((Object)balancePrice2);
        }
    }

    @Override
    protected SCMFetchDataCondition buildCondition() {
        return null;
    }

    @Override
    protected void addListeners() {
        super.addListeners();
        this.prmtTransportOrgUnit.addDataChangeListener((DataChangeListener)this);
        this.kdtEntry.addKDTEditListener((KDTEditListener)this);
    }

    @Override
    protected void removeListeners() {
        super.removeListeners();
        this.prmtTransportOrgUnit.removeDataChangeListener((DataChangeListener)this);
        this.kdtEntry.removeKDTEditListener((KDTEditListener)this);
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add("*");
        return sic;
    }

    protected String getSCMHMDListUI() {
        return "com.kingdee.eas.scm.im.dt.client.CarryBillFeeListUI";
    }

    public void dataChanged(DataChangeEvent e) {
        Object source = e.getSource();
        if (e.getOldValue() != null && e.getOldValue().equals(e.getNewValue())) {
            return;
        }
        if (source.equals(this.prmtTransportOrgUnit)) {
            this.touTOcou = DtUtils.getCompanyInfo(null, (TransportOrgUnitInfo)e.getNewValue());
            this.prmtCompany.setValue(null);
            try {
                this.setFilterForCompany();
            }
            catch (Exception exc) {
                this.handleException(exc);
            }
        }
    }

    @Override
    protected void initBotpControl() throws Exception {
        SCMBotpClientUtils.setTableDefaultEditable((DataBinder)this.dataBinder, (KDTable)this.getDetailTable(), (Map)this.getHeadFieldsIsLock(), (Map)this.getEntryFieldsIsLock());
        super.initBotpControl();
        if (!this.isBotpBill()) {
            int columeCount = this.kdtEntry.getColumnCount();
            for (int i = 0; i < columeCount; ++i) {
                this.kdtEntry.getColumn(i).getStyleAttributes().setLocked(true);
            }
            return;
        }
        this.kdtEntry.getColumn("entry.remark").getStyleAttributes().setLocked(false);
        this.kdtEntry.getColumn(TB_BALANCEQTY).getStyleAttributes().setLocked(false);
        this.kdtEntry.getColumn(TB_BALANCEPRICE).getStyleAttributes().setLocked(false);
        this.kdtEntry.getColumn(TB_BALANCEAMT).getStyleAttributes().setLocked(false);
        for (int i = 0; i < this.kdtEntry.getRowCount(); ++i) {
            if (this.kdtEntry.getCell(i, TB_BALANCER).getValue() != null) continue;
            this.kdtEntry.getCell(i, TB_BALANCER).getStyleAttributes().setLocked(false);
        }
        if (this.editData.getId() == null) {
            return;
        }
        String destObjectID = this.editData.getId().toString();
        String srcObjectID = this.editData.getSourceBillId();
        ISCMBotpFacade ibf = SCMBotpFacadeFactory.getRemoteInstance();
        BOTMappingInfo mapping = ibf.getBOTMappingInfo(srcObjectID, destObjectID);
        if (mapping == null) {
            this.comboDistributionType.setEnabled(false);
            this.kdtEntry.getColumn(TB_DETAILLINE).getStyleAttributes().setLocked(true);
            this.kdtEntry.getColumn(TB_FEEITEM).getStyleAttributes().setLocked(true);
            this.kdtEntry.getColumn(TB_TRANSPORTTYPE).getStyleAttributes().setLocked(true);
            this.kdtEntry.getColumn(TB_MATERIAL).getStyleAttributes().setLocked(true);
            this.kdtEntry.getColumn(TB_UNIT).getStyleAttributes().setLocked(true);
            this.kdtEntry.getColumn(TB_RATINGPRICE).getStyleAttributes().setLocked(true);
            this.kdtEntry.getColumn(TB_RATINGAMT).getStyleAttributes().setLocked(true);
        }
        this.setMainOrgCtrl();
    }

    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        super.actionSave_actionPerformed(e);
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        super.actionSubmit_actionPerformed(e);
    }

    protected void setTableToSumField() {
        this.setTableToSumField(this.kdtEntry, this.getSumColNames(this.kdtEntry.getName()));
    }

    protected String[] getSumColNames(String tableName) {
        if (tableName == null || tableName.length() == 0) {
            return null;
        }
        String[] str = null;
        if (tableName.equals(this.kdtEntry.getName())) {
            str = new String[]{TB_QTY, TB_BALANCEQTY, TB_RATINGAMT, TB_BALANCEAMT, TB_TOTALAPQTY, TB_TOTALAPAMT, TB_ASSOCIATEQTY};
        }
        return str;
    }

    protected void showBotpMenu() {
        super.showBotpMenu();
        this.workbtnBizProcess.setVisible(true);
    }

    protected IMetaDataPK getTDQueryPK() {
        return new MetaDataPK("com.kingdee.eas.scm.im.dt.LogisticsFeePrintQuery");
    }

    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrint_actionPerformed(e);
        this.invokePrintFunction(true);
    }

    public void actionPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrintPreview_actionPerformed(e);
        this.invokePrintFunction(false);
    }

    protected String getTDFileName() {
        return "/SCM/DT/LogisticsFee";
    }

    protected void invokePrintFunction(boolean isPrint) {
        ArrayList<String> idList = new ArrayList<String>();
        if (this.editData != null && !StringUtils.isEmpty((String)this.editData.getString("id"))) {
            idList.add(this.editData.getString("id"));
        }
        if (idList == null || idList.size() == 0 || this.getTDQueryPK() == null || this.getTDFileName() == null) {
            return;
        }
        MultiDataSourceDataProviderProxy data = new MultiDataSourceDataProviderProxy();
        this.setCustomerDataProvider(data, idList);
        SCMCommonDataProvider mainData = new SCMCommonDataProvider(idList, this.getTDQueryPK());
        data.put("MainQuery", (BOSQueryDelegate)mainData);
        SCMSlaveCommonDataProvider multiApproveViewQueryData = new SCMSlaveCommonDataProvider(idList, this.getMultiApproveViewQuery(), "billId");
        data.put("MultiApproveViewQuery", (BOSQueryDelegate)multiApproveViewQueryData);
        KDNoteHelper appHlp = new KDNoteHelper();
        appHlp.addKDNoteActionListener((IPrintActionListener)new PrintListner());
        if (isPrint) {
            appHlp.print(this.getTDFileName(), (Object)data, (Component)SwingUtilities.getWindowAncestor((Component)((Object)this)));
        } else {
            appHlp.printPreview(this.getTDFileName(), (Object)data, (Component)SwingUtilities.getWindowAncestor((Component)((Object)this)));
        }
    }

    protected void logPrint() {
        String operName = EASResource.getString((String)"com.kingdee.eas.scm.im.dt.client.JhResource", (String)"LogisticsFeePrint");
        IObjectPK pk = LogUtil.beginLog(null, (String)operName, (BOSObjectType)new LogisticsFeeInfo().getBOSType(), (IObjectPK)new ObjectUuidPK(this.editData.getId().toString()), (String)this.editData.getNumber().toString(), (String)"logisticsFee_print", (String)this.editData.getTransportOrgUnit().getId().toString(), (String)operName);
        LogUtil.afterLog(null, (IObjectPK)pk);
    }

    public static void setDefaultDecimalEditor(KDFormattedTextField txt, KDTDefaultCellEditor editor, KDTable table, String colKey) {
        String formatString = PrecisionUtil.getFormatString((int)6);
        table.getColumn(colKey).setEditor((ICellEditor)editor);
        table.getColumn(colKey).getStyleAttributes().setNumberFormat(formatString);
        table.getColumn(colKey).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
    }

    public static void setDefaultDecimalEditor(KDFormattedTextField txt, KDTDefaultCellEditor editor, KDTable table, String[] colKeys) {
        for (int i = 0; i < colKeys.length; ++i) {
            LogisticsFeeEditUI.setDefaultDecimalEditor(txt, editor, table, colKeys[i]);
        }
    }

    class PrintListner
    implements IPrintActionListener {
        PrintListner() {
        }

        public void beforePrintOrPreview() {
        }

        public void beforePreview() {
        }

        public void beforePrint() {
            LogisticsFeeEditUI.this.logPrint();
        }

        public void closePreview() {
        }
    }
}

