/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.dt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.BizDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.IDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.KDTableHelper;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectListener;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.render.ObjectValueRender;
import com.kingdee.bos.ctrl.print.IPrintActionListener;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.KDNoteHelper;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.StringUtils;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerCollection;
import com.kingdee.eas.basedata.master.cssp.CustomerFactory;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MaterialInventoryInfo;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitFactory;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.org.TransportOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.util.CommonDataProvider;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.EntryBaseStatusEnum;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.im.dt.HandleModeEnum;
import com.kingdee.eas.scm.im.dt.IDtBillBase;
import com.kingdee.eas.scm.im.dt.RoadCostBillEntryInfo;
import com.kingdee.eas.scm.im.dt.RoadCostBillFactory;
import com.kingdee.eas.scm.im.dt.RoadCostBillInfo;
import com.kingdee.eas.scm.im.dt.client.AbstractRoadCostBillEditUI;
import com.kingdee.eas.scm.im.dt.util.DtUtils;
import com.kingdee.eas.scm.im.dt.util.client.RoadCostBillClientUtils;
import com.kingdee.eas.scm.util.numeric.PrecisionUtil;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class RoadCostBillEditUI
extends AbstractRoadCostBillEditUI
implements DataChangeListener,
KDTEditListener,
KDTSelectListener {
    private static final Logger logger = CoreUIObject.getLogger(RoadCostBillEditUI.class);
    private static final String TB_MATERIAL = "material";
    private static final String TB_MATERIAL_NAME = "materialName";
    private static final String TB_MATERIAL_MODEL = "materialModel";
    private static final String TB_ASSIST_PROPERTY = "assistProperty";
    private static final String TB_LOT = "lot";
    private static final String TB_UNIT = "unit";
    private static final String TB_ROADCOST_QTY = "roadCostQty";
    private static final String TB_BASE_UNIT = "baseUnit";
    private static final String TB_BASE_QTY = "baseQty";
    private static final String TB_ASSIST_UNIT = "assistUnit";
    private static final String TB_ASSIST_QTY = "assistQty";
    private static final String TB_HANDLE_MODE = "handleMode";
    private static final String TB_COMPENSATE_DUTYOR = "compensateDutyor";
    private static final String TB_HANDLE_PRICE = "handlePrice";
    private static final String TB_HANDLE_AMOUNT = "handleAmount";
    private static final String TB_TOTAL_ARQTY = "totalArQty";
    private static final String TB_TOTAL_ARAMOUNT = "totalArAmount";
    private static final String TB_CONSIGNOR = "consignor";
    private static final String TB_CONSIGNOR_STORAGE = "consignorStorageOrgUnit";
    private static final String TB_CONSIGNOR_COMPANY = "consignorCompanyOrgUnit";
    private static final String TB_CONSIGNOR_WAREHOUSE = "consignorWareHouse";
    private static final String TB_CONSIGNEE = "consignee";
    private static final String TB_CONSIGNEE_STORAGE = "consigneeStorageOrgUnit";
    private static final String TB_CONSIGNEE_COMPANY = "consigneeCompanyOrgUnit";
    private static final String TB_CONSIGNEE_WAREHOUSE = "consigneeWareHouse";
    private static final String TB_DETAIL_DESTRIBUTION_LINE = "detailDestributionLine";
    private static final String TB_TRANSPORT_START = "transportStart";
    private static final String TB_TRANSPORT_END = "transportEnd";
    private static final String TB_TRANSPORT_SUPPLIER = "transportSupplier";
    private static final String TB_CAR_LICENSENUMBER = "carlicenseNumber";
    private static final String TB_ASSOCIATE_QTY = "associateQty";
    private static final String[] TBS_QTY = new String[]{"roadCostQty", "totalArQty"};
    private static final String[] TBS_BASEQTY = new String[]{"baseQty", "associateQty"};
    private static final String[] TBS_ASSISTQTY = new String[]{"assistQty"};
    private static final String[] TBS_PRICE = new String[]{"handlePrice"};
    private static final String[] TBS_AMT = new String[]{"handleAmount", "totalArAmount"};
    private KDBizPromptBox prmtConpensateDutyor = new KDBizPromptBox();
    private static final BigDecimal ZERO = DtUtils.ZERO;
    private static final int DEFAULT_PRECISION = 4;

    public RoadCostBillEditUI() throws Exception {
        this.txtDiscription.setMaxLength(255);
    }

    protected IObjectValue createNewData() {
        RoadCostBillInfo info = null;
        try {
            info = new RoadCostBillInfo();
            this.tou = (TransportOrgUnitInfo)this.getDefaultMainBizOrg();
            this.touTOcou = DtUtils.getCompanyInfo(null, this.tou);
            info.setBillType(SCMClientUtils.getBillType((String)"E4Anb3NGxUm/1BMRhRWcSEY+1VI="));
            Date now = SCMClientUtils.getServerDate2();
            UserInfo user = SysContext.getSysContext().getCurrentUserInfo();
            info.setCreator(user);
            info.setCreateTime(new Timestamp(now.getTime()));
            info.setBizDate(now);
            info.setTransportOrgUnit(this.tou);
            info.setCompanyOrgUnit(this.touTOcou);
            info.setBaseStatus(BillBaseStatusEnum.ADD);
            RoadCostBillEntryInfo entry = (RoadCostBillEntryInfo)this.createNewDetailData(this.kdtEntries);
            info.getEntry().add(entry);
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        return info;
    }

    protected IObjectValue createNewDetailData(KDTable table) {
        RoadCostBillEntryInfo entry = null;
        entry = new RoadCostBillEntryInfo();
        entry.setHandleMode(HandleModeEnum.TRANSPORTER_DUTY);
        entry.setRoadCostQty(ZERO);
        entry.setBaseQty(ZERO);
        entry.setAssistQty(ZERO);
        entry.setTotalArQty(ZERO);
        entry.setAssociateQty(ZERO);
        entry.setBaseStatus(EntryBaseStatusEnum.ADD);
        return entry;
    }

    protected void processTargetBillArray(String[] targetBillBosTypeArray, String[] targetBillAliasArray) {
        super.processTargetBillArray(targetBillBosTypeArray, targetBillAliasArray);
        if (targetBillBosTypeArray == null || targetBillAliasArray == null) {
            return;
        }
        for (int i = 0; i < targetBillBosTypeArray.length; ++i) {
            if (!"A4D04D23".equals(targetBillBosTypeArray[i])) continue;
            targetBillBosTypeArray[i] = null;
            targetBillAliasArray[i] = null;
        }
    }

    @Override
    public void onLoad() throws Exception {
        super.onLoad();
        this.menuItemInvBillOptin.setVisible(false);
        this.menuItemInvBillOptin.setEnabled(false);
        this.txtDiscription.setMaxLength(255);
        SCMClientUtils.setEntriesTableStrLength((KDTable)this.kdtEntries, (String[])new String[]{"entry.remark"}, (int)255);
        if (this.prmtSourceBillType.getValue() != null && this.comboBaseStatus.getSelectedItem().equals(BillBaseStatusEnum.TEMPORARILYSAVED)) {
            this.btnRemoveLine.setEnabled(false);
            this.btnAddLine.setEnabled(false);
            this.btnInsertLine.setEnabled(false);
            this.btnSplitLine.setEnabled(false);
        }
        if (this.isBotpBill()) {
            KDTableHelper.updateEnterWithTab((KDTable)this.getDetailTable(), (boolean)false, null);
            KDTableHelper.downArrowAutoAddRow((KDTable)this.getDetailTable(), (boolean)false, null);
        }
        this.getDetailTable().getColumn("coreBillEntrySeq").getStyleAttributes().setNumberFormat(PrecisionUtil.getFormatIntForHideZero());
    }

    @Override
    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        super.actionEdit_actionPerformed(e);
        if (this.prmtSourceBillType.getValue() != null && this.comboBaseStatus.getSelectedItem().equals(BillBaseStatusEnum.TEMPORARILYSAVED)) {
            this.btnRemoveLine.setEnabled(false);
            this.btnAddLine.setEnabled(false);
            this.btnInsertLine.setEnabled(false);
            this.btnSplitLine.setEnabled(false);
        }
    }

    public void onShow() throws Exception {
        super.onShow();
        this.setMainOrgCtrl();
    }

    @Override
    protected void initEntryBeforeOnLoad() throws Exception {
        ObjectValueRender avr = new ObjectValueRender();
        avr.setFormat((IDataFormat)new BizDataFormat("$number$"));
        this.kdtEntries.getColumn(TB_MATERIAL).setRenderer((IBasicRender)avr);
        KDFormattedTextField txtDecimal = new KDFormattedTextField(1);
        KDTDefaultCellEditor editorDecimal = new KDTDefaultCellEditor((JTextField)txtDecimal);
        txtDecimal.setHorizontalAlignment(4);
        txtDecimal.setPrecision(4);
        txtDecimal.setSupportedEmpty(true);
        txtDecimal.setNegatived(false);
        DtUtils.setDefaultDecimalEditor(txtDecimal, editorDecimal, this.kdtEntries, TBS_QTY);
        DtUtils.setDefaultDecimalEditor(txtDecimal, editorDecimal, this.kdtEntries, TBS_BASEQTY);
        DtUtils.setDefaultDecimalEditor(txtDecimal, editorDecimal, this.kdtEntries, TBS_ASSISTQTY);
        DtUtils.setDefaultDecimalEditor(txtDecimal, editorDecimal, this.kdtEntries, TBS_PRICE);
        KDFormattedTextField txtAmount = new KDFormattedTextField(1);
        KDTDefaultCellEditor editorAmount = new KDTDefaultCellEditor((JTextField)txtAmount);
        txtAmount.setHorizontalAlignment(4);
        txtAmount.setPrecision(4);
        txtAmount.setSupportedEmpty(true);
        txtAmount.setNegatived(true);
        DtUtils.setDefaultDecimalEditor(txtAmount, editorAmount, this.kdtEntries, TBS_AMT);
        DtUtils.setDefaultF7Editor(this.prmtConpensateDutyor, "com.kingdee.eas.basedata.master.cssp.app.F7CustomerCompanyQueryWithDefaultStandard", this.kdtEntries, TB_COMPENSATE_DUTYOR);
        KDComboBox handleModeBox = new KDComboBox();
        handleModeBox.addItems(HandleModeEnum.getEnumList().toArray());
        this.kdtEntries.getColumn(TB_HANDLE_MODE).setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)handleModeBox));
        this.kdtEntries.getViewManager().setFreezeView(0, this.kdtEntries.getColumnIndex(TB_MATERIAL_MODEL));
    }

    @Override
    public void loadFields() {
        try {
            this.loadFieldsBefore();
            super.loadFields();
            this.loadFieldsAfter();
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    @Override
    protected void loadFieldsBefore() throws Exception {
        super.loadFieldsBefore();
    }

    @Override
    protected void loadFieldsAfter() throws Exception {
        super.loadFieldsAfter();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("companyOrgUnit.id", (Object)this.getAllCompanyOrgUnit(), CompareType.INCLUDE));
        view.setFilter(filter);
        this.prmtCompany.setEntityViewInfo(view);
    }

    @Override
    protected void initBotpControl() throws Exception {
        super.initBotpControl();
        this.setMainOrgCtrl();
        for (int i = 0; i < this.kdtEntries.getRowCount(); ++i) {
            this.setControlByHandleMode(i);
        }
        if (this.isBotpBill()) {
            this.actionCopyLine.setEnabled(false);
            this.actionRemoveLine.setEnabled(false);
        }
    }

    protected void setMainOrgCtrl() throws Exception {
        if (!this.getOprtState().equals("ADDNEW")) {
            this.prmtTransportOrgUnit.setAccessAuthority(0);
            this.prmtTransportOrgUnit.setEnabled(false);
            this.prmtTransportOrgUnit.setEditable(false);
            this.prmtTransportOrgUnit.setRequired(false);
        }
    }

    private Set getAllCompanyOrgUnit() {
        HashSet<String> couSet = new HashSet<String>();
        if (this.touTOcou != null) {
            couSet.add(this.touTOcou.getId().toString());
        }
        int n = this.editData.getEntry().size();
        for (int i = 0; i < n; ++i) {
            RoadCostBillEntryInfo entry = this.editData.getEntry().get(i);
            if (entry.getCarryBillEntry() == null) continue;
            if (entry.getCarryBillEntry().getSendCompany() != null) {
                couSet.add(entry.getCarryBillEntry().getSendCompany().getId().toString());
            }
            if (entry.getCarryBillEntry().getReceiveCompany() == null) continue;
            couSet.add(entry.getCarryBillEntry().getReceiveCompany().getId().toString());
        }
        return couSet;
    }

    @Override
    public void storeFields() {
        try {
            this.storeFieldsBefore();
            super.storeFields();
            this.storeFieldsAfter();
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    protected void beforeStoreFields(ActionEvent e) throws Exception {
        KDTable table;
        Date bizDate;
        CompanyOrgUnitInfo companyOrgUnit;
        super.beforeStoreFields(e);
        if (!this.getBizInterface().exists((IObjectPK)new ObjectUuidPK(this.editData.getId()))) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.scm.im.IMAutoGenerateResource", (String)"10_RoadCostBillEditUI"));
            SysUtil.abort();
        }
        if (e == null || e.getSource() == this.btnSave || e.getSource() == this.menuItemSave) {
            return;
        }
        TransportOrgUnitInfo transportOrgUnit = (TransportOrgUnitInfo)this.prmtTransportOrgUnit.getValue();
        if (transportOrgUnit == null) {
            MsgBox.showError((Component)((Object)this), (String)RoadCostBillClientUtils.getResource("TransportOrgUnitCantNull"));
            this.prmtTransportOrgUnit.requestFocus();
            SysUtil.abort();
        }
        if ((companyOrgUnit = (CompanyOrgUnitInfo)this.prmtCompany.getValue()) == null) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.scm.im.IMAutoGenerateResource", (String)"5_LogisticsFeeEditUI"));
            this.prmtCompany.requestFocus();
            SysUtil.abort();
        }
        if ((bizDate = (Date)this.pkBizDate.getValue()) == null) {
            MsgBox.showError((Component)((Object)this), (String)RoadCostBillClientUtils.getResource("BizDateCantNull"));
            this.pkBizDate.requestFocus();
            SysUtil.abort();
        }
        if ((table = this.getDetailTable()).getRowCount() == 0) {
            MsgBox.showError((Component)((Object)this), (String)RoadCostBillClientUtils.getResource("EntryCountMustPositive"));
            SysUtil.abort();
        }
        for (int i = 0; i < table.getRowCount(); ++i) {
            BigDecimal handleAmount;
            BigDecimal handlePrice;
            BigDecimal roadCostQty = (BigDecimal)table.getCell(i, TB_ROADCOST_QTY).getValue();
            if (roadCostQty.compareTo(DtUtils.ZERO) > 0) {
                Object customer;
                HandleModeEnum handleMode = (HandleModeEnum)((Object)table.getCell(i, TB_HANDLE_MODE).getValue());
                if (handleMode == null) {
                    MsgBox.showError((Component)((Object)this), (String)RoadCostBillClientUtils.getResource("handleModeCantNull"));
                    table.getEditManager().editCellAt(i, table.getColumnIndex(TB_HANDLE_MODE));
                    SysUtil.abort();
                }
                if ((customer = table.getCell(i, TB_COMPENSATE_DUTYOR).getValue()) == null && (HandleModeEnum.THIRD_PORT_DUTY.equals((Object)handleMode) || HandleModeEnum.TRANSPORTER_DUTY.equals((Object)handleMode))) {
                    MsgBox.showError((Component)((Object)this), (String)RoadCostBillClientUtils.getResource("ConpensateDutyorCantNull1"));
                    table.getEditManager().editCellAt(i, table.getColumnIndex(TB_COMPENSATE_DUTYOR));
                    SysUtil.abort();
                }
            }
            if ((handlePrice = (BigDecimal)table.getCell(i, TB_HANDLE_PRICE).getValue()) == null) {
                MsgBox.showError((Component)((Object)this), (String)RoadCostBillClientUtils.getResource("handlePriceCantNull"));
                table.getEditManager().editCellAt(i, table.getColumnIndex(TB_HANDLE_PRICE));
                SysUtil.abort();
            }
            if ((handleAmount = (BigDecimal)table.getCell(i, TB_HANDLE_AMOUNT).getValue()) != null) continue;
            MsgBox.showError((Component)((Object)this), (String)RoadCostBillClientUtils.getResource("handleAmountCantNull"));
            table.getEditManager().editCellAt(i, table.getColumnIndex(TB_HANDLE_AMOUNT));
            SysUtil.abort();
        }
    }

    protected void setFieldsNull(AbstractObjectValue newData) {
        super.setFieldsNull(newData);
        RoadCostBillInfo info = (RoadCostBillInfo)newData;
        for (int i = 0; i < info.getEntry().size(); ++i) {
            info.getEntry().get(i).setTotalArQty(DtUtils.ZERO);
            info.getEntry().get(i).setTotalArAmount(DtUtils.ZERO);
            info.getEntry().get(i).setAssociateQty(DtUtils.ZERO);
            info.getEntry().get(i).setBaseStatus(EntryBaseStatusEnum.ADD);
        }
    }

    public void dataChanged(DataChangeEvent e) {
    }

    public void editStarting(KDTEditEvent e) {
    }

    public void editStarted(KDTEditEvent e) {
    }

    public void editValueChanged(KDTEditEvent e) {
    }

    public void editStopping(KDTEditEvent e) {
    }

    public void editStopped(KDTEditEvent e) {
        try {
            this.tableValueChanged(e);
        }
        catch (Exception ex) {
            this.handUIException(ex);
        }
    }

    public void editCanceled(KDTEditEvent e) {
    }

    private void tableValueChanged(KDTEditEvent e) throws Exception {
        BigDecimal raodCostQty;
        Object oldValue = e.getOldValue();
        Object newValue = e.getValue();
        if (oldValue == null && newValue == null || oldValue != null && oldValue.equals(newValue)) {
            return;
        }
        int colIndex = e.getColIndex();
        int rowIndex = e.getRowIndex();
        String fieldName = this.kdtEntries.getColumnKey(colIndex);
        if (TB_HANDLE_MODE.equals(fieldName)) {
            this.setValueByHandleMode(rowIndex);
            this.setControlByHandleMode(rowIndex);
        }
        if (TB_HANDLE_PRICE.equals(fieldName)) {
            BigDecimal handlePrice = (BigDecimal)this.kdtEntries.getCell(rowIndex, TB_HANDLE_PRICE).getValue();
            handlePrice = handlePrice == null ? DtUtils.ZERO : handlePrice;
            raodCostQty = (BigDecimal)this.kdtEntries.getCell(rowIndex, TB_ROADCOST_QTY).getValue();
            raodCostQty = raodCostQty == null ? DtUtils.ZERO : raodCostQty;
            BigDecimal handleAmount = raodCostQty.multiply(handlePrice);
            this.kdtEntries.getCell(rowIndex, TB_HANDLE_AMOUNT).setValue((Object)handleAmount);
        }
        if (TB_HANDLE_AMOUNT.equals(fieldName)) {
            BigDecimal handleAmount = (BigDecimal)this.kdtEntries.getCell(rowIndex, TB_HANDLE_AMOUNT).getValue();
            handleAmount = handleAmount == null ? DtUtils.ZERO : handleAmount;
            raodCostQty = (BigDecimal)this.kdtEntries.getCell(rowIndex, TB_ROADCOST_QTY).getValue();
            if (raodCostQty == null || raodCostQty.compareTo(DtUtils.ZERO) == 0) {
                this.kdtEntries.getCell(rowIndex, TB_HANDLE_AMOUNT).setValue((Object)DtUtils.ZERO);
                return;
            }
            int scale = DtUtils.getCellScale(this.kdtEntries, rowIndex, TB_HANDLE_PRICE);
            if (raodCostQty.compareTo(DtUtils.ZERO) < 0) {
                BigDecimal handlePrice = handleAmount.divide(raodCostQty, scale, 4).abs();
                this.kdtEntries.getCell(rowIndex, TB_HANDLE_PRICE).setValue((Object)handlePrice);
                this.kdtEntries.getCell(rowIndex, TB_HANDLE_AMOUNT).setValue((Object)handleAmount.abs().negate());
            } else {
                handleAmount = handleAmount.abs();
                BigDecimal handlePrice = handleAmount.divide(raodCostQty, scale, 4);
                this.kdtEntries.getCell(rowIndex, TB_HANDLE_PRICE).setValue((Object)handlePrice);
                this.kdtEntries.getCell(rowIndex, TB_HANDLE_AMOUNT).setValue((Object)handleAmount);
            }
        }
    }

    public void tableSelectChanged(KDTSelectEvent e) {
    }

    @Override
    protected void addListeners() {
        this.getDetailTable().addKDTEditListener((KDTEditListener)this);
        this.getDetailTable().addKDTSelectListener((KDTSelectListener)this);
        this.prmtTransportOrgUnit.addDataChangeListener((DataChangeListener)this);
    }

    @Override
    protected void removeListeners() {
        this.getDetailTable().removeKDTEditListener((KDTEditListener)this);
        this.getDetailTable().removeKDTSelectListener((KDTSelectListener)this);
        this.prmtTransportOrgUnit.removeDataChangeListener((DataChangeListener)this);
    }

    private void setValueByHandleMode(int rowIndex) throws BOSException {
        BigDecimal roadCostQty = (BigDecimal)this.kdtEntries.getCell(rowIndex, TB_ROADCOST_QTY).getValue();
        if (roadCostQty.compareTo(DtUtils.ZERO) <= 0) {
            this.kdtEntries.getCell(rowIndex, TB_COMPENSATE_DUTYOR).setValue(null);
            return;
        }
        Object handleMode = this.kdtEntries.getCell(rowIndex, TB_HANDLE_MODE).getValue();
        if (HandleModeEnum.TRANSPORTER_DUTY.equals(handleMode)) {
            SupplierInfo carrier = (SupplierInfo)this.kdtEntries.getCell(rowIndex, TB_TRANSPORT_SUPPLIER).getValue();
            CustomerCollection collection = new CustomerCollection();
            if (carrier != null && carrier.getBizAnalysisCode() != null) {
                String oql = "where bizAnalysisCode = '" + carrier.getBizAnalysisCode().getId().toString() + "'";
                collection = CustomerFactory.getRemoteInstance().getCustomerCollection(oql);
            }
            if (collection.size() > 0) {
                this.kdtEntries.getCell(rowIndex, TB_COMPENSATE_DUTYOR).setValue((Object)collection.get(0));
            } else {
                this.kdtEntries.getCell(rowIndex, TB_COMPENSATE_DUTYOR).setValue(null);
                this.kdtEntries.getCell(rowIndex, TB_COMPENSATE_DUTYOR).getStyleAttributes().setLocked(true);
                SCMClientUtils.setNecessColorInCells((KDTable)this.kdtEntries, (String)TB_COMPENSATE_DUTYOR, (int)rowIndex, (boolean)false);
                this.kdtEntries.getCell(rowIndex, TB_HANDLE_MODE).setValue((Object)HandleModeEnum.COMPANY_DUTY);
                MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.scm.im.IMAutoGenerateResource", (String)"11_RoadCostBillEditUI"));
                SysUtil.abort();
            }
        } else if (HandleModeEnum.THIRD_PORT_DUTY.equals(handleMode)) {
            EntityViewInfo viewInfo = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("companyOrgUnit.id", (Object)this.getAllCompanyOrgUnit(), CompareType.INCLUDE));
            viewInfo.setFilter(filter);
            this.prmtConpensateDutyor.setEntityViewInfo(viewInfo);
            this.kdtEntries.getCell(rowIndex, TB_COMPENSATE_DUTYOR).setValue(null);
        } else if (HandleModeEnum.COMPANY_DUTY.equals(handleMode)) {
            this.kdtEntries.getCell(rowIndex, TB_COMPENSATE_DUTYOR).setValue(null);
        }
    }

    private void setControlByHandleMode(int rowIndex) {
        Object handleMode = this.kdtEntries.getCell(rowIndex, TB_HANDLE_MODE).getValue();
        if (HandleModeEnum.TRANSPORTER_DUTY.equals(handleMode)) {
            this.kdtEntries.getCell(rowIndex, TB_COMPENSATE_DUTYOR).getStyleAttributes().setLocked(true);
            SCMClientUtils.setNecessColorInCells((KDTable)this.kdtEntries, (String)TB_COMPENSATE_DUTYOR, (int)rowIndex, (boolean)true);
        } else if (HandleModeEnum.THIRD_PORT_DUTY.equals(handleMode)) {
            this.kdtEntries.getCell(rowIndex, TB_COMPENSATE_DUTYOR).getStyleAttributes().setLocked(false);
            SCMClientUtils.setNecessColorInCells((KDTable)this.kdtEntries, (String)TB_COMPENSATE_DUTYOR, (int)rowIndex, (boolean)true);
        } else if (HandleModeEnum.COMPANY_DUTY.equals(handleMode)) {
            this.kdtEntries.getCell(rowIndex, TB_COMPENSATE_DUTYOR).getStyleAttributes().setLocked(true);
            SCMClientUtils.setNecessColorInCells((KDTable)this.kdtEntries, (String)TB_COMPENSATE_DUTYOR, (int)rowIndex, (boolean)false);
        }
        BigDecimal roadCostQty = (BigDecimal)this.kdtEntries.getCell(rowIndex, TB_ROADCOST_QTY).getValue();
        if (roadCostQty.compareTo(DtUtils.ZERO) <= 0) {
            this.kdtEntries.getCell(rowIndex, TB_COMPENSATE_DUTYOR).getStyleAttributes().setLocked(true);
            SCMClientUtils.setNecessColorInCells((KDTable)this.kdtEntries, (String)TB_COMPENSATE_DUTYOR, (int)rowIndex, (boolean)false);
        }
    }

    @Override
    protected void setColumnControl(int rowIndex, boolean isOnload) throws Exception {
        super.setColumnControl(rowIndex, isOnload);
        KDTable table = this.getDetailTable();
        MaterialInfo material = (MaterialInfo)table.getCell(rowIndex, TB_MATERIAL).getValue();
        if (material == null) {
            return;
        }
        int qtyPrecision = 4;
        int baseQtyPrecision = 4;
        int pricePrecision = 4;
        int amountPrecision = 4;
        MeasureUnitInfo unit = null;
        MeasureUnitInfo baseUnit = null;
        unit = (MeasureUnitInfo)table.getCell(rowIndex, TB_UNIT).getValue();
        baseUnit = (MeasureUnitInfo)table.getCell(rowIndex, TB_BASE_UNIT).getValue();
        if (unit != null) {
            if (this.fetchData.getUnitPrecision(material.getId().toString(), unit.getId().toString()) == null) {
                MultiMeasureUnitInfo mmuUnit = MultiMeasureUnitFactory.getRemoteInstance().getMultiUnit(material.getId().toString(), unit.getId().toString());
                this.fetchData.putUnitPrecision(material.getId().toString(), unit.getId().toString(), mmuUnit.getQtyPrecision());
                qtyPrecision = mmuUnit.getQtyPrecision();
            } else {
                qtyPrecision = this.fetchData.getUnitPrecision(material.getId().toString(), unit.getId().toString());
            }
        }
        DtUtils.changePrecision(table, rowIndex, TBS_QTY, qtyPrecision, false);
        if (baseUnit != null) {
            if (this.fetchData.getUnitPrecision(material.getId().toString(), baseUnit.getId().toString()) == null) {
                MultiMeasureUnitInfo mmuBaseUnit = MultiMeasureUnitFactory.getRemoteInstance().getMultiUnit(material.getId().toString(), baseUnit.getId().toString());
                this.fetchData.putUnitPrecision(material.getId().toString(), baseUnit.getId().toString(), mmuBaseUnit.getQtyPrecision());
                baseQtyPrecision = mmuBaseUnit.getQtyPrecision();
            } else {
                baseQtyPrecision = this.fetchData.getUnitPrecision(material.getId().toString(), baseUnit.getId().toString());
            }
        }
        DtUtils.changePrecision(table, rowIndex, TBS_BASEQTY, baseQtyPrecision, false);
        if (material != null) {
            if (this.fetchData.getPricePrecision(material.getId().toString()) < 0) {
                pricePrecision = MaterialFactory.getRemoteInstance().getMaterialInfo((IObjectPK)new ObjectUuidPK(material.getId())).getPricePrecision();
                this.fetchData.putPricePrecision(material.getId().toString(), pricePrecision);
            } else {
                pricePrecision = this.fetchData.getPricePrecision(material.getId().toString());
            }
        }
        DtUtils.changePrecision(table, rowIndex, TBS_PRICE, pricePrecision, false);
        if (this.touTOcou != null) {
            String oql = "SELECT id, number,name, baseCurrency.id, baseCurrency.precision WHERE id = '" + this.touTOcou.getId().toString() + "'";
            this.touTOcou = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo(oql);
            amountPrecision = this.touTOcou.getBaseCurrency().getPrecision();
        }
        DtUtils.changePrecision(table, rowIndex, TBS_AMT, amountPrecision, true);
        this.setMaterialLot(rowIndex, table);
    }

    @Override
    protected void setColumnData(int rowIndex, boolean isOnload) throws Exception {
        super.setColumnData(rowIndex, isOnload);
    }

    private void setMaterialLot(int rowIndex, KDTable table) throws EASBizException, BOSException {
        MaterialInfo materialForLot = (MaterialInfo)this.getDetailTable().getCell(rowIndex, TB_MATERIAL).getValue();
        StorageOrgUnitInfo sendStoreOrg = (StorageOrgUnitInfo)table.getCell(rowIndex, TB_CONSIGNOR_STORAGE).getValue();
        if (materialForLot != null && sendStoreOrg != null) {
            MaterialInventoryInfo materialInventoryInfo = null;
            materialInventoryInfo = this.fetchData.getMaterialInventory(materialForLot.getId().toString(), sendStoreOrg.getId().toString());
            if (materialInventoryInfo != null && materialInventoryInfo.isIsLotNumber()) {
                table.getCell(rowIndex, TB_LOT).getStyleAttributes().setLocked(false);
            } else {
                table.getCell(rowIndex, TB_LOT).getStyleAttributes().setLocked(true);
                table.getCell(rowIndex, TB_LOT).setValue(null);
            }
        }
    }

    protected ICoreBase getBizInterface() throws Exception {
        return RoadCostBillFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext());
    }

    public KDTextField getNumTextField() {
        return this.txtNumber;
    }

    protected KDTable getDetailTable() {
        return this.kdtEntries;
    }

    public KDBizPromptBox getMainOrgUnit() {
        return this.prmtTransportOrgUnit;
    }

    protected KDBizPromptBox getMainBizOrg() {
        return this.prmtTransportOrgUnit;
    }

    @Override
    protected OrgType getMainBizOrgType() {
        return OrgType.Transport;
    }

    protected String getPermissionItem(String status) {
        if ("ADDNEW".equals(status)) {
            return "roadCost_addnew";
        }
        return null;
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add("*");
        sic.add("entry.*");
        sic.add("carryBill.mainCarrier.*");
        sic.add("carryBill.sendLine.*");
        sic.add("carrybill.transportType.*");
        sic.add("entry.compensateDutyor.*");
        return sic;
    }

    public List getSrcBosTypeForBotp(List srcBosTypeList) {
        TransportOrgUnitInfo transInfo = null;
        ObjectUuidPK orgPk = null;
        String param = null;
        if (this.prmtTransportOrgUnit.getValue() != null) {
            transInfo = (TransportOrgUnitInfo)this.prmtTransportOrgUnit.getValue();
        }
        if (transInfo != null) {
            orgPk = new ObjectUuidPK(transInfo.getId());
        }
        try {
            param = ParamControlFactory.getRemoteInstance().getParamValue(orgPk, "CARRY003");
        }
        catch (EASBizException e) {
            this.handUIException(e);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        for (int i = srcBosTypeList.size() - 1; i >= 0; --i) {
            String bosType = (String)srcBosTypeList.get(i);
            if (!"8B07BBDB".equals(bosType) || !Boolean.valueOf(param).booleanValue()) continue;
            srcBosTypeList.remove(i);
        }
        return super.getSrcBosTypeForBotp(srcBosTypeList);
    }

    public List getDestBosTypeForBotp(CoreBillBaseCollection srcBillInfos, List destBosTypeList) {
        return super.getDestBosTypeForBotp(srcBillInfos, destBosTypeList);
    }

    @Override
    public void actionAudit_actionPerformed(ActionEvent e) throws Exception {
        super.actionAudit_actionPerformed(e);
        boolean isGenerateAROtherbill = false;
        int n = this.editData.getEntry().size();
        for (int i = 0; i < n; ++i) {
            RoadCostBillEntryInfo entry = this.editData.getEntry().get(i);
            BigDecimal roadCostQty = entry.getRoadCostQty();
            BigDecimal bigDecimal = roadCostQty = roadCostQty == null ? DtUtils.ZERO : roadCostQty;
            if (roadCostQty.compareTo(ZERO) >= 0) continue;
            isGenerateAROtherbill = true;
        }
        if (isGenerateAROtherbill && this.getBillEdit() != null) {
            String destBosType = "A4D04D23";
            this.getBillEdit().CreateTo((CoreBillBaseInfo)this.editData, destBosType);
        }
        this.editData = (RoadCostBillInfo)this.getValue((IObjectPK)new ObjectUuidPK(this.editData.getId()));
        this.setDataObject((IObjectValue)this.editData);
        this.loadFields();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionUnAudit_actionPerformed(ActionEvent e) throws Exception {
        try {
            this.checkSelected();
            if (!this.confirmUnAduit()) {
                return;
            }
            if (this.editData.getBaseStatus() != BillBaseStatusEnum.AUDITED) {
                String msg = EASResource.getString((String)"com.kingdee.eas.scm.common.SCMResource.NotUnAudit");
                MsgBox.showWarning((Component)((Object)this), (String)msg);
                return;
            }
            ObjectUuidPK pk = new ObjectUuidPK(this.editData.getId());
            IDtBillBase iDtBillBase = (IDtBillBase)this.getBizInterface();
            iDtBillBase.unAudit((IObjectPK)pk);
            this.setDataObject(this.getValue((IObjectPK)pk));
            this.loadFields();
            this.setSave(true);
            this.setSaved(true);
        }
        catch (Exception e1) {
            this.handUIException(e1);
        }
        finally {
            try {
                this.pubFireVOChangeListener(null);
            }
            catch (Throwable e2) {
                this.handUIException(e2);
            }
        }
    }

    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        if (this.prmtSourceBillType.getValue() == null) {
            MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.scm.im.IMAutoGenerateResource", (String)"12_RoadCostBillEditUI"));
            SysUtil.abort();
        }
        super.actionSave_actionPerformed(e);
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        if (this.prmtSourceBillType.getValue() == null) {
            MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.scm.im.IMAutoGenerateResource", (String)"12_RoadCostBillEditUI"));
            SysUtil.abort();
        }
        super.actionSubmit_actionPerformed(e);
    }

    protected void setTableToSumField() {
        this.setTableToSumField(this.kdtEntries, this.getSumColNames(this.kdtEntries.getName()));
    }

    public void actionCopyLine_actionPerformed(ActionEvent e) throws Exception {
        super.actionCopyLine_actionPerformed(e);
        int copyToRowIndex = KDTableUtil.getLastVisibleRowIndex((KDTable)this.getDetailTable());
        IRow row = this.getDetailTable().getRow(copyToRowIndex);
        MeasureUnitInfo unitInfo = (MeasureUnitInfo)row.getCell(TB_UNIT).getValue();
        int precision = 4;
        if (null != unitInfo) {
            precision = unitInfo.getQtyPrecision();
        }
        SCMClientUtils.changeCellPrecision((IRow)row, (String[])TBS_QTY, (int)precision);
        MaterialInfo material = (MaterialInfo)row.getCell(TB_MATERIAL).getValue();
        precision = 4;
        if (null != material) {
            precision = material.getPricePrecision();
        }
        SCMClientUtils.changeCellPrecision((IRow)row, (String[])TBS_PRICE, (int)precision);
    }

    protected String[] getSumColNames(String tableName) {
        if (tableName == null || tableName.length() == 0) {
            return null;
        }
        String[] str = null;
        if (tableName.equals(this.kdtEntries.getName())) {
            str = new String[]{TB_ROADCOST_QTY, TB_HANDLE_AMOUNT, TB_TOTAL_ARQTY, TB_TOTAL_ARAMOUNT, TB_ASSOCIATE_QTY};
        }
        return str;
    }

    public void actionPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrintPreview_actionPerformed(e);
        ArrayList<String> idList = new ArrayList<String>();
        if (this.editData != null && !StringUtils.isEmpty((String)this.editData.getString("id"))) {
            idList.add(this.editData.getString("id"));
        }
        if (idList == null || idList.size() == 0 || this.getTDQueryPK() == null || this.getTDFileName() == null) {
            return;
        }
        CommonDataProvider data = new CommonDataProvider(idList, this.getTDQueryPK());
        KDNoteHelper appHlp = new KDNoteHelper();
        appHlp.addKDNoteActionListener((IPrintActionListener)new PrintListner());
        appHlp.printPreview(this.getTDFileName(), (Object)data, (Component)SwingUtilities.getWindowAncestor((Component)((Object)this)));
    }

    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrint_actionPerformed(e);
        ArrayList<String> idList = new ArrayList<String>();
        if (this.editData != null && !StringUtils.isEmpty((String)this.editData.getString("id"))) {
            idList.add(this.editData.getString("id"));
        }
        if (idList == null || idList.size() == 0 || this.getTDQueryPK() == null || this.getTDFileName() == null) {
            return;
        }
        CommonDataProvider data = new CommonDataProvider(idList, this.getTDQueryPK());
        KDNoteHelper appHlp = new KDNoteHelper();
        appHlp.addKDNoteActionListener((IPrintActionListener)new PrintListner());
        appHlp.print(this.getTDFileName(), (Object)data, (Component)SwingUtilities.getWindowAncestor((Component)((Object)this)));
    }

    protected IMetaDataPK getTDQueryPK() {
        return new MetaDataPK("com.kingdee.eas.scm.im.dt.RoadCostBillPrintQuery");
    }

    protected String getTDFileName() {
        return "/SCM/DT/RoadCostBill";
    }

    protected boolean checkValid() {
        return true;
    }

    protected void logPrint() {
        String operName = EASResource.getString((String)"com.kingdee.eas.scm.im.dt.client.JhResource", (String)"RoadCostBillPrint");
        IObjectPK pk = LogUtil.beginLog(null, (String)operName, (BOSObjectType)new RoadCostBillInfo().getBOSType(), (IObjectPK)new ObjectUuidPK(this.editData.getId().toString()), (String)this.editData.getNumber().toString(), (String)"roadCost_print", (String)this.editData.getTransportOrgUnit().getId().toString(), (String)operName);
        LogUtil.afterLog(null, (IObjectPK)pk);
    }

    class PrintListner
    implements IPrintActionListener {
        PrintListner() {
        }

        public void beforePrintOrPreview() {
        }

        public void beforePreview() {
        }

        public void beforePrint() {
            RoadCostBillEditUI.this.logPrint();
        }

        public void closePreview() {
        }
    }
}

