/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.dt.util.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.org.TransportOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.bc.ExpenseTypeInfo;
import com.kingdee.eas.scm.im.dt.CarryBillEntryCollection;
import com.kingdee.eas.scm.im.dt.CarryBillEntryFactory;
import com.kingdee.eas.scm.im.dt.CarryBillEntryInfo;
import com.kingdee.eas.scm.im.dt.CarryBillFeeEntryAgent;
import com.kingdee.eas.scm.im.dt.CarryBillFeeEntryInfo;
import com.kingdee.eas.scm.im.dt.DeliveryLineInfo;
import com.kingdee.eas.scm.im.dt.FeeLimitEntryFactory;
import com.kingdee.eas.scm.im.dt.FeeLimitEntryInfo;
import com.kingdee.eas.scm.im.dt.TransportTypeEnum;
import com.kingdee.eas.scm.im.dt.util.DtUtils;
import com.kingdee.eas.scm.im.inv.client.InvClientUtils;
import com.kingdee.eas.util.client.EASResource;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class CarryBillClientUtils {
    public static final String CARRYBILL_RESOURCE = "com.kingdee.eas.scm.im.dt.client.CarryBillResource";

    public static final String getResource(String key) {
        return EASResource.getString((String)CARRYBILL_RESOURCE, (String)key);
    }

    public static final Map createNewFeeEntryFromEntry(CarryBillEntryInfo entry) throws BOSException {
        if (entry == null) {
            return null;
        }
        CarryBillEntryCollection entrys = new CarryBillEntryCollection();
        entrys.add(entry);
        return CarryBillClientUtils.createNewFeeEntryFromEntry(entrys);
    }

    public static final Map createNewFeeEntryFromEntry(CarryBillEntryCollection entrys) throws BOSException {
        HashMap<String, CarryBillFeeEntryAgent> result = new HashMap<String, CarryBillFeeEntryAgent>();
        if (entrys == null || entrys.size() == 0) {
            return result;
        }
        ArrayList<String> idList = new ArrayList<String>();
        int n = entrys.size();
        for (int i = 0; i < n; ++i) {
            if (entrys.get(i).getId() == null) continue;
            idList.add(entrys.get(i).getId().toString());
        }
        String oql = "SELECT *, material.number, material.name, unit.number, unit.name, carrier.name WHERE id IN " + InvClientUtils.getInStringFromList(idList);
        CarryBillEntryCollection entryCollection = CarryBillEntryFactory.getRemoteInstance().getCarryBillEntryCollection(oql);
        int n2 = entryCollection.size();
        for (int i = 0; i < n2; ++i) {
            CarryBillFeeEntryAgent feeEntry = CarryBillFeeEntryAgent.create();
            CarryBillClientUtils.initFeeEntry(feeEntry);
            feeEntry.setFeeMaterial(entryCollection.get(i).getMaterial());
            feeEntry.setFeeUnit(entryCollection.get(i).getUnit());
            feeEntry.setFeeQty(entryCollection.get(i).getQty());
            feeEntry.setFeeCarrier(entryCollection.get(i).getCarrier());
            feeEntry.setCarryBillEntry(entryCollection.get(i));
            result.put(entryCollection.get(i).getId().toString(), feeEntry);
        }
        return result;
    }

    public static final void initFeeEntry(CarryBillFeeEntryInfo feeEntry) {
        if (feeEntry == null) {
            return;
        }
        feeEntry.setFeePrice(DtUtils.ZERO);
        feeEntry.setFeeAmount(DtUtils.ZERO);
        feeEntry.setAgreePrice(DtUtils.ZERO);
        feeEntry.setAgressAmount(DtUtils.ZERO);
        feeEntry.setBalancedQty(DtUtils.ZERO);
        feeEntry.setBalancedAmount(DtUtils.ZERO);
        feeEntry.setUnbalancedQty(DtUtils.ZERO);
        feeEntry.setFeeTransType(TransportTypeEnum.CAR);
    }

    public static final void fillFeeLimitByRow(TransportOrgUnitInfo tou, KDTable kdtFeeEntry, int rowIndex, String bizDate) throws EASBizException, BOSException {
        FeeLimitEntryInfo feeLimit;
        if (bizDate == null) {
            return;
        }
        if (tou == null || kdtFeeEntry == null) {
            return;
        }
        int feeSize = kdtFeeEntry.getRowCount();
        if (rowIndex < 0 || rowIndex >= feeSize) {
            return;
        }
        ExpenseTypeInfo feeItem = (ExpenseTypeInfo)kdtFeeEntry.getCell(rowIndex, "feeItem").getValue();
        if (feeItem == null) {
            return;
        }
        String touID = tou.getId().toString();
        String feeItemID = feeItem.getId().toString();
        String detailLineID = null;
        DeliveryLineInfo detailLine = (DeliveryLineInfo)kdtFeeEntry.getCell(rowIndex, "feeCarryLine").getValue();
        if (detailLine != null) {
            detailLineID = detailLine.getId().toString();
        }
        String unitID = null;
        MeasureUnitInfo unit = (MeasureUnitInfo)kdtFeeEntry.getCell(rowIndex, "feeUnit").getValue();
        if (unit != null) {
            unitID = unit.getId().toString();
        }
        String carrierID = null;
        SupplierInfo carrier = (SupplierInfo)kdtFeeEntry.getCell(rowIndex, "feeCarrier").getValue();
        if (carrier != null) {
            carrierID = carrier.getId().toString();
        }
        if ((feeLimit = (FeeLimitEntryInfo)FeeLimitEntryFactory.getRemoteInstance().getFeeLimitPrice(touID, feeItemID, detailLineID, unitID, carrierID, bizDate)) != null) {
            kdtFeeEntry.getCell(rowIndex, "feeUnit").setValue((Object)feeLimit.getUnit());
            kdtFeeEntry.getCell(rowIndex, "feePrice").setValue((Object)feeLimit.getPrice());
            kdtFeeEntry.getCell(rowIndex, "agreePrice").setValue((Object)feeLimit.getPrice());
        } else {
            kdtFeeEntry.getCell(rowIndex, "feePrice").setValue((Object)DtUtils.ZERO);
            kdtFeeEntry.getCell(rowIndex, "agreePrice").setValue((Object)DtUtils.ZERO);
        }
    }

    public static final String toPlainString(BigDecimal bd) {
        String subString = bd.abs().toString();
        if (subString.indexOf("-") == -1) {
            return bd.toString();
        }
        StringBuffer st = new StringBuffer();
        if (bd.signum() == -1) {
            st.append("-");
        }
        String[] nums = subString.split("-");
        int length = Integer.valueOf(nums[1]);
        for (int i = 0; i < length; ++i) {
            if (i == 1) {
                st.append(".");
            }
            st.append("0");
        }
        st.append(bd.unscaledValue().abs());
        return st.toString();
    }
}

