/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectListener;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.scm.im.inv.MaterialSNInventoryInfo;
import com.kingdee.eas.scm.im.inv.client.AbstractConsignMaterialSerialSelectUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class ConsignMaterialSerialSelectUI
extends AbstractConsignMaterialSerialSelectUI {
    private static final Logger logger = CoreUIObject.getLogger(ConsignMaterialSerialSelectUI.class);
    private static final String FMATERIALNUMBER = "FMaterialNumber";
    private static final String FMATERIALNAME = "FMaterialName";
    private static final String FUNIT = "FUnitName";
    private static final String FAPPORTIONBALANCEQTY = "FApportionBalanceQty";
    private static final String TB_SERIALNUMBER = "serialNumber";
    private static final String TB_STATUS = "status";
    private static final String TB_SELECT = "select";
    private List<String> selectedSNList = new ArrayList<String>();
    private boolean isCanceled = true;

    public ConsignMaterialSerialSelectUI() throws Exception {
        this.kdtEntry.checkParsed();
        this.kdtEntry.addKDTSelectListener(new KDTSelectListener(){

            public void tableSelectChanged(KDTSelectEvent e) {
                int beginRow = 0;
                int endRow = 0;
                ArrayList blocks = ConsignMaterialSerialSelectUI.this.kdtEntry.getSelectManager().getBlocks();
                if (blocks != null) {
                    for (int i = 0; i < blocks.size(); ++i) {
                        beginRow = ((KDTSelectBlock)blocks.get(i)).getBeginRow();
                        endRow = ((KDTSelectBlock)blocks.get(i)).getEndRow();
                        if (beginRow < 0 || endRow - beginRow <= 0) {
                            return;
                        }
                        for (int j = beginRow; j <= endRow; ++j) {
                            Boolean isSelect = (Boolean)ConsignMaterialSerialSelectUI.this.kdtEntry.getRow(j).getCell(ConsignMaterialSerialSelectUI.TB_SELECT).getValue();
                            if (isSelect.booleanValue()) continue;
                            ConsignMaterialSerialSelectUI.this.kdtEntry.getRow(j).getCell(ConsignMaterialSerialSelectUI.TB_SELECT).setValue((Object)Boolean.TRUE);
                        }
                    }
                }
            }
        });
    }

    public void init(Map hm) {
        this.txtMateialNumber.setText(hm.get(FMATERIALNUMBER).toString());
        this.txtMateialName.setText(hm.get(FMATERIALNAME).toString());
        this.prmtSnUnit.setText(hm.get(FUNIT).toString());
        this.txtSNQuantity.setValue((Object)((BigDecimal)hm.get(FAPPORTIONBALANCEQTY)));
        this.kdtEntry.removeRows();
        List snList = (List)hm.get("snList");
        MaterialSNInventoryInfo info = null;
        for (int i = 0; i < snList.size(); ++i) {
            info = (MaterialSNInventoryInfo)snList.get(i);
            IRow row = this.kdtEntry.addRow();
            row.getCell(TB_SERIALNUMBER).setValue((Object)info.getSerialNumber());
            row.getCell(TB_STATUS).setValue((Object)info.getSnStatus().getAlias());
            if (info.getBoolean("selected")) {
                row.getCell(TB_SELECT).setValue((Object)true);
                continue;
            }
            row.getCell(TB_SELECT).setValue((Object)false);
        }
    }

    @Override
    protected void btnOK_actionPerformed(ActionEvent e) throws Exception {
        this.isCanceled = false;
        this.selectedSNList.clear();
        for (int i = 0; i < this.kdtEntry.getRowCount3(); ++i) {
            IRow row = this.kdtEntry.getRow(i);
            if (!((Boolean)row.getCell(TB_SELECT).getValue()).booleanValue()) continue;
            this.selectedSNList.add(row.getCell(TB_SERIALNUMBER).getValue().toString());
        }
        if (this.selectedSNList.size() == 0) {
            MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.scm.im.inv.SerialNumberResource", (String)"Select_SN"));
            SysUtil.abort();
        }
        Integer selectSize = (Integer)this.txtSNQuantity.getValue(Integer.class);
        if (this.selectedSNList.size() > selectSize) {
            MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.scm.im.inv.SerialNumberResource", (String)"SN_Count_Error"));
            SysUtil.abort();
        }
        this.disposeUIWindow();
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        this.isCanceled = true;
        this.disposeUIWindow();
    }

    @Override
    public void actionSelectAll_actionPerformed(ActionEvent e) throws Exception {
        for (int i = 0; i < this.kdtEntry.getRowCount3(); ++i) {
            this.kdtEntry.getRow(i).getCell(TB_SELECT).setValue((Object)true);
        }
    }

    @Override
    public void actionClearAll_actionPerformed(ActionEvent e) throws Exception {
        for (int i = 0; i < this.kdtEntry.getRowCount3(); ++i) {
            this.kdtEntry.getRow(i).getCell(TB_SELECT).setValue((Object)false);
        }
    }

    public List<String> getSelectedSN() {
        return this.selectedSNList;
    }

    public boolean isCanceled() {
        return this.isCanceled;
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnClearAll.setIcon(EASResource.getIcon((String)"imgTbtn_deleteall"));
        this.menuItemClearAll.setIcon(EASResource.getIcon((String)"imgTbtn_deleteall"));
        this.btnSelectAll.setIcon(EASResource.getIcon((String)"imgTbtn_selectall"));
        this.menuItemSelectAll.setIcon(EASResource.getIcon((String)"imgTbtn_selectall"));
    }
}

