/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.KDTableHelper;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseListener;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.master.material.IMaterial;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.scm.im.inv.ILocation;
import com.kingdee.eas.basedata.scm.im.inv.IWarehouse;
import com.kingdee.eas.basedata.scm.im.inv.LocationFactory;
import com.kingdee.eas.basedata.scm.im.inv.LocationInfo;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseFactory;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseInfo;
import com.kingdee.eas.framework.CoreBillEntryBaseInfo;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.im.inv.CountingFilterOptionEnum;
import com.kingdee.eas.scm.im.inv.CountingListLocationCollection;
import com.kingdee.eas.scm.im.inv.CountingListLocationInfo;
import com.kingdee.eas.scm.im.inv.CountingListMaterialCollection;
import com.kingdee.eas.scm.im.inv.CountingListMaterialInfo;
import com.kingdee.eas.scm.im.inv.CountingListWarehouseCollection;
import com.kingdee.eas.scm.im.inv.CountingListWarehouseInfo;
import com.kingdee.eas.scm.im.inv.CountingTaskInfo;
import com.kingdee.eas.scm.im.inv.client.AbstractCountingOptionSelectUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.event.ActionEvent;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.log4j.Logger;

public class CountingOptionSelectUI
extends AbstractCountingOptionSelectUI {
    private static final Logger logger = CoreUIObject.getLogger(CountingOptionSelectUI.class);
    protected IMetaDataPK mainQueryPK;
    protected FilterInfo filterInfo = new FilterInfo();
    protected FilterInfo initFilterInfo = new FilterInfo();
    protected ArrayList selectIDList = new ArrayList();
    protected ArrayList oldSelectIDList = new ArrayList();
    protected IObjectCollection coll = null;
    protected int type = 0;
    public static final int WAREHOUSE = 1;
    public static final int LOCATION = 2;
    public static final int MATERIAL = 3;
    protected boolean selectOrExclude = true;
    protected CountingTaskInfo countingTaskInfo;
    protected boolean editable = true;
    private static final String[] NOMATERIAL_HIDECOLS = new String[]{"model", "helpCode", "baseUnit"};

    public void onLoad() throws Exception {
        super.onLoad();
        this.kDCheckBox1.setSelected(true);
        this.kDTableAll.checkParsed();
        this.kDTableAll.setEditable(false);
        this.kDTableAll.getSelectManager().setSelectMode(10);
        this.kDTableSelect.checkParsed();
        this.kDTableSelect.setEditable(false);
        this.kDTableSelect.getSelectManager().setSelectMode(10);
        this.txtFilterCondition.setText(null);
        this.kDTableSelect.addKDTMouseListener(new KDTMouseListener(){

            public void tableClicked(KDTMouseEvent e) {
                if (e.getClickCount() == 2) {
                    CountingOptionSelectUI.this.deleteSelectItems();
                }
            }
        });
        this.kDTableAll.addKDTMouseListener(new KDTMouseListener(){

            public void tableClicked(KDTMouseEvent e) {
                if (e.getClickCount() == 2) {
                    CountingOptionSelectUI.this.addSelectItems();
                }
            }
        });
    }

    public void setMainQueryPK(IMetaDataPK pk) {
        this.mainQueryPK = pk;
    }

    public void setSelectOrExcludeTag(boolean tag) {
        this.selectOrExclude = tag;
    }

    public void setCountingTaskInfo(CountingTaskInfo countingTaskInfo) {
        this.countingTaskInfo = countingTaskInfo;
    }

    public void initTypeTag() {
        if (this.coll == null) {
            return;
        }
        if (this.coll instanceof CountingListWarehouseCollection) {
            this.type = 1;
        } else if (this.coll instanceof CountingListLocationCollection) {
            this.type = 2;
        } else if (this.coll instanceof CountingListMaterialCollection) {
            this.type = 3;
        }
    }

    public void setSelectTableRows(CoreBillEntryBaseInfo coreEntryBaseInfo, String id, String number, String name) {
        IRow row = this.kDTableSelect.addRow();
        row.setUserObject((Object)coreEntryBaseInfo);
        row.getCell("id").setValue((Object)id);
        row.getCell("number").setValue((Object)number);
        row.getCell("name").setValue((Object)name);
    }

    public void setSelectTableRowsByMaterial(CoreBillEntryBaseInfo coreEntryBaseInfo, IRow row1) {
        IRow row = this.kDTableSelect.addRow();
        row.setUserObject((Object)coreEntryBaseInfo);
        row.getCell("id").setValue(row1.getCell("id").getValue());
        row.getCell("number").setValue(row1.getCell("number").getValue());
        row.getCell("name").setValue(row1.getCell("name").getValue());
        row.getCell("model").setValue(row1.getCell("model").getValue());
        row.getCell("helpCode").setValue(row1.getCell("helpCode").getValue());
        row.getCell("baseUnit").setValue(row1.getCell("baseUnit").getValue());
    }

    public void setSelectTableRowsByMaterial(CoreBillEntryBaseInfo coreEntryBaseInfo, MaterialInfo materialInfo) {
        IRow row = this.kDTableSelect.addRow();
        row.setUserObject((Object)coreEntryBaseInfo);
        row.getCell("id").setValue((Object)materialInfo.getId().toString());
        row.getCell("number").setValue((Object)materialInfo.getNumber());
        row.getCell("name").setValue((Object)materialInfo.getName());
        row.getCell("model").setValue((Object)materialInfo.getModel());
        row.getCell("helpCode").setValue((Object)materialInfo.getHelpCode());
        row.getCell("baseUnit").setValue((Object)materialInfo.getBaseUnit().getName());
    }

    private void addSelectItems() {
        int size = this.kDTableAll.getSelectManager().size();
        if (size == 0 || this.kDTableAll.getSelectManager().getActiveRowIndex() < 0) {
            return;
        }
        for (int j = 0; j < size; ++j) {
            int topIndex;
            KDTSelectBlock selectBlock = this.kDTableAll.getSelectManager().get(j);
            int bottomIndex = selectBlock.getBottom();
            for (int i = topIndex = selectBlock.getTop(); i <= bottomIndex; ++i) {
                IRow row = this.kDTableAll.getRow(i);
                String keyValue = row.getCell("id").getValue().toString();
                if (this.selectIDList.contains(keyValue)) continue;
                CoreBillEntryBaseInfo coreBillEntryBaseInfo = null;
                if (this.type == 1) {
                    coreBillEntryBaseInfo = new CountingListWarehouseInfo();
                } else if (this.type == 2) {
                    coreBillEntryBaseInfo = new CountingListLocationInfo();
                } else if (this.type == 3) {
                    coreBillEntryBaseInfo = new CountingListMaterialInfo();
                }
                this.selectIDList.add(keyValue);
                if (this.type != 3) {
                    Object nameO = row.getCell("name").getValue();
                    String name = nameO == null ? null : nameO.toString();
                    this.setSelectTableRows(coreBillEntryBaseInfo, keyValue, row.getCell("number").getValue().toString(), name);
                    continue;
                }
                this.setSelectTableRowsByMaterial(coreBillEntryBaseInfo, row);
            }
        }
    }

    private void deleteSelectItems() {
        int size = this.kDTableSelect.getSelectManager().size();
        if (size == 0 || this.kDTableSelect.getSelectManager().getActiveRowIndex() < 0) {
            return;
        }
        for (int j = size - 1; j >= 0; --j) {
            KDTSelectBlock selectBlock = this.kDTableSelect.getSelectManager().get(j);
            int bottomIndex = selectBlock.getBottom();
            int topIndex = selectBlock.getTop();
            for (int i = bottomIndex; i >= topIndex; --i) {
                IRow row = this.kDTableSelect.getRow(i);
                String keyValue = row.getCell("id").getValue().toString();
                this.selectIDList.remove(keyValue);
                int index = this.searchRowIndex(keyValue);
                this.kDTableSelect.removeRow(index);
            }
        }
        this.kDTableSelect.getSelectManager().removeAll();
    }

    private int searchRowIndex(String id) {
        for (int i = 0; i < this.kDTableSelect.getRowCount(); ++i) {
            if (!this.kDTableSelect.getRow(i).getCell("id").getValue().toString().equals(id)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void executQuery() throws BOSException, Exception, SQLException {
        int count = this.getQueryExecutor(this.mainQueryPK, this.getEntityViewInfo()).getRowCount();
        this.kDTableAll.removeRows();
        Collection coll = null;
        if (count > 100000) {
            int pageSize = 10000;
            int page = 0;
            if (count > 0) {
                page = count % pageSize == 0 ? count / pageSize : count / pageSize + 1;
                int from = 0;
                int len = pageSize;
                IRowSet rowSet = null;
                for (int i = 0; i < page; ++i) {
                    from = i * pageSize;
                    if (i == page - 1) {
                        len = count - from;
                    }
                    if ((coll = (rowSet = this.getQueryExecutor(this.mainQueryPK, this.getEntityViewInfo()).executeQuery(from, len)).toCollection()).size() == 0) continue;
                    Collection[] colls = new Collection[coll.size()];
                    System.arraycopy(coll.toArray(), 0, colls, 0, coll.size());
                    KDTableHelper.addRows((KDTable)this.kDTableAll, (Collection[])colls);
                }
            }
        } else {
            IRowSet rowSet = this.getQueryExecutor(this.mainQueryPK, this.getEntityViewInfo()).executeQuery();
            coll = rowSet.toCollection();
            if (coll.size() != 0) {
                Collection[] colls = new Collection[coll.size()];
                System.arraycopy(coll.toArray(), 0, colls, 0, coll.size());
                KDTableHelper.addRows((KDTable)this.kDTableAll, (Collection[])colls);
            }
        }
    }

    protected IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo) {
        IQueryExecutor exec = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)queryPK);
        exec.setObjectView(viewInfo);
        exec.option().isAutoIgnoreZero = true;
        exec.option().isAutoTranslateBoolean = true;
        exec.option().isAutoTranslateEnum = true;
        exec.option().topCount = 9999;
        return exec;
    }

    public EntityViewInfo getEntityViewInfo() throws Exception {
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        entityViewInfo.getSelector().add(new SelectorItemInfo("id"));
        entityViewInfo.getSelector().add(new SelectorItemInfo("number"));
        entityViewInfo.getSelector().add(new SelectorItemInfo("name"));
        if (this.type == 3) {
            entityViewInfo.getSelector().add(new SelectorItemInfo("model"));
            entityViewInfo.getSelector().add(new SelectorItemInfo("helpCode"));
            entityViewInfo.getSelector().add(new SelectorItemInfo("baseUnit.name"));
            SorterItemCollection sic = new SorterItemCollection();
            SorterItemInfo number = new SorterItemInfo("number");
            SorterItemInfo name = new SorterItemInfo("name");
            SorterItemInfo helpCode = new SorterItemInfo("helpCode");
            number.setSortType(SortType.ASCEND);
            name.setSortType(SortType.ASCEND);
            helpCode.setSortType(SortType.ASCEND);
            sic.add(number);
            sic.add(name);
            sic.add(helpCode);
            entityViewInfo.setSorter(sic);
        }
        entityViewInfo.setFilter(this.filterInfo);
        return entityViewInfo;
    }

    public void setCtrlNotUsed() throws Exception {
        this.comboFilterCondition.setEditable(false);
        this.btnSearch.setEnabled(false);
        this.btnSelectItems.setEnabled(false);
        this.btnSelectAll.setEnabled(false);
        this.btnDelectItems.setEnabled(false);
        this.btnDelectAll.setEnabled(false);
        this.txtFilterCondition.setEditable(false);
    }

    public void disply() throws Exception {
        if (this.type != 3) {
            SCMClientUtils.hideColumns((KDTable)this.kDTableAll, (String[])NOMATERIAL_HIDECOLS, (boolean)true);
            SCMClientUtils.hideColumns((KDTable)this.kDTableSelect, (String[])NOMATERIAL_HIDECOLS, (boolean)true);
            this.comboFilterCondition.removeItemAt(0);
            this.comboFilterCondition.removeItemAt(2);
            this.comboFilterCondition.removeItemAt(2);
            this.comboFilterCondition.removeItemAt(2);
        }
        IObjectCollection coll = this.getColl();
        this.selectIDList.clear();
        this.kDTableSelect.removeRows();
        if (coll == null) {
            return;
        }
        for (Object o : coll) {
            CountingListMaterialInfo aCountingListMaterialInfo;
            MaterialInfo aMaterialInfo;
            if (this.type == 1) {
                CountingListWarehouseInfo aCountingListWarehouseInfo = (CountingListWarehouseInfo)o;
                WarehouseInfo aWarehouseInfo = aCountingListWarehouseInfo.getWarehouse();
                if (aWarehouseInfo == null) continue;
                IWarehouse iWarehouse = WarehouseFactory.getRemoteInstance();
                aWarehouseInfo = iWarehouse.getWarehouseInfo((IObjectPK)new ObjectUuidPK(aWarehouseInfo.getId()));
                this.selectIDList.add(aWarehouseInfo.getId().toString());
                this.setSelectTableRows(aCountingListWarehouseInfo, aWarehouseInfo.getId().toString(), aWarehouseInfo.getNumber(), aWarehouseInfo.getName());
                continue;
            }
            if (this.type == 2) {
                CountingListLocationInfo aCountingListLocationInfo = (CountingListLocationInfo)o;
                LocationInfo aLocationInfo = aCountingListLocationInfo.getLocation();
                if (aLocationInfo == null) continue;
                ILocation iLocation = LocationFactory.getRemoteInstance();
                aLocationInfo = iLocation.getLocationInfo((IObjectPK)new ObjectUuidPK(aLocationInfo.getId()));
                this.selectIDList.add(aLocationInfo.getId().toString());
                this.setSelectTableRows(aCountingListLocationInfo, aLocationInfo.getId().toString(), aLocationInfo.getNumber(), aLocationInfo.getName());
                continue;
            }
            if (this.type != 3 || (aMaterialInfo = (aCountingListMaterialInfo = (CountingListMaterialInfo)o).getMaterial()) == null) continue;
            IMaterial iMaterial = MaterialFactory.getRemoteInstance();
            aMaterialInfo = iMaterial.getMaterialInfo((IObjectPK)new ObjectUuidPK(aMaterialInfo.getId()));
            this.selectIDList.add(aMaterialInfo.getId().toString());
            this.setSelectTableRowsByMaterial((CoreBillEntryBaseInfo)aCountingListMaterialInfo, aMaterialInfo);
        }
    }

    public void initFilterInfo(FilterInfo filterInfo) {
        this.filterInfo = (FilterInfo)filterInfo.clone();
        this.initFilterInfo = (FilterInfo)filterInfo.clone();
    }

    public void setFilterInfo() {
        boolean isLikeSer = this.kDCheckBox1.isSelected();
        if (this.txtFilterCondition.getText().trim().length() != 0) {
            if (this.comboFilterCondition.getSelectedItem().equals((Object)CountingFilterOptionEnum.Number)) {
                if (isLikeSer) {
                    this.filterInfo.getFilterItems().add(new FilterItemInfo("number", (Object)("%" + this.txtFilterCondition.getText() + "%"), CompareType.LIKE));
                } else {
                    this.filterInfo.getFilterItems().add(new FilterItemInfo("number", (Object)this.txtFilterCondition.getText(), CompareType.EQUALS));
                }
            } else if (this.comboFilterCondition.getSelectedItem().equals((Object)CountingFilterOptionEnum.Name)) {
                if (isLikeSer) {
                    this.filterInfo.getFilterItems().add(new FilterItemInfo("name", (Object)("%" + this.txtFilterCondition.getText() + "%"), CompareType.LIKE));
                } else {
                    this.filterInfo.getFilterItems().add(new FilterItemInfo("name", (Object)this.txtFilterCondition.getText(), CompareType.EQUALS));
                }
            } else if (this.comboFilterCondition.getSelectedItem().equals((Object)CountingFilterOptionEnum.Model)) {
                if (isLikeSer) {
                    this.filterInfo.getFilterItems().add(new FilterItemInfo("model", (Object)("%" + this.txtFilterCondition.getText() + "%"), CompareType.LIKE));
                } else {
                    this.filterInfo.getFilterItems().add(new FilterItemInfo("model", (Object)this.txtFilterCondition.getText(), CompareType.EQUALS));
                }
            } else if (this.comboFilterCondition.getSelectedItem().equals((Object)CountingFilterOptionEnum.HelpCode)) {
                if (isLikeSer) {
                    this.filterInfo.getFilterItems().add(new FilterItemInfo("helpCode", (Object)("%" + this.txtFilterCondition.getText() + "%"), CompareType.LIKE));
                } else {
                    this.filterInfo.getFilterItems().add(new FilterItemInfo("helpCode", (Object)this.txtFilterCondition.getText(), CompareType.EQUALS));
                }
            } else if (this.comboFilterCondition.getSelectedItem().equals((Object)CountingFilterOptionEnum.BaseUnit)) {
                if (isLikeSer) {
                    this.filterInfo.getFilterItems().add(new FilterItemInfo("baseUnit.name", (Object)("%" + this.txtFilterCondition.getText() + "%"), CompareType.LIKE));
                } else {
                    this.filterInfo.getFilterItems().add(new FilterItemInfo("baseUnit.name", (Object)this.txtFilterCondition.getText(), CompareType.EQUALS));
                }
            } else if (this.comboFilterCondition.getSelectedItem().equals((Object)CountingFilterOptionEnum.NumberAndName)) {
                if (isLikeSer) {
                    this.filterInfo.getFilterItems().add(new FilterItemInfo("number", (Object)("%" + this.txtFilterCondition.getText() + "%"), CompareType.LIKE));
                    this.filterInfo.getFilterItems().add(new FilterItemInfo("name", (Object)("%" + this.txtFilterCondition.getText() + "%"), CompareType.LIKE));
                    this.filterInfo.setMaskString("#0 and (#1 or #2) ");
                } else {
                    this.filterInfo.getFilterItems().add(new FilterItemInfo("number", (Object)this.txtFilterCondition.getText(), CompareType.EQUALS));
                    this.filterInfo.getFilterItems().add(new FilterItemInfo("name", (Object)this.txtFilterCondition.getText(), CompareType.EQUALS));
                    this.filterInfo.setMaskString("#0 and (#1 or #2) ");
                }
            }
        }
    }

    @Override
    protected void btnSearch_actionPerformed(ActionEvent e) throws Exception {
        super.btnSearch_actionPerformed(e);
        this.filterInfo = new FilterInfo();
        this.filterInfo = (FilterInfo)this.initFilterInfo.clone();
        this.setFilterInfo();
        this.executQuery();
        this.kDTableAll.reLayoutAndPaint();
    }

    @Override
    protected void btnSelectItems_actionPerformed(ActionEvent e) throws Exception {
        super.btnSelectItems_actionPerformed(e);
        this.addSelectItems();
    }

    @Override
    protected void btnSelectAll_actionPerformed(ActionEvent e) throws Exception {
        super.btnSelectAll_actionPerformed(e);
        this.kDTableAll.getSelectManager().select(0, 0, this.kDTableAll.getRowCount(), 1);
        this.addSelectItems();
        this.kDTableAll.getSelectManager().select(-1, -1);
    }

    @Override
    protected void btnDelectItems_actionPerformed(ActionEvent e) throws Exception {
        super.btnDelectItems_actionPerformed(e);
        this.deleteSelectItems();
    }

    @Override
    protected void btnDelectAll_actionPerformed(ActionEvent e) throws Exception {
        super.btnDelectAll_actionPerformed(e);
        this.selectIDList.clear();
        this.kDTableAll.getSelectManager().select(0, 0, 0, 1);
        this.kDTableSelect.refresh();
    }

    public IObjectCollection getColl() {
        return this.coll;
    }

    public void setColl(IObjectCollection coll) {
        this.coll = coll;
    }

    public void setType(int type) {
        this.type = type;
    }

    public void setCollectios() throws Exception {
        if (this.coll == null) {
            return;
        }
        this.coll.clear();
        int size = this.selectIDList.size();
        for (int i = 0; i < size; ++i) {
            BOSUuid bosID;
            if (this.type == 1) {
                CountingListWarehouseInfo warehouseInfo = (CountingListWarehouseInfo)this.kDTableSelect.getRow(i).getUserObject();
                if (warehouseInfo.getWarehouse() == null) {
                    String warehouseID = this.kDTableSelect.getRow(i).getCell("id").getValue().toString();
                    bosID = BOSUuid.read((String)warehouseID);
                    IWarehouse iWarehouse = WarehouseFactory.getRemoteInstance();
                    WarehouseInfo aWarehouse = iWarehouse.getWarehouseInfo((IObjectPK)new ObjectUuidPK(bosID));
                    warehouseInfo.setSeq(i);
                    warehouseInfo.setSelectOrExclude(this.selectOrExclude);
                    warehouseInfo.setWarehouse(aWarehouse);
                    warehouseInfo.setCountingTask(this.countingTaskInfo);
                    this.coll.addObject((IObjectValue)warehouseInfo);
                    continue;
                }
                this.coll.addObject((IObjectValue)warehouseInfo);
                continue;
            }
            if (this.type == 2) {
                CountingListLocationInfo locationInfo = (CountingListLocationInfo)this.kDTableSelect.getRow(i).getUserObject();
                if (locationInfo.getLocation() == null) {
                    String locationID = this.kDTableSelect.getRow(i).getCell("id").getValue().toString();
                    bosID = BOSUuid.read((String)locationID);
                    ILocation iLocation = LocationFactory.getRemoteInstance();
                    LocationInfo aLocation = iLocation.getLocationInfo((IObjectPK)new ObjectUuidPK(bosID));
                    locationInfo.setSeq(i);
                    locationInfo.setSelectOrExclude(this.selectOrExclude);
                    locationInfo.setLocation(aLocation);
                    locationInfo.setCountingTask(this.countingTaskInfo);
                    this.coll.addObject((IObjectValue)locationInfo);
                    continue;
                }
                this.coll.addObject((IObjectValue)locationInfo);
                continue;
            }
            if (this.type != 3) continue;
            CountingListMaterialInfo materialInfo = (CountingListMaterialInfo)this.kDTableSelect.getRow(i).getUserObject();
            if (materialInfo.getMaterial() == null) {
                String materialID = this.kDTableSelect.getRow(i).getCell("id").getValue().toString();
                bosID = BOSUuid.read((String)materialID);
                IMaterial iMaterial = MaterialFactory.getRemoteInstance();
                MaterialInfo aMaterial = iMaterial.getMaterialInfo((IObjectPK)new ObjectUuidPK(bosID));
                materialInfo.setSeq(i);
                materialInfo.setSelectOrExclude(this.selectOrExclude);
                materialInfo.setMaterial(aMaterial);
                materialInfo.setCountingTask(this.countingTaskInfo);
                this.coll.addObject((IObjectValue)materialInfo);
                continue;
            }
            this.coll.addObject((IObjectValue)materialInfo);
        }
    }

    @Override
    protected void btnConfirm_actionPerformed(ActionEvent e) throws Exception {
        int size = this.selectIDList.size();
        if (size > 500) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.scm.im.inv.CountingResource", (String)"ListAccountCannotGreattorThanfiveHan"));
            SysUtil.abort();
        } else {
            if (this.editable) {
                this.setCollectios();
            }
            this.actionExitCurrent_actionPerformed(e);
        }
    }

    public void actionExitCurrent_actionPerformed(ActionEvent e) throws Exception {
        super.actionExitCurrent_actionPerformed(e);
    }

    public int getType() {
        return this.type;
    }
}

