/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.basedata.assistant.MeasureUnitFactory;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitInfo;
import com.kingdee.eas.framework.report.util.KDTableInsertHandler;
import com.kingdee.eas.framework.report.util.KDTableUtil;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.scm.common.util.StringUtil;
import com.kingdee.eas.scm.im.inv.CountingTableFactory;
import com.kingdee.eas.scm.im.inv.client.AbstractCountingTableBillAdjustUI;
import com.kingdee.eas.scm.im.inv.client.InvClientUtils;
import com.kingdee.eas.scm.util.numeric.PrecisionUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.util.BaseException;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.HashMap;
import javax.swing.JCheckBox;

public class CountingTableBillAdjustUI
extends AbstractCountingTableBillAdjustUI {
    private static final long serialVersionUID = 1L;
    protected HashMap hmQueryCon = new HashMap();
    protected HashMap resultQty = new HashMap();
    private static final String IS_BASEUNIT_UPDATE = "isBaseUpdate";
    protected boolean isSetBack = true;
    private static final BigDecimal zero = new BigDecimal("0.00");

    public CountingTableBillAdjustUI() throws Exception {
        this.resultQty.clear();
        this.tblMain.addKDTSelectListener(new KDTSelectListener(){

            public void tableSelectChanged(KDTSelectEvent e) {
            }
        });
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.tblMain.checkParsed();
        KDCheckBox checkBox = new KDCheckBox();
        this.tblMain.getColumn("isCheck").setEditor((ICellEditor)new KDTDefaultCellEditor((JCheckBox)checkBox));
        int freezeCol = this.tblMain.getColumnIndex("billNum");
        this.tblMain.getViewManager().setFreezeView(-1, freezeCol + 1);
        this.tHelper.setCanMoveColumn(false);
    }

    @Override
    public void actionSelectAll_actionPerformed(ActionEvent e) throws Exception {
        this.setValue(Boolean.TRUE);
        super.actionSelectAll_actionPerformed(e);
    }

    @Override
    public void actionClearAll_actionPerformed(ActionEvent e) throws Exception {
        this.setValue(Boolean.FALSE);
        super.actionClearAll_actionPerformed(e);
    }

    @Override
    public void actionSetAndBack_actionPerformed(ActionEvent e) throws Exception {
        super.actionSetAndBack_actionPerformed(e);
        HashMap param = new HashMap();
        param = this.getHmQueryCon();
        int count = this.tblMain.getRowCount();
        boolean isBaseUnitUpdate = (Boolean)param.get(IS_BASEUNIT_UPDATE);
        BigDecimal qty = zero;
        BigDecimal baseQty = zero;
        BigDecimal assQty = zero;
        BigDecimal result = zero;
        BigDecimal rsAssistQty = zero;
        BigDecimal flag = zero;
        IRow row = null;
        for (int i = 0; i < count && !(row = this.tblMain.getRow(i)).getCell("isCheck").getValue().equals(Boolean.TRUE); ++i) {
        }
        MeasureUnitInfo mu = null;
        MaterialInfo mi = null;
        MultiMeasureUnitInfo mulUnit = null;
        if (isBaseUnitUpdate) {
            mi = (MaterialInfo)param.get("MATERIAL");
            String aMeasureUnitID = (String)param.get("UNIT");
            if (aMeasureUnitID != null) {
                ObjectUuidPK pk = new ObjectUuidPK(aMeasureUnitID);
                try {
                    mu = MeasureUnitFactory.getRemoteInstance().getMeasureUnitInfo((IObjectPK)pk);
                }
                catch (BaseException be) {
                    ExceptionHandler.handle((Throwable)be);
                }
            }
        }
        Object o = null;
        String str = null;
        for (int i = 0; i < count; ++i) {
            row = this.tblMain.getRow(i);
            if (!row.getCell("isCheck").getValue().equals(Boolean.TRUE)) continue;
            o = row.getCell("flag").getValue();
            if (o != null && (str = o.toString()) != null && StringUtil.isNumber((String)str)) {
                flag = new BigDecimal(str);
            }
            if (!isBaseUnitUpdate) {
                qty = (BigDecimal)row.getCell("qty").getValue();
                result = result.add(qty.multiply(flag));
            } else {
                baseQty = (BigDecimal)row.getCell("baseQty").getValue();
                result = result.add(baseQty.multiply(flag));
            }
            assQty = (BigDecimal)row.getCell("assistQty").getValue();
            rsAssistQty = rsAssistQty.add(assQty.multiply(flag));
        }
        BigDecimal coefficient = new BigDecimal("1.00");
        if (isBaseUnitUpdate && mi != null && mu != null && (mulUnit = InvClientUtils.getMulUnit(mu, mi)) != null) {
            coefficient = mulUnit.getBaseConvsRate();
            int precision = mulUnit.getQtyPrecision();
            if (coefficient != null && coefficient.compareTo(zero) != 0) {
                result = result.divide(coefficient, precision, 4);
            }
        }
        this.getResultQty().put("adjustQty", result);
        this.getResultQty().put("adjustAssistQty", rsAssistQty);
        this.setSetBack(true);
        this.disposeUIWindow();
    }

    @Override
    public void actionButton_actionPerformed(ActionEvent e) throws Exception {
        this.setSetBack(false);
        this.disposeUIWindow();
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.setButtonDefaultStyl(this.btnSelectAll);
        this.btnSelectAll.setIcon(EASResource.getIcon((String)"imgTbtn_selectall"));
        this.setButtonDefaultStyl(this.btnClearAll);
        this.btnClearAll.setIcon(EASResource.getIcon((String)"imgTbtn_deleteall"));
    }

    private void setValue(Boolean value) {
        if (this.tblMain.getRowCount() == 0) {
            return;
        }
        int count = this.tblMain.getRowCount();
        for (int i = 0; i < count; ++i) {
            IRow row = this.tblMain.getRow(i);
            row.getCell("isCheck").setValue((Object)value);
        }
    }

    protected void disposeUIWindow() {
        super.disposeUIWindow();
    }

    public void executQuery() throws Exception {
        RptRowSet rowSet = CountingTableFactory.getRemoteInstance().getBillAdjustResultSet(this.getHmQueryCon());
        this.tblMain.removeRows();
        final String[] qtyFields = new String[]{"qty", "baseQty", "assistQty"};
        KDTableUtil.insertRows((RptRowSet)rowSet, (int)0, (KDTable)this.tblMain, (KDTableInsertHandler)new KDTableInsertHandler(){

            public void setTableRowData(IRow row, Object[] rowData) {
                int n = rowData.length - 3;
                for (int i = 1; i < n; ++i) {
                    row.getCell(i).setValue(rowData[i + 3]);
                    row.getCell(i).getStyleAttributes().setLocked(true);
                }
                row.getCell(0).setValue((Object)new Boolean(true));
                row.getCell(0).getStyleAttributes().setLocked(false);
                String fmtString = null;
                int len = qtyFields.length;
                for (int i = 0; i < len; ++i) {
                    fmtString = rowData[i] != null ? PrecisionUtil.getFmtString((int)((Number)rowData[i]).intValue()) : PrecisionUtil.getFmtString((int)0);
                    row.getCell(qtyFields[i]).getStyleAttributes().setNumberFormat(fmtString);
                }
            }
        });
    }

    public HashMap getHmQueryCon() {
        return this.hmQueryCon;
    }

    public void setHmQueryCon(HashMap hmQueryCon) {
        this.hmQueryCon = hmQueryCon;
    }

    public boolean isSetBack() {
        return this.isSetBack;
    }

    public void setSetBack(boolean isSetBack) {
        this.isSetBack = isSetBack;
    }

    public HashMap getResultQty() {
        return this.resultQty;
    }

    public void setResultQty(HashMap resultQty) {
        this.resultQty = resultQty;
    }
}

