/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IBlock;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.event.PreChangeEvent;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.IMeasureUnit;
import com.kingdee.eas.basedata.assistant.MeasureUnitFactory;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.master.material.AsstAttrValueInfo;
import com.kingdee.eas.basedata.master.material.IMultiMeasureUnit;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitCollection;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitFactory;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.scm.common.BillTypeFactory;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.basedata.scm.common.IBillType;
import com.kingdee.eas.basedata.scm.im.inv.LocationInfo;
import com.kingdee.eas.basedata.scm.im.inv.StoreStateInfo;
import com.kingdee.eas.basedata.scm.im.inv.StoreTypeInfo;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.ObjectValueUtil;
import com.kingdee.eas.mm.basedata.TrackNumberInfo;
import com.kingdee.eas.mm.common.client.UIHelper;
import com.kingdee.eas.mm.project.ProjectInfo;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.EntryBaseStatusEnum;
import com.kingdee.eas.scm.common.SCMFetchData;
import com.kingdee.eas.scm.common.client.BillOptionsHelper;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.client.config.InventorySumConditionInfo;
import com.kingdee.eas.scm.common.loadmass.SCMBizDataVO;
import com.kingdee.eas.scm.im.inv.DecomposeBillAgent;
import com.kingdee.eas.scm.im.inv.DecomposeBillFactory;
import com.kingdee.eas.scm.im.inv.DecomposeBillInfo;
import com.kingdee.eas.scm.im.inv.DecomposeEntryAgent;
import com.kingdee.eas.scm.im.inv.DecomposeEntryCollection;
import com.kingdee.eas.scm.im.inv.DecomposeEntryDetailAgent;
import com.kingdee.eas.scm.im.inv.DecomposeEntryDetailCollection;
import com.kingdee.eas.scm.im.inv.DecomposeEntryDetailInfo;
import com.kingdee.eas.scm.im.inv.DecomposeEntryInfo;
import com.kingdee.eas.scm.im.inv.IInventory;
import com.kingdee.eas.scm.im.inv.InventoryFactory;
import com.kingdee.eas.scm.im.inv.InventoryInfo;
import com.kingdee.eas.scm.im.inv.client.AbstractDecomposeBillEditUI;
import com.kingdee.eas.scm.im.inv.client.InvClientUtils;
import com.kingdee.eas.scm.util.filehandle.ResourceUtil;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.BaseException;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import javax.swing.JTextField;

public class DecomposeBillEditUI
extends AbstractDecomposeBillEditUI {
    private static final long serialVersionUID = 7331078614256313360L;
    private static final String MATERIALNUM = "materialNum";
    private static final String NUMBER = "number";
    private static final String MATERIALNAME = "materialName";
    private static final String MODEL = "model";
    private static final String ASSISTPROPERTY = "assistProperty";
    private static final String LOT = "lot";
    private static final String WAREHOUSE = "warehouse";
    private static final String LOCATION = "location";
    private static final String UNIT = "unit";
    private static final String EXP = "exp";
    private static final String QTY = "qty";
    private static final String COEFFICIENT = "coefficient";
    private static final String BASEQTY = "baseQty";
    private static final String BASEUNIT = "baseUnit";
    private static final String ASSISTQTY = "assistQty";
    private static final String ASSISTUNIT = "assistUnit";
    private static final String STORETYPE = "storeType";
    private static final String STORESTATUS = "storeStatus";
    private static final String CUSTOMER = "customer";
    private static final String SUPPLIER = "supplier";
    private static final String ID = "inventoryID";
    public static final String HMKEY = "DecomposeBillEditUI_hmKey";
    public static final String ALKEY = "DecomposeBillEditUI_alKey";
    private static final String TB_PROJECTNUM = "projectNumCol";
    private static final String TB_TRACKNUM = "trackNumCol";
    protected DecomposeEntryDetailHandle decomposeEntryDetailHandle = new DecomposeEntryDetailHandle();
    private ArrayList alShortQtyInvInfo;
    private HashMap hmShortQty = new HashMap();
    private boolean isManualAdd = true;
    private int curEntryRow = 0;
    private HashMap mulMeaUnits = new HashMap();

    @Override
    public void onLoad() throws Exception {
        if (this.getOprtState() == null) {
            this.setOprtState("ADDNEW");
        }
        this.kdtEntryDetail.checkParsed();
        this.bizInventory.setEnabledMultiSelection(true);
        super.onLoad();
        this.initControl();
        this.initTableControl(this.kdtEntry);
        this.initTableControl(this.kdtEntryDetail);
        if (this.kdtEntryDetail != null) {
            this.kdtEntryDetail.getSelectManager().setSelectMode(10);
            this.kdtEntryDetail.getActionMap().remove("AddRow");
            this.kdtEntryDetail.getActionMap().remove("RemoveRow");
            this.kdtEntryDetail.getActionMap().remove("Delete");
            this.kdtEntryDetail.getActionMap().remove("Paste");
        }
        this.kdtEntry.getActionMap().remove("Paste");
        if (this.getSCMBizDataVO() != null) {
            this.menuItemInvBillOptin.setVisible(true);
            this.menuItemInvBillOptin.setEnabled(true);
            this.assistForNumber = BillOptionsHelper.takeConfigType((HashMap)this.getSCMBizDataVO().getOptionConfigMap(), (String)"AssistForNumber", (boolean)true);
            this.numberForAssist = BillOptionsHelper.takeConfigType((HashMap)this.getSCMBizDataVO().getOptionConfigMap(), (String)"NumberForAssist", (boolean)false);
        }
        this.kdtEntry.getColumn(TB_PROJECTNUM).setEditor(null);
        UIHelper.registerProjectF7((KDBizPromptBox)this.getMainOrgUnit(), null, (KDTable)this.kdtEntry, (String)TB_PROJECTNUM);
        UIHelper.registerTrackNumberF7((KDBizPromptBox)this.getMainOrgUnit(), null, (KDTable)this.kdtEntry, (String)TB_PROJECTNUM, (String)TB_TRACKNUM, (boolean)false);
        this.kdtEntryDetail.getColumn(TB_PROJECTNUM).setEditor(null);
        UIHelper.registerProjectF7((KDBizPromptBox)this.getMainOrgUnit(), null, (KDTable)this.kdtEntryDetail, (String)TB_PROJECTNUM);
        UIHelper.registerTrackNumberF7((KDBizPromptBox)this.getMainOrgUnit(), null, (KDTable)this.kdtEntryDetail, (String)TB_PROJECTNUM, (String)TB_TRACKNUM, (boolean)false);
    }

    @Override
    public void onShow() throws Exception {
        super.onShow();
        if (this.getIsEditable()) {
            this.txtNumber.requestFocus();
        } else {
            this.prmtTransactionType.requestFocus();
        }
    }

    @Override
    public void actionDispNeedQty_actionPerformed(ActionEvent e) throws Exception {
        this.checkQtyLessShortQty();
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)HMKEY, (Object)this.hmShortQty);
        uiContext.put((Object)ALKEY, (Object)this.alShortQtyInvInfo);
        IUIWindow iUIWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create("com.kingdee.eas.scm.im.inv.client.DecompShortQtyListUI", (Map)uiContext, null);
        iUIWindow.show();
    }

    private boolean checkQtyLessShortQty() {
        if (this.alShortQtyInvInfo == null) {
            return true;
        }
        boolean isEnough = true;
        int recs = this.alShortQtyInvInfo.size();
        BigDecimal detailQty = InvClientUtils.ZERO;
        BigDecimal needlQty = InvClientUtils.ZERO;
        BigDecimal shortQty = InvClientUtils.ZERO;
        for (int i = 0; i < recs; ++i) {
            if (this.alShortQtyInvInfo.get(i) == null) continue;
            InventoryInfo inventoryInfo = (InventoryInfo)this.alShortQtyInvInfo.get(i);
            needlQty = inventoryInfo.getCurStoreQty();
            DecomposeEntryCollection dec = this.editData.getEntries();
            int decs = dec.size();
            for (int j = 0; j < decs; ++j) {
                DecomposeEntryInfo decomposeEntryInfo = dec.get(j);
                DecomposeEntryDetailCollection dedc = decomposeEntryInfo.getEntries();
                int dedcs = dedc.size();
                for (int k = 0; k < dedcs; ++k) {
                    DecomposeEntryDetailInfo decomposeEntryDetailInfo = dedc.get(k);
                    if (!ObjectValueUtil.objectValueEquals((AbstractObjectValue)decomposeEntryDetailInfo.getMaterial(), (AbstractObjectValue)inventoryInfo.getMaterial()) || !ObjectValueUtil.objectValueEquals((AbstractObjectValue)decomposeEntryDetailInfo.getAssistProperty(), (AbstractObjectValue)inventoryInfo.getAssistProperty()) || decomposeEntryDetailInfo.getLot() != inventoryInfo.getLot() || decomposeEntryDetailInfo.getExp() != inventoryInfo.getExp() || !ObjectValueUtil.objectValueEquals((AbstractObjectValue)decomposeEntryDetailInfo.getWarehouse(), (AbstractObjectValue)inventoryInfo.getWarehouse()) || !ObjectValueUtil.objectValueEquals((AbstractObjectValue)decomposeEntryDetailInfo.getLocation(), (AbstractObjectValue)inventoryInfo.getLocation()) || !decomposeEntryDetailInfo.getUnit().getId().equals((Object)inventoryInfo.getUnit().getId()) || !ObjectValueUtil.objectValueEquals((AbstractObjectValue)decomposeEntryDetailInfo.getStoreType(), (AbstractObjectValue)inventoryInfo.getStoretype()) || !ObjectValueUtil.objectValueEquals((AbstractObjectValue)decomposeEntryDetailInfo.getStoreStatus(), (AbstractObjectValue)inventoryInfo.getStorestatus()) || !ObjectValueUtil.objectValueEquals((AbstractObjectValue)decomposeEntryDetailInfo.getCustomer(), (AbstractObjectValue)inventoryInfo.getCustomer()) || !ObjectValueUtil.objectValueEquals((AbstractObjectValue)decomposeEntryDetailInfo.getSupplier(), (AbstractObjectValue)inventoryInfo.getSupplier())) continue;
                    detailQty = detailQty.add(decomposeEntryDetailInfo.getQty());
                }
            }
            shortQty = needlQty.subtract(detailQty);
            if (shortQty.compareTo(InvClientUtils.ZERO) > 0) {
                isEnough = false;
            }
            this.hmShortQty.put(inventoryInfo.getId().toString(), detailQty);
            detailQty = InvClientUtils.ZERO;
            needlQty = InvClientUtils.ZERO;
            shortQty = InvClientUtils.ZERO;
        }
        return isEnough;
    }

    @Override
    protected void beforeStoreFields(ActionEvent e) throws Exception {
        this.kdtEntry.getEditManager().stopEditing();
        this.dataBinder.storeFields();
        boolean isFrozenState = false;
        int n = this.kdtEntry.getRowCount();
        for (int i = 0; i < n; ++i) {
            StoreStateInfo storeState = (StoreStateInfo)this.kdtEntry.getCell(i, STORESTATUS).getValue();
            if (storeState == null || storeState.getId() == null || !"181875d5-2105-1000-e000-013dc0a812fd62A73FA5".equals(storeState.getId().toString())) continue;
            isFrozenState = true;
            break;
        }
        if (isFrozenState) {
            MsgBox.showInfo((Component)((Object)this), (String)InvClientUtils.getResource("isFrezenStatus"));
            SysUtil.abort();
        }
        if (e != null && e.getSource() != null && (e.getSource() == this.btnSave || e.getSource() == this.menuItemSave)) {
            return;
        }
        String strTemp = "";
        if (this.pkBizDate.getValue() == null) {
            strTemp = InvClientUtils.getResource("bizDateIsNull");
            this.pkBizDate.requestFocus();
            MsgBox.showInfo((Component)((Object)this), (String)strTemp.toString());
            SysUtil.abort();
        }
        if (this.prmtStorageOrgUnit.getData() == null) {
            strTemp = InvClientUtils.getResource("StorageOrgUnitNotNull");
            this.prmtStorageOrgUnit.requestFocus();
            MsgBox.showInfo((Component)((Object)this), (String)strTemp.toString());
            SysUtil.abort();
        }
        StringBuffer sb = new StringBuffer();
        StringBuffer sb2 = new StringBuffer();
        int msgTimes = -1;
        int msgTimes2 = -1;
        int rows = this.kdtEntry.getRowCount();
        if (rows > 0) {
            IRow iRow = null;
            DecomposeEntryInfo dei = null;
            for (int i = 0; i < rows; ++i) {
                BigDecimal assistQty;
                BigDecimal baseQty;
                iRow = this.kdtEntry.getRow(i);
                dei = (DecomposeEntryInfo)this.kdtEntry.getRow(i).getUserObject();
                if (dei.getEntries().size() <= 0 && ++msgTimes < 5) {
                    strTemp = ResourceUtil.getMessage((String)this.invAddResource, (String)"NOHASMULTIUNIT", (String[])new String[]{String.valueOf(i + 1)});
                    if (sb.toString().length() == 0) {
                        sb.append(strTemp);
                        this.kdtEntry.getSelectManager().select(i, 0);
                        this.kdtEntry.requestFocus();
                    } else {
                        sb.append("\n");
                        sb.append(strTemp);
                    }
                }
                if ((baseQty = (BigDecimal)iRow.getCell(BASEQTY).getValue()).compareTo(this.getDetailQty(dei, BASEQTY)) != 0 && ++msgTimes < 5) {
                    strTemp = ResourceUtil.getMessage((String)this.invAddResource, (String)"BASEQTYISNOTEQEUL", (String[])new String[]{String.valueOf(i + 1)});
                    if (sb.toString().length() == 0) {
                        sb.append(strTemp);
                        this.kdtEntry.getSelectManager().select(i, 0);
                        this.kdtEntry.requestFocus();
                    } else {
                        sb.append("\n");
                        sb.append(strTemp);
                    }
                }
                if (iRow.getCell(ASSISTUNIT).getValue() == null || (assistQty = (BigDecimal)iRow.getCell(ASSISTQTY).getValue()) == null || assistQty.compareTo(this.getDetailQty(dei, ASSISTQTY)) == 0 || ++msgTimes2 >= 5) continue;
                strTemp = ResourceUtil.getMessage((String)this.invAddResource, (String)"ASSISTQTYISNOTEQEUL", (String[])new String[]{String.valueOf(i + 1)});
                if (sb2.toString().length() == 0) {
                    sb2.append(strTemp);
                    this.kdtEntry.getSelectManager().select(i, 0);
                    this.kdtEntry.requestFocus();
                    continue;
                }
                sb2.append("\n");
                sb2.append(strTemp);
            }
            if (sb.toString().length() > 0) {
                MsgBox.showInfo((Component)((Object)this), (String)sb.toString());
                SysUtil.abort();
            }
            if (sb2.toString().length() > 0 && !MsgBox.isYes((int)MsgBox.showConfirm3((Component)((Object)this), (String)sb2.toString()))) {
                SysUtil.abort();
            }
        } else {
            strTemp = InvClientUtils.getResource("EntryIsNull");
            this.kdtEntry.requestFocus();
            MsgBox.showInfo((Component)((Object)this), (String)strTemp.toString());
            SysUtil.abort();
        }
    }

    private BigDecimal getDetailQty(DecomposeEntryInfo dei, String colName) {
        BigDecimal qty = InvClientUtils.ZERO;
        DecomposeEntryDetailInfo dedi = null;
        int rows = dei.getEntries().size();
        for (int i = 0; i < rows; ++i) {
            dedi = dei.getEntries().get(i);
            if (dedi == null) continue;
            if (colName.equalsIgnoreCase(BASEQTY)) {
                qty = qty.add(dedi.getBaseQty());
                continue;
            }
            if (!colName.equalsIgnoreCase(ASSISTQTY)) continue;
            qty = qty.add(dedi.getAssistQty() == null ? new BigDecimal("0.00") : dedi.getAssistQty());
        }
        return qty;
    }

    @Override
    public void setQtyBaseQtyAssisQty(KDTable kdTable, int row, int col) throws EASBizException, BOSException {
        BigDecimal assistQty;
        super.setQtyBaseQtyAssisQty(kdTable, row, col);
        if (col == kdTable.getColumnIndex(ASSISTQTY) && (assistQty = (BigDecimal)kdTable.getRow(row).getCell(ASSISTQTY).getValue()) == null) {
            kdTable.getRow(row).getCell(ASSISTQTY).setValue((Object)InvClientUtils.ZERO);
        }
        if (kdTable.equals(this.kdtEntryDetail) && col == kdTable.getColumnIndex(QTY)) {
            DecomposeEntryInfo dei = (DecomposeEntryInfo)this.kdtEntry.getRow(this.curEntryRow).getUserObject();
            DecomposeEntryDetailInfo dedi = dei.getEntries().get(row);
            dedi.setBaseQty((BigDecimal)kdTable.getCell(row, this.getBaseQtyName()).getValue());
            dedi.setAssistQty((BigDecimal)kdTable.getCell(row, this.getAssistQtyName()).getValue());
        }
    }

    private boolean checkExists(InventoryInfo inventoryInfo, boolean isFisrtEntry) {
        if (!isFisrtEntry) {
            return false;
        }
        int rows = this.kdtEntry.getRowCount();
        if (rows > 0) {
            for (int i = 0; i < rows; ++i) {
                IRow iRow = this.kdtEntry.getRow(i);
                if (!iRow.getCell(ID).getValue().toString().equals(inventoryInfo.getId().toString())) continue;
                return true;
            }
        }
        return false;
    }

    private MultiMeasureUnitCollection getMeasureUnitInfo(MaterialInfo mi, MeasureUnitInfo mui, MeasureUnitInfo muiAssist) throws BOSException {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("material", (Object)mi.getId().toString(), CompareType.EQUALS));
        fi.getFilterItems().add(new FilterItemInfo("measureUnit", (Object)mui.getId().toString(), CompareType.NOTEQUALS));
        if (muiAssist != null) {
            fi.getFilterItems().add(new FilterItemInfo("measureUnit", (Object)muiAssist.getId().toString(), CompareType.NOTEQUALS));
        }
        evi.setFilter(fi);
        IMultiMeasureUnit immu = MultiMeasureUnitFactory.getRemoteInstance();
        return immu.getMultiMeasureUnitCollection(evi);
    }

    private void setMaterialProperty(int rowIndex, MaterialInfo mi, MeasureUnitInfo mui, KDTable kDTable) {
        int[] updateRows = new int[]{rowIndex};
        if (mi != null) {
            try {
                MeasureUnitInfo muiBase = null;
                MeasureUnitInfo muiAssist = null;
                IMeasureUnit im = MeasureUnitFactory.getRemoteInstance();
                if (mi.getBaseUnit() != null) {
                    muiBase = im.getMeasureUnitInfo((IObjectPK)new ObjectUuidPK(mi.getBaseUnit().getId()));
                }
                if (mi.getAssistUnit() != null) {
                    muiAssist = im.getMeasureUnitInfo((IObjectPK)new ObjectUuidPK(mi.getAssistUnit().getId()));
                }
                IRow iRow = kDTable.getRow(rowIndex);
                iRow.getCell(NUMBER).setValue((Object)mi.getNumber());
                iRow.getCell(MATERIALNAME).setValue((Object)mi.getName());
                iRow.getCell(MODEL).setValue((Object)mi.getModel());
                iRow.getCell(BASEUNIT).setValue((Object)muiBase);
                String[] fileds = new String[]{QTY};
                if (this.mulMeaUnits.get(mi.getId().toString() + mui.getId().toString()) != null) {
                    SCMClientUtils.changeTableColPrecisionByMaterial((MultiMeasureUnitInfo)((MultiMeasureUnitInfo)this.mulMeaUnits.get(mi.getId().toString() + mui.getId().toString())), (KDTable)kDTable, (String[])fileds, (int[])updateRows);
                } else {
                    SCMClientUtils.changeTableColPrecisionByMaterial((MaterialInfo)mi, (MeasureUnitInfo)mui, (KDTable)kDTable, (String[])fileds, (int[])updateRows);
                }
                String[] filedsb = new String[]{BASEQTY};
                if (muiBase != null && this.mulMeaUnits.get(mi.getId().toString() + muiBase.getId().toString()) != null) {
                    SCMClientUtils.changeTableColPrecisionByMaterial((MultiMeasureUnitInfo)((MultiMeasureUnitInfo)this.mulMeaUnits.get(mi.getId().toString() + muiBase.getId().toString())), (KDTable)kDTable, (String[])filedsb, (int[])updateRows);
                } else {
                    SCMClientUtils.changeTableColPrecisionByMaterial((MaterialInfo)mi, (MeasureUnitInfo)muiBase, (KDTable)kDTable, (String[])filedsb, (int[])updateRows);
                }
                BigDecimal coefficient = InvClientUtils.ZERO;
                try {
                    coefficient = InvClientUtils.getCoefficient(mui, mi);
                }
                catch (BaseException e) {
                    this.handUIException(e);
                }
                coefficient = coefficient.setScale(6, 4);
                iRow.getCell(COEFFICIENT).setValue((Object)coefficient);
                SCMClientUtils.changeTableColPrecision((int)6, (KDTable)this.kdtEntry, (String[])new String[]{COEFFICIENT});
                if (muiAssist != null) {
                    iRow.getCell(ASSISTUNIT).setValue((Object)muiAssist);
                    String[] filedsa = new String[]{ASSISTQTY};
                    if (this.mulMeaUnits.get(mi.getId().toString() + muiAssist.getId().toString()) != null) {
                        SCMClientUtils.changeTableColPrecisionByMaterial((MultiMeasureUnitInfo)((MultiMeasureUnitInfo)this.mulMeaUnits.get(mi.getId().toString() + muiAssist.getId().toString())), (KDTable)kDTable, (String[])filedsa, (int[])updateRows);
                    } else {
                        SCMClientUtils.changeTableColPrecisionByMaterial((MaterialInfo)mi, (MeasureUnitInfo)muiAssist, (KDTable)kDTable, (String[])filedsa, (int[])updateRows);
                    }
                } else {
                    iRow.getCell(ASSISTQTY).setValue((Object)InvClientUtils.ZERO);
                    iRow.getCell(ASSISTQTY).getStyleAttributes().setLocked(true);
                    SCMClientUtils.changeCellPrecision((IRow)iRow, (String[])new String[]{ASSISTQTY}, (int)2);
                }
            }
            catch (EASBizException e) {
                this.handUIException(e);
            }
            catch (BOSException e) {
                this.handUIException(e);
            }
        }
    }

    private void initEntry() throws EASBizException, BOSException {
        int rows = this.kdtEntry.getRowCount();
        IRow iRow = null;
        for (int i = 0; i < rows; ++i) {
            iRow = this.kdtEntry.getRow(i);
            if (iRow == null) continue;
            MaterialInfo mi = (MaterialInfo)iRow.getCell(MATERIALNUM).getValue();
            MeasureUnitInfo mui = (MeasureUnitInfo)iRow.getCell(UNIT).getValue();
            this.setMaterialProperty(i, mi, mui, this.kdtEntry);
        }
        this.kdtEntry.getSelectManager().select(0, 0);
        this.curEntryRow = 0;
    }

    private int fillKDTable(KDTable kDTable, InventoryInfo inventoryInfo, boolean isFisrtEntry) {
        try {
            if (!this.checkExists(inventoryInfo, isFisrtEntry)) {
                this.addLine(kDTable);
                int curRow = kDTable.getRowCount() - 1;
                IRow iRow = kDTable.getRow(curRow);
                if (isFisrtEntry) {
                    String inventoryID = "";
                    inventoryID = inventoryInfo.getId().toString();
                    iRow.getCell(ID).setValue((Object)inventoryID);
                }
                MaterialInfo mi = inventoryInfo.getMaterial();
                iRow.getCell(MATERIALNUM).setValue((Object)mi);
                iRow.getCell(NUMBER).setValue((Object)mi.getNumber());
                MeasureUnitInfo mui = inventoryInfo.getUnit();
                iRow.getCell(UNIT).setValue((Object)mui);
                BigDecimal coefficient = InvClientUtils.getCoefficient(mui, mi);
                iRow.getCell(ASSISTPROPERTY).setValue((Object)inventoryInfo.getAssistProperty());
                iRow.getCell(LOT).setValue((Object)inventoryInfo.getLot());
                iRow.getCell(QTY).setValue((Object)inventoryInfo.getCurStoreQty());
                iRow.getCell(EXP).setValue((Object)inventoryInfo.getExp());
                iRow.getCell(COEFFICIENT).setValue((Object)coefficient);
                iRow.getCell(BASEQTY).setValue((Object)inventoryInfo.getBaseQty());
                iRow.getCell(ASSISTQTY).setValue((Object)inventoryInfo.getCurStoreAssistQty());
                iRow.getCell(WAREHOUSE).setValue((Object)inventoryInfo.getWarehouse());
                iRow.getCell(LOCATION).setValue((Object)inventoryInfo.getLocation());
                iRow.getCell(STORETYPE).setValue((Object)inventoryInfo.getStoretype());
                iRow.getCell(STORESTATUS).setValue((Object)inventoryInfo.getStorestatus());
                iRow.getCell(CUSTOMER).setValue((Object)inventoryInfo.getCustomer());
                iRow.getCell(SUPPLIER).setValue((Object)inventoryInfo.getSupplier());
                if (inventoryInfo.getProject() != null && inventoryInfo.getProject().getId() != null) {
                    iRow.getCell(TB_PROJECTNUM).setValue((Object)inventoryInfo.getProject());
                }
                iRow.getCell(TB_TRACKNUM).setValue((Object)inventoryInfo.getTrackNumber());
                this.setMaterialProperty(curRow, mi, mui, kDTable);
                return curRow;
            }
        }
        catch (BOSException e1) {
            this.handUIException(e1);
        }
        catch (BaseException e1) {
            this.handUIException(e1);
        }
        return -1;
    }

    @Override
    protected void bizInventoryPreChanged(PreChangeEvent e) {
        if (e.getData() == null) {
            return;
        }
        try {
            InventoryInfo[] inventoryInfos = null;
            if (e.getData() instanceof InventoryInfo[]) {
                inventoryInfos = (InventoryInfo[])e.getData();
            } else if (e.getData() instanceof InventoryInfo) {
                inventoryInfos = new InventoryInfo[]{(InventoryInfo)e.getData()};
            }
            if (inventoryInfos == null) {
                return;
            }
            for (InventoryInfo inventoryInfo : inventoryInfos) {
                this.setEntrysData(this.kdtEntry, inventoryInfo);
            }
            this.kdtEntry.getSelectManager().select(0, 0);
            this.curEntryRow = 0;
            this.prmtStorageOrgUnit.setEnabled(false);
            this.setUnitEntity();
        }
        catch (BOSException e1) {
            this.handUIException(e1);
        }
        catch (EASBizException e1) {
            this.handUIException(e1);
        }
    }

    protected void setEntrysData(KDTable kDtable, InventoryInfo inventoryInfo) throws EASBizException, BOSException {
        this.fillKDTable(kDtable, inventoryInfo, true);
    }

    public SelectorItemCollection getInvSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("material.*"));
        sic.add(new SelectorItemInfo(LOT));
        sic.add(new SelectorItemInfo("warehouse.*"));
        sic.add(new SelectorItemInfo("location.*"));
        sic.add(new SelectorItemInfo("unit.*"));
        sic.add(new SelectorItemInfo("assistUnit.*"));
        sic.add(new SelectorItemInfo("storetype.*"));
        sic.add(new SelectorItemInfo("storestatus.*"));
        sic.add(new SelectorItemInfo("storageOrgUnit.*"));
        sic.add(new SelectorItemInfo("supplier.*"));
        sic.add(new SelectorItemInfo("customer.*"));
        sic.add(new SelectorItemInfo("assistProperty.*"));
        sic.add(new SelectorItemInfo("project.id"));
        sic.add(new SelectorItemInfo("project.number"));
        sic.add(new SelectorItemInfo("project.name"));
        sic.add(new SelectorItemInfo("trackNumber.id"));
        sic.add(new SelectorItemInfo("trackNumber.number"));
        sic.add(new SelectorItemInfo("trackNumber.name"));
        return sic;
    }

    protected void setNewEntryData(ArrayList alInventory) throws Exception {
        IInventory iiv = InventoryFactory.getRemoteInstance();
        int recs = alInventory.size();
        SelectorItemCollection sic = this.getInvSelectors();
        for (int i = 0; i < recs; ++i) {
            ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)alInventory.get(i).toString()));
            InventoryInfo inventoryInfo = iiv.getInventoryInfo((IObjectPK)pk, sic);
            if (inventoryInfo.getCurStoreQty().compareTo(this.ZERO) <= 0) continue;
            this.setEntrysData(this.kdtEntry, inventoryInfo);
        }
        this.kdtEntry.getSelectManager().select(0, 0);
        this.curEntryRow = 0;
    }

    protected void setAlShortQtyInvInfo(ArrayList alObject) {
        this.alShortQtyInvInfo = alObject;
        this.btnDispNeedQty.setEnabled(true);
        this.menuItemDispNeedQty.setEnabled(true);
        this.isManualAdd = false;
    }

    @Override
    protected void kdtEntry_tableSelectChanged(KDTSelectEvent e) throws Exception {
        KDTSelectBlock kdtSel = e.getSelectBlock();
        this.curEntryRow = kdtSel.getBeginRow();
        this.refreshEntryDetail(this.curEntryRow);
        this.setUnitEntity();
    }

    @Override
    protected void kdtEntryDetail_editStopped(KDTEditEvent e) throws Exception {
        int row = e.getRowIndex();
        int col = e.getColIndex();
        IRow curRow = this.kdtEntryDetail.getRow(row);
        if (col == this.kdtEntryDetail.getColumnIndex(this.TB_UNIT)) {
            try {
                SCMClientUtils.changeCellPrecisionByMaterial((SCMFetchData)this.fetchData, (String[])new String[]{QTY}, (IRow)curRow, (boolean)this.isNegativeBill);
                this.fetchData.setCou(this.cou);
                BigDecimal baseQty = (BigDecimal)curRow.getCell(this.TB_BASEQTY).getValue();
                MeasureUnitInfo muInfo = (MeasureUnitInfo)curRow.getCell(this.TB_UNIT).getValue();
                MaterialInfo materialInfo = (MaterialInfo)curRow.getCell(this.TB_MATERIAL).getValue();
                BigDecimal unitQty = SCMClientUtils.getUnitQty((MeasureUnitInfo)muInfo, (MaterialInfo)materialInfo, (BigDecimal)baseQty, (SCMFetchData)this.fetchData);
                curRow.getCell(this.TB_QTY).setValue((Object)unitQty);
                this.setAssistQtyByQty(this.kdtEntryDetail, row, this.kdtEntryDetail.getColumnIndex(this.TB_QTY));
            }
            catch (Exception ex) {
                this.handUIException(ex);
            }
        }
        if (this.kdtEntryDetail.getRow(row).getCell(UNIT).getValue() != null) {
            this.kdtEntryDetail.getRow(row).getCell(QTY).getStyleAttributes().setLocked(false);
            if (null != this.kdtEntryDetail.getRow(row).getCell(ASSISTUNIT).getValue()) {
                this.kdtEntryDetail.getRow(row).getCell(ASSISTQTY).getStyleAttributes().setLocked(false);
            }
            BigDecimal coefficient = InvClientUtils.getCoefficient((MeasureUnitInfo)this.kdtEntryDetail.getRow(row).getCell(UNIT).getValue(), (MaterialInfo)this.kdtEntryDetail.getRow(row).getCell(MATERIALNUM).getValue());
            this.kdtEntryDetail.getRow(row).getCell(COEFFICIENT).setValue((Object)coefficient);
        } else {
            this.kdtEntryDetail.getRow(row).getCell(QTY).getStyleAttributes().setLocked(true);
            this.kdtEntryDetail.getRow(row).getCell(this.TB_BASEQTY).setValue((Object)this.ZERO);
        }
        this.setUnitEntity();
        this.setQtyBaseQtyAssisQty(this.kdtEntryDetail, row, col);
    }

    @Override
    protected void kdtEntry_editStopped(KDTEditEvent e) throws Exception {
        this.setQtyBaseQtyAssisQty(this.kdtEntry, e.getRowIndex(), e.getColIndex());
    }

    private void refreshEntryDetail(int selRow) throws EASBizException, BOSException {
        if (selRow >= 0) {
            String[] fileds = new String[]{QTY};
            String[] filedsb = new String[]{BASEQTY};
            String[] filedsa = new String[]{ASSISTQTY};
            IRow iRow = this.kdtEntry.getRow(selRow);
            MaterialInfo mi = (MaterialInfo)iRow.getCell(MATERIALNUM).getValue();
            if (mi == null) {
                return;
            }
            MeasureUnitInfo muia = (MeasureUnitInfo)iRow.getCell(ASSISTUNIT).getValue();
            MeasureUnitInfo muib = (MeasureUnitInfo)iRow.getCell(BASEUNIT).getValue();
            boolean isLock = iRow.getCell(ASSISTQTY).getStyleAttributes().isLocked();
            BigDecimal coefficient = new BigDecimal("0.00");
            int rows = this.kdtEntryDetail.getRowCount();
            for (int i = 0; i < rows; ++i) {
                int[] updateRows = new int[]{i};
                IRow iRowDetail = this.kdtEntryDetail.getRow(i);
                iRowDetail.getCell(NUMBER).setValue((Object)mi.getNumber());
                MeasureUnitInfo mui = (MeasureUnitInfo)iRowDetail.getCell(UNIT).getValue();
                try {
                    if (mui == null) {
                        iRowDetail.getCell(QTY).getStyleAttributes().setLocked(true);
                        iRowDetail.getCell(ASSISTQTY).getStyleAttributes().setLocked(true);
                        SCMClientUtils.changeCellPrecision((IRow)iRowDetail, (String[])fileds, (int)2);
                        continue;
                    }
                    iRowDetail.getCell(QTY).getStyleAttributes().setLocked(false);
                    if (muia != null) {
                        iRowDetail.getCell(ASSISTQTY).getStyleAttributes().setLocked(false);
                    }
                    if (this.mulMeaUnits.get(mi.getId().toString() + mui.getId().toString()) != null) {
                        MultiMeasureUnitInfo mu = (MultiMeasureUnitInfo)this.mulMeaUnits.get(mi.getId().toString() + mui.getId().toString());
                        coefficient = mu.getBaseConvsRate();
                        if (coefficient != null) {
                            coefficient = coefficient.setScale(6, 4);
                        }
                    } else {
                        coefficient = InvClientUtils.getCoefficient(mui, mi);
                    }
                }
                catch (BaseException e) {
                    this.handUIException(e);
                }
                iRowDetail.getCell(NUMBER).setValue((Object)mi.getNumber());
                iRowDetail.getCell(COEFFICIENT).setValue((Object)coefficient);
                if (this.mulMeaUnits.get(mi.getId().toString() + mui.getId().toString()) != null) {
                    SCMClientUtils.changeTableColPrecisionByMaterial((MultiMeasureUnitInfo)((MultiMeasureUnitInfo)this.mulMeaUnits.get(mi.getId().toString() + mui.getId().toString())), (KDTable)this.kdtEntryDetail, (String[])fileds, (int[])updateRows);
                    continue;
                }
                SCMClientUtils.changeTableColPrecisionByMaterial((MaterialInfo)mi, (MeasureUnitInfo)mui, (KDTable)this.kdtEntryDetail, (String[])fileds, (int[])updateRows);
            }
            if (this.mulMeaUnits.get(mi.getId().toString() + muib.getId().toString()) != null) {
                SCMClientUtils.changeTableColPrecisionByMaterial((MultiMeasureUnitInfo)((MultiMeasureUnitInfo)this.mulMeaUnits.get(mi.getId().toString() + muib.getId().toString())), (KDTable)this.kdtEntryDetail, (String[])filedsb);
            } else {
                SCMClientUtils.changeTableColPrecisionByMaterial((MaterialInfo)mi, (MeasureUnitInfo)muib, (KDTable)this.kdtEntryDetail, (String[])filedsb);
            }
            if (muia != null && this.mulMeaUnits.get(mi.getId().toString() + muia.getId().toString()) != null) {
                SCMClientUtils.changeTableColPrecisionByMaterial((MultiMeasureUnitInfo)((MultiMeasureUnitInfo)this.mulMeaUnits.get(mi.getId().toString() + muia.getId().toString())), (KDTable)this.kdtEntryDetail, (String[])filedsa);
            } else {
                SCMClientUtils.changeTableColPrecisionByMaterial((MaterialInfo)mi, (MeasureUnitInfo)muia, (KDTable)this.kdtEntryDetail, (String[])filedsa);
            }
            this.kdtEntryDetail.getColumn(ASSISTQTY).getStyleAttributes().setLocked(isLock);
            this.kdtEntryDetail.repaint();
        }
    }

    @Override
    protected IObjectValue createNewData() {
        DecomposeBillAgent decomposeBillInfo = null;
        try {
            decomposeBillInfo = DecomposeBillAgent.create();
            decomposeBillInfo.setBizDate(SCMClientUtils.getServerDate2());
            decomposeBillInfo.setCreateTime(SCMClientUtils.getServerDate());
            decomposeBillInfo.setBaseStatus(BillBaseStatusEnum.ADD);
            UserInfo aUserInfo = SysContext.getSysContext().getCurrentUserInfo();
            decomposeBillInfo.setCreator(aUserInfo);
            decomposeBillInfo.setIsManualAdd(true);
            decomposeBillInfo.setBillType(this.getBillType());
            this.sou = (StorageOrgUnitInfo)this.getDefaultMainBizOrg();
            decomposeBillInfo.setStorageOrgUnit(this.sou);
        }
        catch (Exception e1) {
            this.handUIException(e1);
        }
        return decomposeBillInfo;
    }

    private BillTypeInfo getBillType() {
        try {
            IBillType ibt = BillTypeFactory.getRemoteInstance();
            ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)"50957179-0105-1000-e002-2152c0a812fd463ED552"));
            BillTypeInfo bti = ibt.getBillTypeInfo((IObjectPK)pk);
            return bti;
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        catch (EASBizException e) {
            this.handUIException(e);
        }
        return null;
    }

    protected IObjectValue createNewDetailData(KDTable table) {
        DecomposeEntryAgent decomposeEntryInfo = null;
        try {
            decomposeEntryInfo = DecomposeEntryAgent.create();
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        decomposeEntryInfo.setBaseStatus(EntryBaseStatusEnum.NULL);
        return decomposeEntryInfo;
    }

    @Override
    public void actionQuickAddLine_actionPerformed(ActionEvent e) throws Exception {
        this.getDetailTable().getSelectManager().removeAll();
        this.inventoryAdaptor();
    }

    @Override
    protected HashMap getQueryCondition() throws Exception {
        HashMap<String, Object> hm = new HashMap<String, Object>();
        StorageOrgUnitInfo aStorageOrgUnitInfo = (StorageOrgUnitInfo)this.prmtStorageOrgUnit.getData();
        if (aStorageOrgUnitInfo != null) {
            hm.put("STORAGEORGUNIT", aStorageOrgUnitInfo);
        }
        boolean isTableFocus = SCMClientUtils.isTableFocus((KDTable)this.kdtEntry);
        hm.put("TABLEHASFOCUS", isTableFocus);
        KDTSelectBlock selectBlock = this.kdtEntry.getSelectManager().get();
        if (selectBlock != null) {
            TrackNumberInfo trackNumberInfo;
            ProjectInfo projectInfo;
            StoreStateInfo storeState;
            StoreTypeInfo storeType;
            MeasureUnitInfo aMeasureUnitInfo;
            LocationInfo aLocationInfo;
            int rowIndex = selectBlock.getTop();
            IRow row = this.kdtEntry.getRow(rowIndex);
            if (row == null) {
                return hm;
            }
            ICell cell = row.getCell(MATERIALNUM);
            MaterialInfo material = (MaterialInfo)cell.getValue();
            hm.put("MATERIAL", material);
            cell = row.getCell(ASSISTPROPERTY);
            if (cell.getValue() != null) {
                AsstAttrValueInfo assistProperty = (AsstAttrValueInfo)cell.getValue();
                hm.put("ASSISTANTATTR", assistProperty.getId().toString());
            }
            cell = row.getCell(LOT);
            String lot = (String)cell.getValue();
            hm.put("BATCH", lot);
            cell = row.getCell(WAREHOUSE);
            WarehouseInfo aWarehouseInfo = (WarehouseInfo)cell.getValue();
            if (aWarehouseInfo != null && aWarehouseInfo.getId() != null) {
                hm.put("WAREHOUSE", aWarehouseInfo.getId().toString());
            }
            if ((aLocationInfo = (LocationInfo)(cell = row.getCell(LOCATION)).getValue()) != null && aLocationInfo.getId() != null) {
                hm.put("LOCATION", aLocationInfo.getId().toString());
            }
            if ((aMeasureUnitInfo = (MeasureUnitInfo)(cell = row.getCell(UNIT)).getValue()) != null && aMeasureUnitInfo.getId() != null) {
                hm.put("UNIT", aMeasureUnitInfo.getId().toString());
            }
            if ((storeType = (StoreTypeInfo)(cell = row.getCell(STORETYPE)).getValue()) != null && storeType.getId() != null) {
                hm.put("STORETYPE", storeType.getId().toString());
            }
            if ((storeState = (StoreStateInfo)(cell = row.getCell(STORESTATUS)).getValue()) != null && storeState.getId() != null) {
                hm.put("STORESTATE", storeState.getId().toString());
            }
            if ((projectInfo = (ProjectInfo)(cell = row.getCell(TB_PROJECTNUM)).getValue()) != null && projectInfo.getId() != null) {
                hm.put("PROJECT", projectInfo.getId().toString());
            }
            if ((trackNumberInfo = (TrackNumberInfo)(cell = row.getCell(TB_TRACKNUM)).getValue()) != null && trackNumberInfo.getId() != null) {
                hm.put("TRACKNUM", trackNumberInfo.getId().toString());
            }
        }
        return hm;
    }

    protected String getEntryMaterialFieldName() {
        return MATERIALNUM;
    }

    protected void initControl() throws Exception {
        KDTSelectManager ksm = this.kdtEntry.getSelectManager();
        KDTSelectManager ksmD = this.kdtEntryDetail.getSelectManager();
        ksm.setSelectMode(2);
        ksmD.setSelectMode(2);
        this.btnQuickAddLine.setIcon(EASResource.getIcon((String)"imgTbtn_newaccountlist"));
        this.btnDispNeedQty.setIcon(EASResource.getIcon((String)"imgTbtn_seechecklist"));
        this.kDContainer1.setEnableActive(false);
        this.kDContainer2.setEnableActive(false);
        this.kDContainer1.setTitleStyle(2);
        this.kDContainer2.setTitleStyle(2);
        this.prmtSourceBillType.setEnabled(false);
        this.prmtSourceBillType.setEditable(false);
        this.comboBaseStatus.setEditable(false);
        this.comboBaseStatus.setEnabled(false);
        this.btnPrint.setVisible(false);
        this.btnPrintPreview.setVisible(false);
        this.separator5.setVisible(false);
        this.menuItemPrint.setVisible(false);
        this.menuItemPrintPreview.setVisible(false);
        this.kDSeparator3.setVisible(false);
        this.separator14.setVisible(false);
        this.txtDescription.setMaxLength(255);
        this.btnDispNeedQty.setVisible(false);
    }

    protected void initTableControl(KDTable kDTable) throws Exception {
        kDTable.getColumn(MATERIALNUM).getStyleAttributes().setLocked(true);
        kDTable.getColumn(MATERIALNAME).getStyleAttributes().setLocked(true);
        kDTable.getColumn(NUMBER).getStyleAttributes().setLocked(true);
        kDTable.getColumn(MODEL).getStyleAttributes().setLocked(true);
        kDTable.getColumn(ASSISTPROPERTY).getStyleAttributes().setLocked(true);
        kDTable.getColumn(LOT).getStyleAttributes().setLocked(true);
        kDTable.getColumn(WAREHOUSE).getStyleAttributes().setLocked(true);
        kDTable.getColumn(LOCATION).getStyleAttributes().setLocked(true);
        this.kdtEntry.getColumn(UNIT).getStyleAttributes().setLocked(true);
        kDTable.getColumn(ASSISTUNIT).getStyleAttributes().setLocked(true);
        kDTable.getColumn(EXP).getStyleAttributes().setLocked(true);
        kDTable.getColumn(COEFFICIENT).getStyleAttributes().setLocked(true);
        kDTable.getColumn(BASEUNIT).getStyleAttributes().setLocked(true);
        kDTable.getColumn(STORETYPE).getStyleAttributes().setLocked(true);
        kDTable.getColumn(STORESTATUS).getStyleAttributes().setLocked(true);
        kDTable.getColumn(CUSTOMER).getStyleAttributes().setLocked(true);
        kDTable.getColumn(SUPPLIER).getStyleAttributes().setLocked(true);
        kDTable.getColumn(BASEQTY).getStyleAttributes().setLocked(true);
        kDTable.getColumn(QTY).getStyleAttributes().setBackground(SCMClientUtils.necessaryColor);
        kDTable.getColumn(TB_PROJECTNUM).getStyleAttributes().setLocked(true);
        kDTable.getColumn(TB_TRACKNUM).getStyleAttributes().setLocked(true);
        kDTable.getColumn(QTY).setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)InvClientUtils.getNewFormatTxtField(2, false)));
        StyleAttributes sa = kDTable.getColumn(QTY).getStyleAttributes();
        sa.setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        kDTable.getColumn(ASSISTQTY).setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)InvClientUtils.getNewFormatTxtField(2, false)));
        sa = kDTable.getColumn(ASSISTQTY).getStyleAttributes();
        sa.setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        kDTable.getColumn(BASEQTY).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        kDTable.getColumn(COEFFICIENT).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        kDTable.getActionMap().remove("Paste");
        InvClientUtils.setFreezeCol(kDTable, MATERIALNAME);
        KDBizPromptBox unitBizBox = (KDBizPromptBox)this.kdtEntryDetail.getColumn(UNIT).getEditor().getComponent();
        unitBizBox.setQueryInfo("com.kingdee.eas.basedata.master.material.app.F7MultiMeasureUnitQuery");
    }

    public String getUITitle() {
        String strTitle = null;
        strTitle = EASResource.getString((String)"com.kingdee.eas.scm.im.inv.WarehsManageResource.DECOMPOSEBILL");
        return strTitle;
    }

    @Override
    protected KDTable getDetailTable() {
        return this.kdtEntry;
    }

    public KDTextField getNumTextField() {
        return this.txtNumber;
    }

    protected KDDatePicker getBizDateField() {
        return this.pkBizDate;
    }

    public KDBizPromptBox getMainOrgUnit() {
        return this.prmtStorageOrgUnit;
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return DecomposeBillFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext());
    }

    public DecomposeBillEditUI() throws Exception {
        this.btnAddEntry.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DecomposeBillEditUI.this.addEntryDetail();
            }
        });
        this.btnDelEntry.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DecomposeBillEditUI.this.delEntryDetail();
            }
        });
    }

    @Override
    public void setDataObject(IObjectValue dataObject) {
        this.editData = (DecomposeBillInfo)dataObject;
        super.setDataObject(dataObject);
    }

    @Override
    public void loadFields() {
        String[][] mults = this.getMultiMeasureUnits();
        if (mults != null) {
            try {
                this.mulMeaUnits = InvClientUtils.getMultiMeasureUnits(MultiMeasureUnitFactory.getRemoteInstance(), mults[0], mults[1]);
            }
            catch (BOSException e) {
                this.handleException((Exception)((Object)e));
            }
        }
        this.removeListeners();
        super.loadFields();
        this.addListeners();
        try {
            this.setControlState();
            this.initEntry();
        }
        catch (Exception e) {
            this.handleException(e);
        }
        this.setDefaultMainOrgUnit();
        this.syncOldData((IObjectValue)this.editData);
        if (this.editData.getSourceBillType() != null) {
            this.actionCopy.setEnabled(false);
        }
    }

    @Override
    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        super.actionEdit_actionPerformed(e);
        this.setControlState();
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("isManualAdd"));
        sic.add(new SelectorItemInfo("billType.id"));
        sic.add(new SelectorItemInfo("billType.number"));
        sic.add(new SelectorItemInfo("billType.name"));
        sic.add(new SelectorItemInfo("entry.storageOrgUnit.id"));
        sic.add(new SelectorItemInfo("entry.storageOrgUnit.number"));
        sic.add(new SelectorItemInfo("entry.storageOrgUnit.name"));
        sic.add(new SelectorItemInfo("entries.material.assistUnit.id"));
        sic.add("entries.companyOrgUnit.name");
        return sic;
    }

    protected void setQuickAddLineStatus(boolean enable) {
        this.actionQuickAddLine.setEnabled(enable);
        this.btnQuickAddLine.setEnabled(enable);
        this.menuItemQuickAddLine.setEnabled(enable);
    }

    @Override
    protected void initDataStatus() {
        super.initDataStatus();
        if ("VIEW".equals(this.getOprtState()) || "FINDVIEW".equals(this.getOprtState())) {
            this.setQuickAddLineStatus(false);
        } else {
            this.setQuickAddLineStatus(true);
        }
    }

    private void setControlState() throws EASBizException, BOSException {
        if (!"ADDNEW".equals(this.getOprtState())) {
            this.prmtStorageOrgUnit.setEnabled(false);
            this.isManualAdd = this.editData.isIsManualAdd();
        } else {
            this.isManualAdd = true;
            this.prmtStorageOrgUnit.setEnabled(true);
            this.prmtTransactionType.setEnabled(true);
            this.kdtEntryDetail.refresh();
        }
        if (this.isManualAdd) {
            this.btnDispNeedQty.setEnabled(false);
            this.menuItemDispNeedQty.setEnabled(false);
        } else {
            this.btnDispNeedQty.setEnabled(true);
            this.menuItemDispNeedQty.setEnabled(true);
        }
    }

    @Override
    protected void prmtStorageOrgUnit_preChange(PreChangeEvent e) throws Exception {
        if ("FINDVIEW".equals(this.getOprtState()) || "VIEW".equals(this.getOprtState())) {
            return;
        }
        if (e.getData() != null && e.getData().equals(e.getOldData())) {
            return;
        }
        if (e.getData() != null && e.getOldData() != null) {
            StorageOrgUnitInfo soNew = (StorageOrgUnitInfo)e.getData();
            StorageOrgUnitInfo soOld = (StorageOrgUnitInfo)e.getOldData();
            if (soNew.getId().equals((Object)soOld.getId())) {
                return;
            }
        }
        String strTemp = null;
        this.sou = InvClientUtils.getStorageOrgUnitInfo(e);
        CompanyOrgUnitInfo couNew = null;
        if (this.sou != null) {
            couNew = this.getCouBySou(this.sou);
            if (!this.checkEntryIsBlank(this.kdtEntry) && !this.isMoveBill) {
                strTemp = InvClientUtils.getResource("CLEARENTRYAFTERORGCHANGED");
                int ret = MsgBox.showConfirm2((String)strTemp);
                if (ret == 2) {
                    e.setResult(0);
                    this.getMainOrgUnit().setData(e.getOldData());
                    return;
                }
                this.cleanEntry();
                for (int i = this.kdtEntryDetail.getRowCount() - 1; i >= 0; --i) {
                    this.removeLine(this.kdtEntryDetail, i);
                }
            }
        }
        if (this.sou != null && couNew == null) {
            this.prmtStorageOrgUnit.requestFocus();
            strTemp = InvClientUtils.getResource("StorageOrgNotHasCompanyOrg");
            MsgBox.showInfo((String)strTemp);
            e.setResult(0);
            this.prmtStorageOrgUnit.setData(e.getOldData());
            return;
        }
        this.prmtAdminOrgUnit.setData(null);
        this.cou = couNew;
    }

    @Override
    public void storeFields() {
        this.kdtEntry.getEditManager().stopEditing();
        super.storeFields();
        try {
            this.sou = (StorageOrgUnitInfo)this.prmtStorageOrgUnit.getValue();
            this.setCouBySou();
            DecomposeEntryCollection dec = this.editData.getEntries();
            int size = dec.size();
            if (size > 0 && this.sou != null) {
                for (int i = 0; i < size; ++i) {
                    DecomposeEntryInfo decomposeEntryInfo = dec.get(i);
                    decomposeEntryInfo.setStorageOrgUnit(this.sou);
                    decomposeEntryInfo.setCompanyOrgUnit(this.cou);
                    DecomposeEntryDetailCollection dedc = decomposeEntryInfo.getEntries();
                    int recs = dedc.size();
                    for (int j = 0; j < recs; ++j) {
                        DecomposeEntryDetailInfo decomposeEntryDetailInfo = dedc.get(j);
                        decomposeEntryDetailInfo.setStorageOrgUnit(this.sou);
                        decomposeEntryDetailInfo.setCompanyOrgUnit(this.cou);
                    }
                }
            }
            this.editData.setIsManualAdd(this.isManualAdd);
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    public void actionRemoveLine_actionPerformed(ActionEvent e) throws Exception {
        super.actionRemoveLine_actionPerformed(e);
        if (this.getDetailTable().getSelectManager().size() > 0) {
            KDTSelectBlock selectBlock = this.getDetailTable().getSelectManager().get(0);
            this.curEntryRow = selectBlock.getEndRow();
            this.refreshEntryDetail(this.curEntryRow);
        } else {
            this.kdtEntryDetail.refresh();
        }
    }

    @Override
    protected KDBizPromptBox getTransacationTypeF7() {
        return null;
    }

    @Override
    protected void initWorkButton() {
        super.initWorkButton();
        this.menuItemQuickAddLine.setIcon(EASResource.getIcon((String)"imgTbtn_newaccountlist"));
        this.menuItemMultiapprove.setVisible(false);
        this.btnMultiapprove.setVisible(false);
        this.actionUnAudit.setVisible(false);
        this.btnSerialNumber.setVisible(false);
        this.menuItemSerialNumber.setVisible(false);
        this.btn_selMaterialSerial.setVisible(false);
        this.menuSelMaterialSerial.setVisible(false);
        this.btnSNsplit.setVisible(false);
        this.menuItemSNsplit.setVisible(false);
        this.btnSNImport.setVisible(false);
        this.menuItemSNImport.setVisible(false);
        this.btnSNExport.setVisible(false);
        this.menuItemSNExport.setVisible(false);
    }

    protected KDBizPromptBox getMainBizOrg() {
        return this.prmtStorageOrgUnit;
    }

    protected String getPermissionItem(String status) {
        if (status.equals("ADDNEW")) {
            return "decompose_new";
        }
        return null;
    }

    @Override
    protected void initEditData(IObjectValue objectValue) {
        super.initEditData(objectValue);
        this.editData = (DecomposeBillInfo)objectValue;
    }

    @Override
    protected void initNeedMainOrgF7s() {
        this.setDepartmentF7(this.prmtAdminOrgUnit);
        this.setNeedMainOrgF7s(new KDBizPromptBox[]{this.prmtAdminOrgUnit});
    }

    private boolean checkEntryIsBlank(KDTable table) {
        int rows = table.getRowCount();
        if (rows > 0) {
            for (int i = 0; i < rows; ++i) {
                if (this.kdtEntry.getRow(i).getCell(table.getColumnIndex(MATERIALNUM)).getValue() == null) continue;
                return false;
            }
            return true;
        }
        return true;
    }

    public String[][] getMultiMeasureUnits() {
        String[][] materialUnits = null;
        HashSet<String> multiSet = new HashSet<String>();
        DecomposeEntryCollection dc = this.editData.getEntries();
        int size = dc.size();
        for (int i = 0; i < size; ++i) {
            DecomposeEntryInfo dei = dc.get(i);
            if (dei == null) continue;
            String materialPK = dei.getMaterial() != null ? dei.getMaterial().getId().toString() : null;
            String unitPK = dei.getUnit() != null ? dei.getUnit().getId().toString() : null;
            String baseUnitPK = dei.getBaseUnit() != null ? dei.getBaseUnit().getId().toString() : null;
            String assistUnitPK = dei.getAssistUnit() != null ? dei.getAssistUnit().getId().toString() : null;
            DecomposeEntryDetailCollection ddc = dei.getEntries();
            if (materialPK != null) {
                if (unitPK != null) {
                    multiSet.add(materialPK + " @ " + unitPK);
                }
                if (baseUnitPK != null) {
                    multiSet.add(materialPK + " @ " + baseUnitPK);
                }
                if (assistUnitPK != null) {
                    multiSet.add(materialPK + " @ " + assistUnitPK);
                }
            }
            if (ddc == null) continue;
            int dsize = ddc.size();
            for (int j = 0; j < dsize; ++j) {
                String d_assistUnitPK;
                DecomposeEntryDetailInfo ded = ddc.get(j);
                if (ded == null) continue;
                String d_materialPK = ded.getMaterial() != null ? ded.getMaterial().getId().toString() : null;
                String d_unitPK = ded.getUnit() != null ? ded.getUnit().getId().toString() : null;
                String d_baseUnitPK = ded.getBaseUnit() != null ? ded.getBaseUnit().getId().toString() : null;
                String string = d_assistUnitPK = ded.getAssistUnit() != null ? ded.getAssistUnit().getId().toString() : null;
                if (d_materialPK == null) continue;
                if (d_unitPK != null) {
                    multiSet.add(d_materialPK + " @ " + d_unitPK);
                }
                if (d_baseUnitPK != null) {
                    multiSet.add(d_materialPK + " @ " + d_baseUnitPK);
                }
                if (d_assistUnitPK == null) continue;
                multiSet.add(d_materialPK + " @ " + d_assistUnitPK);
            }
        }
        if (multiSet.size() > 0) {
            materialUnits = new String[2][multiSet.size()];
            Iterator it = multiSet.iterator();
            int i = 0;
            while (it.hasNext()) {
                String maMu = (String)it.next();
                materialUnits[0][i] = maMu.substring(0, maMu.indexOf(" @ "));
                materialUnits[1][i] = maMu.substring(materialUnits[0][i].length() + 3);
                ++i;
            }
        }
        return materialUnits;
    }

    @Override
    protected String getMaterialName() {
        return this.TB_MATERIAL;
    }

    @Override
    protected String getQtyName() {
        return this.TB_QTY;
    }

    @Override
    protected String getBaseQtyName() {
        return this.TB_BASEQTY;
    }

    @Override
    protected String getAssistQtyName() {
        return this.TB_ASSISTQTY;
    }

    @Override
    protected String getUnitName() {
        return this.TB_UNIT;
    }

    @Override
    protected void initSCMBizDataVO(SCMBizDataVO vo) {
        if (this.isFirstLoading()) {
            vo.setOptionConfigNames(new String[]{"AssistForNumber", "NumberForAssist"});
            vo.setUiClassName(this.getMetaDataPK().getFullName());
        }
        super.initSCMBizDataVO(vo);
    }

    protected EntityViewInfo buildTransactionTypeEntityView() {
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        String billTypeID = this.getBillTypeId();
        if (null != billTypeID) {
            filterInfo.getFilterItems().add(new FilterItemInfo("billType.id", (Object)billTypeID, CompareType.EQUALS));
        }
        filterInfo.getFilterItems().add(new FilterItemInfo("status", (Object)new Integer(1), CompareType.EQUALS));
        ev.setFilter(filterInfo);
        return ev;
    }

    @Override
    protected KDBizPromptBox getBizInventory() {
        return this.bizInventory;
    }

    @Override
    protected String getEntryInvUpdateTypeColumnName() {
        return null;
    }

    @Override
    protected boolean isNeedReLoadStandardCost() {
        return false;
    }

    protected void addEntryDetail() {
        IRow iKdtEntryRow = this.kdtEntry.getRow(this.curEntryRow);
        if (null == iKdtEntryRow) {
            String msg = ResourceUtil.getMessage((String)this.invAddResource, (String)"SELECT_ENTRY_ROW", null);
            MsgBox.showInfo((String)msg);
            SysUtil.abort();
        }
        IRow iKdtEntryDetailRow = this.kdtEntryDetail.addRow();
        DecomposeEntryInfo decomposeEntryInfo = (DecomposeEntryInfo)this.kdtEntry.getRow(this.curEntryRow).getUserObject();
        try {
            DecomposeEntryDetailInfo detailData = this.createNewExpenseData(iKdtEntryRow);
            decomposeEntryInfo.getEntries().add(detailData);
            this.loadLineFields(this.kdtEntryDetail, iKdtEntryDetailRow, (IObjectValue)detailData);
            iKdtEntryDetailRow.setCell(NUMBER, iKdtEntryRow.getCell(NUMBER));
            this.refreshEntryDetail(this.curEntryRow);
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        int row = this.kdtEntryDetail.getRowCount() - 1;
        this.kdtEntryDetail.getRow(row).getCell(UNIT).getStyleAttributes().setLocked(false);
        this.kdtEntryDetail.getRow(row).getCell(QTY).getStyleAttributes().setLocked(true);
        this.kdtEntryDetail.getRow(row).getCell(ASSISTQTY).getStyleAttributes().setLocked(true);
    }

    protected void delEntryDetail() {
        if (this.kdtEntry.getSelectManager().size() == 0) {
            return;
        }
        TreeSet<Integer> set = new TreeSet<Integer>();
        for (int i = 0; i < this.kdtEntryDetail.getSelectManager().size(); ++i) {
            IBlock block = KDTSelectBlock.change((KDTable)this.kdtEntryDetail, (IBlock)this.kdtEntryDetail.getSelectManager().get(i));
            for (int j = block.getTop(); j <= block.getBottom(); ++j) {
                set.add(new Integer(j));
            }
        }
        if (set.size() <= 0) {
            return;
        }
        DecomposeEntryInfo decomposeEntryInfo = (DecomposeEntryInfo)this.kdtEntry.getRow(this.curEntryRow).getUserObject();
        DecomposeEntryDetailCollection dediCol = decomposeEntryInfo.getEntries();
        for (int i = this.kdtEntryDetail.getRowCount() - 1; i >= 0; --i) {
            if (!set.contains(new Integer(i))) continue;
            this.kdtEntryDetail.removeRow(i);
            dediCol.removeObject(i);
        }
    }

    protected void setUnitEntity() {
        if (this.kdtEntry.getRowCount() <= 0) {
            return;
        }
        KDBizPromptBox unitBizBox = (KDBizPromptBox)this.kdtEntryDetail.getColumn(UNIT).getEditor().getComponent();
        MaterialInfo mi = (MaterialInfo)this.kdtEntry.getRow(this.curEntryRow).getCell(MATERIALNUM).getValue();
        MeasureUnitInfo mui = (MeasureUnitInfo)this.kdtEntry.getRow(this.curEntryRow).getCell(UNIT).getValue();
        MeasureUnitInfo muiAssist = (MeasureUnitInfo)this.kdtEntry.getRow(this.curEntryRow).getCell(ASSISTUNIT).getValue();
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("material.id", (Object)mi.getId().toString(), CompareType.EQUALS));
        fi.getFilterItems().add(new FilterItemInfo("measureUnit.id", (Object)mui.getId().toString(), CompareType.NOTEQUALS));
        MeasureUnitInfo detailMui = null;
        for (int i = 0; i < this.kdtEntryDetail.getRowCount(); ++i) {
            detailMui = (MeasureUnitInfo)this.kdtEntryDetail.getRow(i).getCell(UNIT).getValue();
            if (null == detailMui) continue;
            fi.getFilterItems().add(new FilterItemInfo("measureUnit.id", (Object)detailMui.getId().toString(), CompareType.NOTEQUALS));
        }
        if (muiAssist != null) {
            fi.getFilterItems().add(new FilterItemInfo("measureUnit.id", (Object)muiAssist.getId().toString(), CompareType.NOTEQUALS));
        }
        evi.setFilter(fi);
        unitBizBox.setEntityViewInfo(evi);
    }

    protected DecomposeEntryDetailInfo createNewExpenseData(IRow iRow) throws EASBizException, BOSException {
        DecomposeEntryDetailAgent dedi = DecomposeEntryDetailAgent.create();
        dedi.setMaterial((MaterialInfo)iRow.getCell(MATERIALNUM).getValue());
        dedi.setAssistProperty((AsstAttrValueInfo)iRow.getCell(ASSISTPROPERTY).getValue());
        if (iRow.getCell(LOT).getValue() != null) {
            dedi.setLot(iRow.getCell(LOT).getValue().toString());
        } else {
            dedi.setLot(null);
        }
        dedi.setWarehouse((WarehouseInfo)iRow.getCell(WAREHOUSE).getValue());
        dedi.setLocation((LocationInfo)iRow.getCell(LOCATION).getValue());
        dedi.setExp((Date)iRow.getCell(EXP).getValue());
        dedi.setQty(InvClientUtils.ZERO);
        dedi.setBaseQty(InvClientUtils.ZERO);
        dedi.setBaseUnit((MeasureUnitInfo)iRow.getCell(BASEUNIT).getValue());
        if (iRow.getCell(ASSISTUNIT).getValue() != null) {
            dedi.setAssistUnit((MeasureUnitInfo)iRow.getCell(ASSISTUNIT).getValue());
            dedi.setAssistQty(InvClientUtils.ZERO);
        } else {
            dedi.setAssistUnit(null);
            dedi.setAssistQty(null);
        }
        dedi.setStoreType((StoreTypeInfo)iRow.getCell(STORETYPE).getValue());
        dedi.setStoreStatus((StoreStateInfo)iRow.getCell(STORESTATUS).getValue());
        dedi.setCustomer((CustomerInfo)iRow.getCell(CUSTOMER).getValue());
        dedi.setSupplier((SupplierInfo)iRow.getCell(SUPPLIER).getValue());
        dedi.setProject((ProjectInfo)iRow.getCell(TB_PROJECTNUM).getValue());
        dedi.setTrackNumber((TrackNumberInfo)iRow.getCell(TB_TRACKNUM).getValue());
        return dedi;
    }

    private void setAssistQtyByQty(KDTable kdTable, int row, int col) throws EASBizException, BOSException {
        if (kdTable.getCell(row, this.getMaterialName()).getValue() == null || kdTable.getRowCount() < row + 1) {
            return;
        }
        MaterialInfo material = null;
        material = kdTable.getCell(row, this.getMaterialName()).getValue().getClass().isArray() ? ((MaterialInfo[])kdTable.getCell(row, this.getMaterialName()).getValue())[0] : (MaterialInfo)kdTable.getCell(row, this.getMaterialName()).getValue();
        BigDecimal baseQty = InvClientUtils.ZERO;
        BigDecimal assitQty = InvClientUtils.ZERO;
        BigDecimal qty = InvClientUtils.ZERO;
        if (kdTable.getCell(row, this.getUnitName()) == null) {
            return;
        }
        MeasureUnitInfo unit = (MeasureUnitInfo)kdTable.getCell(row, this.getUnitName()).getValue();
        if (unit == null) {
            return;
        }
        if (this.assistForNumber && col == kdTable.getColumnIndex(this.getQtyName())) {
            if (kdTable.getCell(row, this.getQtyName()).getValue() != null) {
                qty = (BigDecimal)kdTable.getCell(row, this.getQtyName()).getValue();
            }
            baseQty = InvClientUtils.getConvsBaseQty(qty, this.fetchData.getUnitbaseConvsRate(material.getId().toString(), unit.getId().toString()), this.fetchData.getUnitPrecision(material.getId().toString(), material.getBaseUnit().getId().toString()));
            if (material.getAssistUnit() != null) {
                assitQty = InvClientUtils.getConvsAssQty(baseQty, this.fetchData.getUnitbaseConvsRate(material.getId().toString(), material.getAssistUnit().getId().toString()), this.fetchData.getUnitPrecision(material.getId().toString(), material.getAssistUnit().getId().toString()));
                if (kdTable.getCell(row, this.getAssistQtyName()) != null) {
                    kdTable.getCell(row, this.getAssistQtyName()).setValue((Object)assitQty);
                    if (kdTable.getCell(row, this.getApproAssistQtyName()) != null) {
                        kdTable.getCell(row, this.getApproAssistQtyName()).setValue((Object)assitQty);
                    }
                }
            }
        }
    }

    @Override
    protected KDDatePicker getPkBizDate() {
        return this.pkBizDate;
    }

    @Override
    protected void afterInventoryF7Query(int rowIndex, int rowCount) throws Exception {
    }

    protected String getBillEntryName() {
        return "entries";
    }

    protected List<InventorySumConditionInfo> getInventorySumConditions() {
        ArrayList<InventorySumConditionInfo> inventorySumConditions = new ArrayList<InventorySumConditionInfo>();
        InventorySumConditionInfo beforeEntryConditionInfo = new InventorySumConditionInfo();
        beforeEntryConditionInfo.setTable(this.kdtEntry);
        beforeEntryConditionInfo.setBillEntryName("entries");
        beforeEntryConditionInfo.setObjValue((IObjectValue)this.editData);
        beforeEntryConditionInfo.setParentObjValue((IObjectValue)this.editData);
        beforeEntryConditionInfo.setQtyName(this.TB_QTY);
        InventorySumConditionInfo afterEntryConditionInfo = new InventorySumConditionInfo();
        DecomposeEntryInfo beforeEntryInfo = null;
        if (this.kdtEntry.getSelectManager() != null && this.kdtEntry.getSelectManager().get() != null && this.kdtEntry.getSelectManager().get().getTop() >= 0) {
            int selectRow = this.kdtEntry.getSelectManager().get().getTop();
            beforeEntryInfo = (DecomposeEntryInfo)this.kdtEntry.getRow(selectRow).getUserObject();
        }
        afterEntryConditionInfo.setTable(this.kdtEntryDetail);
        afterEntryConditionInfo.setBillEntryName("entries");
        afterEntryConditionInfo.setObjValue((IObjectValue)this.editData);
        afterEntryConditionInfo.setParentObjValue(beforeEntryInfo);
        afterEntryConditionInfo.setQtyName(this.TB_QTY);
        inventorySumConditions.add(beforeEntryConditionInfo);
        inventorySumConditions.add(afterEntryConditionInfo);
        return inventorySumConditions;
    }

    protected class DecomposeEntryDetailHandle {
        protected DecomposeEntryDetailHandle() {
        }

        protected void insertExpenseLineLine(KDTable kDtable, int rowIndex, IRow iRow) throws EASBizException, BOSException {
            DecomposeEntryInfo dei = (DecomposeEntryInfo)kDtable.getRow(rowIndex).getUserObject();
            MultiMeasureUnitCollection mmuc = DecomposeBillEditUI.this.getMeasureUnitInfo((MaterialInfo)iRow.getCell(DecomposeBillEditUI.MATERIALNUM).getValue(), (MeasureUnitInfo)iRow.getCell(DecomposeBillEditUI.UNIT).getValue(), (MeasureUnitInfo)iRow.getCell(DecomposeBillEditUI.ASSISTUNIT).getValue());
            int rows = mmuc.size();
            for (int i = 0; i < rows; ++i) {
                DecomposeEntryDetailInfo detailData = this.createNewExpenseData(iRow, mmuc.get(i).getMeasureUnit());
                dei.getEntries().add(detailData);
            }
        }

        protected DecomposeEntryDetailInfo createNewExpenseData(IRow iRow, MeasureUnitInfo mui) throws EASBizException, BOSException {
            DecomposeEntryDetailAgent dedi = DecomposeEntryDetailAgent.create();
            IMeasureUnit imu = MeasureUnitFactory.getRemoteInstance();
            MeasureUnitInfo mu = imu.getMeasureUnitInfo((IObjectPK)new ObjectUuidPK(mui.getId()));
            dedi.setMaterial((MaterialInfo)iRow.getCell(DecomposeBillEditUI.MATERIALNUM).getValue());
            dedi.setAssistProperty((AsstAttrValueInfo)iRow.getCell(DecomposeBillEditUI.ASSISTPROPERTY).getValue());
            if (iRow.getCell(DecomposeBillEditUI.LOT).getValue() != null) {
                dedi.setLot(iRow.getCell(DecomposeBillEditUI.LOT).getValue().toString());
            } else {
                dedi.setLot(null);
            }
            dedi.setWarehouse((WarehouseInfo)iRow.getCell(DecomposeBillEditUI.WAREHOUSE).getValue());
            dedi.setLocation((LocationInfo)iRow.getCell(DecomposeBillEditUI.LOCATION).getValue());
            dedi.setUnit(mu);
            dedi.setExp((Date)iRow.getCell(DecomposeBillEditUI.EXP).getValue());
            dedi.setQty(InvClientUtils.ZERO);
            dedi.setBaseQty(InvClientUtils.ZERO);
            dedi.setBaseUnit((MeasureUnitInfo)iRow.getCell(DecomposeBillEditUI.BASEUNIT).getValue());
            if (iRow.getCell(DecomposeBillEditUI.ASSISTUNIT).getValue() != null) {
                dedi.setAssistUnit((MeasureUnitInfo)iRow.getCell(DecomposeBillEditUI.ASSISTUNIT).getValue());
                dedi.setAssistQty(InvClientUtils.ZERO);
            } else {
                dedi.setAssistUnit(null);
                dedi.setAssistQty(null);
            }
            dedi.setStoreType((StoreTypeInfo)iRow.getCell(DecomposeBillEditUI.STORETYPE).getValue());
            dedi.setStoreStatus((StoreStateInfo)iRow.getCell(DecomposeBillEditUI.STORESTATUS).getValue());
            dedi.setCustomer((CustomerInfo)iRow.getCell(DecomposeBillEditUI.CUSTOMER).getValue());
            dedi.setSupplier((SupplierInfo)iRow.getCell(DecomposeBillEditUI.SUPPLIER).getValue());
            dedi.setProject((ProjectInfo)iRow.getCell(DecomposeBillEditUI.TB_PROJECTNUM).getValue());
            dedi.setTrackNumber((TrackNumberInfo)iRow.getCell(DecomposeBillEditUI.TB_TRACKNUM).getValue());
            return dedi;
        }
    }
}

