/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.headfootdesigner.HeadFootModel;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseListener;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.report.ICommRptBase;
import com.kingdee.eas.framework.report.client.CommRptBaseConditionUI;
import com.kingdee.eas.framework.report.util.KDTableUtil;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.framework.report.util.RptTableHeader;
import com.kingdee.eas.scm.common.client.BillOptionsHelper;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.im.inv.InvCkMutiAccountFacadeFactory;
import com.kingdee.eas.scm.im.inv.client.AbstractInvCkMutiAccountUI;
import com.kingdee.eas.scm.im.inv.client.InvCkMutiAccountFilterUI;
import com.kingdee.eas.util.client.EASResource;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;

public class InvCkMutiAccountUI
extends AbstractInvCkMutiAccountUI {
    private static final long serialVersionUID = 1L;
    private CompanyOrgUnitInfo ficompanyOrgInfo = null;
    private CurrencyInfo baseCurrInfo = null;
    private int amtPrecision = 2;
    private int currRow = -1;
    private int currCol = -1;
    private final int IN = 0;
    private final int OUT = 1;

    public InvCkMutiAccountUI() throws Exception {
        this.tblMain.checkParsed();
        this.tblMain.setEditable(false);
        this.tblMain.getActionMap().remove("Delete");
        this.tblMain.getDataRequestManager().addDataRequestListener((KDTDataRequestListener)this);
        this.tblMain.getDataRequestManager().setDataRequestMode(1);
        this.enableExportExcel(this.tblMain);
        this.kdMenuDetail.setIcon(EASResource.getIcon((String)"imgTbtn_showlist"));
        this.tblMain.getDataRequestManager().setExportMemoryCallback(true);
    }

    protected void initListener() {
        super.initListener();
        this.tblMain.addKDTMouseListener(new KDTMouseListener(){

            public void tableClicked(KDTMouseEvent e) {
                InvCkMutiAccountUI.this.currRow = e.getRowIndex();
                InvCkMutiAccountUI.this.currCol = e.getColIndex();
                if (e.getClickCount() == 2) {
                    InvCkMutiAccountUI.this.tbl_tableClicked(e);
                }
            }
        });
    }

    protected void tbl_tableClicked(KDTMouseEvent e) {
        ActionEvent evt = new ActionEvent(this.btnDetail, 0, "Double Clicked");
        ItemAction actView = this.getActionFromActionEvent(evt);
        actView.actionPerformed(evt);
    }

    protected int getSelectDirection(int colIndex) {
        int result = -1;
        if (this.currCol == -1) {
            return -1;
        }
        if (this.tblMain.getColumnIndex("FInAmount") == colIndex || this.tblMain.getColumnIndex("FActInAmount") == colIndex || this.tblMain.getColumnIndex("FDiffInAmount") == colIndex) {
            result = 0;
        } else if (this.tblMain.getColumnIndex("FOutAmount") == colIndex || this.tblMain.getColumnIndex("FActOutAmount") == colIndex || this.tblMain.getColumnIndex("FDiffOutAmount") == colIndex) {
            result = 1;
        }
        return result;
    }

    protected boolean isSelectTotalRow() {
        if (this.currRow == -1) {
            return true;
        }
        return this.tblMain.getRow(this.currRow).getCell("FActNumber").getValue() == null;
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Company;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        Map billOptionsMap = BillOptionsHelper.takeConfigType((IUIObject)this);
        boolean isShowSumRowFlag = BillOptionsHelper.takeConfigType((Map)billOptionsMap, (IUIObject)this, (String)"isShowSumRowFlag", (boolean)false);
        this.chkMenuShowModel.setSelected(isShowSumRowFlag);
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected ICommRptBase getRemoteInstance() throws BOSException {
        return InvCkMutiAccountFacadeFactory.getRemoteInstance();
    }

    protected KDTable getTableForPrintSetting() {
        return this.tblMain;
    }

    protected RptParams getParamsForInit() {
        RptParams initParam = new RptParams();
        return initParam;
    }

    protected CommRptBaseConditionUI getQueryDialogUserPanel() throws Exception {
        InvCkMutiAccountFilterUI condUI = new InvCkMutiAccountFilterUI();
        condUI.setSize(380, 340);
        return condUI;
    }

    protected void query() {
        this.tblMain.removeColumns();
        this.tblMain.removeRows();
        this.initUIMainOrgContext(((CompanyOrgUnitInfo)this.params.getObject("bizCompnayOrg")).getId().toString());
        this.initUserConfig();
    }

    @Override
    public void actionDetail_actionPerformed(ActionEvent e) throws Exception {
        int direction = this.getSelectDirection(this.currCol);
        if (this.isSelectTotalRow() || direction == -1) {
            return;
        }
        UIContext uiContext = new UIContext((Object)this);
        Object value = this.tblMain.getRow(this.currRow).getCell("FYear").getValue();
        int year = 0;
        int period = 0;
        year = value instanceof BigDecimal ? ((BigDecimal)value).intValue() : ((Integer)value).intValue();
        value = this.tblMain.getRow(this.currRow).getCell("FPeriod").getValue();
        period = value instanceof BigDecimal ? ((BigDecimal)value).intValue() : ((Integer)value).intValue();
        String ActItemNumber = (String)this.tblMain.getRow(this.currRow).getCell("FActItemNumber").getValue();
        String actNumber = (String)this.tblMain.getRow(this.currRow).getCell("FActNumber").getValue();
        String actName = (String)this.tblMain.getRow(this.currRow).getCell("FActName").getValue();
        RptParams rptParam = new RptParams();
        rptParam.setObject("bizCompnayOrg", this.params.getObject("bizCompnayOrg"));
        rptParam.setInt("Direction", direction);
        rptParam.setInt("Year", year);
        rptParam.setInt("Period", period);
        rptParam.setString("ActItemNumber", ActItemNumber);
        rptParam.setString("ActNumber", actNumber);
        rptParam.setString("ActName", actName);
        rptParam.setObject("ckShowNoCalculate", this.params.getObject("ckShowNoCalculate"));
        rptParam.setObject("noSelectMovebill", this.params.getObject("noSelectMovebill"));
        rptParam.setBoolean("isShowException", this.chkMenuShowModel.isSelected());
        uiContext.put((Object)"com.kingdee.eas.framework.report.client.CommRptBaseUI#UICONTEXT_KEY_BE_JOINQUERY", (Object)true);
        uiContext.put((Object)"com.kingdee.eas.framework.report.client.CommRptBaseUI#UICONTEXT_KEY_JOINQUERY_PARAMS", (Object)rptParam);
        IUIWindow uiWindow = null;
        uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewTabFactory").create(this.getEditUIName(), (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
    }

    @Override
    public void actionIsShowException_actionPerformed(ActionEvent e) throws Exception {
        boolean isShowSumRowFlag = this.chkMenuShowModel.isSelected();
        BillOptionsHelper.putConfigTypeByUI((IUIObject)this, (String)"isShowSumRowFlag", (boolean)isShowSumRowFlag);
    }

    protected String getEditUIName() {
        return "com.kingdee.eas.scm.cal.client.InvCkMutiAccountDetailUI";
    }

    public Object getTablePreferenceSchemaKey() {
        return this.queryDialog.getCurrentSolutionInfo().getId();
    }

    public boolean isAsynchronism() {
        return true;
    }

    public void getData(KDTDataRequestEvent e) {
        try {
            RptParams rpt;
            this.tblMain.getDataRequestManager().removeDataRequestListener((KDTDataRequestListener)this);
            int from = e.getFirstRow();
            int len = e.getLastRow() - from + 1;
            RptParams rptParam = new RptParams();
            if (from == 0) {
                rptParam.setString("tempTable", this.getTempTable());
                rptParam.setObject("bizCompnayOrg", this.params.getObject("bizCompnayOrg"));
                rptParam.setObject("spnYearFrom", this.params.getObject("spnYearFrom"));
                rptParam.setObject("spnPeriodFrom", this.params.getObject("spnPeriodFrom"));
                rptParam.setObject("spnYearTo", this.params.getObject("spnYearTo"));
                rptParam.setObject("spnPeriodTo", this.params.getObject("spnPeriodTo"));
                rptParam.setObject("spnAccountFrom", this.params.getObject("spnAccountFrom"));
                rptParam.setObject("spnAccountTo", this.params.getObject("spnAccountTo"));
                rptParam.setObject("ckShowNoCalculate", this.params.getObject("ckShowNoCalculate"));
                rptParam.setObject("noSelectMovebill", this.params.getObject("noSelectMovebill"));
                rpt = InvCkMutiAccountFacadeFactory.getRemoteInstance().createTempTable(rptParam);
                this.setTempTable(rpt.getString("tempTable"));
                RptTableHeader header = (RptTableHeader)rpt.getObject("header");
                KDTableUtil.setHeader((RptTableHeader)header, (KDTable)this.tblMain);
                this.tblMain.setRowCount(rpt.getInt("verticalCount"));
                this.setAmountPrecision();
            }
            rptParam.setString("tempTable", this.getTempTable());
            rpt = InvCkMutiAccountFacadeFactory.getRemoteInstance().query(rptParam, from, len);
            RptRowSet rs = (RptRowSet)rpt.getObject("rowset");
            KDTableUtil.insertRows((RptRowSet)rs, (int)from, (KDTable)this.tblMain);
            this.tblMain.getDataRequestManager().addDataRequestListener((KDTDataRequestListener)this);
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
    }

    private void setAmountPrecision() {
        try {
            this.ficompanyOrgInfo = (CompanyOrgUnitInfo)this.params.getObject("bizCompnayOrg");
            if (this.ficompanyOrgInfo.getBaseCurrency() != null) {
                this.baseCurrInfo = CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)new ObjectUuidPK(this.ficompanyOrgInfo.getBaseCurrency().getId()));
                this.amtPrecision = this.baseCurrInfo.getPrecision();
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
        String fmtStr = SCMClientUtils.getFormatPattern((int)this.amtPrecision);
        this.tblMain.getColumn("FBeginAmount").getStyleAttributes().setNumberFormat(fmtStr);
        this.tblMain.getColumn("FActBeginAmount").getStyleAttributes().setNumberFormat(fmtStr);
        this.tblMain.getColumn("FDiffBeginAmount").getStyleAttributes().setNumberFormat(fmtStr);
        this.tblMain.getColumn("FInAmount").getStyleAttributes().setNumberFormat(fmtStr);
        this.tblMain.getColumn("FActInAmount").getStyleAttributes().setNumberFormat(fmtStr);
        this.tblMain.getColumn("FDiffInAmount").getStyleAttributes().setNumberFormat(fmtStr);
        this.tblMain.getColumn("FOutAmount").getStyleAttributes().setNumberFormat(fmtStr);
        this.tblMain.getColumn("FActOutAmount").getStyleAttributes().setNumberFormat(fmtStr);
        this.tblMain.getColumn("FDiffOutAmount").getStyleAttributes().setNumberFormat(fmtStr);
        this.tblMain.getColumn("FEndAmount").getStyleAttributes().setNumberFormat(fmtStr);
        this.tblMain.getColumn("FActEndAmount").getStyleAttributes().setNumberFormat(fmtStr);
        this.tblMain.getColumn("FDiffEndAmount").getStyleAttributes().setNumberFormat(fmtStr);
    }

    protected Map preparePrintVariantMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        CompanyOrgUnitInfo companyOrgUnitInfo = (CompanyOrgUnitInfo)this.params.getObject("bizCompnayOrg");
        Integer spnYearFrom = (Integer)this.params.getObject("spnYearFrom");
        Integer spnPeriodFrom = (Integer)this.params.getObject("spnPeriodFrom");
        Integer spnYearTo = (Integer)this.params.getObject("spnYearTo");
        Integer spnPeriodTo = (Integer)this.params.getObject("spnPeriodTo");
        String period = spnYearFrom + "." + spnPeriodFrom + " -- " + spnYearTo + "." + spnPeriodTo;
        map.put("Period", period);
        map.put("Currency", this.baseCurrInfo.getName());
        map.put("Company", companyOrgUnitInfo.getName());
        return map;
    }

    protected void preparePrintPageHeader(HeadFootModel header) {
        StyleAttributes sa = Styles.getDefaultSA();
        StringBuffer sb = new StringBuffer();
        sb.append(InvCkMutiAccountUI.getResourceString((String)"print_label_period")).append("&[Period]").append("&|").append(InvCkMutiAccountUI.getResourceString((String)"print_label_currency")).append("&[Currency]").append("&|").append(InvCkMutiAccountUI.getResourceString((String)"print_label_company")).append("&[Company]");
        sb.append("&|");
        header.addRow(sb.toString(), sa);
    }
}

