/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSLocaleUtil;
import com.kingdee.bos.ctrl.extendcontrols.BizDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.IDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.IParser;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.data.logging.Logger;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.foot.KDTFootManager;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.render.ObjectValueRender;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.KDPromptBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.PreChangeEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import com.kingdee.bos.ctrl.swing.util.CtrlFormatUtilities;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.base.permission.IPermissionServiceProvider;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.PermissionServiceProviderFactory;
import com.kingdee.eas.basedata.assistant.CostItemInfo;
import com.kingdee.eas.basedata.assistant.CostObjectInfo;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.assistant.client.CostObjectF7UISelector;
import com.kingdee.eas.basedata.master.cssp.CSSPGroupInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerFactory;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.master.cssp.MainDataParser;
import com.kingdee.eas.basedata.master.cssp.client.F7CustomerTreeDetailListUI;
import com.kingdee.eas.basedata.master.cssp.client.F7SupplierTreeDetailListUI;
import com.kingdee.eas.basedata.master.material.AsstAttrTypeInfo;
import com.kingdee.eas.basedata.master.material.AsstAttrValueInfo;
import com.kingdee.eas.basedata.master.material.CalculateTypeEnum;
import com.kingdee.eas.basedata.master.material.IMaterial;
import com.kingdee.eas.basedata.master.material.IMaterialCost;
import com.kingdee.eas.basedata.master.material.IMaterialPlan;
import com.kingdee.eas.basedata.master.material.IMultiMeasureUnit;
import com.kingdee.eas.basedata.master.material.IsolatedRuleEnum;
import com.kingdee.eas.basedata.master.material.MaterialCompanyInfoCollection;
import com.kingdee.eas.basedata.master.material.MaterialCompanyInfoInfo;
import com.kingdee.eas.basedata.master.material.MaterialCostFactory;
import com.kingdee.eas.basedata.master.material.MaterialCostInfo;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialGroupInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MaterialInventoryFactory;
import com.kingdee.eas.basedata.master.material.MaterialInventoryInfo;
import com.kingdee.eas.basedata.master.material.MaterialPlanCollection;
import com.kingdee.eas.basedata.master.material.MaterialPlanFactory;
import com.kingdee.eas.basedata.master.material.MaterialPlanInfo;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitCollection;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitFactory;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.TimeUnitEnum;
import com.kingdee.eas.basedata.master.material.UsedStatusEnum;
import com.kingdee.eas.basedata.master.material.client.F7MaterialMultiUI;
import com.kingdee.eas.basedata.master.material.client.F7MaterialMultiUISelectorAdaptor;
import com.kingdee.eas.basedata.master.material.client.F7MaterialTreeListUI;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.IFullOrgUnit;
import com.kingdee.eas.basedata.org.IOrgUnitRelation;
import com.kingdee.eas.basedata.org.IStorageOrgUnit;
import com.kingdee.eas.basedata.org.NewOrgViewHelper;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitRelationCollection;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.basedata.org.OrgUnitRelationInfo;
import com.kingdee.eas.basedata.org.OrgViewType;
import com.kingdee.eas.basedata.org.PurchaseOrgUnitInfo;
import com.kingdee.eas.basedata.org.SaleOrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.basedata.person.client.PersonPromptBox;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.basedata.scm.common.BizTypeInfo;
import com.kingdee.eas.basedata.scm.common.TransactionTypeCollection;
import com.kingdee.eas.basedata.scm.common.TransactionTypeFactory;
import com.kingdee.eas.basedata.scm.common.TransactionTypeInfo;
import com.kingdee.eas.basedata.scm.common.util.SCMBaseCommonUtil;
import com.kingdee.eas.basedata.scm.im.inv.ILocation;
import com.kingdee.eas.basedata.scm.im.inv.IMaterialStorageAssign;
import com.kingdee.eas.basedata.scm.im.inv.ISOAccreditWH;
import com.kingdee.eas.basedata.scm.im.inv.IWarehouse;
import com.kingdee.eas.basedata.scm.im.inv.InvUpdateTypeFactory;
import com.kingdee.eas.basedata.scm.im.inv.InvUpdateTypeInfo;
import com.kingdee.eas.basedata.scm.im.inv.LocationFactory;
import com.kingdee.eas.basedata.scm.im.inv.LocationInfo;
import com.kingdee.eas.basedata.scm.im.inv.MaterialStorageAssignFactory;
import com.kingdee.eas.basedata.scm.im.inv.SOAccreditWHFactory;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseFactory;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseInfo;
import com.kingdee.eas.basedata.scm.im.inv.client.LocationHelper;
import com.kingdee.eas.basedata.scm.sd.sale.PriceCondition;
import com.kingdee.eas.basedata.scm.sd.sale.client.PriceSolve;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.client.CoreBillEditUI;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.scm.common.ISCMBillCommonFacade;
import com.kingdee.eas.scm.common.SCMBillCommonFacadeFactory;
import com.kingdee.eas.scm.common.SCMBillException;
import com.kingdee.eas.scm.common.SCMFetchData;
import com.kingdee.eas.scm.common.client.GeneralKDPromptSelectorAdaptor;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.client.SCMGroupClientUtils;
import com.kingdee.eas.scm.common.constants.QueryInfoConstants;
import com.kingdee.eas.scm.common.loadmass.SCMEntryDataVO;
import com.kingdee.eas.scm.common.util.SCMConstant;
import com.kingdee.eas.scm.common.util.StringUtil;
import com.kingdee.eas.scm.im.inv.AbstractDateOfMinDurabilityInfo;
import com.kingdee.eas.scm.im.inv.DateOfMinDurabilityCollection;
import com.kingdee.eas.scm.im.inv.DateOfMinDurabilityFactory;
import com.kingdee.eas.scm.im.inv.DateOfMinDurabilityInfo;
import com.kingdee.eas.scm.im.inv.IDateOfMinDurability;
import com.kingdee.eas.scm.im.inv.IInvBillBaseEntry;
import com.kingdee.eas.scm.im.inv.IInventory;
import com.kingdee.eas.scm.im.inv.IInventoryInitEntry;
import com.kingdee.eas.scm.im.inv.IManufactureRecBill;
import com.kingdee.eas.scm.im.inv.IManufactureRecBillEntry;
import com.kingdee.eas.scm.im.inv.IMoveInWarehsBillEntry;
import com.kingdee.eas.scm.im.inv.IOtherInWarehsBillEntry;
import com.kingdee.eas.scm.im.inv.IPurInWarehsEntry;
import com.kingdee.eas.scm.im.inv.IPurReceivalEntry;
import com.kingdee.eas.scm.im.inv.InvBillBaseEntryInfo;
import com.kingdee.eas.scm.im.inv.InvBillBaseInfo;
import com.kingdee.eas.scm.im.inv.InventoryCollection;
import com.kingdee.eas.scm.im.inv.InventoryFactory;
import com.kingdee.eas.scm.im.inv.InventoryInitEntryCollection;
import com.kingdee.eas.scm.im.inv.InventoryInitEntryFactory;
import com.kingdee.eas.scm.im.inv.ManufactureRecBillEntryCollection;
import com.kingdee.eas.scm.im.inv.ManufactureRecBillEntryFactory;
import com.kingdee.eas.scm.im.inv.ManufactureRecBillFactory;
import com.kingdee.eas.scm.im.inv.ManufactureRecBillInfo;
import com.kingdee.eas.scm.im.inv.MaterialReqBillInfo;
import com.kingdee.eas.scm.im.inv.MaterialRequestBillInfo;
import com.kingdee.eas.scm.im.inv.MoveInWarehsBillEntryCollection;
import com.kingdee.eas.scm.im.inv.MoveInWarehsBillEntryFactory;
import com.kingdee.eas.scm.im.inv.MoveInWarehsBillInfo;
import com.kingdee.eas.scm.im.inv.MoveIssueBillInfo;
import com.kingdee.eas.scm.im.inv.OtherInWarehsBillEntryCollection;
import com.kingdee.eas.scm.im.inv.OtherInWarehsBillEntryFactory;
import com.kingdee.eas.scm.im.inv.OtherInWarehsBillInfo;
import com.kingdee.eas.scm.im.inv.OtherIssueBillInfo;
import com.kingdee.eas.scm.im.inv.PurInWarehsBillInfo;
import com.kingdee.eas.scm.im.inv.PurInWarehsEntryCollection;
import com.kingdee.eas.scm.im.inv.PurInWarehsEntryFactory;
import com.kingdee.eas.scm.im.inv.PurReceivalBillInfo;
import com.kingdee.eas.scm.im.inv.PurReceivalEntryCollection;
import com.kingdee.eas.scm.im.inv.PurReceivalEntryFactory;
import com.kingdee.eas.scm.im.inv.SaleIssueBillInfo;
import com.kingdee.eas.scm.im.inv.StockTransferBillEntryInfo;
import com.kingdee.eas.scm.im.inv.StockTransferBillInfo;
import com.kingdee.eas.scm.im.inv.TransferOrderBillEntryInfo;
import com.kingdee.eas.scm.im.inv.TransferOrderBillInfo;
import com.kingdee.eas.scm.util.array.ArrayUtil;
import com.kingdee.eas.scm.util.collection.CollectionUtil;
import com.kingdee.eas.scm.util.datetime.DateTimeUtil;
import com.kingdee.eas.scm.util.filehandle.ResourceUtil;
import com.kingdee.eas.scm.util.numeric.PrecisionUtil;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.BaseException;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import java.awt.Color;
import java.awt.Component;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JTextField;

public class InvClientUtils {
    public static final BigDecimal MAXVAL = new BigDecimal("999999999999.9999");
    public static final BigDecimal ZERO = new BigDecimal("0.00");
    public static final BigDecimal MINVAL = new BigDecimal("-999999999999.9999");
    public static final BigDecimal MAXINTVAL = new BigDecimal("9999999999");
    public static final String resource = "com.kingdee.eas.scm.im.inv.WarehsManageResource";
    public static final int WHFILTER_ISSTARTED = 1;
    public static final int WHFILTER_NOSTARTED = 0;
    public static final int WHFILTER_ALL = -1;
    public static final String UNIT = "UNIT";
    public static final String BASEUNIT = "BASEUNIT";
    public static final String ASSISTUNIT = "ASSISTUNIT";
    public static final String ASSISTPROPERTY = "assistProperty";
    public static final String WAREHOUSE = "warehouse";
    public static final String LOCATION = "location";
    public static final String EXP = "exp";
    public static final String MFG = "mfg";
    public static final String LOT = "lot";
    public static final String QTY = "qty";
    public static final String PERIODVALID = "periodValid";
    public static final String PERIODVALIDUNIT = "periodValidUnit";
    public static final int BDTYPE_MATEIAL = 0;
    public static final int BDTYPE_SUPPLIER = 1;
    public static final int BDTYPE_CUSTOMER = 2;
    public static final String resourceSR = "com.kingdee.eas.scm.im.inv.SupplyRelationResource";
    public static final String addResource = "com.kingdee.eas.scm.im.inv.InvAddResource";
    public static final String STR_ISRITYPEFORINDUSTRY = "isRITypeForIndustry";
    protected static Map<String, String> alterForLotParamMap = new HashMap<String, String>();

    public static KDFormattedTextField getNewFormatTxtField(int precision, boolean canMinus) {
        KDFormattedTextField txtField = new KDFormattedTextField(1);
        txtField.setPrecision(precision);
        txtField.setMaximumValue((Comparable)MAXVAL);
        txtField.setMinimumValue((Comparable)MINVAL);
        txtField.setNegatived(canMinus);
        txtField.setHorizontalAlignment(4);
        return txtField;
    }

    public static void fmtTableAmt(KDTable table, String columnName, int scale) {
        table.getColumn(columnName).getStyleAttributes().setNumberFormat(InvClientUtils.fmtTableString(scale).toString());
        table.getColumn(columnName).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
    }

    public static void fmtTableAmt(KDTable table, String[] columnName, int scale) {
        int size = columnName.length;
        for (int i = 0; i < size; ++i) {
            table.getColumn(columnName[i]).getStyleAttributes().setNumberFormat(InvClientUtils.fmtTableString(scale).toString());
            table.getColumn(columnName[i]).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        }
    }

    public static void fmtTableAmt(IColumn column, int scale) {
        column.getStyleAttributes().setNumberFormat(InvClientUtils.fmtTableString(scale).toString());
        column.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
    }

    public static void fmtTableAmt(ICell cell, int scale) {
        cell.getStyleAttributes().setNumberFormat(InvClientUtils.fmtTableString(scale).toString());
        cell.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
    }

    public static StringBuffer fmtTableString(int scale) {
        return PrecisionUtil.fmtTableString((int)scale);
    }

    public static EntityViewInfo getBizTypeFromBill(String billTypeNumber) {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("billType.number", (Object)billTypeNumber));
        viewInfo.setFilter(filterInfo);
        return viewInfo;
    }

    public static void fmtDate(KDTable table, String columnKey) {
        table.getColumn(columnKey).getStyleAttributes().setNumberFormat(DateTimeUtil.strDateFormat);
    }

    public static void fmtDate(KDTable table, String[] columnKeys) {
        for (int i = 0; i < columnKeys.length; ++i) {
            InvClientUtils.fmtDate(table, columnKeys[i]);
        }
    }

    public static void tableDelLine(KDTable kDTable) {
        if (kDTable.getSelectManager().get() == null) {
            return;
        }
        int ibeginRow = kDTable.getSelectManager().get().getBeginRow();
        int iEndrow = kDTable.getSelectManager().get().getEndRow();
        int ilastRow = kDTable.getRowCount();
        if (ibeginRow != -1 && iEndrow != -1) {
            for (int i = ibeginRow; i < iEndrow + 1; ++i) {
                IRow row = kDTable.getRow(i);
                if (row == null) continue;
                row = kDTable.removeRow(i);
                --iEndrow;
                --i;
            }
        } else if (ilastRow > 0) {
            kDTable.removeRow(ilastRow - 1);
        }
    }

    public static IRow tableAddLastLine(KDTable kDTable) {
        IRow row = null;
        int iRow = kDTable.getRowCount();
        if (iRow != -1) {
            row = kDTable.addRow(iRow);
        }
        return row;
    }

    public static IRow tableAddLine(KDTable kDTable, boolean isBefore) {
        IRow row = null;
        int ibeginRow = kDTable.getSelectManager().get().getBeginRow();
        int iEndrow = kDTable.getSelectManager().get().getEndRow();
        if (isBefore) {
            if (ibeginRow != -1) {
                if (ibeginRow > 0) {
                    kDTable.addRow(ibeginRow - 1);
                } else {
                    kDTable.addRow(0);
                }
            }
        } else if (iEndrow != -1) {
            kDTable.addRow(iEndrow);
        }
        return row;
    }

    public static String getResource(String strKey) {
        if (strKey == null || strKey.trim().length() == 0) {
            return null;
        }
        return EASResource.getString((String)resource, (String)strKey);
    }

    public static String getAddResource(String strKey) {
        if (strKey == null || strKey.trim().length() == 0) {
            return null;
        }
        return EASResource.getString((String)addResource, (String)strKey);
    }

    public static void setFilterForTransactionType(KDBizPromptBox bizPromptBox, String number) {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        if (number != null) {
            FilterItemInfo filterItemInfo = new FilterItemInfo("billType.number", (Object)number);
            filterInfo.getFilterItems().add(filterItemInfo);
        }
        filterInfo.getFilterItems().add(new FilterItemInfo("status", (Object)new Integer(0), CompareType.NOTEQUALS));
        viewInfo.setFilter(filterInfo);
        bizPromptBox.setEntityViewInfo(viewInfo);
    }

    public static void setFilterForTransactionTypeByBillType(KDBizPromptBox bizPromptBox, Set ids) {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        if (ids != null && ids.size() > 0) {
            filterInfo.getFilterItems().add(new FilterItemInfo("billType.number", (Object)ids, CompareType.INCLUDE));
        }
        viewInfo.setFilter(filterInfo);
        bizPromptBox.setEntityViewInfo(viewInfo);
    }

    public static void setFilterForTransactionType(KDBizPromptBox bizPromptBox, String number, boolean isSubContract) {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.appendFilterItem("billType.number", (Object)number);
        filterInfo.getFilterItems().add(new FilterItemInfo("status", (Object)new Integer(0), CompareType.NOTEQUALS));
        if (isSubContract) {
            filterInfo.setMaskString("#0 and  (#1) and (#2 or #3 or #4 or #5 or #6)");
            filterInfo.appendFilterItem("bizType.number", (Object)"130");
            filterInfo.appendFilterItem("bizType.number", (Object)"131");
            filterInfo.appendFilterItem("bizType.number", (Object)"140");
            filterInfo.appendFilterItem("bizType.number", (Object)"141");
            filterInfo.appendFilterItem("bizType.number", (Object)"132");
        }
        viewInfo.setFilter(filterInfo);
        bizPromptBox.setEntityViewInfo(viewInfo);
    }

    public static BigDecimal getUnitStandardCost(MaterialInfo aMaterialInfo, CompanyOrgUnitInfo aCompanyOrgUnitInfo) throws Exception {
        BigDecimal result = new BigDecimal("0.00");
        if (aMaterialInfo == null || aMaterialInfo.getId() == null || aCompanyOrgUnitInfo == null || aCompanyOrgUnitInfo.getId() == null) {
            return result;
        }
        IMaterial iMaterial = MaterialFactory.getRemoteInstance();
        MaterialCompanyInfoInfo aMaterialCompanyInfoInfo = iMaterial.getCompanyInfo(aMaterialInfo.getId().toString(), aCompanyOrgUnitInfo.getId().toString());
        if (aMaterialCompanyInfoInfo == null) {
            return result;
        }
        if (aMaterialCompanyInfoInfo.getStandardCost() != null) {
            result = aMaterialCompanyInfoInfo.getStandardCost();
        }
        return result;
    }

    public static BigDecimal getUnitStandardCostByFetchData(MaterialInfo aMaterialInfo, CompanyOrgUnitInfo aCompanyOrgUnitInfo, SCMFetchData fetchData) throws Exception {
        BigDecimal result = new BigDecimal("0.00");
        if (aMaterialInfo == null || aMaterialInfo.getId() == null || aCompanyOrgUnitInfo == null || aCompanyOrgUnitInfo.getId() == null) {
            return result;
        }
        if (fetchData != null && fetchData.getMapMaterialCompany() != null && fetchData.getMapMaterialCompany().size() > 0) {
            MaterialCompanyInfoInfo aMaterialCompanyInfoInfo = (MaterialCompanyInfoInfo)fetchData.getMapMaterialCompany().get(aMaterialInfo.getId().toString() + aCompanyOrgUnitInfo.getId().toString());
            if (aMaterialCompanyInfoInfo == null) {
                return result;
            }
            if (aMaterialCompanyInfoInfo.getStandardCost() != null) {
                result = aMaterialCompanyInfoInfo.getStandardCost();
            }
        } else {
            IMaterial iMaterial = MaterialFactory.getRemoteInstance();
            MaterialCompanyInfoInfo aMaterialCompanyInfoInfo = iMaterial.getCompanyInfo(aMaterialInfo.getId().toString(), aCompanyOrgUnitInfo.getId().toString());
            if (aMaterialCompanyInfoInfo == null) {
                return result;
            }
            if (aMaterialCompanyInfoInfo.getStandardCost() != null) {
                result = aMaterialCompanyInfoInfo.getStandardCost();
            }
        }
        return result;
    }

    public static BigDecimal getUnitStandardCost(MaterialInfo aMaterialInfo, CompanyOrgUnitInfo aCompanyOrgUnitInfo, SCMFetchData fetchData) throws Exception {
        BigDecimal result = new BigDecimal("0.00");
        if (aMaterialInfo == null || aMaterialInfo.getId() == null || aCompanyOrgUnitInfo == null || aCompanyOrgUnitInfo.getId() == null) {
            return result;
        }
        MaterialCompanyInfoInfo aMaterialCompanyInfoInfo = fetchData.getMaterialCompany(aMaterialInfo.getId().toString(), aCompanyOrgUnitInfo.getId().toString());
        if (aMaterialCompanyInfoInfo == null) {
            return result;
        }
        if (aMaterialCompanyInfoInfo.getStandardCost() != null) {
            result = aMaterialCompanyInfoInfo.getStandardCost();
        }
        return result;
    }

    public static BigDecimal getCoefficient(MeasureUnitInfo mui, MaterialInfo mi) throws BaseException {
        BigDecimal coefficient = new BigDecimal("1.00");
        MultiMeasureUnitInfo mulUnit = InvClientUtils.getMulUnit(mui, mi);
        if (mulUnit != null && (coefficient = mulUnit.getBaseConvsRate()) != null) {
            return coefficient.setScale(6, 4);
        }
        return coefficient;
    }

    public static BigDecimal getMultiUnitQty(MeasureUnitInfo muiFrom, MeasureUnitInfo muiTo, MaterialInfo mi, BigDecimal qtyFrom) throws Exception {
        BigDecimal coefficient = new BigDecimal("1.00");
        BigDecimal qtyTo = new BigDecimal("0.00");
        if (qtyFrom == null) {
            return qtyFrom;
        }
        qtyTo = qtyFrom;
        MultiMeasureUnitInfo mulUnitFrom = InvClientUtils.getMulUnit(muiFrom, mi);
        MultiMeasureUnitInfo mulUnitTo = InvClientUtils.getMulUnit(muiTo, mi);
        if (mulUnitFrom != null && mulUnitTo != null && (coefficient = mulUnitFrom.getBaseConvsRate().divide(mulUnitTo.getBaseConvsRate(), 18, 4)) != null) {
            qtyFrom = qtyFrom.multiply(coefficient);
        }
        qtyTo = qtyFrom.setScale(mulUnitTo.getQtyPrecision(), 4);
        return qtyTo;
    }

    public static BigDecimal getBaseUnitQty(MeasureUnitInfo mui, MaterialInfo mi, BigDecimal qty) {
        BigDecimal coefficient = new BigDecimal("1.00");
        BigDecimal baseQty = new BigDecimal("0.00000");
        if (qty != null) {
            baseQty = qty;
        } else {
            qty = baseQty;
        }
        try {
            MultiMeasureUnitInfo mulUnit = InvClientUtils.getMulUnit(mui, mi);
            if (mulUnit != null && (coefficient = mulUnit.getBaseConvsRate()) != null) {
                baseQty = qty.multiply(coefficient);
                MeasureUnitInfo baseUnit = mi.getBaseUnit();
                if (baseUnit == null) {
                    IMaterial im = MaterialFactory.getRemoteInstance();
                    baseUnit = im.getMaterialInfo((IObjectPK)new ObjectUuidPK(mi.getId())).getBaseUnit();
                }
                mulUnit = InvClientUtils.getMulUnit(baseUnit, mi);
                int precision = mulUnit.getQtyPrecision();
                baseQty = baseQty.setScale(precision, 4);
            }
            return baseQty;
        }
        catch (BaseException e) {
            ExceptionHandler.handle((Throwable)e);
            return null;
        }
    }

    public static BigDecimal getBaseUnitQtyByVO(MeasureUnitInfo mui, MaterialInfo mi, BigDecimal qty, SCMEntryDataVO outVO) {
        BigDecimal coefficient = new BigDecimal("1.00");
        BigDecimal baseQty = new BigDecimal("0.00000");
        if (qty != null) {
            baseQty = qty;
        } else {
            qty = baseQty;
        }
        try {
            if (outVO != null) {
                Integer precision = null;
                if (outVO.getMmuConvsRate() != null && outVO.getMmuConvsRate().size() > 0) {
                    coefficient = (BigDecimal)outVO.getMmuConvsRate().get(mi.getId().toString() + mui.getId().toString());
                }
                if (outVO.getMmuPrecisions() != null && outVO.getMmuPrecisions().size() > 0) {
                    precision = (Integer)outVO.getMmuPrecisions().get(mi.getId().toString() + mi.getBaseUnit().getId().toString());
                }
                baseQty = qty.multiply(coefficient);
                if (precision != null) {
                    baseQty = baseQty.setScale((int)precision, 4);
                }
            } else {
                MultiMeasureUnitInfo mulUnit = InvClientUtils.getMulUnit(mui, mi);
                if (mulUnit != null && (coefficient = mulUnit.getBaseConvsRate()) != null) {
                    baseQty = qty.multiply(coefficient);
                    MeasureUnitInfo baseUnit = mi.getBaseUnit();
                    if (baseUnit == null) {
                        IMaterial im = MaterialFactory.getRemoteInstance();
                        baseUnit = im.getMaterialInfo((IObjectPK)new ObjectUuidPK(mi.getId())).getBaseUnit();
                    }
                    mulUnit = InvClientUtils.getMulUnit(baseUnit, mi);
                    int precision = mulUnit.getQtyPrecision();
                    baseQty = baseQty.setScale(precision, 4);
                }
            }
            return baseQty;
        }
        catch (BaseException e) {
            ExceptionHandler.handle((Throwable)e);
            return null;
        }
    }

    public static BigDecimal getBaseUnitQty(MeasureUnitInfo mui, MaterialInfo mi, BigDecimal qty, SCMFetchData fetchData) {
        BigDecimal coefficient = new BigDecimal("1.00");
        BigDecimal baseQty = new BigDecimal("0.00000");
        if (qty != null) {
            baseQty = qty;
        } else {
            qty = baseQty;
        }
        try {
            if (mui != null && (coefficient = fetchData.getUnitbaseConvsRate(mi.getId().toString(), mui.getId().toString())) != null) {
                baseQty = qty.multiply(coefficient);
                int precision = fetchData.getUnitPrecision(mi.getId().toString(), mi.getBaseUnit().getId().toString());
                baseQty = baseQty.setScale(precision, 4);
            }
            return baseQty;
        }
        catch (BaseException e) {
            ExceptionHandler.handle((Throwable)e);
            return null;
        }
    }

    public static BigDecimal getConvsBaseQty(BigDecimal qty, BigDecimal convsRate, int precision) {
        BigDecimal coefficient = convsRate != null ? convsRate : new BigDecimal("1.00");
        BigDecimal baseQty = qty != null ? qty : new BigDecimal("0.00000");
        baseQty = baseQty.multiply(coefficient);
        baseQty = baseQty.setScale(precision, 4);
        return baseQty;
    }

    public static BigDecimal getAssUnitQty(MeasureUnitInfo mui, MaterialInfo mi, BigDecimal baseQty, SCMFetchData fetchData) throws EASBizException, BOSException {
        BigDecimal coefficient = null;
        BigDecimal assQty = new BigDecimal("0.00");
        if (baseQty != null) {
            assQty = baseQty;
        } else {
            baseQty = assQty;
        }
        if (mui != null) {
            BigDecimal temp = fetchData.getUnitbaseConvsRate(mi.getId().toString(), mui.getId().toString());
            coefficient = temp != null ? temp : new BigDecimal("1.00");
            int precision = fetchData.getUnitPrecision(mi.getId().toString(), mui.getId().toString());
            assQty = coefficient != null ? baseQty.divide(coefficient, precision, 4) : ZERO;
        }
        return assQty;
    }

    public static BigDecimal getAssUnitQty(MeasureUnitInfo mui, MaterialInfo mi, BigDecimal baseQty) throws BaseException {
        BigDecimal coefficient = new BigDecimal("1.00");
        BigDecimal assQty = ZERO;
        if (baseQty != null) {
            assQty = baseQty;
        } else {
            baseQty = assQty;
        }
        MultiMeasureUnitInfo mulUnit = InvClientUtils.getMulUnit(mui, mi);
        if (mulUnit != null) {
            coefficient = mulUnit.getBaseConvsRate();
            int precision = mulUnit.getQtyPrecision();
            if (coefficient != null) {
                assQty = baseQty.divide(coefficient, precision, 4);
            }
        } else {
            assQty = ZERO;
        }
        return assQty;
    }

    public static BigDecimal getConvsAssQty(BigDecimal baseQty, BigDecimal convsRate, int precision) {
        BigDecimal assQty;
        BigDecimal coefficient = convsRate != null ? convsRate : new BigDecimal("1.00");
        BigDecimal bigDecimal = assQty = baseQty != null ? baseQty : new BigDecimal("0.00000");
        if (baseQty != null) {
            assQty = baseQty.divide(coefficient, precision, 4);
        }
        return assQty;
    }

    public static BigDecimal getBaseQtyForAssQty(BigDecimal assQty, BigDecimal convsRate, int precision) {
        BigDecimal baseQty;
        BigDecimal coefficient = convsRate != null ? convsRate : SCMConstant.BIGDECIMAL_ONE;
        BigDecimal bigDecimal = baseQty = assQty != null ? assQty : SysConstant.BIGZERO;
        if (assQty != null) {
            baseQty = assQty.multiply(coefficient);
            baseQty = baseQty.setScale(precision, 4);
        }
        return baseQty;
    }

    public static BigDecimal getQtyForBaseQty(BigDecimal baseQty, BigDecimal convsRate, int precision) {
        BigDecimal qty;
        BigDecimal coefficient = convsRate != null ? convsRate : new BigDecimal("1.00");
        BigDecimal bigDecimal = qty = baseQty != null ? baseQty : new BigDecimal("0.00000");
        if (baseQty != null) {
            qty = baseQty.divide(coefficient, precision, 4);
        }
        return qty;
    }

    public static BigDecimal getConvsAssQtyFromQty(BigDecimal qty, BigDecimal qtyConvsRate, BigDecimal assistCovsRate, int precision) {
        BigDecimal coefficient = qtyConvsRate != null ? qtyConvsRate : new BigDecimal("1.00");
        BigDecimal baseQty = qty != null ? qty : new BigDecimal("0.00000");
        baseQty = baseQty.multiply(coefficient);
        coefficient = assistCovsRate != null ? assistCovsRate : new BigDecimal("1.00");
        BigDecimal assQty = baseQty != null ? baseQty : new BigDecimal("0.00000");
        assQty = baseQty != null ? baseQty.divide(coefficient, precision, 4) : new BigDecimal("0.00000");
        return assQty;
    }

    public static BigDecimal getUnitQty(MeasureUnitInfo mui, MaterialInfo mi, BigDecimal baseQty) throws BaseException {
        BigDecimal coefficient = new BigDecimal("1.00");
        BigDecimal qty = new BigDecimal("0.00");
        if (baseQty != null) {
            qty = baseQty;
        } else {
            baseQty = qty;
        }
        MultiMeasureUnitInfo mulUnit = InvClientUtils.getMulUnit(mui, mi);
        if (mulUnit != null) {
            coefficient = mulUnit.getBaseConvsRate();
            int precision = mulUnit.getQtyPrecision();
            if (coefficient != null) {
                qty = baseQty.divide(coefficient, precision, 4);
            }
        }
        return qty;
    }

    public static BigDecimal getUnitPrice(MeasureUnitInfo mui, MeasureUnitInfo mui2, MaterialInfo mi, BigDecimal basePrice) throws BaseException {
        BigDecimal coefficient = new BigDecimal("1.00");
        BigDecimal price = new BigDecimal("0.00");
        if (basePrice != null) {
            price = basePrice;
        }
        MultiMeasureUnitInfo mulUnit = InvClientUtils.getMulUnit(mui, mi);
        MultiMeasureUnitInfo mulUnit2 = InvClientUtils.getMulUnit(mui2, mi);
        if (mulUnit != null && mulUnit2 != null && (coefficient = mulUnit.getBaseConvsRate().divide(mulUnit2.getBaseConvsRate(), 18, 4)) != null) {
            price = price.multiply(coefficient);
        }
        price = price.setScale(mi.getPricePrecision(), 4);
        return price;
    }

    public static BigDecimal getUnitPrice(MeasureUnitInfo mui, MeasureUnitInfo mui2, MaterialInfo mi, BigDecimal basePrice, SCMFetchData fetchData) throws BaseException {
        BigDecimal coefficient = new BigDecimal("1.00");
        BigDecimal price = new BigDecimal("0.00");
        if (basePrice != null) {
            price = basePrice;
        }
        BigDecimal convRate1 = fetchData.getUnitbaseConvsRate(mi.getId().toString(), mui.getId().toString());
        BigDecimal convRate2 = fetchData.getUnitbaseConvsRate(mi.getId().toString(), mui2.getId().toString());
        if (mui != null && mui2 != null && (coefficient = convRate1.divide(convRate2, 18, 4)) != null) {
            price = price.multiply(coefficient);
        }
        price = price.setScale(mi.getPricePrecision(), 4);
        return price;
    }

    public static BigDecimal getUnitPrice(MeasureUnitInfo mui, MaterialInfo mi, BigDecimal basePrice) throws BaseException {
        MultiMeasureUnitInfo mulUnit;
        BigDecimal coefficient = new BigDecimal("1.00");
        BigDecimal price = new BigDecimal("0.00");
        if (basePrice != null) {
            price = basePrice;
        }
        if ((mulUnit = InvClientUtils.getMulUnit(mui, mi)) != null && (coefficient = mulUnit.getBaseConvsRate()) != null) {
            price = price.multiply(coefficient);
        }
        return price;
    }

    public static BigDecimal getUnitPriceByVO(MeasureUnitInfo mui, MaterialInfo mi, BigDecimal basePrice, SCMEntryDataVO outVO) throws BaseException {
        BigDecimal coefficient = new BigDecimal("1.00");
        BigDecimal price = new BigDecimal("0.00");
        if (basePrice != null) {
            price = basePrice;
        }
        if (outVO != null && outVO.getMmuConvsRate() != null && outVO.getMmuConvsRate().get(mi.getId().toString() + mui.getId().toString()) != null) {
            coefficient = (BigDecimal)outVO.getMmuConvsRate().get(mi.getId().toString() + mui.getId().toString());
        } else {
            MultiMeasureUnitInfo mulUnit = InvClientUtils.getMulUnit(mui, mi);
            coefficient = mulUnit.getBaseConvsRate();
        }
        if (coefficient != null) {
            price = price.multiply(coefficient);
        }
        return price;
    }

    public static BigDecimal getUnitPrice(MeasureUnitInfo mui, MaterialInfo mi, BigDecimal basePrice, SCMFetchData fetchData) throws EASBizException, BaseException {
        return SCMClientUtils.getUnitPrice((MeasureUnitInfo)mui, (MaterialInfo)mi, (BigDecimal)basePrice, (SCMFetchData)fetchData);
    }

    public static BigDecimal getUnitConvsPrice(BigDecimal basePrice, BigDecimal convsRate) {
        BigDecimal coefficient = convsRate != null ? convsRate : new BigDecimal("1.00");
        BigDecimal price = basePrice != null ? basePrice : new BigDecimal("0.00");
        price = price.multiply(coefficient);
        return price;
    }

    public static KDBizPromptBox getLocationF7(CoreUIObject ui, WarehouseInfo warehs) {
        KDBizPromptBox kDBizPromptBoxLocation = null;
        if (warehs != null) {
            EntityViewInfo viewInfo = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            FilterItemInfo storageFilterItemInfo = new FilterItemInfo("WAREHOUSE.ID", (Object)warehs.getId().toString());
            filterInfo.getFilterItems().add(storageFilterItemInfo);
            viewInfo.setFilter(filterInfo);
            kDBizPromptBoxLocation = new KDBizPromptBox();
            kDBizPromptBoxLocation.setEditable(true);
            try {
                kDBizPromptBoxLocation = LocationHelper.setLocationF7((CoreUIObject)ui, (KDBizPromptBox)kDBizPromptBoxLocation, (String)warehs.getId().toString());
            }
            catch (Exception e) {
                Logger.error((Throwable)e);
            }
        }
        return kDBizPromptBoxLocation;
    }

    public static String getPrecisionFormatStr(int count) {
        return PrecisionUtil.fmtTableString((int)count).toString();
    }

    public static int getMeasueUnitScale(String materialId, String unitId) throws EASBizException, BOSException {
        IMultiMeasureUnit immu = MultiMeasureUnitFactory.getRemoteInstance();
        return immu.getQtyPrecision(materialId, unitId);
    }

    public static MultiMeasureUnitInfo getMulUnit(MeasureUnitInfo mui, MaterialInfo mi) throws BaseException {
        MultiMeasureUnitInfo mulUnit = null;
        IMultiMeasureUnit immu = MultiMeasureUnitFactory.getRemoteInstance();
        if (mui != null && mi != null) {
            mulUnit = immu.getMultiUnit(mi.getId().toString(), mui.getId().toString());
        }
        return mulUnit;
    }

    public static OrgUnitCollection getSaleOrgsInfo(StorageOrgUnitInfo sou) {
        try {
            if (sou == null) {
                return null;
            }
            IOrgUnitRelation iUnitRel = OrgUnitRelationFactory.getRemoteInstance();
            OrgUnitCollection orgCol = iUnitRel.getToUnit(sou.getId().toString(), 4, 2);
            return orgCol;
        }
        catch (EASBizException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        return null;
    }

    public static SaleOrgUnitInfo getSaleOrgUnitInfo(StorageOrgUnitInfo sou) {
        SaleOrgUnitInfo ret = null;
        if (sou == null) {
            return null;
        }
        try {
            IOrgUnitRelation iUnitRel = OrgUnitRelationFactory.getRemoteInstance();
            ret = (SaleOrgUnitInfo)iUnitRel.getDefaultToUnit(sou.getId().toString(), 4, 2);
            if (ret == null) {
                OrgUnitCollection orgCol = iUnitRel.getToUnit(sou.getId().toString(), 4, 2);
                ret = (SaleOrgUnitInfo)orgCol.get(0);
            }
        }
        catch (EASBizException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        return ret;
    }

    public static OrgUnitCollection getPurOrgsColl(StorageOrgUnitInfo sou) {
        try {
            if (sou == null) {
                return null;
            }
            IOrgUnitRelation iUnitRel = OrgUnitRelationFactory.getRemoteInstance();
            OrgUnitCollection orgCol = iUnitRel.getToUnit(sou.getId().toString(), 4, 3);
            return orgCol;
        }
        catch (EASBizException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        return null;
    }

    public static PurchaseOrgUnitInfo getPurOrgsInfo(StorageOrgUnitInfo sou) {
        try {
            if (sou == null) {
                return null;
            }
            return SCMBillCommonFacadeFactory.getRemoteInstance().getPurchaseByStorageOrg(sou.getId().toString());
        }
        catch (EASBizException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        return null;
    }

    public static OrgUnitInfo getDefaultPurOrg(StorageOrgUnitInfo sou) {
        try {
            if (sou == null) {
                return null;
            }
            IOrgUnitRelation iUnitRel = OrgUnitRelationFactory.getRemoteInstance();
            OrgUnitInfo objValue = iUnitRel.getDefaultToUnit(sou.getId().toString(), 4, 3);
            if (objValue == null) {
                return null;
            }
            return objValue;
        }
        catch (EASBizException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        return null;
    }

    public static OrgUnitCollection getSalesInfo(CompanyOrgUnitInfo cou) {
        try {
            if (cou == null) {
                return null;
            }
            IOrgUnitRelation iUtilRel = OrgUnitRelationFactory.getRemoteInstance();
            OrgUnitCollection orgCol = iUtilRel.getFromUnit(cou.getId().toString(), 1, 2);
            return orgCol;
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        catch (EASBizException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        return null;
    }

    public static OrgUnitCollection getStorageUnitInfo(CompanyOrgUnitInfo cou) {
        try {
            if (cou == null) {
                return null;
            }
            IOrgUnitRelation iUnitRel = OrgUnitRelationFactory.getRemoteInstance();
            OrgUnitCollection orgCol = iUnitRel.getFromUnit(cou.getId().toString(), 1, 4);
            return orgCol;
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        catch (EASBizException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        return null;
    }

    public static OrgUnitCollection getStorageUnitInfo(String couId) {
        try {
            if (couId == null || "".equals(couId)) {
                return null;
            }
            IOrgUnitRelation iUnitRel = OrgUnitRelationFactory.getRemoteInstance();
            OrgUnitCollection orgCol = iUnitRel.getFromUnit(couId, 1, 4);
            return orgCol;
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        catch (EASBizException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        return null;
    }

    public static SaleOrgUnitInfo getSalesInfo(StorageOrgUnitInfo sou) {
        try {
            if (sou == null) {
                return null;
            }
            return SCMBillCommonFacadeFactory.getRemoteInstance().getSaleOrgByStorageOrg(sou.getId().toString());
        }
        catch (EASBizException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        return null;
    }

    public static CompanyOrgUnitInfo getCompanyInfo(StorageOrgUnitInfo sou) {
        if (sou == null) {
            return null;
        }
        try {
            ISCMBillCommonFacade iSCMBillCommonFacade = SCMBillCommonFacadeFactory.getRemoteInstance();
            return iSCMBillCommonFacade.getCompanyInfo(sou.getId());
        }
        catch (EASBizException ex) {
            ExceptionHandler.handle((Throwable)ex);
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        return null;
    }

    public static CompanyOrgUnitInfo getCompanyInfo(BOSUuid souId) {
        try {
            if (souId == null) {
                return null;
            }
            IOrgUnitRelation iUnitRel = OrgUnitRelationFactory.getRemoteInstance();
            OrgUnitCollection orgCol = iUnitRel.getToUnit(souId.toString(), 4, 1);
            CompanyOrgUnitInfo ret = (CompanyOrgUnitInfo)orgCol.get(0);
            return ret;
        }
        catch (EASBizException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        return null;
    }

    public static OrgUnitCollection getStorageCollection(PurchaseOrgUnitInfo pou) {
        try {
            if (pou == null) {
                return null;
            }
            IOrgUnitRelation iUnitRel = OrgUnitRelationFactory.getRemoteInstance();
            OrgUnitCollection orgCol = iUnitRel.getFromUnit(pou.getId().toString(), 3, 4);
            return orgCol;
        }
        catch (EASBizException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        return null;
    }

    public static OrgUnitCollection getStorageCollection(SaleOrgUnitInfo saleOU) {
        try {
            if (saleOU == null) {
                return null;
            }
            IOrgUnitRelation iUnitRel = OrgUnitRelationFactory.getRemoteInstance();
            OrgUnitCollection orgCol = iUnitRel.getFromUnit(saleOU.getId().toString(), 2, 4);
            return orgCol;
        }
        catch (EASBizException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        return null;
    }

    public static EntityViewInfo getSaleOrgF7Filter(OrgUnitCollection ouc) {
        if (ouc != null && ouc.size() > 0) {
            HashSet<String> set = new HashSet<String>();
            for (int i = 0; i < ouc.size(); ++i) {
                set.add(ouc.get(i).getId().toString());
            }
            EntityViewInfo evi = new EntityViewInfo();
            FilterInfo fi = new FilterInfo();
            fi.getFilterItems().add(new FilterItemInfo("id", set, CompareType.INCLUDE));
            evi.setFilter(fi);
            return evi;
        }
        return null;
    }

    public static EntityViewInfo getSaleOrgF7Filter(StorageOrgUnitInfo sou, OrgUnitCollection ouc) {
        CompanyOrgUnitInfo cou;
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("id", (Object)"", CompareType.EQUALS));
        evi.setFilter(fi);
        if (ouc != null && ouc.size() > 0 && (cou = InvClientUtils.getCompanyInfo(sou)) != null) {
            OrgUnitCollection saleColl = new OrgUnitCollection();
            HashSet<String> set = new HashSet<String>();
            CompanyOrgUnitInfo cou2 = null;
            SaleOrgUnitInfo saleOrgUnitInfo = null;
            for (int i = 0; i < ouc.size(); ++i) {
                saleOrgUnitInfo = (SaleOrgUnitInfo)ouc.get(i);
                cou2 = InvClientUtils.getCompanyInfo(saleOrgUnitInfo);
                if (cou2 == null || !cou2.getId().equals((Object)cou.getId())) continue;
                set.add(saleOrgUnitInfo.getId().toString());
                saleColl.add((OrgUnitInfo)saleOrgUnitInfo);
            }
            ouc.clear();
            ouc.addCollection(saleColl);
            evi = new EntityViewInfo();
            fi = new FilterInfo();
            fi.getFilterItems().add(new FilterItemInfo("id", set, CompareType.INCLUDE));
            evi.setFilter(fi);
            return evi;
        }
        return evi;
    }

    public static CompanyOrgUnitInfo getCompanyInfo(SaleOrgUnitInfo sou) {
        try {
            if (sou == null) {
                return null;
            }
            IOrgUnitRelation iUnitRel = OrgUnitRelationFactory.getRemoteInstance();
            CompanyOrgUnitInfo ret = (CompanyOrgUnitInfo)iUnitRel.getDefaultToUnit(sou.getId().toString(), 2, 1);
            if (ret == null) {
                OrgUnitCollection orgCol = iUnitRel.getToUnit(sou.getId().toString(), 2, 1);
                ret = (CompanyOrgUnitInfo)orgCol.get(0);
            }
            return ret;
        }
        catch (EASBizException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        return null;
    }

    public static CompanyOrgUnitInfo getCompanyInfo(PurchaseOrgUnitInfo pou) {
        try {
            if (pou == null) {
                return null;
            }
            IOrgUnitRelation iUnitRel = OrgUnitRelationFactory.getRemoteInstance();
            CompanyOrgUnitInfo ret = (CompanyOrgUnitInfo)iUnitRel.getDefaultToUnit(pou.getId().toString(), 3, 1);
            if (ret == null) {
                OrgUnitCollection orgCol = iUnitRel.getToUnit(pou.getId().toString(), 3, 1);
                ret = (CompanyOrgUnitInfo)orgCol.get(0);
            }
            return ret;
        }
        catch (EASBizException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        return null;
    }

    public static OrgUnitCollection getSaleOrgUniInfo(StorageOrgUnitInfo sou) {
        try {
            if (sou == null) {
                return null;
            }
            IOrgUnitRelation iUnitRel = OrgUnitRelationFactory.getRemoteInstance();
            OrgUnitCollection orgCol = iUnitRel.getToUnit(sou.getId().toString(), 4, 2);
            return orgCol;
        }
        catch (EASBizException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        return null;
    }

    public static CompanyOrgUnitInfo getCompanyInfo(AdminOrgUnitInfo adminOrg) {
        try {
            if (adminOrg == null) {
                return null;
            }
            IOrgUnitRelation iUnitRel = OrgUnitRelationFactory.getRemoteInstance();
            OrgUnitCollection orgCol = iUnitRel.getToUnit(adminOrg.getId().toString(), 0, 1);
            CompanyOrgUnitInfo ret = (CompanyOrgUnitInfo)orgCol.get(0);
            return ret;
        }
        catch (EASBizException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        return null;
    }

    public static CompanyOrgUnitInfo getCompanyInfo(FullOrgUnitInfo adminOrg) {
        try {
            if (adminOrg == null) {
                return null;
            }
            IOrgUnitRelation iUnitRel = OrgUnitRelationFactory.getRemoteInstance();
            OrgUnitCollection orgCol = iUnitRel.getToUnit(adminOrg.getId().toString(), 0, 1);
            CompanyOrgUnitInfo ret = (CompanyOrgUnitInfo)orgCol.get(0);
            return ret;
        }
        catch (EASBizException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        return null;
    }

    public static OrgUnitCollection getCompanyInfos(Object[] adminOrgs) {
        if (adminOrgs == null) {
            return null;
        }
        if (adminOrgs instanceof Object[]) {
            OrgUnitCollection coll = new OrgUnitCollection();
            CompanyOrgUnitInfo company = null;
            int size = adminOrgs.length;
            for (int index = 0; index < size; ++index) {
                company = adminOrgs[index] instanceof AdminOrgUnitInfo ? InvClientUtils.getCompanyInfo((AdminOrgUnitInfo)adminOrgs[index]) : InvClientUtils.getCompanyInfo((FullOrgUnitInfo)adminOrgs[index]);
                if (company == null) continue;
                coll.add((OrgUnitInfo)company);
            }
            return coll;
        }
        return null;
    }

    public static CompanyOrgUnitInfo getCompanyInfo(String storgeId) {
        CompanyOrgUnitInfo ret = null;
        if (storgeId != null) {
            try {
                IOrgUnitRelation iUnitRel = OrgUnitRelationFactory.getRemoteInstance();
                OrgUnitCollection orgCol = iUnitRel.getToUnit(storgeId, 4, 1);
                ret = (CompanyOrgUnitInfo)orgCol.get(0);
            }
            catch (EASBizException e) {
                ExceptionHandler.handle((Throwable)e);
            }
            catch (BOSException e) {
                ExceptionHandler.handle((Throwable)e);
            }
        }
        return ret;
    }

    public static EntityViewInfo getWarehouseFilter(StorageOrgUnitInfo sou) {
        EntityViewInfo viewInfo = null;
        try {
            viewInfo = InvClientUtils.getWarehouseFilter(sou, -1);
        }
        catch (EASBizException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        return viewInfo;
    }

    public static EntityViewInfo getWarehouseFilter(StorageOrgUnitInfo sou, int isStarted) throws EASBizException, BOSException {
        if (sou != null && sou.getId() != null) {
            EntityViewInfo viewInfo = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("STORAGEORGUNIT.ID", (Object)sou.getId().toString(), CompareType.EQUALS));
            if (isStarted != -1) {
                filterInfo.getFilterItems().add(new FilterItemInfo("SOWH.ISSTARTED", (Object)new Integer(isStarted), CompareType.EQUALS));
            }
            viewInfo.setFilter(filterInfo);
            return viewInfo;
        }
        return null;
    }

    public static EntityViewInfo getWarehouseFilterForMoveLocation(StorageOrgUnitInfo sou, int isStarted) throws EASBizException, BOSException {
        if (sou != null && sou.getId() != null) {
            EntityViewInfo viewInfo = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("STORAGEORGUNIT.ID", (Object)sou.getId().toString(), CompareType.EQUALS));
            filterInfo.getFilterItems().add(new FilterItemInfo("WAREHOUSE.HASLOCATION", (Object)"1", CompareType.EQUALS));
            if (isStarted != -1) {
                filterInfo.getFilterItems().add(new FilterItemInfo("SOWH.ISSTARTED", (Object)new Integer(isStarted), CompareType.EQUALS));
            }
            viewInfo.setFilter(filterInfo);
            return viewInfo;
        }
        return null;
    }

    public static EntityViewInfo getWarehouseFilter(StorageOrgUnitInfo sou, PeriodInfo curPeriod, int isStarted) throws EASBizException, BOSException {
        if (sou != null && sou.getId() != null) {
            EntityViewInfo viewInfo = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("STORAGEORGUNIT.ID", (Object)sou.getId().toString(), CompareType.EQUALS));
            if (isStarted != -1) {
                filterInfo.getFilterItems().add(new FilterItemInfo("SOWH.ISSTARTED", (Object)new Integer(isStarted), CompareType.EQUALS));
            }
            if (curPeriod != null) {
                filterInfo.getFilterItems().add(new FilterItemInfo("sowhPeriod.id", (Object)curPeriod.getId().toString(), CompareType.EQUALS));
            }
            viewInfo.setFilter(filterInfo);
            return viewInfo;
        }
        return null;
    }

    public static EntityViewInfo getWarehouseFilter(StorageOrgUnitInfo souFrom, StorageOrgUnitInfo souTo, int isStarted) throws EASBizException, BOSException {
        if (souFrom == null && souTo == null) {
            return null;
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        if (souFrom != null && souTo == null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("STORAGEORG.NUMBER", (Object)souFrom.getNumber(), CompareType.GREATER_EQUALS));
        } else if (souFrom == null && souTo != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("STORAGEORG.NUMBER", (Object)souTo.getNumber(), CompareType.LESS_EQUALS));
        } else if (souFrom != null && souTo != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("STORAGEORG.NUMBER", (Object)souFrom.getNumber(), CompareType.GREATER_EQUALS));
            filterInfo.getFilterItems().add(new FilterItemInfo("STORAGEORG.NUMBER", (Object)souTo.getNumber(), CompareType.LESS_EQUALS));
        }
        if (isStarted != -1) {
            filterInfo.getFilterItems().add(new FilterItemInfo("SOWH.ISSTARTED", (Object)new Integer(isStarted), CompareType.EQUALS));
        }
        viewInfo.setFilter(filterInfo);
        return viewInfo;
    }

    public static EntityViewInfo getWarehouseFilter(Set sous, int isStarted) throws EASBizException, BOSException {
        if (sous != null && sous.size() > 0) {
            EntityViewInfo viewInfo = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("STORAGEORGUNIT.ID", (Object)sous, CompareType.INCLUDE));
            if (isStarted != -1) {
                filterInfo.getFilterItems().add(new FilterItemInfo("SOWH.ISSTARTED", (Object)new Integer(isStarted), CompareType.EQUALS));
            }
            viewInfo.setFilter(filterInfo);
            return viewInfo;
        }
        return null;
    }

    public static Set getStoragesIDSet(CompanyOrgUnitInfo company) {
        HashSet<String> storageSet = new HashSet<String>();
        OrgUnitCollection storageColl = InvClientUtils.getStorageUnitInfo(company);
        if (storageColl != null) {
            int size = storageColl.size();
            OrgUnitInfo org = null;
            for (int index = 0; index < size; ++index) {
                org = storageColl.get(index);
                storageSet.add(org.getId().toString());
            }
        }
        return storageSet;
    }

    public static Set getSaleOrgIDSet(CompanyOrgUnitInfo company) {
        HashSet<String> saleSet = new HashSet<String>();
        OrgUnitCollection storageColl = InvClientUtils.getSalesInfo(company);
        if (storageColl != null) {
            int size = storageColl.size();
            OrgUnitInfo org = null;
            for (int index = 0; index < size; ++index) {
                org = storageColl.get(index);
                saleSet.add(org.getId().toString());
            }
        }
        return saleSet;
    }

    public static EntityViewInfo getWarehouseFilter(CompanyOrgUnitInfo companyInfo, int isStarted) throws EASBizException, BOSException {
        if (companyInfo == null) {
            return null;
        }
        Set storageSet = InvClientUtils.getStoragesIDSet(companyInfo);
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("STORAGEORG.ID", (Object)storageSet, CompareType.INCLUDE));
        if (isStarted != -1) {
            filterInfo.getFilterItems().add(new FilterItemInfo("SOWH.ISSTARTED", (Object)new Integer(isStarted), CompareType.EQUALS));
        }
        viewInfo.setFilter(filterInfo);
        return viewInfo;
    }

    public static void setLocationFilter(CoreUIObject ui, StorageOrgUnitInfo sou, WarehouseInfo warehouseInfo, MaterialInfo mi, SCMFetchData fetchData, String locationFieldName, KDTable kdtEntry, int rowIndex, boolean isOnload) {
        if (warehouseInfo == null) {
            if (!isOnload) {
                kdtEntry.getRow(rowIndex).getCell(kdtEntry.getColumnIndex(locationFieldName)).setValue(null);
            }
            SCMClientUtils.setNecessColorInCells((KDTable)kdtEntry, (String)locationFieldName, (int)rowIndex, (boolean)false);
            kdtEntry.getRow(rowIndex).getCell(kdtEntry.getColumnIndex(locationFieldName)).getStyleAttributes().setLocked(true);
            return;
        }
        if (warehouseInfo.isHasLocation()) {
            if (!isOnload) {
                LocationInfo defaultloc = null;
                if (fetchData == null || fetchData.getMapDefaultLocation() == null || mi == null) {
                    defaultloc = InvClientUtils.getDefaultLocation(sou, mi, warehouseInfo);
                } else {
                    try {
                        defaultloc = fetchData.getDefaultGroupLocation(mi.getId().toString(), warehouseInfo.getId().toString(), sou.getId().toString());
                        if (defaultloc == null) {
                            defaultloc = InvClientUtils.getDefaultLocation(sou, mi, warehouseInfo);
                        }
                        MaterialGroupInfo materialGroup = InvClientUtils.getMaterialGroupByMaterial(mi);
                        if (defaultloc == null && materialGroup != null && materialGroup.getId() != null) {
                            defaultloc = fetchData.getDefaultGroupLocation(materialGroup.getId().toString(), warehouseInfo.getId().toString(), sou.getId().toString());
                        }
                    }
                    catch (Exception e) {
                        ExceptionHandler.handle((Throwable)e);
                    }
                }
                LocationInfo lctation = (LocationInfo)kdtEntry.getRow(rowIndex).getCell(locationFieldName).getValue();
                if (lctation == null && defaultloc != null) {
                    lctation = defaultloc;
                }
                kdtEntry.getRow(rowIndex).getCell(kdtEntry.getColumnIndex(locationFieldName)).setValue((Object)lctation);
            }
            kdtEntry.getRow(rowIndex).getCell(kdtEntry.getColumnIndex(locationFieldName)).getStyleAttributes().setLocked(false);
            SCMClientUtils.setNecessColorInCells((KDTable)kdtEntry, (String)locationFieldName, (int)rowIndex, (boolean)true);
            EntityViewInfo viewInfo = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            FilterItemInfo storageFilterItemInfo = new FilterItemInfo("WAREHOUSE.ID", (Object)warehouseInfo.getId().toString());
            filterInfo.getFilterItems().add(storageFilterItemInfo);
            viewInfo.setFilter(filterInfo);
            KDBizPromptBox kDBizPromptBoxLocation = new KDBizPromptBox();
            kDBizPromptBoxLocation.setEditable(true);
            try {
                kDBizPromptBoxLocation = sou != null && sou.getId() != null ? LocationHelper.setLocationF7((CoreUIObject)ui, (KDBizPromptBox)kDBizPromptBoxLocation, (String)warehouseInfo.getId().toString(), (String)sou.getId().toString()) : LocationHelper.setLocationF7((CoreUIObject)ui, (KDBizPromptBox)kDBizPromptBoxLocation, (String)warehouseInfo.getId().toString());
            }
            catch (Exception e) {
                Logger.error((Throwable)e);
            }
            kdtEntry.getRow(rowIndex).getCell(kdtEntry.getColumnIndex(locationFieldName)).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)kDBizPromptBoxLocation));
        } else {
            kdtEntry.getRow(rowIndex).getCell(kdtEntry.getColumnIndex(locationFieldName)).setValue(null);
            kdtEntry.getRow(rowIndex).getCell(kdtEntry.getColumnIndex(locationFieldName)).getStyleAttributes().setLocked(true);
            SCMClientUtils.setNecessColorInCells((KDTable)kdtEntry, (String)locationFieldName, (int)rowIndex, (boolean)false);
        }
    }

    public static void setLocationFilter(CoreUIObject ui, StorageOrgUnitInfo sou, WarehouseInfo warehouseInfo, MaterialInfo mi, SCMFetchData fetchData, KDTable kdtEntry, int rowIndex, boolean isOnload) {
        InvClientUtils.setLocationFilter(ui, sou, warehouseInfo, mi, fetchData, LOCATION, kdtEntry, rowIndex, isOnload);
    }

    public static void setLocationFilter(CoreUIObject ui, StorageOrgUnitInfo sou, WarehouseInfo warehouseInfo, MaterialInfo mi, KDTable kdtEntry, int rowIndex, boolean isOnload, SCMFetchData fetchData) {
        InvClientUtils.setLocationFilter(ui, sou, warehouseInfo, mi, fetchData, kdtEntry, rowIndex, isOnload);
    }

    public static void setLocationFilterForColName(CoreUIObject ui, StorageOrgUnitInfo sou, WarehouseInfo warehouseInfo, MaterialInfo mi, KDTable kdtEntry, int rowIndex, boolean isOnload, String locationColName) {
        if (warehouseInfo == null) {
            if (!isOnload) {
                kdtEntry.getRow(rowIndex).getCell(kdtEntry.getColumnIndex(locationColName)).setValue(null);
            }
            SCMClientUtils.setNecessColorInCells((KDTable)kdtEntry, (String)locationColName, (int)rowIndex, (boolean)false);
            kdtEntry.getRow(rowIndex).getCell(kdtEntry.getColumnIndex(locationColName)).getStyleAttributes().setLocked(true);
            return;
        }
        if (warehouseInfo.isHasLocation()) {
            if (!isOnload) {
                LocationInfo defaultloc = InvClientUtils.getDefaultLocation(sou, mi, warehouseInfo);
                LocationInfo lctation = (LocationInfo)kdtEntry.getRow(rowIndex).getCell(locationColName).getValue();
                if (defaultloc != null) {
                    lctation = defaultloc;
                }
                kdtEntry.getRow(rowIndex).getCell(kdtEntry.getColumnIndex(locationColName)).setValue((Object)lctation);
            }
            kdtEntry.getRow(rowIndex).getCell(kdtEntry.getColumnIndex(locationColName)).getStyleAttributes().setLocked(false);
            SCMClientUtils.setNecessColorInCells((KDTable)kdtEntry, (String)locationColName, (int)rowIndex, (boolean)true);
            EntityViewInfo viewInfo = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            FilterItemInfo storageFilterItemInfo = new FilterItemInfo("WAREHOUSE.ID", (Object)warehouseInfo.getId().toString());
            filterInfo.getFilterItems().add(storageFilterItemInfo);
            viewInfo.setFilter(filterInfo);
            KDBizPromptBox kDBizPromptBoxLocation = new KDBizPromptBox();
            kDBizPromptBoxLocation.setEditable(true);
            try {
                kDBizPromptBoxLocation = sou != null && sou.getId() != null ? LocationHelper.setLocationF7((CoreUIObject)ui, (KDBizPromptBox)kDBizPromptBoxLocation, (String)warehouseInfo.getId().toString(), (String)sou.getId().toString()) : LocationHelper.setLocationF7((CoreUIObject)ui, (KDBizPromptBox)kDBizPromptBoxLocation, (String)warehouseInfo.getId().toString());
            }
            catch (Exception e) {
                Logger.error((Throwable)e);
            }
            kdtEntry.getRow(rowIndex).getCell(kdtEntry.getColumnIndex(locationColName)).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)kDBizPromptBoxLocation));
        } else {
            if (!isOnload) {
                kdtEntry.getRow(rowIndex).getCell(kdtEntry.getColumnIndex(locationColName)).setValue(null);
            }
            kdtEntry.getRow(rowIndex).getCell(kdtEntry.getColumnIndex(locationColName)).getStyleAttributes().setLocked(true);
            SCMClientUtils.setNecessColorInCells((KDTable)kdtEntry, (String)locationColName, (int)rowIndex, (boolean)false);
        }
    }

    public static void setLocationFilterForStockTransferByMSRelation(CoreUIObject ui, StorageOrgUnitInfo sou, WarehouseInfo warehouseInfo, MaterialInfo mi, KDTable kdtEntry, int rowIndex, boolean isOnload, String locationColName) {
        if (warehouseInfo == null) {
            if (!isOnload) {
                kdtEntry.getRow(rowIndex).getCell(kdtEntry.getColumnIndex(locationColName)).setValue(null);
            }
            SCMClientUtils.setNecessColorInCells((KDTable)kdtEntry, (String)locationColName, (int)rowIndex, (boolean)false);
            kdtEntry.getRow(rowIndex).getCell(kdtEntry.getColumnIndex(locationColName)).getStyleAttributes().setLocked(true);
            return;
        }
        if (warehouseInfo.isHasLocation()) {
            if (!isOnload) {
                LocationInfo defaultloc = InvClientUtils.getDefaultLocation(sou, mi, warehouseInfo);
                LocationInfo lctation = (LocationInfo)kdtEntry.getRow(rowIndex).getCell(locationColName).getValue();
                if (defaultloc != null) {
                    lctation = defaultloc;
                }
                kdtEntry.getRow(rowIndex).getCell(kdtEntry.getColumnIndex(locationColName)).setValue((Object)lctation);
            }
            kdtEntry.getRow(rowIndex).getCell(kdtEntry.getColumnIndex(locationColName)).getStyleAttributes().setLocked(false);
            SCMClientUtils.setNecessColorInCells((KDTable)kdtEntry, (String)locationColName, (int)rowIndex, (boolean)true);
            EntityViewInfo viewInfo = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("assignStorageOrgUnit.id", (Object)sou.getId().toString()));
            filterInfo.getFilterItems().add(new FilterItemInfo("assignWarehouse.id", (Object)warehouseInfo.getId().toString()));
            if (mi != null) {
                filterInfo.getFilterItems().add(new FilterItemInfo("assignMaterial.id", (Object)mi.getId().toString()));
            }
            try {
                MaterialGroupInfo materialGroupInfo = InvClientUtils.getMaterialGroupByMaterial(mi);
                if (null != materialGroupInfo) {
                    String longNumber = materialGroupInfo.getLongNumber();
                    HashSet<String> longNumbers = new HashSet<String>();
                    longNumbers.add(longNumber);
                    int index = longNumber.indexOf("!", 0);
                    String lNumber = null;
                    while (index > 0) {
                        lNumber = longNumber.substring(0, index);
                        if (!StringUtil.isEmpty((String)lNumber)) {
                            longNumbers.add(lNumber);
                        }
                        index = longNumber.indexOf("!", index + 1);
                    }
                    filterInfo.getFilterItems().add(new FilterItemInfo("materialGroup.longNumber", longNumbers, CompareType.INCLUDE));
                    filterInfo.getFilterItems().add(new FilterItemInfo("materialStorageAssign.storageAssignType", (Object)new Integer(1), CompareType.EQUALS));
                    filterInfo.setMaskString(" #0 and #1 and (#2 or (#3 and #4))");
                }
            }
            catch (Exception e1) {
                Logger.error((Throwable)e1);
            }
            viewInfo.setFilter(filterInfo);
            KDBizPromptBox kDBizPromptBoxLocation = new KDBizPromptBox();
            kDBizPromptBoxLocation.setEditable(true);
            try {
                kDBizPromptBoxLocation = LocationHelper.setLocationF7((CoreUIObject)ui, (KDBizPromptBox)kDBizPromptBoxLocation, (String)warehouseInfo.getId().toString(), (FilterInfo)filterInfo);
            }
            catch (Exception e) {
                Logger.error((Throwable)e);
            }
            kdtEntry.getRow(rowIndex).getCell(kdtEntry.getColumnIndex(locationColName)).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)kDBizPromptBoxLocation));
        } else {
            if (!isOnload) {
                kdtEntry.getRow(rowIndex).getCell(kdtEntry.getColumnIndex(locationColName)).setValue(null);
            }
            kdtEntry.getRow(rowIndex).getCell(kdtEntry.getColumnIndex(locationColName)).getStyleAttributes().setLocked(true);
            SCMClientUtils.setNecessColorInCells((KDTable)kdtEntry, (String)locationColName, (int)rowIndex, (boolean)false);
        }
    }

    public static void setLocationFilterForColNameStockTransfer(CoreUIObject ui, StorageOrgUnitInfo sou, WarehouseInfo warehouseInfo, MaterialInfo mi, KDTable kdtEntry, int rowIndex, boolean isOnload, String locationColName) {
        if (warehouseInfo == null) {
            if (!isOnload) {
                kdtEntry.getRow(rowIndex).getCell(kdtEntry.getColumnIndex(locationColName)).setValue(null);
            }
            kdtEntry.getRow(rowIndex).getCell(kdtEntry.getColumnIndex(locationColName)).getStyleAttributes().setLocked(true);
            return;
        }
        if (warehouseInfo.isHasLocation()) {
            if (!isOnload) {
                LocationInfo defaultloc = InvClientUtils.getDefaultLocation(sou, mi, warehouseInfo);
                LocationInfo lctation = (LocationInfo)kdtEntry.getRow(rowIndex).getCell(locationColName).getValue();
                if (defaultloc != null) {
                    lctation = defaultloc;
                }
                kdtEntry.getRow(rowIndex).getCell(kdtEntry.getColumnIndex(locationColName)).setValue((Object)lctation);
            }
            kdtEntry.getRow(rowIndex).getCell(kdtEntry.getColumnIndex(locationColName)).getStyleAttributes().setLocked(false);
            EntityViewInfo viewInfo = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            FilterItemInfo storageFilterItemInfo = new FilterItemInfo("WAREHOUSE.ID", (Object)warehouseInfo.getId().toString());
            filterInfo.getFilterItems().add(storageFilterItemInfo);
            viewInfo.setFilter(filterInfo);
            KDBizPromptBox kDBizPromptBoxLocation = new KDBizPromptBox();
            kDBizPromptBoxLocation.setEditable(true);
            try {
                kDBizPromptBoxLocation = sou != null && sou.getId() != null ? LocationHelper.setLocationF7((CoreUIObject)ui, (KDBizPromptBox)kDBizPromptBoxLocation, (String)warehouseInfo.getId().toString(), (String)sou.getId().toString()) : LocationHelper.setLocationF7((CoreUIObject)ui, (KDBizPromptBox)kDBizPromptBoxLocation, (String)warehouseInfo.getId().toString());
            }
            catch (Exception e) {
                Logger.error((Throwable)e);
            }
            kdtEntry.getRow(rowIndex).getCell(kdtEntry.getColumnIndex(locationColName)).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)kDBizPromptBoxLocation));
        } else {
            if (!isOnload) {
                kdtEntry.getRow(rowIndex).getCell(kdtEntry.getColumnIndex(locationColName)).setValue(null);
            }
            kdtEntry.getRow(rowIndex).getCell(kdtEntry.getColumnIndex(locationColName)).getStyleAttributes().setLocked(true);
        }
    }

    public static void setLocationFilterForColNameTransferOrder(CoreUIObject ui, StorageOrgUnitInfo sou, WarehouseInfo warehouseInfo, MaterialInfo mi, KDTable kdtEntry, int rowIndex, boolean isOnload, String locationColName) {
        if (warehouseInfo == null) {
            if (!isOnload) {
                kdtEntry.getRow(rowIndex).getCell(kdtEntry.getColumnIndex(locationColName)).setValue(null);
            }
            kdtEntry.getRow(rowIndex).getCell(kdtEntry.getColumnIndex(locationColName)).getStyleAttributes().setLocked(true);
            return;
        }
        if (warehouseInfo.isHasLocation()) {
            if (!isOnload) {
                LocationInfo defaultloc = InvClientUtils.getDefaultLocation(sou, mi, warehouseInfo);
                LocationInfo lctation = (LocationInfo)kdtEntry.getRow(rowIndex).getCell(locationColName).getValue();
                if (defaultloc != null) {
                    lctation = defaultloc;
                }
                kdtEntry.getRow(rowIndex).getCell(kdtEntry.getColumnIndex(locationColName)).setValue((Object)lctation);
            }
            kdtEntry.getRow(rowIndex).getCell(kdtEntry.getColumnIndex(locationColName)).getStyleAttributes().setLocked(false);
            EntityViewInfo viewInfo = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            FilterItemInfo storageFilterItemInfo = new FilterItemInfo("WAREHOUSE.ID", (Object)warehouseInfo.getId().toString());
            filterInfo.getFilterItems().add(storageFilterItemInfo);
            viewInfo.setFilter(filterInfo);
            KDBizPromptBox prmt = new KDBizPromptBox();
            try {
                prmt = sou != null && sou.getId() != null ? LocationHelper.setLocationF7((CoreUIObject)ui, (KDBizPromptBox)prmt, (String)warehouseInfo.getId().toString(), (String)sou.getId().toString()) : LocationHelper.setLocationF7((CoreUIObject)ui, (KDBizPromptBox)prmt, (String)warehouseInfo.getId().toString());
            }
            catch (Exception e) {
                Logger.error((Throwable)e);
            }
            kdtEntry.getRow(rowIndex).getCell(kdtEntry.getColumnIndex(locationColName)).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)prmt));
        } else {
            if (!isOnload) {
                kdtEntry.getRow(rowIndex).getCell(kdtEntry.getColumnIndex(locationColName)).setValue(null);
            }
            kdtEntry.getRow(rowIndex).getCell(kdtEntry.getColumnIndex(locationColName)).getStyleAttributes().setLocked(true);
        }
    }

    public static void setWarehouseFitler(StorageOrgUnitInfo sou, KDTable kdtEntry, String fieldName, int isStarted) {
        try {
            if (sou != null) {
                KDTDefaultCellEditor editor;
                KDBizPromptBox kDBizPromptBoxWarehouse = null;
                if (kdtEntry.getColumn(fieldName).getEditor() != null && (editor = (KDTDefaultCellEditor)kdtEntry.getColumn(fieldName).getEditor()).getComponent() != null) {
                    kDBizPromptBoxWarehouse = (KDBizPromptBox)editor.getComponent();
                }
                if (kDBizPromptBoxWarehouse == null) {
                    kDBizPromptBoxWarehouse = new KDBizPromptBox();
                }
                kDBizPromptBoxWarehouse.setEditable(true);
                kDBizPromptBoxWarehouse.setQueryInfo("com.kingdee.eas.basedata.scm.im.inv.app.F7WarehouseQuery");
                kDBizPromptBoxWarehouse.setDisplayFormat("$name$");
                kDBizPromptBoxWarehouse.setEditFormat("$number$;$name$");
                kDBizPromptBoxWarehouse.setCommitFormat("$number$;$name$");
                kDBizPromptBoxWarehouse.setEntityViewInfo(SCMBaseCommonUtil.getWarehouseFilter((String)sou.getId().toString(), (int)isStarted));
                kDBizPromptBoxWarehouse.getQueryAgent().resetRuntimeEntityView();
                kdtEntry.getColumn(fieldName).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)kDBizPromptBoxWarehouse));
            } else {
                kdtEntry.getColumn(fieldName).getStyleAttributes().setLocked(true);
            }
        }
        catch (EASBizException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
        }
    }

    public static void setWarehouseFitlerForMoveLocation(StorageOrgUnitInfo sou, KDTable kdtEntry, String fieldName, int isStarted) {
        try {
            if (sou != null) {
                KDTDefaultCellEditor editor;
                KDBizPromptBox kDBizPromptBoxWarehouse = null;
                if (kdtEntry.getColumn(fieldName).getEditor() != null && (editor = (KDTDefaultCellEditor)kdtEntry.getColumn(fieldName).getEditor()).getComponent() != null) {
                    kDBizPromptBoxWarehouse = (KDBizPromptBox)editor.getComponent();
                }
                if (kDBizPromptBoxWarehouse == null) {
                    kDBizPromptBoxWarehouse = new KDBizPromptBox();
                }
                kDBizPromptBoxWarehouse.setEditable(true);
                kDBizPromptBoxWarehouse.setQueryInfo("com.kingdee.eas.basedata.scm.im.inv.app.F7WarehouseQuery");
                kDBizPromptBoxWarehouse.setDisplayFormat("$name$");
                kDBizPromptBoxWarehouse.setEditFormat("$number$");
                kDBizPromptBoxWarehouse.setCommitFormat("$number$;$name$");
                kDBizPromptBoxWarehouse.setEntityViewInfo(InvClientUtils.getWarehouseFilterForMoveLocation(sou, isStarted));
                kDBizPromptBoxWarehouse.getQueryAgent().resetRuntimeEntityView();
                kdtEntry.getColumn(fieldName).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)kDBizPromptBoxWarehouse));
            } else {
                kdtEntry.getColumn(fieldName).getStyleAttributes().setLocked(true);
            }
        }
        catch (EASBizException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
        }
    }

    public static void setWarehouseFitler(StorageOrgUnitInfo sou, KDTable kdtEntry, int rowIndex, String fieldName, int isStarted) {
        try {
            if (sou != null) {
                KDTDefaultCellEditor editor;
                KDBizPromptBox kDBizPromptBoxWarehouse = null;
                if (kdtEntry.getCell(rowIndex, fieldName).getEditor() != null && null != (editor = (KDTDefaultCellEditor)kdtEntry.getCell(rowIndex, fieldName).getEditor()) && editor.getComponent() != null) {
                    kDBizPromptBoxWarehouse = (KDBizPromptBox)editor.getComponent();
                }
                if (kDBizPromptBoxWarehouse == null) {
                    kDBizPromptBoxWarehouse = new KDBizPromptBox();
                }
                kDBizPromptBoxWarehouse.setEditable(true);
                kDBizPromptBoxWarehouse.setQueryInfo("com.kingdee.eas.basedata.scm.im.inv.app.F7WarehouseQuery");
                kDBizPromptBoxWarehouse.setDisplayFormat("$name$");
                kDBizPromptBoxWarehouse.setEditFormat("$number$");
                kDBizPromptBoxWarehouse.setCommitFormat("$number$;$name$");
                kDBizPromptBoxWarehouse.setEntityViewInfo(InvClientUtils.getWarehouseFilter(sou, isStarted));
                kdtEntry.getCell(rowIndex, fieldName).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)kDBizPromptBoxWarehouse));
            } else {
                kdtEntry.getCell(rowIndex, fieldName).getStyleAttributes().setLocked(true);
            }
        }
        catch (EASBizException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
        }
    }

    public static void setWarehouseFitler(StorageOrgUnitInfo sou, KDTable kdtEntry, String warehouseFieldName, String materialFieldName, int isStarted, boolean isUseWarehsRelation) {
        if (isUseWarehsRelation) {
            int rowCount = kdtEntry.getRowCount();
            for (int i = 0; i < rowCount; ++i) {
                MaterialInfo materialInfo = (MaterialInfo)kdtEntry.getCell(i, materialFieldName).getValue();
                if (null == materialInfo) {
                    InvClientUtils.setWarehouseFitler(sou, kdtEntry, i, warehouseFieldName, isStarted);
                    continue;
                }
                InvClientUtils.setWarehouseFitlerByMSRelation(sou, materialInfo, kdtEntry, i, warehouseFieldName, isStarted);
            }
        } else {
            InvClientUtils.setWarehouseFitler(sou, kdtEntry, warehouseFieldName, isStarted);
        }
    }

    public static void setWarehouseFitlerByMSRelation(StorageOrgUnitInfo sou, MaterialInfo materialInfo, KDTable kdtEntry, int row, String fieldName, int isStarted) {
        try {
            if (sou != null && materialInfo != null) {
                KDTDefaultCellEditor editor;
                KDBizPromptBox kDBizPromptBoxWarehouse = null;
                if (kdtEntry.getCell(row, fieldName).getEditor() != null && null != (editor = (KDTDefaultCellEditor)kdtEntry.getCell(row, fieldName).getEditor()) && editor.getComponent() != null) {
                    kDBizPromptBoxWarehouse = (KDBizPromptBox)editor.getComponent();
                }
                if (kDBizPromptBoxWarehouse == null) {
                    kDBizPromptBoxWarehouse = new KDBizPromptBox();
                }
                kDBizPromptBoxWarehouse.setEditable(true);
                kDBizPromptBoxWarehouse.setQueryInfo("com.kingdee.eas.basedata.scm.im.inv.app.F7WarehouseByMSAssignQuery");
                kDBizPromptBoxWarehouse.setDisplayFormat("$name$");
                kDBizPromptBoxWarehouse.setEditFormat("$number$");
                kDBizPromptBoxWarehouse.setCommitFormat("$number$;$name$");
                EntityViewInfo viewInfo = new EntityViewInfo();
                FilterInfo filterInfo = new FilterInfo();
                filterInfo.getFilterItems().add(new FilterItemInfo("assignStorageOrgUnit.id", (Object)sou.getId().toString(), CompareType.EQUALS));
                filterInfo.getFilterItems().add(new FilterItemInfo("assignMaterial.id", (Object)materialInfo.getId().toString(), CompareType.EQUALS));
                int conditionCount = 2;
                StringBuffer maskString = new StringBuffer("( ");
                MaterialGroupInfo materialGroupInfo = InvClientUtils.getMaterialGroupByMaterial(materialInfo);
                if (null != materialGroupInfo) {
                    String longNumber = materialGroupInfo.getLongNumber();
                    HashSet<String> longNumbers = new HashSet<String>();
                    longNumbers.add(longNumber);
                    int index = longNumber.indexOf("!", 0);
                    String lNumber = null;
                    while (index > 0) {
                        lNumber = longNumber.substring(0, index);
                        if (!StringUtil.isEmpty((String)lNumber)) {
                            longNumbers.add(lNumber);
                        }
                        index = longNumber.indexOf("!", index + 1);
                    }
                    filterInfo.getFilterItems().add(new FilterItemInfo("materialGroup.longNumber", longNumbers, CompareType.INCLUDE));
                    filterInfo.getFilterItems().add(new FilterItemInfo("materialStorageAssign.storageAssignType", (Object)"1", CompareType.EQUALS));
                    maskString.append(" #0 and (#1 or (#2 and #3)) ");
                    conditionCount += 2;
                } else {
                    maskString.append(" #0 and #1 ");
                }
                if (isStarted != -1) {
                    filterInfo.getFilterItems().add(new FilterItemInfo("SOWH.ISSTARTED", (Object)new Integer(isStarted), CompareType.EQUALS));
                    maskString.append(" and #" + conditionCount);
                }
                maskString.append(" )");
                filterInfo.setMaskString(maskString.toString());
                viewInfo.setFilter(filterInfo);
                kDBizPromptBoxWarehouse.setEntityViewInfo(viewInfo);
                kDBizPromptBoxWarehouse.getQueryAgent().resetRuntimeEntityView();
                kdtEntry.getCell(row, fieldName).getStyleAttributes().setLocked(false);
                kdtEntry.getCell(row, fieldName).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)kDBizPromptBoxWarehouse));
            } else {
                kdtEntry.getColumn(fieldName).getStyleAttributes().setLocked(true);
            }
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
    }

    public static void setWarehouseFitlerByMSRelationForMoveLocation(StorageOrgUnitInfo sou, MaterialInfo materialInfo, KDTable kdtEntry, int row, String fieldName, int isStarted) {
        try {
            if (sou != null && materialInfo != null) {
                KDTDefaultCellEditor editor;
                KDBizPromptBox kDBizPromptBoxWarehouse = null;
                if (kdtEntry.getCell(row, fieldName).getEditor() != null && null != (editor = (KDTDefaultCellEditor)kdtEntry.getCell(row, fieldName).getEditor()) && editor.getComponent() != null) {
                    kDBizPromptBoxWarehouse = (KDBizPromptBox)editor.getComponent();
                }
                if (kDBizPromptBoxWarehouse == null) {
                    kDBizPromptBoxWarehouse = new KDBizPromptBox();
                }
                kDBizPromptBoxWarehouse.setEditable(true);
                kDBizPromptBoxWarehouse.setQueryInfo("com.kingdee.eas.basedata.scm.im.inv.app.F7WarehouseByMSAssignQuery");
                kDBizPromptBoxWarehouse.setDisplayFormat("$name$");
                kDBizPromptBoxWarehouse.setEditFormat("$number$");
                kDBizPromptBoxWarehouse.setCommitFormat("$number$;$name$");
                EntityViewInfo viewInfo = new EntityViewInfo();
                FilterInfo filterInfo = new FilterInfo();
                filterInfo.getFilterItems().add(new FilterItemInfo("hasLocation", (Object)true, CompareType.EQUALS));
                filterInfo.getFilterItems().add(new FilterItemInfo("assignStorageOrgUnit.id", (Object)sou.getId().toString(), CompareType.EQUALS));
                filterInfo.getFilterItems().add(new FilterItemInfo("assignMaterial.id", (Object)materialInfo.getId().toString(), CompareType.EQUALS));
                int conditionCount = 2;
                StringBuffer maskString = new StringBuffer("( ");
                MaterialGroupInfo materialGroupInfo = InvClientUtils.getMaterialGroupByMaterial(materialInfo);
                if (null != materialGroupInfo) {
                    String longNumber = materialGroupInfo.getLongNumber();
                    HashSet<String> longNumbers = new HashSet<String>();
                    longNumbers.add(longNumber);
                    int index = longNumber.indexOf("!", 0);
                    String lNumber = null;
                    while (index > 0) {
                        lNumber = longNumber.substring(0, index);
                        if (!StringUtil.isEmpty((String)lNumber)) {
                            longNumbers.add(lNumber);
                        }
                        index = longNumber.indexOf("!", index + 1);
                    }
                    filterInfo.getFilterItems().add(new FilterItemInfo("materialGroup.longNumber", longNumbers, CompareType.INCLUDE));
                    filterInfo.getFilterItems().add(new FilterItemInfo("materialStorageAssign.storageAssignType", (Object)"1", CompareType.EQUALS));
                    maskString.append(" #0 and (#1 or (#2 and #3)) ");
                    conditionCount += 2;
                } else {
                    maskString.append(" #0 and #1 ");
                }
                if (isStarted != -1) {
                    filterInfo.getFilterItems().add(new FilterItemInfo("SOWH.ISSTARTED", (Object)new Integer(isStarted), CompareType.EQUALS));
                    maskString.append(" and #" + conditionCount);
                }
                maskString.append(" )");
                filterInfo.setMaskString(maskString.toString());
                viewInfo.setFilter(filterInfo);
                kDBizPromptBoxWarehouse.setEntityViewInfo(viewInfo);
                kDBizPromptBoxWarehouse.getQueryAgent().resetRuntimeEntityView();
                kdtEntry.getCell(row, fieldName).getStyleAttributes().setLocked(false);
                kdtEntry.getCell(row, fieldName).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)kDBizPromptBoxWarehouse));
            } else {
                kdtEntry.getColumn(fieldName).getStyleAttributes().setLocked(true);
            }
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
    }

    public static MaterialGroupInfo getMaterialGroupByMaterial(MaterialInfo materialInfo) throws EASBizException, BOSException {
        if (null == materialInfo) {
            return null;
        }
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("materialGroup.id"));
        selector.add(new SelectorItemInfo("materialGroup.name"));
        selector.add(new SelectorItemInfo("materialGroup.number"));
        selector.add(new SelectorItemInfo("materialGroup.isLeaf"));
        selector.add(new SelectorItemInfo("materialGroup.level"));
        selector.add(new SelectorItemInfo("materialGroup.longNumber"));
        selector.add(new SelectorItemInfo("materialGroup.displayName"));
        MaterialInfo newMaterialInfo = MaterialFactory.getRemoteInstance().getMaterialInfo((IObjectPK)new ObjectUuidPK(materialInfo.getId()), selector);
        if (null != newMaterialInfo) {
            return newMaterialInfo.getMaterialGroup();
        }
        return null;
    }

    public static void setLocationFilterByMSRelation(CoreUIObject ui, StorageOrgUnitInfo sou, MaterialInfo mi, WarehouseInfo warehouseInfo, KDBizPromptBox kDBizPromptBoxLocation) {
        MaterialGroupInfo materialGroupInfo = null;
        if (warehouseInfo.isHasLocation()) {
            try {
                materialGroupInfo = InvClientUtils.getMaterialGroupByMaterial(mi);
            }
            catch (Exception e1) {
                Logger.error((Throwable)e1);
            }
            EntityViewInfo viewInfo = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("assignStorageOrgUnit.id", (Object)sou.getId().toString()));
            filterInfo.getFilterItems().add(new FilterItemInfo("assignWarehouse.id", (Object)warehouseInfo.getId().toString()));
            if (mi != null) {
                filterInfo.getFilterItems().add(new FilterItemInfo("assignMaterial.id", (Object)mi.getId().toString()));
            }
            if (null != materialGroupInfo) {
                String longNumber = materialGroupInfo.getLongNumber();
                HashSet<String> longNumbers = new HashSet<String>();
                longNumbers.add(longNumber);
                int index = longNumber.indexOf("!", 0);
                String lNumber = null;
                while (index > 0) {
                    lNumber = longNumber.substring(0, index);
                    if (!StringUtil.isEmpty((String)lNumber)) {
                        longNumbers.add(lNumber);
                    }
                    index = longNumber.indexOf("!", index + 1);
                }
                filterInfo.getFilterItems().add(new FilterItemInfo("materialGroup.longNumber", longNumbers, CompareType.INCLUDE));
                filterInfo.getFilterItems().add(new FilterItemInfo("materialStorageAssign.storageAssignType", (Object)new Integer(1), CompareType.EQUALS));
                filterInfo.setMaskString(" #0 and #1 and (#2 or (#3 and #4))");
            }
            viewInfo.setFilter(filterInfo);
            try {
                kDBizPromptBoxLocation = LocationHelper.setLocationF7((CoreUIObject)ui, (KDBizPromptBox)kDBizPromptBoxLocation, (String)warehouseInfo.getId().toString(), (FilterInfo)filterInfo);
            }
            catch (Exception e) {
                Logger.error((Throwable)e);
            }
        }
    }

    public static void setLocationFilterByMSRelation(CoreUIObject ui, StorageOrgUnitInfo sou, WarehouseInfo warehouseInfo, MaterialInfo mi, SCMFetchData fetchData, KDTable kdtEntry, int rowIndex, boolean isOnload) {
        if (warehouseInfo == null) {
            if (!isOnload) {
                kdtEntry.getRow(rowIndex).getCell(kdtEntry.getColumnIndex(LOCATION)).setValue(null);
            }
            SCMClientUtils.setNecessColorInCells((KDTable)kdtEntry, (String)LOCATION, (int)rowIndex, (boolean)false);
            kdtEntry.getRow(rowIndex).getCell(kdtEntry.getColumnIndex(LOCATION)).getStyleAttributes().setLocked(true);
            return;
        }
        if (warehouseInfo.isHasLocation()) {
            if (!isOnload) {
                LocationInfo defaultloc = null;
                if (fetchData == null || fetchData.getMapDefaultLocation() == null || mi == null) {
                    defaultloc = InvClientUtils.getDefaultLocation(sou, mi, warehouseInfo);
                } else {
                    try {
                        defaultloc = fetchData.getDefaultGroupLocation(mi.getId().toString(), warehouseInfo.getId().toString(), sou.getId().toString());
                        if (defaultloc == null) {
                            defaultloc = InvClientUtils.getDefaultLocation(sou, mi, warehouseInfo);
                        }
                        MaterialGroupInfo materialGroup = InvClientUtils.getMaterialGroupByMaterial(mi);
                        if (defaultloc == null && materialGroup != null && materialGroup.getId() != null) {
                            defaultloc = fetchData.getDefaultGroupLocation(materialGroup.getId().toString(), warehouseInfo.getId().toString(), sou.getId().toString());
                        }
                    }
                    catch (Exception e) {
                        ExceptionHandler.handle((Throwable)e);
                    }
                }
                LocationInfo lctation = (LocationInfo)kdtEntry.getRow(rowIndex).getCell(LOCATION).getValue();
                if (defaultloc != null) {
                    lctation = defaultloc;
                }
                kdtEntry.getRow(rowIndex).getCell(kdtEntry.getColumnIndex(LOCATION)).setValue((Object)lctation);
            }
            kdtEntry.getRow(rowIndex).getCell(kdtEntry.getColumnIndex(LOCATION)).getStyleAttributes().setLocked(false);
            SCMClientUtils.setNecessColorInCells((KDTable)kdtEntry, (String)LOCATION, (int)rowIndex, (boolean)true);
            EntityViewInfo viewInfo = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("assignStorageOrgUnit.id", (Object)sou.getId().toString()));
            filterInfo.getFilterItems().add(new FilterItemInfo("assignWarehouse.id", (Object)warehouseInfo.getId().toString()));
            if (mi != null) {
                filterInfo.getFilterItems().add(new FilterItemInfo("assignMaterial.id", (Object)mi.getId().toString()));
            }
            try {
                MaterialGroupInfo materialGroupInfo = InvClientUtils.getMaterialGroupByMaterial(mi);
                if (null != materialGroupInfo) {
                    String longNumber = materialGroupInfo.getLongNumber();
                    HashSet<String> longNumbers = new HashSet<String>();
                    longNumbers.add(longNumber);
                    int index = longNumber.indexOf("!", 0);
                    String lNumber = null;
                    while (index > 0) {
                        lNumber = longNumber.substring(0, index);
                        if (!StringUtil.isEmpty((String)lNumber)) {
                            longNumbers.add(lNumber);
                        }
                        index = longNumber.indexOf("!", index + 1);
                    }
                    filterInfo.getFilterItems().add(new FilterItemInfo("materialGroup.longNumber", longNumbers, CompareType.INCLUDE));
                    filterInfo.getFilterItems().add(new FilterItemInfo("materialStorageAssign.storageAssignType", (Object)new Integer(1), CompareType.EQUALS));
                    filterInfo.setMaskString(" #0 and #1 and (#2 or (#3 and #4))");
                }
            }
            catch (Exception e1) {
                Logger.error((Throwable)e1);
            }
            viewInfo.setFilter(filterInfo);
            KDBizPromptBox kDBizPromptBoxLocation = new KDBizPromptBox();
            kDBizPromptBoxLocation.setEditable(true);
            try {
                kDBizPromptBoxLocation = LocationHelper.setLocationF7((CoreUIObject)ui, (KDBizPromptBox)kDBizPromptBoxLocation, (String)warehouseInfo.getId().toString(), (FilterInfo)filterInfo);
            }
            catch (Exception e) {
                Logger.error((Throwable)e);
            }
            kdtEntry.getRow(rowIndex).getCell(kdtEntry.getColumnIndex(LOCATION)).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)kDBizPromptBoxLocation));
        } else {
            if (!isOnload) {
                kdtEntry.getRow(rowIndex).getCell(kdtEntry.getColumnIndex(LOCATION)).setValue(null);
            }
            kdtEntry.getRow(rowIndex).getCell(kdtEntry.getColumnIndex(LOCATION)).getStyleAttributes().setLocked(true);
            SCMClientUtils.setNecessColorInCells((KDTable)kdtEntry, (String)LOCATION, (int)rowIndex, (boolean)false);
        }
    }

    public static void setLocationFilterByMSRelation(CoreUIObject ui, StorageOrgUnitInfo sou, WarehouseInfo warehouseInfo, MaterialInfo mi, KDTable kdtEntry, int rowIndex, boolean isOnload, SCMFetchData fetchData) {
        if (warehouseInfo == null) {
            if (!isOnload) {
                kdtEntry.getRow(rowIndex).getCell(kdtEntry.getColumnIndex(LOCATION)).setValue(null);
            }
            SCMClientUtils.setNecessColorInCells((KDTable)kdtEntry, (String)LOCATION, (int)rowIndex, (boolean)false);
            kdtEntry.getRow(rowIndex).getCell(kdtEntry.getColumnIndex(LOCATION)).getStyleAttributes().setLocked(true);
            return;
        }
        if (warehouseInfo.isHasLocation()) {
            if (!isOnload) {
                LocationInfo defaultloc = null;
                try {
                    MaterialGroupInfo materialGroup;
                    defaultloc = fetchData.getDefaultLocation(mi.getId().toString(), warehouseInfo.getId().toString(), sou.getId().toString());
                    if (defaultloc == null && (materialGroup = InvClientUtils.getMaterialGroupByMaterial(mi)) != null && materialGroup.getId() != null) {
                        defaultloc = fetchData.getDefaultGroupLocation(materialGroup.getId().toString(), warehouseInfo.getId().toString(), sou.getId().toString());
                    }
                }
                catch (Exception e) {
                    ExceptionHandler.handle((Throwable)e);
                }
                LocationInfo lctation = (LocationInfo)kdtEntry.getRow(rowIndex).getCell(LOCATION).getValue();
                if (defaultloc != null) {
                    lctation = defaultloc;
                }
                kdtEntry.getRow(rowIndex).getCell(kdtEntry.getColumnIndex(LOCATION)).setValue((Object)lctation);
            }
            kdtEntry.getRow(rowIndex).getCell(kdtEntry.getColumnIndex(LOCATION)).getStyleAttributes().setLocked(false);
            SCMClientUtils.setNecessColorInCells((KDTable)kdtEntry, (String)LOCATION, (int)rowIndex, (boolean)true);
            EntityViewInfo viewInfo = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("assignStorageOrgUnit.id", (Object)sou.getId().toString()));
            filterInfo.getFilterItems().add(new FilterItemInfo("assignWarehouse.id", (Object)warehouseInfo.getId().toString()));
            if (mi != null) {
                filterInfo.getFilterItems().add(new FilterItemInfo("assignMaterial.id", (Object)mi.getId().toString()));
            }
            try {
                MaterialGroupInfo materialGroupInfo = InvClientUtils.getMaterialGroupByMaterial(mi);
                if (null != materialGroupInfo) {
                    String longNumber = materialGroupInfo.getLongNumber();
                    HashSet<String> longNumbers = new HashSet<String>();
                    longNumbers.add(longNumber);
                    int index = longNumber.indexOf("!", 0);
                    String lNumber = null;
                    while (index > 0) {
                        lNumber = longNumber.substring(0, index);
                        if (!StringUtil.isEmpty((String)lNumber)) {
                            longNumbers.add(lNumber);
                        }
                        index = longNumber.indexOf("!", index + 1);
                    }
                    filterInfo.getFilterItems().add(new FilterItemInfo("materialGroup.longNumber", longNumbers, CompareType.INCLUDE));
                    filterInfo.getFilterItems().add(new FilterItemInfo("materialStorageAssign.storageAssignType", (Object)new Integer(1), CompareType.EQUALS));
                    filterInfo.setMaskString(" #0 and #1 and (#2 or (#3 and #4))");
                }
            }
            catch (Exception e1) {
                Logger.error((Throwable)e1);
            }
            viewInfo.setFilter(filterInfo);
            KDBizPromptBox kDBizPromptBoxLocation = new KDBizPromptBox();
            kDBizPromptBoxLocation.setEditable(true);
            try {
                kDBizPromptBoxLocation = LocationHelper.setLocationF7((CoreUIObject)ui, (KDBizPromptBox)kDBizPromptBoxLocation, (String)warehouseInfo.getId().toString(), (FilterInfo)filterInfo);
            }
            catch (Exception e) {
                Logger.error((Throwable)e);
            }
            kdtEntry.getRow(rowIndex).getCell(kdtEntry.getColumnIndex(LOCATION)).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)kDBizPromptBoxLocation));
        } else {
            if (!isOnload) {
                kdtEntry.getRow(rowIndex).getCell(kdtEntry.getColumnIndex(LOCATION)).setValue(null);
            }
            kdtEntry.getRow(rowIndex).getCell(kdtEntry.getColumnIndex(LOCATION)).getStyleAttributes().setLocked(true);
            SCMClientUtils.setNecessColorInCells((KDTable)kdtEntry, (String)LOCATION, (int)rowIndex, (boolean)false);
        }
    }

    public static void setLocationFilter(CoreUIObject ui, StorageOrgUnitInfo sou, WarehouseInfo warehouseInfo, KDBizPromptBox kDBizPromptBoxLocation) {
        if (warehouseInfo != null && warehouseInfo.isHasLocation()) {
            EntityViewInfo viewInfo = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            FilterItemInfo storageFilterItemInfo = new FilterItemInfo("WAREHOUSE.ID", (Object)warehouseInfo.getId().toString());
            filterInfo.getFilterItems().add(storageFilterItemInfo);
            viewInfo.setFilter(filterInfo);
            try {
                kDBizPromptBoxLocation = sou != null && sou.getId() != null ? LocationHelper.setLocationF7((CoreUIObject)ui, (KDBizPromptBox)kDBizPromptBoxLocation, (String)warehouseInfo.getId().toString(), (String)sou.getId().toString()) : LocationHelper.setLocationF7((CoreUIObject)ui, (KDBizPromptBox)kDBizPromptBoxLocation, (String)warehouseInfo.getId().toString());
            }
            catch (Exception e) {
                Logger.error((Throwable)e);
            }
        }
    }

    public static void setLocationEditable(WarehouseInfo warehouseInfo, MaterialInfo mi, KDTable kdtEntry, int rowIndex) {
        if (warehouseInfo == null) {
            SCMClientUtils.setNecessColorInCells((KDTable)kdtEntry, (String)LOCATION, (int)rowIndex, (boolean)false);
            kdtEntry.getRow(rowIndex).getCell(kdtEntry.getColumnIndex(LOCATION)).getStyleAttributes().setLocked(true);
            return;
        }
        if (warehouseInfo.isHasLocation()) {
            kdtEntry.getRow(rowIndex).getCell(kdtEntry.getColumnIndex(LOCATION)).getStyleAttributes().setLocked(false);
            SCMClientUtils.setNecessColorInCells((KDTable)kdtEntry, (String)LOCATION, (int)rowIndex, (boolean)true);
        } else {
            kdtEntry.getRow(rowIndex).getCell(kdtEntry.getColumnIndex(LOCATION)).getStyleAttributes().setLocked(true);
            SCMClientUtils.setNecessColorInCells((KDTable)kdtEntry, (String)LOCATION, (int)rowIndex, (boolean)false);
        }
    }

    public static WarehouseInfo getDefaultWarehouse(StorageOrgUnitInfo sou, MaterialInfo mi, int isStarted) throws EASBizException, BOSException {
        if (sou != null && mi != null) {
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("STORAGEORG.ID", (Object)sou.getId().toString(), CompareType.EQUALS));
            filterInfo.getFilterItems().add(new FilterItemInfo("MATERIAL.ID", (Object)mi.getId().toString(), CompareType.EQUALS));
            IMaterialStorageAssign imsa = MaterialStorageAssignFactory.getRemoteInstance();
            IObjectPK[] pks = imsa.getPKList(filterInfo, null);
            IWarehouse iw = WarehouseFactory.getRemoteInstance();
            int recs2 = pks.length;
            ISOAccreditWH iso = SOAccreditWHFactory.getRemoteInstance();
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("*"));
            sic.add(new SelectorItemInfo("whman.number"));
            sic.add(new SelectorItemInfo("whman.name"));
            if (recs2 > 0) {
                if (isStarted != 0) {
                    ObjectUuidPK pk = new ObjectUuidPK(imsa.getMaterialStorageAssignInfo(pks[0]).getWarehouse().getBOSUuid("id"));
                    WarehouseInfo wi = iw.getWarehouseInfo((IObjectPK)pk, sic);
                    return wi;
                }
                for (int i = 0; i < recs2; ++i) {
                    ObjectUuidPK pk = new ObjectUuidPK(imsa.getMaterialStorageAssignInfo(pks[i]).getWarehouse().getBOSUuid("id"));
                    WarehouseInfo wi = iw.getWarehouseInfo((IObjectPK)pk, sic);
                    if (iso.isStarted(sou, wi)) continue;
                    return wi;
                }
            }
        }
        return null;
    }

    public static LocationInfo getDefaultLocation(StorageOrgUnitInfo sou, MaterialInfo mi, WarehouseInfo wi) {
        try {
            if (sou != null && mi != null && wi != null) {
                EntityViewInfo viewInfo = new EntityViewInfo();
                FilterInfo filterInfo = new FilterInfo();
                filterInfo.getFilterItems().add(new FilterItemInfo("STORAGEORG.ID", (Object)sou.getId().toString(), CompareType.EQUALS));
                filterInfo.getFilterItems().add(new FilterItemInfo("MATERIAL.ID", (Object)mi.getId().toString(), CompareType.EQUALS));
                filterInfo.getFilterItems().add(new FilterItemInfo("WAREHOUSE.ID", (Object)wi.getId().toString(), CompareType.EQUALS));
                filterInfo.getFilterItems().add(new FilterItemInfo("isDefaultLocation", (Object)Boolean.TRUE));
                viewInfo.setFilter(filterInfo);
                IMaterialStorageAssign imsa = MaterialStorageAssignFactory.getRemoteInstance();
                if (imsa != null) {
                    IObjectPK[] pks = imsa.getPKList(filterInfo, null);
                    ILocation il = LocationFactory.getRemoteInstance();
                    int recs = pks.length;
                    if (recs > 0) {
                        if (imsa.getMaterialStorageAssignInfo(pks[0]).getLocation() != null) {
                            ObjectUuidPK pk = new ObjectUuidPK(imsa.getMaterialStorageAssignInfo(pks[0]).getLocation().getBOSUuid("id"));
                            return il.getLocationInfo((IObjectPK)pk);
                        }
                        return null;
                    }
                }
            }
        }
        catch (EASBizException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        return null;
    }

    public static void setAssistPropertyF7(KDTable kdtEntry, int rowIndex, String columnName, AsstAttrTypeInfo asstAttrTypeInfo) {
        if (asstAttrTypeInfo != null) {
            EntityViewInfo viewInfo = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            FilterItemInfo filterItemInfo = new FilterItemInfo("BASICTYPEID", (Object)asstAttrTypeInfo.getId().toString(), CompareType.EQUALS);
            filterInfo.getFilterItems().add(filterItemInfo);
            viewInfo.setFilter(filterInfo);
            KDBizPromptBox kDBizPromptBoxAssistProperty = new KDBizPromptBox();
            kDBizPromptBoxAssistProperty.setEditable(true);
            kDBizPromptBoxAssistProperty.setQueryInfo("com.kingdee.eas.basedata.master.material.app.AsstAttrValueF7Query");
            kDBizPromptBoxAssistProperty.setDisplayFormat("$name$");
            kDBizPromptBoxAssistProperty.setEditFormat("$number$");
            kDBizPromptBoxAssistProperty.setCommitFormat("$number$");
            kDBizPromptBoxAssistProperty.setEntityViewInfo(viewInfo);
            kdtEntry.getRow(rowIndex).getCell(kdtEntry.getColumnIndex(columnName)).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)kDBizPromptBoxAssistProperty));
        }
    }

    public static PersonInfo getDefaultStocker(WarehouseInfo warehouseInfo) throws EASBizException, BOSException {
        if (warehouseInfo == null) {
            return null;
        }
        PersonInfo stocker = warehouseInfo.getWhman();
        if (stocker != null) {
            ObjectUuidPK pk = new ObjectUuidPK(stocker.getId().toString());
            stocker = PersonFactory.getRemoteInstance().getPersonInfo((IObjectPK)pk);
        }
        return stocker;
    }

    public static PersonInfo getDefaultStocker(String warehsID) throws EASBizException, BOSException {
        if (warehsID != null) {
            IWarehouse iWarehouse = WarehouseFactory.getRemoteInstance();
            WarehouseInfo wareInfo = null;
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("*"));
            sic.add(new SelectorItemInfo("whman.id"));
            sic.add(new SelectorItemInfo("whman.number"));
            sic.add(new SelectorItemInfo("whman.name"));
            ObjectUuidPK pk = new ObjectUuidPK(warehsID);
            wareInfo = iWarehouse.getWarehouseInfo((IObjectPK)pk, sic);
            if (wareInfo.getWhman() != null) {
                return wareInfo.getWhman();
            }
        }
        return null;
    }

    public static KDBizPromptBox getMaterialF7ForFilterUI(KDBizPromptBox materialF7, Object owner, String listQueryInfo, String queryInfo) {
        materialF7.setEditable(true);
        materialF7.setDisplayFormat("$number$");
        materialF7.setEditFormat("$number$");
        materialF7.setCommitParser((IParser)new MainDataParser(materialF7));
        materialF7.setCommitFormat("$number$");
        F7MaterialMultiUISelectorAdaptor selectorMaterial = null;
        try {
            MaterialGroupInfo info = new MaterialGroupInfo();
            selectorMaterial = new F7MaterialMultiUISelectorAdaptor((KDPromptBox)materialF7, (Component)new F7MaterialMultiUI(), owner, info.getBOSType().toString(), listQueryInfo, "materialGroup.id");
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
        selectorMaterial.setIsMultiSelect(false);
        selectorMaterial.setQueryProperty("helpCode", "or");
        materialF7.setSelector(selectorMaterial);
        materialF7.addSelectorListener(selectorMaterial);
        materialF7.setQueryInfo(queryInfo);
        return materialF7;
    }

    public static KDBizPromptBox getMaterialF7ForFilterUI(KDBizPromptBox materialF7, Object owner) {
        return InvClientUtils.getMaterialF7ForFilterUI(materialF7, owner, "com.kingdee.eas.basedata.master.material.app.F7MaterialQuery", "com.kingdee.eas.basedata.master.material.app.F7MaterialBaseInfoQuery");
    }

    public static KDBizPromptBox getMaterialF7ForFilterUIByOrg(KDBizPromptBox kDBizPromptBoxMaterial, Object owner, OrgType mainOrgType) {
        kDBizPromptBoxMaterial.setEditable(true);
        kDBizPromptBoxMaterial.setDisplayFormat("$number$");
        kDBizPromptBoxMaterial.setEditFormat("$number$");
        kDBizPromptBoxMaterial.setCommitFormat("$number$;$helpCode$");
        F7MaterialMultiUISelectorAdaptor selectorLisenterMaterial = null;
        try {
            MaterialGroupInfo info = new MaterialGroupInfo();
            selectorLisenterMaterial = new F7MaterialMultiUISelectorAdaptor((KDPromptBox)kDBizPromptBoxMaterial, (Component)new F7MaterialMultiUI(), owner, info.getBOSType().toString(), QueryInfoConstants.getMaterialQueryInfo((OrgType)mainOrgType), "materialGroup.id", QueryInfoConstants.getMaterialNoGroupQueryInfo((OrgType)mainOrgType), false);
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
        selectorLisenterMaterial.setIsMultiSelect(false);
        selectorLisenterMaterial.setQueryProperty("helpCode", "or");
        kDBizPromptBoxMaterial.setSelector(selectorLisenterMaterial);
        kDBizPromptBoxMaterial.addSelectorListener(selectorLisenterMaterial);
        kDBizPromptBoxMaterial.setQueryInfo(QueryInfoConstants.getMaterialNoGroupQueryInfo((OrgType)mainOrgType));
        return kDBizPromptBoxMaterial;
    }

    public static KDBizPromptBox getMaterialF7ForReportFilterUI(KDBizPromptBox kDBizPromptBoxMaterial, Object owner) {
        kDBizPromptBoxMaterial.setEditable(true);
        kDBizPromptBoxMaterial.setDisplayFormat("$number$");
        kDBizPromptBoxMaterial.setEditFormat("$number$");
        kDBizPromptBoxMaterial.setCommitParser((IParser)new MainDataParser(kDBizPromptBoxMaterial));
        kDBizPromptBoxMaterial.setCommitFormat("$number$");
        F7MaterialMultiUISelectorAdaptor selectorLisenterMaterial = null;
        try {
            MaterialGroupInfo info = new MaterialGroupInfo();
            selectorLisenterMaterial = new F7MaterialMultiUISelectorAdaptor((KDPromptBox)kDBizPromptBoxMaterial, (Component)new F7MaterialMultiUI(), owner, info.getBOSType().toString(), "com.kingdee.eas.basedata.master.material.app.F7MaterialInventoryQuery", "materialGroup.id", false);
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
        selectorLisenterMaterial.setIsMultiSelect(false);
        selectorLisenterMaterial.setQueryProperty("helpCode", "or");
        kDBizPromptBoxMaterial.setSelector(selectorLisenterMaterial);
        kDBizPromptBoxMaterial.addSelectorListener(selectorLisenterMaterial);
        kDBizPromptBoxMaterial.setQueryInfo("com.kingdee.eas.basedata.master.material.app.F7MaterialInventoryNoGroupQuery");
        return kDBizPromptBoxMaterial;
    }

    public static void initSupplierF7(KDBizPromptBox f7, CoreUIObject owner) {
        InvClientUtils.initSCMBDTreeF7(f7, owner, 1, false);
    }

    public static void initSupplierF7ForFilter(KDBizPromptBox f7, CoreUIObject owner) {
        InvClientUtils.initSCMBDTreeF7(f7, owner, 1, true);
    }

    public static void initCustomerF7(KDBizPromptBox f7, CoreUIObject owner) {
        InvClientUtils.initSCMBDTreeF7(f7, owner, 2, true);
    }

    public static void initCustomerF7ForFilter(KDBizPromptBox f7, CoreUIObject owner) {
        InvClientUtils.initSCMBDTreeF7(f7, owner, 2, true);
    }

    private static void initSCMBDTreeF7(KDBizPromptBox f7, CoreUIObject owner, int bDType, boolean disNumber) {
        if (f7 != null) {
            f7.setEditable(true);
            if (disNumber) {
                f7.setDisplayFormat("$number$");
            } else {
                f7.setDisplayFormat("$name$");
            }
            f7.setEditFormat("$number$");
            GeneralKDPromptSelectorAdaptor selectorLisenter = null;
            try {
                switch (bDType) {
                    case 1: {
                        selectorLisenter = new GeneralKDPromptSelectorAdaptor((KDPromptBox)f7, (Component)new F7SupplierTreeDetailListUI(), (Object)owner, CSSPGroupInfo.getBosType(), "com.kingdee.eas.basedata.master.cssp.app.F7SupplierQuery", "browseGroup.id");
                        selectorLisenter.setQueryProperty("mnemonicCode", "or");
                        f7.setCommitFormat("$number$;$mnemonicCode$");
                        break;
                    }
                    case 2: {
                        selectorLisenter = new GeneralKDPromptSelectorAdaptor((KDPromptBox)f7, (Component)new F7CustomerTreeDetailListUI(), (Object)owner, CSSPGroupInfo.getBosType(), "com.kingdee.eas.basedata.master.cssp.app.F7CustomerQuery", "browseGroup.id", "com.kingdee.eas.basedata.master.cssp.app.F7CustomerQueryWithDefaultStandard");
                        selectorLisenter.setQueryProperty("mnemonicCode", "or");
                        f7.setCommitFormat("$number$;$mnemonicCode$");
                        break;
                    }
                    default: {
                        selectorLisenter = new GeneralKDPromptSelectorAdaptor((KDPromptBox)f7, (Component)new F7MaterialTreeListUI(), (Object)owner, MaterialGroupInfo.getBosType(), "com.kingdee.eas.basedata.master.material.app.F7MaterialQuery", "materialGroup.id");
                        selectorLisenter.setQueryProperty("helpCode", "or");
                        f7.setCommitFormat("$number$;$helpCode$");
                        break;
                    }
                }
            }
            catch (Exception e) {
                ExceptionHandler.handle((Throwable)e);
            }
            selectorLisenter.setIsMultiSelect(false);
            f7.setSelector(selectorLisenter);
            f7.addSelectorListener(selectorLisenter);
        }
    }

    public static KDBizPromptBox getMaterialF7ByStorageOrgUnit(KDBizPromptBox kDBizPromptBoxMaterial, Object[] storageOrgIds, Object owner) {
        kDBizPromptBoxMaterial.setEditable(true);
        kDBizPromptBoxMaterial.setDisplayFormat("$number$");
        kDBizPromptBoxMaterial.setEditFormat("$number$");
        kDBizPromptBoxMaterial.setCommitFormat("$number$;$helpCode$;$name$;$model$");
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        if (storageOrgIds.length > 0) {
            HashSet<Object> storgageOrgSet = new HashSet<Object>();
            for (int i = 0; i < storageOrgIds.length; ++i) {
                storgageOrgSet.add(storageOrgIds[i]);
            }
            filterInfo.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", storgageOrgSet, CompareType.INCLUDE));
        } else {
            filterInfo.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)"#"));
        }
        viewInfo.setFilter(filterInfo);
        kDBizPromptBoxMaterial.setEntityViewInfo(viewInfo);
        F7MaterialMultiUISelectorAdaptor selectorLisenterMaterial = null;
        try {
            selectorLisenterMaterial = new F7MaterialMultiUISelectorAdaptor((KDPromptBox)kDBizPromptBoxMaterial, (Component)new F7MaterialMultiUI(), owner, MaterialGroupInfo.getBosType(), "com.kingdee.eas.basedata.master.material.app.F7MaterialInventoryQuery", "materialGroup.id");
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
        return kDBizPromptBoxMaterial;
    }

    public static KDBizPromptBox getMaterialF7(KDBizPromptBox kDBizPromptBoxMaterial, CompanyOrgUnitInfo cou, StorageOrgUnitInfo sou, Object owner) {
        kDBizPromptBoxMaterial.setEditable(true);
        kDBizPromptBoxMaterial.setDisplayFormat("$number$");
        kDBizPromptBoxMaterial.setEditFormat("$number$");
        kDBizPromptBoxMaterial.setCommitFormat("$number$;$helpCode$;$name$;$model$");
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        if (cou == null && sou == null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)"#"));
        }
        if (sou != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)sou.getId().toString()));
        }
        viewInfo.setFilter(filterInfo);
        kDBizPromptBoxMaterial.setEntityViewInfo(viewInfo);
        F7MaterialMultiUISelectorAdaptor selectorLisenterMaterial = null;
        try {
            selectorLisenterMaterial = new F7MaterialMultiUISelectorAdaptor((KDPromptBox)kDBizPromptBoxMaterial, (Component)new F7MaterialMultiUI(), owner, MaterialGroupInfo.getBosType(), "com.kingdee.eas.basedata.master.material.app.F7MaterialInventoryQuery", "materialGroup.id");
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
        selectorLisenterMaterial.setIsMultiSelect(true);
        selectorLisenterMaterial.setQueryProperty("helpCode", "or");
        kDBizPromptBoxMaterial.setSelector((KDPromptSelector)selectorLisenterMaterial);
        kDBizPromptBoxMaterial.addSelectorListener((SelectorListener)selectorLisenterMaterial);
        return kDBizPromptBoxMaterial;
    }

    public static KDBizPromptBox initMaterialF7(Object owner) {
        KDBizPromptBox kDBizPromptBoxMaterial = new KDBizPromptBox();
        kDBizPromptBoxMaterial.setEditable(true);
        kDBizPromptBoxMaterial.setDisplayFormat("$number$");
        kDBizPromptBoxMaterial.setEditFormat("$number$");
        kDBizPromptBoxMaterial.setCommitFormat("$number$;$helpCode$;$name$;$model$");
        F7MaterialMultiUISelectorAdaptor selectorLisenterMaterial = null;
        try {
            selectorLisenterMaterial = new F7MaterialMultiUISelectorAdaptor((KDPromptBox)kDBizPromptBoxMaterial, (Component)new F7MaterialMultiUI(), owner, MaterialGroupInfo.getBosType(), "com.kingdee.eas.basedata.master.material.app.F7MaterialInventoryQuery", "materialGroup.id");
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
        selectorLisenterMaterial.setIsMultiSelect(true);
        selectorLisenterMaterial.setQueryProperty("helpCode", "or");
        kDBizPromptBoxMaterial.setSelector((KDPromptSelector)selectorLisenterMaterial);
        kDBizPromptBoxMaterial.addSelectorListener((SelectorListener)selectorLisenterMaterial);
        return kDBizPromptBoxMaterial;
    }

    public static void setF7CUid(GeneralKDPromptSelectorAdaptor selectorLisenterMaterial, KDBizPromptBox kDBizPromptBoxMaterial, CtrlUnitInfo cuInfo) {
        if (cuInfo != null) {
            selectorLisenterMaterial.setCUId(cuInfo.getId().toString());
            kDBizPromptBoxMaterial.setCurrentCtrlUnit(cuInfo);
        }
    }

    public static EntityViewInfo getMaterialFilter(StorageOrgUnitInfo storage) {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        String storageId = "";
        if (storage != null) {
            storageId = storage.getId().toString();
        }
        filterInfo.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)storageId));
        viewInfo.setFilter(filterInfo);
        return viewInfo;
    }

    public static KDBizPromptBox getStorageOrgUnitF7(KDBizPromptBox kDBizPromptBox) {
        kDBizPromptBox.setEditable(true);
        kDBizPromptBox.setDisplayFormat("$number$");
        kDBizPromptBox.setEditFormat("$number$");
        kDBizPromptBox.setCommitFormat("$number$");
        kDBizPromptBox.setQueryInfo("com.kingdee.eas.basedata.org.app.StorageOrgUnitQuery");
        SCMClientUtils.setF7OrgUnitBizUnit((KDBizPromptBox)kDBizPromptBox);
        return kDBizPromptBox;
    }

    public static KDBizPromptBox getStorageOrgUnitF7(KDBizPromptBox kDBizPromptBox, CtrlUnitInfo cu) {
        kDBizPromptBox.setEditable(true);
        kDBizPromptBox.setDisplayFormat("$number$");
        kDBizPromptBox.setEditFormat("$number$");
        kDBizPromptBox.setCommitFormat("$number$");
        kDBizPromptBox.setQueryInfo("com.kingdee.eas.basedata.org.app.StorageOrgUnitQuery");
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("isBizUnit", (Object)Boolean.TRUE, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("CU.id", (Object)cu.getId(), CompareType.EQUALS));
        viewInfo.setFilter(filterInfo);
        kDBizPromptBox.setEntityViewInfo(viewInfo);
        return kDBizPromptBox;
    }

    public static StorageOrgUnitInfo getStorageOrgUnitInfo(PreChangeEvent arg0) {
        block7: {
            if (arg0.getData() == null) {
                return null;
            }
            try {
                if (arg0.getData() instanceof FullOrgUnitInfo) {
                    FullOrgUnitInfo fou = (FullOrgUnitInfo)arg0.getData();
                    try {
                        IStorageOrgUnit iStorageOrgUnit = StorageOrgUnitFactory.getRemoteInstance();
                        ObjectUuidPK pk = new ObjectUuidPK(fou.getId());
                        return iStorageOrgUnit.getStorageOrgUnitInfo((IObjectPK)pk);
                    }
                    catch (EASBizException e) {
                        ExceptionHandler.handle((Throwable)e);
                        break block7;
                    }
                    catch (BOSException e) {
                        ExceptionHandler.handle((Throwable)e);
                        break block7;
                    }
                }
                return (StorageOrgUnitInfo)arg0.getData();
            }
            catch (Exception e1) {
                Logger.error((Throwable)e1);
            }
        }
        return null;
    }

    public static KDBizPromptBox getCustOrSuppF7Tree(CompanyOrgUnitInfo cou, Object owner, boolean isCustomer, boolean isMultiSelect) throws Exception {
        String couid = "";
        if (cou != null) {
            couid = cou.getId().toString();
        }
        EntityViewInfo companyViewInfo = new EntityViewInfo();
        FilterInfo companyFilterInfo = new FilterInfo();
        companyFilterInfo.getFilterItems().add(new FilterItemInfo("COMPANYORGUNIT.ID", (Object)couid, CompareType.EQUALS));
        companyViewInfo.setFilter(companyFilterInfo);
        KDBizPromptBox kDBizPromptBox = new KDBizPromptBox();
        GeneralKDPromptSelectorAdaptor selectorLisenter = null;
        selectorLisenter = isCustomer ? new GeneralKDPromptSelectorAdaptor((KDPromptBox)kDBizPromptBox, (Component)new F7SupplierTreeDetailListUI(), owner, "7A2569A2", "com.kingdee.eas.basedata.master.cssp.app.F7SupplierQuery", "browseGroup.id") : new GeneralKDPromptSelectorAdaptor((KDPromptBox)kDBizPromptBox, (Component)new F7CustomerTreeDetailListUI(), owner, "7A2569A2", "com.kingdee.eas.basedata.master.cssp.app.F7CustomerQuery", "browseGroup.id");
        kDBizPromptBox.setSelector((KDPromptSelector)selectorLisenter);
        kDBizPromptBox.addSelectorListener((SelectorListener)selectorLisenter);
        return kDBizPromptBox;
    }

    public static KDBizPromptBox getCustOrSuppF7(CompanyOrgUnitInfo cou, Object owner, boolean isCustomer, boolean isMultiSelect) throws Exception {
        if (cou != null) {
            EntityViewInfo companyViewInfo = new EntityViewInfo();
            FilterInfo companyFilterInfo = new FilterInfo();
            companyFilterInfo.getFilterItems().add(new FilterItemInfo("COMPANYORGUNIT.ID", (Object)cou.getId().toString(), CompareType.EQUALS));
            companyViewInfo.setFilter(companyFilterInfo);
            KDBizPromptBox kDBizPromptBox = new KDBizPromptBox();
            kDBizPromptBox.setEditable(true);
            kDBizPromptBox.setDisplayFormat("$name$");
            kDBizPromptBox.setEditFormat("$number$");
            kDBizPromptBox.setCommitFormat("$number$");
            kDBizPromptBox.setEntityViewInfo(companyViewInfo);
            GeneralKDPromptSelectorAdaptor selectorLisenter = null;
            String bosType = CSSPGroupInfo.getBosType();
            selectorLisenter = isCustomer ? new GeneralKDPromptSelectorAdaptor((KDPromptBox)kDBizPromptBox, (Component)new F7CustomerTreeDetailListUI(), owner, bosType, "com.kingdee.eas.basedata.master.cssp.app.F7CustomerCompanyQuery", "browseGroup.id") : new GeneralKDPromptSelectorAdaptor((KDPromptBox)kDBizPromptBox, (Component)new F7SupplierTreeDetailListUI(), owner, bosType, "com.kingdee.eas.basedata.master.cssp.app.F7SupplierCompanyQuery", "browseGroup.id");
            selectorLisenter.setIsMultiSelect(isMultiSelect);
            kDBizPromptBox.setSelector((KDPromptSelector)selectorLisenter);
            kDBizPromptBox.addSelectorListener((SelectorListener)selectorLisenter);
            return kDBizPromptBox;
        }
        return null;
    }

    public static void setColLock(KDTable kdtEntry, String[] colNames, int row, boolean isLock) {
        if (kdtEntry != null && colNames != null) {
            int cols = colNames.length;
            IRow curRow = kdtEntry.getRow(row);
            for (int i = 0; i < cols; ++i) {
                curRow.getCell(kdtEntry.getColumnIndex(colNames[i])).getStyleAttributes().setLocked(isLock);
            }
        }
    }

    public static void setColLock(KDTable kdtEntry, String[] colNames, boolean isLock) {
        if (kdtEntry != null && colNames != null) {
            int cols = colNames.length;
            for (int i = 0; i < cols; ++i) {
                kdtEntry.getColumn(colNames[i]).getStyleAttributes().setLocked(isLock);
            }
        }
    }

    public static void setCellLock(KDTable kdtEntry, String colName, boolean isLock) {
        if (kdtEntry != null && colName != null) {
            int rows = kdtEntry.getRowCount();
            for (int i = 0; i < rows; ++i) {
                kdtEntry.getRow(i).getCell(colName).getStyleAttributes().setLocked(isLock);
            }
        }
    }

    public static void setCellLock(KDTable kdtEntry, String colName, boolean isLock, String isPresent) {
        kdtEntry.getColumn(colName).getStyleAttributes().setLocked(isLock);
        if (kdtEntry != null && colName != null) {
            int rows = kdtEntry.getRowCount();
            IRow iRow = null;
            for (int i = 0; i < rows; ++i) {
                iRow = kdtEntry.getRow(i);
                if (((Boolean)iRow.getCell(isPresent).getValue()).booleanValue()) {
                    iRow.getCell(colName).getStyleAttributes().setLocked(true);
                    continue;
                }
                iRow.getCell(colName).getStyleAttributes().setLocked(isLock);
            }
        }
    }

    public static void setTableLock(KDTable kdtEntry, boolean isLock) {
        if (kdtEntry != null) {
            int rows = kdtEntry.getRowCount();
            int cols = kdtEntry.getColumnCount();
            IRow curRow = null;
            for (int i = 0; i < rows; ++i) {
                curRow = kdtEntry.getRow(i);
                for (int j = 0; j < cols; ++j) {
                    curRow.getCell(j).getStyleAttributes().setLocked(isLock);
                }
            }
        }
    }

    public static void setTableLock(KDTable kdtEntry, String[] colNames, boolean isLock) {
        if (kdtEntry != null) {
            int rows = kdtEntry.getRowCount();
            int cols = kdtEntry.getColumnCount();
            int select = 0;
            if (colNames != null) {
                select = colNames.length;
            }
            boolean flag = false;
            for (int i = 0; i < cols; ++i) {
                flag = false;
                for (int j = 0; j < select; ++j) {
                    if (kdtEntry.getColumnIndex(colNames[j]) != i) continue;
                    flag = true;
                    break;
                }
                if (flag) continue;
                for (int m = 0; m < rows; ++m) {
                    kdtEntry.getCell(m, i).getStyleAttributes().setLocked(isLock);
                }
            }
        }
    }

    public static void setRowLock(KDTable kdtEntry, int row, String[] colNames, boolean isLock) {
        if (kdtEntry != null) {
            int cols = kdtEntry.getColumnCount();
            IRow curRow = kdtEntry.getRow(row);
            for (int j = 0; j < cols; ++j) {
                curRow.getCell(j).getStyleAttributes().setLocked(isLock);
            }
            if (colNames != null) {
                cols = colNames.length;
                for (int i = 0; i < cols; ++i) {
                    curRow.getCell(colNames[i]).getStyleAttributes().setLocked(!isLock);
                }
            }
        }
    }

    public static void setCellValueNull(KDTable table, String[] needClearCols, int rowIndex, boolean isFullTableClear, String[] unClearCols) {
        int needClearColNum;
        Vector<Integer> vector = null;
        if (isFullTableClear) {
            vector = new Vector<Integer>();
            vector.add(new Integer(table.getColumnIndex("Id")));
            vector.add(new Integer(table.getColumnIndex("id")));
            vector.add(new Integer(table.getColumnIndex("ID")));
            vector.add(new Integer(table.getColumnIndex("storeType")));
            vector.add(new Integer(table.getColumnIndex("storeStatus")));
            vector.add(new Integer(table.getColumnIndex("storeState")));
            vector.add(new Integer(table.getColumnIndex(WAREHOUSE)));
            vector.add(new Integer(table.getColumnIndex("moveInWarehouse")));
            vector.add(new Integer(table.getColumnIndex("moveOutWarehouse")));
            vector.add(new Integer(table.getColumnIndex("stocker")));
            vector.add(new Integer(table.getColumnIndex(LOCATION)));
            vector.add(new Integer(table.getColumnIndex("moveInLocation")));
            vector.add(new Integer(table.getColumnIndex("moveOutLocation")));
            vector.add(new Integer(table.getColumnIndex("customer")));
            vector.add(new Integer(table.getColumnIndex("supplier")));
            vector.add(new Integer(table.getColumnIndex("taxRate")));
            vector.add(new Integer(table.getColumnIndex("costObject")));
            vector.add(new Integer(table.getColumnIndex("costObjectName")));
            vector.add(new Integer(table.getColumnIndex("costCenterOrgUnit")));
            vector.add(new Integer(table.getColumnIndex("mainAdminOrgUnit")));
            if (!ArrayUtil.isEmpty((Object[])unClearCols)) {
                int len = unClearCols.length;
                for (int i = 0; i < len; ++i) {
                    vector.add(new Integer(table.getColumnIndex(unClearCols[i])));
                }
            }
        }
        int startColIndex = 0;
        if (isFullTableClear) {
            needClearColNum = table.getColumnCount();
        } else {
            if (ArrayUtil.isEmpty((Object[])needClearCols)) {
                return;
            }
            needClearColNum = needClearCols.length;
        }
        IRow curRow = table.getRow(rowIndex);
        for (int i = startColIndex; i < needClearColNum; ++i) {
            int curColIndex;
            if (isFullTableClear) {
                if (vector.contains(new Integer(i))) continue;
                curColIndex = i;
            } else {
                curColIndex = table.getColumnIndex(needClearCols[i]);
            }
            ICellEditor cellEditor = table.getColumn(curColIndex).getEditor();
            if (cellEditor != null && cellEditor.getComponent() instanceof KDFormattedTextField) {
                KDFormattedTextField ktf = (KDFormattedTextField)cellEditor.getComponent();
                if (ktf.getDataType() != 1) continue;
                curRow.getCell(curColIndex).setValue((Object)ZERO);
                continue;
            }
            if (curRow.getCell(curColIndex).getValue() instanceof Boolean) {
                curRow.getCell(curColIndex).setValue((Object)Boolean.FALSE);
                continue;
            }
            curRow.getCell(curColIndex).setValue(null);
        }
    }

    public static void setCellValueNull(KDTable kdtEntry, String[] colNames, int rowIndex, boolean isAllCols) {
        int cols;
        int startColIndex;
        if (isAllCols && colNames == null) {
            startColIndex = 1;
            cols = kdtEntry.getColumnCount();
        } else {
            startColIndex = 0;
            cols = colNames.length;
        }
        IRow curRow = kdtEntry.getRow(rowIndex);
        if (curRow == null) {
            return;
        }
        int id_index = kdtEntry.getColumnIndex("Id");
        int storeType_index = kdtEntry.getColumnIndex("storeType");
        int storeStatus_index = kdtEntry.getColumnIndex("storeStatus");
        int warehouse_index = kdtEntry.getColumnIndex(WAREHOUSE);
        int moveInWarehouse_index = kdtEntry.getColumnIndex("moveInWarehouse");
        int moveOutWarehouse_index = kdtEntry.getColumnIndex("moveOutWarehouse");
        int moveInLocation_index = kdtEntry.getColumnIndex("moveInLocation");
        int moveOutLocation_index = kdtEntry.getColumnIndex("moveOutLocation");
        int stocker_index = kdtEntry.getColumnIndex("stocker");
        int location_index = kdtEntry.getColumnIndex(LOCATION);
        int customer_index = kdtEntry.getColumnIndex("customer");
        int supplier_index = kdtEntry.getColumnIndex("supplier");
        int discountType_index = kdtEntry.getColumnIndex("discountType");
        int invUpdateType_index = kdtEntry.getColumnIndex("invUpdateType");
        for (int i = startColIndex; i < cols; ++i) {
            int curCol;
            if (isAllCols) {
                if (i == id_index || i == storeType_index || i == storeStatus_index || i == warehouse_index || i == moveInWarehouse_index || i == moveOutWarehouse_index || i == moveInLocation_index || i == moveOutLocation_index || i == stocker_index || i == location_index || i == customer_index || i == supplier_index || i == discountType_index || i == invUpdateType_index) continue;
                curCol = i;
            } else {
                curCol = kdtEntry.getColumnIndex(colNames[i]);
            }
            ICellEditor cellEditor = kdtEntry.getColumn(curCol).getEditor();
            if (cellEditor != null && cellEditor.getComponent() instanceof KDFormattedTextField) {
                KDFormattedTextField ktf = (KDFormattedTextField)cellEditor.getComponent();
                if (ktf.getDataType() != 1) continue;
                curRow.getCell(curCol).setValue((Object)ZERO);
                continue;
            }
            if (curRow.getCell(curCol).getValue() instanceof Boolean) {
                curRow.getCell(curCol).setValue((Object)new Boolean(false));
                continue;
            }
            curRow.getCell(curCol).setValue(null);
        }
    }

    public static void setCellValueNull(KDTable kdtEntry, IRow curRow, String[] colNames) {
        for (int i = 0; i < colNames.length; ++i) {
            curRow.getCell(kdtEntry.getColumnIndex(colNames[i])).setValue(null);
        }
    }

    public static void setCellCopyColValueNull(KDTable kdtEntry) {
        int rowCount = kdtEntry.getRowCount();
        String[] cols = new String[]{WAREHOUSE, "stocker", LOCATION, "balanceCustomer"};
        for (int i = 0; i < rowCount; ++i) {
            for (int j = 0; j < cols.length; ++j) {
                if (kdtEntry.getCell(i, cols[j]) == null) continue;
                kdtEntry.getCell(i, cols[j]).setValue(null);
            }
        }
    }

    public static int getLocalCurrencyPrecision(CompanyOrgUnitInfo cou) throws Exception {
        int precision = 2;
        ICurrency ic = CurrencyFactory.getRemoteInstance();
        CurrencyInfo ci = ic.getCurrencyInfo((IObjectPK)new ObjectUuidPK(cou.getBaseCurrency().getId()));
        precision = ci.getPrecision();
        return precision;
    }

    public static boolean isRowBlankOnTable(KDTable detailTable, int row, String[] cols) throws Exception {
        if (detailTable == null) {
            throw new Exception("table is null!");
        }
        if (cols == null) {
            return true;
        }
        for (int i = 0; i < cols.length; ++i) {
            if (detailTable.getCell(row, cols[i]) == null || detailTable.getCell(row, cols[i]).getValue() == null) continue;
            return false;
        }
        return true;
    }

    public static void setFreezeCol(KDTable kdTable, String colName) {
        int freezeCol = kdTable.getColumnIndex(colName);
        kdTable.getViewManager().setFreezeView(-1, freezeCol + 1);
    }

    public static EntityViewInfo getCUViewInfo(CtrlUnitInfo cu) {
        if (cu != null) {
            EntityViewInfo evi = new EntityViewInfo();
            FilterInfo fi = new FilterInfo();
            fi.getFilterItems().add(new FilterItemInfo("CU", (Object)cu.getId().toString(), CompareType.EQUALS));
            evi.setFilter(fi);
            return evi;
        }
        return null;
    }

    public static TransactionTypeInfo getTransaction(String billTypeID, BizTypeInfo bizType, BillTypeInfo srcBillType) throws EASBizException, BOSException {
        TransactionTypeCollection tic;
        String bizTypeID = null;
        TransactionTypeInfo transaction = null;
        if (bizType != null) {
            bizTypeID = bizType.getId().toString();
        }
        if (billTypeID != null && (tic = TransactionTypeFactory.getRemoteInstance().getCollection(billTypeID, bizTypeID)) != null) {
            for (int i = 0; i < tic.size(); ++i) {
                transaction = tic.get(i);
                if (transaction.getStatus().getValue() != 1) continue;
                return transaction;
            }
        }
        return null;
    }

    public static TransactionTypeInfo getTransaction(EntityViewInfo viewInfo) throws EASBizException, BOSException {
        TransactionTypeInfo transaction = null;
        TransactionTypeCollection tic = TransactionTypeFactory.getRemoteInstance().getTransactionTypeCollection(viewInfo);
        if (tic != null) {
            for (int i = 0; i < tic.size(); ++i) {
                transaction = tic.get(i);
                if (transaction.getStatus().getValue() != 1) continue;
                return transaction;
            }
        }
        return null;
    }

    public static String checkMaterialHasCompany(SCMFetchData fetchData, Object[] materials, String companyID) throws BOSException, EASBizException {
        int i;
        if (materials.length == 0) {
            return "";
        }
        StringBuffer msg = new StringBuffer();
        StringBuffer resultmsg = new StringBuffer();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        int size = materials.length;
        for (i = 0; i < size; ++i) {
            if (fetchData.getMaterialCompany(((MaterialInfo)materials[i]).getId().toString(), companyID) == null) continue;
            hashMap.put(((MaterialInfo)materials[i]).getId().toString(), "");
        }
        size = materials.length;
        for (i = 0; i < size; ++i) {
            if (hashMap.containsKey(((MaterialInfo)materials[i]).getId().toString())) continue;
            msg.append("\n");
            msg.append(((MaterialInfo)materials[i]).getNumber());
            msg.append(": ");
            msg.append(((MaterialInfo)materials[i]).getName());
        }
        if (msg.toString().length() > 0) {
            resultmsg.append(InvClientUtils.getResource("MATERIALNOCOMPAY"));
            resultmsg.append(msg);
        }
        return resultmsg.toString();
    }

    public static String checkMaterialHasCompany(Object[] materials, String companyID) throws BOSException, EASBizException {
        int i;
        if (materials.length == 0) {
            return "";
        }
        MaterialCompanyInfoCollection mcic = SCMBillCommonFacadeFactory.getRemoteInstance().getMaterialCompanyCollection(InvClientUtils.getMaterialCompanyOQL(materials, companyID));
        StringBuffer msg = new StringBuffer();
        StringBuffer resultmsg = new StringBuffer();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        int size = mcic.size();
        for (i = 0; i < size; ++i) {
            MaterialCompanyInfoInfo mci = mcic.get(i);
            hashMap.put(mci.getMateial().getId().toString(), "");
        }
        size = materials.length;
        for (i = 0; i < size; ++i) {
            if (hashMap.containsKey(((MaterialInfo)materials[i]).getId().toString())) continue;
            msg.append("\n");
            msg.append(((MaterialInfo)materials[i]).getNumber());
            msg.append(": ");
            msg.append(((MaterialInfo)materials[i]).getName());
        }
        if (msg.toString().length() > 0) {
            resultmsg.append(InvClientUtils.getResource("MATERIALNOCOMPAY"));
            resultmsg.append(msg);
        }
        return resultmsg.toString();
    }

    public static String checkMaterialHasCompany(Object[] materials, String companyID, SCMFetchData fetchData) throws BOSException, EASBizException {
        int i;
        if (materials.length == 0) {
            return "";
        }
        if (companyID == null || fetchData == null) {
            return "";
        }
        MaterialCompanyInfoCollection mcic = new MaterialCompanyInfoCollection();
        MaterialCompanyInfoInfo info = null;
        MaterialInfo material = null;
        String materialiID = "";
        MaterialInfo[] materials_needfetch = new MaterialInfo[materials.length];
        int j = 0;
        for (int i2 = 0; i2 < materials.length; ++i2) {
            material = (MaterialInfo)materials[i2];
            if (material == null || material.getId() == null) continue;
            materialiID = material.getId().toString();
            info = fetchData.getMaterialCompany(materialiID, companyID);
            if (info != null) {
                mcic.add(info);
                continue;
            }
            materials_needfetch[j++] = material;
        }
        if (j != 0) {
            MaterialCompanyInfoCollection mcic_fetch = SCMBillCommonFacadeFactory.getRemoteInstance().getMaterialCompanyCollection(InvClientUtils.getMaterialCompanyOQL(materials, companyID));
            mcic.addCollection(mcic_fetch);
        }
        StringBuffer msg = new StringBuffer();
        StringBuffer resultmsg = new StringBuffer();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        int size = mcic.size();
        for (i = 0; i < size; ++i) {
            MaterialCompanyInfoInfo mci = mcic.get(i);
            hashMap.put(mci.getMateial().getId().toString(), "");
        }
        size = materials.length;
        for (i = 0; i < size; ++i) {
            if (hashMap.containsKey(((MaterialInfo)materials[i]).getId().toString())) continue;
            msg.append("\n");
            msg.append(((MaterialInfo)materials[i]).getNumber());
            msg.append(": ");
            msg.append(((MaterialInfo)materials[i]).getName());
        }
        if (msg.toString().length() > 0) {
            resultmsg.append(InvClientUtils.getResource("MATERIALNOCOMPAY"));
            resultmsg.append(msg);
        }
        return resultmsg.toString();
    }

    public static Map getmatPemissionSqlMap(Set cuUnitSets, int rettype, String repStr) {
        FullOrgUnitInfo cuUnit2 = null;
        EntityViewInfo matEntityViewInfo = null;
        HashMap<String, String> matpermMap = new HashMap<String, String>();
        if (cuUnitSets != null && cuUnitSets.size() > 0) {
            for (FullOrgUnitInfo cuUnit2 : cuUnitSets) {
                try {
                    String orgId = null;
                    orgId = cuUnit2.isIsCU() ? cuUnit2.getId().toString() : cuUnit2.getCU().getId().toString();
                    matEntityViewInfo = InvClientUtils.getDataPermissionEntity(orgId, "bd_material_view");
                    if (rettype == 0 && matEntityViewInfo != null) {
                        matpermMap.put(cuUnit2.getId().toString(), InvClientUtils.getCUFilterString(matEntityViewInfo, "material."));
                        continue;
                    }
                    if (rettype != 1 || matEntityViewInfo == null || matEntityViewInfo == null) continue;
                    matpermMap.put(cuUnit2.getId().toString(), InvClientUtils.getmaterialPermSql(matEntityViewInfo, repStr));
                }
                catch (Exception e) {
                    return null;
                }
            }
        }
        return matpermMap;
    }

    public static String getCUFilterString(EntityViewInfo matEntityViewInfo, String str) {
        StringBuffer sb = new StringBuffer();
        String itemStr = "";
        if (matEntityViewInfo != null) {
            String[] masks = InvClientUtils.getMasking(matEntityViewInfo.getFilter().getMaskString());
            FilterInfo filter = matEntityViewInfo.getFilter();
            FilterItemCollection items = filter.getFilterItems();
            for (int i = 0; i < items.size(); ++i) {
                itemStr = InvClientUtils.getFilterString(items.get(i), str);
                sb.append(InvClientUtils.getJoinStr(itemStr, masks, i));
            }
        }
        return sb.toString();
    }

    private static String getFilterString(FilterItemInfo item, String str) {
        return str + item.toString();
    }

    private static String[] getMasking(String masking) {
        String[] ret = masking.split("\\#");
        return ret;
    }

    private static String getJoinStr(String iterStr, String[] maskStr, int index) {
        if (index == 0) {
            return maskStr[0] + maskStr[1].replace(index + "", iterStr);
        }
        int isExist = maskStr[index + 1].indexOf(index + "");
        if (isExist > -1) {
            return maskStr[index + 1].replace(index + "", iterStr);
        }
        return "";
    }

    public static Map getwarePemissionSqlMap(Set cuUnitSets, int rettype, String repStr) {
        HashMap<String, String> warePermMap = new HashMap<String, String>();
        FullOrgUnitInfo cuUnit2 = null;
        EntityViewInfo wareEntityViewInfo = null;
        if (cuUnitSets != null && cuUnitSets.size() > 0) {
            for (FullOrgUnitInfo cuUnit2 : cuUnitSets) {
                try {
                    String orgId = null;
                    orgId = cuUnit2.isIsCU() ? cuUnit2.getId().toString() : cuUnit2.getCU().getId().toString();
                    wareEntityViewInfo = InvClientUtils.getDataPermissionEntity(orgId, "warehous_view");
                    if (rettype == 0 && wareEntityViewInfo != null) {
                        warePermMap.put(cuUnit2.getId().toString(), InvClientUtils.getCUFilterString(wareEntityViewInfo, "warehouse."));
                        continue;
                    }
                    if (rettype != 1 || wareEntityViewInfo == null) continue;
                    warePermMap.put(cuUnit2.getId().toString(), InvClientUtils.getwarePermSql(wareEntityViewInfo, repStr));
                }
                catch (Exception e) {
                    return null;
                }
            }
        }
        return warePermMap;
    }

    public static Set getAuthorizedf7Orgs() {
        OrgViewType[] orgViewTypes = new OrgViewType[]{OrgViewType.STORAGE};
        OrgType orgType = NewOrgViewHelper.convert((OrgViewType)orgViewTypes[0]);
        ObjectUuidPK treePK = new ObjectUuidPK(NewOrgViewHelper.convert2TreeId((OrgType)orgType));
        ObjectUuidPK userPK = new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId());
        HashSet<String> orgUnitSet = new HashSet<String>();
        Set fullUnitSet = new HashSet();
        FullOrgUnitCollection unitCol = null;
        try {
            unitCol = PermissionFactory.getRemoteInstance().getAuthorizedOrg((IObjectPK)userPK, orgType, (IObjectPK)treePK, "inoutstoregatherreport_view");
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
            return orgUnitSet;
        }
        for (int i = 0; i < unitCol.size(); ++i) {
            orgUnitSet.add(unitCol.get(i).getId().toString());
        }
        fullUnitSet = InvClientUtils.getFullOrgUnit(orgUnitSet);
        return fullUnitSet;
    }

    private static Set getFullOrgUnit(Set orgUnitSet) {
        FullOrgUnitCollection orgUnitCollection = null;
        HashSet<FullOrgUnitInfo> fullUnitSet = new HashSet<FullOrgUnitInfo>();
        try {
            IFullOrgUnit iFullOrgUnit = FullOrgUnitFactory.getRemoteInstance();
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("*"));
            EntityViewInfo ev = new EntityViewInfo();
            FilterInfo fi = new FilterInfo();
            fi.getFilterItems().add(new FilterItemInfo("ID", (Object)orgUnitSet, CompareType.INCLUDE));
            ev.setSelector(sic);
            ev.setFilter(fi);
            orgUnitCollection = iFullOrgUnit.getFullOrgUnitCollection(ev);
            for (int i = 0; i < orgUnitCollection.size(); ++i) {
                fullUnitSet.add(orgUnitCollection.get(i));
            }
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
        return fullUnitSet;
    }

    public static String getwarePermSql(EntityViewInfo entityViewInfo, String repStr) {
        String fsql = null;
        String oriSql = null;
        String finalSql = null;
        MetaDataPK warehousQuery = MetaDataPK.create((String)"com.kingdee.eas.basedata.scm.im.inv.app", (String)"WarehouseQuery");
        try {
            String toSql;
            int posORDER;
            IQueryExecutor exec = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)warehousQuery);
            exec.setObjectView(entityViewInfo);
            oriSql = exec.getSQL();
            int posWhere = oriSql.indexOf("WHERE");
            if (posWhere > 0 && (posORDER = (toSql = oriSql.substring(posWhere + 5, oriSql.length())).indexOf("ORDER")) > 0) {
                finalSql = toSql.substring(0, posORDER - 1);
                fsql = finalSql.replaceAll("\"WAREHOUSE\".", repStr);
            }
        }
        catch (BOSException e) {
            return null;
        }
        return fsql;
    }

    public static String getmaterialPermSql(EntityViewInfo entityViewInfo, String repStr) {
        String fsql = null;
        String oriSql = null;
        String finalSql = null;
        MetaDataPK mainQueryPK = MetaDataPK.create((String)"com.kingdee.eas.basedata.master.material.app", (String)"MaterialQuery");
        try {
            String toSql;
            int posORDER;
            IQueryExecutor exec = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)mainQueryPK);
            exec.setObjectView(entityViewInfo);
            oriSql = exec.getSQL();
            int posWhere = oriSql.indexOf("WHERE");
            if (posWhere > 0 && (posORDER = (toSql = oriSql.substring(posWhere + 5, oriSql.length())).indexOf("ORDER")) > 0) {
                finalSql = toSql.substring(0, posORDER - 1);
                fsql = finalSql.replaceAll("\"MATERIAL\".", repStr);
            }
        }
        catch (BOSException e) {
            return null;
        }
        return fsql;
    }

    public static EntityViewInfo getDataPermissionEntity(String storageOrgID, String PermissionItem) throws Exception {
        ObjectUuidPK userPK = new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId().toString());
        ObjectUuidPK orgPK = null;
        if (storageOrgID != null) {
            orgPK = new ObjectUuidPK(storageOrgID);
        }
        if (orgPK == null) {
            return null;
        }
        IPermissionServiceProvider provider = PermissionServiceProviderFactory.getRemoteInstance();
        String oql = provider.getPermissionRule((IObjectPK)userPK, (IObjectPK)orgPK, PermissionItem);
        if (oql == null) {
            return null;
        }
        StringBuffer permision = new StringBuffer();
        permision.append(" select * ");
        permision.append(oql);
        oql = permision.toString();
        EntityViewInfo view = null;
        FilterInfo filter = null;
        try {
            view = new EntityViewInfo(oql);
        }
        catch (ParserException e) {
            return null;
        }
        if (view.getFilter() != null && view.getFilter().getFilterItems() != null && view.getFilter().getFilterItems().size() > 0) {
            filter = view.getFilter();
        }
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        entityViewInfo.setFilter(filter);
        return entityViewInfo;
    }

    private static String getMaterialCompanyOQL(Object[] materials, String companyID) {
        StringBuffer oqlWhere = new StringBuffer();
        oqlWhere.append("select id,mateial.id,company.id where ");
        oqlWhere.append("mateial.id  in(");
        int size = materials.length;
        for (int i = 0; i < size; ++i) {
            if (StringUtils.isEmpty((String)((MaterialInfo)materials[i]).getId().toString())) continue;
            oqlWhere.append("'").append(((MaterialInfo)materials[i]).getId().toString()).append("',");
        }
        oqlWhere.delete(oqlWhere.length() - 1, oqlWhere.length());
        oqlWhere.append(")");
        oqlWhere.append(" and company.id = '").append(companyID).append("' ");
        return oqlWhere.toString();
    }

    public static String[] getMaterailCollection(InvBillBaseInfo invBillBaseInfo) {
        IObjectCollection entrys = (IObjectCollection)invBillBaseInfo.get("entry");
        InvBillBaseEntryInfo invBillBaseEntryInfo = null;
        int size = entrys.size();
        String[] materails = new String[size];
        for (int i = 0; i < size; ++i) {
            invBillBaseEntryInfo = (InvBillBaseEntryInfo)entrys.getObject(i);
            if (invBillBaseEntryInfo.getMaterial() == null) continue;
            materails[i] = invBillBaseEntryInfo.getMaterial().getId().toString();
        }
        return materails;
    }

    public static HashMap getMultiMeasureUnits(IMultiMeasureUnit imultiUnit, String[] materialId, String[] measureUnitId) throws BOSException {
        HashMap<String, MultiMeasureUnitInfo> mulUnitsMap = new HashMap<String, MultiMeasureUnitInfo>();
        if (imultiUnit != null) {
            String oqlWhere = SCMClientUtils.getMultiMeasureUnitOQL((String[])materialId, (String[])measureUnitId);
            if (StringUtils.isEmpty((String)oqlWhere)) {
                return mulUnitsMap;
            }
            MultiMeasureUnitCollection mulUnits = imultiUnit.getMultiMeasureUnitCollection(oqlWhere);
            MultiMeasureUnitInfo mulUnitInfo = null;
            int num = mulUnits.size();
            for (int i = 0; i < num; ++i) {
                mulUnitInfo = mulUnits.get(i);
                mulUnitsMap.put(mulUnitInfo.getMaterial().getId().toString() + mulUnitInfo.getMeasureUnit().getId().toString(), mulUnitInfo);
            }
        }
        return mulUnitsMap;
    }

    public static HashMap getUnitCollection(InvBillBaseInfo invBillBaseInfo) throws BOSException {
        IObjectCollection entrys = (IObjectCollection)invBillBaseInfo.get("entry");
        if (entrys == null) {
            entrys = (IObjectCollection)invBillBaseInfo.get("entries");
        }
        InvBillBaseEntryInfo invBillBaseEntryInfo = null;
        int size = entrys.size();
        String[] units = new String[size];
        String[] baseUnits = new String[size];
        String[] assistUnits = new String[size];
        HashMap<String, HashMap> hashMap = new HashMap<String, HashMap>();
        if (size > 0) {
            for (int i = 0; i < size; ++i) {
                invBillBaseEntryInfo = (InvBillBaseEntryInfo)entrys.getObject(i);
                if (invBillBaseEntryInfo == null || invBillBaseEntryInfo.getMaterial() == null || invBillBaseEntryInfo.getUnit() == null) continue;
                units[i] = invBillBaseEntryInfo.getUnit().getId().toString();
                baseUnits[i] = invBillBaseEntryInfo.getBaseUnit().getId().toString();
                assistUnits[i] = invBillBaseEntryInfo.getAssistUnit() != null ? invBillBaseEntryInfo.getAssistUnit().getId().toString() : null;
            }
            String[] materials = InvClientUtils.getMaterailCollection(invBillBaseInfo);
            IMultiMeasureUnit imultiUnit = MultiMeasureUnitFactory.getRemoteInstance();
            HashMap hmUnit = InvClientUtils.getMultiMeasureUnits(imultiUnit, materials, units);
            HashMap hmBaseUnit = InvClientUtils.getMultiMeasureUnits(imultiUnit, materials, baseUnits);
            HashMap hmAssistUnit = InvClientUtils.getMultiMeasureUnits(imultiUnit, materials, assistUnits);
            hashMap.put(UNIT, hmUnit);
            hashMap.put(BASEUNIT, hmBaseUnit);
            hashMap.put(ASSISTUNIT, hmAssistUnit);
        }
        return hashMap;
    }

    public static void setExpAndMfgEditable(MaterialInventoryInfo materialInventoryInfo, KDTable kdtEntry, int rowIndex, boolean isInWarehouse) {
        if (materialInventoryInfo == null) {
            return;
        }
        IRow curRow = kdtEntry.getRow(rowIndex);
        if (materialInventoryInfo.isIsPeriodValid()) {
            if (isInWarehouse) {
                curRow.getCell(kdtEntry.getColumnIndex(MFG)).getStyleAttributes().setLocked(false);
                curRow.getCell(kdtEntry.getColumnIndex(EXP)).getStyleAttributes().setLocked(false);
            } else {
                curRow.getCell(kdtEntry.getColumnIndex(MFG)).getStyleAttributes().setLocked(true);
                curRow.getCell(kdtEntry.getColumnIndex(EXP)).getStyleAttributes().setLocked(true);
            }
            SCMClientUtils.setNecessColorInCells((KDTable)kdtEntry, (String)MFG, (int)rowIndex, (boolean)true);
            SCMClientUtils.setNecessColorInCells((KDTable)kdtEntry, (String)EXP, (int)rowIndex, (boolean)true);
        } else {
            curRow.getCell(kdtEntry.getColumnIndex(MFG)).getStyleAttributes().setLocked(true);
            curRow.getCell(kdtEntry.getColumnIndex(EXP)).getStyleAttributes().setLocked(true);
            SCMClientUtils.setNecessColorInCells((KDTable)kdtEntry, (String)MFG, (int)rowIndex, (boolean)false);
            SCMClientUtils.setNecessColorInCells((KDTable)kdtEntry, (String)EXP, (int)rowIndex, (boolean)false);
        }
    }

    public static EntityViewInfo getBizStorageFilter() {
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(SCMClientUtils.getF7FilterInfoByAuthorizeStorageOrg((String)"STORAGEORGUNIT.ID"));
        return viewInfo;
    }

    public static void setExpAndMfgEnabled(MaterialInventoryInfo materialInventoryInfo, KDTable kdtEntry, int rowIndex, boolean isInWarehouse) {
        if (materialInventoryInfo == null) {
            return;
        }
        IRow curRow = kdtEntry.getRow(rowIndex);
        if (materialInventoryInfo.isIsPeriodValid()) {
            if (isInWarehouse) {
                curRow.getCell(kdtEntry.getColumnIndex(MFG)).getStyleAttributes().setLocked(false);
                curRow.getCell(kdtEntry.getColumnIndex(EXP)).getStyleAttributes().setLocked(false);
            } else {
                curRow.getCell(kdtEntry.getColumnIndex(MFG)).getStyleAttributes().setLocked(true);
                curRow.getCell(kdtEntry.getColumnIndex(EXP)).getStyleAttributes().setLocked(true);
            }
            SCMClientUtils.setNecessColorInCells((KDTable)kdtEntry, (String)MFG, (int)rowIndex, (boolean)true);
            SCMClientUtils.setNecessColorInCells((KDTable)kdtEntry, (String)EXP, (int)rowIndex, (boolean)true);
            curRow.getCell(kdtEntry.getColumnIndex(PERIODVALID)).setValue((Object)new Integer(materialInventoryInfo.getPeriodValid()));
            curRow.getCell(kdtEntry.getColumnIndex(PERIODVALIDUNIT)).setValue((Object)new Integer(materialInventoryInfo.getPeriodValidUnit().getValue()));
        } else {
            curRow.getCell(kdtEntry.getColumnIndex(MFG)).getStyleAttributes().setLocked(true);
            curRow.getCell(kdtEntry.getColumnIndex(EXP)).getStyleAttributes().setLocked(true);
            SCMClientUtils.setNecessColorInCells((KDTable)kdtEntry, (String)MFG, (int)rowIndex, (boolean)false);
            SCMClientUtils.setNecessColorInCells((KDTable)kdtEntry, (String)EXP, (int)rowIndex, (boolean)false);
            curRow.getCell(kdtEntry.getColumnIndex(PERIODVALID)).setValue(null);
            curRow.getCell(kdtEntry.getColumnIndex(PERIODVALIDUNIT)).setValue(null);
            curRow.getCell(MFG).setValue(null);
            curRow.getCell(EXP).setValue(null);
        }
    }

    public static void setExpAndMfgValue(MaterialInventoryInfo materialInventoryInfo, KDTable kdtEntry, int rowIndex, boolean isInWarehouse) {
        if (materialInventoryInfo == null) {
            return;
        }
        IRow curRow = kdtEntry.getRow(rowIndex);
        if (materialInventoryInfo.isIsPeriodValid()) {
            curRow.getCell(kdtEntry.getColumnIndex(PERIODVALID)).setValue((Object)new Integer(materialInventoryInfo.getPeriodValid()));
            curRow.getCell(kdtEntry.getColumnIndex(PERIODVALIDUNIT)).setValue((Object)new Integer(materialInventoryInfo.getPeriodValidUnit().getValue()));
        } else {
            curRow.getCell(kdtEntry.getColumnIndex(PERIODVALID)).setValue(null);
            curRow.getCell(kdtEntry.getColumnIndex(PERIODVALIDUNIT)).setValue(null);
            curRow.getCell(MFG).setValue(null);
            curRow.getCell(EXP).setValue(null);
        }
    }

    public static void setExpAndMfgEnabledWhenLoad(KDTable kdtEntry) {
        kdtEntry.getColumn(EXP).getStyleAttributes().setLocked(true);
        kdtEntry.getColumn(MFG).getStyleAttributes().setLocked(true);
    }

    public static void setExpAndMfgEnabledWhenLoad(InvBillBaseInfo invBillBaseInfo, KDTable kdtEntry) {
        if (invBillBaseInfo == null) {
            return;
        }
        if (invBillBaseInfo.get("entry") == null) {
            return;
        }
        IObjectCollection iObjectCollection = (IObjectCollection)invBillBaseInfo.get("entry");
        InvBillBaseEntryInfo invBillBaseEntryInfo = null;
        IRow curRow = null;
        Map dateofMinMap = new HashMap();
        String key = null;
        for (int i = 0; i < iObjectCollection.size(); ++i) {
            invBillBaseEntryInfo = (InvBillBaseEntryInfo)iObjectCollection.getObject(i);
            if (invBillBaseEntryInfo.getStorageOrgUnit() == null || invBillBaseEntryInfo.getMaterial() == null) {
                return;
            }
            curRow = kdtEntry.getRow(i);
            if (curRow == null) {
                return;
            }
            if (invBillBaseEntryInfo == null || curRow.getCell(kdtEntry.getColumnIndex(PERIODVALID)).getValue() == null || invBillBaseEntryInfo.getStorageOrgUnit() == null || invBillBaseEntryInfo.getMaterial() == null || invBillBaseEntryInfo.getLot() == null) continue;
            if (i == 0) {
                try {
                    dateofMinMap = DateOfMinDurabilityFactory.getRemoteInstance().batchGetDateOfMin(iObjectCollection);
                }
                catch (Exception e) {
                    ExceptionHandler.handle((Throwable)e);
                }
            }
            curRow.getCell(kdtEntry.getColumnIndex(MFG)).getStyleAttributes().setLocked(true);
            curRow.getCell(kdtEntry.getColumnIndex(EXP)).getStyleAttributes().setLocked(true);
            key = invBillBaseEntryInfo.getStorageOrgUnit().getId().toString() + invBillBaseEntryInfo.getMaterial().getId().toString() + invBillBaseEntryInfo.getLot();
            DateOfMinDurabilityInfo dod = (DateOfMinDurabilityInfo)dateofMinMap.get(key);
            if (dod != null) {
                curRow.getCell(kdtEntry.getColumnIndex(MFG)).setValue((Object)dod.getMfg());
                curRow.getCell(kdtEntry.getColumnIndex(EXP)).setValue((Object)dod.getExp());
                continue;
            }
            EntityViewInfo evi = new EntityViewInfo();
            FilterInfo fi = new FilterInfo();
            fi.getFilterItems().add(new FilterItemInfo("storageOrgUnit", (Object)invBillBaseEntryInfo.getStorageOrgUnit().getId().toString(), CompareType.EQUALS));
            fi.getFilterItems().add(new FilterItemInfo("material", (Object)invBillBaseEntryInfo.getMaterial().getId().toString(), CompareType.EQUALS));
            fi.getFilterItems().add(new FilterItemInfo(LOT, (Object)invBillBaseEntryInfo.getLot(), CompareType.EQUALS));
            evi.setFilter(fi);
            try {
                IDateOfMinDurability ido = DateOfMinDurabilityFactory.getRemoteInstance();
                DateOfMinDurabilityCollection doc = ido.getDateOfMinDurabilityCollection(evi);
                if (doc == null || doc.size() <= 0) {
                    curRow.getCell(kdtEntry.getColumnIndex(MFG)).getStyleAttributes().setLocked(false);
                    curRow.getCell(kdtEntry.getColumnIndex(EXP)).getStyleAttributes().setLocked(false);
                    continue;
                }
                dod = doc.get(0);
                curRow.getCell(kdtEntry.getColumnIndex(MFG)).setValue((Object)dod.getMfg());
                curRow.getCell(kdtEntry.getColumnIndex(EXP)).setValue((Object)dod.getExp());
                continue;
            }
            catch (BOSException e) {
                ExceptionHandler.handle((Throwable)e);
            }
        }
    }

    public static void setExpAndMfgEnabledWhenLoad(InvBillBaseInfo baseInfo, KDTable kdtEntry, SCMFetchData fetchData) throws EASBizException, BOSException {
        if (baseInfo == null || baseInfo.get("entry") == null) {
            return;
        }
        IObjectCollection iObjectCollection = (IObjectCollection)baseInfo.get("entry");
        InvBillBaseEntryInfo entryInfo = null;
        IRow curRow = null;
        for (int i = 0; i < iObjectCollection.size(); ++i) {
            entryInfo = (InvBillBaseEntryInfo)iObjectCollection.getObject(i);
            curRow = kdtEntry.getRow(i);
            if (entryInfo.getStorageOrgUnit() == null || entryInfo.getMaterial() == null || curRow == null) {
                return;
            }
            if (entryInfo == null || curRow.getCell(kdtEntry.getColumnIndex(PERIODVALID)).getValue() == null || entryInfo.getStorageOrgUnit() == null || entryInfo.getMaterial() == null || entryInfo.getLot() == null) continue;
            curRow.getCell(kdtEntry.getColumnIndex(MFG)).getStyleAttributes().setLocked(true);
            curRow.getCell(kdtEntry.getColumnIndex(EXP)).getStyleAttributes().setLocked(true);
            try {
                DateOfMinDurabilityInfo dod = fetchData.getDurability(entryInfo.getMaterial().getId().toString(), entryInfo.getStorageOrgUnit().getId().toString(), entryInfo.getLot());
                if (dod == null) {
                    curRow.getCell(kdtEntry.getColumnIndex(MFG)).getStyleAttributes().setLocked(false);
                    curRow.getCell(kdtEntry.getColumnIndex(EXP)).getStyleAttributes().setLocked(false);
                    continue;
                }
                curRow.getCell(kdtEntry.getColumnIndex(MFG)).setValue((Object)dod.getMfg());
                curRow.getCell(kdtEntry.getColumnIndex(EXP)).setValue((Object)dod.getExp());
                continue;
            }
            catch (BOSException e) {
                ExceptionHandler.handle((Throwable)e);
            }
        }
    }

    public static Date getMFG(Date exp, int unit, int unitValue) {
        Calendar mfgCal = InvClientUtils.getMFGCalerdar(exp, unit, unitValue);
        return mfgCal == null ? null : mfgCal.getTime();
    }

    public static Calendar getMFGCalerdar(Date exp, int unit, int unitValue) {
        if (exp != null) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(exp);
            if (unit == 1) {
                calendar.add(1, -unitValue);
            } else if (unit == 2) {
                calendar.add(2, -unitValue);
            } else if (unit == 3) {
                calendar.add(5, -unitValue);
            }
            return calendar;
        }
        return null;
    }

    public static void setMFG(KDTable kdtEntry, int rowIndex, TransactionTypeInfo tti, boolean isReversed, boolean plusOne) throws EASBizException, BOSException {
        InvClientUtils.setMFG(kdtEntry, rowIndex, tti, isReversed, plusOne, null, null, null);
    }

    public static void setMFG(KDTable kdtEntry, int rowIndex, TransactionTypeInfo tti, boolean isReversed) throws EASBizException, BOSException {
        InvClientUtils.setMFG(kdtEntry, rowIndex, tti, isReversed, false);
    }

    public static void setMFG(KDTable kdtEntry, int rowIndex, TransactionTypeInfo tti, boolean isReversed, boolean plusOne, StorageOrgUnitInfo sou, MaterialInfo materialInfo, InvBillBaseInfo editData) throws EASBizException, BOSException {
        InvClientUtils.setMFG(kdtEntry, rowIndex, tti, isReversed, plusOne, sou, materialInfo, editData, true, null);
    }

    public static void setMFG(KDTable kdtEntry, int rowIndex, TransactionTypeInfo tti, boolean isReversed, boolean plusOne, StorageOrgUnitInfo sou, MaterialInfo materialInfo, InvBillBaseInfo editData, boolean checkEXP, SCMFetchData fetchData) throws EASBizException, BOSException {
        IRow curRow = kdtEntry.getRow(rowIndex);
        if (curRow.getCell(MFG).getValue() != null) {
            return;
        }
        if (curRow.getCell(PERIODVALID).getValue() != null && curRow.getCell(PERIODVALIDUNIT).getValue() != null && curRow.getCell(EXP).getValue() != null) {
            MaterialInventoryInfo materialInv = fetchData.getMaterialInventory(materialInfo.getId().toString(), sou.getId().toString());
            if (materialInv.getCloseDateCalMode().getValue() == 2) {
                return;
            }
            if (materialInv.getCloseDateCalMode().getValue() == 1) {
                plusOne = true;
            }
            Date exp = (Date)curRow.getCell(EXP).getValue();
            int periodVlidUnit = 0;
            if (curRow.getCell(PERIODVALIDUNIT) != null && curRow.getCell(PERIODVALIDUNIT).getValue() != null) {
                if (curRow.getCell(PERIODVALIDUNIT).getValue() instanceof Integer) {
                    periodVlidUnit = (Integer)curRow.getCell(PERIODVALIDUNIT).getValue();
                } else if (curRow.getCell(PERIODVALIDUNIT).getValue() instanceof TimeUnitEnum) {
                    periodVlidUnit = ((TimeUnitEnum)curRow.getCell(PERIODVALIDUNIT).getValue()).getValue();
                }
            }
            Calendar mfgCal = InvClientUtils.getMFGCalerdar(exp, periodVlidUnit, Integer.parseInt(curRow.getCell(PERIODVALID).getValue().toString()));
            if (plusOne && mfgCal != null) {
                mfgCal.add(5, 1);
            }
            curRow.getCell(MFG).setValue((Object)(mfgCal == null ? null : mfgCal.getTime()));
            if (sou != null && materialInfo != null && editData != null) {
                InvClientUtils.checkEXP(kdtEntry, rowIndex, tti, isReversed, sou, materialInfo, editData, checkEXP);
            } else {
                InvClientUtils.checkEXP(kdtEntry, rowIndex, tti, isReversed);
            }
        }
    }

    public static void checkEXP(KDTable kdtEntry, int rowIndex, TransactionTypeInfo tti, boolean isReversed) {
        boolean afterNow;
        if (null == tti) {
            return;
        }
        if (isReversed) {
            return;
        }
        IRow curRow = kdtEntry.getRow(rowIndex);
        Date mfg = (Date)curRow.getCell(MFG).getValue();
        Date exp = (Date)curRow.getCell(EXP).getValue();
        if (mfg == null || exp == null) {
            return;
        }
        if (exp.before(mfg) && !exp.equals(mfg)) {
            kdtEntry.getEditManager().editCellAt(rowIndex, kdtEntry.getColumnIndex(EXP));
            MsgBox.showInfo((String)InvClientUtils.getResource("EXPBEFOREMFG"));
            return;
        }
        Date now = new Date();
        Date now2 = new Date(now.getYear(), now.getMonth(), now.getDate());
        boolean beforeNow = exp.before(now2) && !exp.equals(now2);
        boolean bl = afterNow = mfg.after(now2) && !mfg.equals(now2);
        if (beforeNow || afterNow) {
            int ret;
            String msg = null;
            if (SCMBaseCommonUtil.isNormalIssueWarehsSubInvTransaction((TransactionTypeInfo)tti) && (ret = MsgBox.showConfirm3((String)(msg = beforeNow ? InvClientUtils.getResource("EXPVAILDOUT") : InvClientUtils.getResource("MFGVALIDOUT")))) != 0) {
                curRow.getCell(EXP).setValue(null);
                curRow.getCell(MFG).setValue(null);
                curRow.getCell(LOT).setValue(null);
                kdtEntry.getEditManager().editCellAt(rowIndex, kdtEntry.getColumnIndex(LOT));
            }
            if (SCMBaseCommonUtil.isNormalInWarehsAddInvTransaction((TransactionTypeInfo)tti) && (ret = MsgBox.showConfirm3((String)(msg = beforeNow ? InvClientUtils.getResource("EXPVAILDIN") : InvClientUtils.getResource("MFGVALIDIN")))) != 0) {
                curRow.getCell(EXP).setValue(null);
                curRow.getCell(MFG).setValue(null);
                kdtEntry.getEditManager().editCellAt(rowIndex, kdtEntry.getColumnIndex(EXP));
            }
        }
    }

    public static void checkEXP(Component uiCompanent, KDTable kdtEntry, int rowIndex, TransactionTypeInfo tti, boolean isReversed) {
        boolean afterNow;
        Date now;
        Date now2;
        if (isReversed) {
            return;
        }
        IRow curRow = kdtEntry.getRow(rowIndex);
        Date mfg = (Date)curRow.getCell(MFG).getValue();
        Date exp = (Date)curRow.getCell(EXP).getValue();
        if (mfg == null || exp == null) {
            return;
        }
        if (exp.before(mfg) && !exp.equals(mfg)) {
            kdtEntry.getEditManager().editCellAt(rowIndex, kdtEntry.getColumnIndex(EXP));
            MsgBox.showInfo((String)InvClientUtils.getResource("EXPBEFOREMFG"));
            SysUtil.abort();
        }
        boolean beforeNow = exp.before(now2 = new Date((now = new Date()).getYear(), now.getMonth(), now.getDate())) && !exp.equals(now2);
        boolean bl = afterNow = mfg.after(now2) && !mfg.equals(now2);
        if (beforeNow || afterNow) {
            int ret;
            String msg = null;
            if (SCMBaseCommonUtil.isNormalIssueWarehsSubInvTransaction((TransactionTypeInfo)tti) && (ret = MsgBox.showConfirm3((Component)uiCompanent, (String)(msg = beforeNow ? InvClientUtils.getResource("EXPVAILDOUT") : InvClientUtils.getResource("MFGVALIDOUT")))) != 0) {
                curRow.getCell(EXP).setValue(null);
                curRow.getCell(MFG).setValue(null);
                curRow.getCell(LOT).setValue(null);
                kdtEntry.getEditManager().editCellAt(rowIndex, kdtEntry.getColumnIndex(LOT));
            }
            if (tti != null) {
                int ret2;
                int bizDirection = tti.getRiType().getBizDirection().getValue();
                String billTypeID = tti.getBillType().getId().toString();
                if (bizDirection == 1 && SCMBaseCommonUtil.isInWarehsBill((String)billTypeID) && (ret2 = MsgBox.showConfirm3((Component)uiCompanent, (String)(msg = beforeNow ? InvClientUtils.getResource("EXPVAILDIN") : InvClientUtils.getResource("MFGVALIDIN")))) != 0) {
                    curRow.getCell(EXP).setValue(null);
                    curRow.getCell(MFG).setValue(null);
                    kdtEntry.getEditManager().editCellAt(rowIndex, kdtEntry.getColumnIndex(EXP));
                }
            }
        }
    }

    public static void checkEXP(KDTable kdtEntry, int rowIndex, TransactionTypeInfo tti, boolean isReversed, StorageOrgUnitInfo sou, MaterialInfo materialInfo, InvBillBaseInfo editData) {
        InvClientUtils.checkEXP(kdtEntry, rowIndex, tti, isReversed, sou, materialInfo, editData, true);
    }

    public static void checkEXPWithParentUI(Component uiCompanent, KDTable kdtEntry, int rowIndex, TransactionTypeInfo tti, boolean isReversed, StorageOrgUnitInfo sou, MaterialInfo materialInfo, InvBillBaseInfo editData) {
        InvClientUtils.checkEXPWithParentUI(uiCompanent, kdtEntry, rowIndex, tti, isReversed, sou, materialInfo, editData, true);
    }

    public static void checkEXP(KDTable kdtEntry, int rowIndex, TransactionTypeInfo tti, boolean isReversed, StorageOrgUnitInfo sou, MaterialInfo materialInfo, InvBillBaseInfo editData, boolean uncheckEXP) {
        String msg;
        int ret;
        MaterialInventoryInfo materialInventory;
        Calendar c;
        if (isReversed) {
            return;
        }
        IRow curRow = kdtEntry.getRow(rowIndex);
        Date mfg = (Date)curRow.getCell(MFG).getValue();
        Date exp = (Date)curRow.getCell(EXP).getValue();
        if (mfg == null || exp == null) {
            return;
        }
        if (exp.before(mfg) && !exp.equals(mfg)) {
            kdtEntry.getEditManager().editCellAt(rowIndex, kdtEntry.getColumnIndex(EXP));
            MsgBox.showInfo((String)InvClientUtils.getResource("EXPBEFOREMFG"));
            return;
        }
        Date now = new Date();
        Date now2 = new Date(now.getYear(), now.getMonth(), now.getDate());
        Date newMfg = new Date(mfg.getYear(), mfg.getMonth(), mfg.getDate());
        boolean beforeNow = exp.before(now2) && !exp.equals(now2);
        boolean afterNow = newMfg.after(now2) && !newMfg.equals(now2);
        boolean ischecked = false;
        if (beforeNow || afterNow) {
            int ret2;
            String msg2 = null;
            if (SCMBaseCommonUtil.isNormalIssueWarehsSubInvTransaction((TransactionTypeInfo)tti)) {
                ischecked = true;
                msg2 = beforeNow ? InvClientUtils.getResource("EXPVAILDOUT") : InvClientUtils.getResource("MFGVALIDOUT");
                ret2 = MsgBox.showConfirm3((String)msg2);
                if (ret2 != 0) {
                    curRow.getCell(EXP).setValue(null);
                    curRow.getCell(MFG).setValue(null);
                    curRow.getCell(LOT).setValue(null);
                    kdtEntry.getEditManager().editCellAt(rowIndex, kdtEntry.getColumnIndex(LOT));
                }
            }
            if (SCMBaseCommonUtil.isNormalInWarehsAddInvTransaction((TransactionTypeInfo)tti)) {
                ischecked = true;
                msg2 = beforeNow ? InvClientUtils.getResource("EXPVAILDIN") : InvClientUtils.getResource("MFGVALIDIN");
                ret2 = MsgBox.showConfirm3((String)msg2);
                if (ret2 != 0) {
                    curRow.getCell(EXP).setValue(null);
                    curRow.getCell(MFG).setValue(null);
                    kdtEntry.getEditManager().editCellAt(rowIndex, kdtEntry.getColumnIndex(EXP));
                }
            }
        }
        if (!uncheckEXP) {
            return;
        }
        Date bizDate = editData.getBizDate();
        if (null == bizDate) {
            bizDate = new Date();
            editData.setBizDate(bizDate);
        }
        Date compareBizDate = new Date(bizDate.getTime() + 3600000L);
        if (sou != null && materialInfo != null && editData != null && (editData instanceof PurReceivalBillInfo || editData instanceof PurInWarehsBillInfo || editData instanceof OtherInWarehsBillInfo || editData instanceof MoveInWarehsBillInfo || editData instanceof ManufactureRecBillInfo) && !ischecked) {
            c = Calendar.getInstance();
            c.setTime(exp);
            try {
                materialInventory = MaterialInventoryFactory.getRemoteInstance().getInventoryInfo(materialInfo.getId().toString(), sou.getId().toString());
                if (materialInventory != null && materialInventory.isIsPeriodValid()) {
                    int InWarehsAhead = materialInventory.getInWarehsAhead();
                    if (materialInventory.getAheadUnit().equals((Object)TimeUnitEnum.YEAR)) {
                        c.add(1, -InWarehsAhead);
                    } else if (materialInventory.getAheadUnit().equals((Object)TimeUnitEnum.MONTH)) {
                        c.add(2, -InWarehsAhead);
                    } else if (materialInventory.getAheadUnit().equals((Object)TimeUnitEnum.DAY)) {
                        c.add(5, -InWarehsAhead);
                    }
                    if (c.getTime().before(compareBizDate) && (ret = MsgBox.showConfirm3((String)(msg = InvClientUtils.getResource("EXPVALID")))) != 0) {
                        curRow.getCell(EXP).setValue(null);
                        curRow.getCell(MFG).setValue(null);
                        curRow.getCell(LOT).setValue(null);
                        kdtEntry.getEditManager().editCellAt(rowIndex, kdtEntry.getColumnIndex(EXP));
                    }
                }
            }
            catch (EASBizException e) {
                Logger.error((Throwable)e);
            }
            catch (BOSException e) {
                Logger.error((Throwable)e);
            }
        }
        if (sou != null && materialInfo != null && editData != null && (editData instanceof SaleIssueBillInfo || editData instanceof MaterialRequestBillInfo || editData instanceof OtherIssueBillInfo || editData instanceof MoveIssueBillInfo || editData instanceof MaterialReqBillInfo) && !ischecked) {
            c = Calendar.getInstance();
            c.setTime(exp);
            try {
                materialInventory = MaterialInventoryFactory.getRemoteInstance().getInventoryInfo(materialInfo.getId().toString(), sou.getId().toString());
                if (materialInventory != null && materialInventory.isIsPeriodValid()) {
                    int outWarehsAhead = materialInventory.getOutWarehsAhead();
                    if (materialInventory.getAheadUnit().equals((Object)TimeUnitEnum.YEAR)) {
                        c.add(1, -outWarehsAhead);
                    } else if (materialInventory.getAheadUnit().equals((Object)TimeUnitEnum.MONTH)) {
                        c.add(2, -outWarehsAhead);
                    } else if (materialInventory.getAheadUnit().equals((Object)TimeUnitEnum.DAY)) {
                        c.add(5, -outWarehsAhead);
                    }
                    if (c.getTime().before(compareBizDate) && (ret = MsgBox.showConfirm3((String)(msg = InvClientUtils.getResource("EXPVALID")))) != 0) {
                        curRow.getCell(EXP).setValue(null);
                        curRow.getCell(MFG).setValue(null);
                        curRow.getCell(LOT).setValue(null);
                        kdtEntry.getEditManager().editCellAt(rowIndex, kdtEntry.getColumnIndex(EXP));
                    }
                }
            }
            catch (EASBizException e) {
                Logger.error((Throwable)e);
            }
            catch (BOSException e) {
                Logger.error((Throwable)e);
            }
        }
    }

    public static void checkEXPWithParentUI(Component uiCompanent, KDTable kdtEntry, int rowIndex, TransactionTypeInfo tti, boolean isReversed, StorageOrgUnitInfo sou, MaterialInfo materialInfo, InvBillBaseInfo editData, boolean uncheckEXP) {
        String msg;
        int ret;
        MaterialInventoryInfo materialInventory;
        Calendar c;
        if (isReversed) {
            return;
        }
        IRow curRow = kdtEntry.getRow(rowIndex);
        Date mfg = (Date)curRow.getCell(MFG).getValue();
        Date exp = (Date)curRow.getCell(EXP).getValue();
        if (mfg == null || exp == null) {
            return;
        }
        if (exp.before(mfg) && !exp.equals(mfg)) {
            kdtEntry.getEditManager().editCellAt(rowIndex, kdtEntry.getColumnIndex(EXP));
            MsgBox.showInfo((String)InvClientUtils.getResource("EXPBEFOREMFG"));
            return;
        }
        Date now = new Date();
        Date now2 = new Date(now.getYear(), now.getMonth(), now.getDate());
        boolean beforeNow = exp.before(now2) && !exp.equals(now2);
        boolean afterNow = mfg.after(now2) && !mfg.equals(now2);
        boolean ischecked = false;
        if (beforeNow || afterNow) {
            int ret2;
            String msg2 = null;
            if (SCMBaseCommonUtil.isNormalIssueWarehsSubInvTransaction((TransactionTypeInfo)tti)) {
                ischecked = true;
                msg2 = beforeNow ? InvClientUtils.getResource("EXPVAILDOUT") : InvClientUtils.getResource("MFGVALIDOUT");
                ret2 = MsgBox.showConfirm3((Component)uiCompanent, (String)msg2);
                if (ret2 != 0) {
                    curRow.getCell(EXP).setValue(null);
                    curRow.getCell(MFG).setValue(null);
                    curRow.getCell(LOT).setValue(null);
                    kdtEntry.getEditManager().editCellAt(rowIndex, kdtEntry.getColumnIndex(LOT));
                }
            }
            if (tti != null && SCMBaseCommonUtil.isNormalInWarehsAddInvTransaction((TransactionTypeInfo)tti)) {
                ischecked = true;
                msg2 = beforeNow ? InvClientUtils.getResource("EXPVAILDIN") : InvClientUtils.getResource("MFGVALIDIN");
                ret2 = MsgBox.showConfirm3((Component)uiCompanent, (String)msg2);
                if (ret2 != 0) {
                    curRow.getCell(EXP).setValue(null);
                    curRow.getCell(MFG).setValue(null);
                    kdtEntry.getEditManager().editCellAt(rowIndex, kdtEntry.getColumnIndex(EXP));
                }
            }
        }
        if (!uncheckEXP) {
            return;
        }
        Date bizDate = editData.getBizDate();
        if (null == bizDate) {
            bizDate = new Date();
            editData.setBizDate(bizDate);
        }
        Date compareBizDate = new Date(bizDate.getTime() + 3600000L);
        if (sou != null && materialInfo != null && editData != null && (editData instanceof PurReceivalBillInfo || editData instanceof PurInWarehsBillInfo || editData instanceof OtherInWarehsBillInfo || editData instanceof MoveInWarehsBillInfo || editData instanceof ManufactureRecBillInfo) && !ischecked) {
            c = Calendar.getInstance();
            c.setTime(exp);
            try {
                materialInventory = MaterialInventoryFactory.getRemoteInstance().getInventoryInfo(materialInfo.getId().toString(), sou.getId().toString());
                if (materialInventory != null && materialInventory.isIsPeriodValid()) {
                    int InWarehsAhead = materialInventory.getInWarehsAhead();
                    if (materialInventory.getAheadUnit().equals((Object)TimeUnitEnum.YEAR)) {
                        c.add(1, -InWarehsAhead);
                    } else if (materialInventory.getAheadUnit().equals((Object)TimeUnitEnum.MONTH)) {
                        c.add(2, -InWarehsAhead);
                    } else if (materialInventory.getAheadUnit().equals((Object)TimeUnitEnum.DAY)) {
                        c.add(5, -InWarehsAhead);
                    }
                    if (c.getTime().before(compareBizDate) && (ret = MsgBox.showConfirm3((Component)uiCompanent, (String)(msg = InvClientUtils.getResource("EXPVALID")))) != 0) {
                        curRow.getCell(EXP).setValue(null);
                        curRow.getCell(MFG).setValue(null);
                        kdtEntry.getEditManager().editCellAt(rowIndex, kdtEntry.getColumnIndex(EXP));
                    }
                }
            }
            catch (EASBizException e) {
                Logger.error((Throwable)e);
            }
            catch (BOSException e) {
                Logger.error((Throwable)e);
            }
        }
        if (sou != null && materialInfo != null && editData != null && (editData instanceof SaleIssueBillInfo || editData instanceof MaterialRequestBillInfo || editData instanceof OtherIssueBillInfo || editData instanceof MoveIssueBillInfo || editData instanceof MaterialReqBillInfo) && !ischecked) {
            c = Calendar.getInstance();
            c.setTime(exp);
            try {
                materialInventory = MaterialInventoryFactory.getRemoteInstance().getInventoryInfo(materialInfo.getId().toString(), sou.getId().toString());
                if (materialInventory != null && materialInventory.isIsPeriodValid()) {
                    int outWarehsAhead = materialInventory.getOutWarehsAhead();
                    if (materialInventory.getAheadUnit().equals((Object)TimeUnitEnum.YEAR)) {
                        c.add(1, -outWarehsAhead);
                    } else if (materialInventory.getAheadUnit().equals((Object)TimeUnitEnum.MONTH)) {
                        c.add(2, -outWarehsAhead);
                    } else if (materialInventory.getAheadUnit().equals((Object)TimeUnitEnum.DAY)) {
                        c.add(5, -outWarehsAhead);
                    }
                    if (c.getTime().before(compareBizDate) && (ret = MsgBox.showConfirm3((Component)uiCompanent, (String)(msg = InvClientUtils.getResource("EXPVALID")))) != 0) {
                        curRow.getCell(EXP).setValue(null);
                        curRow.getCell(MFG).setValue(null);
                        kdtEntry.getEditManager().editCellAt(rowIndex, kdtEntry.getColumnIndex(EXP));
                    }
                }
            }
            catch (EASBizException e) {
                Logger.error((Throwable)e);
            }
            catch (BOSException e) {
                Logger.error((Throwable)e);
            }
        }
    }

    public static Date getPeriodValid(Date exp, Date mfg) {
        if (mfg != null && exp != null) {
            return DateTimeUtils.subDate((Date)exp, (Date)mfg);
        }
        return null;
    }

    public static boolean isUseWarehsRelation(String storageOrgUnitID) throws EASBizException, BOSException {
        ObjectUuidPK pk;
        boolean isUseWarehsRelation = false;
        IParamControl ipc = ParamControlFactory.getRemoteInstance();
        String strUseWarehsRelation = ipc.getParamValue((IObjectPK)(pk = new ObjectUuidPK(storageOrgUnitID)), "INM008");
        if (strUseWarehsRelation != null && strUseWarehsRelation.trim().length() != 0 && strUseWarehsRelation.trim().equalsIgnoreCase("true")) {
            isUseWarehsRelation = true;
        }
        return isUseWarehsRelation;
    }

    public static Integer getDayNumber(int unit, int unitValue) {
        if (unit == 1) {
            return new Integer(unitValue * 365);
        }
        if (unit == 2) {
            return new Integer(unitValue * 30);
        }
        if (unit == 3) {
            return new Integer(unitValue);
        }
        return new Integer(0);
    }

    public static void setLotInfo(KDTable kdtEntry, int rowIndex, StorageOrgUnitInfo sou, MaterialInfo materialInfo, String lot, InvBillBaseInfo editData) {
        if (sou == null || materialInfo == null) {
            return;
        }
        IRow curRow = kdtEntry.getRow(rowIndex);
        InvClientUtils.setLotData(kdtEntry, curRow, sou, materialInfo, lot, editData);
    }

    public static void setLotInfo(TransactionTypeInfo tti, KDTable kdtEntry, int rowIndex, StorageOrgUnitInfo sou, MaterialInfo materialInfo, String lot, InvBillBaseInfo editData) {
        if (sou == null || materialInfo == null) {
            return;
        }
        IRow curRow = kdtEntry.getRow(rowIndex);
        InvClientUtils.setLotData(tti, kdtEntry, curRow, sou, materialInfo, lot, editData);
    }

    public static void setLotInfo(KDTable kdtEntry, int rowIndex, StorageOrgUnitInfo sou, MaterialInfo materialInfo, String lot, InvBillBaseInfo editData, SCMFetchData fetchData) throws EASBizException, BOSException {
        if (sou == null || materialInfo == null) {
            return;
        }
        IRow curRow = kdtEntry.getRow(rowIndex);
        InvClientUtils.setLotData(kdtEntry, curRow, sou, materialInfo, lot, editData, fetchData);
    }

    public static void setLotInfo(KDTable kdtEntry, String materialCol, InvBillBaseInfo editData) {
        if (editData.getStorageOrgUnit() == null || materialCol == null) {
            return;
        }
        IRow curRow = null;
        int rows = kdtEntry.getRowCount();
        for (int i = 0; i < rows; ++i) {
            curRow = kdtEntry.getRow(i);
            if (curRow.getCell(LOT).getValue() == null) continue;
            InvClientUtils.setLotData(kdtEntry, curRow, editData.getStorageOrgUnit(), (MaterialInfo)curRow.getCell(materialCol).getValue(), curRow.getCell(LOT).getValue().toString(), editData);
        }
    }

    private static void setLotData(KDTable kdtEntry, IRow curRow, StorageOrgUnitInfo sou, MaterialInfo materialInfo, String lot, InvBillBaseInfo editData, SCMFetchData fetchData) throws EASBizException, BOSException {
        MaterialInventoryInfo matInv = fetchData.getMaterialInventory(materialInfo.getId().toString(), sou.getId().toString());
        boolean isPeriodVaild = matInv.isIsPeriodValid();
        if (!isPeriodVaild) {
            curRow.getCell(kdtEntry.getColumnIndex(MFG)).setValue(null);
            curRow.getCell(kdtEntry.getColumnIndex(EXP)).setValue(null);
            return;
        }
        try {
            DateOfMinDurabilityInfo dod = fetchData.getDurability(materialInfo.getId().toString(), sou.getId().toString(), lot);
            if (dod == null) {
                curRow.getCell(kdtEntry.getColumnIndex(MFG)).getStyleAttributes().setLocked(false);
                curRow.getCell(kdtEntry.getColumnIndex(EXP)).getStyleAttributes().setLocked(false);
                if (InvClientUtils.isOut(null, editData)) {
                    curRow.getCell(kdtEntry.getColumnIndex(MFG)).setValue(null);
                    curRow.getCell(kdtEntry.getColumnIndex(EXP)).setValue(null);
                    if (!InvClientUtils.isJumpOrg(editData)) {
                        curRow.getCell(kdtEntry.getColumnIndex(MFG)).getStyleAttributes().setLocked(true);
                        curRow.getCell(kdtEntry.getColumnIndex(EXP)).getStyleAttributes().setLocked(true);
                    }
                }
            } else {
                curRow.getCell(kdtEntry.getColumnIndex(MFG)).setValue((Object)dod.getMfg());
                curRow.getCell(kdtEntry.getColumnIndex(EXP)).setValue((Object)dod.getExp());
                curRow.getCell(kdtEntry.getColumnIndex(MFG)).getStyleAttributes().setLocked(true);
                curRow.getCell(kdtEntry.getColumnIndex(EXP)).getStyleAttributes().setLocked(true);
            }
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
        }
    }

    public static DateOfMinDurabilityInfo getDateOfMinDurabilityInfo(StorageOrgUnitInfo sou, MaterialInfo materialInfo, String lot) {
        DateOfMinDurabilityInfo domDurabilityInfo = null;
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("storageOrgUnit", (Object)sou.getId().toString(), CompareType.EQUALS));
        fi.getFilterItems().add(new FilterItemInfo("material", (Object)materialInfo.getId().toString(), CompareType.EQUALS));
        fi.getFilterItems().add(new FilterItemInfo(LOT, (Object)lot, CompareType.EQUALS));
        evi.setFilter(fi);
        try {
            IDateOfMinDurability domd = DateOfMinDurabilityFactory.getRemoteInstance();
            DateOfMinDurabilityCollection domdCollection = domd.getDateOfMinDurabilityCollection(evi);
            if (domdCollection != null && domdCollection.size() > 0) {
                domDurabilityInfo = domdCollection.get(0);
            }
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        return domDurabilityInfo;
    }

    private static void setLotData(KDTable kdtEntry, IRow curRow, StorageOrgUnitInfo sou, MaterialInfo materialInfo, String lot, InvBillBaseInfo editData) {
        InvClientUtils.setLotData(null, kdtEntry, curRow, sou, materialInfo, lot, editData);
    }

    private static void setLotData(TransactionTypeInfo tti, KDTable kdtEntry, IRow curRow, StorageOrgUnitInfo sou, MaterialInfo materialInfo, String lot, InvBillBaseInfo editData) {
        boolean isPeriodVaild;
        boolean bl = isPeriodVaild = curRow.getCell(kdtEntry.getColumnIndex(PERIODVALIDUNIT)).getValue() != null;
        if (!isPeriodVaild) {
            curRow.getCell(kdtEntry.getColumnIndex(MFG)).setValue(null);
            curRow.getCell(kdtEntry.getColumnIndex(EXP)).setValue(null);
            return;
        }
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("storageOrgUnit", (Object)sou.getId().toString(), CompareType.EQUALS));
        fi.getFilterItems().add(new FilterItemInfo("material", (Object)materialInfo.getId().toString(), CompareType.EQUALS));
        if (lot != null) {
            fi.getFilterItems().add(new FilterItemInfo(LOT, (Object)lot, CompareType.EQUALS));
        }
        evi.setFilter(fi);
        try {
            IDateOfMinDurability ido = DateOfMinDurabilityFactory.getRemoteInstance();
            DateOfMinDurabilityCollection doc = ido.getDateOfMinDurabilityCollection(evi);
            if (doc == null || doc.size() <= 0) {
                curRow.getCell(kdtEntry.getColumnIndex(MFG)).getStyleAttributes().setLocked(false);
                curRow.getCell(kdtEntry.getColumnIndex(EXP)).getStyleAttributes().setLocked(false);
                if (InvClientUtils.isOut(null, editData)) {
                    curRow.getCell(kdtEntry.getColumnIndex(MFG)).setValue(null);
                    curRow.getCell(kdtEntry.getColumnIndex(EXP)).setValue(null);
                    if (!InvClientUtils.isJumpOrg(editData)) {
                        curRow.getCell(kdtEntry.getColumnIndex(MFG)).getStyleAttributes().setLocked(true);
                        curRow.getCell(kdtEntry.getColumnIndex(EXP)).getStyleAttributes().setLocked(true);
                    }
                }
            } else {
                DateOfMinDurabilityInfo dod = doc.get(0);
                curRow.getCell(kdtEntry.getColumnIndex(MFG)).setValue((Object)dod.getMfg());
                curRow.getCell(kdtEntry.getColumnIndex(EXP)).setValue((Object)dod.getExp());
                curRow.getCell(kdtEntry.getColumnIndex(MFG)).getStyleAttributes().setLocked(true);
                curRow.getCell(kdtEntry.getColumnIndex(MFG)).getStyleAttributes().setNumberFormat(SCMClientUtils.strDateFormat);
                curRow.getCell(kdtEntry.getColumnIndex(EXP)).getStyleAttributes().setLocked(true);
                curRow.getCell(kdtEntry.getColumnIndex(EXP)).getStyleAttributes().setNumberFormat(SCMClientUtils.strDateFormat);
            }
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
        }
    }

    private static boolean isOut(TransactionTypeInfo info, InvBillBaseInfo editData) {
        TransactionTypeInfo tti;
        if (editData.getBillType() == null) {
            return false;
        }
        String billTypeId = editData.getBillType().getId().toString();
        if ("XlazxwEREADgAAAEwKgSxUY+1VI=".equals(billTypeId)) {
            return true;
        }
        TransactionTypeInfo transactionTypeInfo = tti = info != null ? info : editData.getTransactionType();
        if (tti == null) {
            return false;
        }
        if (("50957179-0105-1000-e000-015bc0a812fd463ED552".equals(billTypeId) || "50957179-0105-1000-e000-016ec0a812fd463ED552".equals(billTypeId) || "50957179-0105-1000-e000-0163c0a812fd463ED552".equals(billTypeId) || "50957179-0105-1000-e000-0177c0a812fd463ED552".equals(billTypeId)) && SCMBaseCommonUtil.isNormalIssueWarehsSubInvTransaction((TransactionTypeInfo)tti)) {
            return true;
        }
        return ("50957179-0105-1000-e000-015fc0a812fd463ED552".equals(billTypeId) || "50957179-0105-1000-e000-0157c0a812fd463ED552".equals(billTypeId) || "50957179-0105-1000-e000-017bc0a812fd463ED552".equals(billTypeId) || "50957179-0105-1000-e000-0167c0a812fd463ED552".equals(billTypeId)) && SCMBaseCommonUtil.isInWarehsSubInvTransaction((TransactionTypeInfo)tti);
    }

    public static Date getEXP(Date mfg, int unit, int unitValue) {
        return InvClientUtils.getEXP(mfg, unit, unitValue, false);
    }

    public static Date getEXP(Date mfg, int unit, int unitValue, boolean minusOne) {
        if (mfg != null) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(mfg);
            if (unit == 1) {
                calendar.add(1, unitValue);
            } else if (unit == 2) {
                calendar.add(2, unitValue);
            } else if (unit == 3) {
                calendar.add(5, unitValue);
            }
            if (minusOne) {
                calendar.add(5, -1);
            }
            return calendar.getTime();
        }
        return null;
    }

    public static void setEXP(KDTable kdtEntry, int rowIndex, TransactionTypeInfo tti, boolean isReversed) throws Exception {
        InvClientUtils.setEXP(kdtEntry, rowIndex, tti, isReversed, false);
    }

    public static void setEXP(KDTable kdtEntry, int rowIndex, TransactionTypeInfo tti, boolean isReversed, boolean minusOne) throws Exception {
        InvClientUtils.setEXP(kdtEntry, rowIndex, tti, isReversed, minusOne, null, null, null, null);
    }

    public static void setEXP(KDTable kdtEntry, int rowIndex, TransactionTypeInfo tti, boolean isReversed, boolean minusOne, StorageOrgUnitInfo sou, MaterialInfo materialInfo, SCMFetchData fetchData, InvBillBaseInfo editData) throws Exception {
        InvClientUtils.setEXP(kdtEntry, rowIndex, tti, isReversed, minusOne, sou, materialInfo, fetchData, editData, true);
    }

    public static void setEXP(KDTable kdtEntry, int rowIndex, TransactionTypeInfo tti, boolean isReversed, boolean minusOne, StorageOrgUnitInfo sou, MaterialInfo materialInfo, SCMFetchData fetchData, InvBillBaseInfo editData, boolean uncheckEXP) throws Exception {
        IRow curRow = kdtEntry.getRow(rowIndex);
        if (curRow.getCell(PERIODVALID).getValue() != null && curRow.getCell(PERIODVALIDUNIT).getValue() != null && curRow.getCell(MFG).getValue() != null) {
            Date mfg = (Date)curRow.getCell(MFG).getValue();
            int periodVlidUnit = 0;
            if (curRow.getCell(PERIODVALIDUNIT) != null && curRow.getCell(PERIODVALIDUNIT).getValue() != null) {
                if (curRow.getCell(PERIODVALIDUNIT).getValue() instanceof Integer) {
                    periodVlidUnit = (Integer)curRow.getCell(PERIODVALIDUNIT).getValue();
                } else if (curRow.getCell(PERIODVALIDUNIT).getValue() instanceof TimeUnitEnum) {
                    periodVlidUnit = ((TimeUnitEnum)curRow.getCell(PERIODVALIDUNIT).getValue()).getValue();
                }
            }
            if (sou == null || materialInfo == null) {
                return;
            }
            MaterialInventoryInfo materialInv = fetchData.getMaterialInventory(materialInfo.getId().toString(), sou.getId().toString());
            Date exp = null;
            if (materialInv.getCloseDateCalMode().getValue() == 0) {
                minusOne = false;
                exp = InvClientUtils.getEXP(mfg, periodVlidUnit, Integer.parseInt(curRow.getCell(PERIODVALID).getValue().toString()), minusOne);
            }
            if (materialInv.getCloseDateCalMode().getValue() == 1) {
                minusOne = true;
                exp = InvClientUtils.getEXP(mfg, periodVlidUnit, Integer.parseInt(curRow.getCell(PERIODVALID).getValue().toString()), minusOne);
            }
            if (materialInv.getCloseDateCalMode().getValue() == 2) {
                exp = InvClientUtils.getEXP1(mfg, periodVlidUnit, Integer.parseInt(curRow.getCell(PERIODVALID).getValue().toString()));
            }
            curRow.getCell(EXP).setValue((Object)exp);
            if (sou != null && materialInfo != null && editData != null) {
                InvClientUtils.checkEXP(kdtEntry, rowIndex, tti, isReversed, sou, materialInfo, editData, uncheckEXP);
            } else {
                InvClientUtils.checkEXP(kdtEntry, rowIndex, tti, isReversed);
            }
        }
    }

    public static Date getEXP1(Date mfg, int unit, int unitValue) throws Exception {
        if (mfg != null) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(mfg);
            if (unit == 1) {
                calendar.add(1, unitValue);
            } else if (unit == 2) {
                calendar.add(2, unitValue);
            } else if (unit == 3) {
                calendar.add(5, unitValue);
            }
            int year = 0;
            int month = calendar.get(2);
            year = calendar.get(1);
            String temp = year + "-" + month;
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM");
            Date d = null;
            d = format.parse(temp);
            calendar.setTime(d);
            int day = calendar.getActualMaximum(5);
            String endDay = year + "-" + month + "-" + day;
            SimpleDateFormat fomat = new SimpleDateFormat("yyyy-MM-dd");
            Date endDate = null;
            endDate = fomat.parse(endDay);
            return endDate;
        }
        return null;
    }

    public static Date getExpByMfg(MaterialInfo material, StorageOrgUnitInfo sou, Date mfg) throws Exception {
        if (material == null || sou == null || mfg == null) {
            return null;
        }
        MaterialInventoryInfo materialInv = MaterialInventoryFactory.getRemoteInstance().getInventoryInfo(material.getId().toString(), sou.getId().toString());
        if (materialInv == null) {
            return null;
        }
        TimeUnitEnum timeUnit = materialInv.getPeriodValidUnit();
        int period = materialInv.getPeriodValid();
        if (timeUnit != null && period != 0) {
            return InvClientUtils.getEXP(mfg, timeUnit.getValue(), period);
        }
        return null;
    }

    public static Date getMfgByExp(MaterialInfo material, StorageOrgUnitInfo sou, Date exp) throws Exception {
        if (material == null || sou == null || exp == null) {
            return null;
        }
        MaterialInventoryInfo materialInv = MaterialInventoryFactory.getRemoteInstance().getInventoryInfo(material.getId().toString(), sou.getId().toString());
        if (materialInv == null) {
            return null;
        }
        TimeUnitEnum timeUnit = materialInv.getPeriodValidUnit();
        int period = materialInv.getPeriodValid();
        if (timeUnit != null && period != 0) {
            return InvClientUtils.getMFG(exp, timeUnit.getValue(), period);
        }
        return null;
    }

    public static void checkDuplicateLot(KDTable kdtEntry, String materialColName) {
        int rows = kdtEntry.getRowCount() - 1;
        if (rows < 0) {
            return;
        }
        IRow iRow = null;
        ArrayList<String> al = new ArrayList<String>();
        ArrayList<String> al2 = new ArrayList<String>();
        MaterialInfo materialInfo = null;
        for (int i = 0; i <= rows; ++i) {
            iRow = kdtEntry.getRow(i);
            if (iRow.getCell(EXP).getValue() != null && iRow.getCell(MFG).getValue() != null && iRow.getCell(LOT).getValue() != null && iRow.getCell(materialColName).getValue() != null) {
                materialInfo = (MaterialInfo)iRow.getCell(materialColName).getValue();
                al.add(materialInfo.getId().toString() + iRow.getCell(LOT).getValue().toString());
                al2.add(materialInfo.getId().toString() + ((Date)iRow.getCell(MFG).getValue()).getTime() + ((Date)iRow.getCell(EXP).getValue()).getTime());
                continue;
            }
            al.add(null);
            al2.add(null);
        }
        String rec = null;
        String rec2 = null;
        int recs = al.size();
        for (int i = 0; i < recs; ++i) {
            if (al.get(i) == null || al2.get(i) == null) continue;
            rec = al.get(i).toString();
            rec2 = al2.get(i).toString();
            for (int j = i + 1; j < recs; ++j) {
                if (al.get(j) == null || al2.get(j) == null || !al.get(j).toString().equals(rec) || al2.get(j).toString().equals(rec2)) continue;
                String comma = ResourceUtil.getMessage(null, (String)addResource, (String)"Comma", null);
                String duplicateLots = ResourceUtil.getMessage(null, (String)addResource, (String)"DUPLICATELOTS", (String[])new String[]{String.valueOf(i + 1), comma, String.valueOf(j + 1)});
                MsgBox.showInfo((String)duplicateLots);
                kdtEntry.getEditManager().editCellAt(i, kdtEntry.getColumnIndex(LOT));
                SysUtil.abort();
            }
        }
    }

    public static List checkDuplicateLot(InvBillBaseInfo invBillInfo, KDTable tabMain, String materialCol, String asstAttrCol, String lotCol) {
        ArrayList<String> errors = new ArrayList<String>();
        if (null == invBillInfo || null == invBillInfo.getBillType() || null == invBillInfo.getStorageOrgUnit() || null == tabMain || StringUtil.isEmpty((String)materialCol) || StringUtil.isEmpty((String)asstAttrCol) || StringUtil.isEmpty((String)lotCol) || null == tabMain.getColumn(materialCol)) {
            return errors;
        }
        String billTypeID = invBillInfo.getBillType().getId().toString();
        String souID = invBillInfo.getStorageOrgUnit().getId().toString();
        IRow row = null;
        MaterialInfo material = null;
        AsstAttrValueInfo asstAttr = null;
        String lot = null;
        ArrayList<String> clientArr = new ArrayList<String>();
        try {
            int rowCount = tabMain.getRowCount();
            for (int i = 0; i < rowCount; ++i) {
                row = tabMain.getRow(i);
                if (null == row.getCell(materialCol) || null == row.getCell(materialCol).getValue() || null == row.getCell(lotCol) || null == row.getCell(lotCol).getValue()) continue;
                material = (MaterialInfo)row.getCell(materialCol).getValue();
                asstAttr = (AsstAttrValueInfo)row.getCell(asstAttrCol).getValue();
                String strAss = null == asstAttr ? "" : asstAttr.getId().toString();
                lot = row.getCell(lotCol).getValue().toString();
                if (!clientArr.contains(material.getId().toString() + strAss + lot)) {
                    clientArr.add(material.getId().toString() + strAss + lot);
                } else if (!errors.contains(String.valueOf(i + 1))) {
                    errors.add(String.valueOf(i + 1));
                }
                boolean isExistForServer = false;
                IInventory inventory = InventoryFactory.getRemoteInstance();
                IInvBillBaseEntry iInvEntryBiz = null;
                InventoryCollection invColl = null;
                EntityViewInfo entityViewInfo = new EntityViewInfo();
                EntityViewInfo entityViewInfoBill = new EntityViewInfo();
                FilterInfo filterInfo = new FilterInfo();
                FilterInfo filterInfoBill = new FilterInfo();
                entityViewInfo.setFilter(filterInfo);
                entityViewInfoBill.setFilter(filterInfoBill);
                filterInfo.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)souID, CompareType.EQUALS));
                filterInfo.getFilterItems().add(new FilterItemInfo("material.id", (Object)material.getId().toString(), CompareType.EQUALS));
                filterInfo.getFilterItems().add(new FilterItemInfo(LOT, (Object)lot, CompareType.EQUALS));
                filterInfo.getFilterItems().add(new FilterItemInfo("baseQty", (Object)new BigDecimal("0"), CompareType.GREATER));
                filterInfoBill.getFilterItems().add(new FilterItemInfo("parent.storageOrgUnit.id", (Object)souID, CompareType.EQUALS));
                filterInfoBill.getFilterItems().add(new FilterItemInfo("material.id", (Object)material.getId().toString(), CompareType.EQUALS));
                filterInfoBill.getFilterItems().add(new FilterItemInfo(LOT, (Object)lot, CompareType.EQUALS));
                if (!StringUtil.isEmpty((String)strAss)) {
                    filterInfo.getFilterItems().add(new FilterItemInfo("assistProperty.id", (Object)strAss, CompareType.EQUALS));
                    filterInfoBill.getFilterItems().add(new FilterItemInfo("assistProperty.id", (Object)strAss, CompareType.EQUALS));
                }
                if (invBillInfo.getId() != null) {
                    filterInfoBill.getFilterItems().add(new FilterItemInfo("parent.id", (Object)invBillInfo.getId().toString(), CompareType.NOTEQUALS));
                }
                entityViewInfo.getSelector().add(LOT);
                entityViewInfoBill.getSelector().add(LOT);
                invColl = inventory.getInventoryCollection(entityViewInfo);
                if ("50957179-0105-1000-e000-015fc0a812fd463ED552".equals(billTypeID)) {
                    iInvEntryBiz = PurInWarehsEntryFactory.getRemoteInstance();
                } else if ("50957179-0105-1000-e000-0167c0a812fd463ED552".equals(billTypeID)) {
                    iInvEntryBiz = ManufactureRecBillEntryFactory.getRemoteInstance();
                } else if ("50957179-0105-1000-e000-017bc0a812fd463ED552".equals(billTypeID)) {
                    iInvEntryBiz = OtherInWarehsBillEntryFactory.getRemoteInstance();
                    filterInfoBill.getFilterItems().add(new FilterItemInfo("sourceBillType.id", (Object)"50957179-0105-1000-e000-888880a812fd463ED552", CompareType.NOTEQUALS));
                    filterInfoBill.getFilterItems().add(new FilterItemInfo("sourceBillType.id", (Object)"50957179-0105-1000-e004-4152c0a812fd463ED552", CompareType.NOTEQUALS));
                }
                CoreBaseCollection billCollection = null;
                if (null != iInvEntryBiz) {
                    billCollection = iInvEntryBiz.getCollection(entityViewInfoBill);
                }
                if (!CollectionUtil.isEmpty(billCollection)) {
                    isExistForServer = true;
                }
                if (CollectionUtil.isEmpty((AbstractObjectCollection)invColl) && !isExistForServer || errors.contains(String.valueOf(i + 1))) continue;
                errors.add(String.valueOf(i + 1));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return errors;
    }

    public static void checkDuplicateLotAll(BillTypeInfo billType, String FID, StorageOrgUnitInfo sou, KDTable kdtEntry, int selectRow, String materialColName, String assistArrColName, boolean isBatch) throws BOSException {
        String noRow = null;
        String duplicateLots = null;
        int retMsg = -1;
        int rows = kdtEntry.getRowCount() - 1;
        if (rows < 0) {
            return;
        }
        IRow iRow = null;
        ArrayList<String> al = new ArrayList<String>();
        ArrayList<String> al2 = new ArrayList<String>();
        ArrayList<String> al3 = new ArrayList<String>();
        MaterialInfo materialInfo = null;
        AsstAttrValueInfo asstAttrValueInfo = null;
        WarehouseInfo warehouseInfo = null;
        LocationInfo locationInfo = null;
        String strAsstAttrValue = null;
        String strLocation = null;
        for (int i = 0; i <= rows; ++i) {
            iRow = kdtEntry.getRow(i);
            if (iRow.getCell(materialColName).getValue() != null && iRow.getCell(LOT).getValue() != null && iRow.getCell(WAREHOUSE).getValue() != null) {
                materialInfo = (MaterialInfo)iRow.getCell(materialColName).getValue();
                asstAttrValueInfo = (AsstAttrValueInfo)iRow.getCell(assistArrColName).getValue();
                warehouseInfo = (WarehouseInfo)iRow.getCell(WAREHOUSE).getValue();
                if (!"101".equals(billType.getNumber())) {
                    locationInfo = (LocationInfo)iRow.getCell(LOCATION).getValue();
                }
                al.add(materialInfo.getId().toString() + iRow.getCell(LOT).getValue().toString());
                strAsstAttrValue = asstAttrValueInfo != null ? asstAttrValueInfo.getId().toString() : "";
                strLocation = locationInfo != null ? locationInfo.getId().toString() : "";
                al2.add(materialInfo.getId().toString() + strAsstAttrValue + warehouseInfo.getId().toString() + strLocation);
                continue;
            }
            al.add(null);
            al2.add(null);
        }
        String rec = null;
        String rec2 = null;
        String msg = "";
        int recs = al.size();
        if (al.get(selectRow) == null || al2.get(selectRow) == null) {
            return;
        }
        rec = al.get(selectRow).toString();
        rec2 = al2.get(selectRow).toString();
        for (int j = 0; j < recs; ++j) {
            if (j == selectRow || al.get(j) == null || al2.get(j) == null || !al.get(j).toString().equals(rec) || !al2.get(j).toString().equals(rec2)) continue;
            al3.add(String.valueOf(selectRow));
            noRow = InvClientUtils.getResource("No");
            duplicateLots = InvClientUtils.getResource("DUPLICATELOTSALL");
            msg = noRow + (selectRow + 1) + duplicateLots;
            retMsg = MsgBox.showConfirm2((String)msg);
            if (retMsg == 0) break;
            kdtEntry.getEditManager().editCellAt(selectRow, kdtEntry.getColumnIndex(LOT));
            kdtEntry.getEditManager().getEditCell().setValue(null);
            return;
        }
        if (al3 != null) {
            for (int i = 0; i < al3.size(); ++i) {
                if (!al3.get(i).toString().equals(String.valueOf(selectRow))) continue;
                return;
            }
        }
        iRow = kdtEntry.getRow(selectRow);
        boolean isExistForServer = false;
        IInventory inventory = InventoryFactory.getRemoteInstance();
        InventoryCollection invColl = null;
        IPurReceivalEntry purReceivalBill = PurReceivalEntryFactory.getRemoteInstance();
        PurReceivalEntryCollection purReceiveColl = null;
        IPurInWarehsEntry purInWarehsBill = PurInWarehsEntryFactory.getRemoteInstance();
        PurInWarehsEntryCollection purInColl = null;
        IManufactureRecBillEntry manufactureRecBill = ManufactureRecBillEntryFactory.getRemoteInstance();
        ManufactureRecBillEntryCollection manufactureInColl = null;
        IMoveInWarehsBillEntry moveInWarehsBill = MoveInWarehsBillEntryFactory.getRemoteInstance();
        MoveInWarehsBillEntryCollection moveInColl = null;
        IOtherInWarehsBillEntry otherInWarehsBill = OtherInWarehsBillEntryFactory.getRemoteInstance();
        OtherInWarehsBillEntryCollection otherInColl = null;
        IInventoryInitEntry inventoryInit = InventoryInitEntryFactory.getRemoteInstance();
        InventoryInitEntryCollection invInitInColl = null;
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        EntityViewInfo entityViewInfoBill = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        FilterInfo filterInfoBill = new FilterInfo();
        entityViewInfo.setFilter(filterInfo);
        entityViewInfoBill.setFilter(filterInfoBill);
        boolean isHaveAsstAttr = false;
        boolean isHaveLocation = false;
        materialInfo = null;
        asstAttrValueInfo = null;
        warehouseInfo = null;
        locationInfo = null;
        strAsstAttrValue = null;
        strLocation = null;
        try {
            if (iRow.getCell(materialColName).getValue() != null && iRow.getCell(LOT).getValue() != null && iRow.getCell(WAREHOUSE).getValue() != null) {
                materialInfo = (MaterialInfo)iRow.getCell(materialColName).getValue();
                warehouseInfo = (WarehouseInfo)iRow.getCell(WAREHOUSE).getValue();
                isHaveLocation = warehouseInfo.isHasLocation();
                isHaveAsstAttr = materialInfo.getAssistAttr() != null;
                filterInfo.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)sou.getId().toString(), CompareType.EQUALS));
                filterInfo.getFilterItems().add(new FilterItemInfo("material.id", (Object)materialInfo.getId().toString(), CompareType.EQUALS));
                filterInfo.getFilterItems().add(new FilterItemInfo(LOT, (Object)iRow.getCell(LOT).getValue().toString(), CompareType.EQUALS));
                filterInfo.getFilterItems().add(new FilterItemInfo("warehouse.id", (Object)warehouseInfo.getId().toString(), CompareType.EQUALS));
                filterInfo.getFilterItems().add(new FilterItemInfo("baseQty", (Object)new BigDecimal("0"), CompareType.GREATER));
                filterInfoBill.getFilterItems().add(new FilterItemInfo("parent.storageOrgUnit.id", (Object)sou.getId().toString(), CompareType.EQUALS));
                filterInfoBill.getFilterItems().add(new FilterItemInfo("material.id", (Object)materialInfo.getId().toString(), CompareType.EQUALS));
                filterInfoBill.getFilterItems().add(new FilterItemInfo(LOT, (Object)iRow.getCell(LOT).getValue().toString(), CompareType.EQUALS));
                filterInfoBill.getFilterItems().add(new FilterItemInfo("warehouse.id", (Object)warehouseInfo.getId().toString(), CompareType.EQUALS));
                if (isHaveAsstAttr) {
                    asstAttrValueInfo = (AsstAttrValueInfo)iRow.getCell(assistArrColName).getValue();
                    if (asstAttrValueInfo != null) {
                        strAsstAttrValue = asstAttrValueInfo.getId().toString();
                        filterInfo.getFilterItems().add(new FilterItemInfo("assistProperty.id", (Object)strAsstAttrValue, CompareType.EQUALS));
                        filterInfoBill.getFilterItems().add(new FilterItemInfo("assistProperty.id", (Object)strAsstAttrValue, CompareType.EQUALS));
                    } else {
                        return;
                    }
                }
                if (isHaveLocation && !billType.getNumber().equals("101")) {
                    locationInfo = (LocationInfo)iRow.getCell(LOCATION).getValue();
                    if (locationInfo != null) {
                        strLocation = locationInfo.getId().toString();
                        filterInfo.getFilterItems().add(new FilterItemInfo("location.id", (Object)strLocation, CompareType.EQUALS));
                        filterInfoBill.getFilterItems().add(new FilterItemInfo("location.id", (Object)strLocation, CompareType.EQUALS));
                    } else {
                        return;
                    }
                }
                if (FID != null) {
                    filterInfoBill.getFilterItems().add(new FilterItemInfo("parent.id", (Object)FID, CompareType.NOTEQUALS));
                }
                entityViewInfo.getSelector().add(LOT);
                entityViewInfoBill.getSelector().add(LOT);
                invColl = inventory.getInventoryCollection(entityViewInfo);
                if (billType.getNumber().equals("101")) {
                    purReceiveColl = purReceivalBill.getPurReceivalEntryCollection(entityViewInfoBill);
                    if (purReceiveColl.size() > 0) {
                        isExistForServer = true;
                    }
                } else if (billType.getNumber().equals("103")) {
                    purInColl = purInWarehsBill.getPurInWarehsEntryCollection(entityViewInfoBill);
                    if (purInColl.size() > 0) {
                        isExistForServer = true;
                    }
                } else if (billType.getNumber().equals("105")) {
                    manufactureInColl = manufactureRecBill.getManufactureRecBillEntryCollection(entityViewInfoBill);
                    if (manufactureInColl.size() > 0) {
                        isExistForServer = true;
                    }
                } else if (billType.getNumber().equals("107")) {
                    moveInColl = moveInWarehsBill.getMoveInWarehsBillEntryCollection(entityViewInfoBill);
                    if (moveInColl.size() > 0) {
                        isExistForServer = true;
                    }
                } else if (billType.getNumber().equals("109")) {
                    otherInColl = otherInWarehsBill.getOtherInWarehsBillEntryCollection(entityViewInfoBill);
                    if (otherInColl.size() > 0) {
                        isExistForServer = true;
                    }
                } else if (billType.getNumber().equals("100") && (invInitInColl = inventoryInit.getInventoryInitEntryCollection(entityViewInfoBill)).size() > 0) {
                    isExistForServer = true;
                }
                if (invColl.size() > 0 || isExistForServer) {
                    noRow = InvClientUtils.getResource("No");
                    duplicateLots = InvClientUtils.getResource("DUPLICATELOTSALL");
                    msg = noRow + (selectRow + 1) + duplicateLots;
                    retMsg = MsgBox.showConfirm2((String)msg);
                    if (retMsg != 0) {
                        kdtEntry.getEditManager().editCellAt(selectRow, kdtEntry.getColumnIndex(LOT));
                        kdtEntry.getEditManager().getEditCell().setValue(null);
                        return;
                    }
                }
            }
        }
        catch (BOSException e) {
            throw new BOSException((Throwable)e);
        }
    }

    public static void setExpAndMfgEnabledWhenLoad(StockTransferBillInfo stockTransferBillInfo, KDTable kdtEntry) {
        if (stockTransferBillInfo == null) {
            return;
        }
        if (stockTransferBillInfo.get("entry") == null) {
            return;
        }
        IObjectCollection iObjectCollection = (IObjectCollection)stockTransferBillInfo.get("entry");
        StockTransferBillEntryInfo stockTransferBillEntryInfo = null;
        IRow curRow = null;
        for (int i = 0; i < iObjectCollection.size(); ++i) {
            stockTransferBillEntryInfo = (StockTransferBillEntryInfo)iObjectCollection.getObject(0);
            if (stockTransferBillInfo.getIssueStorageOrgUnit() == null || stockTransferBillEntryInfo.getMaterial() == null) {
                return;
            }
            curRow = kdtEntry.getRow(i);
            if (curRow == null) {
                return;
            }
            if (stockTransferBillEntryInfo == null || stockTransferBillInfo.getIssueStorageOrgUnit() == null || stockTransferBillEntryInfo.getMaterial() == null || stockTransferBillEntryInfo.getLot() == null || curRow.getCell(kdtEntry.getColumnIndex(EXP)).getStyleAttributes().isLocked()) continue;
            curRow.getCell(kdtEntry.getColumnIndex(MFG)).getStyleAttributes().setLocked(true);
            curRow.getCell(kdtEntry.getColumnIndex(EXP)).getStyleAttributes().setLocked(true);
            EntityViewInfo evi = new EntityViewInfo();
            FilterInfo fi = new FilterInfo();
            fi.getFilterItems().add(new FilterItemInfo("storageOrgUnit", (Object)stockTransferBillInfo.getIssueStorageOrgUnit().getId().toString(), CompareType.EQUALS));
            fi.getFilterItems().add(new FilterItemInfo("material", (Object)stockTransferBillEntryInfo.getMaterial().getId().toString(), CompareType.EQUALS));
            fi.getFilterItems().add(new FilterItemInfo(LOT, (Object)stockTransferBillEntryInfo.getLot(), CompareType.EQUALS));
            evi.setFilter(fi);
            try {
                IDateOfMinDurability ido = DateOfMinDurabilityFactory.getRemoteInstance();
                DateOfMinDurabilityCollection doc = ido.getDateOfMinDurabilityCollection(evi);
                if (doc != null && doc.size() > 0) continue;
                curRow.getCell(kdtEntry.getColumnIndex(MFG)).getStyleAttributes().setLocked(false);
                curRow.getCell(kdtEntry.getColumnIndex(EXP)).getStyleAttributes().setLocked(false);
                continue;
            }
            catch (BOSException e) {
                ExceptionHandler.handle((Throwable)e);
            }
        }
    }

    public static void setLotInfo(KDTable kdtEntry, int rowIndex, StorageOrgUnitInfo sou, MaterialInfo materialInfo, String lot, StockTransferBillInfo editData) {
        boolean isPeriodVaild;
        if (sou == null || materialInfo == null) {
            return;
        }
        IRow curRow = kdtEntry.getRow(rowIndex);
        boolean bl = isPeriodVaild = curRow.getCell(kdtEntry.getColumnIndex(PERIODVALIDUNIT)).getValue() != null;
        if (!isPeriodVaild) {
            return;
        }
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("storageOrgUnit", (Object)sou.getId().toString(), CompareType.EQUALS));
        fi.getFilterItems().add(new FilterItemInfo("material", (Object)materialInfo.getId().toString(), CompareType.EQUALS));
        fi.getFilterItems().add(new FilterItemInfo(LOT, (Object)lot, CompareType.EQUALS));
        evi.setFilter(fi);
        try {
            IDateOfMinDurability ido = DateOfMinDurabilityFactory.getRemoteInstance();
            DateOfMinDurabilityCollection doc = ido.getDateOfMinDurabilityCollection(evi);
            if (doc != null && doc.size() > 0) {
                DateOfMinDurabilityInfo dod = doc.get(0);
                curRow.getCell(kdtEntry.getColumnIndex(MFG)).setValue((Object)dod.getMfg());
                curRow.getCell(kdtEntry.getColumnIndex(EXP)).setValue((Object)dod.getExp());
                curRow.getCell(kdtEntry.getColumnIndex(MFG)).getStyleAttributes().setLocked(true);
                curRow.getCell(kdtEntry.getColumnIndex(EXP)).getStyleAttributes().setLocked(true);
            } else {
                curRow.getCell(kdtEntry.getColumnIndex(MFG)).setValue(null);
                curRow.getCell(kdtEntry.getColumnIndex(EXP)).setValue(null);
                curRow.getCell(kdtEntry.getColumnIndex(MFG)).getStyleAttributes().setLocked(true);
                curRow.getCell(kdtEntry.getColumnIndex(EXP)).getStyleAttributes().setLocked(true);
            }
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
        }
    }

    public static void setLotInfo(KDTable kdtEntry, int rowIndex, StorageOrgUnitInfo sou, MaterialInfo materialInfo, String lot, TransferOrderBillInfo editData) {
        boolean isPeriodVaild;
        if (sou == null || materialInfo == null) {
            return;
        }
        IRow curRow = kdtEntry.getRow(rowIndex);
        boolean bl = isPeriodVaild = curRow.getCell(kdtEntry.getColumnIndex(PERIODVALIDUNIT)).getValue() != null;
        if (!isPeriodVaild) {
            return;
        }
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("storageOrgUnit", (Object)sou.getId().toString(), CompareType.EQUALS));
        fi.getFilterItems().add(new FilterItemInfo("material", (Object)materialInfo.getId().toString(), CompareType.EQUALS));
        fi.getFilterItems().add(new FilterItemInfo(LOT, (Object)lot, CompareType.EQUALS));
        evi.setFilter(fi);
        try {
            IDateOfMinDurability ido = DateOfMinDurabilityFactory.getRemoteInstance();
            DateOfMinDurabilityCollection doc = ido.getDateOfMinDurabilityCollection(evi);
            if (doc != null && doc.size() > 0) {
                DateOfMinDurabilityInfo dod = doc.get(0);
                curRow.getCell(kdtEntry.getColumnIndex(MFG)).setValue((Object)dod.getMfg());
                curRow.getCell(kdtEntry.getColumnIndex(EXP)).setValue((Object)dod.getExp());
            }
            SCMClientUtils.lockCells((IRow)curRow, (String[])new String[]{EXP, MFG}, (boolean)true);
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
        }
    }

    public static void setLotInfo(KDTable kdtEntry, int rowIndex, StorageOrgUnitInfo sou, MaterialInfo materialInfo, String lot, TransferOrderBillInfo editData, SCMFetchData fetchData) {
        if (sou == null || materialInfo == null) {
            return;
        }
        IRow curRow = kdtEntry.getRow(rowIndex);
        try {
            boolean isPeriodVaild = curRow.getCell(PERIODVALIDUNIT).getValue() != null;
            AbstractDateOfMinDurabilityInfo dod = null;
            if (isPeriodVaild) {
                dod = fetchData.getDurability(materialInfo.getId().toString(), sou.getId().toString(), lot);
            }
            if (dod != null) {
                curRow.getCell(PERIODVALIDUNIT).setValue((Object)dod.getPeriodValidUnit());
                boolean bl = isPeriodVaild = curRow.getCell(PERIODVALIDUNIT).getValue() != null;
            }
            if (!isPeriodVaild) {
                return;
            }
            if (dod != null) {
                curRow.getCell(MFG).setValue((Object)dod.getMfg());
                curRow.getCell(EXP).setValue((Object)dod.getExp());
            } else {
                SCMClientUtils.clearCells((IRow)curRow, (String[])new String[]{MFG, EXP});
            }
            SCMClientUtils.lockCells((IRow)curRow, (String[])new String[]{EXP, MFG}, (boolean)true);
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
    }

    public static void setLotInfo(KDTable kdtEntry, int rowIndex, StorageOrgUnitInfo sou, MaterialInfo materialInfo, String lot, StockTransferBillInfo editData, SCMFetchData fetchData) {
        if (sou == null || materialInfo == null) {
            return;
        }
        IRow curRow = kdtEntry.getRow(rowIndex);
        try {
            boolean isPeriodVaild = curRow.getCell(PERIODVALIDUNIT).getValue() != null;
            DateOfMinDurabilityInfo dod = fetchData.getDurability(materialInfo.getId().toString(), sou.getId().toString(), lot);
            if (dod != null && !isPeriodVaild) {
                curRow.getCell(PERIODVALIDUNIT).setValue((Object)dod.getPeriodValidUnit());
                boolean bl = isPeriodVaild = curRow.getCell(PERIODVALIDUNIT).getValue() != null;
            }
            if (!isPeriodVaild) {
                return;
            }
            if (dod != null) {
                curRow.getCell(MFG).setValue((Object)dod.getMfg());
                curRow.getCell(EXP).setValue((Object)dod.getExp());
            } else {
                SCMClientUtils.clearCells((IRow)curRow, (String[])new String[]{MFG, EXP});
            }
            SCMClientUtils.lockCells((IRow)curRow, (String[])new String[]{EXP, MFG}, (boolean)true);
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
    }

    public static boolean isOffSetable(InvBillBaseInfo invBillBaseInfo) throws BOSException, EASBizException {
        InvBillBaseEntryInfo aInvBillBaseEntryInfo;
        CompanyOrgUnitInfo companyOrgUnitInfo;
        IObjectCollection iObjectCollection;
        boolean isOffSet = false;
        if (invBillBaseInfo != null && (iObjectCollection = (IObjectCollection)invBillBaseInfo.get("entry")) != null && iObjectCollection.size() > 0 && (companyOrgUnitInfo = (aInvBillBaseEntryInfo = (InvBillBaseEntryInfo)iObjectCollection.getObject(0)).getCompanyOrgUnit()) != null) {
            PeriodInfo currentPeriodInfo = SystemStatusCtrolUtils.getCurrentPeriod(null, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)companyOrgUnitInfo);
            if (currentPeriodInfo == null) {
                throw new SCMBillException(SCMBillException.CURRENTPERIODISNULL);
            }
            isOffSet = true;
        }
        return isOffSet;
    }

    public static boolean checkForOffSet(InvBillBaseInfo invBillBaseInfo) throws BOSException, EASBizException {
        boolean isOffSet = false;
        if (invBillBaseInfo != null && invBillBaseInfo.isIsReversed()) {
            InvBillBaseEntryInfo aInvBillBaseEntryInfo;
            CompanyOrgUnitInfo companyOrgUnitInfo;
            IObjectCollection iObjectCollection = (IObjectCollection)invBillBaseInfo.get("entry");
            if (iObjectCollection != null && iObjectCollection.size() > 0 && (companyOrgUnitInfo = (aInvBillBaseEntryInfo = (InvBillBaseEntryInfo)iObjectCollection.getObject(0)).getCompanyOrgUnit()) != null) {
                PeriodInfo currentPeriodInfo = SystemStatusCtrolUtils.getCurrentPeriod(null, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)companyOrgUnitInfo);
                if (currentPeriodInfo == null) {
                    throw new SCMBillException(SCMBillException.CURRENTPERIODISNULL);
                }
                TransactionTypeInfo transactionType = invBillBaseInfo.getTransactionType();
                if (transactionType == null) {
                    MsgBox.showInfo((String)InvClientUtils.getResource("TransactionTypeNotNull"));
                    SysUtil.abort();
                }
                InvUpdateTypeInfo invUpdateTypeInfo = null;
                try {
                    invUpdateTypeInfo = TransactionTypeFactory.getRemoteInstance().getDefaultInvUpdateType(transactionType.getId().toString());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (!invUpdateTypeInfo.isIsNotUpdateInv()) {
                    if (!invBillBaseInfo.isIsInitBill() && invBillBaseInfo.getBizDate().before(currentPeriodInfo.getBeginDate())) {
                        MsgBox.showInfo((String)InvClientUtils.getResource("OFFDATEBEFORECURRENTPERIOD"));
                        SysUtil.abort();
                    } else {
                        isOffSet = true;
                    }
                } else {
                    isOffSet = true;
                }
            }
        } else {
            isOffSet = true;
        }
        return isOffSet;
    }

    public static boolean isOnlySaleBackWriteNS(String companyInfoID) throws EASBizException, BOSException {
        ObjectUuidPK pk;
        boolean isAutoAudit = false;
        IParamControl ipc = ParamControlFactory.getRemoteInstance();
        String strAutoAudit = ipc.getParamValue((IObjectPK)(pk = new ObjectUuidPK(companyInfoID)), "INM002");
        if (strAutoAudit != null && strAutoAudit.trim().length() != 0 && strAutoAudit.trim().equalsIgnoreCase("true")) {
            isAutoAudit = true;
        }
        return isAutoAudit;
    }

    public static boolean isOnlyOutNSCanBack(String companyInfoID) throws EASBizException, BOSException {
        ObjectUuidPK pk;
        boolean isAutoAudit = false;
        IParamControl ipc = ParamControlFactory.getRemoteInstance();
        String strAutoAudit = ipc.getParamValue((IObjectPK)(pk = new ObjectUuidPK(companyInfoID)), "INM003");
        if (strAutoAudit != null && strAutoAudit.trim().length() != 0 && strAutoAudit.trim().equalsIgnoreCase("true")) {
            isAutoAudit = true;
        }
        return isAutoAudit;
    }

    public static boolean isAlertForLotDuplicate(String companyInfoID) throws EASBizException, BOSException {
        boolean isAutoAudit = false;
        String strAutoAudit = "";
        if (alterForLotParamMap.containsKey(companyInfoID)) {
            strAutoAudit = alterForLotParamMap.get(companyInfoID);
        } else {
            IParamControl ipc = ParamControlFactory.getRemoteInstance();
            ObjectUuidPK pk = new ObjectUuidPK(companyInfoID);
            strAutoAudit = ipc.getParamValue((IObjectPK)pk, "INM120");
            alterForLotParamMap.put(companyInfoID, strAutoAudit);
        }
        if (strAutoAudit != null && strAutoAudit.trim().length() != 0 && strAutoAudit.trim().equalsIgnoreCase("true")) {
            isAutoAudit = true;
        }
        return isAutoAudit;
    }

    public static void setTableValesByLastLine(KDTable kDTable, int rowIndex, String[] colunmsNames) {
        if (rowIndex == 0) {
            return;
        }
        for (String columnName : colunmsNames) {
            if (kDTable.getRow(rowIndex - 1).getCell(columnName) == null) continue;
            kDTable.getRow(rowIndex).getCell(columnName).setValue(kDTable.getRow(rowIndex - 1).getCell(columnName).getValue());
        }
    }

    public static String getLotNumber(MaterialInventoryInfo materialInv) throws EASBizException, BOSException {
        if (materialInv == null || materialInv.getMaterial() == null || materialInv.getOrgUnit() == null) {
            return null;
        }
        String materialID = materialInv.getMaterial().getId().toString();
        String storageOrgID = materialInv.getOrgUnit().getId().toString();
        String lotNumber = DateOfMinDurabilityFactory.getRemoteInstance().getLot(materialID, storageOrgID, materialInv.getIssuePriorityMode());
        return lotNumber;
    }

    public static String getLotNumb(MaterialInventoryInfo materialInv, String assistPropertyID) throws EASBizException, BOSException {
        if (materialInv == null || materialInv.getMaterial() == null || materialInv.getOrgUnit() == null) {
            return null;
        }
        String materialID = materialInv.getMaterial().getId().toString();
        String storageOrgID = materialInv.getOrgUnit().getId().toString();
        String lotNumber = DateOfMinDurabilityFactory.getRemoteInstance().getLot(materialID, storageOrgID, materialInv.getIssuePriorityMode(), assistPropertyID);
        return lotNumber;
    }

    public static BigDecimal getStockPrice(MaterialInfo material, AsstAttrValueInfo asst, MeasureUnitInfo unit, CompanyOrgUnitInfo inCompany, CurrencyInfo currency, BigDecimal qty, StorageOrgUnitInfo sou, CustomerInfo innerCustomer) throws BaseException {
        Map priceInfoMap;
        PriceSolve priceSolve;
        BigDecimal price;
        CustomerInfo customer = innerCustomer;
        if (customer == null && inCompany != null) {
            customer = CustomerFactory.getRemoteInstance().getCustomerCollectionByInter(inCompany.getId().toString()).get(0);
        }
        PriceCondition priceCondition = new PriceCondition();
        priceCondition.setMaterialInfo(material);
        priceCondition.setCustomerInfo(customer);
        priceCondition.setOrderQty(qty);
        priceCondition.setCurrencyInfo(currency);
        priceCondition.setAssiProperty(asst);
        priceCondition.setCompanyOrg(inCompany);
        StorageOrgUnitInfo mainBizOrg = sou;
        if (mainBizOrg != null) {
            priceCondition.setCu(mainBizOrg.getCU());
        }
        if ((price = (priceSolve = new PriceSolve()).visitPrice(priceInfoMap = priceSolve.getPriceInfoByInnerPriceType(priceCondition))) == null) {
            price = ZERO;
        }
        if (unit != null) {
            BigDecimal coefficient = InvClientUtils.getMulUnit(unit, material).getBaseConvsRate();
            price = price.multiply(coefficient);
        }
        price = price.setScale(material.getPricePrecision(), 4);
        return price;
    }

    public static void commonVerify(CoreBillEditUI ui) {
    }

    public static void commonVerify(ArrayList compList) {
        if (compList == null || compList.size() == 0) {
            return;
        }
        for (JComponent comp : compList) {
            InvClientUtils.verifySingle(comp);
        }
    }

    public static void verifySingle(JComponent comp) {
        block9: {
            block8: {
                KDPromptBox prmt;
                JComponent compInContainer;
                KDLabelContainer container;
                block10: {
                    if (comp == null) {
                        return;
                    }
                    if (!(comp instanceof KDLabelContainer)) break block8;
                    container = (KDLabelContainer)comp;
                    compInContainer = (JComponent)container.getComponent(2);
                    if (compInContainer == null) break block9;
                    if (!(compInContainer instanceof JTextField) || !compInContainer.getBackground().equals(SCMClientUtils.necessaryColor)) break block10;
                    JTextField textField = (JTextField)compInContainer;
                    if (textField.getText() == null || textField.getText().trim().length() == 0) {
                        MsgBox.showInfo((String)container.getBoundLabelText());
                        textField.requestFocus();
                        SysUtil.abort();
                    }
                    break block9;
                }
                if (!(compInContainer instanceof KDPromptBox) || !compInContainer.getBackground().equals(SCMClientUtils.necessaryColor) || (prmt = (KDPromptBox)compInContainer).getValue() != null) break block9;
                MsgBox.showInfo((String)container.getBoundLabelText());
                prmt.requestFocus();
                SysUtil.abort();
                break block9;
            }
            if (comp instanceof KDComboBox && comp.getBackground().equals(SCMClientUtils.necessaryColor)) {
                KDComboBox cbx = (KDComboBox)comp;
                if (cbx.getBackground().equals(SCMClientUtils.necessaryColor) && cbx.getSelectedItem() == null) {
                    MsgBox.showInfo((String)cbx.getBoundLabelText());
                    SysUtil.abort();
                }
            } else if (comp instanceof KDTable) {
                KDTable table = (KDTable)comp;
                int rowCount = table.getRowCount();
                int colCount = table.getColumnCount();
                for (int i = 0; i < rowCount; ++i) {
                    for (int j = 0; j < colCount; ++j) {
                        ICell cell = table.getCell(i, j);
                        if (!cell.getStyleAttributes().getBackground().equals(SCMClientUtils.necessaryColor) || cell.getValue() != null) continue;
                        String colName = table.getHead().getRow(0).getCell(j).getValue().toString();
                        MsgBox.showInfo((String)colName);
                        SysUtil.abort();
                    }
                }
            }
        }
    }

    public static EntityViewInfo getOrgEntityViewInfo(FullOrgUnitCollection collcetion) throws BOSException, EASBizException {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        BOSUuid[] orgIds = new BOSUuid[collcetion.size()];
        int size = collcetion.size();
        for (int i = 0; i < size; ++i) {
            orgIds[i] = collcetion.get(i).getId();
        }
        CompanyOrgUnitInfo[] couInfos = InvClientUtils.getCompanyInfos2(orgIds);
        HashSet<String> set = new HashSet<String>(couInfos.length);
        for (int i = 0; i < couInfos.length; ++i) {
            if (couInfos[i] == null) continue;
            set.add(couInfos[i].getId().toString());
        }
        if (set.size() > 0) {
            fi.getFilterItems().add(new FilterItemInfo("id", set, CompareType.INCLUDE));
        } else {
            fi.getFilterItems().add(new FilterItemInfo("id", (Object)"NOTEXISTID", CompareType.INCLUDE));
        }
        evi.setFilter(fi);
        return evi;
    }

    public static EntityViewInfo getOrgEntityViewInfo(OrgUnitCollection collcetion) throws BOSException, EASBizException {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        StorageOrgUnitInfo sou = new StorageOrgUnitInfo();
        CompanyOrgUnitInfo cou = null;
        StringBuffer stringBuffer = new StringBuffer();
        String companyOrgUnitIDs = null;
        for (int i = 0; i < collcetion.size(); ++i) {
            sou.setId(collcetion.get(i).getId());
            cou = InvClientUtils.getCompanyInfo(sou);
            if (cou == null || cou.getId() == null) continue;
            stringBuffer.append(cou.getId().toString());
            stringBuffer.append(",");
        }
        companyOrgUnitIDs = stringBuffer.toString();
        if (companyOrgUnitIDs.length() > 0) {
            companyOrgUnitIDs = companyOrgUnitIDs.substring(0, companyOrgUnitIDs.length() - 1);
            fi.getFilterItems().add(new FilterItemInfo("id", (Object)companyOrgUnitIDs, CompareType.INCLUDE));
        } else {
            fi.getFilterItems().add(new FilterItemInfo("id", (Object)"NOTEXISTID", CompareType.INCLUDE));
        }
        evi.setFilter(fi);
        return evi;
    }

    public static EntityViewInfo getEntityViewForF7StoreTypeForBill() {
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        HashSet<String> set = new HashSet<String>();
        set.add("E");
        set.add("G");
        set.add("C");
        set.add("S");
        filter.getFilterItems().add(new FilterItemInfo("number", set, CompareType.INCLUDE));
        ev.setFilter(filter);
        return ev;
    }

    public static boolean isReturnRIType(TransactionTypeInfo transType) {
        if (transType == null || transType.getRiType() == null || transType.getRiType().getBizDirection() == null) {
            return false;
        }
        int bizDirection = transType.getRiType().getBizDirection().getValue();
        return bizDirection == -1;
    }

    public static boolean isUpdateInvByBaseUnit(String orgID) {
        try {
            IParamControl ipc = ParamControlFactory.getRemoteInstance();
            ObjectUuidPK pk = new ObjectUuidPK(orgID);
            String val = ipc.getParamValue((IObjectPK)pk, "INM004");
            if (val != null && val.equalsIgnoreCase("true")) {
                return true;
            }
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
        return false;
    }

    public static EntityViewInfo getBizTypeEntityViewInfo(boolean isTransferOrderBill) {
        FilterInfo fi;
        EntityViewInfo evi;
        HashSet<String> setBizType = new HashSet<String>();
        setBizType.add("d8e80652-0117-1000-e000-04c5c0a812202407435C");
        setBizType.add("LyS5ouN3YEPgQAB/AQBJsCQHQ1w=");
        setBizType.add("LyS5ouN4YEPgQAB/AQBJsCQHQ1w=");
        setBizType.add("ltQJK8kihHPgQKjAYj1jAyQHQ1w=");
        setBizType.add("ltQJdddQMebgQKjAYj1j1yQHQ1w=");
        setBizType.add("ltQJ0s1RqWzgQKjAYj1j3CQHQ1w=");
        if (isTransferOrderBill) {
            evi = InvClientUtils.getBizTypeFromBill("141");
            fi = evi.getFilter();
            fi.getFilterItems().add(new FilterItemInfo("id", setBizType, CompareType.INCLUDE));
        } else {
            evi = InvClientUtils.getBizTypeFromBill("140");
            fi = evi.getFilter();
            fi.getFilterItems().add(new FilterItemInfo("id", setBizType, CompareType.NOTINCLUDE));
        }
        evi.setFilter(fi);
        return evi;
    }

    public static String getInStringFromList(List list) {
        if (list == null || list.size() == 0) {
            return null;
        }
        StringBuffer in = new StringBuffer();
        in.append(" (");
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            in.append("'").append(iter.next().toString()).append("'");
            if (!iter.hasNext()) continue;
            in.append(",");
        }
        in.append(") ");
        return in.toString();
    }

    public static void setCellValueNullWithFixInvCol(KDTable kdtEntry, String[] colNames, int rowIndex, boolean isAllCols, String[] unClearCols) {
        int cols;
        int startColIndex;
        Vector<Integer> vector = null;
        if (isAllCols) {
            vector = new Vector<Integer>();
            vector.add(new Integer(kdtEntry.getColumnIndex("Id")));
            vector.add(new Integer(kdtEntry.getColumnIndex("id")));
            vector.add(new Integer(kdtEntry.getColumnIndex("storeType")));
            vector.add(new Integer(kdtEntry.getColumnIndex("storeStatus")));
            for (int i = 0; i < unClearCols.length; ++i) {
                vector.add(new Integer(kdtEntry.getColumnIndex(unClearCols[i])));
            }
        }
        if (isAllCols && colNames == null) {
            startColIndex = 1;
            cols = kdtEntry.getColumnCount();
        } else {
            startColIndex = 0;
            cols = colNames.length;
        }
        IRow curRow = kdtEntry.getRow(rowIndex);
        for (int i = startColIndex; i < cols; ++i) {
            int curCol;
            if (isAllCols) {
                if (vector.contains(new Integer(i))) continue;
                curCol = i;
            } else {
                curCol = kdtEntry.getColumnIndex(colNames[i]);
            }
            ICellEditor cellEditor = kdtEntry.getColumn(curCol).getEditor();
            if (cellEditor != null && cellEditor.getComponent() instanceof KDFormattedTextField) {
                KDFormattedTextField ktf = (KDFormattedTextField)cellEditor.getComponent();
                if (ktf.getDataType() != 1) continue;
                curRow.getCell(curCol).setValue((Object)ZERO);
                continue;
            }
            if (curRow.getCell(curCol).getValue() instanceof Boolean) {
                curRow.getCell(curCol).setValue((Object)new Boolean(false));
                continue;
            }
            curRow.getCell(curCol).setValue(null);
        }
    }

    public static HashSet getCostCenterOrgUnitSet(String souid) throws BOSException, EASBizException {
        IOrgUnitRelation iOrgUnitRel = OrgUnitRelationFactory.getRemoteInstance();
        HashSet<String> set = new HashSet<String>();
        OrgUnitCollection orgIds = iOrgUnitRel.getFromUnit(souid, 1, 5);
        for (int i = 0; orgIds != null && i < orgIds.size(); ++i) {
            set.add(orgIds.get(i).getId().toString());
        }
        return set;
    }

    public static HashSet getCostCenterOrgUnitSet(int oryType, String souid) throws BOSException, EASBizException {
        IOrgUnitRelation iOrgUnitRel = OrgUnitRelationFactory.getRemoteInstance();
        HashSet<String> set = new HashSet<String>();
        OrgUnitCollection orgIds = iOrgUnitRel.getFromUnit(souid, 1, 5);
        for (int i = 0; orgIds != null && i < orgIds.size(); ++i) {
            set.add(orgIds.get(i).getId().toString());
        }
        return set;
    }

    public static HashSet getCostCenterOrgUnitSet2(int oryType, String souid) throws BOSException, EASBizException {
        IOrgUnitRelation iOrgUnitRel = OrgUnitRelationFactory.getRemoteInstance();
        HashSet<String> set = new HashSet<String>();
        OrgUnitCollection orgIds = iOrgUnitRel.getFromUnit(souid, oryType, 5);
        for (int i = 0; orgIds != null && i < orgIds.size(); ++i) {
            set.add(orgIds.get(i).getId().toString());
        }
        return set;
    }

    public static boolean isDynCalculateQty(String storageOrgUnitID) throws BOSException, EASBizException {
        ObjectUuidPK pk;
        boolean isDynCalculateQty = false;
        IParamControl ipc = ParamControlFactory.getRemoteInstance();
        String strDynCalculateQty = ipc.getParamValue((IObjectPK)(pk = new ObjectUuidPK(storageOrgUnitID)), "INM130");
        if (strDynCalculateQty != null && strDynCalculateQty.trim().length() != 0 && strDynCalculateQty.trim().equalsIgnoreCase("true")) {
            isDynCalculateQty = true;
        }
        return isDynCalculateQty;
    }

    public static boolean isSaleIssueBillSplitChangeDate(String billType, String companyInfoID) throws BOSException, EASBizException {
        boolean isChangeDate = false;
        IParamControl ipc = ParamControlFactory.getRemoteInstance();
        ObjectUuidPK pk = new ObjectUuidPK(companyInfoID);
        String per = "INM100";
        if ("50957179-0105-1000-e000-015bc0a812fd463ED552".equals(billType)) {
            per = "INM100";
        } else if ("50957179-0105-1000-e000-015fc0a812fd463ED552".equals(billType)) {
            per = "INM101";
        }
        String strChangeDate = ipc.getParamValue((IObjectPK)pk, per);
        if (strChangeDate != null && strChangeDate.trim().length() != 0 && strChangeDate.trim().equalsIgnoreCase("true")) {
            isChangeDate = true;
        }
        return isChangeDate;
    }

    public static boolean isInWarehsBillSplitChangeDate(String companyInfoID) throws BOSException, EASBizException {
        ObjectUuidPK pk;
        boolean isChangeDate = false;
        IParamControl ipc = ParamControlFactory.getRemoteInstance();
        String strChangeDate = ipc.getParamValue((IObjectPK)(pk = new ObjectUuidPK(companyInfoID)), "INM101");
        if (strChangeDate != null && strChangeDate.trim().length() != 0 && strChangeDate.trim().equalsIgnoreCase("true")) {
            isChangeDate = true;
        }
        return isChangeDate;
    }

    public static boolean isObjectArrEmpty(Object o) {
        if (o == null) {
            return true;
        }
        if (o instanceof Object[]) {
            Object[] objs = (Object[])o;
            boolean isEmpty = true;
            for (int i = 0; i < objs.length; ++i) {
                if (objs[i] == null) continue;
                isEmpty = false;
                break;
            }
            return isEmpty;
        }
        return false;
    }

    public static CompanyOrgUnitInfo[] getCompanyInfos2(Object[] souInfos) throws EASBizException, BOSException {
        BOSUuid[] souIds = new BOSUuid[souInfos.length];
        boolean isCouEmtpy = true;
        int length = souInfos.length;
        for (int i = 0; i < length && souInfos[i] != null; ++i) {
            if (souInfos[i] instanceof StorageOrgUnitInfo) {
                souIds[i] = ((StorageOrgUnitInfo)souInfos[i]).getId();
            } else {
                if (!(souInfos[i] instanceof FullOrgUnitInfo)) continue;
                souIds[i] = ((FullOrgUnitInfo)souInfos[i]).getId();
            }
            isCouEmtpy = false;
        }
        if (isCouEmtpy) {
            return null;
        }
        return InvClientUtils.getCompanyInfos2(souIds);
    }

    public static CompanyOrgUnitInfo[] getCompanyInfos2(BOSUuid[] souIds) throws EASBizException, BOSException {
        Map couMap = SCMBillCommonFacadeFactory.getRemoteInstance().getCompanyInfos(souIds);
        ArrayList<CompanyOrgUnitInfo> list = new ArrayList<CompanyOrgUnitInfo>();
        int length = souIds.length;
        for (int i = 0; i < length && souIds[i] != null; ++i) {
            if ((CompanyOrgUnitInfo)couMap.get(souIds[i].toString()) == null) continue;
            list.add((CompanyOrgUnitInfo)couMap.get(souIds[i].toString()));
        }
        CompanyOrgUnitInfo[] orgUnitInfo = new CompanyOrgUnitInfo[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            orgUnitInfo[i] = (CompanyOrgUnitInfo)list.get(i);
        }
        return orgUnitInfo;
    }

    public static boolean checkStorageConsignSameCompany(String[] ids) {
        if (ids != null) {
            int size = ids.length;
            BOSUuid[] bosIDs = new BOSUuid[size];
            for (int index = 0; index < size; ++index) {
                if (ids[index] == null) continue;
                bosIDs[index] = BOSUuid.read((String)ids[index]);
            }
            ISCMBillCommonFacade iScmBillCommon = null;
            try {
                iScmBillCommon = SCMBillCommonFacadeFactory.getRemoteInstance();
            }
            catch (BOSException e) {
                Logger.error((Throwable)e);
                return false;
            }
            Map map = null;
            try {
                map = iScmBillCommon.getCompanyInfos(bosIDs);
            }
            catch (EASBizException e) {
                Logger.error((Throwable)e);
                return false;
            }
            catch (BOSException e) {
                Logger.error((Throwable)e);
                return false;
            }
            if (map != null && map.size() == 1) {
                return true;
            }
            HashMap<String, String> compareMap = new HashMap<String, String>();
            if (map != null) {
                Set set = map.keySet();
                for (String id : set) {
                    CompanyOrgUnitInfo company;
                    if (map.get(id) == null || (company = (CompanyOrgUnitInfo)map.get(id)) == null || compareMap.containsValue(company.getId().toString())) continue;
                    compareMap.put(company.getId().toString(), company.getId().toString());
                }
                if (compareMap.size() == 1) {
                    return true;
                }
            }
            MsgBox.showInfo((String)InvClientUtils.getAddResource("NotSameCompanyCannotGenAVoucher"));
            return false;
        }
        return false;
    }

    public static void changeUnitQtyColProps(KDTable detailTable, int row, MaterialInfo materialInfo, MaterialInventoryInfo materialInventoryInfo, SCMFetchData fetchData, boolean isOnload, String[] fieldsUnit, String[][] fieldsQty, boolean isNegative) throws EASBizException, BOSException {
        MeasureUnitInfo mu = null;
        MeasureUnitInfo muBase = null;
        MeasureUnitInfo muAssist = null;
        IRow curRow = detailTable.getRow(row);
        int precision = 2;
        if (isOnload) {
            mu = (MeasureUnitInfo)curRow.getCell(detailTable.getColumnIndex(fieldsUnit[0])).getValue();
            muBase = (MeasureUnitInfo)curRow.getCell(detailTable.getColumnIndex(fieldsUnit[1])).getValue();
            muAssist = (MeasureUnitInfo)curRow.getCell(detailTable.getColumnIndex(fieldsUnit[2])).getValue();
        } else {
            mu = materialInventoryInfo != null && curRow.getCell(fieldsUnit[0]).getValue() == null ? materialInventoryInfo.getUnit() : (MeasureUnitInfo)curRow.getCell(detailTable.getColumnIndex(fieldsUnit[0])).getValue();
            muBase = materialInfo.getBaseUnit();
            muAssist = materialInfo.getAssistUnit();
        }
        if (mu != null) {
            precision = fetchData.getUnitPrecision(materialInfo.getId().toString(), mu.getId().toString());
        }
        SCMClientUtils.changeCellPrecision((IRow)curRow, (String[])fieldsQty[0], (int)precision, (boolean)isNegative);
        if (muBase != null) {
            precision = fetchData.getUnitPrecision(materialInfo.getId().toString(), muBase.getId().toString());
        }
        SCMClientUtils.changeCellPrecision((IRow)curRow, (String[])fieldsQty[1], (int)precision, (boolean)isNegative);
        if (muAssist != null) {
            Integer muAssistPrecisionInteger = fetchData.getUnitPrecision(materialInfo.getId().toString(), muAssist.getId().toString());
            precision = muAssistPrecisionInteger != null ? muAssistPrecisionInteger : 2;
        }
        SCMClientUtils.changeCellPrecision((IRow)curRow, (String[])fieldsQty[2], (int)precision, (boolean)isNegative);
    }

    public static void inverseRowQty(IRow row, String[] colNames, boolean isNegativeBill, boolean isZero) {
        if (isZero) {
            InvClientUtils.inverseRowQty(row, colNames, isNegativeBill);
        } else {
            int len = colNames.length;
            for (int i = 0; i < len; ++i) {
                if (row.getCell(colNames[i]) == null || row.getCell(colNames[i]).getValue() == null) continue;
                BigDecimal value = InvClientUtils.formatBigDecimal((BigDecimal)row.getCell(colNames[i]).getValue());
                row.getCell(colNames[i]).setValue((Object)(isNegativeBill ? value.abs().negate() : value.abs()));
            }
        }
    }

    public static void inverseRowQty(IRow row, String[] colNames, boolean isNegativeBill) {
        int size = colNames.length;
        for (int i = 0; i < size; ++i) {
            if (row.getCell(colNames[i]) == null) continue;
            BigDecimal value = InvClientUtils.formatBigDecimal((BigDecimal)row.getCell(colNames[i]).getValue());
            row.getCell(colNames[i]).setValue((Object)(isNegativeBill ? value.abs().negate() : value.abs()));
        }
    }

    public static BigDecimal formatBigDecimal(BigDecimal value) {
        return value == null ? ZERO : value;
    }

    public static boolean isSelfManufactureMaterial(MaterialInfo aMaterialInfo, CompanyOrgUnitInfo aCompanyOrgUnitInfo) throws Exception {
        boolean flag = false;
        if (aMaterialInfo == null || aMaterialInfo.getId() == null || aCompanyOrgUnitInfo == null || aCompanyOrgUnitInfo.getId() == null) {
            return flag;
        }
        IMaterial iMaterial = MaterialFactory.getRemoteInstance();
        MaterialCompanyInfoInfo aMaterialCompanyInfoInfo = iMaterial.getCompanyInfo(aMaterialInfo.getId().toString(), aCompanyOrgUnitInfo.getId().toString());
        if (aMaterialCompanyInfoInfo == null) {
            return flag;
        }
        if (aMaterialCompanyInfoInfo.getCalculateType() != null && CalculateTypeEnum.SELFMANUFACTURE.equals((Object)aMaterialCompanyInfoInfo.getCalculateType())) {
            return true;
        }
        return flag;
    }

    public static void setCostObjectFilter(CompanyOrgUnitInfo aCompanyOrgUnitInfo, KDTable kdtEntry, String collName) throws Exception {
        FilterItemInfo filterItemInfo;
        FilterInfo filterInfo;
        EntityViewInfo viewInfo;
        KDBizPromptBox bizcostObjectBox = new KDBizPromptBox();
        bizcostObjectBox.setEditFormat("$number$");
        bizcostObjectBox.setDisplayFormat("$number$");
        bizcostObjectBox.setCommitFormat("$number$");
        bizcostObjectBox.setEditable(true);
        bizcostObjectBox.setQueryInfo("com.kingdee.eas.basedata.assistant.app.F7CostObjectQuery");
        if (aCompanyOrgUnitInfo != null) {
            viewInfo = new EntityViewInfo();
            filterInfo = new FilterInfo();
            filterItemInfo = new FilterItemInfo("company.id", (Object)aCompanyOrgUnitInfo.getId().toString(), CompareType.EQUALS);
            filterInfo.getFilterItems().add(filterItemInfo);
            viewInfo.setFilter(filterInfo);
            bizcostObjectBox.setEntityViewInfo(viewInfo);
            CtrlUnitInfo cui = (CtrlUnitInfo)aCompanyOrgUnitInfo.getCU().clone();
            bizcostObjectBox.setCurrentCtrlUnit(cui);
        } else {
            viewInfo = new EntityViewInfo();
            filterInfo = new FilterInfo();
            filterItemInfo = new FilterItemInfo("company.id", (Object)"''", CompareType.EQUALS);
            filterInfo.getFilterItems().add(filterItemInfo);
            viewInfo.setFilter(filterInfo);
            bizcostObjectBox.setEntityViewInfo(viewInfo);
        }
        String companyId = null;
        if (aCompanyOrgUnitInfo != null && aCompanyOrgUnitInfo.getId() != null) {
            companyId = aCompanyOrgUnitInfo.getId().toString();
        }
        CostObjectF7UISelector arg0 = new CostObjectF7UISelector(null, bizcostObjectBox, Boolean.TRUE, Boolean.FALSE, Boolean.TRUE, companyId);
        bizcostObjectBox.setSelector((KDPromptSelector)arg0);
        kdtEntry.getColumn(collName).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)bizcostObjectBox));
        ObjectValueRender avr = new ObjectValueRender();
        avr.setFormat((IDataFormat)new BizDataFormat("$number$"));
        kdtEntry.getColumn(collName).setRenderer((IBasicRender)avr);
    }

    public static void setCostItemFilter(CompanyOrgUnitInfo aCompanyOrgUnitInfo, KDTable kdtEntry, String collName) throws Exception {
        KDBizPromptBox prmtCostItem = new KDBizPromptBox();
        prmtCostItem.setQueryInfo("com.kingdee.eas.basedata.assistant.app.CostItemTreeListQuery");
        prmtCostItem.setEditable(true);
        prmtCostItem.setDisplayFormat("$name$");
        prmtCostItem.setEditFormat("$number$");
        prmtCostItem.setCommitFormat("$number$");
        prmtCostItem.setRequired(true);
        kdtEntry.getColumn(collName).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)prmtCostItem));
        ObjectValueRender avr = new ObjectValueRender();
        avr.setFormat((IDataFormat)new BizDataFormat("$number$"));
        kdtEntry.getColumn(collName).setRenderer((IBasicRender)avr);
    }

    public static void setF7CostObjectSuiteFilter(CompanyOrgUnitInfo aCompanyOrgUnitInfo, KDTable kdtEntry, String collName) throws Exception {
        EntityViewInfo viewInfo;
        KDBizPromptBox bizcostObjectBox = new KDBizPromptBox();
        bizcostObjectBox.setEditFormat("$number$");
        bizcostObjectBox.setDisplayFormat("$number$");
        bizcostObjectBox.setCommitFormat("$number$");
        bizcostObjectBox.setEditable(true);
        bizcostObjectBox.setQueryInfo("com.kingdee.eas.basedata.assistant.F7CostObjectSuiteQuery");
        if (aCompanyOrgUnitInfo != null) {
            viewInfo = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            FilterItemInfo filterItemInfo = new FilterItemInfo("company.id", (Object)aCompanyOrgUnitInfo.getId().toString(), CompareType.EQUALS);
            filterInfo.getFilterItems().add(filterItemInfo);
            viewInfo.setFilter(filterInfo);
            bizcostObjectBox.setEntityViewInfo(viewInfo);
        } else {
            viewInfo = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            FilterItemInfo filterItemInfo = new FilterItemInfo("company.id", (Object)"''", CompareType.EQUALS);
            filterInfo.getFilterItems().add(filterItemInfo);
            viewInfo.setFilter(filterInfo);
            bizcostObjectBox.setEntityViewInfo(viewInfo);
        }
        kdtEntry.getColumn(collName).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)bizcostObjectBox));
        ObjectValueRender avr = new ObjectValueRender();
        avr.setFormat((IDataFormat)new BizDataFormat("$number$"));
        kdtEntry.getColumn(collName).setRenderer((IBasicRender)avr);
    }

    public static CostItemInfo getDefaultCostItem(CompanyOrgUnitInfo aCompanyOrgUnitInfo, MaterialInfo materialInfo) throws Exception {
        CostItemInfo costItemInfo = null;
        if (aCompanyOrgUnitInfo != null && materialInfo != null) {
            EntityViewInfo viewInfo = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            FilterItemInfo filterItemMaterialInfo = new FilterItemInfo("material", (Object)materialInfo.getId().toString(), CompareType.EQUALS);
            FilterItemInfo filterItemOrgInfo = new FilterItemInfo("orgUnit", (Object)aCompanyOrgUnitInfo.getId().toString(), CompareType.EQUALS);
            filterInfo.getFilterItems().add(filterItemMaterialInfo);
            filterInfo.getFilterItems().add(filterItemOrgInfo);
            viewInfo.setFilter(filterInfo);
            SelectorItemCollection sic = viewInfo.getSelector();
            sic.add(new SelectorItemInfo("defaultCostItem.*"));
            IMaterialCost iMaterialCost = MaterialCostFactory.getRemoteInstance();
            CoreBaseCollection materialCostCollection = iMaterialCost.getCollection(viewInfo);
            if (materialCostCollection != null && materialCostCollection.size() > 0) {
                return ((MaterialCostInfo)materialCostCollection.get(0)).getDefaultCostItem();
            }
            return costItemInfo;
        }
        return costItemInfo;
    }

    public static CostObjectInfo getDefaultCostObject(CompanyOrgUnitInfo aCompanyOrgUnitInfo, MaterialInfo materialInfo, String lot) throws Exception {
        if (aCompanyOrgUnitInfo != null && materialInfo != null) {
            IManufactureRecBill iManufactureRecBill = ManufactureRecBillFactory.getRemoteInstance();
            return iManufactureRecBill.getDefaultCostObject(materialInfo.getId().toString(), aCompanyOrgUnitInfo.getId().toString(), lot);
        }
        return null;
    }

    public static void checkDuplicateLot(TransferOrderBillInfo transferOrderBillInfo) {
        if (transferOrderBillInfo != null && transferOrderBillInfo.getEntry() != null) {
            int rows = transferOrderBillInfo.getEntry().size();
            if (rows < 0) {
                return;
            }
            ArrayList<String> al = new ArrayList<String>();
            ArrayList<String> al2 = new ArrayList<String>();
            MaterialInfo materialInfo = null;
            for (int i = 0; i < rows; ++i) {
                TransferOrderBillEntryInfo entry = transferOrderBillInfo.getEntry().get(i);
                if (entry.getExp() != null && entry.getMfg() != null && entry.getLot() != null && entry.getMaterial() != null) {
                    materialInfo = entry.getMaterial();
                    al.add(materialInfo.getId().toString() + entry.getLot().toString());
                    al2.add(materialInfo.getId().toString() + entry.getMfg().getTime() + entry.getExp().getTime());
                    continue;
                }
                al.add(null);
                al2.add(null);
            }
            String rec = null;
            String rec2 = null;
            int recs = al.size();
            for (int i = 0; i < recs; ++i) {
                if (al.get(i) == null || al2.get(i) == null) continue;
                rec = al.get(i).toString();
                rec2 = al2.get(i).toString();
                for (int j = i + 1; j < recs; ++j) {
                    if (al.get(j) == null || al2.get(j) == null || !al.get(j).toString().equals(rec) || al2.get(j).toString().equals(rec2)) continue;
                    String comma = ResourceUtil.getMessage(null, (String)addResource, (String)"Comma", null);
                    String duplicateLots = ResourceUtil.getMessage(null, (String)addResource, (String)"DUPLICATELOTS", (String[])new String[]{String.valueOf(i + 1), comma, String.valueOf(j + 1)});
                    MsgBox.showInfo((String)duplicateLots);
                    SysUtil.abort();
                }
            }
        }
    }

    public static void checkBeforeAudit(ICoreBase iCoreBase, IObjectPK pk) throws EASBizException, BOSException {
        Date pkBizDate;
        CompanyOrgUnitInfo companyInUnit;
        CompanyOrgUnitInfo companyOutUnit;
        StorageOrgUnitInfo storageInUnit;
        int errorCount = 0;
        StringBuffer error = new StringBuffer();
        TransferOrderBillInfo transferOrderBillInfo = (TransferOrderBillInfo)iCoreBase.getValue(pk);
        String strTemp = "";
        StorageOrgUnitInfo storageOutUnit = transferOrderBillInfo.getIssueStorageOrgUnit();
        if (storageOutUnit == null) {
            strTemp = InvClientUtils.getResource("StorageOrgUnitNotNull");
            InvClientUtils.showError(strTemp);
        }
        if ((storageInUnit = transferOrderBillInfo.getReceiptStorageOrgUnit()) == null) {
            strTemp = InvClientUtils.getResource("moveInStorageOrgNotNull");
            InvClientUtils.showError(strTemp);
        }
        if ((companyOutUnit = transferOrderBillInfo.getIssueCompanyOrgUnit()) == null) {
            strTemp = InvClientUtils.getResource("moveOutComapnyIsNull");
            InvClientUtils.showError(strTemp);
        }
        if ((companyInUnit = transferOrderBillInfo.getReceiptCompanyOrgUnit()) == null) {
            strTemp = InvClientUtils.getResource("moveInComapnyIsNull");
            InvClientUtils.showError(strTemp);
        }
        if ((pkBizDate = transferOrderBillInfo.getBizDate()) == null) {
            strTemp = InvClientUtils.getResource("bizDateIsNull");
            InvClientUtils.showError(strTemp);
        }
        if (transferOrderBillInfo.getCurrency() == null) {
            strTemp = EASResource.getString((String)"com.kingdee.eas.scm.sd.sale.SaleUIResource", (String)"SALEINV_NEEDCURRENCY");
            InvClientUtils.showError(strTemp);
        }
        int rowCount = 0;
        if (transferOrderBillInfo.getEntry() != null) {
            rowCount = transferOrderBillInfo.getEntry().size();
        }
        if (rowCount == 0) {
            strTemp = InvClientUtils.getResource("EntryIsNull");
            InvClientUtils.showError(strTemp);
        }
        if (rowCount > 0) {
            MaterialInfo materialNum = null;
            MeasureUnitInfo unit = null;
            BigDecimal unitPrice = null;
            BigDecimal taxPrice = null;
            BigDecimal qty = null;
            AsstAttrValueInfo asst = null;
            boolean isPresent = false;
            BigDecimal obj = null;
            for (int i = 0; i < rowCount; ++i) {
                Date planOutDate;
                Date planInDate;
                TransferOrderBillEntryInfo transferOrderBillEntryInfo = transferOrderBillInfo.getEntry().get(i);
                materialNum = transferOrderBillEntryInfo.getMaterial();
                if (materialNum == null || materialNum.getId() == null) {
                    strTemp = InvClientUtils.getResource("materialNumIsNull");
                    errorCount = InvClientUtils.buildErrorString(error, strTemp, i, errorCount);
                } else {
                    asst = transferOrderBillEntryInfo.getAssistProperty();
                    if (asst == null && materialNum.getAssistAttr() != null) {
                        strTemp = InvClientUtils.getResource("assistPropertyIsNull");
                        errorCount = InvClientUtils.buildErrorString(error, strTemp, i, errorCount);
                    }
                }
                unit = transferOrderBillEntryInfo.getUnit();
                if (unit == null || unit.getId() == null) {
                    strTemp = InvClientUtils.getResource("unitIsNull");
                    errorCount = InvClientUtils.buildErrorString(error, strTemp, i, errorCount);
                }
                BigDecimal bigDecimal = qty = (obj = transferOrderBillEntryInfo.getQty()) != null && StringUtil.isNumber((String)((Object)obj).toString()) ? new BigDecimal(((Object)obj).toString()) : null;
                if (qty == null || qty.compareTo(ZERO) <= 0) {
                    strTemp = InvClientUtils.getResource("qtyGreaterZero");
                    errorCount = InvClientUtils.buildErrorString(error, strTemp, i, errorCount);
                }
                unitPrice = (obj = transferOrderBillEntryInfo.getPrice()) != null && StringUtil.isNumber((String)((Object)obj).toString()) ? new BigDecimal(((Object)obj).toString()) : null;
                obj = transferOrderBillEntryInfo.getTaxPrice();
                taxPrice = obj != null && StringUtil.isNumber((String)((Object)obj).toString()) ? new BigDecimal(((Object)obj).toString()) : null;
                isPresent = transferOrderBillEntryInfo.isIsPresent();
                boolean chkInTax = transferOrderBillInfo.isIsInTax();
                if (!isPresent) {
                    if (!chkInTax) {
                        if (unitPrice == null || unitPrice.compareTo(ZERO) <= 0) {
                            strTemp = InvClientUtils.getResource("PriceLessZero");
                            errorCount = InvClientUtils.buildErrorString(error, strTemp, i, errorCount);
                        }
                    } else if (taxPrice == null || taxPrice.compareTo(ZERO) <= 0) {
                        strTemp = InvClientUtils.getAddResource("TAXPRICELESSZERO");
                        errorCount = InvClientUtils.buildErrorString(error, strTemp, i, errorCount);
                    }
                }
                if ((planInDate = transferOrderBillEntryInfo.getReceiptPlanDate()) == null) {
                    strTemp = InvClientUtils.getResource("moveInPlanDateIsNull");
                    errorCount = InvClientUtils.buildErrorString(error, strTemp, i, errorCount);
                }
                if ((planOutDate = transferOrderBillEntryInfo.getIssuePlanDate()) == null) {
                    strTemp = InvClientUtils.getResource("moveOutPlanDateIsNull");
                    errorCount = InvClientUtils.buildErrorString(error, strTemp, i, errorCount);
                }
                if (planInDate != null && planOutDate != null && planInDate.before(planOutDate)) {
                    strTemp = InvClientUtils.getResource("moveInOutPlanError");
                    errorCount = InvClientUtils.buildErrorString(error, strTemp, i, errorCount);
                }
                if (!(transferOrderBillEntryInfo.getIssueStorageOrgUnit() instanceof StorageOrgUnitInfo)) {
                    strTemp = EASResource.getString((String)"com.kingdee.eas.scm.im.IMAutoGenerateResource", (String)"50_InvClientUtils");
                    errorCount = InvClientUtils.buildErrorString(error, strTemp, i, errorCount);
                }
                if (!(transferOrderBillEntryInfo.getReceiveStorageOrgUnit() instanceof StorageOrgUnitInfo)) {
                    strTemp = EASResource.getString((String)"com.kingdee.eas.scm.im.IMAutoGenerateResource", (String)"51_InvClientUtils");
                    errorCount = InvClientUtils.buildErrorString(error, strTemp, i, errorCount);
                }
                if (!(transferOrderBillEntryInfo.getIssueCompanyOrgUnit() instanceof CompanyOrgUnitInfo)) {
                    strTemp = EASResource.getString((String)"com.kingdee.eas.scm.im.IMAutoGenerateResource", (String)"52_InvClientUtils");
                    errorCount = InvClientUtils.buildErrorString(error, strTemp, i, errorCount);
                }
                if (transferOrderBillEntryInfo.getReceiveCompanyOrgUnit() instanceof CompanyOrgUnitInfo) continue;
                strTemp = EASResource.getString((String)"com.kingdee.eas.scm.im.IMAutoGenerateResource", (String)"53_InvClientUtils");
                errorCount = InvClientUtils.buildErrorString(error, strTemp, i, errorCount);
            }
            InvClientUtils.showError(error.toString());
            InvClientUtils.checkDuplicateLot(transferOrderBillInfo);
        }
    }

    private static void showError(String error) {
        if (error.length() > 0) {
            MsgBox.showInfo((String)error);
            SysUtil.abort();
        }
    }

    private static int buildErrorString(StringBuffer error, String strTemp, int rowIndex, int errorCount) {
        ++errorCount;
        String no = InvClientUtils.getResource("No");
        String row = InvClientUtils.getResource("Row");
        if (error.toString().length() != 0) {
            error.append(";");
        }
        error.append(no + (rowIndex + 1) + row + strTemp);
        if (errorCount > 4) {
            InvClientUtils.showError(error.toString());
        }
        return errorCount;
    }

    public static boolean isOffSetable4PurReceival(InvBillBaseInfo invBillBaseInfo) {
        InvBillBaseEntryInfo aInvBillBaseEntryInfo;
        CompanyOrgUnitInfo companyOrgUnitInfo;
        IObjectCollection iObjectCollection;
        boolean isOffSet = false;
        if (invBillBaseInfo != null && (iObjectCollection = (IObjectCollection)invBillBaseInfo.get("entry")) != null && iObjectCollection.size() > 0 && (companyOrgUnitInfo = (aInvBillBaseEntryInfo = (InvBillBaseEntryInfo)iObjectCollection.getObject(0)).getCompanyOrgUnit()) != null) {
            try {
                PeriodInfo currentPeriodInfo = SystemStatusCtrolUtils.getCurrentPeriod(null, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)companyOrgUnitInfo);
                if (currentPeriodInfo == null) {
                    throw new SCMBillException(SCMBillException.CURRENTPERIODISNULL);
                }
                isOffSet = true;
            }
            catch (Exception e) {
                ExceptionHandler.handle((Throwable)e);
            }
        }
        return isOffSet;
    }

    public static void setCostItemForOtherInwarehsBillFilter(CompanyOrgUnitInfo aCompanyOrgUnitInfo, KDTable kdtEntry, String collName) throws Exception {
        KDBizPromptBox prmtCostItem = new KDBizPromptBox();
        prmtCostItem.setQueryInfo("com.kingdee.eas.basedata.assistant.app.CostItemTreeListQuery");
        prmtCostItem.setEditable(true);
        prmtCostItem.setDisplayFormat("$name$");
        prmtCostItem.setEditFormat("$number$");
        prmtCostItem.setCommitFormat("$number$");
        prmtCostItem.setRequired(true);
        if (aCompanyOrgUnitInfo != null) {
            prmtCostItem.setCurrentCtrlUnit(aCompanyOrgUnitInfo.getCU());
        }
        kdtEntry.getColumn(collName).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)prmtCostItem));
        ObjectValueRender avr = new ObjectValueRender();
        avr.setFormat((IDataFormat)new BizDataFormat("$number$"));
        kdtEntry.getColumn(collName).setRenderer((IBasicRender)avr);
    }

    public static BigDecimal getUnitQty(MeasureUnitInfo unitInfo, MaterialInfo material, BigDecimal baseQty, SCMFetchData fetchedData) throws EASBizException, BOSException {
        return SCMClientUtils.getUnitQty((MeasureUnitInfo)unitInfo, (MaterialInfo)material, (BigDecimal)baseQty, (SCMFetchData)fetchedData);
    }

    public static void setLocationFilter(StorageOrgUnitInfo sou, WarehouseInfo warehouseInfo, MaterialInfo mi, KDTable kdtEntry, int rowIndex, boolean isOnload) {
        if (warehouseInfo == null) {
            if (!isOnload) {
                kdtEntry.getRow(rowIndex).getCell(kdtEntry.getColumnIndex(LOCATION)).setValue(null);
            }
            SCMClientUtils.setNecessColorInCells((KDTable)kdtEntry, (String)LOCATION, (int)rowIndex, (boolean)false);
            kdtEntry.getRow(rowIndex).getCell(kdtEntry.getColumnIndex(LOCATION)).getStyleAttributes().setLocked(true);
            return;
        }
        if (warehouseInfo.isHasLocation()) {
            if (!isOnload) {
                LocationInfo defaultloc = InvClientUtils.getDefaultLocation(sou, mi, warehouseInfo);
                LocationInfo lctation = (LocationInfo)kdtEntry.getRow(rowIndex).getCell(LOCATION).getValue();
                if (defaultloc != null) {
                    lctation = defaultloc;
                }
                kdtEntry.getRow(rowIndex).getCell(kdtEntry.getColumnIndex(LOCATION)).setValue((Object)lctation);
            }
            kdtEntry.getRow(rowIndex).getCell(kdtEntry.getColumnIndex(LOCATION)).getStyleAttributes().setLocked(false);
            SCMClientUtils.setNecessColorInCells((KDTable)kdtEntry, (String)LOCATION, (int)rowIndex, (boolean)true);
            EntityViewInfo viewInfo = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            FilterItemInfo storageFilterItemInfo = new FilterItemInfo("WAREHOUSE.ID", (Object)warehouseInfo.getId().toString());
            filterInfo.getFilterItems().add(storageFilterItemInfo);
            viewInfo.setFilter(filterInfo);
            KDBizPromptBox kDBizPromptBoxLocation = new KDBizPromptBox();
            kDBizPromptBoxLocation.setEditable(true);
            kDBizPromptBoxLocation.setQueryInfo("com.kingdee.eas.basedata.scm.im.inv.app.F7LocationQuery");
            kDBizPromptBoxLocation.setDisplayFormat("$number$");
            kDBizPromptBoxLocation.setEditFormat("$number$");
            kDBizPromptBoxLocation.setCommitFormat("$number$");
            kDBizPromptBoxLocation.setEntityViewInfo(viewInfo);
            kdtEntry.getRow(rowIndex).getCell(kdtEntry.getColumnIndex(LOCATION)).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)kDBizPromptBoxLocation));
        } else {
            kdtEntry.getRow(rowIndex).getCell(kdtEntry.getColumnIndex(LOCATION)).setValue(null);
            kdtEntry.getRow(rowIndex).getCell(kdtEntry.getColumnIndex(LOCATION)).getStyleAttributes().setLocked(true);
            SCMClientUtils.setNecessColorInCells((KDTable)kdtEntry, (String)LOCATION, (int)rowIndex, (boolean)false);
        }
    }

    public static void setLocationFilter(StorageOrgUnitInfo sou, WarehouseInfo warehouseInfo, MaterialInfo mi, SCMFetchData fetchData, KDTable kdtEntry, int rowIndex, boolean isOnload) {
        if (fetchData == null || fetchData.getMapDefaultLocation() == null) {
            InvClientUtils.setLocationFilter(sou, warehouseInfo, mi, kdtEntry, rowIndex, isOnload);
        }
        if (warehouseInfo == null) {
            if (!isOnload) {
                kdtEntry.getRow(rowIndex).getCell(kdtEntry.getColumnIndex(LOCATION)).setValue(null);
            }
            SCMClientUtils.setNecessColorInCells((KDTable)kdtEntry, (String)LOCATION, (int)rowIndex, (boolean)false);
            kdtEntry.getRow(rowIndex).getCell(kdtEntry.getColumnIndex(LOCATION)).getStyleAttributes().setLocked(true);
            return;
        }
        if (warehouseInfo.isHasLocation()) {
            if (!isOnload) {
                LocationInfo defaultloc = null;
                try {
                    defaultloc = fetchData.getDefaultLocation(mi.getId().toString(), warehouseInfo.getId().toString(), sou.getId().toString());
                }
                catch (EASBizException e) {
                    ExceptionHandler.handle((Throwable)e);
                }
                catch (BOSException e) {
                    ExceptionHandler.handle((Throwable)e);
                }
                LocationInfo lctation = (LocationInfo)kdtEntry.getRow(rowIndex).getCell(LOCATION).getValue();
                if (defaultloc != null) {
                    lctation = defaultloc;
                }
                kdtEntry.getRow(rowIndex).getCell(kdtEntry.getColumnIndex(LOCATION)).setValue((Object)lctation);
            }
            kdtEntry.getRow(rowIndex).getCell(kdtEntry.getColumnIndex(LOCATION)).getStyleAttributes().setLocked(false);
            SCMClientUtils.setNecessColorInCells((KDTable)kdtEntry, (String)LOCATION, (int)rowIndex, (boolean)true);
            EntityViewInfo viewInfo = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            FilterItemInfo storageFilterItemInfo = new FilterItemInfo("WAREHOUSE.ID", (Object)warehouseInfo.getId().toString());
            filterInfo.getFilterItems().add(storageFilterItemInfo);
            viewInfo.setFilter(filterInfo);
            KDBizPromptBox kDBizPromptBoxLocation = new KDBizPromptBox();
            kDBizPromptBoxLocation.setEditable(true);
            kDBizPromptBoxLocation.setQueryInfo("com.kingdee.eas.basedata.scm.im.inv.app.F7LocationQuery");
            kDBizPromptBoxLocation.setDisplayFormat("$number$");
            kDBizPromptBoxLocation.setEditFormat("$number$");
            kDBizPromptBoxLocation.setCommitFormat("$number$");
            kDBizPromptBoxLocation.setEntityViewInfo(viewInfo);
            kdtEntry.getRow(rowIndex).getCell(kdtEntry.getColumnIndex(LOCATION)).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)kDBizPromptBoxLocation));
        } else {
            kdtEntry.getRow(rowIndex).getCell(kdtEntry.getColumnIndex(LOCATION)).setValue(null);
            kdtEntry.getRow(rowIndex).getCell(kdtEntry.getColumnIndex(LOCATION)).getStyleAttributes().setLocked(true);
            SCMClientUtils.setNecessColorInCells((KDTable)kdtEntry, (String)LOCATION, (int)rowIndex, (boolean)false);
        }
    }

    public static BigDecimal obj2BigDecimal(Object obj) {
        return InvClientUtils.obj2BigDecimal(obj, null);
    }

    public static BigDecimal obj2BigDecimal(Object obj, BigDecimal defaultValue) {
        if (null == obj) {
            return defaultValue;
        }
        if (obj instanceof BigDecimal) {
            return (BigDecimal)obj;
        }
        if (obj instanceof String) {
            try {
                Object s = BOSLocaleUtil.getNumberFormat().parseObject((String)obj);
                return new BigDecimal(s.toString());
            }
            catch (Exception s) {}
        } else {
            if (obj instanceof Byte) {
                byte b = (Byte)obj;
                return new BigDecimal("" + b);
            }
            if (obj instanceof Short) {
                short s = (Short)obj;
                return new BigDecimal("" + s);
            }
            if (obj instanceof Integer) {
                int i = (Integer)obj;
                return new BigDecimal("" + i);
            }
            if (obj instanceof Long) {
                long l = (Long)obj;
                return new BigDecimal("" + l);
            }
            if (obj instanceof Float) {
                float f = ((Float)obj).floatValue();
                return new BigDecimal("" + f);
            }
            if (obj instanceof Double || obj instanceof Number) {
                double d = ((Number)obj).doubleValue();
                return new BigDecimal("" + d);
            }
        }
        return defaultValue;
    }

    public static void setProjectTrackEditable(KDTable table, boolean isBotp, boolean isClearVal, int rowIdx, MaterialPlanInfo matPlanInfo, String projectNum, String trackNum) throws Exception {
        if (table.getRow(rowIdx) == null) {
            return;
        }
        if (matPlanInfo != null && matPlanInfo.getStatus() == UsedStatusEnum.APPROVED) {
            if (matPlanInfo.getManufactureStrategy() != null && matPlanInfo.getManufactureStrategy().getId() != null && (matPlanInfo.getManufactureStrategy().getId().toString().equals("qAXoUB/tBg/gQKjAYj0WQ9g0uEU=") || matPlanInfo.getManufactureStrategy().getId().toString().equals("qAYfaBzTrmLgQKjAYj0f3dg0uEU="))) {
                table.getRow(rowIdx).getCell(trackNum).getStyleAttributes().setBackground(SCMClientUtils.necessaryColor);
                table.getRow(rowIdx).getCell(trackNum).getStyleAttributes().setLocked(false);
                if (isClearVal) {
                    table.getRow(rowIdx).getCell(projectNum).setValue(null);
                }
                table.getRow(rowIdx).getCell(projectNum).getStyleAttributes().setLocked(true);
                table.getRow(rowIdx).getCell(projectNum).getStyleAttributes().setBackground(Color.WHITE);
            } else if (matPlanInfo.getManufactureStrategy() != null && matPlanInfo.getManufactureStrategy().getId() != null && matPlanInfo.getManufactureStrategy().getId().toString().equals("qAXoUB/uBg/gQKjAYj0WQ9g0uEU=")) {
                if (matPlanInfo.getIsolatedRule() != null && matPlanInfo.getIsolatedRule() == IsolatedRuleEnum.ITEM) {
                    table.getRow(rowIdx).getCell(projectNum).getStyleAttributes().setLocked(false);
                    table.getRow(rowIdx).getCell(projectNum).getStyleAttributes().setBackground(SCMClientUtils.necessaryColor);
                    table.getRow(rowIdx).getCell(trackNum).getStyleAttributes().setBackground(Color.WHITE);
                    table.getRow(rowIdx).getCell(trackNum).getStyleAttributes().setLocked(false);
                } else if (matPlanInfo.getIsolatedRule() != null && matPlanInfo.getIsolatedRule() == IsolatedRuleEnum.ITEM_TRACKNO) {
                    table.getRow(rowIdx).getCell(projectNum).getStyleAttributes().setLocked(false);
                    table.getRow(rowIdx).getCell(projectNum).getStyleAttributes().setBackground(SCMClientUtils.necessaryColor);
                    table.getRow(rowIdx).getCell(trackNum).getStyleAttributes().setBackground(SCMClientUtils.necessaryColor);
                    table.getRow(rowIdx).getCell(trackNum).getStyleAttributes().setLocked(false);
                } else {
                    table.getRow(rowIdx).getCell(trackNum).getStyleAttributes().setBackground(Color.WHITE);
                    table.getRow(rowIdx).getCell(trackNum).getStyleAttributes().setLocked(false);
                    table.getRow(rowIdx).getCell(projectNum).getStyleAttributes().setLocked(false);
                    table.getRow(rowIdx).getCell(projectNum).getStyleAttributes().setBackground(Color.WHITE);
                }
            } else {
                table.getRow(rowIdx).getCell(trackNum).getStyleAttributes().setBackground(Color.WHITE);
                table.getRow(rowIdx).getCell(trackNum).getStyleAttributes().setLocked(false);
                table.getRow(rowIdx).getCell(projectNum).getStyleAttributes().setLocked(false);
                table.getRow(rowIdx).getCell(projectNum).getStyleAttributes().setBackground(Color.WHITE);
            }
        } else {
            table.getRow(rowIdx).getCell(trackNum).getStyleAttributes().setBackground(Color.WHITE);
            table.getRow(rowIdx).getCell(trackNum).getStyleAttributes().setLocked(false);
            table.getRow(rowIdx).getCell(projectNum).getStyleAttributes().setLocked(false);
            table.getRow(rowIdx).getCell(projectNum).getStyleAttributes().setBackground(Color.WHITE);
        }
    }

    public static Set getAuthorizedf7Orgs(String storageOrgID) {
        OrgViewType[] orgViewTypes = new OrgViewType[]{OrgViewType.STORAGE};
        OrgType orgType = NewOrgViewHelper.convert((OrgViewType)orgViewTypes[0]);
        ObjectUuidPK treePK = new ObjectUuidPK(NewOrgViewHelper.convert2TreeId((OrgType)orgType));
        ObjectUuidPK userPK = new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId());
        HashSet<String> orgUnitSet = new HashSet<String>();
        Set fullUnitSet = new HashSet();
        FullOrgUnitCollection unitCol = null;
        try {
            unitCol = PermissionFactory.getRemoteInstance().getAuthorizedOrg((IObjectPK)userPK, orgType, (IObjectPK)treePK, "inoutstoregatherreport_view");
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
            return orgUnitSet;
        }
        for (int i = 0; i < unitCol.size(); ++i) {
            if (!unitCol.get(i).getId().toString().equals(storageOrgID)) continue;
            orgUnitSet.add(unitCol.get(i).getId().toString());
        }
        fullUnitSet = InvClientUtils.getFullOrgUnit(orgUnitSet);
        return fullUnitSet;
    }

    public static Set getAuthorizedf7Orgs(String[] storageOrgIDs) {
        OrgViewType[] orgViewTypes = new OrgViewType[]{OrgViewType.STORAGE};
        OrgType orgType = NewOrgViewHelper.convert((OrgViewType)orgViewTypes[0]);
        ObjectUuidPK treePK = new ObjectUuidPK(NewOrgViewHelper.convert2TreeId((OrgType)orgType));
        ObjectUuidPK userPK = new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId());
        HashSet<String> orgUnitSet = new HashSet<String>();
        Set fullUnitSet = new HashSet();
        FullOrgUnitCollection unitCol = null;
        try {
            unitCol = PermissionFactory.getRemoteInstance().getAuthorizedOrg((IObjectPK)userPK, orgType, (IObjectPK)treePK, "inoutstoregatherreport_view");
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
            return orgUnitSet;
        }
        for (int i = 0; i < unitCol.size(); ++i) {
            for (int j = 0; j < storageOrgIDs.length; ++j) {
                if (!unitCol.get(i).getId().toString().equals(storageOrgIDs[j])) continue;
                orgUnitSet.add(unitCol.get(i).getId().toString());
            }
        }
        fullUnitSet = InvClientUtils.getFullOrgUnit(orgUnitSet);
        return fullUnitSet;
    }

    public static KDBizPromptBox setStockerF7ByStorageOrg(KDBizPromptBox kDBizPromptBoxStocker, StorageOrgUnitInfo sou, CoreUI coreUI) throws Exception {
        kDBizPromptBoxStocker.setEditable(true);
        kDBizPromptBoxStocker.setQueryInfo("com.kingdee.eas.basedata.person.app.PersonQuery");
        kDBizPromptBoxStocker.setDisplayFormat("$name$");
        kDBizPromptBoxStocker.setEditFormat("$number$");
        kDBizPromptBoxStocker.setCommitFormat("$number$;$idNum$");
        HashMap hash = new HashMap();
        PersonPromptBox box = new PersonPromptBox((IUIObject)coreUI, hash);
        box.showAllAdmin();
        kDBizPromptBoxStocker.setSelector((KDPromptSelector)box);
        kDBizPromptBoxStocker.commitEdit();
        return kDBizPromptBoxStocker;
    }

    public static Map getInventoryPemissionSqlMap(Set cuUnitSets, String permItemName) throws EASBizException, BOSException {
        Set cuUnits;
        ObjectUuidPK userPK = new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId().toString());
        HashMap<String, FilterInfo> warePermMap = new HashMap<String, FilterInfo>();
        if (cuUnitSets.size() == 0 && (cuUnits = InvClientUtils.getAuthorizedf7Orgs()) != null && cuUnits.size() > 0) {
            for (FullOrgUnitInfo orgUnit : cuUnits) {
                cuUnitSets.add(orgUnit.getId().toString());
            }
        }
        if (cuUnitSets != null && cuUnitSets.size() > 0) {
            Iterator it = cuUnitSets.iterator();
            while (it.hasNext()) {
                String orgId = null;
                orgId = it.next().toString();
                ObjectUuidPK orgPK = null;
                if (orgId != null) {
                    orgPK = new ObjectUuidPK(orgId);
                }
                if (orgPK == null) {
                    return null;
                }
                IPermissionServiceProvider provider = PermissionServiceProviderFactory.getRemoteInstance();
                String oql = provider.getPermissionRule((IObjectPK)userPK, (IObjectPK)orgPK, permItemName);
                if (oql == null) {
                    warePermMap.put(orgId, null);
                    continue;
                }
                StringBuffer permision = new StringBuffer();
                permision.append(" select * ");
                permision.append(oql);
                oql = permision.toString();
                EntityViewInfo view = null;
                FilterInfo filter = null;
                try {
                    view = new EntityViewInfo(oql);
                }
                catch (ParserException e) {
                    return null;
                }
                if (view.getFilter() != null && view.getFilter().getFilterItems() != null && view.getFilter().getFilterItems().size() > 0) {
                    filter = view.getFilter();
                }
                warePermMap.put(orgId, filter);
            }
        }
        return warePermMap;
    }

    public static Map getMaterialPlanCollec(Map materialIDs, String orgID) throws BOSException {
        HashMap<String, MaterialPlanInfo> matPlans = new HashMap<String, MaterialPlanInfo>();
        if (StringUtil.isEmpty((String)orgID) || materialIDs.size() == 0) {
            return matPlans;
        }
        Iterator it = materialIDs.keySet().iterator();
        StringBuffer ids = new StringBuffer();
        while (it.hasNext()) {
            ids.append((String)it.next()).append(",");
        }
        if (ids.length() > 0) {
            ids.deleteCharAt(ids.length() - 1);
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("material.id", (Object)ids.toString(), CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)orgID, CompareType.EQUALS));
        filter.setMaskString("#0 and #1");
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        IMaterialPlan iMatPlan = MaterialPlanFactory.getRemoteInstance();
        MaterialPlanCollection col = iMatPlan.getMaterialPlanCollection(view);
        MaterialPlanInfo matPlanInfo = null;
        String key = null;
        int size = col.size();
        for (int i = 0; i < size; ++i) {
            matPlanInfo = col.get(i);
            if (matPlanInfo == null || matPlanInfo.getMaterial() == null || matPlanInfo.getOrgUnit() == null) continue;
            key = matPlanInfo.getMaterial().getId().toString() + matPlanInfo.getOrgUnit().getId().toString();
            matPlans.put(key, matPlanInfo);
        }
        return matPlans;
    }

    public static void inverseQty(IRow row, String[] colNames, boolean isNegativeBill) {
        BigDecimal value = null;
        int size = colNames.length;
        for (int i = 0; i < size; ++i) {
            value = (BigDecimal)row.getCell(colNames[i]).getValue();
            if (value == null || value.compareTo(ZERO) == 0) {
                row.getCell(colNames[i]).setValue((Object)ZERO);
                continue;
            }
            row.getCell(colNames[i]).setValue((Object)(isNegativeBill ? value.abs().negate() : value.abs()));
        }
    }

    private static boolean isJumpOrg(InvBillBaseInfo info) {
        String bizTypeID = null;
        return info != null && info.getBizType() != null && ("i6DbShN4SLaNlFkX90UXOiQHQ1w=".equals(bizTypeID = info.getBizType().getId().toString()) || "YJN9V65PSkutQxeUH6F72SQHQ1w=".equals(bizTypeID) || "nhvcdx82RzuTw48FSlV79CQHQ1w=".equals(bizTypeID));
    }

    public static String getDecimalFormatString(BigDecimal dec, int scale) {
        if (dec == null) {
            return null;
        }
        DecimalFormat df = (DecimalFormat)CtrlFormatUtilities.getDecimalFormat();
        df.applyPattern(PrecisionUtil.getFmtString((int)scale));
        return df.format(dec);
    }

    public static boolean isForwardAmt(InvBillBaseInfo info, InvUpdateTypeInfo invUpdateType) {
        if (info == null || info.getBillType() == null || invUpdateType == null) {
            return true;
        }
        try {
            InvUpdateTypeInfo invUpdate = InvUpdateTypeFactory.getRemoteInstance().getInvUpdateTypeInfo("select id,storeType.id,storeType.isForwardAmt where id = '" + invUpdateType.getId().toString() + "'");
            if (SCMBaseCommonUtil.isInWarehsBill((String)info.getBillType().getId().toString())) {
                return invUpdate.getStoreType().isIsForwardAmt();
            }
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return true;
    }

    public static void setColumnsFontColor(KDTable table, String[] colNames, TransactionTypeInfo tti, boolean isReversed) {
        boolean isNegative = false;
        boolean a = false;
        if (tti != null && tti.getRiType() != null && tti.getRiType().getBizDirection() != null && tti.getRiType().getBizDirection().getValue() == -1) {
            isNegative = true;
        }
        InvClientUtils.setColumnsFontColor(table, colNames, isNegative, isReversed);
    }

    public static void setColumnsFontColor(KDTable table, String[] colNames, boolean isNegative, boolean isReversed) {
        if (table == null || colNames == null || isReversed) {
            return;
        }
        int[] colNameIdx = new int[colNames.length];
        Color fontColor = isNegative ? Color.RED : Color.BLACK;
        int len = colNames.length;
        for (int i = 0; i < len; ++i) {
            colNameIdx[i] = table.getColumnIndex(colNames[i]);
            IColumn column = table.getColumn(colNameIdx[i]);
            if (column == null) continue;
            column.getStyleAttributes().setFontColor(fontColor);
        }
        KDTFootManager footRowManager = table.getFootManager();
        IRow footRow = null;
        if (footRowManager != null && footRowManager.getFootRow(0) != null) {
            footRow = footRowManager.getFootRow(0);
            int len2 = colNameIdx.length;
            for (int i = 0; i < len2; ++i) {
                ICell cell = footRow.getCell(colNameIdx[i]);
                if (cell == null) continue;
                cell.getStyleAttributes().setFontColor(fontColor);
            }
        }
    }

    public static void setMaterialFilterbySou(Set souSet, KDBizPromptBox bizMaterialF7) {
        if (bizMaterialF7 != null) {
            bizMaterialF7.getQueryAgent().resetRuntimeEntityView();
            EntityViewInfo viewInfo = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            FilterItemInfo storageFilterItemInfo = new FilterItemInfo("storageOrgUnit.id", (Object)souSet, CompareType.INCLUDE);
            filterInfo.getFilterItems().add(storageFilterItemInfo);
            viewInfo.setFilter(filterInfo);
            bizMaterialF7.setEditable(true);
            bizMaterialF7.setQueryInfo("com.kingdee.eas.basedata.master.material.app.F7MaterialInventoryNoGroupQuery");
            bizMaterialF7.setDisplayFormat("$number$");
            bizMaterialF7.setEditFormat("$number$");
            bizMaterialF7.setCommitFormat("$number$");
            bizMaterialF7.setEntityViewInfo(viewInfo);
        }
    }

    public static EntityViewInfo getWarehouseFilterBySOAccreditWH(Set sous, int isStarted) throws EASBizException, BOSException {
        if (sous != null && sous.size() > 0) {
            EntityViewInfo viewInfo = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("SOWH.STORAGEORG.ID", (Object)sous, CompareType.INCLUDE));
            if (isStarted != -1) {
                filterInfo.getFilterItems().add(new FilterItemInfo("SOWH.ISSTARTED", (Object)new Integer(isStarted), CompareType.EQUALS));
            }
            viewInfo.setFilter(filterInfo);
            return viewInfo;
        }
        return null;
    }

    public static EntityViewInfo getEntityViewForF7AccountView(CompanyOrgUnitInfo cou) {
        EntityViewInfo ev = new EntityViewInfo();
        if (cou == null || cou.getAccountTable() == null) {
            return ev;
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("accountTableID.id", (Object)cou.getAccountTable().getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("companyID.id", (Object)cou.getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("isCFreeze", (Object)false));
        filter.getFilterItems().add(new FilterItemInfo("isGFreeze", (Object)false));
        ev.setFilter(filter);
        return ev;
    }

    public static void setLocationFilterByMSRelation(CoreUIObject ui, StorageOrgUnitInfo sou, WarehouseInfo warehouseInfo, MaterialInfo mi, KDTable kdtEntry, int rowIndex, boolean isOnload, SCMFetchData fetchData, String locationColName) {
        if (warehouseInfo == null) {
            if (!isOnload) {
                kdtEntry.getRow(rowIndex).getCell(kdtEntry.getColumnIndex(locationColName)).setValue(null);
            }
            SCMClientUtils.setNecessColorInCells((KDTable)kdtEntry, (String)locationColName, (int)rowIndex, (boolean)false);
            kdtEntry.getRow(rowIndex).getCell(kdtEntry.getColumnIndex(locationColName)).getStyleAttributes().setLocked(true);
            return;
        }
        if (warehouseInfo.isHasLocation()) {
            if (!isOnload) {
                LocationInfo defaultloc = null;
                try {
                    MaterialGroupInfo materialGroup;
                    defaultloc = fetchData.getDefaultLocation(mi.getId().toString(), warehouseInfo.getId().toString(), sou.getId().toString());
                    if (defaultloc == null && (materialGroup = InvClientUtils.getMaterialGroupByMaterial(mi)) != null && materialGroup.getId() != null) {
                        defaultloc = fetchData.getDefaultGroupLocation(materialGroup.getId().toString(), warehouseInfo.getId().toString(), sou.getId().toString());
                    }
                }
                catch (Exception e) {
                    ExceptionHandler.handle((Throwable)e);
                }
                LocationInfo lctation = (LocationInfo)kdtEntry.getRow(rowIndex).getCell(locationColName).getValue();
                if (defaultloc != null) {
                    lctation = defaultloc;
                }
                kdtEntry.getRow(rowIndex).getCell(kdtEntry.getColumnIndex(locationColName)).setValue((Object)lctation);
            }
            kdtEntry.getRow(rowIndex).getCell(kdtEntry.getColumnIndex(locationColName)).getStyleAttributes().setLocked(false);
            SCMClientUtils.setNecessColorInCells((KDTable)kdtEntry, (String)locationColName, (int)rowIndex, (boolean)true);
            EntityViewInfo viewInfo = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("assignStorageOrgUnit.id", (Object)sou.getId().toString()));
            filterInfo.getFilterItems().add(new FilterItemInfo("assignWarehouse.id", (Object)warehouseInfo.getId().toString()));
            if (mi != null) {
                filterInfo.getFilterItems().add(new FilterItemInfo("assignMaterial.id", (Object)mi.getId().toString()));
            }
            try {
                MaterialGroupInfo materialGroupInfo = InvClientUtils.getMaterialGroupByMaterial(mi);
                if (null != materialGroupInfo) {
                    String longNumber = materialGroupInfo.getLongNumber();
                    HashSet<String> longNumbers = new HashSet<String>();
                    longNumbers.add(longNumber);
                    int index = longNumber.indexOf("!", 0);
                    String lNumber = null;
                    while (index > 0) {
                        lNumber = longNumber.substring(0, index);
                        if (!StringUtil.isEmpty((String)lNumber)) {
                            longNumbers.add(lNumber);
                        }
                        index = longNumber.indexOf("!", index + 1);
                    }
                    filterInfo.getFilterItems().add(new FilterItemInfo("materialGroup.longNumber", longNumbers, CompareType.INCLUDE));
                    filterInfo.getFilterItems().add(new FilterItemInfo("materialStorageAssign.storageAssignType", (Object)new Integer(1), CompareType.EQUALS));
                    filterInfo.setMaskString(" #0 and #1 and (#2 or (#3 and #4))");
                }
            }
            catch (Exception e1) {
                Logger.error((Throwable)e1);
            }
            viewInfo.setFilter(filterInfo);
            KDBizPromptBox kDBizPromptBoxLocation = new KDBizPromptBox();
            kDBizPromptBoxLocation.setEditable(true);
            try {
                kDBizPromptBoxLocation = LocationHelper.setLocationF7((CoreUIObject)ui, (KDBizPromptBox)kDBizPromptBoxLocation, (String)warehouseInfo.getId().toString(), (FilterInfo)filterInfo);
            }
            catch (Exception e) {
                Logger.error((Throwable)e);
            }
            kdtEntry.getRow(rowIndex).getCell(kdtEntry.getColumnIndex(locationColName)).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)kDBizPromptBoxLocation));
        } else {
            if (!isOnload) {
                kdtEntry.getRow(rowIndex).getCell(kdtEntry.getColumnIndex(locationColName)).setValue(null);
            }
            kdtEntry.getRow(rowIndex).getCell(kdtEntry.getColumnIndex(locationColName)).getStyleAttributes().setLocked(true);
            SCMClientUtils.setNecessColorInCells((KDTable)kdtEntry, (String)locationColName, (int)rowIndex, (boolean)false);
        }
    }

    public static Set getCostCenterOrgUnitSet(Set cous) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("toUnit", (Object)cous, CompareType.INCLUDE));
        filter.appendFilterItem("typeRelation.fromType", (Object)5);
        filter.appendFilterItem("typeRelation.toType", (Object)1);
        filter.setMaskString("#0 and #1 and #2");
        view.setFilter(filter);
        view.getSelector().add(new SelectorItemInfo("fromUnit.id"));
        OrgUnitRelationCollection ourCol = OrgUnitRelationFactory.getRemoteInstance().getOrgUnitRelationCollection(view);
        if (ourCol == null || ourCol.size() == 0) {
            return null;
        }
        HashSet<String> costCenterIdSet = new HashSet<String>(ourCol.size());
        int size = ourCol.size();
        for (int i = 0; i < size; ++i) {
            OrgUnitRelationInfo ourInfo = ourCol.get(i);
            costCenterIdSet.add(ourInfo.getFromUnit().getId().toString());
        }
        return costCenterIdSet;
    }

    public static void setMFG(KDTable kdtEntry, int rowIndex, TransactionTypeInfo tti, boolean isReversed, boolean plusOne, StorageOrgUnitInfo sou, MaterialInfo materialInfo, InvBillBaseInfo editData, SCMFetchData fetchData) throws Exception {
        InvClientUtils.setMFG(kdtEntry, rowIndex, tti, isReversed, plusOne, sou, materialInfo, editData, true, fetchData);
    }

    public static void handleLocation(StorageOrgUnitInfo sou, WarehouseInfo warehouseInfo, MaterialInfo mi, SCMFetchData fetchData, String locationFieldName, KDTable kdtEntry, int rowIndex, boolean isOnload) {
        if (warehouseInfo == null) {
            if (!isOnload) {
                kdtEntry.getRow(rowIndex).getCell(kdtEntry.getColumnIndex(locationFieldName)).setValue(null);
            }
            SCMClientUtils.setNecessColorInCells((KDTable)kdtEntry, (String)locationFieldName, (int)rowIndex, (boolean)false);
            kdtEntry.getRow(rowIndex).getCell(kdtEntry.getColumnIndex(locationFieldName)).getStyleAttributes().setLocked(true);
            return;
        }
        if (warehouseInfo.isHasLocation()) {
            if (!isOnload) {
                LocationInfo defaultloc = null;
                if (fetchData == null || fetchData.getMapDefaultLocation() == null || mi == null) {
                    defaultloc = InvClientUtils.getDefaultLocation(sou, mi, warehouseInfo);
                } else {
                    try {
                        defaultloc = fetchData.getDefaultLocation(mi.getId().toString(), warehouseInfo.getId().toString(), sou.getId().toString());
                        MaterialGroupInfo materialGroup = mi.getMaterialGroup();
                        if (defaultloc == null && materialGroup != null && materialGroup.getId() != null) {
                            defaultloc = fetchData.getDefaultGroupLocation(materialGroup.getId().toString(), warehouseInfo.getId().toString(), sou.getId().toString());
                        }
                    }
                    catch (Exception e) {
                        ExceptionHandler.handle((Throwable)e);
                    }
                }
                LocationInfo location = (LocationInfo)kdtEntry.getRow(rowIndex).getCell(locationFieldName).getValue();
                if (location == null && defaultloc != null) {
                    location = defaultloc;
                }
                kdtEntry.getRow(rowIndex).getCell(kdtEntry.getColumnIndex(locationFieldName)).setValue((Object)location);
            }
            kdtEntry.getRow(rowIndex).getCell(kdtEntry.getColumnIndex(locationFieldName)).getStyleAttributes().setLocked(false);
            SCMClientUtils.setNecessColorInCells((KDTable)kdtEntry, (String)locationFieldName, (int)rowIndex, (boolean)true);
        } else {
            kdtEntry.getRow(rowIndex).getCell(kdtEntry.getColumnIndex(locationFieldName)).setValue(null);
            kdtEntry.getRow(rowIndex).getCell(kdtEntry.getColumnIndex(locationFieldName)).getStyleAttributes().setLocked(true);
            SCMClientUtils.setNecessColorInCells((KDTable)kdtEntry, (String)locationFieldName, (int)rowIndex, (boolean)false);
        }
    }

    public static void setLocationFilterByMSRelation(CoreUIObject ui, StorageOrgUnitInfo sou, MaterialInfo mi, WarehouseInfo warehouseInfo, SCMFetchData fetchData, KDBizPromptBox kDBizPromptBoxLocation) {
        MaterialGroupInfo materialGroupInfo = null;
        if (warehouseInfo.isHasLocation()) {
            try {
                if (mi != null) {
                    materialGroupInfo = fetchData.getMaterial(mi.getId().toString()).getMaterialGroup();
                }
            }
            catch (Exception e1) {
                Logger.error((Throwable)e1);
            }
            EntityViewInfo viewInfo = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("assignStorageOrgUnit.id", (Object)sou.getId().toString()));
            filterInfo.getFilterItems().add(new FilterItemInfo("assignWarehouse.id", (Object)warehouseInfo.getId().toString()));
            if (mi != null) {
                filterInfo.getFilterItems().add(new FilterItemInfo("assignMaterial.id", (Object)mi.getId().toString()));
            }
            if (null != materialGroupInfo) {
                String longNumber = materialGroupInfo.getLongNumber();
                HashSet<String> longNumbers = new HashSet<String>();
                longNumbers.add(longNumber);
                int index = longNumber.indexOf("!", 0);
                String lNumber = null;
                while (index > 0) {
                    lNumber = longNumber.substring(0, index);
                    if (!StringUtil.isEmpty((String)lNumber)) {
                        longNumbers.add(lNumber);
                    }
                    index = longNumber.indexOf("!", index + 1);
                }
                filterInfo.getFilterItems().add(new FilterItemInfo("materialGroup.longNumber", longNumbers, CompareType.INCLUDE));
                filterInfo.getFilterItems().add(new FilterItemInfo("materialStorageAssign.storageAssignType", (Object)new Integer(1), CompareType.EQUALS));
                filterInfo.setMaskString(" #0 and #1 and (#2 or (#3 and #4))");
            }
            viewInfo.setFilter(filterInfo);
            try {
                kDBizPromptBoxLocation = LocationHelper.setLocationF7((CoreUIObject)ui, (KDBizPromptBox)kDBizPromptBoxLocation, (String)warehouseInfo.getId().toString(), (FilterInfo)filterInfo);
            }
            catch (Exception e) {
                Logger.error((Throwable)e);
            }
        }
    }

    public static void handleWarehouse(StorageOrgUnitInfo sou, KDTable kdtEntry, int row, String fieldName) {
        if (sou != null) {
            kdtEntry.getCell(row, fieldName).getStyleAttributes().setLocked(false);
        } else {
            kdtEntry.getCell(row, fieldName).getStyleAttributes().setLocked(true);
        }
    }

    public static void handleWarehouseByMSRelation(StorageOrgUnitInfo sou, MaterialInfo materialInfo, KDTable kdtEntry, int row, String fieldName) {
        if (sou != null && materialInfo != null) {
            kdtEntry.getCell(row, fieldName).getStyleAttributes().setLocked(false);
        } else {
            kdtEntry.getCell(row, fieldName).getStyleAttributes().setLocked(true);
        }
    }

    public static void setWarehouseFitler(StorageOrgUnitInfo sou, int isStarted, KDBizPromptBox kDBizPromptBoxWarehouse) {
        try {
            if (sou != null) {
                kDBizPromptBoxWarehouse.setEditable(true);
                kDBizPromptBoxWarehouse.setQueryInfo("com.kingdee.eas.basedata.scm.im.inv.app.F7WarehouseQuery");
                kDBizPromptBoxWarehouse.setDisplayFormat("$name$");
                kDBizPromptBoxWarehouse.setEditFormat("$number$;$name$");
                kDBizPromptBoxWarehouse.setCommitFormat("$number$;$name$");
                kDBizPromptBoxWarehouse.setEntityViewInfo(InvClientUtils.getWarehouseFilter(sou, isStarted));
                kDBizPromptBoxWarehouse.getQueryAgent().resetRuntimeEntityView();
            }
        }
        catch (EASBizException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
        }
    }

    public static void setWarehouseFitlerByMSRelation(StorageOrgUnitInfo sou, MaterialInfo materialInfo, int isStarted, SCMFetchData fetchData, KDBizPromptBox kDBizPromptBoxWarehouse) {
        try {
            if (sou != null && materialInfo != null) {
                kDBizPromptBoxWarehouse.setEditable(true);
                kDBizPromptBoxWarehouse.setQueryInfo("com.kingdee.eas.basedata.scm.im.inv.app.F7WarehouseByMSAssignQuery");
                kDBizPromptBoxWarehouse.setDisplayFormat("$name$");
                kDBizPromptBoxWarehouse.setEditFormat("$number$");
                kDBizPromptBoxWarehouse.setCommitFormat("$number$;$name$");
                EntityViewInfo viewInfo = new EntityViewInfo();
                FilterInfo filterInfo = new FilterInfo();
                filterInfo.getFilterItems().add(new FilterItemInfo("assignStorageOrgUnit.id", (Object)sou.getId().toString(), CompareType.EQUALS));
                filterInfo.getFilterItems().add(new FilterItemInfo("assignMaterial.id", (Object)materialInfo.getId().toString(), CompareType.EQUALS));
                int conditionCount = 2;
                StringBuffer maskString = new StringBuffer("( ");
                MaterialGroupInfo materialGroupInfo = fetchData.getMaterial(materialInfo.getId().toString()).getMaterialGroup();
                if (null != materialGroupInfo) {
                    String longNumber = materialGroupInfo.getLongNumber();
                    HashSet<String> longNumbers = new HashSet<String>();
                    longNumbers.add(longNumber);
                    int index = longNumber.indexOf("!", 0);
                    String lNumber = null;
                    while (index > 0) {
                        lNumber = longNumber.substring(0, index);
                        if (!StringUtil.isEmpty((String)lNumber)) {
                            longNumbers.add(lNumber);
                        }
                        index = longNumber.indexOf("!", index + 1);
                    }
                    filterInfo.getFilterItems().add(new FilterItemInfo("materialGroup.longNumber", longNumbers, CompareType.INCLUDE));
                    filterInfo.getFilterItems().add(new FilterItemInfo("materialStorageAssign.storageAssignType", (Object)"1", CompareType.EQUALS));
                    maskString.append(" #0 and (#1 or (#2 and #3)) ");
                    conditionCount += 2;
                } else {
                    maskString.append(" #0 and #1 ");
                }
                if (isStarted != -1) {
                    filterInfo.getFilterItems().add(new FilterItemInfo("SOWH.ISSTARTED", (Object)new Integer(isStarted), CompareType.EQUALS));
                    maskString.append(" and #" + conditionCount);
                }
                maskString.append(" )");
                filterInfo.setMaskString(maskString.toString());
                viewInfo.setFilter(filterInfo);
                kDBizPromptBoxWarehouse.setEntityViewInfo(viewInfo);
                kDBizPromptBoxWarehouse.getQueryAgent().resetRuntimeEntityView();
            }
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
    }

    public static void setWarehouseFitlerByMSRelation(StorageOrgUnitInfo sou, KDTable kdtEntry, String fieldName, int isStarted) {
        try {
            if (sou != null) {
                KDTDefaultCellEditor editor;
                KDBizPromptBox kDBizPromptBoxWarehouse = null;
                if (kdtEntry.getColumn(fieldName).getEditor() != null && null != (editor = (KDTDefaultCellEditor)kdtEntry.getColumn(fieldName).getEditor()) && editor.getComponent() != null) {
                    kDBizPromptBoxWarehouse = (KDBizPromptBox)editor.getComponent();
                }
                if (kDBizPromptBoxWarehouse == null) {
                    kDBizPromptBoxWarehouse = new KDBizPromptBox();
                }
                kDBizPromptBoxWarehouse.setEditable(true);
                kDBizPromptBoxWarehouse.setQueryInfo("com.kingdee.eas.basedata.scm.im.inv.app.F7WarehouseByMSAssignQuery");
                kDBizPromptBoxWarehouse.setDisplayFormat("$name$");
                kDBizPromptBoxWarehouse.setEditFormat("$number$");
                kDBizPromptBoxWarehouse.setCommitFormat("$number$;$name$");
                kDBizPromptBoxWarehouse.getQueryAgent().resetRuntimeEntityView();
                kdtEntry.getColumn(fieldName).getStyleAttributes().setLocked(false);
                kdtEntry.getColumn(fieldName).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)kDBizPromptBoxWarehouse));
            } else {
                kdtEntry.getColumn(fieldName).getStyleAttributes().setLocked(true);
            }
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
    }

    public static void setWarehouseFitlerByMSRelationFilter(StorageOrgUnitInfo sou, MaterialInfo materialInfo, KDTable kdtEntry, String fieldName, int isStarted) {
        try {
            if (sou != null && materialInfo != null) {
                KDTDefaultCellEditor editor;
                KDBizPromptBox kDBizPromptBoxWarehouse = null;
                if (kdtEntry.getColumn(fieldName).getEditor() != null && null != (editor = (KDTDefaultCellEditor)kdtEntry.getColumn(fieldName).getEditor()) && editor.getComponent() != null) {
                    kDBizPromptBoxWarehouse = (KDBizPromptBox)editor.getComponent();
                }
                if (null == kDBizPromptBoxWarehouse) {
                    return;
                }
                EntityViewInfo viewInfo = new EntityViewInfo();
                FilterInfo filterInfo = new FilterInfo();
                filterInfo.getFilterItems().add(new FilterItemInfo("assignStorageOrgUnit.id", (Object)sou.getId().toString(), CompareType.EQUALS));
                filterInfo.getFilterItems().add(new FilterItemInfo("assignMaterial.id", (Object)materialInfo.getId().toString(), CompareType.EQUALS));
                int conditionCount = 2;
                StringBuffer maskString = new StringBuffer("( ");
                MaterialGroupInfo materialGroupInfo = InvClientUtils.getMaterialGroupByMaterial(materialInfo);
                if (null != materialGroupInfo) {
                    String longNumber = materialGroupInfo.getLongNumber();
                    HashSet<String> longNumbers = new HashSet<String>();
                    longNumbers.add(longNumber);
                    int index = longNumber.indexOf("!", 0);
                    String lNumber = null;
                    while (index > 0) {
                        lNumber = longNumber.substring(0, index);
                        if (!StringUtil.isEmpty((String)lNumber)) {
                            longNumbers.add(lNumber);
                        }
                        index = longNumber.indexOf("!", index + 1);
                    }
                    filterInfo.getFilterItems().add(new FilterItemInfo("materialGroup.longNumber", longNumbers, CompareType.INCLUDE));
                    filterInfo.getFilterItems().add(new FilterItemInfo("materialStorageAssign.storageAssignType", (Object)"1", CompareType.EQUALS));
                    maskString.append(" #0 and (#1 or (#2 and #3)) ");
                    conditionCount += 2;
                } else {
                    maskString.append(" #0 and #1 ");
                }
                if (isStarted != -1) {
                    filterInfo.getFilterItems().add(new FilterItemInfo("SOWH.ISSTARTED", (Object)new Integer(isStarted), CompareType.EQUALS));
                    maskString.append(" and #" + conditionCount);
                }
                maskString.append(" )");
                filterInfo.setMaskString(maskString.toString());
                viewInfo.setFilter(filterInfo);
                kDBizPromptBoxWarehouse.setEntityViewInfo(viewInfo);
                kDBizPromptBoxWarehouse.getQueryAgent().resetRuntimeEntityView();
            } else {
                kdtEntry.getColumn(fieldName).getStyleAttributes().setLocked(true);
            }
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
    }

    public static Set<String> getAdminOrgIdSetFromStorageOrgUnits(String storageOrgUnitNumbers) {
        HashSet<String> souIdSet = new HashSet<String>();
        HashSet<String> adminOrgSet = new HashSet<String>();
        if (!StringUtil.isEmpty((String)storageOrgUnitNumbers)) {
            OrgUnitInfo[] orgUnitInfosByNumber = SCMGroupClientUtils.getOrgUnitInfosByNumber((String)storageOrgUnitNumbers);
            for (int i = 0; i < orgUnitInfosByNumber.length; ++i) {
                souIdSet.add(orgUnitInfosByNumber[i].getId().toString());
            }
            if (souIdSet.size() > 0) {
                EntityViewInfo view = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("fromUnit", souIdSet, CompareType.INCLUDE));
                filter.appendFilterItem("typeRelation.fromType", (Object)4);
                filter.appendFilterItem("typeRelation.toType", (Object)0);
                filter.setMaskString("#0 and #1 and #2");
                view.setFilter(filter);
                view.getSelector().add("toUnit.id");
                view.getSelector().add("fromUnit.id");
                OrgUnitRelationCollection ourCol = new OrgUnitRelationCollection();
                try {
                    ourCol = OrgUnitRelationFactory.getRemoteInstance().getOrgUnitRelationCollection(view);
                }
                catch (BOSException e) {
                    ExceptionHandler.handle((Throwable)e);
                }
                int size = ourCol.size();
                for (int i = 0; i < size; ++i) {
                    adminOrgSet.add(ourCol.get(i).getToUnit().getId().toString());
                }
            }
        }
        return adminOrgSet;
    }

    public static void setColLock(KDTable detailTable, int[] lockColIndexs, int row, boolean isLock) {
        if (detailTable != null && lockColIndexs != null) {
            int cols = lockColIndexs.length;
            IRow curRow = detailTable.getRow(row);
            for (int i = 0; i < cols; ++i) {
                curRow.getCell(lockColIndexs[i]).getStyleAttributes().setLocked(isLock);
            }
        }
    }
}

