/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.data.logging.Logger;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.framework.util.EntityControlTypeUtil;
import com.kingdee.eas.basedata.master.material.IMaterialGroupStandard;
import com.kingdee.eas.basedata.master.material.MaterialGroupStandardCollection;
import com.kingdee.eas.basedata.master.material.MaterialGroupStandardFactory;
import com.kingdee.eas.basedata.master.material.MaterialGroupStandardInfo;
import com.kingdee.eas.basedata.master.material.MaterialGroupStandardTypeEnum;
import com.kingdee.eas.basedata.master.material.StoreType;
import com.kingdee.eas.basedata.master.material.client.F7MaterialMultiUISelectorAdaptor;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.client.f7.SCMRptMultiOrgsF7;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.util.ReportQueryConditionHelper;
import com.kingdee.eas.scm.im.inv.client.AbstractInvOverShortAnalyseFilterUI;
import com.kingdee.eas.scm.im.inv.client.InvClientUtils;
import com.kingdee.eas.scm.im.rpt.IMRptUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Iterator;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;

public class InvOverShortAnalyseFilterUI
extends AbstractInvOverShortAnalyseFilterUI {
    private static final long serialVersionUID = -4244577701207893973L;
    private static final String permItem = "invovershortanaly_view";
    private static final String resClassName = "com.kingdee.eas.scm.im.rpt.IMRptResource";
    private static SCMRptMultiOrgsF7 f7;
    public static final String CTX_ONLY_BASE_SRANDARD = "onlyBaseStandard";
    public static final String CTX_GROUP_STANDARD = "groupStandard";
    public static final String CTX_CU = "cu";
    private CtrlUnitInfo curCtrlUnitInfo;

    public InvOverShortAnalyseFilterUI() throws Exception {
        this.addCkBxSimpleNameListener();
        f7 = new SCMRptMultiOrgsF7(this.bizPromptStorageOrgFrom, OrgType.Storage, permItem, EASResource.getString((String)resClassName, (String)"storageOrgUnitMutilF7"));
        f7.setUseCache(false);
        this.setSize(508, 300);
        this.addF7Listener();
    }

    private void loadGroupStandard() throws Exception {
        MaterialGroupStandardInfo groupStandard = null;
        Boolean onlyBaseStandard = (Boolean)this.getUIContext().get(CTX_ONLY_BASE_SRANDARD);
        if (onlyBaseStandard != null && onlyBaseStandard.booleanValue()) {
            IMaterialGroupStandard iBiz = MaterialGroupStandardFactory.getRemoteInstance();
            MaterialGroupStandardCollection baseGroupStandardColl = iBiz.getBaseMaterialGroupStandardColl();
            if (baseGroupStandardColl.size() > 0) {
                groupStandard = baseGroupStandardColl.get(0);
            }
        } else {
            groupStandard = (MaterialGroupStandardInfo)this.getUIContext().get(CTX_GROUP_STANDARD);
        }
        if (groupStandard != null) {
            this.comboGroupStandard.removeAllItems();
            this.comboGroupStandard.addItem((Object)groupStandard);
            this.comboGroupStandard.setSelectedIndex(0);
        } else {
            IMaterialGroupStandard iMaterialGroupStandard = MaterialGroupStandardFactory.getRemoteInstance();
            FilterInfo filterInfoCU = EntityControlTypeUtil.getFilterInfoForControlTypeS4((String)this.curCtrlUnitInfo.getId().toString(), (String)this.curCtrlUnitInfo.getLongNumber());
            EntityViewInfo viewInfo = new EntityViewInfo();
            viewInfo.setFilter(filterInfoCU);
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("name"));
            sic.add(new SelectorItemInfo("number"));
            sic.add(new SelectorItemInfo("standardType"));
            viewInfo.setSelector(sic);
            MaterialGroupStandardCollection groupStandardColl = iMaterialGroupStandard.getMaterialGroupStandardCollection(viewInfo);
            this.comboGroupStandard.removeAllItems();
            if (groupStandardColl != null) {
                this.comboGroupStandard.addItems(groupStandardColl.toArray());
            }
            int defaultIndex = 0;
            int size = groupStandardColl.size();
            for (int index = 0; index < size; ++index) {
                if (!groupStandardColl.get(index).getStandardType().equals((Object)MaterialGroupStandardTypeEnum.BasicStandard)) continue;
                defaultIndex = index;
                break;
            }
            this.comboGroupStandard.setSelectedIndex(defaultIndex);
        }
    }

    @Override
    public void loadFields() {
        this.curCtrlUnitInfo = (CtrlUnitInfo)this.getUIContext().get(CTX_CU);
        if (this.curCtrlUnitInfo == null) {
            // empty if block
        }
        if (this.curCtrlUnitInfo == null) {
            this.curCtrlUnitInfo = SysContext.getSysContext().getCurrentCtrlUnit();
        }
        try {
            this.loadGroupStandard();
        }
        catch (Exception e) {
            Logger.error((Throwable)e);
        }
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void clear() {
        this.bizPromptStorageOrgFrom.setValue((Object)this.getDefaultMainBizOrg());
        this.bizPromptMaterialNumFrom.setValue(null);
        this.bizPromptMaterialNumTo.setValue(null);
        this.comboBoxStoreType.setSelectedIndex(-1);
        this.prmtStoreState.setValue(null);
        this.ckBxShowMShortName.setSelected(false);
        this.txtMShortNameFrom.setText(null);
        this.txtMShortNameTo.setText(null);
        try {
            this.loadGroupStandard();
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    public void onInit(RptParams initParams) throws Exception {
        SCMClientUtils.setSotrageOrgF7((KDBizPromptBox)this.bizPromptStorageOrgFrom);
        InvClientUtils.getMaterialF7ForReportFilterUI(this.bizPromptMaterialNumFrom, (Object)this);
        InvClientUtils.getMaterialF7ForReportFilterUI(this.bizPromptMaterialNumTo, (Object)this);
        this.bizPromptMaterialNumFrom.setEnabledMultiSelection(true);
        F7MaterialMultiUISelectorAdaptor selectorMaterial = (F7MaterialMultiUISelectorAdaptor)this.bizPromptMaterialNumFrom.getSelector();
        selectorMaterial.setIsMultiSelect(true);
        SCMClientUtils.addListenerForMultiF7((KDBizPromptBox)this.bizPromptMaterialNumFrom, (KDBizPromptBox)this.bizPromptMaterialNumTo);
        this.loadStoreTypeEnum((JComboBox)this.comboBoxStoreType);
        this.comboBoxStoreType.setSelectedIndex(-1);
    }

    public RptParams getCustomCondition() {
        RptParams rptParam = new RptParams();
        rptParam.setObject("storageOrgFrom", f7.getFullData());
        rptParam.setObject("bizstorageOrgFrom", this.bizPromptStorageOrgFrom.getValue());
        rptParam.setObject("materialGroupStandard", this.comboGroupStandard.getSelectedItem());
        rptParam.setObject("materialTypeFrom", this.bizMaterialTypeFrom.getValue());
        rptParam.setObject("materialTypeTo", this.bizMaterialTypeTo.getValue());
        rptParam.setObject("materialNumFrom", this.bizPromptMaterialNumFrom.getValue());
        rptParam.setObject("materialNumTo", this.bizPromptMaterialNumTo.getValue());
        rptParam.setObject("storeType", this.comboBoxStoreType.getSelectedItem());
        rptParam.setObject("storeState", this.prmtStoreState.getValue());
        rptParam.setObject("ckBxShowMShortName", (Object)this.ckBxShowMShortName.isSelected());
        rptParam.setObject("shortNameFrom", (Object)this.txtMShortNameFrom.getText());
        rptParam.setObject("shortNameTo", (Object)this.txtMShortNameTo.getText());
        return rptParam;
    }

    public void setCustomCondition(RptParams params) {
        if (params == null) {
            return;
        }
        this.bizPromptStorageOrgFrom.setValue(params.getObject("bizstorageOrgFrom"));
        this.comboGroupStandard.setSelectedItem(params.getObject("materialGroupStandard"));
        this.bizMaterialTypeFrom.setValue(params.getObject("materialTypeFrom"));
        this.bizMaterialTypeTo.setValue(params.getObject("materialTypeTo"));
        this.bizPromptMaterialNumFrom.setValue(params.getObject("materialNumFrom"));
        this.bizPromptMaterialNumTo.setValue(params.getObject("materialNumTo"));
        this.comboBoxStoreType.setSelectedItem(params.getObject("storeType"));
        this.prmtStoreState.setValue(params.getObject("storeState"));
        if ((Boolean)params.getObject("ckBxShowMShortName") != null) {
            this.ckBxShowMShortName.setSelected(((Boolean)params.getObject("ckBxShowMShortName")).booleanValue());
        } else {
            this.ckBxShowMShortName.setSelected(false);
        }
        this.txtMShortNameFrom.setText((String)params.getObject("shortNameFrom"));
        this.txtMShortNameTo.setText((String)params.getObject("shortNameTo"));
    }

    public CustomerParams getCustomerParams() {
        CustomerParams customerParams = new CustomerParams();
        ReportQueryConditionHelper.fillCustomerParams((CustomerParams)customerParams, (Container)((Object)this));
        return customerParams;
    }

    public void setCustomerParams(CustomerParams cp) {
        if (cp != null && cp.getCustomerParam("RPTPARAMS_KEY_AT_CUSTOMERPARAMS") != null) {
            return;
        }
        this.clear();
        ReportQueryConditionHelper.fillComponent((Container)((Object)this), (CustomerParams)cp);
    }

    private void loadStoreTypeEnum(JComboBox cb) {
        DefaultComboBoxModel<StoreType> model = new DefaultComboBoxModel<StoreType>();
        Iterator i = StoreType.iterator();
        while (i.hasNext()) {
            StoreType e = (StoreType)i.next();
            model.addElement(e);
        }
        cb.setModel(model);
    }

    protected void addF7Listener() {
        this.bizPromptStorageOrgFrom.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                try {
                    InvOverShortAnalyseFilterUI.this.bizPromptStorageOrgFrom_dataChanged(e);
                }
                catch (Exception e1) {
                    Logger.error((Throwable)e1);
                }
            }
        });
        this.bizPromptMaterialNumFrom.addSelectorListener(new SelectorListener(){

            public void willShow(SelectorEvent e) {
                InvOverShortAnalyseFilterUI.this.bizPromptMaterial_willShow(e);
            }
        });
        this.bizPromptMaterialNumTo.addSelectorListener(new SelectorListener(){

            public void willShow(SelectorEvent e) {
                InvOverShortAnalyseFilterUI.this.bizPromptMaterial_willShow(e);
            }
        });
        this.comboGroupStandard.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                InvOverShortAnalyseFilterUI.this.comboGroupStandard_itemStateChanged(e);
            }
        });
    }

    private void comboGroupStandard_itemStateChanged(ItemEvent e) {
        Object o = e.getItem();
        MaterialGroupStandardInfo groupInfo = null;
        if (o != null && o instanceof MaterialGroupStandardInfo) {
            groupInfo = (MaterialGroupStandardInfo)o;
        }
        if (this.bizMaterialTypeFrom != null || this.bizMaterialTypeTo != null) {
            this.bizMaterialTypeFrom.setValue(null);
            this.bizMaterialTypeTo.setValue(null);
        }
        if (groupInfo != null) {
            IMRptUtils.setBizMaterialGroup(this.bizMaterialTypeFrom, groupInfo.getId().toString());
            IMRptUtils.setBizMaterialGroup(this.bizMaterialTypeTo, groupInfo.getId().toString());
        }
    }

    protected void bizPromptMaterial_willShow(SelectorEvent e) {
        this.storageOrgUnitCheck();
    }

    protected void bizPromptStorageOrgFrom_dataChanged(DataChangeEvent e) {
        Object[] fullStorageOrgUnit = (Object[])this.bizPromptStorageOrgFrom.getValue();
        if (fullStorageOrgUnit != null) {
            OrgUnitCollection orgColl = new OrgUnitCollection();
            for (int i = 0; i < fullStorageOrgUnit.length; ++i) {
                orgColl.add((OrgUnitInfo)((FullOrgUnitInfo)fullStorageOrgUnit[i]));
            }
        }
    }

    protected void storageOrgUnitCheck() {
        Object[] storageOrg;
        if (this.bizPromptStorageOrgFrom.getValue() == null || ((Object[])this.bizPromptStorageOrgFrom.getValue()).length == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)resClassName, (String)"storageOrgUnitNotNull"));
            SysUtil.abort();
        } else if (((Object[])this.bizPromptStorageOrgFrom.getValue()).length == 1 && ((storageOrg = (Object[])this.bizPromptStorageOrgFrom.getValue())[0] == null || storageOrg[0].toString().length() == 0)) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)resClassName, (String)"storageOrgUnitNotNull"));
            SysUtil.abort();
        }
    }

    public boolean verify() {
        this.storageOrgUnitCheck();
        return true;
    }

    protected void addCkBxSimpleNameListener() {
        this.ckBxShowMShortName.setVisible(true);
        this.txtMShortNameFrom.setVisible(true);
        this.txtMShortNameTo.setVisible(true);
        this.ckBxShowMShortName.setSelected(false);
        this.txtMShortNameFrom.setEnabled(false);
        this.txtMShortNameTo.setEnabled(false);
        this.ckBxShowMShortName.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                try {
                    InvOverShortAnalyseFilterUI.this.ckBxShowMShortName_itemStateChanged(e);
                }
                catch (Exception exc) {
                    InvOverShortAnalyseFilterUI.this.handUIException(exc);
                }
            }
        });
    }

    protected void ckBxShowMShortName_itemStateChanged(ItemEvent e) throws Exception {
        boolean isSelected = this.ckBxShowMShortName.isSelected();
        this.txtMShortNameFrom.setText(null);
        this.txtMShortNameTo.setText(null);
        if (isSelected) {
            this.txtMShortNameFrom.setEnabled(true);
            this.txtMShortNameTo.setEnabled(true);
        } else {
            this.txtMShortNameFrom.setEnabled(false);
            this.txtMShortNameTo.setEnabled(false);
        }
    }

    @Override
    public boolean isPrepareInit() {
        return true;
    }

    protected OrgUnitInfo[] getDefaultMainBizOrg() {
        try {
            OrgUnitInfo currentMainOrg = SysContext.getSysContext().getCurrentOrgUnit(OrgType.Storage);
            String userId = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
            return IMRptUtils.getDefaultMainBizOrg(currentMainOrg, userId, OrgType.Storage, permItem);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        catch (EASBizException e) {
            this.handUIException(e);
        }
        return null;
    }
}

