/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDSpinner;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.client.f7.NewCompanyF7;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.scm.im.inv.client.AbstractInventoryCheckAccountFilterUI;
import javax.swing.JSpinner;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class InventoryCheckAccountFilterUI
extends AbstractInventoryCheckAccountFilterUI
implements KDTEditListener,
DataChangeListener,
ChangeListener {
    private static final Logger logger = CoreUIObject.getLogger(InventoryCheckAccountFilterUI.class);

    public void onLoad() throws Exception {
        super.onLoad();
        this.bizCompnayOrg.addDataChangeListener((DataChangeListener)this);
        this.spnYearFrom.addChangeListener((ChangeListener)this);
        this.spnYearTo.addChangeListener((ChangeListener)this);
        this.bizCompnayOrg.setValue((Object)SysContext.getSysContext().getCurrentFIUnit());
        NewCompanyF7 comF7 = new NewCompanyF7();
        comF7.setMultiSelect(false);
        comF7.setIsCUFilter(true);
        comF7.setNeedAddOrgRange(false);
        this.bizCompnayOrg.setSelector((KDPromptSelector)comF7);
        this.loadAccountPeriod((CompanyOrgUnitInfo)this.bizCompnayOrg.getData(), true);
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    private void loadAccountPeriod(CompanyOrgUnitInfo companyInfo, boolean isSetInitValue) throws EASBizException, BOSException {
        PeriodInfo curPeriodInfo = SystemStatusCtrolUtils.getCurrentPeriod(null, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)companyInfo);
        PeriodInfo periodInfo = SystemStatusCtrolUtils.getStartPeriod(null, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)companyInfo);
        int minYear = periodInfo.getPeriodYear();
        int maxYear = 2199;
        int minMonth = 1;
        int maxMonth = 12;
        this.SetSpinnerMaxMin((JSpinner)this.spnYearFrom, minYear, maxYear);
        this.SetSpinnerMaxMin((JSpinner)this.spnYearTo, minYear, maxYear);
        this.SetSpinnerMaxMin((JSpinner)this.spnPeriodFrom, minMonth, maxMonth);
        this.SetSpinnerMaxMin((JSpinner)this.spnPeriodTo, minMonth, maxMonth);
        if (isSetInitValue) {
            this.setInitAccountPeriod(curPeriodInfo);
        }
    }

    private void SetSpinnerMaxMin(JSpinner spinner, int min, int max) {
        SpinnerModel model = spinner.getModel();
        if (model instanceof SpinnerNumberModel) {
            if (max > min) {
                ((SpinnerNumberModel)model).setMaximum(new Integer(max));
            }
            ((SpinnerNumberModel)model).setMinimum(new Integer(min));
        }
    }

    private void setInitAccountPeriod(PeriodInfo curPeriodInfo) {
        this.spnYearFrom.setValue((Object)new Integer(curPeriodInfo.getPeriodYear()));
        this.spnYearTo.setValue((Object)new Integer(curPeriodInfo.getPeriodYear()));
        this.spnPeriodFrom.setValue((Object)new Integer(curPeriodInfo.getPeriodNumber()));
        this.spnPeriodTo.setValue((Object)new Integer(curPeriodInfo.getPeriodNumber()));
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        CompanyOrgUnitInfo aCompanyOrgUnitInfo = (CompanyOrgUnitInfo)this.bizCompnayOrg.getData();
        KDSpinner aSpinner = (KDSpinner)e.getSource();
        PeriodInfo periodInfo = null;
        try {
            periodInfo = SystemStatusCtrolUtils.getStartPeriod(null, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)aCompanyOrgUnitInfo);
        }
        catch (EASBizException e2) {
            this.handUIException(e2);
        }
        catch (BOSException e2) {
            this.handUIException(e2);
        }
        int startYear = periodInfo.getPeriodYear();
        int startMonth = periodInfo.getPeriodNumber();
        try {
            int minPeriod = PeriodUtils.getMinPeriodNumber(null, (int)Integer.parseInt(aSpinner.getValue().toString()), (String)aCompanyOrgUnitInfo.getId().toString());
            int maxPeriod = PeriodUtils.getMaxPeriodNumber(null, (int)Integer.parseInt(aSpinner.getValue().toString()), (String)aCompanyOrgUnitInfo.getId().toString());
            if (aSpinner.getName().toString().equals("spnYearFrom")) {
                if (Integer.parseInt(aSpinner.getValue().toString()) == startYear) {
                    minPeriod = startMonth;
                }
                this.SetSpinnerMaxMin((JSpinner)this.spnPeriodFrom, minPeriod, maxPeriod);
                int curPeriod = Integer.parseInt(this.spnPeriodFrom.getValue().toString());
                if (curPeriod < minPeriod || curPeriod > maxPeriod) {
                    this.spnPeriodFrom.setValue((Object)new Integer(maxPeriod));
                }
            } else if (aSpinner.getName().toString().equals("spnYearTo")) {
                if (Integer.parseInt(aSpinner.getValue().toString()) == startYear) {
                    minPeriod = startMonth;
                }
                this.SetSpinnerMaxMin((JSpinner)this.spnPeriodTo, minPeriod, maxPeriod);
                int curPeriod = Integer.parseInt(this.spnPeriodFrom.getValue().toString());
                if (curPeriod < minPeriod || curPeriod > maxPeriod) {
                    this.spnPeriodTo.setValue((Object)new Integer(maxPeriod));
                }
            }
        }
        catch (EASBizException e1) {
            this.handUIException(e1);
        }
        catch (NumberFormatException e1) {
            this.handUIException(e1);
        }
        catch (BOSException e1) {
            this.handUIException(e1);
        }
    }

    public void editStarting(KDTEditEvent e) {
    }

    public void editStarted(KDTEditEvent e) {
    }

    public void editValueChanged(KDTEditEvent e) {
    }

    public void editStopping(KDTEditEvent e) {
    }

    public void editStopped(KDTEditEvent e) {
    }

    public void editCanceled(KDTEditEvent e) {
    }

    public void dataChanged(DataChangeEvent eventObj) {
    }
}

