/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.scm.im.inv.IInventoryCheckAccount;
import com.kingdee.eas.scm.im.inv.InventoryCheckAccountFactory;
import com.kingdee.eas.scm.im.inv.client.AbstractInventoryCheckAccountListUI;
import com.kingdee.eas.scm.im.inv.client.InventoryCheckAccountFilterUI;
import com.kingdee.eas.util.client.EASResource;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.apache.log4j.Logger;

public class InventoryCheckAccountListUI
extends AbstractInventoryCheckAccountListUI {
    private static final Logger logger = CoreUIObject.getLogger(InventoryCheckAccountListUI.class);
    private static final String ResourcePath = "com.kingdee.eas.scm.im.inv.WarehsManageResource";
    CommonQueryDialog commonQueryDialog;
    InventoryCheckAccountFilterUI invCheckAccountFilterUI;

    public InventoryCheckAccountListUI() throws Exception {
        this.popFilterDialog();
        this.InitToolBar();
        this.fillHead();
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public String getUITitle() {
        return EASResource.getString((String)ResourcePath, (String)"inventoryCheckAccount");
    }

    private void popFilterDialog() throws Exception {
        if (this.commonQueryDialog == null) {
            this.commonQueryDialog = new CommonQueryDialog();
            this.commonQueryDialog.setOwner((Component)this.getUIContext().get("Owner"));
            this.commonQueryDialog.setParentUIClassName(this.getMetaDataPK().getFullName());
            MetaDataPK queryPK = new MetaDataPK("com.kingdee.eas.framework.report.app", "CommRptEmptyQuery");
            this.commonQueryDialog.setQueryObjectPK((IMetaDataPK)queryPK);
            this.commonQueryDialog.setShowFilter(false);
            this.commonQueryDialog.setShowSorter(false);
            this.commonQueryDialog.setShowToolbar(true);
            this.invCheckAccountFilterUI = new InventoryCheckAccountFilterUI();
            this.invCheckAccountFilterUI.setPanelName(EASResource.getString((String)"com.kingdee.eas.scm.im.inv.WarehsManageResource.inventoryCheckAccount"));
            this.commonQueryDialog.addUserPanel((KDPanel)this.invCheckAccountFilterUI);
            this.commonQueryDialog.show();
        }
    }

    public void fillHead() {
        String accountPeriod = EASResource.getString((String)ResourcePath, (String)"AccountPeriod");
        String year = EASResource.getString((String)ResourcePath, (String)"Year");
        String period = EASResource.getString((String)ResourcePath, (String)"Period");
        String account = EASResource.getString((String)ResourcePath, (String)"account");
        String accountCode = EASResource.getString((String)ResourcePath, (String)"accountCode");
        String accountName = EASResource.getString((String)ResourcePath, (String)"accountName");
        String beginAmount = EASResource.getString((String)ResourcePath, (String)"beginAmount");
        String endAmount = EASResource.getString((String)ResourcePath, (String)"endAmount");
        String diffAmount = EASResource.getString((String)ResourcePath, (String)"diffAmount");
        String inventoryTotal = EASResource.getString((String)ResourcePath, (String)"inventoryTotal");
        String accountBalance = EASResource.getString((String)ResourcePath, (String)"accountBalance");
        String debitFor = EASResource.getString((String)ResourcePath, (String)"debitFor");
        String creditFor = EASResource.getString((String)ResourcePath, (String)"creditFor");
        this.tblMain.addColumns(16);
        this.tblMain.getColumn(0).setKey("year");
        this.tblMain.getColumn(1).setKey("period");
        this.tblMain.getColumn(2).setKey("accountCode");
        this.tblMain.getColumn(3).setKey("accountName");
        this.tblMain.getColumn(4).setKey("inventoryBegin");
        this.tblMain.getColumn(5).setKey("accountBegin");
        this.tblMain.getColumn(6).setKey("diffBegin");
        this.tblMain.getColumn(7).setKey("inventoryDebit");
        this.tblMain.getColumn(8).setKey("accountDebit");
        this.tblMain.getColumn(9).setKey("diffDebit");
        this.tblMain.getColumn(10).setKey("inventoryCredit");
        this.tblMain.getColumn(11).setKey("accountCredit");
        this.tblMain.getColumn(12).setKey("diffCredit");
        this.tblMain.getColumn(13).setKey("inventoryEnd");
        this.tblMain.getColumn(14).setKey("accountEnd");
        this.tblMain.getColumn(15).setKey("diffEnd");
        this.tblMain.addHeadRows(2);
        IRow headRow = this.tblMain.getHeadRow(0);
        headRow.getCell(0).setValue((Object)accountPeriod);
        this.tblMain.getHeadMergeManager().mergeBlock(0, 0, 0, 1);
        headRow.getCell(2).setValue((Object)account);
        this.tblMain.getHeadMergeManager().mergeBlock(0, 2, 0, 3);
        headRow.getCell(4).setValue((Object)beginAmount);
        this.tblMain.getHeadMergeManager().mergeBlock(0, 4, 0, 6);
        headRow.getCell(7).setValue((Object)debitFor);
        this.tblMain.getHeadMergeManager().mergeBlock(0, 7, 0, 9);
        headRow.getCell(10).setValue((Object)creditFor);
        this.tblMain.getHeadMergeManager().mergeBlock(0, 10, 0, 12);
        headRow.getCell(13).setValue((Object)endAmount);
        this.tblMain.getHeadMergeManager().mergeBlock(0, 13, 0, 15);
        headRow = this.tblMain.getHeadRow(1);
        headRow.getCell(0).setValue((Object)year);
        headRow.getCell(1).setValue((Object)period);
        headRow.getCell(2).setValue((Object)accountCode);
        headRow.getCell(3).setValue((Object)accountName);
        headRow.getCell(4).setValue((Object)inventoryTotal);
        headRow.getCell(5).setValue((Object)accountBalance);
        headRow.getCell(6).setValue((Object)diffAmount);
        headRow.getCell(7).setValue((Object)inventoryTotal);
        headRow.getCell(8).setValue((Object)accountBalance);
        headRow.getCell(9).setValue((Object)diffAmount);
        headRow.getCell(10).setValue((Object)inventoryTotal);
        headRow.getCell(11).setValue((Object)accountBalance);
        headRow.getCell(12).setValue((Object)diffAmount);
        headRow.getCell(13).setValue((Object)inventoryTotal);
        headRow.getCell(14).setValue((Object)accountBalance);
        headRow.getCell(15).setValue((Object)diffAmount);
    }

    public void InitToolBar() {
        this.btnRefresh.setText(EASResource.getString((String)"com.kingdee.eas.scm.im.inv.WarehsManageResource.refresh"));
        this.btnRefresh.setToolTipText(EASResource.getString((String)"com.kingdee.eas.scm.im.inv.WarehsManageResource.refresh"));
        this.btnRefresh.setIcon(EASResource.getIcon((String)"imgTbtn_refresh"));
        this.btnPrint.setText(EASResource.getString((String)"com.kingdee.eas.scm.im.inv.WarehsManageResource.print"));
        this.btnPrint.setToolTipText(EASResource.getString((String)"com.kingdee.eas.scm.im.inv.WarehsManageResource.print"));
        this.btnPrint.setIcon(EASResource.getIcon((String)"imgTbtn_print"));
        this.btnPrintPreview.setText(EASResource.getString((String)"com.kingdee.eas.scm.im.inv.WarehsManageResource.printPreview"));
        this.btnPrintPreview.setToolTipText(EASResource.getString((String)"com.kingdee.eas.scm.im.inv.WarehsManageResource.printPreview"));
        this.btnPrintPreview.setIcon(EASResource.getIcon((String)"imgTbtn_preview"));
        this.btnExport.setText(EASResource.getString((String)"com.kingdee.eas.scm.im.inv.WarehsManageResource.Export"));
        this.btnExport.setToolTipText(EASResource.getString((String)"com.kingdee.eas.scm.im.inv.WarehsManageResource.Export"));
        this.btnExport.setIcon(EASResource.getIcon((String)"imgTbtn_output"));
        this.btnQurey.setText(EASResource.getString((String)"com.kingdee.eas.scm.im.inv.WarehsManageResource.Query"));
        this.btnQurey.setToolTipText(EASResource.getString((String)"com.kingdee.eas.scm.im.inv.WarehsManageResource.Query"));
        this.btnQurey.setIcon(EASResource.getIcon((String)"imgTbtn_filter"));
        this.btnPrint.setEnabled(true);
        this.btnRefresh.setEnabled(true);
        this.btnPrintPreview.setEnabled(true);
        this.btnExport.setEnabled(true);
        this.btnQurey.setEnabled(true);
    }

    public void fillBody(RptParams rptParams) throws EASBizException, BOSException {
        IInventoryCheckAccount invCkAcct = InventoryCheckAccountFactory.getRemoteInstance();
        List mlist = invCkAcct.getInventoryAccount(rptParams);
        Iterator it = mlist.iterator();
        while (it.hasNext()) {
            IRow curRow = this.tblMain.addRow();
            Vector v = (Vector)it.next();
            curRow.getCell(0).setValue((Object)((String)v.get(1)));
            curRow.getCell(1).setValue((Object)((String)v.get(2)));
            curRow.getCell(2).setValue((Object)((BigDecimal)v.get(3)));
            curRow.getCell(4).setValue((Object)((BigDecimal)v.get(4)));
            curRow.getCell(6).setValue((Object)((BigDecimal)v.get(5)));
        }
    }

    public void actionPageSetup_actionPerformed(ActionEvent e) throws Exception {
        super.actionPageSetup_actionPerformed(e);
    }

    public void actionExitCurrent_actionPerformed(ActionEvent e) throws Exception {
        super.actionExitCurrent_actionPerformed(e);
    }

    public void actionHelp_actionPerformed(ActionEvent e) throws Exception {
        super.actionHelp_actionPerformed(e);
    }

    public void actionAbout_actionPerformed(ActionEvent e) throws Exception {
        super.actionAbout_actionPerformed(e);
    }

    public void actionOnLoad_actionPerformed(ActionEvent e) throws Exception {
        super.actionOnLoad_actionPerformed(e);
    }

    @Override
    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        super.actionRefresh_actionPerformed(e);
    }

    @Override
    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrint_actionPerformed(e);
    }

    @Override
    public void actionPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrintPreview_actionPerformed(e);
    }

    @Override
    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        super.actionQuery_actionPerformed(e);
    }

    @Override
    public void actionExport_actionPerformed(ActionEvent e) throws Exception {
        super.actionExport_actionPerformed(e);
    }
}

