/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.framework.util.EntityControlTypeUtil;
import com.kingdee.eas.basedata.master.material.AsstAttrValueInfo;
import com.kingdee.eas.basedata.master.material.IMaterialGroupStandard;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialGroupCollection;
import com.kingdee.eas.basedata.master.material.MaterialGroupFactory;
import com.kingdee.eas.basedata.master.material.MaterialGroupStandardCollection;
import com.kingdee.eas.basedata.master.material.MaterialGroupStandardFactory;
import com.kingdee.eas.basedata.master.material.MaterialGroupStandardInfo;
import com.kingdee.eas.basedata.master.material.MaterialGroupStandardTypeEnum;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.StoreType;
import com.kingdee.eas.basedata.master.material.client.F7MaterialMultiUISelectorAdaptor;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitCollection;
import com.kingdee.eas.basedata.org.StorageOrgUnitFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.scm.im.inv.LocationFactory;
import com.kingdee.eas.basedata.scm.im.inv.LocationInfo;
import com.kingdee.eas.basedata.scm.im.inv.StoreTypeInfo;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseFactory;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.mm.basedata.TrackNumberInfo;
import com.kingdee.eas.mm.common.client.UIHelper;
import com.kingdee.eas.mm.project.ProjectInfo;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.service.SCMServiceFactory;
import com.kingdee.eas.scm.common.util.SortUtil;
import com.kingdee.eas.scm.im.inv.InventoryFacadeFactory;
import com.kingdee.eas.scm.im.inv.client.AbstractInventoryFilterUI;
import com.kingdee.eas.scm.im.inv.client.InvClientUtils;
import com.kingdee.eas.scm.im.rpt.IMRptUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import org.apache.log4j.Logger;

public class InventoryFilterUI
extends AbstractInventoryFilterUI {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = CoreUIObject.getLogger(InventoryFilterUI.class);
    HashMap paramHashMap = null;
    private static final String permItem = "inventory";
    protected StorageOrgUnitInfo storageOrgUnitInfo;
    private DataChangeListener warehouseListener = null;
    private DataChangeListener storageListener = null;
    public static final String CTX_ONLY_BASE_SRANDARD = "onlyBaseStandard";
    public static final String CTX_GROUP_STANDARD = "groupStandard";
    public static final String CTX_CU = "cu";
    private CtrlUnitInfo curCtrlUnitInfo;
    private OrgUnitCollection hasPermOrg = null;
    private int idxDefaultMainOrg = -1;
    private OrgUnitInfo[] mainOrgs = null;
    private FilterInfo materialTypeFilterInfo = null;
    private String materialGroupStandardID = null;

    public InventoryFilterUI() throws Exception {
        if (null != this.warehouseListener) {
            this.bizPromptWarehouseFrom.removeDataChangeListener(this.warehouseListener);
        }
        this.warehouseListener = new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                try {
                    InventoryFilterUI.this.prmtWarehouseForm_dataChanged(eventObj);
                }
                catch (Exception exc) {
                    InventoryFilterUI.this.handUIException(exc);
                }
            }
        };
        this.bizPromptWarehouseFrom.addDataChangeListener(this.warehouseListener);
        if (null != this.storageListener) {
            this.bizPromptStorageOrgFrom.removeDataChangeListener(this.storageListener);
        }
        this.storageListener = new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                try {
                    InventoryFilterUI.this.prmtStorageFrom_dataChanged(eventObj);
                }
                catch (Exception exc) {
                    InventoryFilterUI.this.handUIException(exc);
                }
            }
        };
        this.bizPromptStorageOrgFrom.addDataChangeListener(this.storageListener);
        this.comboGroupStandard.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                InventoryFilterUI.this.comboGroupStandard_itemStateChanged(e);
            }
        });
        UIHelper.registerProjectF7ForFilter((KDBizPromptBox)this.getMainBizOrgF7(), (KDBizPromptBox)this.prmtProjectNumFrom);
        UIHelper.registerProjectF7ForFilter((KDBizPromptBox)this.getMainBizOrgF7(), (KDBizPromptBox)this.prmtProjectNumTo);
        UIHelper.registerTrackNumberF7ForFilter((KDBizPromptBox)this.getMainBizOrgF7(), (KDBizPromptBox)this.prmtTrackNumFrom);
        UIHelper.registerTrackNumberF7ForFilter((KDBizPromptBox)this.getMainBizOrgF7(), (KDBizPromptBox)this.prmtTrackNumTo);
    }

    private void comboGroupStandard_itemStateChanged(ItemEvent e) {
        Object o = e.getItem();
        MaterialGroupStandardInfo groupInfo = null;
        if (o != null && o instanceof MaterialGroupStandardInfo) {
            groupInfo = (MaterialGroupStandardInfo)o;
            this.setMaterialGroupStandard(groupInfo.getId().toString());
        }
        if (this.bizMaterialTypeFrom.getValue() != null || this.bizMaterialTypeTo.getValue() != null) {
            this.bizMaterialTypeFrom.setValue(null);
            this.bizMaterialTypeTo.setValue(null);
        }
        if (groupInfo != null) {
            IMRptUtils.setBizMaterialGroup(this.bizMaterialTypeFrom, groupInfo.getId().toString());
            IMRptUtils.setBizMaterialGroup(this.bizMaterialTypeTo, groupInfo.getId().toString());
        }
    }

    private void prmtWarehouseForm_dataChanged(DataChangeEvent eventObj) {
        String strNumber = this.bizPromptWarehouseFrom.getText();
        if (this.bizPromptWarehouseFrom.getValue() != null && strNumber != null && strNumber.toString().length() > 0) {
            Object[] obj = (Object[])this.bizPromptWarehouseFrom.getValue();
            HashSet<String> set = new HashSet<String>();
            int size = obj.length;
            for (int j = 0; j < size; ++j) {
                WarehouseInfo warehouseInfo = (WarehouseInfo)obj[j];
                set.add(warehouseInfo.getId().toString());
            }
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("Warehouse.id", set, CompareType.INCLUDE));
            EntityViewInfo viewInfo = new EntityViewInfo();
            viewInfo.setFilter(filterInfo);
            this.bizPromptLocationFrom.setEntityViewInfo(viewInfo);
        }
    }

    private void prmtStorageFrom_dataChanged(DataChangeEvent eventObj) {
        String strNumber = this.bizPromptStorageOrgFrom.getText();
        if (this.bizPromptStorageOrgFrom.getValue() != null && strNumber != null && strNumber.toString().length() > 0) {
            Object[] obj = null;
            obj = this.bizPromptStorageOrgFrom.getValue() instanceof Object[] ? (Object[])this.bizPromptStorageOrgFrom.getValue() : new Object[]{(StorageOrgUnitInfo)this.bizPromptStorageOrgFrom.getValue()};
            HashSet<String> set = new HashSet<String>();
            int size = obj.length;
            for (int j = 0; j < size; ++j) {
                StorageOrgUnitInfo storageOrgUnitInfo = (StorageOrgUnitInfo)obj[j];
                set.add(storageOrgUnitInfo.getId().toString());
            }
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("Warehouse.whState", (Object)1, CompareType.EQUALS));
            filterInfo.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", set, CompareType.INCLUDE));
            EntityViewInfo viewInfo = new EntityViewInfo();
            viewInfo.setFilter(filterInfo);
            this.bizPromptWarehouseFrom.setEntityViewInfo(viewInfo);
            InvClientUtils.setMaterialFilterbySou(set, this.bizPromptMaterialNumFrom);
            InvClientUtils.setMaterialFilterbySou(set, this.bizPromptMaterialNumTo);
        }
    }

    private void loadGroupStandard() throws Exception {
        MaterialGroupStandardInfo groupStandard = null;
        Boolean onlyBaseStandard = (Boolean)this.getUIContext().get(CTX_ONLY_BASE_SRANDARD);
        if (onlyBaseStandard != null && onlyBaseStandard.booleanValue()) {
            IMaterialGroupStandard iBiz = MaterialGroupStandardFactory.getRemoteInstance();
            MaterialGroupStandardCollection baseGroupStandardColl = iBiz.getBaseMaterialGroupStandardColl();
            if (baseGroupStandardColl.size() > 0) {
                groupStandard = baseGroupStandardColl.get(0);
            }
        } else {
            groupStandard = (MaterialGroupStandardInfo)this.getUIContext().get(CTX_GROUP_STANDARD);
        }
        if (groupStandard != null) {
            this.comboGroupStandard.removeAllItems();
            this.comboGroupStandard.addItem((Object)groupStandard);
            this.comboGroupStandard.setSelectedIndex(0);
        } else {
            IMaterialGroupStandard iMaterialGroupStandard = MaterialGroupStandardFactory.getRemoteInstance();
            FilterInfo filterInfoCU = EntityControlTypeUtil.getFilterInfoForControlTypeS4((String)this.curCtrlUnitInfo.getId().toString(), (String)this.curCtrlUnitInfo.getLongNumber());
            EntityViewInfo viewInfo = new EntityViewInfo();
            viewInfo.setFilter(filterInfoCU);
            MaterialGroupStandardCollection groupStandardColl = iMaterialGroupStandard.getMaterialGroupStandardCollection(viewInfo);
            this.comboGroupStandard.removeAllItems();
            if (groupStandardColl != null) {
                this.comboGroupStandard.addItems(groupStandardColl.toArray());
            }
            int defaultIndex = 0;
            int size = groupStandardColl.size();
            for (int index = 0; index < size; ++index) {
                if (!groupStandardColl.get(index).getStandardType().equals((Object)MaterialGroupStandardTypeEnum.BasicStandard)) continue;
                defaultIndex = index;
                break;
            }
            this.comboGroupStandard.setSelectedIndex(defaultIndex);
        }
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.bizPromptStorageOrgFrom.setRequired(true);
        this.clear();
        if (this.storageOrgUnitInfo != null) {
            this.bizPromptStorageOrgFrom.setValue((Object)this.storageOrgUnitInfo);
        }
        this.loadStoreTypeEnum((JComboBox)this.comboBoxStoreType);
        this.comboBoxStoreType.setSelectedIndex(-1);
        this.setF7();
        this.curCtrlUnitInfo = (CtrlUnitInfo)this.getUIContext().get(CTX_CU);
        if (this.curCtrlUnitInfo == null) {
            this.curCtrlUnitInfo = SysContext.getSysContext().getCurrentCtrlUnit();
        }
        this.loadGroupStandard();
        if (this.comboGroupStandard.getSelectedItem() != null) {
            this.setMaterialGroupStandard(((MaterialGroupStandardInfo)this.comboGroupStandard.getSelectedItem()).getId().toString());
        }
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    private void setF7() throws Exception {
        InvClientUtils.getMaterialF7ForReportFilterUI(this.bizPromptMaterialNumFrom, (Object)this);
        ((F7MaterialMultiUISelectorAdaptor)this.bizPromptMaterialNumFrom.getSelector()).setIsMultiSelect(true);
        InvClientUtils.getMaterialF7ForReportFilterUI(this.bizPromptMaterialNumTo, (Object)this);
        SCMClientUtils.addListenerForMultiF7((KDBizPromptBox)this.bizPromptMaterialNumFrom, (KDBizPromptBox)this.bizPromptMaterialNumTo);
        SCMClientUtils.setMainBizOrgF7forSealUp((KDBizPromptBox)this.bizPromptStorageOrgFrom, (OrgType)OrgType.Storage, (String)permItem);
    }

    public void clear() {
        OrgUnitInfo aOrgUnitInfo = this.getDefaultMainBizOrg();
        if (aOrgUnitInfo != null && this.getMainBizOrgF7() != null) {
            this.getMainBizOrgF7().setValue((Object)aOrgUnitInfo);
        }
        this.bizPromptWarehouseFrom.setValue(null);
        this.bizPromptWarehouseTo.setValue(null);
        this.bizPromptLocationFrom.setValue(null);
        this.bizPromptLocationTo.setValue(null);
        this.bizPromptStoreTypeFrom.setValue(null);
        this.bizPromptStoreTypeTo.setValue(null);
        this.bizPromptMaterialNumFrom.setValue(null);
        this.bizPromptMaterialNumTo.setValue(null);
        this.bizPromptAssisAttrFrom.setValue(null);
        this.bizPromptAssisAttrTo.setValue(null);
        this.txtBatchFrom.setText(null);
        this.txtBatchTo.setText(null);
        this.prmtProjectNumFrom.setValue(null);
        this.prmtProjectNumTo.setValue(null);
        this.prmtTrackNumFrom.setValue(null);
        this.prmtTrackNumTo.setValue(null);
        this.bizMaterialTypeFrom.setValue(null);
        this.bizMaterialTypeTo.setValue(null);
        this.comboBoxStoreType.setSelectedIndex(-1);
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Storage;
    }

    protected OrgUnitInfo getDefaultMainBizOrg() {
        OrgUnitInfo currentMainOrg;
        if (this.idxDefaultMainOrg > -1) {
            return this.mainOrgs[this.idxDefaultMainOrg];
        }
        if (this.mainOrgs == null) {
            this.gainAuthMainBizOrgs();
        }
        if ((currentMainOrg = SysContext.getSysContext().getCurrentOrgUnit(this.getMainBizOrgType())) != null && this.mainOrgs.length > 0) {
            for (int i = 0; i < this.mainOrgs.length; ++i) {
                if (!currentMainOrg.getId().toString().equals(this.mainOrgs[i].getId().toString())) continue;
                this.idxDefaultMainOrg = i;
                return currentMainOrg;
            }
        }
        if (this.mainOrgs.length > 0) {
            this.idxDefaultMainOrg = 0;
            return this.mainOrgs[0];
        }
        return null;
    }

    private void gainAuthMainBizOrgs() {
        if (this.mainOrgs == null) {
            try {
                this.mainOrgs = SCMServiceFactory.getPermissionService().getAuthorizedBizOrgUnits((IObjectPK)new ObjectStringPK(SysContext.getSysContext().getCurrentUserInfo().getId().toString()), this.getMainBizOrgType(), permItem);
                if (this.mainOrgs == null) {
                    this.mainOrgs = new OrgUnitInfo[0];
                }
                if (this.mainOrgs.length > 0) {
                    this.mainOrgs = (OrgUnitInfo[])SortUtil.sortDataByNumber((DataBaseInfo[])this.mainOrgs, (boolean)true);
                    this.hasPermOrg = new OrgUnitCollection();
                    int len = this.mainOrgs.length;
                    for (int i = 0; i < len; ++i) {
                        this.hasPermOrg.add(this.mainOrgs[i]);
                    }
                }
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        }
    }

    public FilterInfo getFilterInfo() {
        StoreType storeType;
        int j;
        StringBuffer sbFormula = new StringBuffer();
        FilterInfo filter = new FilterInfo();
        FilterItemCollection items = filter.getFilterItems();
        int i = 0;
        String strNumber = null;
        Object[] obj = null;
        HashSet<String> oriSet = new HashSet<String>();
        HashSet<String> orgSet = new HashSet<String>();
        FilterItemInfo templateFilterItemInfo = new FilterItemInfo();
        strNumber = this.bizPromptStorageOrgFrom.getText();
        if (this.bizPromptStorageOrgFrom.getValue() != null && strNumber != null && strNumber.toString().length() > 0) {
            obj = this.bizPromptStorageOrgFrom.getValue() instanceof Object[] ? (Object[])this.bizPromptStorageOrgFrom.getValue() : new Object[]{(StorageOrgUnitInfo)this.bizPromptStorageOrgFrom.getValue()};
            int size = obj.length;
            for (int j2 = 0; j2 < size; ++j2) {
                StorageOrgUnitInfo storageOrgUnitInfo = (StorageOrgUnitInfo)obj[j2];
                orgSet.add(storageOrgUnitInfo.getId().toString());
                oriSet.add(storageOrgUnitInfo.getId().toString());
            }
            templateFilterItemInfo = new FilterItemInfo("storageOrgUnit.id", orgSet, CompareType.INCLUDE);
            items.add(templateFilterItemInfo);
            if (i == 0) {
                sbFormula.append("#" + i++);
            } else {
                sbFormula.append(" and #" + i++);
            }
        }
        strNumber = this.bizPromptWarehouseFrom.getText();
        if (this.bizPromptWarehouseFrom.getValue() != null && strNumber != null && strNumber.toString().length() > 0) {
            obj = (Object[])this.bizPromptWarehouseFrom.getValue();
            HashSet<String> whsSet = new HashSet<String>();
            int size = obj.length;
            for (j = 0; j < size; ++j) {
                WarehouseInfo warehouseInfo = (WarehouseInfo)obj[j];
                whsSet.add(warehouseInfo.getId().toString());
            }
            templateFilterItemInfo = new FilterItemInfo("warehouse.id", whsSet, CompareType.INCLUDE);
            items.add(templateFilterItemInfo);
            if (i == 0) {
                sbFormula.append("#" + i++);
            } else {
                sbFormula.append(" and #" + i++);
            }
        }
        strNumber = this.bizPromptLocationFrom.getText();
        if (this.bizPromptLocationFrom.getValue() != null && strNumber != null && strNumber.toString().length() > 0) {
            obj = (Object[])this.bizPromptLocationFrom.getValue();
            HashSet<String> loSet = new HashSet<String>();
            int size = obj.length;
            for (j = 0; j < size; ++j) {
                LocationInfo locationInfo = (LocationInfo)obj[j];
                loSet.add(locationInfo.getId().toString());
            }
            templateFilterItemInfo = new FilterItemInfo("location.id", loSet, CompareType.INCLUDE);
            items.add(templateFilterItemInfo);
            if (i == 0) {
                sbFormula.append("#" + i++);
            } else {
                sbFormula.append(" and #" + i++);
            }
        }
        strNumber = this.bizPromptStoreTypeFrom.getText();
        Object value = this.bizPromptStoreTypeFrom.getValue();
        if (value != null && strNumber != null && strNumber.toString().length() > 0) {
            strNumber = value instanceof StoreTypeInfo ? ((StoreTypeInfo)value).getNumber() : value.toString();
            templateFilterItemInfo = new FilterItemInfo("storetype.number", (Object)strNumber.toString().trim(), CompareType.GREATER_EQUALS);
            items.add(templateFilterItemInfo);
            if (i == 0) {
                sbFormula.append("#" + i++);
            } else {
                sbFormula.append(" and #" + i++);
            }
        } else if (strNumber != null && strNumber.toString().length() > 0) {
            templateFilterItemInfo = new FilterItemInfo("storetype.number", (Object)strNumber.toString().trim(), CompareType.GREATER_EQUALS);
            items.add(templateFilterItemInfo);
            if (i == 0) {
                sbFormula.append("#" + i++);
            } else {
                sbFormula.append(" and #" + i++);
            }
        }
        strNumber = this.bizPromptStoreTypeTo.getText();
        value = this.bizPromptStoreTypeTo.getValue();
        if (value != null && strNumber != null && strNumber.toString().length() > 0) {
            strNumber = value instanceof StoreTypeInfo ? ((StoreTypeInfo)value).getNumber() : value.toString();
            templateFilterItemInfo = new FilterItemInfo("storetype.number", (Object)strNumber.toString().trim(), CompareType.LESS_EQUALS);
            items.add(templateFilterItemInfo);
            if (i == 0) {
                sbFormula.append("#" + i++);
            } else {
                sbFormula.append(" and #" + i++);
            }
        } else if (strNumber != null && strNumber.toString().length() > 0) {
            templateFilterItemInfo = new FilterItemInfo("storetype.number", (Object)strNumber.toString().trim(), CompareType.LESS_EQUALS);
            items.add(templateFilterItemInfo);
            if (i == 0) {
                sbFormula.append("#" + i++);
            } else {
                sbFormula.append(" and #" + i++);
            }
        }
        strNumber = this.bizPromptMaterialNumFrom.getText();
        value = this.bizPromptMaterialNumFrom.getValue();
        if (value != null && strNumber != null && strNumber.toString().length() > 0) {
            if (value instanceof Object[]) {
                Object[] materials = (Object[])value;
                HashSet<String> materialNumbers = new HashSet<String>();
                for (int j3 = 0; j3 < materials.length; ++j3) {
                    materialNumbers.add(((MaterialInfo)materials[j3]).getNumber());
                }
                templateFilterItemInfo = materialNumbers.size() == 1 ? new FilterItemInfo("material.number", (Object)((MaterialInfo)materials[0]).getNumber(), CompareType.GREATER_EQUALS) : new FilterItemInfo("material.number", materialNumbers, CompareType.INCLUDE);
            } else {
                strNumber = value instanceof MaterialInfo ? ((MaterialInfo)value).getNumber() : value.toString();
                templateFilterItemInfo = new FilterItemInfo("material.number", (Object)strNumber.toString().trim(), CompareType.GREATER_EQUALS);
            }
            items.add(templateFilterItemInfo);
            if (i == 0) {
                sbFormula.append("#" + i++);
            } else {
                sbFormula.append(" and #" + i++);
            }
        } else if (strNumber != null && strNumber.toString().length() > 0) {
            templateFilterItemInfo = new FilterItemInfo("material.number", (Object)strNumber.toString().trim(), CompareType.GREATER_EQUALS);
            items.add(templateFilterItemInfo);
            if (i == 0) {
                sbFormula.append("#" + i++);
            } else {
                sbFormula.append(" and #" + i++);
            }
        }
        strNumber = this.bizPromptMaterialNumTo.getText();
        value = this.bizPromptMaterialNumTo.getValue();
        if (value != null && strNumber != null && strNumber.toString().length() > 0) {
            strNumber = value instanceof MaterialInfo ? ((MaterialInfo)value).getNumber() : value.toString();
            templateFilterItemInfo = new FilterItemInfo("material.number", (Object)strNumber.toString().trim(), CompareType.LESS_EQUALS);
            items.add(templateFilterItemInfo);
            if (i == 0) {
                sbFormula.append("#" + i++);
            } else {
                sbFormula.append(" and #" + i++);
            }
        } else if (strNumber != null && strNumber.toString().length() > 0) {
            templateFilterItemInfo = new FilterItemInfo("material.number", (Object)strNumber.toString().trim(), CompareType.LESS_EQUALS);
            items.add(templateFilterItemInfo);
            if (i == 0) {
                sbFormula.append("#" + i++);
            } else {
                sbFormula.append(" and #" + i++);
            }
        }
        strNumber = ((MaterialGroupStandardInfo)this.comboGroupStandard.getSelectedItem()).getId().toString();
        value = this.comboGroupStandard.getSelectedItem();
        if (value != null && strNumber != null && strNumber.toString().length() > 0) {
            strNumber = value instanceof MaterialGroupStandardInfo ? ((MaterialGroupStandardInfo)value).getId().toString() : value.toString();
            templateFilterItemInfo = new FilterItemInfo("groupstandard.id", (Object)strNumber.toString().trim(), CompareType.EQUALS);
            items.add(templateFilterItemInfo);
            if (i == 0) {
                sbFormula.append("#" + i++);
            } else {
                sbFormula.append(" and #" + i++);
            }
        } else if (strNumber != null && strNumber.toString().length() > 0) {
            templateFilterItemInfo = new FilterItemInfo("groupstandard.id", (Object)strNumber.toString().trim(), CompareType.EQUALS);
            items.add(templateFilterItemInfo);
            if (i == 0) {
                sbFormula.append("#" + i++);
            } else {
                sbFormula.append(" and #" + i++);
            }
        }
        IObjectValue from = (IObjectValue)this.bizMaterialTypeFrom.getValue();
        IObjectValue to = (IObjectValue)this.bizMaterialTypeTo.getValue();
        if (from != null) {
            templateFilterItemInfo = new FilterItemInfo("materialGroup.id", (Object)from.getString("id"), CompareType.GREATER_EQUALS);
            items.add(templateFilterItemInfo);
        }
        if (to != null) {
            templateFilterItemInfo = new FilterItemInfo("materialGroup.id", (Object)to.getString("id"), CompareType.LESS_EQUALS);
            items.add(templateFilterItemInfo);
        }
        strNumber = this.bizPromptAssisAttrFrom.getText();
        value = this.bizPromptAssisAttrFrom.getValue();
        if (value != null && strNumber != null && strNumber.toString().length() > 0) {
            strNumber = value instanceof AsstAttrValueInfo ? ((AsstAttrValueInfo)value).getNumber() : value.toString();
            templateFilterItemInfo = new FilterItemInfo("assistProperty.number", (Object)strNumber.toString().trim(), CompareType.GREATER_EQUALS);
            items.add(templateFilterItemInfo);
            if (i == 0) {
                sbFormula.append("#" + i++);
            } else {
                sbFormula.append(" and #" + i++);
            }
        } else if (strNumber != null && strNumber.toString().length() > 0) {
            templateFilterItemInfo = new FilterItemInfo("assistProperty.number", (Object)strNumber.toString().trim(), CompareType.GREATER_EQUALS);
            items.add(templateFilterItemInfo);
            if (i == 0) {
                sbFormula.append("#" + i++);
            } else {
                sbFormula.append(" and #" + i++);
            }
        }
        strNumber = this.bizPromptAssisAttrTo.getText();
        value = this.bizPromptAssisAttrTo.getValue();
        if (value != null && strNumber != null && strNumber.toString().length() > 0) {
            strNumber = value instanceof AsstAttrValueInfo ? ((AsstAttrValueInfo)value).getNumber() : value.toString();
            templateFilterItemInfo = new FilterItemInfo("assistProperty.number", (Object)strNumber.toString().trim(), CompareType.LESS_EQUALS);
            items.add(templateFilterItemInfo);
            if (i == 0) {
                sbFormula.append("#" + i++);
            } else {
                sbFormula.append(" and #" + i++);
            }
        } else if (strNumber != null && strNumber.toString().length() > 0) {
            templateFilterItemInfo = new FilterItemInfo("assistProperty.number", (Object)strNumber.toString().trim(), CompareType.LESS_EQUALS);
            items.add(templateFilterItemInfo);
            if (i == 0) {
                sbFormula.append("#" + i++);
            } else {
                sbFormula.append(" and #" + i++);
            }
        }
        if (this.txtBatchFrom.getText() != null && this.txtBatchFrom.getText().trim().length() > 0) {
            templateFilterItemInfo = new FilterItemInfo("lot", (Object)this.txtBatchFrom.getText().trim(), CompareType.GREATER_EQUALS);
            items.add(templateFilterItemInfo);
            if (i == 0) {
                sbFormula.append("#" + i++);
            } else {
                sbFormula.append(" and #" + i++);
            }
        }
        if (this.txtBatchTo.getText() != null && this.txtBatchTo.getText().trim().length() > 0) {
            templateFilterItemInfo = new FilterItemInfo("lot", (Object)this.txtBatchTo.getText().trim(), CompareType.LESS_EQUALS);
            items.add(templateFilterItemInfo);
            if (i == 0) {
                sbFormula.append("#" + i++);
            } else {
                sbFormula.append(" and #" + i++);
            }
        }
        strNumber = this.prmtProjectNumFrom.getText();
        value = this.prmtProjectNumFrom.getValue();
        if (value != null && !StringUtils.isEmpty((String)strNumber)) {
            strNumber = value instanceof ProjectInfo ? ((ProjectInfo)value).getNumber() : value.toString();
            templateFilterItemInfo = new FilterItemInfo("project.number", (Object)strNumber.toString().trim(), CompareType.GREATER_EQUALS);
            items.add(templateFilterItemInfo);
            if (i == 0) {
                sbFormula.append("#" + i++);
            } else {
                sbFormula.append(" and #" + i++);
            }
        } else if (!StringUtils.isEmpty((String)strNumber)) {
            templateFilterItemInfo = new FilterItemInfo("project.number", (Object)strNumber.toString().trim(), CompareType.GREATER_EQUALS);
            items.add(templateFilterItemInfo);
            if (i == 0) {
                sbFormula.append("#" + i++);
            } else {
                sbFormula.append(" and #" + i++);
            }
        }
        strNumber = this.prmtProjectNumTo.getText();
        value = this.prmtProjectNumTo.getValue();
        if (value != null && !StringUtils.isEmpty((String)strNumber)) {
            strNumber = value instanceof ProjectInfo ? ((ProjectInfo)value).getNumber() : value.toString();
            templateFilterItemInfo = new FilterItemInfo("project.number", (Object)strNumber.toString().trim(), CompareType.LESS_EQUALS);
            items.add(templateFilterItemInfo);
            if (i == 0) {
                sbFormula.append("#" + i++);
            } else {
                sbFormula.append(" and #" + i++);
            }
        } else if (!StringUtils.isEmpty((String)strNumber)) {
            templateFilterItemInfo = new FilterItemInfo("project.number", (Object)strNumber.toString().trim(), CompareType.LESS_EQUALS);
            items.add(templateFilterItemInfo);
            if (i == 0) {
                sbFormula.append("#" + i++);
            } else {
                sbFormula.append(" and #" + i++);
            }
        }
        strNumber = this.prmtTrackNumFrom.getText();
        value = this.prmtTrackNumFrom.getValue();
        if (value != null && !StringUtils.isEmpty((String)strNumber)) {
            strNumber = value instanceof TrackNumberInfo ? ((TrackNumberInfo)value).getNumber() : value.toString();
            templateFilterItemInfo = new FilterItemInfo("trackNumber.number", (Object)strNumber.toString().trim(), CompareType.GREATER_EQUALS);
            items.add(templateFilterItemInfo);
            if (i == 0) {
                sbFormula.append("#" + i++);
            } else {
                sbFormula.append(" and #" + i++);
            }
        } else if (!StringUtils.isEmpty((String)strNumber)) {
            templateFilterItemInfo = new FilterItemInfo("trackNumber.number", (Object)strNumber.toString().trim(), CompareType.GREATER_EQUALS);
            items.add(templateFilterItemInfo);
            if (i == 0) {
                sbFormula.append("#" + i++);
            } else {
                sbFormula.append(" and #" + i++);
            }
        }
        strNumber = this.prmtTrackNumTo.getText();
        value = this.prmtTrackNumTo.getValue();
        if (value != null && !StringUtils.isEmpty((String)strNumber)) {
            strNumber = value instanceof TrackNumberInfo ? ((TrackNumberInfo)value).getNumber() : value.toString();
            templateFilterItemInfo = new FilterItemInfo("trackNumber.number", (Object)strNumber.toString().trim(), CompareType.LESS_EQUALS);
            items.add(templateFilterItemInfo);
            if (i == 0) {
                sbFormula.append("#" + i++);
            } else {
                sbFormula.append(" and #" + i++);
            }
        } else if (!StringUtils.isEmpty((String)strNumber)) {
            templateFilterItemInfo = new FilterItemInfo("trackNumber.number", (Object)strNumber.toString().trim(), CompareType.LESS_EQUALS);
            items.add(templateFilterItemInfo);
            if (i == 0) {
                sbFormula.append("#" + i++);
            } else {
                sbFormula.append(" and #" + i++);
            }
        }
        if (this.comboBoxStoreType.getSelectedItem() != null && (storeType = (StoreType)this.comboBoxStoreType.getSelectedItem()).getValue() != 0) {
            templateFilterItemInfo = new FilterItemInfo("materialCost.storeType", (Object)new Integer(storeType.getValue()), CompareType.EQUALS);
            items.add(templateFilterItemInfo);
            if (i == 0) {
                sbFormula.append("#" + i++);
            } else {
                sbFormula.append(" and #" + i++);
            }
        }
        if (sbFormula.toString().length() != 0) {
            // empty if block
        }
        this.buildMaterialTypeFilterInfo();
        logger.debug((Object)filter.getFilterItems());
        return filter;
    }

    public FilterInfo getMaterialTypeFilterInfo() {
        return this.materialTypeFilterInfo;
    }

    public void loadData(EntityViewInfo entityViewInfo) {
        this.clear();
        try {
            if (entityViewInfo.getFilter() == null || entityViewInfo.getFilter().getFilterItems() == null || entityViewInfo.getFilter().getFilterItems().size() == 0) {
                return;
            }
            FilterItemCollection currentFilterItemCollection = entityViewInfo.getFilter().getFilterItems();
            int currentFilterItemCollectionSize = currentFilterItemCollection.size();
            EntityViewInfo view = null;
            FilterInfo filter = null;
            String itemID = null;
            for (int i = 0; i < currentFilterItemCollectionSize; ++i) {
                String number;
                Object[] obj;
                StorageOrgUnitCollection col;
                FilterItemInfo filterItemInfo = currentFilterItemCollection.get(i);
                if (filterItemInfo.getPropertyName().equals("storageOrgUnit.id") && filterItemInfo.getCompareType().getName().equals(CompareType.INCLUDE.getName())) {
                    view = new EntityViewInfo();
                    filter = new FilterInfo();
                    filterItemInfo.setPropertyName("id");
                    filter.getFilterItems().add(filterItemInfo);
                    view.setFilter(filter);
                    col = StorageOrgUnitFactory.getRemoteInstance().getStorageOrgUnitCollection(view);
                    obj = col.toArray();
                    this.bizPromptStorageOrgFrom.setValue((Object)obj);
                }
                if (filterItemInfo.getPropertyName().equals("warehouse.id") && filterItemInfo.getCompareType().getName().equals(CompareType.INCLUDE.getName())) {
                    view = new EntityViewInfo();
                    filter = new FilterInfo();
                    filterItemInfo.setPropertyName("id");
                    filter.getFilterItems().add(filterItemInfo);
                    view.setFilter(filter);
                    col = WarehouseFactory.getRemoteInstance().getWarehouseCollection(view);
                    obj = col.toArray();
                    this.bizPromptWarehouseFrom.setValue((Object)obj);
                }
                if (filterItemInfo.getPropertyName().equals("location.id") && filterItemInfo.getCompareType().getName().equals(CompareType.INCLUDE.getName())) {
                    view = new EntityViewInfo();
                    filter = new FilterInfo();
                    filterItemInfo.setPropertyName("id");
                    filter.getFilterItems().add(filterItemInfo);
                    view.setFilter(filter);
                    col = LocationFactory.getRemoteInstance().getLocationCollection(view);
                    obj = col.toArray();
                    this.bizPromptLocationFrom.setValue((Object)obj);
                }
                if (filterItemInfo.getPropertyName().equals("storetype.number") && filterItemInfo.getCompareType().getName().equals(CompareType.GREATER_EQUALS.getName())) {
                    number = filterItemInfo.getCompareValue().toString();
                    this.bizPromptStoreTypeFrom.setText(number);
                }
                if (filterItemInfo.getPropertyName().equals("storetype.number") && filterItemInfo.getCompareType().getName().equals(CompareType.LESS_EQUALS.getName())) {
                    number = filterItemInfo.getCompareValue().toString();
                    this.bizPromptStoreTypeTo.setText(number);
                }
                if (filterItemInfo.getPropertyName().equals("material.number")) {
                    if (filterItemInfo.getCompareType().getName().equals(CompareType.GREATER_EQUALS.getName())) {
                        number = filterItemInfo.getCompareValue().toString();
                        this.bizPromptMaterialNumFrom.setText(number);
                    } else if (filterItemInfo.getCompareType().getName().equals(CompareType.INCLUDE.getName())) {
                        view = new EntityViewInfo();
                        filter = new FilterInfo();
                        filterItemInfo.setPropertyName("number");
                        filter.getFilterItems().add(filterItemInfo);
                        view.setFilter(filter);
                        col = MaterialFactory.getRemoteInstance().getMaterialCollection(view);
                        obj = col.toArray();
                        this.bizPromptMaterialNumFrom.setValue((Object)obj);
                    }
                }
                if (filterItemInfo.getPropertyName().equals("material.number") && filterItemInfo.getCompareType().getName().equals(CompareType.LESS_EQUALS.getName())) {
                    number = filterItemInfo.getCompareValue().toString();
                    this.bizPromptMaterialNumTo.setText(number);
                }
                if (filterItemInfo.getPropertyName().equals("assistProperty.number") && filterItemInfo.getCompareType().getName().equals(CompareType.GREATER_EQUALS.getName())) {
                    number = filterItemInfo.getCompareValue().toString();
                    this.bizPromptAssisAttrFrom.setText(number);
                }
                if (filterItemInfo.getPropertyName().equals("assistProperty.number") && filterItemInfo.getCompareType().getName().equals(CompareType.LESS_EQUALS.getName())) {
                    number = filterItemInfo.getCompareValue().toString();
                    this.bizPromptAssisAttrTo.setText(number);
                }
                if (filterItemInfo.getPropertyName().equals("lot") && filterItemInfo.getCompareType().getName().equals(CompareType.GREATER_EQUALS.getName())) {
                    number = filterItemInfo.getCompareValue().toString();
                    this.txtBatchFrom.setText(number);
                }
                if (filterItemInfo.getPropertyName().equals("lot") && filterItemInfo.getCompareType().getName().equals(CompareType.LESS_EQUALS.getName())) {
                    number = filterItemInfo.getCompareValue().toString();
                    this.txtBatchTo.setText(number);
                }
                if (filterItemInfo.getPropertyName().equals("project.number") && filterItemInfo.getCompareType().getName().equals(CompareType.GREATER_EQUALS.getName())) {
                    number = filterItemInfo.getCompareValue().toString();
                    this.prmtProjectNumFrom.setText(number);
                }
                if (filterItemInfo.getPropertyName().equals("project.number") && filterItemInfo.getCompareType().getName().equals(CompareType.LESS_EQUALS.getName())) {
                    number = filterItemInfo.getCompareValue().toString();
                    this.prmtProjectNumTo.setText(number);
                }
                if (filterItemInfo.getPropertyName().equals("trackNumber.number") && filterItemInfo.getCompareType().getName().equals(CompareType.GREATER_EQUALS.getName())) {
                    number = filterItemInfo.getCompareValue().toString();
                    this.prmtTrackNumFrom.setText(number);
                }
                if (filterItemInfo.getPropertyName().equals("trackNumber.number") && filterItemInfo.getCompareType().getName().equals(CompareType.LESS_EQUALS.getName())) {
                    number = filterItemInfo.getCompareValue().toString();
                    this.prmtTrackNumTo.setText(number);
                }
                if (filterItemInfo.getPropertyName().equals("materialCost.storeType") && filterItemInfo.getCompareValue() != null) {
                    number = filterItemInfo.getCompareValue().toString();
                    Iterator iterator = StoreType.iterator();
                    while (iterator.hasNext()) {
                        StoreType storeType = (StoreType)iterator.next();
                        if (Integer.valueOf(number).intValue() != storeType.getValue()) continue;
                        this.comboBoxStoreType.setSelectedItem((Object)storeType);
                    }
                }
                if (filterItemInfo.getPropertyName().equals("groupstandard.id") && filterItemInfo.getCompareType().getName().equals(CompareType.EQUALS.getName())) {
                    for (int itemNum = 0; itemNum < this.comboGroupStandard.getItemCount(); ++itemNum) {
                        itemID = ((MaterialGroupStandardInfo)this.comboGroupStandard.getItemAt(itemNum)).getId().toString();
                        if (itemID == null || !itemID.equals(filterItemInfo.getCompareValue().toString())) continue;
                        this.comboGroupStandard.setSelectedIndex(itemNum);
                        break;
                    }
                    this.setMaterialGroupStandard(filterItemInfo.getCompareValue().toString());
                }
                if (filterItemInfo.getPropertyName().equals("materialGroup.id") && filterItemInfo.getCompareType().getName().equals(CompareType.GREATER_EQUALS.getName())) {
                    view = new EntityViewInfo();
                    filter = new FilterInfo();
                    filter.appendFilterItem("id", filterItemInfo.getCompareValue());
                    view.setFilter(filter);
                    MaterialGroupCollection col2 = MaterialGroupFactory.getRemoteInstance().getMaterialGroupCollection(view);
                    if (col2 != null && col2.size() > 0) {
                        this.bizMaterialTypeFrom.setValue((Object)col2.get(0));
                    }
                }
                if (!filterItemInfo.getPropertyName().equals("materialGroup.id") || !filterItemInfo.getCompareType().getName().equals(CompareType.LESS_EQUALS.getName())) continue;
                view = new EntityViewInfo();
                filter = new FilterInfo();
                filter.appendFilterItem("id", filterItemInfo.getCompareValue());
                view.setFilter(filter);
                MaterialGroupCollection col3 = MaterialGroupFactory.getRemoteInstance().getMaterialGroupCollection(view);
                if (col3 == null || col3.size() <= 0) continue;
                this.bizMaterialTypeTo.setValue((Object)col3.get(0));
            }
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    private void loadStoreTypeEnum(JComboBox cb) {
        DefaultComboBoxModel<StoreType> model = new DefaultComboBoxModel<StoreType>();
        Iterator i = StoreType.iterator();
        while (i.hasNext()) {
            StoreType e = (StoreType)i.next();
            model.addElement(e);
        }
        cb.setModel(model);
    }

    public KDBizPromptBox getMainBizOrgF7() {
        return this.bizPromptStorageOrgFrom;
    }

    @Override
    public boolean isPrepareInit() {
        return true;
    }

    public OrgUnitCollection getMainBizOrgs() {
        OrgUnitCollection orgCol = super.getMainBizOrgs();
        if (orgCol == null || orgCol.size() == 0) {
            return this.hasPermOrg;
        }
        return orgCol;
    }

    public boolean verify() {
        if (this.bizPromptStorageOrgFrom.getValue() == null) {
            MsgBox.showInfo((String)InvClientUtils.getResource("StorageOrgUnitNotNull"));
            SysUtil.abort();
        }
        return true;
    }

    public Object getStorageOrgUnit() {
        return this.bizPromptStorageOrgFrom.getValue();
    }

    private void buildMaterialTypeFilterInfo() {
        this.materialTypeFilterInfo = new FilterInfo();
        FilterItemInfo templateFilterItemInfo = null;
        String standerdId = ((MaterialGroupStandardInfo)this.comboGroupStandard.getSelectedItem()).getId().toString();
        IObjectValue from = (IObjectValue)this.bizMaterialTypeFrom.getValue();
        IObjectValue to = (IObjectValue)this.bizMaterialTypeTo.getValue();
        List materialGroup = null;
        try {
            materialGroup = InventoryFacadeFactory.getRemoteInstance().getMaterialGroupLongNumber(from, to, standerdId);
        }
        catch (BOSException e) {
            logger.error((Object)e);
        }
        int i = 0;
        StringBuffer sbFormula = new StringBuffer();
        if (materialGroup != null && materialGroup.size() != 0) {
            if (i != 0) {
                sbFormula.append(" and (");
            } else {
                sbFormula.append("(");
            }
            for (int j = 0; j < materialGroup.size(); ++j) {
                templateFilterItemInfo = new FilterItemInfo("materialGroup.longNumber", materialGroup.get(j), CompareType.EQUALS);
                this.materialTypeFilterInfo.getFilterItems().add(templateFilterItemInfo);
                templateFilterItemInfo = new FilterItemInfo("materialGroup.longNumber", (Object)(materialGroup.get(j) + "!%"), CompareType.LIKE);
                this.materialTypeFilterInfo.getFilterItems().add(templateFilterItemInfo);
                if (j == 0) {
                    sbFormula.append("#" + i++ + " or  #" + i++ + "");
                    continue;
                }
                sbFormula.append(" or #" + i++ + " or  #" + i++ + "");
            }
            sbFormula.append(")");
        } else if (from != null || to != null) {
            templateFilterItemInfo = new FilterItemInfo("materialGroup.longNumber", (Object)"XXXXXXXXXXX", CompareType.EQUALS);
            this.materialTypeFilterInfo.getFilterItems().add(templateFilterItemInfo);
            if (i == 0) {
                sbFormula.append("#" + i++);
            } else {
                sbFormula.append("  and  #" + i++);
            }
        }
        this.materialTypeFilterInfo.setMaskString(sbFormula.toString());
    }

    public String getMaterialGroupStandardID() {
        return this.materialGroupStandardID;
    }

    public void setMaterialGroupStandard(String materialGroupStandardID) {
        this.materialGroupStandardID = materialGroupStandardID;
    }
}

