/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActGroupDetailCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstActGroupDetailInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.service.SCMServiceFactory;
import com.kingdee.eas.scm.common.util.SortUtil;
import com.kingdee.eas.scm.im.inv.IInventoryInitCheckAccount;
import com.kingdee.eas.scm.im.inv.InventoryInitCheckAccountFactory;
import com.kingdee.eas.scm.im.inv.client.AbstractInventoryInitCheckAccountListUI;
import com.kingdee.eas.scm.im.rpt.IMRptUtils;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.apache.log4j.Logger;

public class InventoryInitCheckAccountListUI
extends AbstractInventoryInitCheckAccountListUI {
    private static final Logger logger = CoreUIObject.getLogger(InventoryInitCheckAccountListUI.class);
    private static final String Material = "material";
    private static final String StorageOrg = "storeageOrg";
    private static final String CompanyOrg = "companyOrg";
    private static final String ResourcePath = "com.kingdee.eas.scm.im.inv.WarehsManageResource";
    private OrgUnitInfo[] mainOrgs = null;
    private static final String permItem_view = "inventorycheckaccount_start";
    private CompanyOrgUnitInfo ficompanyOrgInfo = null;
    private CurrencyInfo baseCurrInfo = null;
    public int amtPrecision = 2;

    public InventoryInitCheckAccountListUI() throws Exception {
        CompanyOrgUnitInfo company = SysContext.getSysContext().getCurrentFIUnit();
        this.tblMain.setEditable(false);
        this.tblMain.getActionMap().remove("Delete");
        IMRptUtils.checkHasAuthorized(company.getId().toString(), OrgType.Company, permItem_view);
        this.initToolBar();
        this.initMenuBar();
        SCMClientUtils.setMainBizOrgF7((KDBizPromptBox)this.companyOrgUnitPromptBox, (OrgType)OrgType.Company, (String)permItem_view);
        this.ficompanyOrgInfo = SysContext.getSysContext().getCurrentFIUnit();
        if (this.ficompanyOrgInfo.isIsOUSealUp()) {
            this.ficompanyOrgInfo = (CompanyOrgUnitInfo)this.getDefaultMainBizOrg();
        }
        if (this.ficompanyOrgInfo.getBaseCurrency() != null) {
            this.baseCurrInfo = CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)new ObjectUuidPK(this.ficompanyOrgInfo.getBaseCurrency().getId()));
            this.amtPrecision = this.baseCurrInfo.getPrecision();
        }
        this.companyOrgUnitPromptBox.setData((Object)this.ficompanyOrgInfo);
        this.transAccount.setVisible(false);
        this.btnTransAccount.setVisible(false);
    }

    private final OrgUnitInfo getDefaultMainBizOrg() throws Exception {
        if (this.mainOrgs == null) {
            this.mainOrgs = SCMServiceFactory.getPermissionService().getAuthorizedBizOrgUnits((IObjectPK)new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId().toString()), OrgType.Company, permItem_view);
        }
        if (this.mainOrgs == null || this.mainOrgs.length == 0) {
            return null;
        }
        ArrayList<OrgUnitInfo> tempOrgArray = new ArrayList<OrgUnitInfo>();
        for (int i = 0; i < this.mainOrgs.length; ++i) {
            if (this.mainOrgs[i].isIsOUSealUp()) continue;
            tempOrgArray.add(this.mainOrgs[i]);
        }
        this.mainOrgs = tempOrgArray.toArray(new OrgUnitInfo[tempOrgArray.size()]);
        if (this.mainOrgs.length > 0) {
            this.mainOrgs = (OrgUnitInfo[])SortUtil.sortDataByNumber((DataBaseInfo[])this.mainOrgs, (boolean)true);
        }
        return this.mainOrgs[0];
    }

    public void fmtTblMain() {
        int rowNum = this.tblMain.getRowCount();
        for (int i = 0; i < rowNum; ++i) {
            SCMClientUtils.changeTableColPrecision((int)this.amtPrecision, (KDTable)this.tblMain, (String[])new String[]{"inventoryIn", "accountIn", "inventoryOut", "accountOut", "inventoryBegin", "accountBegin"}, (int)i);
        }
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    protected void companyOrgUnitPromptBox_dataChanged(DataChangeEvent e) throws Exception {
        Object object = this.companyOrgUnitPromptBox.getData();
        if (object != null) {
            this.ficompanyOrgInfo = (CompanyOrgUnitInfo)object;
            this.tblMain.removeColumns();
            this.fillHead();
            this.fillBody(this.ficompanyOrgInfo.getId().toString());
            this.fmtTblMain();
        }
    }

    public void fillHead() {
        String account = EASResource.getString((String)ResourcePath, (String)"account");
        String accountCode = EASResource.getString((String)ResourcePath, (String)"accountCode");
        String accountName = EASResource.getString((String)ResourcePath, (String)"accountName");
        String inventoryTotal = EASResource.getString((String)ResourcePath, (String)"inventoryTotal");
        String accountBalance = EASResource.getString((String)ResourcePath, (String)"accountBalance");
        String yearDebitFor = EASResource.getString((String)ResourcePath, (String)"yearDebitFor");
        String yearCreditFor = EASResource.getString((String)ResourcePath, (String)"yearCreditFor");
        String beginAmount = EASResource.getString((String)ResourcePath, (String)"beginAmount");
        this.tblMain.addColumns(8);
        this.tblMain.getColumn(0).setKey("accountCode");
        this.tblMain.getColumn(1).setKey("accountName");
        this.tblMain.getColumn(2).setKey("inventoryIn");
        this.tblMain.getColumn(3).setKey("accountIn");
        this.tblMain.getColumn(4).setKey("inventoryOut");
        this.tblMain.getColumn(5).setKey("accountOut");
        this.tblMain.getColumn(6).setKey("inventoryBegin");
        this.tblMain.getColumn(7).setKey("accountBegin");
        this.tblMain.addHeadRows(2);
        IRow headRow = this.tblMain.getHeadRow(0);
        headRow.getCell(0).setValue((Object)account);
        this.tblMain.getHeadMergeManager().mergeBlock(0, 0, 0, 1);
        headRow.getCell(2).setValue((Object)yearDebitFor);
        this.tblMain.getHeadMergeManager().mergeBlock(0, 2, 0, 3);
        headRow.getCell(4).setValue((Object)yearCreditFor);
        this.tblMain.getHeadMergeManager().mergeBlock(0, 4, 0, 5);
        headRow.getCell(6).setValue((Object)beginAmount);
        this.tblMain.getHeadMergeManager().mergeBlock(0, 6, 0, 7);
        headRow = this.tblMain.getHeadRow(1);
        headRow.getCell(0).setValue((Object)accountCode);
        headRow.getCell(1).setValue((Object)accountName);
        headRow.getCell(2).setValue((Object)inventoryTotal);
        headRow.getCell(3).setValue((Object)accountBalance);
        headRow.getCell(4).setValue((Object)inventoryTotal);
        headRow.getCell(5).setValue((Object)accountBalance);
        headRow.getCell(6).setValue((Object)inventoryTotal);
        headRow.getCell(7).setValue((Object)accountBalance);
    }

    public void fillBody(String companyOrgUnit) throws EASBizException, BOSException {
        Vector acVct;
        String accountID;
        Vector v;
        IRow curRow;
        IInventoryInitCheckAccount invInitCkAcct = InventoryInitCheckAccountFactory.getRemoteInstance();
        List mlist = invInitCkAcct.getInventoryMaterialAccount(companyOrgUnit);
        Iterator it = mlist.iterator();
        this.tblMain.getColumn(2).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblMain.getColumn(3).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblMain.getColumn(4).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblMain.getColumn(5).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblMain.getColumn(6).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblMain.getColumn(7).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        while (it.hasNext()) {
            curRow = this.tblMain.addRow();
            v = (Vector)it.next();
            curRow.getCell(0).setValue((Object)((String)v.get(1)));
            curRow.getCell(1).setValue((Object)((String)v.get(2)));
            curRow.getCell(2).setValue((Object)((BigDecimal)v.get(3)));
            curRow.getCell(4).setValue((Object)((BigDecimal)v.get(4)));
            curRow.getCell(6).setValue((Object)((BigDecimal)v.get(5)));
            accountID = (String)v.get(0);
            acVct = invInitCkAcct.getAccountBalance(accountID, companyOrgUnit);
            if (acVct != null) {
                curRow.getCell(3).setValue((Object)((BigDecimal)acVct.get(1)));
                curRow.getCell(5).setValue((Object)((BigDecimal)acVct.get(2)));
                curRow.getCell(7).setValue((Object)((BigDecimal)acVct.get(3)));
                continue;
            }
            curRow.getCell(3).setValue((Object)new BigDecimal("0.00"));
            curRow.getCell(5).setValue((Object)new BigDecimal("0.00"));
            curRow.getCell(7).setValue((Object)new BigDecimal("0.00"));
        }
        mlist = invInitCkAcct.getInventoryDiffAccount(companyOrgUnit);
        it = mlist.iterator();
        while (it.hasNext()) {
            curRow = this.tblMain.addRow();
            v = (Vector)it.next();
            curRow.getCell(0).setValue((Object)((String)v.get(1)));
            curRow.getCell(1).setValue((Object)((String)v.get(2)));
            curRow.getCell(2).setValue((Object)((BigDecimal)v.get(3)));
            curRow.getCell(4).setValue((Object)((BigDecimal)v.get(4)));
            curRow.getCell(6).setValue((Object)((BigDecimal)v.get(5)));
            accountID = (String)v.get(0);
            acVct = invInitCkAcct.getAccountBalance(accountID, companyOrgUnit);
            if (acVct != null) {
                curRow.getCell(3).setValue((Object)((BigDecimal)acVct.get(1)));
                curRow.getCell(5).setValue((Object)((BigDecimal)acVct.get(2)));
                curRow.getCell(7).setValue((Object)((BigDecimal)acVct.get(3)));
                continue;
            }
            curRow.getCell(3).setValue((Object)new BigDecimal("0.00"));
            curRow.getCell(5).setValue((Object)new BigDecimal("0.00"));
            curRow.getCell(7).setValue((Object)new BigDecimal("0.00"));
        }
    }

    public String getUITitle() {
        return EASResource.getString((String)ResourcePath, (String)"InventoryInitCheckAccount");
    }

    private void initToolBar() {
        this.btnRefresh.setText(EASResource.getString((String)"com.kingdee.eas.scm.im.inv.WarehsManageResource.refresh"));
        this.btnRefresh.setToolTipText(EASResource.getString((String)"com.kingdee.eas.scm.im.inv.WarehsManageResource.refresh"));
        this.btnRefresh.setIcon(EASResource.getIcon((String)"imgTbtn_refresh"));
        this.btnPrint.setText(EASResource.getString((String)"com.kingdee.eas.scm.im.inv.WarehsManageResource.print"));
        this.btnPrint.setToolTipText(EASResource.getString((String)"com.kingdee.eas.scm.im.inv.WarehsManageResource.print"));
        this.btnPrint.setIcon(EASResource.getIcon((String)"imgTbtn_print"));
        this.btnPrintPreview.setText(EASResource.getString((String)"com.kingdee.eas.scm.im.inv.WarehsManageResource.printPreview"));
        this.btnPrintPreview.setToolTipText(EASResource.getString((String)"com.kingdee.eas.scm.im.inv.WarehsManageResource.printPreview"));
        this.btnPrintPreview.setIcon(EASResource.getIcon((String)"imgTbtn_preview"));
        this.btnTransAccount.setText(EASResource.getString((String)"com.kingdee.eas.scm.im.inv.WarehsManageResource.transAccount"));
        this.btnTransAccount.setToolTipText(EASResource.getString((String)"com.kingdee.eas.scm.im.inv.WarehsManageResource.transAccount"));
        this.btnTransAccount.setIcon(EASResource.getIcon((String)"imgTbtn_associatecreate"));
        this.btnPrint.setEnabled(true);
        this.btnRefresh.setEnabled(true);
        this.btnPrintPreview.setEnabled(true);
        this.btnTransAccount.setEnabled(true);
    }

    private void initMenuBar() {
        this.menuItemPrint.setIcon(EASResource.getIcon((String)"imgTbtn_print"));
        this.menuItemPrintPreview.setIcon(EASResource.getIcon((String)"imgTbtn_preview"));
        this.menuItemRefresh.setIcon(EASResource.getIcon((String)"imgTbtn_refresh"));
    }

    @Override
    protected void btnTransAccount_actionPerformed(ActionEvent e) throws Exception {
    }

    @Override
    public void actionPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        this.preparePrintPage(this.tblMain);
        this.tblMain.getPrintManager().printPreview();
    }

    @Override
    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        this.preparePrintPage(this.tblMain);
        this.tblMain.getPrintManager().print();
    }

    @Override
    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        this.tblMain.removeColumns();
        this.fillHead();
        this.fillBody(this.ficompanyOrgInfo.getId().toString());
        this.fmtTblMain();
    }

    @Override
    public void actionTransAccount_actionPerformed(ActionEvent e) throws Exception {
        IInventoryInitCheckAccount invInitCkAcct = InventoryInitCheckAccountFactory.getRemoteInstance();
        CompanyOrgUnitInfo companyUnitInfo = SysContext.getSysContext().getCurrentFIUnit();
        List strList = invInitCkAcct.getInitAccount(companyUnitInfo.getId().toString());
        Iterator it = strList.iterator();
        StringBuffer allowAct = new StringBuffer();
        StringBuffer otherAct = new StringBuffer();
        while (it.hasNext()) {
            AccountViewInfo actViewInfo = (AccountViewInfo)it.next();
            if (actViewInfo.getCAA() != null && actViewInfo.getCAA().getAsstActGpDt() != null) {
                AsstActGroupDetailCollection asstColl = actViewInfo.getCAA().getAsstActGpDt();
                for (int i = 0; i < asstColl.size(); ++i) {
                    AsstActGroupDetailInfo asstDetailInfo = asstColl.get(i);
                    AsstActTypeInfo assActTypeInfo = asstDetailInfo.getAsstActType();
                    String asstHGAttribute = assActTypeInfo.getAsstHGAttribute();
                    if (!asstHGAttribute.equals(StorageOrg) && !asstHGAttribute.equals(Material)) {
                        otherAct.append("/");
                        otherAct.append(actViewInfo.getName());
                        continue;
                    }
                    allowAct.append("/");
                    allowAct.append(actViewInfo.getName());
                }
                continue;
            }
            allowAct.append("/");
            allowAct.append(actViewInfo.getName());
        }
        if (otherAct.length() > 0) {
            MsgBox.showError((String)(otherAct.toString().substring(1) + EASResource.getString((String)ResourcePath, (String)"AsstActNotCorresponding")));
            int result = MsgBox.showConfirm2((String)EASResource.getString((String)ResourcePath, (String)"OtherActTransfer"));
            if (result != 0) {
                return;
            }
        }
        if (allowAct.length() > 0) {
            invInitCkAcct.transferAccount(companyUnitInfo.getId().toString());
            MsgBox.showInfo((String)EASResource.getString((String)ResourcePath, (String)"InvInitTransAccountSuccess"));
        }
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.setButtonDefaultStyl(this.btnPrint);
        this.setButtonDefaultStyl(this.btnPrintPreview);
        this.setButtonDefaultStyl(this.btnRefresh);
    }
}

