/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.extendcontrols.ext.CommonF7KDTableListener;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.basedata.assistant.client.CostObjectF7UISelector;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.person.client.PersonPromptBox;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.util.FilterUtility;
import com.kingdee.eas.mm.common.client.UIHelper;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.client.ISCMBillStatusControl;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.client.SCMCommonF7KDTableListener;
import com.kingdee.eas.scm.common.filter.ColConnFilterElement;
import com.kingdee.eas.scm.common.filter.CompositeFilterElement;
import com.kingdee.eas.scm.common.filter.FilterElement;
import com.kingdee.eas.scm.common.filter.RangeFilterElement;
import com.kingdee.eas.scm.common.filter.SingleFilterElement;
import com.kingdee.eas.scm.common.util.SCMQueryFormat;
import com.kingdee.eas.scm.common.verify.VerifyItem;
import com.kingdee.eas.scm.common.verify.VerifyType;
import com.kingdee.eas.scm.im.inv.client.AbstractMaterialReqBillFilterUI;
import com.kingdee.eas.scm.im.inv.client.InvClientUtils;
import java.awt.Component;
import java.util.HashMap;
import java.util.HashSet;
import org.apache.log4j.Logger;

public class MaterialReqBillFilterUI
extends AbstractMaterialReqBillFilterUI
implements ISCMBillStatusControl {
    private static final Logger logger = CoreUIObject.getLogger(MaterialReqBillFilterUI.class);
    private boolean isSubContract = false;
    private CtrlUnitInfo CU = null;
    private HashMap companyMap = null;

    public MaterialReqBillFilterUI() throws Exception {
        this.getElementsInfo();
    }

    public MaterialReqBillFilterUI(boolean isSubContract) throws Exception {
        this();
        this.isSubContract = isSubContract;
    }

    private void getElementsInfo() {
        CompositeFilterElement elements = new CompositeFilterElement(0);
        elements.add((FilterElement)new RangeFilterElement("number", (Component)this.prmtNumberFrom, (Component)this.prmtNumberTo));
        elements.add((FilterElement)new RangeFilterElement("transactionType.number", (Component)this.bizPromptTrsTypeFrom, (Component)this.bizPromptTrsTypeTo));
        elements.add((FilterElement)new RangeFilterElement("sourceBillType.number", (Component)this.bizPromptSoureBillTypeFrom, (Component)this.bizPromptSoureBillTypeTo));
        elements.add((FilterElement)new RangeFilterElement("entry.sourceBillNumber", (Component)this.txtSourBillNumFrom, (Component)this.txtSourBillNumTo));
        elements.add((FilterElement)new RangeFilterElement("entry.material.number", (Component)this.bizPromptMaterialNumFrom, (Component)this.bizPromptMaterialNumTo));
        elements.add((FilterElement)new RangeFilterElement("entry.costObject.number", (Component)this.bizPromptCostObjectNumFrom, (Component)this.bizPromptCostObjectNumTo));
        elements.add((FilterElement)new RangeFilterElement("entry.warehouse.number", (Component)this.bizPromptWarehouseFrom, (Component)this.bizPromptWarehouseTo));
        UIHelper.registerProjectF7ForFilter((KDBizPromptBox)this.getMainBizOrgF7(), (KDBizPromptBox)this.prmtProjectNumFrom);
        UIHelper.registerProjectF7ForFilter((KDBizPromptBox)this.getMainBizOrgF7(), (KDBizPromptBox)this.prmtProjectNumTo);
        elements.add((FilterElement)new RangeFilterElement("project.number", (Component)this.prmtProjectNumFrom, (Component)this.prmtProjectNumTo));
        UIHelper.registerTrackNumberF7ForFilter((KDBizPromptBox)this.getMainBizOrgF7(), (KDBizPromptBox)this.prmtTrackNumFrom);
        UIHelper.registerTrackNumberF7ForFilter((KDBizPromptBox)this.getMainBizOrgF7(), (KDBizPromptBox)this.prmtTrackNumTo);
        elements.add((FilterElement)new RangeFilterElement("trackNumber.number", (Component)this.prmtTrackNumFrom, (Component)this.prmtTrackNumTo));
        if (!this.isSubContract) {
            elements.add((FilterElement)new RangeFilterElement("entry.supplyWarehouse.number", (Component)this.prmtSupplyWareHSFrom, (Component)this.prmtSupplyWareHSTo));
            elements.add((FilterElement)new RangeFilterElement("bizType.number", (Component)this.prmtBizTypeForm, (Component)this.prmtBizTypeTo));
            SingleFilterElement supplyOrgElement = new SingleFilterElement("supplyStoreOrgUnit.number", (Component)this.prmtSupplyStorageOrgUnit);
            elements.add((FilterElement)supplyOrgElement);
        }
        RangeFilterElement dateElement = new RangeFilterElement("bizDate", (Component)this.bizDateFrom, (Component)this.bizDateTo);
        dateElement.addVerifyItem(new VerifyItem(VerifyType.LESS_EQUAL_TYPE, SCMClientUtils.getResource((String)"CompareDate")));
        elements.add((FilterElement)dateElement);
        ColConnFilterElement mainOrgElement = new ColConnFilterElement("storageOrgUnit.id", (Component)this.bizPromptStOrgUnitFrom);
        mainOrgElement.addVerifyItem(new VerifyItem(VerifyType.REQUIRED_TYPE, InvClientUtils.getResource("StorageOrgUnitNotNull")));
        elements.add((FilterElement)mainOrgElement);
        elements.add((FilterElement)new SingleFilterElement("entry.picker.number", (Component)this.prmtPicker, null));
        elements.add((FilterElement)new SingleFilterElement("baseStatus", (Component)this.comboxBillStatus, (Object)BillBaseStatusEnum.NULL));
        this.getFilterManager().setElement((FilterElement)elements);
        this.getFilterManager().setMainOrgElement((FilterElement)mainOrgElement, "storageOrgUnit.id");
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Storage;
    }

    private void setF7Filter() throws Exception {
        this.setBizMaterialF7(this.bizPromptMaterialNumFrom, false, null);
        this.setBizMaterialF7(this.bizPromptMaterialNumTo, false, null);
        HashMap<String, Boolean> ctx = new HashMap<String, Boolean>();
        ctx.put("IS_SINGLE_SELECT", false);
        PersonPromptBox box = new PersonPromptBox((IUIObject)this, ctx);
        box.setEnabledMultiSelection(true);
        box.showAllAdmin();
        this.prmtPicker.setSelector((KDPromptSelector)box);
        this.prmtPicker.setEnabledMultiSelection(true);
        this.f7Manager.registerContextChangeF7(this.prmtNumberFrom, this.getPropertyOfMainBizOrg());
        this.f7Manager.registerContextChangeF7(this.prmtNumberTo, this.getPropertyOfMainBizOrg());
        this.f7Manager.registerContextChangeF7(this.bizPromptWarehouseFrom, this.getPropertyOfMainBizOrg());
        this.f7Manager.registerContextChangeF7(this.bizPromptWarehouseTo, this.getPropertyOfMainBizOrg());
        InvClientUtils.setFilterForTransactionType(this.bizPromptTrsTypeFrom, "104");
        InvClientUtils.setFilterForTransactionType(this.bizPromptTrsTypeTo, "104");
        this.prmtNumberFrom.addCommonF7KDTableListener((CommonF7KDTableListener)new SCMCommonF7KDTableListener("baseStatus"));
        this.prmtNumberTo.addCommonF7KDTableListener((CommonF7KDTableListener)new SCMCommonF7KDTableListener("baseStatus"));
        this.setNeedMainOrgF7s(new KDBizPromptBox[]{this.bizPromptMaterialNumFrom, this.bizPromptMaterialNumTo, this.bizPromptCostObjectNumFrom, this.bizPromptCostObjectNumTo});
        this.setBillNumberF7s(new KDBizPromptBox[]{this.prmtNumberFrom, this.prmtNumberTo});
        this.setBizTypeF7Filter(this.prmtBizTypeForm);
        this.setBizTypeF7Filter(this.prmtBizTypeTo);
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.companyMap = new HashMap();
        this.setF7Filter();
        this.setDefaultValue();
        if (this.getMainBizOrgF7().getText() != null) {
            this.mainOrgChanged();
        }
        this.bizPromptStOrgUnitFrom.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                try {
                    MaterialReqBillFilterUI.this.bizPromptStOrgUnitFrom_dataChanged(eventObj);
                }
                catch (Exception exc) {
                    MaterialReqBillFilterUI.this.handUIException(exc);
                }
            }
        });
        this.prmtSupplyStorageOrgUnit.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                try {
                    Object supplyStOrgUnitObjects = MaterialReqBillFilterUI.this.prmtSupplyStorageOrgUnit.getValue();
                    if (supplyStOrgUnitObjects != null) {
                        HashSet<String> idSet = new HashSet<String>();
                        if (supplyStOrgUnitObjects instanceof StorageOrgUnitInfo) {
                            StorageOrgUnitInfo supplyStOrgUnit = (StorageOrgUnitInfo)supplyStOrgUnitObjects;
                            idSet.add(supplyStOrgUnit.getId().toString());
                        } else if (supplyStOrgUnitObjects instanceof Object[]) {
                            Object[] supplyStOrgUnitObjectArr;
                            for (Object supplyStOrgUnitObject : supplyStOrgUnitObjectArr = (Object[])supplyStOrgUnitObjects) {
                                if (supplyStOrgUnitObject == null || !(supplyStOrgUnitObject instanceof StorageOrgUnitInfo)) continue;
                                StorageOrgUnitInfo supplyStOrgUnit = (StorageOrgUnitInfo)supplyStOrgUnitObject;
                                idSet.add(supplyStOrgUnit.getId().toString());
                            }
                        }
                        if (idSet.size() > 0) {
                            EntityViewInfo viewInfo = new EntityViewInfo();
                            FilterInfo filterInfo = new FilterInfo();
                            FilterItemInfo snFilter = new FilterItemInfo("storageOrgUnit.id", idSet, CompareType.INCLUDE);
                            filterInfo.getFilterItems().add(snFilter);
                            viewInfo.setFilter(filterInfo);
                            MaterialReqBillFilterUI.this.prmtSupplyWareHSFrom.setEntityViewInfo(viewInfo);
                            MaterialReqBillFilterUI.this.prmtSupplyWareHSTo.setEntityViewInfo(viewInfo);
                        } else {
                            MaterialReqBillFilterUI.this.prmtSupplyWareHSFrom.setEntityViewInfo(null);
                            MaterialReqBillFilterUI.this.prmtSupplyWareHSTo.setEntityViewInfo(null);
                        }
                    } else {
                        MaterialReqBillFilterUI.this.prmtSupplyWareHSFrom.setEntityViewInfo(null);
                        MaterialReqBillFilterUI.this.prmtSupplyWareHSTo.setEntityViewInfo(null);
                    }
                }
                catch (Exception exc) {
                    MaterialReqBillFilterUI.this.handUIException(exc);
                }
            }
        });
        if (this.isSubContract) {
            this.setSubContractF7Filters();
        }
        this.setMainBizF7(this.prmtSupplyStorageOrgUnit);
    }

    public void bizPromptStOrgUnitFrom_dataChanged(DataChangeEvent e) throws Exception {
        Object[] sous;
        Object sou = this.getMainBizOrgF7().getData();
        if (sou != null && sou instanceof StorageOrgUnitInfo) {
            this.CU = ((StorageOrgUnitInfo)sou).getCU();
            this.setCostObjectF7Filter(this.bizPromptCostObjectNumFrom);
            this.setCostObjectF7Filter(this.bizPromptCostObjectNumTo);
        } else if (sou != null && sou instanceof Object[] && (sous = (Object[])this.getMainBizOrgF7().getData()) != null && sous.length > 0) {
            this.CU = sous[0] instanceof StorageOrgUnitInfo ? ((StorageOrgUnitInfo)sous[0]).getCU() : (sous[0] instanceof FullOrgUnitInfo ? ((FullOrgUnitInfo)sous[0]).getCU() : SysContext.getSysContext().getCurrentCtrlUnit());
            Object[] companycol = this.getCompanyInfos(sous);
            this.setCostObjectF7Filter(this.bizPromptCostObjectNumFrom, companycol);
            this.setCostObjectF7Filter(this.bizPromptCostObjectNumTo, companycol);
        }
    }

    protected void setDefaultValue() {
        SCMQueryFormat.formatStartTime((KDDatePicker)this.bizDateFrom);
        SCMQueryFormat.formatEndTime((KDDatePicker)this.bizDateTo);
        SCMQueryFormat.formatBillStatus((ISCMBillStatusControl)this, (KDComboBox)this.comboxBillStatus);
    }

    public Object[] getUnVisibleBillStatus() {
        return new Object[]{BillBaseStatusEnum.RELEASED, BillBaseStatusEnum.BLOCKED, BillBaseStatusEnum.CLOSED};
    }

    public Object[] getAdditiveBillStatus() {
        return null;
    }

    public KDBizPromptBox getMainBizOrgF7() {
        return this.bizPromptStOrgUnitFrom;
    }

    protected String getViewPermission() {
        return "materialreq_view";
    }

    protected String getPropertyOfMainBizOrg() {
        return "storageOrgUnit.id";
    }

    private void setSubContractF7Filters() {
        EntityViewInfo viewInfo = InvClientUtils.getBizStorageFilter();
        this.prmtNumberFrom.setEntityViewInfo(viewInfo);
        this.prmtNumberTo.setEntityViewInfo(viewInfo);
        this.setBillF7(this.prmtNumberFrom, this.isSubContract);
        this.setBillF7(this.prmtNumberTo, this.isSubContract);
        InvClientUtils.setFilterForTransactionType(this.bizPromptTrsTypeFrom, "104", this.isSubContract);
        InvClientUtils.setFilterForTransactionType(this.bizPromptTrsTypeTo, "104", this.isSubContract);
    }

    private void setBillF7(KDBizPromptBox bizSupplierBox, boolean isSubContract) {
        this.addF7Filter(bizSupplierBox, this.getBillFilter(isSubContract));
    }

    private void addF7Filter(KDBizPromptBox bizMaterialBox, FilterInfo filterInfo) {
        if (bizMaterialBox != null) {
            EntityViewInfo entityViewInfo = bizMaterialBox.getEntityViewInfo();
            if (entityViewInfo == null || !FilterUtility.hasFilterItem((FilterInfo)entityViewInfo.getFilter())) {
                entityViewInfo = new EntityViewInfo();
                entityViewInfo.setFilter(filterInfo);
            } else {
                try {
                    entityViewInfo.getFilter().mergeFilter(filterInfo, "AND");
                }
                catch (Exception e) {
                    this.handUIException(e);
                }
            }
            bizMaterialBox.setEntityViewInfo(entityViewInfo);
        }
    }

    private FilterInfo getBillFilter(boolean isSubContract) {
        FilterInfo filterInfo = new FilterInfo();
        FilterItemInfo info = null;
        info = isSubContract ? new FilterItemInfo("purchaseType", (Object)new Integer(1)) : new FilterItemInfo("purchaseType", (Object)new Integer(0));
        filterInfo.getFilterItems().add(info);
        return filterInfo;
    }

    private void setBizTypeF7Filter(KDBizPromptBox kDBizPromptBox) {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("billType.id", (Object)"50957179-0105-1000-e000-0163c0a812fd463ED552", CompareType.EQUALS));
        viewInfo.setFilter(filterInfo);
        kDBizPromptBox.setEntityViewInfo(viewInfo);
    }

    private void setCostObjectF7Filter(KDBizPromptBox kDBizPromptBox) {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        StorageOrgUnitInfo storageUnit = null;
        CompanyOrgUnitInfo company = null;
        if (this.getMainBizOrgF7() != null) {
            storageUnit = (StorageOrgUnitInfo)this.getMainBizOrgF7().getData();
        }
        if (storageUnit != null) {
            if (this.companyMap.containsKey(storageUnit.getId())) {
                company = (CompanyOrgUnitInfo)this.companyMap.get(storageUnit.getId());
            } else {
                company = InvClientUtils.getCompanyInfo(storageUnit);
                this.companyMap.put(storageUnit.getId(), company);
            }
            if (company != null && company.getId() != null) {
                filterInfo.getFilterItems().add(new FilterItemInfo("company.id", (Object)company.getId().toString(), CompareType.EQUALS));
            }
        }
        CostObjectF7UISelector arg0 = new CostObjectF7UISelector(null, kDBizPromptBox, Boolean.TRUE, Boolean.FALSE, Boolean.FALSE, company == null ? null : company.getId().toString());
        kDBizPromptBox.setSelector((KDPromptSelector)arg0);
        viewInfo.setFilter(filterInfo);
        kDBizPromptBox.setEntityViewInfo(viewInfo);
        kDBizPromptBox.setCurrentCtrlUnit(this.CU);
        kDBizPromptBox.getQueryAgent().resetRuntimeEntityView();
    }

    private void setCostObjectF7Filter(KDBizPromptBox kDBizPromptBox, Object[] companycol) throws EASBizException, BOSException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        if (companycol != null && companycol.length > 0) {
            StringBuffer sb = new StringBuffer();
            int length = companycol.length;
            for (int i = 0; i < length && companycol[i] != null; ++i) {
                if (((CompanyOrgUnitInfo)companycol[i]).getId() == null) continue;
                sb.append(((CompanyOrgUnitInfo)companycol[i]).getId().toString());
                if (i >= length - 1) continue;
                sb.append(",");
            }
            if (sb.length() > 0) {
                filterInfo.getFilterItems().add(new FilterItemInfo("company.id", (Object)sb.toString(), CompareType.INCLUDE));
            }
        }
        viewInfo.setFilter(filterInfo);
        kDBizPromptBox.setEntityViewInfo(viewInfo);
        kDBizPromptBox.setCurrentCtrlUnit(this.CU);
        kDBizPromptBox.getQueryAgent().resetRuntimeEntityView();
    }

    private CompanyOrgUnitInfo[] getCompanyInfos(Object[] souInfos) throws EASBizException, BOSException {
        CompanyOrgUnitInfo[] companycol = new CompanyOrgUnitInfo[souInfos.length * 2];
        companycol = InvClientUtils.getCompanyInfos2(souInfos);
        return companycol;
    }

    @Override
    public boolean isPrepareInit() {
        return true;
    }
}

