/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTCell;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDTabbedPane;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.data.NLSSortType;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.ui.util.IUIActionPostman;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.CustomerQueryPanel;
import com.kingdee.eas.base.dap.client.DAPFromMultiBillTypeEditUI;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.framework.util.KDTableUtil;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.IOrgUnitRelation;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.basedata.scm.common.BizTypeFactory;
import com.kingdee.eas.basedata.scm.common.BizTypeInfo;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.dynbusiness.condition.ParameterItem;
import com.kingdee.eas.framework.FrameWorkException;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.framework.batchaction.ActionLevelEnum;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.framework.batchaction.BatchSelectionEntries;
import com.kingdee.eas.framework.client.CoreBillListUI;
import com.kingdee.eas.framework.config.ColumnItemData;
import com.kingdee.eas.framework.config.UserCustomConfigItemData;
import com.kingdee.eas.framework.query.QuickFilteringSupportItems;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.client.config.InventorySumConditionInfo;
import com.kingdee.eas.scm.im.inv.IMaterialReqBillEntry;
import com.kingdee.eas.scm.im.inv.MaterialReqBillCollection;
import com.kingdee.eas.scm.im.inv.MaterialReqBillEntryCollection;
import com.kingdee.eas.scm.im.inv.MaterialReqBillEntryFactory;
import com.kingdee.eas.scm.im.inv.MaterialReqBillEntryInfo;
import com.kingdee.eas.scm.im.inv.MaterialReqBillFactory;
import com.kingdee.eas.scm.im.inv.MaterialReqBillInfo;
import com.kingdee.eas.scm.im.inv.client.AbstractMaterialReqBillListUI;
import com.kingdee.eas.scm.im.inv.client.InvClientUtils;
import com.kingdee.eas.scm.im.inv.client.MaterialReqBillEditUI;
import com.kingdee.eas.scm.im.inv.client.MaterialReqBillFilterUI;
import com.kingdee.eas.scm.util.SCMSelectorFactory;
import com.kingdee.eas.tools.datatask.DatataskParameter;
import com.kingdee.eas.tools.datatask.client.DatataskCaller;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class MaterialReqBillListUI
extends AbstractMaterialReqBillListUI {
    private static final long serialVersionUID = 265063590070232226L;
    private MaterialReqBillFilterUI filterUI = null;
    private IUIWindow materialTransactionWindow = null;
    public static final String RES_InvUI = "com.kingdee.eas.basedata.scm.im.inv.client.InvResource";
    public int amtPrecision = 2;
    private static final String[] subConHideCols = new String[]{"productLine", "classGroup", "person", "productLineWP", "trackNumCol", "saleOrderNum", "issueQty", "baseIssueQty", "pickingDate", "demandDate", "supplyLocation", "supplyWareHS", "settlePrice"};
    public static final String WRITEBAK_SCM_VOUCHER = "FA_032";
    private static final String TB_NEED_STORAGE_ID = "storageOrgUnit.id";
    private static final String TB_SUPPLY_STORAGE_ID = "supplyStoreOrgUnit.id";
    private QuickFilteringSupportItems qfsi = new QuickFilteringSupportItems(true, true);

    public String getUITitle() {
        if (this.isSubContractBill()) {
            return EASResource.getString((String)"com.kingdee.eas.scm.im.inv.client.InvResource", (String)"SubContractMatReqBill");
        }
        return EASResource.getString((String)"com.kingdee.eas.scm.im.inv.client.InvResource", (String)"MaterialReqBill");
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.initFormatTable();
        if (this.getUIContext().get("BillMainQuery") != null) {
            this.setQueryPreference(true);
            this.tHelper = null;
            this.initHelper();
        }
    }

    protected CommonQueryDialog initCommonQueryDialog() {
        this.commonQueryDialog = super.initCommonQueryDialog();
        this.commonQueryDialog.setWidth(508);
        this.commonQueryDialog.setHeight(430);
        return this.commonQueryDialog;
    }

    @Override
    public SelectorItemCollection getBOTPSelectors() {
        SelectorItemCollection sic = super.getBOTPSelectors();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("entry.*"));
        sic.add(new SelectorItemInfo("supplier.name"));
        sic.add(new SelectorItemInfo("supplier.number"));
        sic.add(new SelectorItemInfo("supplier.isInternalCompany"));
        sic.add(new SelectorItemInfo("storageOrgUnit.name"));
        sic.add(new SelectorItemInfo("storageOrgUnit.number"));
        sic.add(new SelectorItemInfo(TB_NEED_STORAGE_ID));
        sic.add(new SelectorItemInfo("entry.id"));
        sic.add(new SelectorItemInfo("entry.storageOrgUnit.name"));
        sic.add(new SelectorItemInfo("entry.storageOrgUnit.number"));
        sic.add(new SelectorItemInfo("entry.companyOrgUnit.name"));
        sic.add(new SelectorItemInfo("entry.companyOrgUnit.number"));
        sic.add(new SelectorItemInfo("entry.qty"));
        sic.add(new SelectorItemInfo("entry.unitPrice"));
        sic.add(new SelectorItemInfo("entry.amount"));
        sic.add(new SelectorItemInfo("entry.sourceBillId"));
        sic.add(new SelectorItemInfo("entry.sourceBillEntryId"));
        sic.add(new SelectorItemInfo("entry.material.name"));
        sic.add(new SelectorItemInfo("entry.material.number"));
        sic.add(new SelectorItemInfo("entry.unit.name"));
        sic.add(new SelectorItemInfo("entry.unit.number"));
        sic.add(new SelectorItemInfo("entry.assistantUnit.name"));
        sic.add(new SelectorItemInfo("entry.assistantUnit.number"));
        sic.add(new SelectorItemInfo("entry.warehouse.id"));
        sic.add(new SelectorItemInfo("entry.warehouse.number"));
        sic.add(new SelectorItemInfo("entry.warehouse.name"));
        sic.add(new SelectorItemInfo("entry.warehouse.hasLocation"));
        sic.add(new SelectorItemInfo("entry.warehouse.whman.number"));
        sic.add(new SelectorItemInfo("entry.warehouse.whman.name"));
        sic.add(new SelectorItemInfo("entry.stocker.id"));
        sic.add(new SelectorItemInfo("entry.stocker.number"));
        sic.add(new SelectorItemInfo("entry.stocker.name"));
        sic.add(new SelectorItemInfo("entry.location.id"));
        sic.add(new SelectorItemInfo("entry.location.number"));
        sic.add(new SelectorItemInfo("entry.location.name"));
        return sic;
    }

    public String[] getMergeColumnKeys() {
        String[] strMergeColKeys = new String[]{"id", "number", "baseStatus", "bizType", "transactionType.name", "bizDate", "storageOrgUnit.name", "department.name", "totalStandardCost", "totalActualCost", "isOfSet", "isVoucher", "voucher.number", "creator.name", "creatorTime", "modifier.name", "modifyTime", "auditor", "auditorTime", "supplier.name", "pcVouchered", "pcVoucherNumber", "description", "processNode"};
        return strMergeColKeys;
    }

    public void initFormatTable() throws Exception {
        this.tblMain.getColumn("totalStandardCost").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblMain.getColumn("totalActualCost").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblMain.getColumn("standardCost").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblMain.getColumn("actualCost").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        InvClientUtils.setFreezeCol(this.tblMain, "baseStatus");
        this.tblMain.getColumn("creatorTime").setEditor((ICellEditor)new KDTDefaultCellEditor(new KDDatePicker()));
        this.tblMain.getColumn("creatorTime").getStyleAttributes().setNumberFormat(SCMClientUtils.strTimeFormat);
        this.tblMain.getColumn("modifyTime").setEditor((ICellEditor)new KDTDefaultCellEditor(new KDDatePicker()));
        this.tblMain.getColumn("modifyTime").getStyleAttributes().setNumberFormat(SCMClientUtils.strTimeFormat);
        this.tblMain.getColumn("auditorTime").setEditor((ICellEditor)new KDTDefaultCellEditor(new KDDatePicker()));
        this.tblMain.getColumn("auditorTime").getStyleAttributes().setNumberFormat(SCMClientUtils.strTimeFormat);
        this.tblMain.getColumn("pickingDate").getStyleAttributes().setNumberFormat(SCMClientUtils.strDateFormat);
        this.tblMain.getColumn("demandDate").getStyleAttributes().setNumberFormat(SCMClientUtils.strTimeFormat);
        this.tblMain.getColumn("unReturnedBaseQty").getStyleAttributes().setHided(true);
        this.hideSubColumns();
        this.tblMain.repaint();
    }

    private void hideSubColumns() {
        if (this.isSubContractBill()) {
            UserCustomConfigItemData configItemData = this.tHelper.getUserDataFromUI().getTableCurrentSetting("com.kingdee.eas.scm.im.inv.client.MaterialReqBillListUI.tblMain");
            if (configItemData != null) {
                Map columnData = configItemData.getColumnData();
                this.isShowCol(columnData, "supplier.name");
                this.isShowCol(columnData, "processMaterial.name");
                this.isShowCol(columnData, "issueAdminOrgUnit.name");
                this.isShowCol(columnData, "issuePerson.name");
            }
            ArrayList<String> hideCols = new ArrayList<String>();
            for (String col : subConHideCols) {
                if (!this.tblMain.getColumn(col).getStyleAttributes().isHided()) continue;
                hideCols.add(col);
            }
            SCMClientUtils.hideColumns((KDTable)this.tblMain, (String[])hideCols.toArray(new String[0]), (boolean)true);
            ArrayList cells = this.tblMain.getHead().getRow(0).getCells();
            String demandhs = InvClientUtils.getResource("DEMAND_WAREHS");
            String demandloaction = InvClientUtils.getResource("DEMAND_LOCATION");
            for (int i = 0; i < cells.size(); ++i) {
                KDTCell cell = (KDTCell)cells.get(i);
                String name = cell.getValue().toString();
                if (name.equals(demandhs)) {
                    cell.setValue((Object)name.substring(2, name.length()));
                    continue;
                }
                if (!name.equals(demandloaction)) continue;
                cell.setValue((Object)name.substring(2, name.length()));
            }
        } else {
            this.tblMain.getColumn("supplier.name").getStyleAttributes().setHided(true);
            this.tblMain.getColumn("processMaterial.name").getStyleAttributes().setHided(true);
            this.tblMain.getColumn("issueAdminOrgUnit.name").getStyleAttributes().setHided(true);
            this.tblMain.getColumn("issuePerson.name").getStyleAttributes().setHided(true);
            this.tblMain.getColumn("entry.subWrittenOffQty").getStyleAttributes().setHided(true);
            this.tblMain.getColumn("entry.subUnWriteOffQty").getStyleAttributes().setHided(true);
            this.tblMain.getColumn("entry.subWrittenOffBaseQty").getStyleAttributes().setHided(true);
            this.tblMain.getColumn("entry.subUnWriteOffBaseQty").getStyleAttributes().setHided(true);
            this.tblMain.getColumn("writtenOffAmount").getStyleAttributes().setHided(true);
            this.tblMain.getColumn("unWriteOffAmount").getStyleAttributes().setHided(true);
        }
    }

    protected void isShowCol(Map columnData, String colName) {
        ColumnItemData columnItemData;
        if (null != columnData && null != columnData.get(colName) && !(columnItemData = (ColumnItemData)columnData.get(colName)).isHidden()) {
            this.tblMain.getColumn(colName).getStyleAttributes().setHided(false);
        }
    }

    protected boolean initDefaultFilter() {
        return this.getUIContext().get("BillMainQuery") == null;
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    protected String getEditUIName() {
        return MaterialReqBillEditUI.class.getName();
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return MaterialReqBillFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext());
    }

    @Override
    public void actionAudit_actionPerformed(ActionEvent e) throws Exception {
        try {
            super.actionAudit_actionPerformed(e);
        }
        catch (Exception er) {
            this.handUIException(er);
        }
    }

    protected CompanyOrgUnitInfo getCompanyOrgUnitInfo() throws Exception {
        KDTSelectBlock selectBlock = this.tblMain.getSelectManager().get();
        if (selectBlock != null) {
            ICell cell;
            Object keyValue;
            int rowIndex = selectBlock.getTop();
            IRow row = this.tblMain.getRow(rowIndex);
            String entryID = this.getEntriesPKName();
            if (entryID != null && (keyValue = (cell = row.getCell(entryID)).getValue()) != null) {
                IMaterialReqBillEntry ipe = MaterialReqBillEntryFactory.getRemoteInstance();
                MaterialReqBillEntryInfo pie = ipe.getMaterialReqBillEntryInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)keyValue.toString())));
                return pie.getCompanyOrgUnit();
            }
        }
        return null;
    }

    protected String[] getQtyColumns() throws Exception {
        return new String[]{"entry.qty", "baseQty", "assistQty", "reverseQty", "returnsQty", "unReturnedBaseQty", "issueQty", "baseIssueQty", "entry.subWrittenOffQty", "entry.subWrittenOffBaseQty", "entry.subUnWriteOffQty", "entry.subUnWriteOffBaseQty", "entry.associateQty", "unVmiSettleBaseQty", "totalVmiSettleBaseQty"};
    }

    protected String[] getPriceColumns() throws Exception {
        return new String[]{"unitStandardCost", "unitActualCost"};
    }

    public String[] getAmountColumns() {
        return new String[]{"totalStandardCost", "totalActualCost", "standardCost", "actualCost", "writtenOffAmount", "unWriteOffAmount"};
    }

    protected void getRowSetBeforeFillTable(IRowSet rowSet) {
        if (this.isSwitchView()) {
            return;
        }
        int amoutPre = 2;
        String[] UNIT_COLUMNS = new String[]{"entry.qty", "entry.reverseQty", "subWrittenOffQty", "subUnWriteOffQty"};
        String[] BASEUNIT_COLUMNS = new String[]{"entry.baseQty", "subWrittenOffBaseQty", "subUnWriteOffBaseQty", "entry.unVmiSettleBaseQty", "entry.totalVmiSettleBaseQty"};
        String[] ASSISTUNIT_COLUMNS = new String[]{"entry.assistQty"};
        String[] PIRCE_COLUMNS = new String[]{"entry.unitStandardCost", "entry.unitActualCost"};
        String[] amount_COLUMNS = new String[]{"totalAmount", "totalStandardCost", "totalActualCost", "entry.standardCost", "entry.actualCost", "entry.scWrittenOffAmount", "entry.scUnWrittenOffAmount"};
        try {
            rowSet.beforeFirst();
            Map colMap = SCMClientUtils.getColumnsByRowSet((IRowSet)rowSet);
            while (rowSet.next()) {
                amoutPre = rowSet.getInt("baseCurrency.precision");
                SCMClientUtils.iniColumnsPrecision((int)this.qtyPrecision, (String[])UNIT_COLUMNS, (IRowSet)rowSet, (Map)colMap);
                SCMClientUtils.iniColumnsPrecision((int)this.qtyPrecision, (String[])BASEUNIT_COLUMNS, (IRowSet)rowSet, (Map)colMap);
                SCMClientUtils.iniColumnsPrecision((int)this.qtyPrecision, (String[])ASSISTUNIT_COLUMNS, (IRowSet)rowSet, (Map)colMap);
                SCMClientUtils.iniColumnsPrecision((int)this.pricePrecision, (String[])PIRCE_COLUMNS, (IRowSet)rowSet, (Map)colMap);
                SCMClientUtils.iniColumnsPrecision((int)amoutPre, (String[])amount_COLUMNS, (IRowSet)rowSet, (Map)colMap);
            }
        }
        catch (Exception ex) {
            this.handUIException(ex);
        }
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("baseCurrency.precision"));
        sic.add(new SelectorItemInfo("entry.amount"));
        sic.addObjectCollection((IObjectCollection)SCMSelectorFactory.getInvUpdateTypeSelector((boolean)true, (String)this.getEntriesName()));
        return sic;
    }

    protected boolean isSupportDynQuery() {
        return true;
    }

    @Override
    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        if (this.getUIContext().get("BillQuery") != null) {
            for (int i = 0; i < this.tblMain.getSelectManager().size(); ++i) {
                KDTSelectBlock sb = this.tblMain.getSelectManager().get(i);
                for (int j = sb.getTop(); j <= sb.getBottom(); ++j) {
                    boolean isVouchered = (Boolean)this.tblMain.getCell(j, "isVoucher").getValue();
                    boolean isReversed = (Boolean)this.tblMain.getCell(j, "isOfSet").getValue();
                    if (isVouchered) {
                        MsgBox.showInfo((Component)((Object)this), (String)InvClientUtils.getResource("CANT_EDIT_IF_VOUCHERED"));
                        SysUtil.abort();
                    }
                    if (!isReversed) continue;
                    MsgBox.showInfo((Component)((Object)this), (String)InvClientUtils.getResource("CANT_EDIT_IF_ISREVERSED"));
                    SysUtil.abort();
                }
            }
        }
        super.actionEdit_actionPerformed(e);
    }

    protected CustomerQueryPanel getFilterUI() throws Exception {
        if (this.filterUI == null) {
            this.filterUI = this.isSubContractBill() ? new MaterialReqBillFilterUI(true) : new MaterialReqBillFilterUI();
        }
        return this.filterUI;
    }

    @Override
    public void initBatchActions() throws BOSException {
        this.actionManager.setClzIBizFactory(ActionLevelEnum.HEAD, MaterialReqBillFactory.class);
        this.actionManager.setClzIBizFactory(ActionLevelEnum.ENTRY, MaterialReqBillEntryFactory.class);
        this.getTableSelectionHelper().setTableProperty((CoreBillListUI)this, this.mainQueryPK, this.tblMain, "id", "entry.id", "number", "entry.seq", TB_NEED_STORAGE_ID);
        super.initBatchActions();
    }

    protected boolean getParameterValue(String storageUnitID, String parameterName) throws Exception {
        boolean value = false;
        IOrgUnitRelation iUnitRel = OrgUnitRelationFactory.getRemoteInstance();
        OrgUnitCollection orgCol = iUnitRel.getToUnit(storageUnitID, 4, 1);
        CompanyOrgUnitInfo companyOrgUnit = (CompanyOrgUnitInfo)orgCol.get(0);
        if (companyOrgUnit.getId().toString() != null && companyOrgUnit.getId().toString().length() > 0) {
            ParameterItem item = new ParameterItem(parameterName);
            value = item.getValueAsBoolean(null, (IObjectPK)new ObjectUuidPK(companyOrgUnit.getId()));
        }
        return value;
    }

    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        super.actionQuery_actionPerformed(e);
        if (!this.isSubContractBill()) {
            SCMClientUtils.hideColumns((KDTable)this.tblMain, (String[])new String[]{"entry.subWrittenOffQty", "entry.subWrittenOffBaseQty", "entry.subUnWriteOffQty", "entry.subUnWriteOffBaseQty", "writtenOffAmount", "unWriteOffAmount"}, (boolean)true);
        }
    }

    public void actionVoucher_actionPerformed(ActionEvent e) throws Exception {
        ArrayList idList = this.getSelectedIdValues();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo(TB_NEED_STORAGE_ID));
        sic.add(new SelectorItemInfo("bizType.number"));
        sic.add(new SelectorItemInfo("bizType.id"));
        filter.getFilterItems().add(new FilterItemInfo("id", new HashSet(idList), CompareType.INCLUDE));
        view.setFilter(filter);
        view.setSelector(sic);
        MaterialReqBillCollection coll = MaterialReqBillFactory.getRemoteInstance().getMaterialReqBillCollection(view);
        String[] orgIDs = new String[coll.size()];
        HashSet<String> bizTypes = new HashSet<String>();
        for (int i = 0; i < coll.size(); ++i) {
            orgIDs[i] = coll.get(i).getStorageOrgUnit().getId().toString();
            bizTypes.add(coll.get(i).getBizType().getNumber());
        }
        boolean needCheck = this.isNeedCheckParam(bizTypes);
        if (!InvClientUtils.checkStorageConsignSameCompany(orgIDs)) {
            return;
        }
        if (orgIDs != null && orgIDs.length > 0 && this.getParameterValue(orgIDs[0], WRITEBAK_SCM_VOUCHER) && needCheck) {
            return;
        }
        HashSet<String> set = new HashSet<String>();
        int size = orgIDs.length;
        for (int i = 0; i < size; ++i) {
            set.add(orgIDs[i]);
        }
        Object[] orgIDs2 = set.toArray();
        try {
            IPermission iPer = PermissionFactory.getRemoteInstance();
            for (int index = 0; index < orgIDs2.length; ++index) {
                iPer.checkFunctionPermission((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)SysContext.getSysContext().getCurrentUserInfo().getId().toString())), (IObjectPK)new ObjectUuidPK(BOSUuid.read((String)orgIDs2[index].toString())), "materialreq_generalVoucher");
            }
        }
        catch (Exception ex) {
            this.handUIException(ex);
            return;
        }
        OrgUnitInfo orgUnitInfo = new OrgUnitInfo();
        orgUnitInfo.setId(BOSUuid.read((String)orgIDs[0]));
        this.getUIContext().put(this.getMainBizOrgType(), orgUnitInfo);
        super.actionVoucher_actionPerformed(e);
    }

    private boolean isNeedCheckParam(String[] bizTypes) throws Exception {
        boolean result = false;
        HashSet<String> set = new HashSet<String>();
        if (bizTypes == null) {
            return result;
        }
        for (int i = 0; i < bizTypes.length; ++i) {
            if (set.contains(bizTypes[i])) continue;
            set.add(bizTypes[i]);
        }
        String oql = "where number = '341'";
        BizTypeInfo bizType = BizTypeFactory.getRemoteInstance().getBizTypeInfo(oql);
        if (bizType != null && set.contains(bizType.getName())) {
            result = true;
        }
        return result;
    }

    protected IMetaDataPK getTDQueryPK() {
        if (this.isSubContractBill()) {
            return MetaDataPK.create((String)"com.kingdee.eas.scm.im.inv.MaterialReqSubcontractPrintQuery");
        }
        return MetaDataPK.create((String)"com.kingdee.eas.scm.im.inv.MaterialReqPrintQuery");
    }

    protected String getTDFileName() {
        if (this.isSubContractBill()) {
            return "/SCM/SM/SubContract/SubContractMaterialreq";
        }
        return "/SCM/IM/Issue/MaterialReqBill";
    }

    public void actionMultiPrint_actionPerformed(ActionEvent arg0) throws Exception {
        super.actionMultiPrint_actionPerformed(arg0);
    }

    public void actionMultiPrintPreview_actionPerformed(ActionEvent arg0) throws Exception {
        super.actionMultiPrintPreview_actionPerformed(arg0);
    }

    protected FilterInfo getDefaultFilterForQuery() {
        FilterInfo filterInfo = super.getDefaultFilterForQuery();
        boolean isCreateTo = Integer.valueOf("0").equals(this.getUIContext().get("BTPCreateMode"));
        if (!isCreateTo && this.getBOTPViewStatus() == 1) {
            return filterInfo;
        }
        if (!(filterInfo == null || this.getUIContext().get("Owner") != null && this.getUIContext().get("Owner") instanceof DAPFromMultiBillTypeEditUI)) {
            if (this.isSubContractBill()) {
                filterInfo.getFilterItems().add(new FilterItemInfo("purchaseType", (Object)new Integer(1)));
            } else {
                filterInfo.getFilterItems().add(new FilterItemInfo("purchaseType", (Object)new Integer(0)));
            }
        }
        return filterInfo;
    }

    protected ArrayList getImportParam() {
        String solutionName;
        DatataskParameter param = new DatataskParameter();
        param.solutionName = solutionName = "eas.30im.MaterialReq";
        ArrayList<DatataskParameter> paramList = new ArrayList<DatataskParameter>();
        paramList.add(param);
        return paramList;
    }

    public void actionImportData_actionPerformed(ActionEvent e) throws Exception {
        this.getMainOrgContext().put((Object)"isSubContractBill", (Object)new Boolean(this.isSubContractBill()));
        super.actionImportData_actionPerformed(e);
    }

    public void actionExportData_actionPerformed(ActionEvent e) throws Exception {
        ArrayList para = this.getExportParam();
        if (para == null || para.size() <= 0) {
            throw new FrameWorkException(FrameWorkException.EXPORTDATAPARANULL);
        }
        DatataskCaller dc = new DatataskCaller();
        dc.setParentComponent((Component)((Object)this));
        dc.setMainOrgContext(this.getMainOrgContext());
        dc.invoke(para, 1);
    }

    protected ArrayList getExportParam() {
        DatataskParameter param = new DatataskParameter();
        param.solutionName = "eas.30im.MaterialReq";
        param.datataskMode = 1;
        param.varList = new ArrayList();
        param.alias = EASResource.getString((String)RES_InvUI, (String)"MATERIALREQ");
        Hashtable<String, FilterInfo> hashtable = new Hashtable<String, FilterInfo>();
        try {
            hashtable.put("filter", this.mainQuery.getFilter());
        }
        catch (Exception exception) {
            // empty catch block
        }
        param.setContextParam(hashtable);
        ArrayList<DatataskParameter> paramList = new ArrayList<DatataskParameter>();
        paramList.add(param);
        return paramList;
    }

    @Override
    public void actionCancelMaterial_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"optype", (Object)"2");
        this.materialTransactionWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create("com.kingdee.eas.mm.mo.client.MaterialTransactionPlatformUI", (Map)uiContext, null, OprtState.VIEW);
        this.materialTransactionWindow.show();
    }

    @Override
    public void actionGetMaterial_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"optype", (Object)"1");
        this.materialTransactionWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create("com.kingdee.eas.mm.mo.client.MaterialTransactionPlatformUI", (Map)uiContext, null, OprtState.VIEW);
        this.materialTransactionWindow.show();
    }

    @Override
    public boolean isPrepareInit() {
        return true;
    }

    @Override
    public IUIActionPostman prepareInit() {
        RequestContext request = new RequestContext();
        request.setClassName("com.kingdee.eas.scm.im.inv.app.MaterialReqBillListUIHandler");
        IUIActionPostman handler = super.prepareInit();
        handler.setRequestContext((Serializable)request);
        return handler;
    }

    protected IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo) {
        if (this.getUIContext().get("BillMainQuery") != null) {
            viewInfo = (EntityViewInfo)this.getUIContext().get("BillMainQuery");
        }
        if (viewInfo != null && viewInfo.getSorter() != null && viewInfo.getSorter().size() > 0 && !viewInfo.getSorter().toString().equals("")) {
            SorterItemCollection sorters = viewInfo.getSorter();
            SortType sortType = null;
            boolean hasPickerSorter = false;
            for (int i = 0; i < sorters.size(); ++i) {
                if (!sorters.get(i).getPropertyName().equals("picker.name")) continue;
                hasPickerSorter = true;
                sortType = sorters.get(i).getSortType();
                viewInfo.getSorter().remove(sorters.get(i));
            }
            if (hasPickerSorter) {
                SorterItemInfo bSorterItemInfo = new SorterItemInfo("picker.name");
                bSorterItemInfo.setSortType(sortType == null ? SortType.ASCEND : sortType);
                bSorterItemInfo.setNLSSortType(NLSSortType.getEnum((String)"SCHINESE_PINYIN"));
                viewInfo.getSorter().add(bSorterItemInfo);
            }
        }
        IQueryExecutor exec = super.getQueryExecutor(queryPK, viewInfo);
        return exec;
    }

    public boolean isPrepareActionQuery() {
        return false;
    }

    public boolean isPrepareActionDelVoucher() {
        return false;
    }

    protected String[] getQueryShowField() {
        return new String[]{"number", "baseStatus", "bizDate", "storageOrgUnit.name", "costOrgUnit.name", "costObjectName", "material.number", "material.name", "material.model", "transactionType.name", "unit.name", "entry.qty", "warehouse.name", "location.name", "supplier.name"};
    }

    protected boolean isLazyMode() {
        return !Boolean.TRUE.equals(this.getUIContext().get("isFromWorkflowMultiapprove"));
    }

    public String getsourceBillEntryId() {
        return "entry.sourceBillEntryId";
    }

    protected String[] getQueryHideField() {
        return new String[]{"isVoucher", "isOfSet", TB_NEED_STORAGE_ID};
    }

    public void refreshList() throws Exception {
        this.hideSubColumns();
        super.refreshList();
    }

    protected QuickFilteringSupportItems getQuickFilteringSupport() {
        if (this.getUIContext().get("BillQuery") != null) {
            return super.getQuickFilteringSupport();
        }
        return this.qfsi;
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.menuItemMultiapprove.setVisible(false);
        this.btnMultiapprove.setVisible(false);
        this.menuItemExportData.setVisible(true);
        this.menuItemImportData.setVisible(true);
        if (this.isSubContractBill()) {
            this.menuItemGetMaterial.setEnabled(false);
            this.menuItemGetMaterial.setVisible(false);
            this.menuItemCancelMaterial.setEnabled(false);
            this.menuItemCancelMaterial.setVisible(false);
        } else {
            this.menuItemGetMaterial.setVisible(true);
            this.menuItemCancelMaterial.setEnabled(true);
            this.menuItemGetMaterial.setVisible(true);
            this.menuItemCancelMaterial.setEnabled(true);
        }
        this.actionDiscard.setEnabled(true);
        this.actionDiscard.setVisible(true);
    }

    protected boolean isSupportBatchSubmitAction() {
        return true;
    }

    protected boolean isPCVoucherVisible() {
        return true;
    }

    @Override
    protected String getGeneralPCVoucherPermission() {
        return "materialreq_generalPcVoucher";
    }

    @Override
    protected String getStorageColName() {
        return TB_NEED_STORAGE_ID;
    }

    @Override
    protected void checkOtherForPCVoucher() throws Exception {
        super.checkOtherForPCVoucher();
        String[] orgIDs = KDTableUtil.getSelectRowFieldValue((KDTable)this.tblMain, (String)TB_NEED_STORAGE_ID);
        String[] bizTypes = KDTableUtil.getSelectRowFieldValue((KDTable)this.tblMain, (String)"bizType");
        boolean needCheck = false;
        try {
            needCheck = this.isNeedCheckParam(bizTypes);
        }
        catch (Exception e) {
            this.handleException(e);
            this.abort();
        }
        if (orgIDs != null && orgIDs.length > 0) {
            boolean writebak_scm_voucher = false;
            try {
                writebak_scm_voucher = this.getParameterValue(orgIDs[0], WRITEBAK_SCM_VOUCHER);
            }
            catch (Exception e) {
                this.handleException(e);
                this.abort();
            }
            if (writebak_scm_voucher && needCheck) {
                this.abort();
            }
        }
    }

    protected BOSObjectType getBOSType() {
        return new MaterialReqBillInfo().getBOSType();
    }

    public void onShow() throws Exception {
        if (this.getParent().getParent() instanceof KDTabbedPane) {
            KDTabbedPane tabbPane = (KDTabbedPane)this.getParent().getParent();
            if (this.isSubContractBill()) {
                for (int i = 0; i < tabbPane.getTabCount(); ++i) {
                    tabbPane.setTitleAt(i, this.transmitSubTitle(tabbPane.getTitleAt(i)));
                }
            }
        }
        super.onShow();
    }

    private String transmitSubTitle(String title) {
        String resultTitle = title;
        if (title.equals(EASResource.getString((String)"com.kingdee.eas.scm.im.inv.client.InvResource", (String)"PurInWarehsBill"))) {
            resultTitle = EASResource.getString((String)"com.kingdee.eas.scm.im.inv.client.InvResource", (String)"SubContractInWarehsBill");
        }
        if (title.equals(EASResource.getString((String)"com.kingdee.eas.scm.im.inv.client.InvResource", (String)"MaterialReqBill"))) {
            resultTitle = EASResource.getString((String)"com.kingdee.eas.scm.im.inv.client.InvResource", (String)"SubContractMatReqBill");
        }
        if (title.equals(EASResource.getString((String)"com.kingdee.eas.scm.im.inv.client.InvResource", (String)"PurReceivalBill"))) {
            resultTitle = EASResource.getString((String)"com.kingdee.eas.scm.im.inv.client.InvResource", (String)"SubContractReceivalBill");
        }
        return resultTitle;
    }

    private boolean isNeedCheckParam(Set bizTypes) throws Exception {
        boolean result = false;
        if (bizTypes.contains("341")) {
            result = true;
        }
        return result;
    }

    @Override
    public boolean beforeAction(BatchActionEnum bizAction, BatchSelectionEntries selectionEntries, ActionEvent event) {
        if (bizAction.equals((Object)BatchActionEnum.SUBMIT)) {
            try {
                if (this.verifyZero()) {
                    return false;
                }
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        }
        return super.beforeAction(bizAction, selectionEntries, event);
    }

    protected boolean verifyZero() throws Exception {
        int ret;
        StringBuffer errorSb = new StringBuffer();
        EntityViewInfo view = new EntityViewInfo();
        ArrayList idList = this.getSelectedIdValues();
        FilterInfo filter = new FilterInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("baseStatus"));
        sic.add(new SelectorItemInfo("entry.id"));
        sic.add(new SelectorItemInfo("entry.seq"));
        sic.add(new SelectorItemInfo("entry.baseQty"));
        filter.getFilterItems().add(new FilterItemInfo("id", new HashSet(idList), CompareType.INCLUDE));
        view.setFilter(filter);
        view.setSelector(sic);
        MaterialReqBillInfo info = null;
        MaterialReqBillEntryCollection entryColl = null;
        MaterialReqBillEntryInfo entry = null;
        BigDecimal baseQty = null;
        MaterialReqBillCollection coll = MaterialReqBillFactory.getRemoteInstance().getMaterialReqBillCollection(view);
        for (int i = 0; i < coll.size(); ++i) {
            info = coll.get(i);
            if (info.getBaseStatus() != null && !info.getBaseStatus().equals((Object)BillBaseStatusEnum.TEMPORARILYSAVED) && !info.getBaseStatus().equals((Object)BillBaseStatusEnum.SUBMITED) || (entryColl = info.getEntry()) == null) continue;
            for (int j = 0; j < entryColl.size(); ++j) {
                entry = entryColl.get(j);
                baseQty = entry.getBaseQty();
                if (baseQty != null && SysConstant.BIGZERO.compareTo(baseQty) != 0) continue;
                errorSb.append(info.getNumber()).append(EASResource.getString((String)"com.kingdee.eas.scm.im.inv.InvAddResource.Line", (Object[])new Object[]{j + 1 + ""})).append("\n");
            }
        }
        return errorSb.length() > 0 && (ret = MsgBox.showConfirm3a((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.scm.im.inv.InvAddResource.EXIST_ZEROQTY_ENTRY"), (String)errorSb.toString())) != 0;
    }

    protected List<InventorySumConditionInfo> getInventorySumConditions() throws Exception {
        if (this.isSubContractBill()) {
            return null;
        }
        ArrayList<InventorySumConditionInfo> result = super.getInventorySumConditions();
        if (result == null) {
            result = new ArrayList<InventorySumConditionInfo>();
        }
        HashMap<String, String> billIdAndStorageOrgUnitIdMap = new HashMap<String, String>();
        int count = this.tblMain.getRowCount();
        for (int i = 0; i < count; ++i) {
            Object storageOrgUnitObj = this.tblMain.getCell(i, TB_SUPPLY_STORAGE_ID).getValue();
            billIdAndStorageOrgUnitIdMap.put(this.tblMain.getCell(i, this.getKeyFieldName()).getValue().toString(), storageOrgUnitObj == null ? null : storageOrgUnitObj.toString());
        }
        if (result.size() == 0) {
            InventorySumConditionInfo inventorySumConditionInfo = new InventorySumConditionInfo();
            inventorySumConditionInfo.setBillEntryName(this.getEntriesName());
            inventorySumConditionInfo.setTable(this.tblMain);
            inventorySumConditionInfo.setQtyName(this.getBaseQtyName());
            inventorySumConditionInfo.setBillIdAndStorageOrgUnitIdMap(billIdAndStorageOrgUnitIdMap);
            result.add(inventorySumConditionInfo);
        } else {
            for (InventorySumConditionInfo inventorySumConditionInfo : result) {
                inventorySumConditionInfo.setBillIdAndStorageOrgUnitIdMap(billIdAndStorageOrgUnitIdMap);
            }
        }
        return result;
    }
}

