/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.client;

import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.person.IPerson;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.client.PersonPromptBox;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.ObjectBaseInfo;
import com.kingdee.eas.mm.common.client.UIHelper;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.client.ISCMBillStatusControl;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.client.SCMGroupClientUtils;
import com.kingdee.eas.scm.common.filter.ColConnFilterElement;
import com.kingdee.eas.scm.common.filter.CompositeFilterElement;
import com.kingdee.eas.scm.common.filter.FilterElement;
import com.kingdee.eas.scm.common.filter.RangeFilterElement;
import com.kingdee.eas.scm.common.filter.SingleFilterElement;
import com.kingdee.eas.scm.common.util.SCMQueryFormat;
import com.kingdee.eas.scm.common.verify.VerifyItem;
import com.kingdee.eas.scm.common.verify.VerifyType;
import com.kingdee.eas.scm.im.inv.client.AbstractMaterialRequestFilterUI;
import com.kingdee.eas.scm.im.inv.client.InvClientUtils;
import java.awt.Component;
import java.util.HashMap;
import java.util.HashSet;
import org.apache.log4j.Logger;

public class MaterialRequestFilterUI
extends AbstractMaterialRequestFilterUI
implements ISCMBillStatusControl {
    private static final Logger logger = CoreUIObject.getLogger(MaterialRequestFilterUI.class);
    private CompanyOrgUnitInfo cou = null;
    private OrgUnitCollection couColl = null;
    private IPerson iperson = PersonFactory.getRemoteInstance();

    public MaterialRequestFilterUI() throws Exception {
        this.getElementsInfo();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    private void getElementsInfo() {
        CompositeFilterElement elements = new CompositeFilterElement(0);
        elements.add((FilterElement)new RangeFilterElement("number", (Component)this.prmtNumberFrom, (Component)this.prmtNumberTo));
        elements.add((FilterElement)new RangeFilterElement("bizType.number", (Component)this.bizPromptBizTypeFrom, (Component)this.bizPromptBizTypeTo));
        elements.add((FilterElement)new RangeFilterElement("material.number", (Component)this.bizPromptMaterialNumFrom, (Component)this.bizPromptMaterialNumTo));
        elements.add((FilterElement)new RangeFilterElement("outStorage.number", (Component)this.bizPromptOutStorage, (Component)this.bizPromptOutStorageTo));
        UIHelper.registerProjectF7ForFilter((KDBizPromptBox)this.getMainBizOrgF7(), (KDBizPromptBox)this.prmtProjectNumFrom);
        UIHelper.registerProjectF7ForFilter((KDBizPromptBox)this.getMainBizOrgF7(), (KDBizPromptBox)this.prmtProjectNumTo);
        elements.add((FilterElement)new RangeFilterElement("project.number", (Component)this.prmtProjectNumFrom, (Component)this.prmtProjectNumTo));
        UIHelper.registerTrackNumberF7ForFilter((KDBizPromptBox)this.getMainBizOrgF7(), (KDBizPromptBox)this.prmtTrackNumFrom);
        UIHelper.registerTrackNumberF7ForFilter((KDBizPromptBox)this.getMainBizOrgF7(), (KDBizPromptBox)this.prmtTrackNumTo);
        elements.add((FilterElement)new RangeFilterElement("trackNumber.number", (Component)this.prmtTrackNumFrom, (Component)this.prmtTrackNumTo));
        RangeFilterElement dateElements = new RangeFilterElement("bizDate", (Component)this.bizDateFrom, (Component)this.bizDateTo);
        dateElements.addVerifyItem(new VerifyItem(VerifyType.LESS_EQUAL_TYPE, SCMClientUtils.getResource((String)"CompareDate")));
        elements.add((FilterElement)dateElements);
        ColConnFilterElement mainOrgElement = new ColConnFilterElement("requestOrgUnit.id", (Component)this.bizPromptReqOrgUnit);
        mainOrgElement.addVerifyItem(new VerifyItem(VerifyType.REQUIRED_TYPE, InvClientUtils.getAddResource("RequestOrgNotNull")));
        elements.add((FilterElement)mainOrgElement);
        elements.add((FilterElement)new SingleFilterElement("baseStatus", (Component)this.comboxBillStatus, (Object)BillBaseStatusEnum.NULL));
        elements.add((FilterElement)new SingleFilterElement("requestPerson.number", (Component)this.BizPromptRequestPerson, null));
        this.getFilterManager().setElement((FilterElement)elements);
        this.getFilterManager().setMainOrgElement((FilterElement)mainOrgElement, "requestOrgUnit.id");
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Admin;
    }

    private void setF7Filter() throws Exception {
        this.bizPromptReqOrgUnit.setEnabledMultiSelection(true);
        HashMap<String, Boolean> ctx = new HashMap<String, Boolean>();
        ctx.put("IS_SINGLE_SELECT", false);
        PersonPromptBox box = new PersonPromptBox((IUIObject)this, ctx);
        box.setEnabledMultiSelection(true);
        box.showAllAdmin();
        this.BizPromptRequestPerson.setSelector((KDPromptSelector)box);
        this.BizPromptRequestPerson.setEnabledMultiSelection(true);
        this.f7Manager.registerBizMaterialF7(this.bizPromptMaterialNumFrom, null, null, null, OrgType.Company, false, false);
        this.f7Manager.registerBizMaterialF7(this.bizPromptMaterialNumTo, null, null, null, OrgType.Company, false, false);
        this.setBizTypeF7Filter(this.bizPromptBizTypeFrom);
        this.setBizTypeF7Filter(this.bizPromptBizTypeTo);
        this.setRequestOrgFilter();
        this.setNeedMainOrgF7s(new KDBizPromptBox[]{this.bizPromptMaterialNumFrom, this.bizPromptMaterialNumTo});
        this.setBillNumberF7s(new KDBizPromptBox[]{this.prmtNumberFrom, this.prmtNumberTo});
        this.f7Manager.registerContextChangeF7(this.prmtNumberFrom, this.getPropertyOfMainBizOrg());
        this.f7Manager.registerContextChangeF7(this.prmtNumberTo, this.getPropertyOfMainBizOrg());
        this.setShowAllSealOrg(new KDBizPromptBox[]{this.bizPromptReqOrgUnit}, new OrgType[]{OrgType.Admin});
    }

    public EntityViewInfo getAdminOrgFilter() {
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(SCMClientUtils.getF7FilterInfoByAuthorizeStorageOrg((String)"requestOrgUnit.id"));
        return viewInfo;
    }

    private void setBizTypeF7Filter(KDBizPromptBox kDBizPromptBox) {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("billType.id", (Object)"XlazxwEREADgAAAEwKgSxUY+1VI=", CompareType.EQUALS));
        viewInfo.setFilter(filterInfo);
        kDBizPromptBox.setEntityViewInfo(viewInfo);
    }

    private void setRequestOrgFilter() {
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.setF7Filter();
        this.setDefaultValue();
        if (this.getMainBizOrgF7().getText() != null) {
            this.mainOrgChanged();
        }
    }

    protected void setDefaultValue() {
        SCMQueryFormat.formatStartTime((KDDatePicker)this.bizDateFrom);
        SCMQueryFormat.formatEndTime((KDDatePicker)this.bizDateTo);
        SCMQueryFormat.formatBillStatus((ISCMBillStatusControl)this, (KDComboBox)this.comboxBillStatus);
        this.setDefaultReqOrg();
    }

    private void setDefaultReqOrg() {
    }

    public Object[] getUnVisibleBillStatus() {
        return new Object[]{BillBaseStatusEnum.RELEASED, BillBaseStatusEnum.BLOCKED};
    }

    public Object[] getAdditiveBillStatus() {
        return null;
    }

    public KDBizPromptBox getMainBizOrgF7() {
        return this.bizPromptReqOrgUnit;
    }

    protected String getViewPermission() {
        return "materialRequest_view";
    }

    protected String getPropertyOfMainBizOrg() {
        return "requestOrgUnit.id";
    }

    public void afterMainOrgChanged(String ids) {
        if (this.bizPromptReqOrgUnit.getValue() != null) {
            if (this.bizPromptReqOrgUnit.getValue() instanceof AdminOrgUnitInfo) {
                AdminOrgUnitInfo adminOrgUnit = (AdminOrgUnitInfo)this.bizPromptReqOrgUnit.getValue();
                this.cou = InvClientUtils.getCompanyInfo(adminOrgUnit);
                this.couColl = null;
            } else if (this.bizPromptReqOrgUnit.getValue() instanceof Object[]) {
                Object[] adminOrgs = (Object[])this.bizPromptReqOrgUnit.getValue();
                this.couColl = InvClientUtils.getCompanyInfos(adminOrgs);
            } else {
                this.cou = InvClientUtils.getCompanyInfo(((DataBaseInfo)this.bizPromptReqOrgUnit.getValue()).getId().toString());
                this.couColl = null;
            }
            if (this.couColl != null) {
                this.setOrgsFilterForMaterial(this.bizPromptMaterialNumFrom, this.couColl, this.couColl.toArray());
                this.setOrgsFilterForMaterial(this.bizPromptMaterialNumTo, this.couColl, this.couColl.toArray());
                this.f7Manager.changeF7Context(this.bizPromptMaterialNumFrom);
                this.f7Manager.changeF7Context(this.bizPromptMaterialNumTo);
                this.setOutStorageBoxByCompanys(this.bizPromptOutStorage, this.couColl);
                this.setOutStorageBoxByCompanys(this.bizPromptOutStorageTo, this.couColl);
            } else {
                this.setDefaultOrgsFilterForMaterial(this.bizPromptMaterialNumFrom, SysContext.getSysContext().getCurrentFIUnit());
                this.setDefaultOrgsFilterForMaterial(this.bizPromptMaterialNumTo, SysContext.getSysContext().getCurrentFIUnit());
                this.f7Manager.changeF7Context(this.bizPromptMaterialNumFrom);
                this.f7Manager.changeF7Context(this.bizPromptMaterialNumTo);
                this.setOutStorageBox(this.bizPromptOutStorage, this.cou);
                this.setOutStorageBox(this.bizPromptOutStorageTo, this.cou);
            }
        } else {
            this.setDefaultOrgsFilterForMaterial(this.bizPromptMaterialNumFrom, SysContext.getSysContext().getCurrentFIUnit());
            this.setDefaultOrgsFilterForMaterial(this.bizPromptMaterialNumTo, SysContext.getSysContext().getCurrentFIUnit());
            this.f7Manager.changeF7Context(this.bizPromptMaterialNumFrom);
            this.f7Manager.changeF7Context(this.bizPromptMaterialNumTo);
            this.setOutStorageBox(this.bizPromptOutStorage, null);
            this.setOutStorageBox(this.bizPromptOutStorageTo, null);
        }
    }

    private void setOutStorageBox(KDBizPromptBox bizAdminOrgBox, CompanyOrgUnitInfo company) {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        if (company != null && company.getId() != null) {
            OrgUnitCollection storageColl = InvClientUtils.getStorageUnitInfo(company);
            OrgUnitInfo orgUnitInfo = null;
            if (storageColl != null && storageColl.size() > 0) {
                HashSet<String> storageSet = new HashSet<String>();
                int size = storageColl.size();
                for (int i = 0; i < size; ++i) {
                    orgUnitInfo = storageColl.get(i);
                    storageSet.add(orgUnitInfo.getId().toString());
                }
                filterInfo.getFilterItems().add(new FilterItemInfo("id", storageSet, CompareType.INCLUDE));
            }
        }
        filterInfo.getFilterItems().add(new FilterItemInfo("isBizUnit", (Object)new Integer("1"), CompareType.EQUALS));
        viewInfo.setFilter(filterInfo);
        bizAdminOrgBox.setEntityViewInfo(viewInfo);
    }

    private void setOutStorageBoxByCompanys(KDBizPromptBox bizAdminOrgBox, OrgUnitCollection companys) {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        CompanyOrgUnitInfo company = null;
        HashSet<String> storageSet = new HashSet<String>();
        if (companys != null && companys.size() > 0) {
            int size = companys.size();
            for (int index = 0; index < size; ++index) {
                company = (CompanyOrgUnitInfo)companys.get(index);
                if (company == null || company.getId() == null) continue;
                OrgUnitCollection storageColl = InvClientUtils.getStorageUnitInfo(company);
                OrgUnitInfo orgUnitInfo = null;
                if (storageColl == null || storageColl.size() <= 0) continue;
                int storageSize = storageColl.size();
                for (int i = 0; i < storageSize; ++i) {
                    orgUnitInfo = storageColl.get(i);
                    storageSet.add(orgUnitInfo.getId().toString());
                }
            }
            filterInfo.getFilterItems().add(new FilterItemInfo("id", storageSet, CompareType.INCLUDE));
        }
        filterInfo.getFilterItems().add(new FilterItemInfo("isBizUnit", (Object)new Integer("1"), CompareType.EQUALS));
        viewInfo.setFilter(filterInfo);
        bizAdminOrgBox.setEntityViewInfo(viewInfo);
    }

    private void setOrgsFilterForMaterial(KDBizPromptBox bizAdminOrgBox, OrgUnitCollection coll, Object[] selectColl) {
        String ids = null;
        Object[] objects = selectColl;
        if (objects == null) {
            return;
        }
        if (objects.length > 0) {
            OrgUnitInfo[] unitInfos = new OrgUnitInfo[objects.length];
            for (int i = 0; i < objects.length; ++i) {
                unitInfos[i] = (OrgUnitInfo)objects[i];
            }
            ids = SCMGroupClientUtils.getKeyIdList((ObjectBaseInfo[])unitInfos, (String)",");
        }
        if (ids == null) {
            return;
        }
        this.f7Manager.changeF7Context(ids, coll);
    }

    private void setDefaultOrgsFilterForMaterial(KDBizPromptBox bizAdminOrgBoxm, CompanyOrgUnitInfo company) {
        Object[] object = new Object[]{company};
        OrgUnitCollection orgColl = new OrgUnitCollection();
        orgColl.add((OrgUnitInfo)company);
        this.setOrgsFilterForMaterial(bizAdminOrgBoxm, orgColl, object);
    }

    public void clear() {
        super.clear();
        this.bizPromptReqOrgUnit.setValue((Object)this.getDefaultMainBizOrg());
    }

    protected boolean isNeedAddVirtual() {
        return true;
    }
}

