/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.client;

import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.scm.im.inv.client.AbstractMaterialSNInventoryConditionUI;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import org.apache.log4j.Logger;

public class MaterialSNInventoryConditionUI
extends AbstractMaterialSNInventoryConditionUI {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = CoreUIObject.getLogger(MaterialSNInventoryConditionUI.class);
    private static final String resClassName = "com.kingdee.eas.scm.im.inv.MaterialSNResource";

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    public void loadFields() {
        super.loadFields();
        this.kDDatePicker_billBizDateFrom.setValue(null);
        this.kDDatePicker_billBizDateTo.setValue(null);
        if (this.ckBxOnlyShowSN.isSelected()) {
            this.kDDatePicker_billBizDateFrom.setEnabled(false);
            this.kDDatePicker_billBizDateTo.setEnabled(false);
        }
        try {
            this.addF7Listener();
            this.setMaterialSNF7();
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
            super.handUIException((Throwable)e);
        }
    }

    protected void addF7Listener() {
        this.kDBizPromptBox_material.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                try {
                    MaterialSNInventoryConditionUI.this.material_dataChanged(e);
                }
                catch (Exception e1) {
                    MaterialSNInventoryConditionUI.this.handUIException(e1);
                }
            }
        });
        this.ckBxOnlyShowSN.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                try {
                    MaterialSNInventoryConditionUI.this.ckBxOnlyShowSN_itemStateChanged(e);
                }
                catch (Exception exc) {
                    MaterialSNInventoryConditionUI.this.handUIException(exc);
                }
            }
        });
    }

    protected void material_dataChanged(DataChangeEvent e) throws Exception {
        this.kDBizPromptBox_snFrom.setValue(null);
        this.kDBizPromptBox_snTo.setValue(null);
        this.setMaterialSNF7();
    }

    protected void ckBxOnlyShowSN_itemStateChanged(ItemEvent e) throws Exception {
        boolean isSelected = this.ckBxOnlyShowSN.isSelected();
        this.kDDatePicker_billBizDateFrom.setValue(null);
        this.kDDatePicker_billBizDateTo.setValue(null);
        if (isSelected) {
            this.kDDatePicker_billBizDateFrom.setEnabled(false);
            this.kDDatePicker_billBizDateTo.setEnabled(false);
        } else {
            this.kDDatePicker_billBizDateFrom.setEnabled(true);
            this.kDDatePicker_billBizDateTo.setEnabled(true);
        }
    }

    private void setMaterialSNF7() throws Exception {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("seqUnit.id", null, CompareType.ISNOT);
        filter.getFilterItems().add(filterItem);
        view.setFilter(filter);
        this.kDBizPromptBox_material.setEntityViewInfo(view);
        Object materialObj = this.kDBizPromptBox_material.getValue();
        if (materialObj != null) {
            MaterialInfo material = (MaterialInfo)materialObj;
            EntityViewInfo viewInfo = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            FilterItemInfo snFilter = new FilterItemInfo("material.id", (Object)material.getId().toString(), CompareType.EQUALS);
            filterInfo.getFilterItems().add(snFilter);
            viewInfo.setFilter(filterInfo);
            this.kDBizPromptBox_snFrom.setEntityViewInfo(viewInfo);
            this.kDBizPromptBox_snTo.setEntityViewInfo(viewInfo);
        } else {
            this.kDBizPromptBox_snFrom.setEntityViewInfo(null);
            this.kDBizPromptBox_snTo.setEntityViewInfo(null);
        }
    }

    public void onInit(RptParams initParams) throws Exception {
    }

    public RptParams getCustomCondition() {
        RptParams params = new RptParams();
        params.setObject("material", this.kDBizPromptBox_material.getValue());
        params.setObject("dateFrom", this.kDDatePicker_billBizDateFrom.getValue());
        params.setObject("dateTo", this.kDDatePicker_billBizDateTo.getValue());
        params.setObject("snFrom", this.kDBizPromptBox_snFrom.getValue());
        params.setObject("snTo", this.kDBizPromptBox_snTo.getValue());
        params.setBoolean("ckBxOnlyShowSN", this.ckBxOnlyShowSN.isSelected());
        params.setObject("snStatus", this.kDComboBox_snStatus.getSelectedItem());
        return params;
    }

    public void setCustomCondition(RptParams params) {
        this.kDDatePicker_billBizDateFrom.setValue(params.getObject("dateFrom"));
        this.kDDatePicker_billBizDateTo.setValue(params.getObject("dateTo"));
        this.kDBizPromptBox_material.setValue(params.getObject("material"));
        this.kDBizPromptBox_snFrom.setValue(params.getObject("snFrom"));
        this.kDBizPromptBox_snTo.setValue(params.getObject("snTo"));
        this.ckBxOnlyShowSN.setSelected(params.getBoolean("ckBxOnlyShowSN"));
        this.kDComboBox_snStatus.setSelectedItem(params.getObject("snStatus"));
    }

    public boolean verify() {
        if (this.kDBizPromptBox_material.getValue() == null && (this.kDBizPromptBox_snFrom.getValue() == null || this.kDBizPromptBox_snTo.getValue() == null)) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resClassName, (String)"MATERIALSN_NOTNULL"));
            return false;
        }
        return true;
    }

    public void clear() {
        super.clear();
        this.kDBizPromptBox_material.setValue(null);
        this.kDBizPromptBox_snFrom.setValue(null);
        this.kDBizPromptBox_snTo.setValue(null);
        this.kDDatePicker_billBizDateFrom.setValue(null);
        this.kDDatePicker_billBizDateTo.setValue(null);
        this.ckBxOnlyShowSN.setSelected(true);
        this.kDDatePicker_billBizDateFrom.setEnabled(false);
        this.kDDatePicker_billBizDateTo.setEnabled(false);
        this.kDComboBox_snStatus.setSelectedIndex(0);
    }
}

