/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.StorageOrgUnitCollection;
import com.kingdee.eas.basedata.org.StorageOrgUnitFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.common.util.F7ContextManager;
import com.kingdee.eas.scm.im.inv.MaterialSNInventoryCollection;
import com.kingdee.eas.scm.im.inv.MaterialSNInventoryFactory;
import com.kingdee.eas.scm.im.inv.MaterialSNInventoryInfo;
import com.kingdee.eas.scm.im.inv.SerialNumberStatusEnum;
import com.kingdee.eas.scm.im.inv.client.AbstractMaterialSNInventoryFilterUI;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.util.HashSet;
import org.apache.log4j.Logger;

public class MaterialSNInventoryFilterUI
extends AbstractMaterialSNInventoryFilterUI {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = CoreUIObject.getLogger(MaterialSNInventoryFilterUI.class);
    private static final String resClassName = "com.kingdee.eas.scm.im.inv.MaterialSNResource";

    public void onLoad() throws Exception {
        super.onLoad();
        try {
            this.addF7Listener();
            this.setMaterialSNF7();
            this.setInventoryF7();
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
            super.handUIException((Throwable)e);
        }
    }

    private void setInventoryF7() {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        FilterItemInfo bizUnitfilterItem = new FilterItemInfo("isBizUnit", (Object)1, CompareType.EQUALS);
        FilterItemInfo sealUpfilterItem = new FilterItemInfo("isSealUp", (Object)0, CompareType.EQUALS);
        filter.getFilterItems().add(bizUnitfilterItem);
        filter.getFilterItems().add(sealUpfilterItem);
        view.setFilter(filter);
        this.kDBizPromptBox_Inventory.setEntityViewInfo(view);
    }

    protected void addF7Listener() {
        this.kDBizPromptBox_material.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                try {
                    MaterialSNInventoryFilterUI.this.material_dataChanged(e);
                }
                catch (Exception e1) {
                    MaterialSNInventoryFilterUI.this.handUIException(e1);
                }
            }
        });
    }

    protected void material_dataChanged(DataChangeEvent e) throws Exception {
        this.kDBizPromptBox_snFrom.setValue(null);
        this.kDBizPromptBox_snTo.setValue(null);
        this.setMaterialSNF7();
    }

    private void setMaterialSNF7() throws Exception {
        F7ContextManager f7Manager = new F7ContextManager((Component)((Object)this), OrgType.Storage, 1);
        f7Manager.registerBizMaterialF7(this.kDBizPromptBox_material, null, null, null, false);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("seqUnit.id", null, CompareType.ISNOT);
        filter.getFilterItems().add(filterItem);
        view.setFilter(filter);
        this.kDBizPromptBox_material.setEntityViewInfo(view);
        Object materialObj = this.kDBizPromptBox_material.getValue();
        if (materialObj != null) {
            MaterialInfo material = (MaterialInfo)materialObj;
            EntityViewInfo viewInfo = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            FilterItemInfo snFilter = new FilterItemInfo("material.id", (Object)material.getId().toString(), CompareType.EQUALS);
            filterInfo.getFilterItems().add(snFilter);
            viewInfo.setFilter(filterInfo);
            this.kDBizPromptBox_snFrom.setEntityViewInfo(viewInfo);
            this.kDBizPromptBox_snTo.setEntityViewInfo(viewInfo);
        } else {
            this.kDBizPromptBox_snFrom.setEntityViewInfo(null);
            this.kDBizPromptBox_snTo.setEntityViewInfo(null);
        }
    }

    public FilterInfo getFilterInfo() {
        SerialNumberStatusEnum snStatus;
        Object snToObj;
        Object snFromObj;
        Object materialObj;
        this.filterInfo = new FilterInfo();
        Object[] orgUnit = (Object[])this.kDBizPromptBox_Inventory.getValue();
        StorageOrgUnitInfo info = null;
        HashSet<String> setIds = new HashSet<String>();
        if (orgUnit != null && orgUnit.length > 0) {
            for (int i = 0; i < orgUnit.length; ++i) {
                info = (StorageOrgUnitInfo)orgUnit[i];
                setIds.add(info.getId().toString());
            }
        }
        if ((materialObj = this.kDBizPromptBox_material.getValue()) != null) {
            MaterialInfo material = (MaterialInfo)materialObj;
            FilterItemInfo materialFilter = new FilterItemInfo("material.id", (Object)material.getId().toString(), CompareType.EQUALS);
            this.filterInfo.getFilterItems().add(materialFilter);
        }
        if (setIds.size() > 0) {
            FilterItemInfo materialFilter = new FilterItemInfo("storageOrgUnit.id", setIds, CompareType.INCLUDE);
            this.filterInfo.getFilterItems().add(materialFilter);
        }
        if ((snFromObj = this.kDBizPromptBox_snFrom.getValue()) != null) {
            MaterialSNInventoryInfo snFrom = (MaterialSNInventoryInfo)snFromObj;
            FilterItemInfo snFromFilter = new FilterItemInfo("serialNumber", (Object)snFrom.getSerialNumber(), CompareType.GREATER_EQUALS);
            this.filterInfo.getFilterItems().add(snFromFilter);
        }
        if ((snToObj = this.kDBizPromptBox_snTo.getValue()) != null) {
            MaterialSNInventoryInfo snTo = (MaterialSNInventoryInfo)snToObj;
            FilterItemInfo snToFilter = new FilterItemInfo("serialNumber", (Object)snTo.getSerialNumber(), CompareType.LESS_EQUALS);
            this.filterInfo.getFilterItems().add(snToFilter);
        }
        if ((snStatus = (SerialNumberStatusEnum)((Object)this.kDComboBox_snStatus.getSelectedItem())).getValue() != -1) {
            FilterItemInfo snStatusFilter = new FilterItemInfo("snStatus", (Object)snStatus.getValue(), CompareType.EQUALS);
            this.filterInfo.getFilterItems().add(snStatusFilter);
        }
        return this.filterInfo;
    }

    public boolean verify() {
        if (this.kDBizPromptBox_material.getValue() == null && (this.kDBizPromptBox_snFrom.getValue() == null || this.kDBizPromptBox_snTo.getValue() == null)) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resClassName, (String)"MATERIALSN_NOTNULL"));
            return false;
        }
        return true;
    }

    public void loadData(EntityViewInfo viewInfo) {
        try {
            this.clear();
            FilterItemCollection currentFilterItemCollection = viewInfo.getFilter().getFilterItems();
            for (int i = 0; i < currentFilterItemCollection.size(); ++i) {
                FilterItemInfo filterItem;
                String propName = currentFilterItemCollection.get(i).getPropertyName();
                Object compVal = currentFilterItemCollection.get(i).getCompareValue();
                CompareType comp = currentFilterItemCollection.get(i).getCompareType();
                if (compVal == null) continue;
                if ("storageOrgUnit.id".equals(propName)) {
                    EntityViewInfo storageViewInfo = new EntityViewInfo();
                    FilterInfo filterInfo = new FilterInfo();
                    filterItem = new FilterItemInfo("id", compVal, CompareType.INCLUDE);
                    filterInfo.getFilterItems().add(filterItem);
                    storageViewInfo.setFilter(filterInfo);
                    StorageOrgUnitCollection coll = StorageOrgUnitFactory.getRemoteInstance().getStorageOrgUnitCollection(storageViewInfo);
                    Object[] object = coll.toArray();
                    this.kDBizPromptBox_Inventory.setValue((Object)object);
                }
                if ("material.id".equalsIgnoreCase(propName)) {
                    String materialID = compVal.toString();
                    MaterialInfo material = MaterialFactory.getRemoteInstance().getMaterialInfo((IObjectPK)new ObjectUuidPK(materialID));
                    this.kDBizPromptBox_material.setValue((Object)material);
                }
                if ("serialNumber".equalsIgnoreCase(propName)) {
                    EntityViewInfo snViewInfo = new EntityViewInfo();
                    FilterInfo snFilterInfo = new FilterInfo();
                    filterItem = new FilterItemInfo("serialNumber", compVal, CompareType.EQUALS);
                    snFilterInfo.getFilterItems().add(filterItem);
                    snViewInfo.setFilter(snFilterInfo);
                    MaterialSNInventoryCollection collection = MaterialSNInventoryFactory.getRemoteInstance().getMaterialSNInventoryCollection(snViewInfo);
                    MaterialSNInventoryInfo matSN = null;
                    if (collection != null && collection.size() > 0) {
                        matSN = collection.get(0);
                    }
                    if (comp == CompareType.GREATER_EQUALS) {
                        this.kDBizPromptBox_snFrom.setValue((Object)matSN);
                    } else {
                        this.kDBizPromptBox_snTo.setValue((Object)matSN);
                    }
                }
                if (!"snStatus".equalsIgnoreCase(propName)) continue;
                int snStatus = Integer.parseInt(compVal.toString());
                this.kDComboBox_snStatus.setSelectedItem((Object)SerialNumberStatusEnum.getEnum(snStatus));
            }
        }
        catch (EASBizException e) {
            this.handUIException(e);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
    }

    public void clear() {
        super.clear();
        this.kDBizPromptBox_material.setValue(null);
        this.kDBizPromptBox_Inventory.setValue(null);
        this.kDBizPromptBox_snFrom.setValue(null);
        this.kDBizPromptBox_snTo.setValue(null);
        this.kDComboBox_snStatus.setSelectedIndex(0);
    }
}

