/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTColumn;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ObjectMultiPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.CustomerQueryPanel;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.client.RealModeIDList;
import com.kingdee.eas.framework.config.IObjectMultiPKBuilder;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.im.inv.MaterialSNInventoryFactory;
import com.kingdee.eas.scm.im.inv.SerialNumberStatusEnum;
import com.kingdee.eas.scm.im.inv.client.AbstractMaterialSNInventoryListUI;
import com.kingdee.eas.scm.im.inv.client.MaterialSNInventoryFilterUI;
import com.kingdee.eas.scm.im.inv.client.MultiTablePreferencesHelper;
import com.kingdee.eas.scm.im.inv.client.ViewBillUIHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class MaterialSNInventoryListUI
extends AbstractMaterialSNInventoryListUI {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = CoreUIObject.getLogger(MaterialSNInventoryListUI.class);
    private static final String resClassName = "com.kingdee.eas.scm.im.inv.MaterialSNResource";
    private CommonQueryDialog queryDialog = null;
    protected MaterialSNInventoryFilterUI userPanel = null;

    public MaterialSNInventoryListUI() throws Exception {
        this.tblMain.checkParsed();
        this.downTable.checkParsed();
        this.tblMain.setEditable(false);
        this.downTable.setEditable(false);
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.btnRemove.setVisible(false);
        this.btnAttachment.setVisible(false);
        this.btnAuditResult.setVisible(false);
        this.menuItemAddNew.setVisible(false);
        this.MenuItemAttachment.setVisible(false);
        this.menuItemEdit.setVisible(false);
        this.menuItemCreateTo.setVisible(false);
        this.menuItemCopyTo.setVisible(false);
        this.menuItemView.setVisible(false);
        this.menuItemLocate.setVisible(false);
        this.menuItemTraceUp.setVisible(false);
        this.menuItemTraceDown.setVisible(false);
        this.menuWorkFlow.setVisible(false);
        this.menuItemImportData.setVisible(false);
        this.btnViewUI.setIcon(EASResource.getIcon((String)"imgTbtn_bill"));
        this.tblMain.setColumnMoveable(true);
        this.downTable.setColumnMoveable(true);
    }

    protected void tblMain_tableSelectChanged(KDTSelectEvent e) throws Exception {
        try {
            int rowIndex;
            IRow currow;
            KDTSelectBlock selectBlock = this.tblMain.getSelectManager().get(0);
            if (selectBlock != null && (currow = this.tblMain.getRow(rowIndex = selectBlock.getTop())) != null) {
                String materialID = currow.getCell("material.id").getValue().toString();
                String serialNumber = currow.getCell("serialNumber").getValue().toString();
                EntityViewInfo viewInfo = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("material.id", (Object)materialID));
                filter.getFilterItems().add(new FilterItemInfo("entry.serialNumber", (Object)serialNumber));
                viewInfo.setFilter(filter);
                MetaDataPK queryPK = MetaDataPK.create((String)"com.kingdee.eas.scm.im.inv.MaterialSerialNumberQuery");
                IQueryExecutor exec = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)queryPK);
                exec.setObjectView(viewInfo);
                IRowSet rowSet = exec.executeQuery();
                this.insertRows(this.downTable, rowSet, 0, rowSet.size());
            }
        }
        catch (BOSException e1) {
            logger.error((Object)e1.getMessage());
            this.handUIException(e1);
        }
    }

    private void insertRows(KDTable table, IRowSet rs, int begin, int length) throws SQLException {
        table.repaint();
        table.removeRows();
        IRow row = null;
        String key = null;
        List columnList = table.getColumns().getColumns();
        while (rs.next()) {
            row = table.addRow(begin++);
            for (int i = 0; i < columnList.size(); ++i) {
                String statusValue;
                int status;
                KDTColumn column = (KDTColumn)columnList.get(i);
                key = column.getKey();
                if (row.getCell(key) == null) continue;
                if ("billBaseStatus".equals(key)) {
                    status = rs.getInt("billBaseStatus");
                    if (status == 0) {
                        row.getCell(key).setValue(null);
                        continue;
                    }
                    statusValue = BillBaseStatusEnum.getEnum((int)status).getAlias();
                    row.getCell(key).setValue((Object)statusValue);
                    continue;
                }
                if ("snStatus".equals(key)) {
                    status = rs.getInt("snStatus");
                    statusValue = SerialNumberStatusEnum.getEnum(status).getAlias();
                    row.getCell(key).setValue((Object)statusValue);
                    continue;
                }
                row.getCell(key).setValue(rs.getObject(key));
            }
        }
    }

    @Override
    public void actionViewUI_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected(this.downTable);
        ViewBillUIHelper viewUIHelper = new ViewBillUIHelper(this.downTable, "billID", "billType.id");
        if (!viewUIHelper.checkObjectExists()) {
            return;
        }
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ID", (Object)viewUIHelper.getSelectedKeyValue());
        RealModeIDList idList = new RealModeIDList();
        idList.add(viewUIHelper.getSelectedKeyValue());
        uiContext.put((Object)"IDList", (Object)idList);
        IUIWindow uiWindow = null;
        uiWindow = SwingUtilities.getWindowAncestor((Component)((Object)this)) != null && SwingUtilities.getWindowAncestor((Component)((Object)this)) instanceof JDialog ? UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(viewUIHelper.getEditUIName(), (Map)uiContext, null, OprtState.VIEW) : UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(viewUIHelper.getEditUIName(), (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
    }

    private void checkSelected(KDTable table) {
        if (table.getRowCount() == 0 || table.getSelectManager().size() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resClassName, (String)"Msg_MustSelected"));
            SysUtil.abort();
        }
    }

    protected ICoreBase getBizInterface() throws Exception {
        return MaterialSNInventoryFactory.getRemoteInstance();
    }

    protected void initHelper() {
        if (this.tHelper != null) {
            return;
        }
        this.tHelperPrint = this.tHelper = new MultiTablePreferencesHelper((CoreUI)this, new IObjectMultiPKBuilder(){

            public IObjectPK buildPK() {
                String uiClassName = MaterialSNInventoryListUI.this.getMetaDataPK().getFullName();
                Object schemaKey = MaterialSNInventoryListUI.this.getTablePreferenceSchemaKey();
                if (schemaKey != null) {
                    uiClassName = uiClassName + schemaKey;
                }
                ObjectMultiPK pk = new ObjectMultiPK();
                pk.setKeyValue("user", (Object)SysContext.getSysContext().getCurrentUserInfo().getId());
                pk.setKeyValue("uiClassName", (Object)uiClassName);
                return pk;
            }
        });
    }

    protected CommonQueryDialog initCommonQueryDialog() {
        if (this.queryDialog != null) {
            return this.queryDialog;
        }
        this.queryDialog = super.initCommonQueryDialog();
        try {
            this.queryDialog.addUserPanel((KDPanel)this.getUserPanel());
            this.queryDialog.setUiObject(null);
            this.queryDialog.setHeight(200);
            this.queryDialog.setWidth(450);
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        return this.queryDialog;
    }

    protected CustomerQueryPanel getUserPanel() throws Exception {
        if (this.userPanel == null) {
            this.userPanel = new MaterialSNInventoryFilterUI();
        }
        return this.userPanel;
    }

    protected boolean isIgnoreCUFilter() {
        return true;
    }

    protected boolean initDefaultFilter() {
        return true;
    }

    protected boolean innerCheckPartSum() {
        return false;
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
    }
}

