/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.common.GlobalLocator;
import com.kingdee.bos.ctrl.kdf.headfootdesigner.HeadFootModel;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.master.material.MaterialCollection;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.client.RealModeIDList;
import com.kingdee.eas.framework.config.ITablePreferenceHelper;
import com.kingdee.eas.framework.report.ICommRptBase;
import com.kingdee.eas.framework.report.IVirtualRptBaseFacade;
import com.kingdee.eas.framework.report.client.CommRptBaseConditionUI;
import com.kingdee.eas.framework.report.util.KDTableUtil;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.framework.report.util.RptTableHeader;
import com.kingdee.eas.scm.cal.CostAdjustBillFactory;
import com.kingdee.eas.scm.cal.client.CostAdjustBillEditUI;
import com.kingdee.eas.scm.im.inv.InvStateAdjustBillFactory;
import com.kingdee.eas.scm.im.inv.InventoryInitBillFactory;
import com.kingdee.eas.scm.im.inv.ManufactureRecBillFactory;
import com.kingdee.eas.scm.im.inv.MaterialReqBillFactory;
import com.kingdee.eas.scm.im.inv.MaterialRequestBillFactory;
import com.kingdee.eas.scm.im.inv.MaterialSNInventoryCollection;
import com.kingdee.eas.scm.im.inv.MaterialSNInventoryFacadeFactory;
import com.kingdee.eas.scm.im.inv.MaterialSNInventoryFactory;
import com.kingdee.eas.scm.im.inv.MaterialSNInventoryInfo;
import com.kingdee.eas.scm.im.inv.MoveInWarehsBillFactory;
import com.kingdee.eas.scm.im.inv.MoveIssueBillFactory;
import com.kingdee.eas.scm.im.inv.MoveLocationBillFactory;
import com.kingdee.eas.scm.im.inv.OtherInWarehsBillFactory;
import com.kingdee.eas.scm.im.inv.OtherIssueBillFactory;
import com.kingdee.eas.scm.im.inv.PurInWarehsBillFactory;
import com.kingdee.eas.scm.im.inv.PurReceivalBillFactory;
import com.kingdee.eas.scm.im.inv.SaleIssueBillFactory;
import com.kingdee.eas.scm.im.inv.SerialNumberException;
import com.kingdee.eas.scm.im.inv.SerialNumberStatusEnum;
import com.kingdee.eas.scm.im.inv.client.AbstractMaterialSNInventoryReportUI;
import com.kingdee.eas.scm.im.inv.client.FileImportUI;
import com.kingdee.eas.scm.im.inv.client.InvStateAdjustBillEditUI;
import com.kingdee.eas.scm.im.inv.client.InventoryInitBillEditUI;
import com.kingdee.eas.scm.im.inv.client.ManufactureRecBillEditUI;
import com.kingdee.eas.scm.im.inv.client.MaterialReqBillEditUI;
import com.kingdee.eas.scm.im.inv.client.MaterialRequestBillEditUI;
import com.kingdee.eas.scm.im.inv.client.MaterialSNInventoryConditionUI;
import com.kingdee.eas.scm.im.inv.client.MoveInWarehsBillEditUI;
import com.kingdee.eas.scm.im.inv.client.MoveIssueBillEditUI;
import com.kingdee.eas.scm.im.inv.client.MoveLocationBillEditUI;
import com.kingdee.eas.scm.im.inv.client.OtherInWarehsBillEditUI;
import com.kingdee.eas.scm.im.inv.client.OtherIssueBillEditUI;
import com.kingdee.eas.scm.im.inv.client.PurInWarehsBillEditUI;
import com.kingdee.eas.scm.im.inv.client.PurReceivalBillEditUI;
import com.kingdee.eas.scm.im.inv.client.SaleIssueBillEditUI;
import com.kingdee.eas.scm.util.SCMRptUtil;
import com.kingdee.eas.scm.util.string.StringUtil;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFDataFormat;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.HorizontalAlignment;

public class MaterialSNInventoryReportUI
extends AbstractMaterialSNInventoryReportUI {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = CoreUIObject.getLogger(MaterialSNInventoryReportUI.class);
    private static final String SN_RESOURCE = "com.kingdee.eas.scm.im.inv.SerialNumberResource";
    private boolean firstLoadData = true;
    private IUIWindow snImportWindow = null;
    private HashMap<String, Object> materialCacheMap = new HashMap();

    public MaterialSNInventoryReportUI() throws Exception {
        this.kDTable.checkParsed();
        this.kDTable.setEditable(false);
        this.kDTable.getDataRequestManager().addDataRequestListener((KDTDataRequestListener)this);
        this.kDTable.getDataRequestManager().setDataRequestMode(1);
        this.kDTable.getDataRequestManager().setPageRowCount(1000);
        this.kDTable.getSelectManager().setSelectMode(10);
        this.btnViewUI.setIcon(EASResource.getIcon((String)"imgTbtn_bill"));
        this.btnSNImport.setIcon(EASResource.getIcon((String)"imgTbtn_input"));
        this.menuSNImport.setIcon(EASResource.getIcon((String)"imgTbtn_input"));
        this.btnSNImport.setEnabled(true);
        this.menuSNImport.setEnabled(true);
        this.enableExportExcel(this.kDTable);
        this.btnDelete.setIcon(EASResource.getIcon((String)"imgTbtn_delete"));
        this.btnDelete.setEnabled(true);
        this.getTable().getDataRequestManager().setExportMemoryCallback(true);
    }

    public void onLoad() throws Exception {
        if (this.getUIContext().get("notShowDialog") != null && Boolean.valueOf(this.getUIContext().get("notShowDialog").toString()).booleanValue()) {
            this.setShowDialogOnLoad(false);
        }
        super.onLoad();
    }

    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        this.firstLoadData = true;
        this.insertRowCount = 0;
        super.actionRefresh_actionPerformed(e);
    }

    public void actionQuery4Inventory(String inventoryID) throws Exception {
        this.toolBar.setVisible(false);
        this.params.setString("inventoryID", inventoryID);
        this.params.setBoolean("ckBxOnlyShowSN", true);
        this.firstLoadData = true;
        this.insertRowCount = 0;
        this.query();
    }

    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        this.firstLoadData = true;
        this.insertRowCount = 0;
        super.actionQuery_actionPerformed(e);
    }

    protected ICommRptBase getRemoteInstance() throws BOSException {
        return MaterialSNInventoryFacadeFactory.getRemoteInstance();
    }

    protected KDTable getTableForPrintSetting() {
        return this.kDTable;
    }

    protected boolean enableTablePreferences() {
        return true;
    }

    protected RptParams getParamsForInit() {
        return null;
    }

    public String[] getMergeColumnKeys() {
        return new String[]{"FSerialNumber", "FMaterialNumber", "FMaterialName", "FModel", "FSnUnit", "FSnStatus", "FStorageOrgUnit", "FWarehouse", "FLocation", "FStoreStatus", "FAssistProperty", "FLot", "FProject", "FTrackNumber", "FStoreType", "FSupplier", "FCustomer"};
    }

    protected CommRptBaseConditionUI getQueryDialogUserPanel() throws Exception {
        MaterialSNInventoryConditionUI conditionUI = new MaterialSNInventoryConditionUI();
        conditionUI.setSize(565, 250);
        return conditionUI;
    }

    protected void query() {
        if (this.getUIContext().get("notShowDialog") != null && Boolean.valueOf(this.getUIContext().get("notShowDialog").toString()).booleanValue() && StringUtils.isEmpty((String)this.params.getString("inventoryID"))) {
            return;
        }
        this.kDTable.removeColumns();
        this.kDTable.removeRows();
        super.query();
        boolean ckBxOnlyShowSN = this.params.getBoolean("ckBxOnlyShowSN");
        if (ckBxOnlyShowSN) {
            this.btnViewUI.setVisible(false);
        } else {
            this.btnViewUI.setVisible(true);
        }
        this.initUserConfig();
    }

    public Object getTablePreferenceSchemaKey() {
        BOSUuid object = null;
        if (this.queryDialog != null && this.queryDialog.getCurrentSolutionInfo() != null) {
            object = this.queryDialog.getCurrentSolutionInfo().getId();
        }
        return object;
    }

    public void getData(KDTDataRequestEvent e) {
        this.kDTable.getDataRequestManager().removeDataRequestListener((KDTDataRequestListener)this);
        int start = e.getFirstRow();
        int length = e.getLastRow() - start + 1;
        RptParams para = new RptParams();
        para.setString("tempTable", this.getTempTable());
        para.setObject("dateFrom", this.params.getObject("dateFrom"));
        para.setObject("dateTo", this.params.getObject("dateTo"));
        para.setObject("material", this.params.getObject("material"));
        para.setObject("snFrom", this.params.getObject("snFrom"));
        para.setObject("snTo", this.params.getObject("snTo"));
        para.setBoolean("ckBxOnlyShowSN", this.params.getBoolean("ckBxOnlyShowSN"));
        para.setObject("snStatus", this.params.getObject("snStatus"));
        para.setObject("inventoryID", (Object)this.params.getString("inventoryID"));
        try {
            if (start == 0 && this.firstLoadData) {
                try {
                    RptParams rpt = MaterialSNInventoryFacadeFactory.getRemoteInstance().createTempTable(para);
                    this.setTempTable(rpt.getString("tempTable"));
                    para.setObject("tempTable", (Object)this.getTempTable());
                    RptTableHeader header = (RptTableHeader)rpt.getObject("header");
                    KDTableUtil.setHeader((RptTableHeader)header, (KDTable)this.kDTable);
                    if (this.tHelper != null) {
                        this.tHelper.setDefaultUserData(null);
                    }
                    this.initUserConfig();
                    Map queryHeader = (Map)rpt.getObject("queryHeader");
                    if (queryHeader != null && !queryHeader.isEmpty()) {
                        SCMRptUtil.setQueryHeader((KDTable)this.kDTable, (ITablePreferenceHelper)this.tHelper, (Map)queryHeader);
                    }
                    this.kDTable.setRowCount(rpt.getInt("totalCount"));
                    rpt = MaterialSNInventoryFacadeFactory.getRemoteInstance().query(para, start, length);
                    RptRowSet rs = (RptRowSet)rpt.getObject("rowset");
                    SCMRptUtil.insertRows((RptRowSet)rs, (int)start, (CoreUI)this, (KDTable)this.kDTable, (ITablePreferenceHelper)this.tHelper);
                    this.firstLoadData = false;
                }
                catch (Exception ex) {
                    logger.error((Object)ex);
                    this.handUIExceptionAndAbort(ex);
                }
            } else {
                para.setString("tempTable", this.getTempTable());
                RptParams rpt = MaterialSNInventoryFacadeFactory.getRemoteInstance().query(para, start, length);
                RptRowSet rs = (RptRowSet)rpt.getObject("rowset");
                SCMRptUtil.insertRows((RptRowSet)rs, (int)start, (CoreUI)this, (KDTable)this.kDTable, (ITablePreferenceHelper)this.tHelper);
            }
            super.setMergeColumn();
        }
        catch (Exception ex) {
            this.handUIException(ex);
        }
        this.kDTable.getDataRequestManager().addDataRequestListener((KDTDataRequestListener)this);
    }

    @Override
    public void actionDelete_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        if (MsgBox.isYes((int)MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Confirm_Delete")))) {
            ArrayList list = new ArrayList();
            KDTSelectBlock selectBlock = null;
            int mSize = this.getTable().getSelectManager().size();
            for (int p = mSize - 1; p >= 0; --p) {
                selectBlock = this.getTable().getSelectManager().get(p);
                if (selectBlock == null) continue;
                for (int i = selectBlock.getEndRow(); i >= selectBlock.getTop(); --i) {
                    HashMap<String, String> dataMap = new HashMap<String, String>();
                    IRow row = this.getTable().getRow(i);
                    int snStatus = Integer.parseInt(row.getCell("FSnStatus").getValue().toString());
                    if (snStatus != 4) {
                        throw new SerialNumberException(SerialNumberException.CANNOTDELETE_WAITIN);
                    }
                    String materialID = row.getCell("FMaterialID").getValue().toString();
                    String serialNumber = row.getCell("FSerialNumber").getValue().toString();
                    dataMap.put("materialID", materialID);
                    dataMap.put("serialNumber", serialNumber);
                    list.add(dataMap);
                }
            }
            if (list.size() > 0) {
                MaterialSNInventoryFactory.getRemoteInstance().deleteMaterialSNInventory(list);
                this.actionRefresh_actionPerformed(e);
            }
        }
    }

    @Override
    public void actionViewUI_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        if (!this.checkObjectExists()) {
            return;
        }
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ID", (Object)this.getSelectedKeyValue());
        this.prepareUIContext(uiContext, e);
        IUIWindow uiWindow = null;
        uiWindow = SwingUtilities.getWindowAncestor((Component)((Object)this)) != null && SwingUtilities.getWindowAncestor((Component)((Object)this)) instanceof JDialog ? UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(this.getEditUIName(), (Map)uiContext, null, OprtState.VIEW) : UIFactory.createUIFactory((String)this.getEditUIModal()).create(this.getEditUIName(), (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
    }

    protected void prepareUIContext(UIContext uiContext, ActionEvent e) {
        RealModeIDList idList = new RealModeIDList();
        idList.add(this.getSelectedKeyValue());
        uiContext.put((Object)"IDList", (Object)idList);
    }

    private String getEditUIModal() {
        return "com.kingdee.eas.base.uiframe.client.UINewFrameFactory";
    }

    private void checkSelected() {
        if (this.kDTable.getSelectManager().size() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            SysUtil.abort();
        }
    }

    private boolean checkObjectExists() throws BOSException, EASBizException, Exception {
        if (this.getSelectedKeyValue() == null) {
            throw new EASBizException(EASBizException.CHECKEXIST);
        }
        if (!this.getBizInterface().exists((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)this.getSelectedKeyValue())))) {
            throw new EASBizException(EASBizException.CHECKEXIST);
        }
        return true;
    }

    protected String getSelectedKeyValue() {
        KDTSelectBlock selectBlock = this.kDTable.getSelectManager().get();
        if (selectBlock != null) {
            Object keyValue;
            int rowIndex = selectBlock.getTop();
            IRow row = this.kDTable.getRow(rowIndex);
            if (row == null) {
                return null;
            }
            ICell cell = row.getCell(this.getKeyFieldName());
            if (cell == null) {
                MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Error_KeyField_Fail"));
                SysUtil.abort();
            }
            if (!((keyValue = cell.getValue()) == null || keyValue.equals("0") || keyValue.equals(" ") || keyValue.equals(""))) {
                return keyValue.toString();
            }
            return null;
        }
        return null;
    }

    private ICoreBase getBizInterface() throws Exception {
        String billType = new String(this.getCellValue("FBillTypeID_lz"));
        if (billType.equals("50957179-0105-1000-e000-0157c0a812fd463ED552")) {
            return PurReceivalBillFactory.getRemoteInstance();
        }
        if (billType.equals("50957179-0105-1000-e000-015fc0a812fd463ED552")) {
            return PurInWarehsBillFactory.getRemoteInstance();
        }
        if (billType.equals("50957179-0105-1000-e000-0167c0a812fd463ED552")) {
            return ManufactureRecBillFactory.getRemoteInstance();
        }
        if (billType.equals("50957179-0105-1000-e000-0172c0a812fd463ED552")) {
            return MoveInWarehsBillFactory.getRemoteInstance();
        }
        if (billType.equals("50957179-0105-1000-e000-017bc0a812fd463ED552")) {
            return OtherInWarehsBillFactory.getRemoteInstance();
        }
        if (billType.equals("50957179-0105-1000-e000-015bc0a812fd463ED552")) {
            return SaleIssueBillFactory.getRemoteInstance();
        }
        if (billType.equals("50957179-0105-1000-e000-0163c0a812fd463ED552")) {
            return MaterialReqBillFactory.getRemoteInstance();
        }
        if (billType.equals("50957179-0105-1000-e000-016ec0a812fd463ED552")) {
            return MoveIssueBillFactory.getRemoteInstance();
        }
        if (billType.equals("50957179-0105-1000-e000-0177c0a812fd463ED552")) {
            return OtherIssueBillFactory.getRemoteInstance();
        }
        if (billType.equals("XlazxwEREADgAAAEwKgSxUY+1VI=")) {
            return MaterialRequestBillFactory.getRemoteInstance();
        }
        if (billType.equals("3a3b5446-0106-1000-e000-01bcc0a812e6463ED552")) {
            return CostAdjustBillFactory.getRemoteInstance();
        }
        if (billType.equals("50957179-0105-1000-e001-1152c0a812fd463ED552")) {
            return MoveLocationBillFactory.getRemoteInstance();
        }
        if (billType.equals("528d806a-0106-1000-e000-0194c0a812e6463ED552")) {
            return InventoryInitBillFactory.getRemoteInstance();
        }
        if (billType.equals("50957179-0105-1000-e000-0152c0a812fd463ED552")) {
            return InvStateAdjustBillFactory.getRemoteInstance();
        }
        if (billType.equals("50957179-0105-1000-e001-1152c0a812fd463ED552")) {
            return MoveLocationBillFactory.getRemoteInstance();
        }
        return null;
    }

    private String getEditUIName() {
        String billType = new String(this.getCellValue("FBillTypeID_lz"));
        if (billType.equals("50957179-0105-1000-e000-0157c0a812fd463ED552")) {
            return PurReceivalBillEditUI.class.getName();
        }
        if (billType.equals("50957179-0105-1000-e000-015fc0a812fd463ED552")) {
            return PurInWarehsBillEditUI.class.getName();
        }
        if (billType.equals("50957179-0105-1000-e000-0167c0a812fd463ED552")) {
            return ManufactureRecBillEditUI.class.getName();
        }
        if (billType.equals("50957179-0105-1000-e000-0172c0a812fd463ED552")) {
            return MoveInWarehsBillEditUI.class.getName();
        }
        if (billType.equals("50957179-0105-1000-e000-017bc0a812fd463ED552")) {
            return OtherInWarehsBillEditUI.class.getName();
        }
        if (billType.equals("50957179-0105-1000-e000-015bc0a812fd463ED552")) {
            return SaleIssueBillEditUI.class.getName();
        }
        if (billType.equals("50957179-0105-1000-e000-0163c0a812fd463ED552")) {
            return MaterialReqBillEditUI.class.getName();
        }
        if (billType.equals("50957179-0105-1000-e000-016ec0a812fd463ED552")) {
            return MoveIssueBillEditUI.class.getName();
        }
        if (billType.equals("50957179-0105-1000-e000-0177c0a812fd463ED552")) {
            return OtherIssueBillEditUI.class.getName();
        }
        if (billType.equals("XlazxwEREADgAAAEwKgSxUY+1VI=")) {
            return MaterialRequestBillEditUI.class.getName();
        }
        if (billType.equals("3a3b5446-0106-1000-e000-01bcc0a812e6463ED552")) {
            return CostAdjustBillEditUI.class.getName();
        }
        if (billType.equals("50957179-0105-1000-e001-1152c0a812fd463ED552")) {
            return MoveLocationBillEditUI.class.getName();
        }
        if (billType.equals("528d806a-0106-1000-e000-0194c0a812e6463ED552")) {
            return InventoryInitBillEditUI.class.getName();
        }
        if (billType.equals("50957179-0105-1000-e000-0152c0a812fd463ED552")) {
            return InvStateAdjustBillEditUI.class.getName();
        }
        if (billType.equals("50957179-0105-1000-e001-1152c0a812fd463ED552")) {
            return MoveLocationBillEditUI.class.getName();
        }
        return null;
    }

    protected String getCellValue(String cellField) {
        KDTSelectBlock selectBlock = this.kDTable.getSelectManager().get();
        if (selectBlock != null) {
            Object keyValue;
            int rowIndex = selectBlock.getTop();
            IRow row = this.kDTable.getRow(rowIndex);
            if (row == null) {
                return null;
            }
            ICell cell = row.getCell(cellField);
            if (cell == null) {
                MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Error_KeyField_Fail"));
                SysUtil.abort();
            }
            if ((keyValue = cell.getValue()) != null) {
                return keyValue.toString();
            }
        }
        return null;
    }

    private String getKeyFieldName() {
        return "FBillID_lz";
    }

    protected IVirtualRptBaseFacade getVirtualRemoteInstance() throws BOSException {
        return MaterialSNInventoryFacadeFactory.getRemoteInstance();
    }

    protected KDTable getTable() {
        return this.kDTable;
    }

    @Override
    public boolean isPrepareInit() {
        return true;
    }

    protected void preparePrintPageHeader(HeadFootModel header) {
    }

    protected Map preparePrintVariantMap() {
        return new HashMap();
    }

    @Override
    public void actionSNImport_actionPerformed(ActionEvent e) throws Exception {
        super.actionSNImport_actionPerformed(e);
        this.windowOpen();
    }

    private void windowOpen() throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"OprtState", (Object)this.getOprtState());
        if (this.snImportWindow == null) {
            this.snImportWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create("com.kingdee.eas.scm.im.inv.client.FileImportUI", (Map)uiContext, null, OprtState.VIEW);
        }
        FileImportUI fileImportUI = (FileImportUI)this.snImportWindow.getUIObject();
        fileImportUI.init(this.getSNResource("SNInventoryImport"), "XLS");
        fileImportUI.setResUI((CoreUI)this);
        this.snImportWindow.show();
        if (fileImportUI.isIscancel()) {
            return;
        }
        File file = fileImportUI.getFile();
        if (file == null) {
            return;
        }
        this.importFromExcel(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void importFromExcel(File afile) throws Exception {
        HSSFWorkbook workBook;
        try (FileInputStream fin = null;){
            fin = new FileInputStream(afile);
            workBook = new HSSFWorkbook((InputStream)fin);
        }
        HSSFSheet sheet = workBook.getSheetAt(0);
        if (sheet == null) {
            String msg = this.getSNResource("NotFindSheet");
            MsgBox.showError((Component)((Object)this), (String)(msg + ":sheetName"));
            return;
        }
        MaterialSNInventoryCollection snInfos = new MaterialSNInventoryCollection();
        if ((snInfos = this.readXlsAndDataCheck(snInfos, workBook)) != null && snInfos.size() > 0) {
            try {
                MaterialSNInventoryFactory.getRemoteInstance().saveMaterialSNInventoryBatch(snInfos);
                MsgBox.showInfo((String)this.getSNResource("import_Inventory_success"));
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        }
    }

    private MaterialSNInventoryCollection readXlsAndDataCheck(MaterialSNInventoryCollection snInfos, HSSFWorkbook workBook) throws BOSException, EASBizException {
        HSSFSheet sheet = workBook.getSheetAt(0);
        int rowCount = sheet.getLastRowNum();
        int startCol = 0;
        StringBuffer errorMsg = new StringBuffer();
        for (int i = 0; i <= rowCount; ++i) {
            HSSFRow cells = sheet.getRow(i);
            int cellRow = i + 1;
            if (i == 0) {
                if (cells.getCell(startCol) != null && cells.getCell(startCol + 1) != null && this.getSNResource("materaiNumber").equals(cells.getCell(startCol).toString()) && this.getSNResource("SERIALNUMBER").equals(cells.getCell(startCol + 1).toString())) continue;
                errorMsg.append(this.getSNResource("table_head_error"));
                continue;
            }
            if (cells == null || cells.getLastCellNum() < 0 || (cells.getCell(startCol) == null || StringUtil.isEmpty((String)cells.getCell(startCol).toString())) && (cells.getCell(startCol + 1) == null || StringUtil.isEmpty((String)cells.getCell(startCol + 1).toString()))) continue;
            if (cells.getCell(startCol) == null || StringUtil.isEmpty((String)cells.getCell(startCol).toString())) {
                errorMsg.append(this.getSNResource("materialNumber_empty", new String[]{String.valueOf(cellRow)}));
                continue;
            }
            String materialNumber = cells.getCell(startCol).toString();
            MaterialInfo material = null;
            material = this.getMaterialInfo(materialNumber);
            if (material == null) {
                errorMsg.append(this.getSNResource("MATERIAL_NOT_FIND", new String[]{String.valueOf(cellRow)}));
                continue;
            }
            if (material.getSeqUnit() == null) {
                errorMsg.append(this.getSNResource("MATERAIL_NOT_SMANGEMENT", new String[]{String.valueOf(cellRow)}));
                continue;
            }
            cells.getCell(startCol + 1).setCellType(CellType.STRING);
            if (cells.getCell(startCol + 1) == null || StringUtil.isEmpty((String)cells.getCell(startCol + 1).toString())) {
                errorMsg.append(this.getSNResource("sn_number_isNull", new String[]{String.valueOf(cellRow)}));
                continue;
            }
            String serialNumber = cells.getCell(startCol + 1).toString();
            for (int k = 0; k < snInfos.size(); ++k) {
                boolean isRepeat = false;
                MaterialSNInventoryInfo entryInfos = snInfos.get(k);
                if (serialNumber.equals(entryInfos.getSerialNumber()) && materialNumber.equals(entryInfos.getMaterial().getNumber())) {
                    errorMsg.append(this.getSNResource("sn_table_repeat", new String[]{String.valueOf(cellRow)}));
                    isRepeat = true;
                    break;
                }
                if (isRepeat) break;
            }
            MaterialSNInventoryInfo snInfo = new MaterialSNInventoryInfo();
            snInfo.setSerialNumber(serialNumber);
            snInfo.setMaterial(material);
            snInfo.setSnStatus(SerialNumberStatusEnum.WAITIN);
            snInfos.add(snInfo);
        }
        if (errorMsg.length() > 0) {
            String msg = this.getSNResource("import_error");
            MsgBox.showDetailAndOK(null, (String)msg, (String)errorMsg.toString(), (int)2);
            return null;
        }
        if (snInfos == null || snInfos.size() == 0) {
            MsgBox.showInfo((String)this.getSNResource("filenodata"));
            return null;
        }
        return snInfos;
    }

    private MaterialInfo getMaterialInfo(String materialNumber) throws EASBizException, BOSException {
        MaterialInfo materialInfo = null;
        materialInfo = (MaterialInfo)this.materialCacheMap.get(materialNumber);
        if (materialInfo != null) {
            return materialInfo;
        }
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)materialNumber));
        ev.setFilter(filter);
        ev.getSelector().add(new SelectorItemInfo("id"));
        ev.getSelector().add(new SelectorItemInfo("number"));
        ev.getSelector().add(new SelectorItemInfo("name"));
        ev.getSelector().add(new SelectorItemInfo("seqUnit.name"));
        ev.getSelector().add(new SelectorItemInfo("seqUnit.id"));
        ev.getSelector().add(new SelectorItemInfo("seqUnit.number"));
        MaterialCollection mi = MaterialFactory.getRemoteInstance().getMaterialCollection(ev);
        if (mi.size() > 1) {
            String msg = this.getSNResource("MATERIALNUMBER_REPEAT", new String[]{materialNumber});
            MsgBox.showError((String)msg);
            SysUtil.abort();
        } else if (mi.size() > 0) {
            materialInfo = mi.get(0);
            this.materialCacheMap.put(materialNumber, materialInfo);
        }
        return materialInfo;
    }

    public void exportTempFile(File file) throws BOSException {
        try {
            if (file != null) {
                HSSFWorkbook book = this.creatBook();
                FileOutputStream fout = new FileOutputStream(file);
                book.write((OutputStream)fout);
                fout.close();
                this.openFileInExcel(file.getAbsolutePath());
            }
        }
        catch (Exception e) {
            MsgBox.showError((String)e.getMessage());
        }
    }

    private HSSFWorkbook creatBook() {
        HSSFWorkbook wb = new HSSFWorkbook();
        HSSFSheet sheet = wb.createSheet(this.getSNResource("SERIALNUMBER"));
        HSSFRow row = sheet.createRow(0);
        sheet.setColumnWidth(0, 6400);
        sheet.setColumnWidth(1, 10240);
        HSSFCellStyle defaultColumnStyle = wb.createCellStyle();
        HSSFDataFormat format = wb.createDataFormat();
        defaultColumnStyle.setDataFormat(format.getFormat("@"));
        sheet.setDefaultColumnStyle(0, (CellStyle)defaultColumnStyle);
        sheet.setDefaultColumnStyle(1, (CellStyle)defaultColumnStyle);
        HSSFCellStyle style = wb.createCellStyle();
        HSSFCellStyle style2 = wb.createCellStyle();
        style.setAlignment(HorizontalAlignment.CENTER);
        style.setBorderBottom(BorderStyle.THIN);
        style.setBorderLeft(BorderStyle.THIN);
        style.setBorderTop(BorderStyle.THIN);
        style.setBorderRight(BorderStyle.THIN);
        style2.setBorderBottom(BorderStyle.THIN);
        style2.setBorderLeft(BorderStyle.THIN);
        style2.setBorderTop(BorderStyle.THIN);
        style2.setBorderRight(BorderStyle.THIN);
        HSSFFont font = wb.createFont();
        font.setBold(true);
        style.setFont(font);
        HSSFCell cell = row.createCell(0);
        cell.setCellValue(this.getSNResource("materaiNumber"));
        cell.setCellStyle(style);
        cell = row.createCell(1);
        cell.setCellValue(this.getSNResource("SERIALNUMBER"));
        cell.setCellStyle(style);
        int rowNum = 1;
        for (int i = 0; i < 10; ++i) {
            row = sheet.createRow(rowNum++);
            cell = row.createCell(0);
            cell.setCellStyle(style2);
            cell.setCellValue("");
            cell = row.createCell(1);
            cell.setCellStyle(style2);
            cell.setCellValue("");
        }
        return wb;
    }

    private void openFileInExcel(String file) throws IOException {
        File f = GlobalLocator.getInstance().locateResourceFile("/client/LanchFile.bat");
        if (f == null) {
            throw new IOException();
        }
        Runtime.getRuntime().exec("\"" + f.getAbsolutePath() + "\" \"excel\" \"" + file + "\"");
    }

    private String getSNResource(String field) {
        return EASResource.getString((String)SN_RESOURCE, (String)field);
    }

    private String getSNResource(String field, String[] params) {
        return EASResource.getString((String)SN_RESOURCE, (String)field, (Object[])params);
    }
}

