/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.BizDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.IDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.render.ObjectValueRender;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.IKDTextComponent;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDPromptBox;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.ctrl.swing.event.PreChangeEvent;
import com.kingdee.bos.ctrl.swing.event.PreChangeListener;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.scm.util.SCMF7ContextUtils;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.MeasureUnitFactory;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.AsstAttrTypeInfo;
import com.kingdee.eas.basedata.master.material.AsstAttrValueInfo;
import com.kingdee.eas.basedata.master.material.IMultiMeasureUnit;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MaterialInventoryFactory;
import com.kingdee.eas.basedata.master.material.MaterialInventoryInfo;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.basedata.scm.common.TransactionTypeInfo;
import com.kingdee.eas.basedata.scm.im.inv.IWarehouse;
import com.kingdee.eas.basedata.scm.im.inv.LocationInfo;
import com.kingdee.eas.basedata.scm.im.inv.LotFrame;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseFactory;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.batchaction.ActionLevelEnum;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.mm.common.client.UIHelper;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.EntryBaseStatusEnum;
import com.kingdee.eas.scm.common.SCMBillEntryBaseInfo;
import com.kingdee.eas.scm.common.SCMFetchData;
import com.kingdee.eas.scm.common.SCMFetchDataCondition;
import com.kingdee.eas.scm.common.action.ISupportBatchAction;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.loadmass.SCMBizDataVO;
import com.kingdee.eas.scm.common.util.StringUtil;
import com.kingdee.eas.scm.im.inv.IMaterialSerialNumber;
import com.kingdee.eas.scm.im.inv.IMoveIssueBillEntry;
import com.kingdee.eas.scm.im.inv.InvBillBaseEntryInfo;
import com.kingdee.eas.scm.im.inv.InvCommonUtils;
import com.kingdee.eas.scm.im.inv.InventoryInfo;
import com.kingdee.eas.scm.im.inv.MaterialSerialNumberCollection;
import com.kingdee.eas.scm.im.inv.MaterialSerialNumberFactory;
import com.kingdee.eas.scm.im.inv.MoveIssueBillAgent;
import com.kingdee.eas.scm.im.inv.MoveIssueBillEntryAgent;
import com.kingdee.eas.scm.im.inv.MoveIssueBillEntryCollection;
import com.kingdee.eas.scm.im.inv.MoveIssueBillEntryFactory;
import com.kingdee.eas.scm.im.inv.MoveIssueBillEntryInfo;
import com.kingdee.eas.scm.im.inv.MoveIssueBillFactory;
import com.kingdee.eas.scm.im.inv.MoveIssueBillInfo;
import com.kingdee.eas.scm.im.inv.StockTransferBillEntryFactory;
import com.kingdee.eas.scm.im.inv.StockTransferBillEntryInfo;
import com.kingdee.eas.scm.im.inv.client.AbstractMoveIssueBillEditUI;
import com.kingdee.eas.scm.im.inv.client.InvClientUtils;
import com.kingdee.eas.scm.util.SCMSelectorFactory;
import com.kingdee.eas.scm.util.filehandle.ResourceUtil;
import com.kingdee.eas.scm.util.numeric.NumericUtil;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class MoveIssueBillEditUI
extends AbstractMoveIssueBillEditUI
implements DataChangeListener,
ChangeListener,
KDTEditListener,
PreChangeListener {
    private static final long serialVersionUID = 2841362138155829439L;
    private static final String TB_MATERIAL = "materialNum";
    private static final String TB_MATERIALNAME = "materialName";
    private static final String TB_MATERIALMODEL = "materialModel";
    private static final String TB_UNIT = "unit";
    private static final String TB_QTY = "qty";
    private static final String TB_WAREHOUSE = "warehouse";
    private static final String TB_ASSISTQTY = "assistantQty";
    private static final String TB_COUNTERQTY = "counterialQty";
    private static final String TB_UNITSTANCOST = "unitStandardCost";
    private static final String TB_STANDARDCOST = "standardCost";
    private static final String TB_UNITFACTCOST = "unitFactCost";
    private static final String TB_FACTCOST = "factCost";
    private static final String TB_ASSISTANTUNIT = "assistantUnit";
    private static final String TB_LOCATION = "location";
    private static final String TB_STOCKER = "stocker";
    private static final String TB_BATCH = "lot";
    private static final String TB_ASSISTANATTR = "assistantAttr";
    private static final String TB_BASEUNIT = "baseUnit";
    private static final String TB_BASEUNITQTY = "baseUnitQty";
    private static final String TB_MFG = "mfg";
    private static final String TB_EXP = "exp";
    private static final String TB_STOCKTRANSFERBILLNUM = "stockTransferBillNum";
    private static final String TB_STOCKTRANSFERBILLSEQ = "stockTransferBillSeq";
    private static final String TB_ISPRESENT = "isPresent";
    private static final String TB_CANINWAREHSBASEQTY = "canInwarehsBaseQty";
    private static final String TB_TOTALINWAREHSQTY = "totalInWarehsQty";
    private static final String TB_PROJECTNUM = "projectNumCol";
    private static final String TB_TRACKNUM = "trackNumCol";
    private static final String TB_PRICE = "price";
    private static final String TB_AMOUNT = "amount";
    KDBizPromptBox bizMaterialNumber = null;
    private KDBizPromptBox prmtSupplier = null;
    private KDBizPromptBox prmtCustomer = null;
    private boolean inwardSetOff = false;
    private boolean inwardBOTP = false;
    private boolean isBOTP = false;
    boolean isReverse = false;
    private int SRowIndex;
    private KDBizPromptBox prmtWarehouse;
    private int indexRow = 1;
    private int indexCol = 1;
    private static final String[] PRICE_PRECISION_TAB = new String[]{"unitStandardCost", "unitFactCost", "price"};
    private static final String[] BASEQTY_PRECISION_TAB = new String[]{"baseUnitQty", "unVmiSettleBaseQty", "totalVmiSettleBaseQty"};
    private static final String[] LOCKCOLS = new String[]{"qty", "unit"};
    private static final String[] ASSQTY_PRECISION_TAB = new String[]{"assistantQty"};
    private static final String[] NECESSCOLOR_COLUMNS = new String[]{"materialNum", "unit", "qty", "warehouse"};
    private static final String[] QTYPRECISIONTAB = new String[]{"qty", "counterialQty", "totalInWarehsQty"};
    private static final String[] CURRENCYPRECISIONTAB = new String[]{"standardCost", "factCost"};
    private static final String[] NeedInverseQtyColumns = new String[]{"qty", "baseUnitQty", "assistantQty", "amount", "factCost", "standardCost", "counterialQty", "canInwarehsBaseQty", "totalInWarehsQty", "unVmiSettleBaseQty", "totalVmiSettleBaseQty"};

    public MoveIssueBillEditUI() throws Exception {
        this.initConfigMap();
    }

    @Override
    protected void initBOTPData() throws Exception {
        this.initBOTPOrReverseData(this.editData);
    }

    @Override
    protected void initReverseData() throws Exception {
    }

    protected void initBOTPOrReverseData(MoveIssueBillInfo editData) throws Exception {
        if (editData != null && editData.getBoolean("autoTransfer")) {
            this.setOprtState(OprtState.EDIT);
            this.setDataObject((IObjectValue)editData);
            this.initFetchData();
        }
        this.isBOTP = !this.isReverse && editData.getSourceBillType() != null;
        int entrySize = editData.getEntry().size();
        String materialId = "";
        if ((this.isReverse || this.isBOTP && editData.getBillType() == null) && entrySize > 0) {
            if (this.isBOTP) {
                editData.setIsInitBill(false);
                this.sou = editData.getStorageOrgUnit();
                this.setCouBySou();
                if (this.sou != null && this.cou == null) {
                    MsgBox.showInfo((String)InvClientUtils.getResource("StorageOrgNotHasCompanyOrg"));
                    SysUtil.abort();
                }
                editData.setIssueCompanyOrgUnit(this.cou);
                editData.setReceiptCompanyOrgUnit(this.cou);
                if (this.cou.getBaseCurrency() != null) {
                    this.localAmtPrecision = this.cou.getBaseCurrency().getPrecision();
                }
                BillTypeInfo billType = new BillTypeInfo();
                billType.setId(BOSUuid.read((String)"50957179-0105-1000-e000-016ec0a812fd463ED552"));
                billType.setNumber("107");
                editData.setBillType(billType);
            }
            for (int i = 0; i < entrySize; ++i) {
                MoveIssueBillEntryInfo entry = editData.getEntry().get(i);
                BigDecimal qty = entry.getQty();
                entry.setTotalInWarehsQty(entry.getTotalInWarehsQty() == null ? InvClientUtils.ZERO : entry.getTotalInWarehsQty());
                if (!this.isReverse) continue;
                entry.setQty(qty == null ? InvClientUtils.ZERO : qty.abs());
                entry.setBaseQty(entry.getBaseQty() == null ? InvClientUtils.ZERO : entry.getBaseQty().abs());
                entry.setAssistQty(entry.getAssistQty() == null ? null : entry.getAssistQty().abs());
                entry.setActualCost(entry.getActualCost() == null ? null : entry.getActualCost().abs());
                entry.setStandardCost(entry.getStandardCost() == null ? null : entry.getStandardCost().abs());
            }
        }
    }

    @Override
    protected void setCouBySou() {
        super.setCouBySou();
        if (this.cou != null && this.cou.getBaseCurrency() != null && this.cou.getBaseCurrency().getName() == null) {
            try {
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("id"));
                sic.add(new SelectorItemInfo("number"));
                sic.add(new SelectorItemInfo("name"));
                sic.add(new SelectorItemInfo("precision"));
                this.cou.setBaseCurrency(CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)new ObjectUuidPK(this.cou.getBaseCurrency().getId()), sic));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void loadFields() {
        this.isReverse = this.editData.isIsReversed();
        this.isBOTP = !this.editData.isIsReversed() && this.editData.getSourceBillType() != null;
        try {
            this.removeListeners();
            this.initFetchData();
            this.loadFieldsBefore();
            super.loadFields();
            if (this.sou == null) {
                this.sou = this.editData.getStorageOrgUnit();
            }
            if (this.cou == null || this.cou.getBaseCurrency() == null || this.cou.getBaseCurrency().getName() == null) {
                this.setCouBySou();
            }
            if (this.sou != null && this.cou == null) {
                MsgBox.showInfo((String)InvClientUtils.getResource("StorageOrgNotHasCompanyOrg"));
                SysUtil.abort();
            }
            if (this.cou != null && this.cou.getBaseCurrency() != null) {
                this.localAmtPrecision = this.cou.getBaseCurrency().getPrecision();
                int precision = this.cou.getBaseCurrency() == null ? 2 : this.cou.getBaseCurrency().getPrecision();
                SCMClientUtils.changeAllCellPrecision((KDTable)this.getDetailTable(), (String[])CURRENCYPRECISIONTAB, (int)precision, (boolean)this.isNegativeBill);
            }
            this.loadFieldsAfter();
            this.setControl();
            BigDecimal totalActualCost = new BigDecimal("0.00");
            int num = this.kdtEntry.getRowCount();
            for (int i = 0; i < num; ++i) {
                BigDecimal actualCost = (BigDecimal)this.kdtEntry.getCell(i, TB_FACTCOST).getValue();
                if (actualCost == null) continue;
                totalActualCost = totalActualCost.add(actualCost);
            }
            this.editData.setTotalActualCost(totalActualCost);
            this.txtAddFactCost.setValue((Object)totalActualCost);
            if (this.getOprtState().equals("ADDNEW")) {
                this.setDefaultMainOrgUnit();
            }
            this.addListeners();
        }
        catch (Exception ex) {
            this.handUIException(ex);
        }
        if (this.isBillQuery()) {
            this.setOnlyActualCostEditable();
        }
        this.syncOldData((IObjectValue)this.editData);
        this.initTableControls();
        this.kdtEntry.getColumn(TB_EXP).getStyleAttributes().setNumberFormat(SCMClientUtils.strDateFormat);
        this.kdtEntry.getColumn(TB_MFG).getStyleAttributes().setNumberFormat(SCMClientUtils.strDateFormat);
        this.initIsSetOff();
        InvClientUtils.setColumnsFontColor(this.getDetailTable(), this.getNumberColumns(), this.getTransactionType(), this.editData.isIsReversed());
    }

    @Override
    protected int getDefaultOrgMask() {
        return 2;
    }

    private void initEntrys() throws EASBizException, BOSException {
        SCMClientUtils.changeTableColPrecision((int)this.localAmtPrecision, (KDTable)this.kdtEntry, (String[])new String[]{TB_AMOUNT});
        StorageOrgUnitInfo storage = (StorageOrgUnitInfo)this.prmtStorageOrgUnit.getValue();
        this.kdtEntry.getColumn(TB_WAREHOUSE).getStyleAttributes().setLocked(false);
        if (storage != null) {
            int count = this.getDetailTable().getRowCount();
            this.lotFrameList = new LinkedList();
            for (int i = 0; i < count; ++i) {
                this.initEntry(null, i, storage);
            }
        } else {
            this.kdtEntry.getColumn(TB_MATERIAL).getStyleAttributes().setLocked(true);
        }
        this.kdtEntry.getColumn(TB_TOTALINWAREHSQTY).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.kdtEntry.getColumn(TB_TOTALINWAREHSQTY).getStyleAttributes().setLocked(true);
        this.kdtEntry.getColumn(TB_CANINWAREHSBASEQTY).getStyleAttributes().setHided(true);
    }

    private int getPrecision(String materialId, MeasureUnitInfo unitInfo) throws BOSException, EASBizException {
        Integer precision = this.fetchData.getUnitPrecision(materialId, unitInfo.getId().toString());
        return precision == null ? 2 : precision;
    }

    private void initEntry(MaterialInfo materialInfo, int i, StorageOrgUnitInfo storage) throws BOSException, EASBizException {
        MaterialInfo material = null;
        MeasureUnitInfo unit = null;
        MeasureUnitInfo assUnit = null;
        MeasureUnitInfo baseUnit = null;
        WarehouseInfo warehs = null;
        String materialId = null;
        MaterialInventoryInfo materialInvInfo = null;
        IRow curRow = this.kdtEntry.getRow(i);
        material = materialInfo == null ? (MaterialInfo)this.kdtEntry.getCell(i, TB_MATERIAL).getValue() : materialInfo;
        unit = (MeasureUnitInfo)curRow.getCell(TB_UNIT).getValue();
        assUnit = (MeasureUnitInfo)curRow.getCell(TB_ASSISTANTUNIT).getValue();
        baseUnit = (MeasureUnitInfo)curRow.getCell(TB_BASEUNIT).getValue();
        warehs = (WarehouseInfo)curRow.getCell(TB_WAREHOUSE).getValue();
        boolean isMaterLock = false;
        if (("EDIT".equalsIgnoreCase(this.getOprtState()) || "ADDNEW".equalsIgnoreCase(this.getOprtState())) && (this.isReverse || this.isBOTP)) {
            isMaterLock = true;
        }
        curRow.getCell(TB_MATERIAL).getStyleAttributes().setLocked(isMaterLock);
        if (material != null) {
            this.setActualCostColor(curRow);
            InvClientUtils.setColLock(this.kdtEntry, new String[]{TB_QTY}, i, false);
            materialId = material.getId().toString();
            materialInvInfo = this.fetchData.getMaterialInventory(materialId, storage.getId().toString());
            SCMClientUtils.changeTableColPrecision((int)material.getPricePrecision(), (KDTable)this.kdtEntry, (String[])PRICE_PRECISION_TAB, (int)i);
            this.changeQtyPrecision(curRow);
            if (materialInvInfo != null && materialInvInfo.isIsLotNumber()) {
                if (curRow.getCell(TB_BATCH).getValue() == null) {
                    curRow.getCell(TB_BATCH).getStyleAttributes().setLocked(false);
                    LotFrame lotFrame = new LotFrame();
                    lotFrame.setSeq(i);
                    lotFrame.setMainBizOrg(this.sou.getId().toString());
                    lotFrame.setMaterial(material.getId().toString());
                    this.lotFrameList.add(lotFrame);
                }
                curRow.getCell(TB_BATCH).getStyleAttributes().setLocked(false);
                SCMClientUtils.setNecessColorInCells((KDTable)this.kdtEntry, (String)TB_BATCH, (int)i, (boolean)true);
                InvClientUtils.setExpAndMfgEnabled(materialInvInfo, this.kdtEntry, i, false);
                if (this.isBOTP && curRow.getCell(TB_BATCH).getValue() != null) {
                    StorageOrgUnitInfo sou = (StorageOrgUnitInfo)this.prmtStorageOrgUnit.getValue();
                    InvClientUtils.setLotInfo(this.kdtEntry, i, sou, material, curRow.getCell(TB_BATCH).getValue().toString(), this.editData, this.fetchData);
                }
            } else {
                curRow.getCell(TB_BATCH).getStyleAttributes().setLocked(true);
                curRow.getCell(TB_BATCH).setValue(null);
                curRow.getCell(TB_MFG).getStyleAttributes().setLocked(true);
                curRow.getCell(TB_EXP).getStyleAttributes().setLocked(true);
            }
            if (materialInvInfo != null && materialInvInfo.isIsSequenceNo()) {
                curRow.getCell(this.kdtEntry.getColumnIndex("isSerialNumber")).setValue((Object)new Boolean(true));
            } else {
                curRow.getCell(this.kdtEntry.getColumnIndex("isSerialNumber")).setValue((Object)new Boolean(false));
            }
            this.initEntryUnitCell(i, material);
            boolean isUseWarehsRelation = this.isUseWarehsRelation(this.sou);
            if (isUseWarehsRelation) {
                InvClientUtils.setWarehouseFitlerByMSRelation(this.sou, material, this.getDetailTable(), i, TB_WAREHOUSE, -1);
            }
            if (warehs != null && warehs.isHasLocation()) {
                curRow.getCell(TB_LOCATION).getStyleAttributes().setLocked(false);
                SCMClientUtils.setNecessColorInCells((KDTable)this.kdtEntry, (String)TB_LOCATION, (int)i, (boolean)true);
                if (isUseWarehsRelation) {
                    InvClientUtils.setLocationFilterByMSRelation((CoreUIObject)this, this.sou, warehs, material, this.getDetailTable(), i, false, this.fetchData);
                } else {
                    KDBizPromptBox kDBizPromptBoxLocation = InvClientUtils.getLocationF7((CoreUIObject)this, warehs);
                    curRow.getCell(TB_LOCATION).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)kDBizPromptBoxLocation));
                }
            } else {
                curRow.getCell(TB_LOCATION).getStyleAttributes().setLocked(true);
                SCMClientUtils.setNecessColorInCells((KDTable)this.kdtEntry, (String)TB_LOCATION, (int)i, (boolean)false);
            }
            if (warehs == null || !this.isBOTP && !this.isReverse) {
                curRow.getCell(TB_WAREHOUSE).getStyleAttributes().setLocked(false);
            }
            this.setEntryAssistProperty(i, material);
        } else {
            String[] precisionFileds = new String[]{TB_QTY, TB_BASEUNITQTY, TB_UNITSTANCOST, TB_UNITFACTCOST, TB_TOTALINWAREHSQTY, TB_COUNTERQTY, "unVmiSettleBaseQty", "totalVmiSettleBaseQty"};
            SCMClientUtils.changeTableColPrecision((int)2, (KDTable)this.getDetailTable(), (String[])precisionFileds, (int)i, (boolean)true);
        }
    }

    private void changeQtyPrecision(IRow curRow) throws BOSException, EASBizException {
        MaterialInfo material = (MaterialInfo)curRow.getCell(TB_MATERIAL).getValue();
        if (material == null) {
            return;
        }
        String materialId = material.getId().toString();
        MeasureUnitInfo unit = (MeasureUnitInfo)curRow.getCell(TB_UNIT).getValue();
        MeasureUnitInfo assUnit = (MeasureUnitInfo)curRow.getCell(TB_ASSISTANTUNIT).getValue();
        MeasureUnitInfo baseUnit = (MeasureUnitInfo)curRow.getCell(TB_BASEUNIT).getValue();
        if (unit != null) {
            SCMClientUtils.changeCellPrecision((IRow)curRow, (String[])QTYPRECISIONTAB, (int)this.getPrecision(materialId, unit), (boolean)this.isNegativeBill, (boolean)true);
        }
        if (assUnit != null) {
            SCMClientUtils.changeCellPrecision((IRow)curRow, (String[])ASSQTY_PRECISION_TAB, (int)this.getPrecision(materialId, assUnit), (boolean)this.isNegativeBill, (boolean)true);
            curRow.getCell(TB_ASSISTQTY).getStyleAttributes().setLocked(false);
        } else {
            curRow.getCell(TB_ASSISTQTY).setValue(null);
            curRow.getCell(TB_ASSISTQTY).getStyleAttributes().setLocked(true);
        }
        if (baseUnit != null) {
            SCMClientUtils.changeCellPrecision((IRow)curRow, (String[])BASEQTY_PRECISION_TAB, (int)this.getPrecision(materialId, baseUnit), (boolean)this.isNegativeBill, (boolean)true);
        }
    }

    private void setLocationColProperty(WarehouseInfo warehouseInfo, int rowIndex, boolean isClearLocation) {
        if (isClearLocation) {
            this.kdtEntry.getRow(rowIndex).getCell(this.kdtEntry.getColumnIndex(TB_LOCATION)).setValue(null);
        }
        if (warehouseInfo == null) {
            this.kdtEntry.getRow(rowIndex).getCell(this.kdtEntry.getColumnIndex(TB_LOCATION)).getStyleAttributes().setLocked(true);
            SCMClientUtils.setNecessColorInCells((KDTable)this.kdtEntry, (String)TB_LOCATION, (int)rowIndex, (boolean)false);
            return;
        }
        if (warehouseInfo.isHasLocation()) {
            this.kdtEntry.getRow(rowIndex).getCell(this.kdtEntry.getColumnIndex(TB_LOCATION)).getStyleAttributes().setLocked(false);
            SCMClientUtils.setNecessColorInCells((KDTable)this.kdtEntry, (String)TB_LOCATION, (int)rowIndex, (boolean)true);
            EntityViewInfo viewInfo = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            FilterItemInfo storageFilterItemInfo = new FilterItemInfo("WAREHOUSE.ID", (Object)warehouseInfo.getId().toString());
            filterInfo.getFilterItems().add(storageFilterItemInfo);
            viewInfo.setFilter(filterInfo);
            KDBizPromptBox kDBizPromptBoxLocation = new KDBizPromptBox();
            kDBizPromptBoxLocation.setEditable(true);
            kDBizPromptBoxLocation.setQueryInfo("com.kingdee.eas.basedata.scm.im.inv.app.F7LocationQuery");
            kDBizPromptBoxLocation.setDisplayFormat("$name$");
            kDBizPromptBoxLocation.setEditFormat("$number$");
            kDBizPromptBoxLocation.setCommitFormat("$number$");
            kDBizPromptBoxLocation.setEntityViewInfo(viewInfo);
            this.kdtEntry.getCell(rowIndex, TB_LOCATION).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)kDBizPromptBoxLocation));
            MaterialInfo material = (MaterialInfo)this.kdtEntry.getCell(rowIndex, TB_MATERIAL).getValue();
            StorageOrgUnitInfo storage = (StorageOrgUnitInfo)this.prmtStorageOrgUnit.getValue();
            if (material != null && storage != null) {
                this.kdtEntry.getCell(rowIndex, TB_LOCATION).setValue((Object)InvClientUtils.getDefaultLocation(storage, material, warehouseInfo));
            }
        } else {
            this.kdtEntry.getRow(rowIndex).getCell(this.kdtEntry.getColumnIndex(TB_LOCATION)).getStyleAttributes().setLocked(true);
            SCMClientUtils.setNecessColorInCells((KDTable)this.kdtEntry, (String)TB_LOCATION, (int)rowIndex, (boolean)false);
        }
    }

    private void initEntryUnitCell(int rowIndex, MaterialInfo materialInfo) {
        KDBizPromptBox bizUnitBox = new KDBizPromptBox();
        bizUnitBox.setQueryInfo("com.kingdee.eas.basedata.master.material.app.F7MultiMeasureUnitQuery");
        bizUnitBox.setEditFormat("$number$");
        bizUnitBox.setDisplayFormat("$name$");
        bizUnitBox.setCommitFormat("$number$");
        bizUnitBox.setEditable(true);
        SCMClientUtils.setF7MeasureUnit((KDBizPromptBox)bizUnitBox, (String)materialInfo.getId().toString());
        this.kdtEntry.getRow(rowIndex).getCell(TB_UNIT).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)bizUnitBox));
        bizUnitBox.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                try {
                    SCMClientUtils.setMultiToMeasureUnit((KDBizPromptBox)((KDBizPromptBox)e.getSource()));
                }
                catch (Exception exc) {
                    MoveIssueBillEditUI.this.handUIException(exc);
                }
            }
        });
    }

    private void initHeadControls() throws Exception {
        this.btnQuickAddLine.setEnabled(false);
        this.btnQuickAddLine.setVisible(false);
        this.menuItemQuickAddLine.setEnabled(false);
        this.menuItemQuickAddLine.setVisible(false);
        this.actionQuickAddLine.setEnabled(false);
        if (!this.isBotpBill()) {
            this.prmtTransactionType.setEnabled(false);
        }
        this.kdtEntry.getActionMap().remove("Paste");
        this.btnOffset.setIcon(EASResource.getIcon((String)"imgTbtn_redclash"));
        this.btnQuickAddLine.setIcon(EASResource.getIcon((String)"imgTbtn_newaccountlist"));
        this.txtAddFactCost.setHorizontalAlignment(4);
        this.txtAddStandardCost.setHorizontalAlignment(4);
        this.txtAddStandardCost.setNegatived(false);
        this.txtAddFactCost.setNegatived(false);
        this.txtAddFactCost.setNegatived(false);
        this.txtAddFactCost.setRemoveingZeroInDispaly(false);
        this.txtAddStandardCost.setNegatived(false);
        this.txtAddStandardCost.setRemoveingZeroInDispaly(false);
        this.txtDescription.setMaxLength(255);
        SCMClientUtils.setSotrageOrgF7((KDBizPromptBox)this.prmtMoveInStorageOrgUnit);
        if ("EDIT".equals(this.getOprtState()) || "ADDNEW".equals(this.getOprtState())) {
            if (4 != this.editData.getBaseStatus().getValue()) {
                this.setHeadBizTypeStatus(!this.isBotpBill());
                this.setHeadTransactionTypeStatus();
            } else {
                this.setHeadBizTypeStatus(false);
                this.setHeadTransactionTypeStatus(false);
            }
        } else {
            this.setHeadBizTypeStatus(false);
            this.setHeadTransactionTypeStatus(false);
        }
        this.initActions();
    }

    protected void moveInStoragePreChanged(PreChangeEvent e) {
        try {
            StorageOrgUnitInfo storage = (StorageOrgUnitInfo)e.getData();
            StorageOrgUnitInfo oldStorage = (StorageOrgUnitInfo)e.getOldData();
            if (storage == null && oldStorage == null || storage != null && storage.equals((Object)oldStorage)) {
                return;
            }
            CompanyOrgUnitInfo newCompany = null;
            if (storage != null && (newCompany = InvClientUtils.getCompanyInfo(storage)) == null) {
                MsgBox.showInfo((String)InvClientUtils.getResource("StorageOrgNotHasCompanyOrg"));
                e.setResult(0);
            }
            this.editData.setReceiptCompanyOrgUnit(newCompany);
        }
        catch (Exception e0) {
            this.handUIException(e0);
        }
    }

    private void initBOTPControls() {
        if (this.isBOTP ^ this.inwardBOTP) {
            if (this.isBOTP) {
                this.kdtEntry.getColumn(TB_QTY).getStyleAttributes().setLocked(false);
                this.kdtEntry.getColumn(TB_UNIT).getStyleAttributes().setLocked(false);
                this.kdtEntry.getColumn(TB_STOCKER).getStyleAttributes().setLocked(false);
            }
            this.inwardBOTP = this.isBOTP;
        }
        if (this.isBOTP) {
            this.actionAddLine.setEnabled(false);
            this.actionInsertLine.setEnabled(false);
            this.prmtStorageOrgUnit.setAccessAuthority(1);
            this.prmtStorageOrgUnit.setEnabled(false);
            this.prmtMoveInStorageOrgUnit.setAccessAuthority(1);
            this.prmtMoveInStorageOrgUnit.setEnabled(false);
        }
    }

    private void initSetOffControls() {
        if (this.isReverse ^ this.inwardSetOff) {
            if (this.isReverse) {
                this.prmtTransactionType.setEnabled(false);
                this.prmtStorageOrgUnit.setEnabled(false);
                this.prmtMoveInStorageOrgUnit.setEnabled(false);
                this.bizAdminOrg.setEnabled(false);
                InvClientUtils.setTableLock(this.kdtEntry, new String[]{TB_ASSISTQTY}, true);
                this.kdtEntry.getColumn(TB_QTY).getStyleAttributes().setFontColor(Color.RED);
                this.kdtEntry.getColumn(TB_BASEUNITQTY).getStyleAttributes().setFontColor(Color.RED);
                this.kdtEntry.getColumn(TB_ASSISTQTY).getStyleAttributes().setFontColor(Color.RED);
                this.kdtEntry.getColumn("unVmiSettleBaseQty").getStyleAttributes().setFontColor(Color.RED);
                this.kdtEntry.getColumn("totalVmiSettleBaseQty").getStyleAttributes().setFontColor(Color.RED);
                InvClientUtils.setCellLock(this.kdtEntry, TB_QTY, false);
                InvClientUtils.setCellLock(this.kdtEntry, "remark", false);
            } else {
                this.kdtEntry.getColumn(TB_QTY).getStyleAttributes().setFontColor(Color.BLACK);
                this.kdtEntry.getColumn(TB_BASEUNITQTY).getStyleAttributes().setFontColor(Color.BLACK);
                this.kdtEntry.getColumn(TB_ASSISTQTY).getStyleAttributes().setFontColor(Color.BLACK);
                this.kdtEntry.getColumn("unVmiSettleBaseQty").getStyleAttributes().setFontColor(Color.BLACK);
                this.kdtEntry.getColumn("totalVmiSettleBaseQty").getStyleAttributes().setFontColor(Color.BLACK);
            }
            this.inwardSetOff = this.isReverse;
        }
    }

    private void initIsSetOff() {
        this.isReverse = this.editData.isIsReversed();
        if (this.isReverse) {
            SCMClientUtils.enableComponents((IKDTextComponent[])new IKDTextComponent[]{this.prmtTransactionType, this.prmtStorageOrgUnit, this.prmtMoveInStorageOrgUnit, this.bizAdminOrg}, (boolean)false);
            InvClientUtils.setTableLock(this.kdtEntry, new String[]{TB_QTY, TB_ASSISTQTY, "remark"}, true);
            this.kdtEntry.getColumn(TB_QTY).getStyleAttributes().setFontColor(Color.RED);
            this.kdtEntry.getColumn(TB_BASEUNITQTY).getStyleAttributes().setFontColor(Color.RED);
            this.kdtEntry.getColumn(TB_ASSISTQTY).getStyleAttributes().setFontColor(Color.RED);
            this.kdtEntry.getColumn("unVmiSettleBaseQty").getStyleAttributes().setFontColor(Color.RED);
            this.kdtEntry.getColumn("totalVmiSettleBaseQty").getStyleAttributes().setFontColor(Color.RED);
        } else {
            this.kdtEntry.getColumn(TB_QTY).getStyleAttributes().setFontColor(Color.BLACK);
            this.kdtEntry.getColumn(TB_BASEUNITQTY).getStyleAttributes().setFontColor(Color.BLACK);
            this.kdtEntry.getColumn(TB_ASSISTQTY).getStyleAttributes().setFontColor(Color.BLACK);
            this.kdtEntry.getColumn("unVmiSettleBaseQty").getStyleAttributes().setFontColor(Color.BLACK);
            this.kdtEntry.getColumn("totalVmiSettleBaseQty").getStyleAttributes().setFontColor(Color.BLACK);
        }
    }

    private void initSetOffBtn() {
        if (this.editData.isIsReversed() || this.editData.getId() == null || this.editData.getBaseStatus().getValue() != EntryBaseStatusEnum.AUDITED.getValue()) {
            this.actionOffset.setEnabled(false);
        } else {
            this.actionOffset.setEnabled(true);
            this.btnOffset.setEnabled(true);
        }
        this.btnOffset.setVisible(this.isCanOffSet);
        this.menuItemOffset.setVisible(this.isCanOffSet);
    }

    private void initTableF7() throws Exception {
        ObjectValueRender materialAvr = new ObjectValueRender();
        materialAvr.setFormat((IDataFormat)new BizDataFormat("$number$"));
        this.kdtEntry.getColumn(TB_MATERIAL).setRenderer((IBasicRender)materialAvr);
        ObjectValueRender avrAssPro = new ObjectValueRender();
        avrAssPro.setFormat((IDataFormat)new BizDataFormat("$name$"));
        this.kdtEntry.getColumn(TB_ASSISTANATTR).setRenderer((IBasicRender)avrAssPro);
        this.kdtEntry.getColumn(TB_WAREHOUSE).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)this.getprmtWarehouse()));
        StorageOrgUnitInfo storage = this.editData.getStorageOrgUnit();
        if (storage != null) {
            try {
                this.getprmtWarehouse().setEntityViewInfo(InvClientUtils.getWarehouseFilter(storage));
            }
            catch (Exception ex) {
                this.handUIException(ex);
            }
        }
        KDBizPromptBox kDBizPromptBoxStocker = new KDBizPromptBox();
        kDBizPromptBoxStocker = SCMClientUtils.setStockerF7ByStorageOrg((KDBizPromptBox)kDBizPromptBoxStocker, (CoreUI)this, (String)this.fetchData.getAdminUnitId());
        this.kdtEntry.getColumn(TB_STOCKER).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)kDBizPromptBoxStocker));
        KDBizPromptBox bizAssistantUnitBox = new KDBizPromptBox();
        bizAssistantUnitBox.setEditFormat("$number$");
        bizAssistantUnitBox.setDisplayFormat("$name$");
        bizAssistantUnitBox.setCommitFormat("$number$");
        this.kdtEntry.getColumn(TB_ASSISTANTUNIT).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)bizAssistantUnitBox));
        KDBizPromptBox bizBaseUnitBox = new KDBizPromptBox();
        bizBaseUnitBox.setEditFormat("$number$");
        bizBaseUnitBox.setDisplayFormat("$name$");
        bizBaseUnitBox.setCommitFormat("$number$");
        this.kdtEntry.getColumn(TB_ASSISTANTUNIT).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)bizBaseUnitBox));
        KDDatePicker KDDateEXP = new KDDatePicker();
        this.kdtEntry.getColumn(TB_EXP).setEditor((ICellEditor)new KDTDefaultCellEditor(KDDateEXP));
        SCMClientUtils.setEntriesTableStrLength((KDTable)this.kdtEntry, (String[])new String[]{"remark"}, (int)255);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        Object o = this.bizMaterialNumber.getValue();
        if (o == null) {
            return;
        }
        if (!(o instanceof MaterialInfo[]) && !(o instanceof Object[])) {
            return;
        }
        KDTSelectBlock ksb = this.kdtEntry.getSelectManager().get();
        int beginRow = ksb.getBeginRow();
        MaterialInfo[] materialInfos = null;
        if (o instanceof MaterialInfo[]) {
            materialInfos = (MaterialInfo[])o;
        } else if (o instanceof Object[]) {
            Object[] objects = (Object[])o;
            if (objects.length == 0) {
                return;
            }
            materialInfos = new MaterialInfo[objects.length];
            System.arraycopy(objects, 0, materialInfos, 0, objects.length);
        } else {
            return;
        }
        int length = materialInfos.length;
        if (length > 0) {
            this.bizMaterialNumber.removeChangeListener((ChangeListener)this);
            for (int i = 0; i < length; ++i) {
                if (materialInfos[i] == null) {
                    InvClientUtils.setCellValueNull(this.kdtEntry, null, beginRow + i, true);
                    InvClientUtils.setColLock(this.kdtEntry, LOCKCOLS, beginRow + i, true);
                    return;
                }
                IRow curRow2 = this.kdtEntry.getRow(beginRow + i);
                curRow2.getCell(TB_MATERIAL).setValue(null);
                curRow2.getCell(TB_MATERIAL).setValue((Object)materialInfos[i]);
                InvClientUtils.setCellValueNull(this.kdtEntry, null, beginRow + i, true);
                try {
                    this.materialChange(materialInfos[i], beginRow + i, true);
                }
                catch (Exception e1) {
                    this.handUIException(e1);
                }
                if (i >= length - 1) continue;
                this.insertLine(beginRow + i + 1);
            }
            this.fillLotFrame();
            this.bizMaterialNumber.addChangeListener((ChangeListener)this);
        }
    }

    private void initTableControls() {
        this.kdtEntry.getColumn(TB_MATERIAL).getStyleAttributes().setLocked(true);
        InvClientUtils.setCellLock(this.kdtEntry, TB_MATERIAL, true);
        SCMClientUtils.setNecessColorInTable((KDTable)this.kdtEntry, (String[])NECESSCOLOR_COLUMNS);
    }

    @Override
    protected IObjectValue createNewData() {
        MoveIssueBillAgent billInfo = null;
        try {
            billInfo = MoveIssueBillAgent.create();
            billInfo.setBillType(SCMClientUtils.getBillType((String)"50957179-0105-1000-e000-016ec0a812fd463ED552"));
            billInfo.setCreator(SysContext.getSysContext().getCurrentUserInfo());
            Date date = this.getSCMBizDataVO() != null ? this.getSCMBizDataVO().getCurrentTime() : SCMClientUtils.getServerDate2();
            Calendar cal = Calendar.getInstance();
            cal.setTime(date);
            cal.set(11, 0);
            cal.set(12, 0);
            cal.set(13, 0);
            cal.set(14, 0);
            billInfo.setBizDate(cal.getTime());
            billInfo.setBizDate(SCMClientUtils.getServerDate2());
            billInfo.setCreateTime(SCMClientUtils.getServerDate());
            billInfo.setAuditTime(null);
            billInfo.setBaseStatus(BillBaseStatusEnum.ADD);
            billInfo.setTotalActualCost(InvClientUtils.ZERO);
            billInfo.setTotalStandardCost(InvClientUtils.ZERO);
            billInfo.setFiVouchered(false);
            billInfo.setVoucher(null);
            billInfo.setTotalQty(InvClientUtils.ZERO);
            this.sou = (StorageOrgUnitInfo)this.getDefaultMainBizOrg();
            this.setCouBySou();
            if (this.cou != null) {
                billInfo.setStorageOrgUnit(this.sou);
                billInfo.setIssueCompanyOrgUnit(this.cou);
                billInfo.setReceiptCompanyOrgUnit(this.cou);
            }
            MoveIssueBillEntryInfo entryInfo = null;
            entryInfo = (MoveIssueBillEntryInfo)this.createNewDetailData(this.kdtEntry);
            if (this.cou != null) {
                entryInfo.setStorageOrgUnit(this.sou);
                entryInfo.setCompanyOrgUnit(this.cou);
            }
            billInfo.getEntry().add(entryInfo);
        }
        catch (Exception ex) {
            this.handUIException(ex);
        }
        return billInfo;
    }

    protected IObjectValue createNewDetailData(KDTable table) {
        MoveIssueBillEntryAgent entry = null;
        try {
            entry = MoveIssueBillEntryAgent.create();
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        entry.setReverseQty(InvClientUtils.ZERO);
        entry.setReturnsQty(InvClientUtils.ZERO);
        entry.setAssociateQty(InvClientUtils.ZERO);
        entry.setActualCost(InvClientUtils.ZERO);
        entry.setStandardCost(InvClientUtils.ZERO);
        entry.setTotalInWarehsQty(InvClientUtils.ZERO);
        if (entry.getBaseQty() == null) {
            entry.setBaseQty(InvClientUtils.ZERO);
        }
        if (entry.getQty() == null) {
            entry.setQty(InvClientUtils.ZERO);
        }
        if (entry.getUnitActualCost() == null) {
            entry.setUnitActualCost(InvClientUtils.ZERO);
        }
        if (entry.getAssistQty() == null) {
            entry.setAssistQty(InvClientUtils.ZERO);
        }
        if (this.getDetailTable().getRowCount() > 0 && this.batchCarryWarehouseLocation && !this.isUseWarehsRelation(this.sou)) {
            IRow curRow = this.getDetailTable().getRow(0);
            WarehouseInfo wi = (WarehouseInfo)curRow.getCell(this.getDetailTable().getColumnIndex(TB_WAREHOUSE)).getValue();
            entry.setWarehouse(wi);
            PersonInfo personInfo = (PersonInfo)curRow.getCell(this.getDetailTable().getColumnIndex(TB_STOCKER)).getValue();
            entry.setStocker(personInfo);
        }
        entry.setStorageOrgUnit(this.sou);
        entry.setCompanyOrgUnit(this.cou);
        this.fillCurEntryByFirsrRow(entry, new String[]{this.getCustomerColName(), this.getSupplierColName()});
        return entry;
    }

    @Override
    public void storeFields() {
        this.kdtEntry.getEditManager().stopEditing();
        try {
            this.storeFieldsBefore();
            super.storeFields();
            this.storeFieldsAfter();
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        if (BillBaseStatusEnum.SUBMITED.equals((Object)this.editData.getBaseStatus())) {
            this.initOldData((IObjectValue)this.editData);
        }
        this.editData.setSyncOldValue(true);
        MoveIssueBillEntryInfo entry = null;
        BigDecimal facost = null;
        BigDecimal standardCost = null;
        BigDecimal assQty = null;
        if (this.inwardSetOff) {
            if (this.editData.getTotalStandardCost() != null) {
                this.editData.setTotalStandardCost(this.editData.getTotalStandardCost().negate());
            }
            if (this.editData.getTotalActualCost() != null) {
                this.editData.setTotalActualCost(this.editData.getTotalActualCost().negate());
            }
        }
        MoveIssueBillEntryCollection entrys = this.editData.getEntry();
        int entryCount = entrys.size();
        for (int i = 0; i < entryCount; ++i) {
            entry = entrys.get(i);
            entry.setStorageOrgUnit(this.sou);
            entry.setCompanyOrgUnit(this.cou);
            assQty = entry.getAssistQty();
            if (assQty == null) {
                assQty = InvClientUtils.ZERO;
                entry.setAssistQty(assQty);
            }
            if (this.inwardSetOff) {
                if (entry.getQty() == null) {
                    entry.setQty(InvClientUtils.ZERO);
                } else {
                    entry.setQty(entry.getQty().abs().negate());
                }
                if (entry.getAmount() == null) {
                    entry.setAmount(InvClientUtils.ZERO);
                } else {
                    entry.setAmount(entry.getAmount().abs().negate());
                }
                if (entry.getBaseQty() == null) {
                    entry.setBaseQty(InvClientUtils.ZERO);
                } else {
                    entry.setBaseQty(entry.getBaseQty().abs().negate());
                }
                if (assQty != null) {
                    entry.setAssistQty(assQty.abs().negate());
                }
                if ((standardCost = entry.getStandardCost()) != null) {
                    entry.setStandardCost(standardCost.abs().negate());
                }
                if ((facost = entry.getActualCost()) != null) {
                    entry.setActualCost(facost.abs().negate());
                }
            } else {
                entry.setCanInwarehsBaseQty(entry.getBaseQty());
            }
            if (!this.isNegativeBill) continue;
            entry.setUnitActualCost(entry.getUnitActualCost());
        }
        this.editData.setSyncOldValue(false);
    }

    @Override
    public void onShow() throws Exception {
        this.initOldData((IObjectValue)this.editData);
        super.onShow();
        this.initOldData((IObjectValue)this.editData);
        this.requestFocus4BizType();
    }

    @Override
    public void onLoad() throws Exception {
        String oprState = this.getOprtState();
        if (oprState == null) {
            this.setOprtState("ADDNEW");
            oprState = "ADDNEW";
        }
        this.bizInventory.setEnabledMultiSelection(true);
        super.onLoad();
        this.initHeadControls();
        this.initTableF7();
        this.initTableControls();
        this.initSetOffBtn();
        this.menuItemMultiapprove.setVisible(false);
        this.btnMultiapprove.setVisible(false);
        this.btnSplitOption.setVisible(false);
        if (this.isReverse) {
            this.prmtTransactionType.setEnabled(false);
        }
        this.kdtEntry.getColumn(TB_PROJECTNUM).setEditor(null);
        UIHelper.registerProjectF7((KDBizPromptBox)this.getMainOrgUnit(), (KDBizPromptBox)this.prmtMoveInStorageOrgUnit, (KDTable)this.kdtEntry, (String)TB_PROJECTNUM);
        UIHelper.registerTrackNumberF7((KDBizPromptBox)this.getMainOrgUnit(), (KDBizPromptBox)this.prmtMoveInStorageOrgUnit, (KDTable)this.kdtEntry, (String)TB_PROJECTNUM, (String)TB_TRACKNUM, (boolean)false);
        if (this.getSCMBizDataVO() != null) {
            this.setInvBillOptinStatus();
        }
        this.prmtTransactionType.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
            }
        });
    }

    protected void moveOutStoragePreChanged(PreChangeEvent e) {
        try {
            if ("FINDVIEW".equals(this.getOprtState()) || "VIEW".equals(this.getOprtState())) {
                return;
            }
            if (e.getData() != null && e.getData().equals(e.getOldData())) {
                return;
            }
            if (e.getData() != null && e.getOldData() != null) {
                StorageOrgUnitInfo soNew = (StorageOrgUnitInfo)e.getData();
                StorageOrgUnitInfo soOld = (StorageOrgUnitInfo)e.getOldData();
                if (soNew.getId().equals((Object)soOld.getId())) {
                    return;
                }
            }
            this.sou = InvClientUtils.getStorageOrgUnitInfo(e);
            if (this.sou != null) {
                CompanyOrgUnitInfo couNew = null;
                if (this.sou != null) {
                    couNew = this.getCouBySou(this.sou);
                }
                if (couNew == null) {
                    MsgBox.showInfo((String)InvClientUtils.getResource("StorageOrgNotHasCompanyOrg"));
                    e.setResult(0);
                } else {
                    if (!this.checkEntryIsBlank() && !this.isMoveBill) {
                        String strTemp = InvClientUtils.getResource("CLEARENTRYAFTERORGCHANGED");
                        int ret = MsgBox.showConfirm2((String)strTemp);
                        if (ret == 2) {
                            e.setResult(0);
                            return;
                        }
                        this.kdtEntry.removeRows();
                        this.addLine(this.kdtEntry);
                        this.getDetailTable().getSelectManager().select(0, 0);
                    }
                    this.cou = couNew;
                    if (this.cou.getBaseCurrency() != null && this.cou.getBaseCurrency().getName() == null) {
                        SelectorItemCollection sic = new SelectorItemCollection();
                        sic.add(new SelectorItemInfo("id"));
                        sic.add(new SelectorItemInfo("number"));
                        sic.add(new SelectorItemInfo("name"));
                        sic.add(new SelectorItemInfo("precision"));
                        this.cou.setBaseCurrency(CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)new ObjectUuidPK(this.cou.getBaseCurrency().getId()), sic));
                        this.localAmtPrecision = this.cou.getBaseCurrency().getPrecision();
                    }
                    if (this.cou != null) {
                        SCMClientUtils.changeTableColPrecisionByCurrency((CurrencyInfo)this.cou.getBaseCurrency(), (KDTable)this.getDetailTable(), (String[])CURRENCYPRECISIONTAB);
                    }
                    KDBizPromptBox kDBizPromptBoxStocker = new KDBizPromptBox();
                    kDBizPromptBoxStocker = SCMF7ContextUtils.setStockerF7ByStorageOrg((KDBizPromptBox)kDBizPromptBoxStocker, (StorageOrgUnitInfo)this.sou, (CoreUI)this);
                    this.kdtEntry.getColumn(TB_STOCKER).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)kDBizPromptBoxStocker));
                    this.editData.setIssueCompanyOrgUnit(couNew);
                    try {
                        this.getprmtWarehouse().setEntityViewInfo(InvClientUtils.getWarehouseFilter(this.sou));
                    }
                    catch (Exception ex) {
                        this.handUIException(ex);
                    }
                    this.bizAdminOrg.setData(null);
                    this.kdtEntry.getColumn(TB_MATERIAL).getStyleAttributes().setLocked(true);
                    int count = this.kdtEntry.getRowCount();
                    for (int i = 0; i < count; ++i) {
                        this.kdtEntry.getCell(i, this.kdtEntry.getColumnIndex(TB_PROJECTNUM)).setValue(null);
                        this.kdtEntry.getCell(i, this.kdtEntry.getColumnIndex(TB_TRACKNUM)).setValue(null);
                    }
                }
            } else {
                if (!this.checkEntryIsBlank()) {
                    String strTemp = InvClientUtils.getResource("CLEARENTRYAFTERORGCHANGED");
                    int ret = MsgBox.showConfirm2((String)strTemp);
                    if (ret == 2) {
                        e.setResult(0);
                        return;
                    }
                    this.kdtEntry.removeRows();
                    this.addLine(this.kdtEntry);
                    this.getDetailTable().getSelectManager().select(0, 0);
                }
                this.kdtEntry.getColumn(TB_MATERIAL).getStyleAttributes().setLocked(true);
            }
            this.getCostCenter().setValue(null);
        }
        catch (Exception ex) {
            this.handUIException(ex);
        }
    }

    private boolean checkEntryIsBlank() {
        int rows = this.kdtEntry.getRowCount();
        if (rows > 0) {
            for (int i = 0; i < rows; ++i) {
                if (this.kdtEntry.getCell(i, TB_MATERIAL).getValue() == null) continue;
                return false;
            }
            return true;
        }
        return true;
    }

    @Override
    protected void setFieldsNull(AbstractObjectValue newData) {
        super.setFieldsNull(newData);
        MoveIssueBillInfo aMoveIssueBillInfo = (MoveIssueBillInfo)newData;
        aMoveIssueBillInfo.setFiVouchered(false);
        aMoveIssueBillInfo.setVoucher(null);
        aMoveIssueBillInfo.setIsReversed(false);
        aMoveIssueBillInfo.setSourceBillId(null);
        aMoveIssueBillInfo.setSourceBillType(null);
        BigDecimal ZERO = new BigDecimal("0.00");
        try {
            if (aMoveIssueBillInfo.getEntry() != null) {
                MoveIssueBillEntryCollection coll = aMoveIssueBillInfo.getEntry();
                for (int i = 0; i < coll.size(); ++i) {
                    MoveIssueBillEntryInfo entryInfo = coll.get(i);
                    entryInfo.setReturnsQty(ZERO);
                    entryInfo.setReverseQty(ZERO);
                    entryInfo.setReturnBaseQty(ZERO);
                    entryInfo.setReverseBaseQty(ZERO);
                    if (entryInfo.getTotalInWarehsQty() == null) {
                        entryInfo.setTotalInWarehsQty(ZERO);
                    }
                    entryInfo.setTotalInWarehsQty(ZERO);
                    entryInfo.setCanInwarehsBaseQty(ZERO);
                    BigDecimal qty = entryInfo.getQty();
                    if (qty == null) {
                        qty = ZERO;
                    }
                    super.initEntryCost4Botp(entryInfo, this.localAmtPrecision);
                }
            }
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    public void actionQueryByMaterial_actionPerformed(ActionEvent e) throws Exception {
        super.actionQueryByMaterial_actionPerformed(e);
    }

    @Override
    protected KDTable getDetailTable() {
        return this.kdtEntry;
    }

    protected void tableValueChanged(KDTEditEvent e) throws Exception {
        int colIsPresent;
        WarehouseInfo tempWI;
        IRow iRow;
        WarehouseInfo wi;
        if (e.getValue() != null && e.getValue().equals(e.getOldValue()) || e.getValue() == null && e.getOldValue() == null) {
            return;
        }
        int rowIndex = e.getRowIndex();
        int colIndex = e.getColIndex();
        int colLot = this.kdtEntry.getColumnIndex(TB_BATCH);
        IRow curRow = this.kdtEntry.getRow(rowIndex);
        int materialCol = this.kdtEntry.getColumnIndex(TB_MATERIAL);
        int qtyCol = this.kdtEntry.getColumnIndex(TB_QTY);
        int warehsCol = this.kdtEntry.getColumnIndex(TB_WAREHOUSE);
        int colStocker = this.kdtEntry.getColumnIndex(TB_STOCKER);
        int colLocation = this.getDetailTable().getColumnIndex(TB_LOCATION);
        int unitCol = this.kdtEntry.getColumnIndex(TB_UNIT);
        int colFactCost = this.kdtEntry.getColumnIndex(TB_FACTCOST);
        int colUnitFactCost = this.kdtEntry.getColumnIndex(TB_UNITFACTCOST);
        int colUnitPrice = this.kdtEntry.getColumnIndex(TB_PRICE);
        int colAmount = this.kdtEntry.getColumnIndex(TB_AMOUNT);
        this.fillAllEntriesByFirstRow(e.getValue(), this.getDetailTable().getColumnKey(e.getColIndex()), e.getRowIndex());
        KDTable kDTable = (KDTable)e.getSource();
        String colName = kDTable.getColumnKey(e.getColIndex());
        if (TB_PROJECTNUM.equals(colName) && e.getValue() != null && !e.getValue().equals(e.getOldValue())) {
            this.kdtEntry.getCell(rowIndex, this.kdtEntry.getColumnIndex(TB_TRACKNUM)).setValue(null);
            UIHelper.registerTrackNumberF7((KDBizPromptBox)this.getMainOrgUnit(), (KDBizPromptBox)this.prmtMoveInStorageOrgUnit, (KDTable)this.kdtEntry, (String)TB_PROJECTNUM, (String)TB_TRACKNUM, (boolean)false);
        }
        Object temp = this.kdtEntry.getCell(rowIndex, materialCol).getValue();
        MaterialInfo material = null;
        if (!(temp instanceof MaterialInfo)) {
            return;
        }
        material = (MaterialInfo)temp;
        if (colIndex == materialCol && (material == null || material instanceof MaterialInfo)) {
            InvClientUtils.setCellValueNull(this.kdtEntry, null, rowIndex, true);
            if (material == null) {
                InvClientUtils.setColLock(this.kdtEntry, LOCKCOLS, rowIndex, true);
                return;
            }
            InvClientUtils.setColLock(this.kdtEntry, LOCKCOLS, rowIndex, false);
            this.materialChange(material, rowIndex, true);
        }
        if (colAmount == colIndex) {
            BigDecimal amount = (BigDecimal)kDTable.getCell(rowIndex, TB_AMOUNT).getValue();
            BigDecimal qty = (BigDecimal)kDTable.getRow(rowIndex).getCell(TB_QTY).getValue();
            if (qty == null || amount == null || qty.compareTo(InvClientUtils.ZERO) == 0) {
                kDTable.getCell(rowIndex, TB_PRICE).setValue((Object)InvClientUtils.ZERO);
            } else {
                MaterialInfo materialInfo = (MaterialInfo)kDTable.getCell(rowIndex, TB_MATERIAL).getValue();
                if (materialInfo != null) {
                    BigDecimal price = amount.divide(qty, materialInfo.getPricePrecision(), 4);
                    kDTable.getCell(rowIndex, TB_PRICE).setValue((Object)price);
                }
            }
        }
        if (colIndex == colUnitPrice || colIndex == qtyCol) {
            BigDecimal qty = InvClientUtils.ZERO;
            BigDecimal price = InvClientUtils.ZERO;
            String str = null;
            Object o = kDTable.getRow(rowIndex).getCell(TB_QTY).getValue();
            if (o != null && (str = o.toString()) != null && StringUtil.isNumber((String)str)) {
                qty = new BigDecimal(str);
            }
            if ((o = kDTable.getRow(rowIndex).getCell(TB_PRICE).getValue()) != null && (str = o.toString()) != null && StringUtil.isNumber((String)str)) {
                price = new BigDecimal(str);
            }
            BigDecimal amount = qty.multiply(price);
            amount = amount.setScale(this.localAmtPrecision, 4);
            kDTable.getRow(rowIndex).getCell(TB_AMOUNT).setValue((Object)amount);
        }
        TransactionTypeInfo tti = this.editData.getTransactionType();
        boolean isReversed = this.editData.isIsReversed();
        if (colIndex == colLot) {
            if (curRow.getCell(colLot).getValue() != null) {
                String lot = curRow.getCell(colLot).getValue().toString();
                InvClientUtils.setLotInfo(this.kdtEntry, rowIndex, this.editData.getStorageOrgUnit(), material, lot, this.editData);
                InvClientUtils.checkEXP(kDTable, rowIndex, tti, isReversed, this.sou, material, this.editData);
            } else {
                this.kdtEntry.getCell(rowIndex, TB_MFG).setValue(null);
                this.kdtEntry.getCell(rowIndex, TB_EXP).setValue(null);
            }
        }
        if (colIndex == qtyCol) {
            this.qtyChanged(rowIndex);
        }
        if (colIndex == colFactCost) {
            this.calEntryUnitActualCostByTotal(rowIndex);
        }
        if (colIndex == colUnitFactCost) {
            this.calEntryActualCostByUnitCost(rowIndex, this.localAmtPrecision);
        }
        if (colIndex == warehsCol) {
            WarehouseInfo warehouse = (WarehouseInfo)this.kdtEntry.getCell(rowIndex, colIndex).getValue();
            boolean isUseWarehsRelation = this.isUseWarehsRelation(this.sou);
            if (isUseWarehsRelation) {
                InvClientUtils.setLocationFilterByMSRelation((CoreUIObject)this, this.sou, warehouse, material, this.fetchData, this.getDetailTable(), rowIndex, false);
            } else {
                this.setLocationColProperty(warehouse, rowIndex, true);
            }
            if (warehouse != null) {
                if ("ADDNEW".equals(this.getOprtState()) || "EDIT".equals(this.getOprtState())) {
                    PersonInfo stocker;
                    if (warehouse.getWhman() == null || warehouse.getWhman().getName() == null) {
                        if (this.fetchData.getDefaultStocker(warehouse.getId().toString()) == null) {
                            ObjectUuidPK pk = new ObjectUuidPK(warehouse.getId());
                            IWarehouse iWarehouse = WarehouseFactory.getRemoteInstance();
                            SelectorItemCollection sc = new SelectorItemCollection();
                            sc.add(new SelectorItemInfo("id"));
                            sc.add(new SelectorItemInfo("number"));
                            sc.add(new SelectorItemInfo("name"));
                            sc.add(new SelectorItemInfo("hasLocation"));
                            sc.add(new SelectorItemInfo("whman.id"));
                            sc.add(new SelectorItemInfo("whman.number"));
                            sc.add(new SelectorItemInfo("whman.name"));
                            warehouse = iWarehouse.getWarehouseInfo((IObjectPK)pk, sc);
                            stocker = warehouse.getWhman();
                            this.fetchData.putDefaultStocker(warehouse.getId().toString(), stocker);
                        } else {
                            stocker = this.fetchData.getDefaultStocker(warehouse.getId().toString());
                        }
                    } else {
                        stocker = warehouse.getWhman();
                    }
                    if (this.isActionF12 && curRow.getCell(TB_STOCKER).getValue() == null || !this.isActionF12) {
                        curRow.getCell(this.getDetailTable().getColumnIndex(TB_STOCKER)).setValue((Object)stocker);
                    }
                    if (this.batchCarryWarehouseLocation && rowIndex == 0) {
                        int rowCount = this.getDetailTable().getRowCount();
                        IRow iRow2 = null;
                        WarehouseInfo tempWI2 = null;
                        MaterialInfo tempMi = null;
                        boolean isCopy = false;
                        for (int i = 1; i < rowCount; ++i) {
                            iRow2 = this.getDetailTable().getRow(i);
                            tempWI2 = (WarehouseInfo)iRow2.getCell(TB_WAREHOUSE).getValue();
                            tempMi = (MaterialInfo)iRow2.getCell(TB_MATERIAL).getValue();
                            isCopy = false;
                            if (tempWI2 == null && tempMi != null) {
                                isCopy = true;
                                if (isUseWarehsRelation && !tempMi.getId().equals((Object)material.getId())) {
                                    isCopy = false;
                                }
                            }
                            if (!isCopy) continue;
                            iRow2.getCell(TB_WAREHOUSE).setValue((Object)warehouse);
                            iRow2.getCell(TB_STOCKER).setValue((Object)stocker);
                            if (isUseWarehsRelation) {
                                InvClientUtils.setLocationFilterByMSRelation((CoreUIObject)this, this.sou, warehouse, tempMi, this.fetchData, this.getDetailTable(), i, false);
                                continue;
                            }
                            InvClientUtils.setLocationFilter((CoreUIObject)this, this.sou, warehouse, tempMi, this.fetchData, this.getDetailTable(), i, false);
                        }
                    }
                }
            } else {
                curRow.getCell(TB_STOCKER).setValue(null);
            }
        }
        if (colIndex == colStocker && ("ADDNEW".equals(this.getOprtState()) || "EDIT".equals(this.getOprtState()))) {
            wi = (WarehouseInfo)curRow.getCell(warehsCol).getValue();
            PersonInfo aPersonInfo = (PersonInfo)curRow.getCell(colStocker).getValue();
            if (wi != null && aPersonInfo != null && rowIndex == 0) {
                int rowCount = this.getDetailTable().getRowCount();
                iRow = null;
                tempWI = null;
                PersonInfo tempPs = null;
                for (int i = 1; i < rowCount; ++i) {
                    iRow = this.getDetailTable().getRow(i);
                    tempWI = (WarehouseInfo)iRow.getCell(warehsCol).getValue();
                    tempPs = (PersonInfo)iRow.getCell(colStocker).getValue();
                    if (tempWI == null || tempPs != null || !tempWI.getId().toString().equals(wi.getId().toString())) continue;
                    iRow.getCell(colStocker).setValue((Object)aPersonInfo);
                }
            }
        }
        if (colIndex == colLocation) {
            wi = (WarehouseInfo)curRow.getCell(TB_WAREHOUSE).getValue();
            LocationInfo aLocationInfo = (LocationInfo)curRow.getCell(TB_LOCATION).getValue();
            if (this.batchCarryWarehouseLocation && rowIndex == 0 && wi != null) {
                int rowCount = this.getDetailTable().getRowCount();
                iRow = null;
                tempWI = null;
                MaterialInfo tempMi = null;
                boolean isUseWarehsRelation = this.isUseWarehsRelation(this.sou);
                for (int i = 1; i < rowCount; ++i) {
                    iRow = this.getDetailTable().getRow(i);
                    tempWI = (WarehouseInfo)iRow.getCell(TB_WAREHOUSE).getValue();
                    tempMi = (MaterialInfo)iRow.getCell(TB_MATERIAL).getValue();
                    if (isUseWarehsRelation) {
                        if (tempWI == null || !tempWI.getId().equals((Object)wi.getId()) || tempMi == null || !tempMi.getId().equals((Object)material.getId()) || iRow.getCell(TB_LOCATION).getValue() != null) continue;
                        iRow.getCell(TB_LOCATION).setValue((Object)aLocationInfo);
                        continue;
                    }
                    if (tempWI == null || !tempWI.getId().equals((Object)wi.getId()) || iRow.getCell(TB_LOCATION).getValue() != null) continue;
                    iRow.getCell(TB_LOCATION).setValue((Object)aLocationInfo);
                }
            }
        }
        if (colIndex == unitCol) {
            this.unitChanged(rowIndex);
        }
        if (colIndex == (colIsPresent = this.kdtEntry.getColumnIndex(TB_ISPRESENT))) {
            this.calEntryCost4IsPresentChanged(rowIndex, this.localAmtPrecision);
        }
        if (!(colIndex != this.kdtEntry.getColumnIndex(TB_MATERIAL) && colIndex != this.kdtEntry.getColumnIndex(TB_UNIT) && colIndex != this.kdtEntry.getColumnIndex(TB_ASSISTANATTR) && colIndex != this.kdtEntry.getColumnIndex(TB_BATCH) && colIndex != this.kdtEntry.getColumnIndex(TB_WAREHOUSE) && colIndex != this.kdtEntry.getColumnIndex(TB_LOCATION) || this.isActionF12)) {
            this.checkDupRecord(rowIndex, colIndex);
        }
        this.setQtyBaseQtyAssisQty(this.getDetailTable(), rowIndex, colIndex);
    }

    protected Vector getCheckDupFileds() {
        Vector<String> vct = new Vector<String>();
        vct.add(TB_MATERIAL);
        vct.add(TB_UNIT);
        vct.add(TB_ASSISTANATTR);
        vct.add(TB_BATCH);
        vct.add(TB_WAREHOUSE);
        vct.add(TB_LOCATION);
        vct.add(TB_STOCKTRANSFERBILLNUM);
        vct.add(TB_STOCKTRANSFERBILLSEQ);
        return vct;
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return MoveIssueBillFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext());
    }

    @Override
    protected void beforeStoreFields(ActionEvent e) throws Exception {
        super.beforeStoreFields(e);
        String strTemp = "";
        int errorCount = 0;
        StringBuffer error = new StringBuffer();
        int entryCount = this.kdtEntry.getRowCount();
        StringBuffer sbSN = new StringBuffer();
        if (entryCount == 0) {
            strTemp = InvClientUtils.getResource("EntryIsNull");
            this.showError(strTemp);
        }
        Date bizDate = (Date)this.pkBizDate.getValue();
        this.editData.setBizDate(bizDate);
        String[] checkCols = new String[]{TB_MATERIAL};
        if (e != null && e.getSource() != null && (e.getSource() == this.btnSave || e.getSource() == this.menuItemSave)) {
            int rowCount = this.getDetailTable().getRowCount();
            for (int i = 0; i < rowCount; ++i) {
                if (!InvClientUtils.isRowBlankOnTable(this.getDetailTable(), i, checkCols)) continue;
                this.removeLine(this.getDetailTable(), i);
                --i;
                --rowCount;
            }
            if (rowCount == 0) {
                this.addLine(this.getDetailTable());
            }
        } else {
            if (this.editData.isIsReversed()) {
                IMoveIssueBillEntry iMoveIssueEntry = MoveIssueBillEntryFactory.getRemoteInstance();
                MoveIssueBillEntryInfo sourceEntry = null;
                BigDecimal canConterial = null;
                MoveIssueBillEntryInfo entry = null;
                BigDecimal qty = null;
                BigDecimal sourceQty = null;
                BigDecimal sourceCountervail = null;
                KDFormattedTextField ktf = null;
                for (int i = 0; i < entryCount; ++i) {
                    if (InvClientUtils.isRowBlankOnTable(this.kdtEntry, i, checkCols)) {
                        this.removeLine(this.kdtEntry, i);
                        --i;
                        --entryCount;
                        continue;
                    }
                    qty = (BigDecimal)this.kdtEntry.getCell(i, TB_QTY).getValue();
                    if (qty == null || qty.compareTo(InvClientUtils.ZERO) <= 0) {
                        this.verifyQtyZero(strTemp, errorCount, error, i);
                    } else {
                        entry = (MoveIssueBillEntryInfo)this.kdtEntry.getRow(i).getUserObject();
                        if (entry == null || entry.getSourceBillEntryId() == null) {
                            this.removeLine(this.kdtEntry, i);
                            --i;
                            --entryCount;
                            continue;
                        }
                        SelectorItemCollection sic = new SelectorItemCollection();
                        sic.add(new SelectorItemInfo(TB_QTY));
                        sic.add(new SelectorItemInfo("reverseQty"));
                        sourceEntry = iMoveIssueEntry.getMoveIssueBillEntryInfo((IObjectPK)new ObjectUuidPK(entry.getSourceBillEntryId()), sic);
                        sourceQty = sourceEntry.getQty();
                        sourceCountervail = sourceEntry.getReverseQty();
                        canConterial = sourceCountervail == null ? sourceQty : sourceQty.subtract(sourceCountervail);
                        ktf = (KDFormattedTextField)this.kdtEntry.getCell(i, TB_QTY).getEditor().getComponent();
                        canConterial = canConterial.setScale(ktf.getPrecision(), 4);
                        if (qty.compareTo(canConterial) > 0) {
                            StringBuffer sb = new StringBuffer();
                            String realCountervailStr = NumericUtil.getDecimalFormatString((BigDecimal)canConterial, (int)qty.scale());
                            sb.append(ResourceUtil.getMessage((String)this.invAddResource, (String)"OffSetQtyGreaterThanOld", (String[])new String[]{String.valueOf(i + 1), realCountervailStr}));
                            errorCount = this.buildErrorString(error, sb.toString(), i, errorCount, TB_QTY);
                        }
                    }
                    MaterialInfo material = (MaterialInfo)this.kdtEntry.getCell(i, TB_MATERIAL).getValue();
                    MeasureUnitInfo unit = (MeasureUnitInfo)this.kdtEntry.getCell(i, TB_UNIT).getValue();
                    Object isSerialNumber = this.getDetailTable().getRow(i).getCell("isSerialNumber").getValue();
                    if (!this.isNeedCheckSN(i) || isSerialNumber == null || !new Boolean(isSerialNumber.toString()).booleanValue() || material == null || material.getSeqUnit() == null || unit == null || !unit.getId().equals((Object)material.getSeqUnit().getId())) continue;
                    EntityViewInfo ev = new EntityViewInfo();
                    FilterInfo filter = new FilterInfo();
                    boolean isSaveSN = false;
                    if (material == null || material.getId() == null) continue;
                    MoveIssueBillEntryInfo entryInfo = (MoveIssueBillEntryInfo)this.getDetailTable().getRow(i).getUserObject();
                    if (this.editData.getId() != null && entryInfo.getId() != null) {
                        String billID = this.editData.getId().toString();
                        filter.getFilterItems().add(new FilterItemInfo("billID", (Object)billID));
                        filter.getFilterItems().add(new FilterItemInfo("billEntryID", (Object)entryInfo.getId().toString().trim()));
                        filter.getFilterItems().add(new FilterItemInfo("material", (Object)material.getId().toString()));
                        filter.getFilterItems().add(new FilterItemInfo("snQty", (Object)entryInfo.getQty(), CompareType.GREATER_EQUALS));
                        ev.setFilter(filter);
                        ev.getSelector().add(new SelectorItemInfo("id"));
                        ev.getSelector().add(new SelectorItemInfo("entry.id"));
                        ev.getSorter().add(new SorterItemInfo("entry.seq"));
                        IMaterialSerialNumber iMaterialSerialNumber = MaterialSerialNumberFactory.getRemoteInstance();
                        MaterialSerialNumberCollection snColl = iMaterialSerialNumber.getMaterialSerialNumberCollection(ev);
                        isSaveSN = snColl != null && snColl.size() != 0;
                    }
                    if (this.editData.get("ImportSN") != null) {
                        Hashtable htSN = (Hashtable)this.editData.get("ImportSN");
                        String lot = (String)this.getDetailTable().getCell(i, TB_BATCH).getValue();
                        if (lot != null && lot.length() > 0) {
                            String key = lot.trim() + material.getId();
                            isSaveSN = htSN.get(key) != null;
                        }
                    }
                    if (isSaveSN) continue;
                    strTemp = ResourceUtil.getMessage((String)this.invAddResource, (String)"SerialNumberNotInput", (String[])new String[]{String.valueOf(i + 1)});
                    sbSN.append(strTemp + '\n');
                    this.getDetailTable().requestFocus();
                    this.getDetailTable().getEditManager().editCellAt(i, 0);
                }
            } else {
                TransactionTypeInfo transaction;
                StorageOrgUnitInfo storageIn;
                StorageOrgUnitInfo storage = (StorageOrgUnitInfo)this.prmtStorageOrgUnit.getData();
                if (storage == null) {
                    strTemp = InvClientUtils.getResource("TransOutStorageNotNull");
                    this.showError(strTemp, (JComponent)this.prmtStorageOrgUnit);
                }
                if ((storageIn = (StorageOrgUnitInfo)this.prmtMoveInStorageOrgUnit.getData()) == null) {
                    strTemp = InvClientUtils.getResource("TransInStorageNotNull");
                    this.showError(strTemp, (JComponent)this.prmtMoveInStorageOrgUnit);
                }
                if (this.pkBizDate.getValue() == null) {
                    strTemp = InvClientUtils.getResource("bizDateIsNull");
                    this.showError(strTemp, (JComponent)this.pkBizDate);
                }
                if ((transaction = (TransactionTypeInfo)this.prmtTransactionType.getValue()) != null) {
                    String bizTypeId = this.getBizTypeId();
                    if (bizTypeId != null && ("d8e80652-0118-1000-e000-04c5c0a812202407435C".equals(bizTypeId) || "d8e80652-011a-1000-e000-04c5c0a812202407435C".equals(bizTypeId))) {
                        if (storage.equals((Object)storageIn)) {
                            strTemp = InvClientUtils.getResource("MoveInComStorageEqual");
                            this.showError(strTemp, (JComponent)this.prmtTransactionType);
                        } else if (!this.editData.getIssueCompanyOrgUnit().equals((Object)this.editData.getReceiptCompanyOrgUnit())) {
                            strTemp = InvClientUtils.getResource("MoveInComDiffCom");
                            this.showError(strTemp, (JComponent)this.prmtTransactionType);
                        }
                    } else if (bizTypeId != null && ("d8e80652-0119-1000-e000-04c5c0a812202407435C".equals(bizTypeId) || "d8e80652-011b-1000-e000-04c5c0a812202407435C".equals(bizTypeId)) && !storage.getId().equals((Object)storageIn.getId())) {
                        strTemp = InvClientUtils.getResource("MoveInStorageNotEqual");
                        this.showError(strTemp, (JComponent)this.prmtTransactionType);
                    }
                }
                AsstAttrValueInfo asst = null;
                MeasureUnitInfo unit = null;
                MaterialInfo material = null;
                MaterialInventoryInfo materialInvInfo = null;
                BigDecimal qty = null;
                WarehouseInfo ware = null;
                LocationInfo location = null;
                for (int i = 0; i < entryCount; ++i) {
                    if (InvClientUtils.isRowBlankOnTable(this.getDetailTable(), i, checkCols)) {
                        this.removeLine(this.getDetailTable(), i);
                        --i;
                        --entryCount;
                        continue;
                    }
                    material = (MaterialInfo)this.kdtEntry.getCell(i, TB_MATERIAL).getValue();
                    if (material == null || material.getId() == null) {
                        strTemp = this.getDetailTable().getHeadRow(0).getCell(TB_MATERIAL).getValue().toString();
                        strTemp = ResourceUtil.getMessage((String)this.invAddResource, (String)"FieldCannotBeBlank", (String[])new String[]{String.valueOf(i + 1), strTemp});
                        errorCount = this.buildErrorString(error, strTemp, i, errorCount, TB_MATERIAL);
                    } else {
                        boolean isPeriodVaild;
                        Object tempBatch;
                        materialInvInfo = MaterialInventoryFactory.getRemoteInstance().getInventoryInfo(material.getId().toString(), storage.getId().toString());
                        if (materialInvInfo != null && materialInvInfo.isIsLotNumber() && ((tempBatch = this.kdtEntry.getCell(i, TB_BATCH).getValue()) == null || tempBatch.toString().trim().length() == 0)) {
                            strTemp = this.getDetailTable().getHeadRow(0).getCell(TB_BATCH).getValue().toString();
                            strTemp = ResourceUtil.getMessage((String)this.invAddResource, (String)"FieldCannotBeBlank", (String[])new String[]{String.valueOf(i + 1), strTemp});
                            errorCount = this.buildErrorString(error, strTemp, i, errorCount, TB_BATCH);
                        }
                        boolean bl = isPeriodVaild = this.kdtEntry.getRow(i).getCell(this.kdtEntry.getColumnIndex("periodValidUnit")).getValue() != null;
                        if (isPeriodVaild && (this.kdtEntry.getRow(i).getCell(TB_MFG).getValue() == null || this.kdtEntry.getRow(i).getCell(TB_EXP).getValue() == null)) {
                            strTemp = ResourceUtil.getMessage((String)this.invAddResource, (String)"EXPMFGISNULL", (String[])new String[]{String.valueOf(i + 1)});
                            errorCount = this.kdtEntry.getRow(i).getCell(TB_MFG).getValue() == null ? this.buildErrorString(error, strTemp, i, errorCount, TB_MFG) : this.buildErrorString(error, strTemp, i, errorCount, TB_EXP);
                        }
                        if ((asst = (AsstAttrValueInfo)this.kdtEntry.getCell(i, TB_ASSISTANATTR).getValue()) == null && material.getAssistAttr() != null) {
                            strTemp = this.getDetailTable().getHeadRow(0).getCell(TB_ASSISTANATTR).getValue().toString();
                            strTemp = ResourceUtil.getMessage((String)this.invAddResource, (String)"FieldCannotBeBlank", (String[])new String[]{String.valueOf(i + 1), strTemp});
                            errorCount = this.buildErrorString(error, strTemp, i, errorCount, TB_ASSISTANATTR);
                        }
                    }
                    unit = (MeasureUnitInfo)this.kdtEntry.getCell(i, TB_UNIT).getValue();
                    if (unit == null || unit.getId() == null) {
                        strTemp = this.getDetailTable().getHeadRow(0).getCell(TB_UNIT).getValue().toString();
                        strTemp = ResourceUtil.getMessage((String)this.invAddResource, (String)"FieldCannotBeBlank", (String[])new String[]{String.valueOf(i + 1), strTemp});
                        errorCount = this.buildErrorString(error, strTemp, i, errorCount, TB_UNIT);
                    }
                    if ((qty = (BigDecimal)this.kdtEntry.getCell(i, TB_QTY).getValue()) == null || qty.compareTo(InvClientUtils.ZERO) == 0) {
                        strTemp = this.getDetailTable().getHeadRow(0).getCell(TB_QTY).getValue().toString();
                        strTemp = ResourceUtil.getMessage((String)this.invAddResource, (String)"FieldCannotBeBlank", (String[])new String[]{String.valueOf(i + 1), strTemp});
                        errorCount = this.buildErrorString(error, strTemp, i, errorCount, TB_QTY);
                    }
                    if ((ware = (WarehouseInfo)this.kdtEntry.getCell(i, TB_WAREHOUSE).getValue()) == null || ware.getId() == null) {
                        strTemp = this.getDetailTable().getHeadRow(0).getCell(TB_WAREHOUSE).getValue().toString();
                        strTemp = ResourceUtil.getMessage((String)this.invAddResource, (String)"FieldCannotBeBlank", (String[])new String[]{String.valueOf(i + 1), strTemp});
                        errorCount = this.buildErrorString(error, strTemp, i, errorCount, TB_WAREHOUSE);
                    }
                    location = (LocationInfo)this.kdtEntry.getCell(i, TB_LOCATION).getValue();
                    if (ware != null && ware.isHasLocation() && location == null) {
                        strTemp = this.getDetailTable().getHeadRow(0).getCell(TB_LOCATION).getValue().toString();
                        strTemp = ResourceUtil.getMessage((String)this.invAddResource, (String)"FieldCannotBeBlank", (String[])new String[]{String.valueOf(i + 1), strTemp});
                        errorCount = this.buildErrorString(error, strTemp, i, errorCount, TB_LOCATION);
                    }
                    Object isSerialNumber = this.getDetailTable().getRow(i).getCell("isSerialNumber").getValue();
                    if (!this.isNeedCheckSN(i) || isSerialNumber == null || !new Boolean(isSerialNumber.toString()).booleanValue() || material == null || material.getSeqUnit() == null || unit == null || !unit.getId().equals((Object)material.getSeqUnit().getId())) continue;
                    EntityViewInfo ev = new EntityViewInfo();
                    FilterInfo filter = new FilterInfo();
                    boolean isSaveSN = false;
                    if (material == null || material.getId() == null) continue;
                    MoveIssueBillEntryInfo entryInfo = (MoveIssueBillEntryInfo)this.getDetailTable().getRow(i).getUserObject();
                    if (this.editData.getId() != null && entryInfo.getId() != null) {
                        String billID = this.editData.getId().toString();
                        filter.getFilterItems().add(new FilterItemInfo("billID", (Object)billID));
                        filter.getFilterItems().add(new FilterItemInfo("billEntryID", (Object)entryInfo.getId().toString().trim()));
                        filter.getFilterItems().add(new FilterItemInfo("material", (Object)material.getId().toString()));
                        filter.getFilterItems().add(new FilterItemInfo("snQty", (Object)entryInfo.getQty(), CompareType.GREATER_EQUALS));
                        ev.setFilter(filter);
                        ev.getSelector().add(new SelectorItemInfo("id"));
                        ev.getSelector().add(new SelectorItemInfo("entry.id"));
                        ev.getSorter().add(new SorterItemInfo("entry.seq"));
                        IMaterialSerialNumber iMaterialSerialNumber = MaterialSerialNumberFactory.getRemoteInstance();
                        MaterialSerialNumberCollection snColl = iMaterialSerialNumber.getMaterialSerialNumberCollection(ev);
                        isSaveSN = snColl != null && snColl.size() != 0;
                    }
                    if (this.editData.get("ImportSN") != null) {
                        Hashtable htSN = (Hashtable)this.editData.get("ImportSN");
                        String lot = (String)this.getDetailTable().getCell(i, TB_BATCH).getValue();
                        if (lot != null && lot.length() > 0) {
                            String key = lot.trim() + material.getId();
                            isSaveSN = htSN.get(key) != null;
                        }
                    }
                    if (isSaveSN) continue;
                    strTemp = ResourceUtil.getMessage((String)this.invAddResource, (String)"SerialNumberNotInput", (String[])new String[]{String.valueOf(i + 1)});
                    sbSN.append(strTemp + '\n');
                    this.getDetailTable().requestFocus();
                    this.getDetailTable().getEditManager().editCellAt(i, 0);
                }
            }
            if (sbSN.toString().length() > 0) {
                if (InvCommonUtils.isSerialRequired(this.sou.getId().toString(), null).booleanValue()) {
                    MsgBox.showInfo((Component)((Object)this), (String)sbSN.toString());
                    SysUtil.abort();
                } else {
                    sbSN.append('\n' + InvClientUtils.getResource("SN_CONFIRM_NOT_INPUT"));
                    int answer = MsgBox.showConfirm2((Component)((Object)this), (String)sbSN.toString());
                    if (answer != 0) {
                        SysUtil.abort();
                    }
                }
            }
            this.showError(error.toString());
            InvClientUtils.checkDuplicateLot(this.kdtEntry, TB_MATERIAL);
        }
        if (e != null && e.getSource() != null && (e.getSource() == this.btnSubmit || e.getSource() == this.menuItemSubmit)) {
            InvClientUtils.checkForOffSet(this.editData);
        }
    }

    private int buildErrorString(StringBuffer error, String strTemp, int rowIndex, int errorCount, String col) {
        ++errorCount;
        if (error.toString().length() != 0) {
            error.append("\r\n");
        }
        if (errorCount == 1) {
            this.indexRow = rowIndex;
            this.indexCol = this.kdtEntry.getColumnIndex(col);
        }
        error.append(strTemp);
        if (errorCount > 4) {
            this.showError(error.toString());
        }
        return errorCount;
    }

    private void showError(String error) {
        if (error.length() > 0) {
            MsgBox.showInfo((String)error);
            if (this.indexRow != -1) {
                this.kdtEntry.getEditManager().editCellAt(this.indexRow, this.indexCol);
                this.indexRow = -1;
                this.indexCol = -1;
            }
            SysUtil.abort();
        }
    }

    private void showError(String error, JComponent component) {
        if (error.length() > 0) {
            MsgBox.showInfo((String)error);
            component.requestFocus();
            SysUtil.abort();
        }
    }

    public void actionRemoveLine_actionPerformed(ActionEvent e) throws Exception {
        super.actionRemoveLine_actionPerformed(e);
    }

    @Override
    public void actionOffset_actionPerformed(ActionEvent e) throws Exception {
        if (this.editData.getSourceBillType() != null && "18b7FpLNSrmaD8V9SPcOhkY+1VI=".equals(this.editData.getSourceBillType().getId().toString())) {
            MsgBox.showInfo((Component)((Object)this), (String)InvClientUtils.getResource("NOTSUPPORT_OFFSET"));
            SysUtil.abort();
        }
        if (this.editData.getId() == null || !InvClientUtils.isOffSetable(this.editData)) {
            return;
        }
        if (this.isSysBill()) {
            MsgBox.showInfo((Component)((Object)this), (String)InvClientUtils.getResource("SYSBILL_CANT_OFFSET"));
            SysUtil.abort();
        }
        MoveIssueBillInfo billInfo = this.editData;
        billInfo.setIsReversed(true);
        String sourebillNumber = billInfo.getNumber();
        billInfo.setNumber(null);
        MoveIssueBillEntryCollection entrys = billInfo.getEntry();
        MoveIssueBillEntryInfo entry = null;
        BigDecimal reverseQty = InvClientUtils.ZERO;
        BigDecimal totalInWarehsQty = InvClientUtils.ZERO;
        MeasureUnitInfo unit = null;
        MeasureUnitInfo assistUnit = null;
        MaterialInfo material = null;
        boolean isQtyChange = false;
        int entrySize = entrys.size();
        for (int i = 0; i < entrySize; ++i) {
            BigDecimal qty;
            entry = entrys.get(i);
            if (entry.getId() == null) {
                entrys.removeObject((IObjectValue)entry);
                --i;
                --entrySize;
                continue;
            }
            entry.setParent(billInfo);
            entry.setSourceBillId(billInfo.getId().toString());
            entry.setSourceBillNumber(sourebillNumber);
            entry.setSourceBillEntryId(entry.getId().toString());
            entry.setSourceBillEntrySeq(entry.getSeq());
            reverseQty = entry.getReverseQty();
            totalInWarehsQty = entry.getTotalInWarehsQty();
            BigDecimal oldQty = entry.getQty();
            if (oldQty == null) {
                oldQty = InvClientUtils.ZERO;
            }
            if (reverseQty != null) {
                entry.setQty(entry.getQty().subtract(reverseQty));
            }
            if (totalInWarehsQty != null) {
                entry.setQty(entry.getQty().subtract(totalInWarehsQty));
            }
            entry.setReverseQty(InvClientUtils.ZERO);
            entry.setReverseBaseQty(InvClientUtils.ZERO);
            entry.setTotalInWarehsQty(InvClientUtils.ZERO);
            entry.setCanInwarehsBaseQty(InvClientUtils.ZERO);
            entry.setId(null);
            unit = entry.getUnit();
            assistUnit = entry.getAssistUnit();
            material = entry.getMaterial();
            entry.setBaseQty(InvClientUtils.getBaseUnitQty(unit, material, entry.getQty()));
            if (assistUnit != null) {
                entry.setAssistQty(InvClientUtils.getAssUnitQty(assistUnit, material, entry.getBaseQty()));
            }
            if ((qty = entry.getQty()) == null) {
                qty = InvClientUtils.ZERO;
            }
            boolean bl = isQtyChange = oldQty.compareTo(qty) != 0;
            if (!isQtyChange) continue;
            this.initEntryCost4Reversed(entry, this.localAmtPrecision);
        }
        billInfo.setSourceBillId(billInfo.getId().toString());
        billInfo.setId(null);
        billInfo.setBaseStatus(BillBaseStatusEnum.ADD);
        billInfo.setVoucher(null);
        billInfo.setFiVouchered(false);
        billInfo.setCreator(SysContext.getSysContext().getCurrentUserInfo());
        billInfo.setLastUpdateUser(null);
        billInfo.setLastUpdateTime(null);
        billInfo.setAuditor(null);
        billInfo.setAuditTime(null);
        billInfo.setModifier(null);
        billInfo.setModificationTime(null);
        billInfo.setSourceBillType(billInfo.getBillType());
        this.setOprtState("ADDNEW");
        StorageOrgUnitInfo storage = this.editData.getStorageOrgUnit();
        this.setNumEditableWhenUnitChange(storage.getId().toString());
        if (this.isAutoNumber) {
            this.isAddView = this.isAddView(storage.getId().toString());
            if (this.isAddView) {
                this.getNumTextField().setText(null);
                String newNum = this.getNewNumberByUnit(storage.getId().toString());
                this.getNumTextField().setText(newNum);
                billInfo.setNumber(newNum);
            }
        }
        this.setDataObject((IObjectValue)billInfo);
        this.setMakeRelations(null);
        this.unLockUI();
        this.loadFields();
        this.setDefaultFocused();
        this.bizPrmtBizType.setEnabled(false);
        this.prmtStorageOrgUnit.setEditable(false);
        this.prmtStorageOrgUnit.setAccessAuthority(1);
        this.getNumTextField().setEditable(this.getIsEditable());
        if (this.getIsEditable()) {
            this.getNumTextField().setAccessAuthority(0);
        } else {
            this.getNumTextField().setAccessAuthority(1);
        }
    }

    public KDTextField getNumTextField() {
        return this.txtNumber;
    }

    protected KDDatePicker getBizDateField() {
        return this.pkBizDate;
    }

    public KDBizPromptBox getMainOrgUnit() {
        return this.prmtStorageOrgUnit;
    }

    @Override
    public void actionQuickAddLine_actionPerformed(ActionEvent e) throws Exception {
        this.SRowIndex = this.kdtEntry.getRowCount();
        this.inventoryAdaptor();
    }

    @Override
    protected void bizInventoryPreChanged(PreChangeEvent e) {
        if (e.getData() == null) {
            return;
        }
        InventoryInfo[] Inventory0 = null;
        if (e.getData() instanceof InventoryInfo[]) {
            Inventory0 = (InventoryInfo[])e.getData();
        } else if (e.getData() instanceof InventoryInfo) {
            Inventory0 = new InventoryInfo[]{(InventoryInfo)e.getData()};
        }
        if (Inventory0 == null) {
            return;
        }
        MaterialInfo material = null;
        WarehouseInfo warehs = null;
        MeasureUnitInfo unit = null;
        MeasureUnitInfo baseUnit = null;
        MeasureUnitInfo assistUnit = null;
        LocationInfo location = null;
        String lot = null;
        String materialId = null;
        int qtyPrecision = 2;
        try {
            IMultiMeasureUnit immu = MultiMeasureUnitFactory.getRemoteInstance();
            for (int i = 0; i < Inventory0.length; ++i) {
                if (this.SRowIndex == 1 && this.kdtEntry.getCell(0, TB_MATERIAL).getValue() == null) {
                    this.SRowIndex = 0;
                } else {
                    this.insertLine(this.SRowIndex);
                }
                InventoryInfo sInventory = Inventory0[i];
                if (this.SRowIndex == -1) continue;
                material = sInventory.getMaterial();
                warehs = sInventory.getWarehouse();
                location = sInventory.getLocation();
                unit = sInventory.getUnit();
                baseUnit = sInventory.getBaseUnit();
                assistUnit = sInventory.getAssistUnit();
                lot = sInventory.getLot();
                if (material != null) {
                    this.kdtEntry.getCell(this.SRowIndex, TB_MATERIAL).setValue((Object)material);
                    materialId = material.getId().toString();
                }
                if (warehs != null) {
                    this.kdtEntry.getRow(this.SRowIndex).getCell(TB_WAREHOUSE).setValue((Object)warehs);
                    if (warehs.isHasLocation()) {
                        this.kdtEntry.getCell(this.SRowIndex, TB_LOCATION).getStyleAttributes().setLocked(false);
                        SCMClientUtils.setNecessColorInCells((KDTable)this.kdtEntry, (String)TB_LOCATION, (int)this.SRowIndex, (boolean)true);
                    }
                }
                this.kdtEntry.getCell(this.SRowIndex, TB_LOCATION).setValue((Object)location);
                this.kdtEntry.getCell(this.SRowIndex, TB_BATCH).setValue((Object)lot);
                if (unit != null) {
                    this.kdtEntry.getCell(this.SRowIndex, TB_UNIT).setValue((Object)unit);
                    qtyPrecision = immu.getQtyPrecision(materialId, unit.getId().toString());
                    SCMClientUtils.changeTableColPrecision((int)qtyPrecision, (KDTable)this.kdtEntry, (String[])QTYPRECISIONTAB, (int)this.SRowIndex);
                }
                if (baseUnit != null) {
                    this.kdtEntry.getCell(this.SRowIndex, TB_BASEUNIT).setValue((Object)baseUnit);
                    qtyPrecision = immu.getQtyPrecision(materialId, unit.getId().toString());
                    SCMClientUtils.changeTableColPrecision((int)qtyPrecision, (KDTable)this.kdtEntry, (String[])BASEQTY_PRECISION_TAB, (int)this.SRowIndex);
                }
                this.kdtEntry.getCell(this.SRowIndex, TB_ASSISTANTUNIT).setValue((Object)assistUnit);
                if (assistUnit != null) {
                    qtyPrecision = immu.getQtyPrecision(materialId, unit.getId().toString());
                    SCMClientUtils.changeTableColPrecision((int)qtyPrecision, (KDTable)this.kdtEntry, (String[])ASSQTY_PRECISION_TAB, (int)this.SRowIndex);
                }
                this.kdtEntry.getCell(this.SRowIndex, TB_QTY).setValue((Object)sInventory.getCurStoreQty());
                this.kdtEntry.getCell(this.SRowIndex, TB_BASEUNITQTY).setValue((Object)sInventory.getBaseQty());
                this.kdtEntry.getCell(this.SRowIndex, TB_ASSISTQTY).setValue((Object)sInventory.getCurStoreAssistQty());
                this.setInvUpdateByInventory(sInventory, this.SRowIndex);
                this.calEntryCost4MaterialChanged(this.SRowIndex, this.localAmtPrecision);
            }
        }
        catch (EASBizException e2) {
            this.handUIException(e2);
        }
        catch (BOSException e2) {
            this.handUIException(e2);
        }
        catch (Exception e2) {
            this.handUIException(e2);
        }
        this.getDetailTable().getSelectManager().select(0, this.getDetailTable().getColumnIndex(TB_MATERIAL));
    }

    private void materialChange(MaterialInfo material, int rowIndex, boolean isOnload) throws BOSException, EASBizException {
        String materialName = "";
        String materialModel = "";
        IRow curRow = this.kdtEntry.getRow(rowIndex);
        InvClientUtils.setColLock(this.kdtEntry, LOCKCOLS, rowIndex, false);
        StorageOrgUnitInfo storage = (StorageOrgUnitInfo)this.prmtStorageOrgUnit.getValue();
        if (storage == null) {
            String message = EASResource.getString((String)"com.kingdee.eas.scm.im.inv.WarehsManageResource.STORAGEORGNOTSELECT");
            this.prmtStorageOrgUnit.requestFocus();
            MsgBox.showInfo((Component)((Object)this), (String)message);
            return;
        }
        if (material != null) {
            MeasureUnitInfo assUnit;
            materialName = material.getName();
            materialModel = material.getModel();
            this.initEntryUnitCell(rowIndex, material);
            if (storage != null) {
                MaterialInventoryInfo materialInvInfo = MaterialInventoryFactory.getRemoteInstance().getInventoryInfo(material.getId().toString(), storage.getId().toString());
                if (materialInvInfo != null) {
                    this.kdtEntry.getCell(rowIndex, TB_UNIT).setValue((Object)materialInvInfo.getUnit());
                    SCMClientUtils.changeTableColPrecisionByMaterial((MaterialInfo)material, (MeasureUnitInfo)materialInvInfo.getUnit(), (KDTable)this.getDetailTable(), (String[])QTYPRECISIONTAB, (int[])new int[]{rowIndex});
                    if (materialInvInfo != null && materialInvInfo.isIsLotNumber()) {
                        SCMClientUtils.setNecessColorInCells((KDTable)this.kdtEntry, (String)TB_BATCH, (int)rowIndex, (boolean)true);
                        curRow.getCell(TB_BATCH).getStyleAttributes().setLocked(false);
                        if (!this.editData.isIsReversed() && this.isBotpBill() && curRow.getCell(TB_BATCH).getValue() != null && curRow.getCell(TB_EXP).getValue() == null) {
                            InvClientUtils.setLotInfo(this.kdtEntry, rowIndex, this.sou, material, curRow.getCell(TB_BATCH).getValue().toString(), this.editData, this.fetchData);
                        }
                        if (this.editData.isIsReversed()) {
                            curRow.getCell(TB_BATCH).getStyleAttributes().setLocked(true);
                        }
                        if (curRow.getCell(TB_BATCH).getValue() == null) {
                            LotFrame lotFrame = new LotFrame();
                            lotFrame.setSeq(rowIndex);
                            lotFrame.setMainBizOrg(this.sou.getId().toString());
                            lotFrame.setMaterial(material.getId().toString());
                            this.lotFrameList.add(lotFrame);
                            if (curRow.getCell(TB_BATCH).getValue() == null) {
                                curRow.getCell(TB_BATCH).getStyleAttributes().setLocked(false);
                            }
                        }
                    } else {
                        SCMClientUtils.clearCells((IRow)curRow, (String[])new String[]{TB_BATCH, TB_MFG, TB_EXP});
                        curRow.getCell(this.kdtEntry.getColumnIndex(TB_BATCH)).getStyleAttributes().setLocked(true);
                        SCMClientUtils.setNecessColorInCells((KDTable)this.kdtEntry, (String)TB_BATCH, (int)rowIndex, (boolean)false);
                    }
                } else {
                    SCMClientUtils.changeTableColPrecisionByMaterial(null, null, (KDTable)this.getDetailTable(), (String[])QTYPRECISIONTAB, (int[])new int[]{rowIndex});
                    this.kdtEntry.getCell(rowIndex, TB_UNIT).setValue(null);
                }
                WarehouseInfo wi = InvClientUtils.getDefaultWarehouse(storage, material, 0);
                InvClientUtils.setLocationFilter((CoreUIObject)this, storage, wi, material, this.fetchData, this.kdtEntry, rowIndex, true);
                if (wi != null) {
                    this.kdtEntry.getCell(rowIndex, TB_WAREHOUSE).setValue((Object)wi);
                    PersonInfo stocker = wi.getWhman();
                    if (stocker != null) {
                        this.kdtEntry.getCell(rowIndex, TB_STOCKER).setValue((Object)stocker);
                    }
                }
            }
            this.kdtEntry.getCell(rowIndex, TB_ASSISTANATTR).setValue(null);
            this.setEntryAssistProperty(rowIndex, material);
            MeasureUnitInfo baseUnit = material.getBaseUnit();
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("number"));
            sic.add(new SelectorItemInfo("name"));
            if (baseUnit != null) {
                ObjectUuidPK pk = new ObjectUuidPK(baseUnit.getId().toString());
                baseUnit = MeasureUnitFactory.getRemoteInstance().getMeasureUnitInfo((IObjectPK)pk, sic);
                this.kdtEntry.getCell(rowIndex, TB_BASEUNIT).setValue((Object)baseUnit);
            }
            if ((assUnit = material.getAssistUnit()) != null) {
                String assId = assUnit.getId().toString();
                ObjectUuidPK pk = new ObjectUuidPK(assId);
                assUnit = MeasureUnitFactory.getRemoteInstance().getMeasureUnitInfo((IObjectPK)pk, sic);
                this.kdtEntry.getCell(rowIndex, TB_ASSISTQTY).getStyleAttributes().setLocked(false);
                int scale = InvClientUtils.getMeasueUnitScale(material.getId().toString(), assId);
                SCMClientUtils.changeTableColPrecision((int)scale, (KDTable)this.kdtEntry, (String[])ASSQTY_PRECISION_TAB, (int)rowIndex);
            } else {
                this.kdtEntry.getCell(rowIndex, TB_ASSISTQTY).getStyleAttributes().setLocked(true);
                this.kdtEntry.getCell(rowIndex, TB_ASSISTQTY).setValue(null);
            }
            this.kdtEntry.getCell(rowIndex, TB_ASSISTANTUNIT).setValue((Object)assUnit);
            int pricePrecision = material.getPricePrecision();
            SCMClientUtils.changeTableColPrecision((int)pricePrecision, (KDTable)this.kdtEntry, (String[])PRICE_PRECISION_TAB, (int)rowIndex);
        }
        this.kdtEntry.getCell(rowIndex, TB_MATERIALNAME).setValue((Object)materialName);
        this.kdtEntry.getCell(rowIndex, TB_MATERIALMODEL).setValue((Object)materialModel);
        this.calEntryCost4MaterialChanged(rowIndex, this.localAmtPrecision);
    }

    protected String getEntryMaterialFieldName() {
        return TB_MATERIAL;
    }

    @Override
    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        super.checkCanEdit();
        boolean isReverse = this.editData.isIsReversed();
        int entrySize = this.editData.getEntry().size();
        BigDecimal facost = InvClientUtils.ZERO;
        BigDecimal standardCost = InvClientUtils.ZERO;
        if (isReverse && entrySize > 0) {
            this.editData.setTotalStandardCost(this.editData.getTotalStandardCost().negate());
            this.editData.setTotalActualCost(this.editData.getTotalActualCost().negate());
            for (int i = 0; i < entrySize; ++i) {
                MoveIssueBillEntryInfo entry = this.editData.getEntry().get(i);
                BigDecimal qty = entry.getQty();
                entry.setQty(qty.negate());
                entry.setBaseQty(entry.getBaseQty().negate());
                BigDecimal assQty = entry.getAssistQty();
                if (assQty != null) {
                    entry.setAssistQty(assQty.negate());
                }
                if ((facost = entry.getActualCost()) != null) {
                    entry.setActualCost(facost.negate());
                }
                if ((standardCost = entry.getStandardCost()) == null) continue;
                entry.setStandardCost(standardCost.negate());
            }
        }
        super.actionEdit_actionPerformed(e);
        this.initSetOffBtn();
        this.setOnlyActualCostEditable();
        this.syncOldData((IObjectValue)this.editData);
        this.initIsSetOff();
    }

    @Override
    protected void initDataStatus() {
        super.initDataStatus();
        if (this.editData != null) {
            this.initSetOffBtn();
        }
        if ("ADDNEW".equals(this.getOprtState())) {
            if (this.editData.getId() == null && !this.isBotpBill()) {
                this.prmtStorageOrgUnit.setEnabled(true);
            }
            if (this.isBotpBill()) {
                this.setQuickAddLineStatus(false);
            } else {
                this.setQuickAddLineStatus(true);
            }
        } else if ("VIEW".equals(this.getOprtState()) || "FINDVIEW".equals(this.getOprtState())) {
            this.setQuickAddLineStatus(false);
        } else if ("EDIT".equals(this.getOprtState())) {
            if (this.isBotpBill()) {
                this.setQuickAddLineStatus(false);
            } else {
                this.setQuickAddLineStatus(true);
            }
        }
        String viewStatus = this.getOprtState();
        if ((viewStatus.equalsIgnoreCase("EDIT") || viewStatus.equalsIgnoreCase("ADDNEW")) && (this.isReverse || this.isBOTP)) {
            this.kdtEntry.setEnabled(true);
            this.getNumTextField().setEnabled(true);
            if (this.isBOTP) {
                this.pkBizDate.setEnabled(true);
            }
            if (this.isReverse) {
                // empty if block
            }
        }
        if (this.editData != null && this.editData.getBaseStatus().getValue() == 4 && this.getUIContext().get("BillQuery") == null) {
            this.btnSave.setEnabled(false);
            this.actionSave.setEnabled(false);
            this.menuItemSave.setEnabled(false);
            this.btnSubmit.setEnabled(false);
            this.actionSubmit.setEnabled(false);
            this.menuItemSubmit.setEnabled(false);
            this.setOprtState("VIEW");
        }
        this.setControl();
    }

    protected void setQuickAddLineStatus(boolean enable) {
    }

    protected void setEntryAssistProperty(int rowIndex, MaterialInfo materialInfo) {
        if (materialInfo != null) {
            AsstAttrTypeInfo asst = materialInfo.getAssistAttr();
            if (asst != null && !this.editData.isIsReversed()) {
                KDBizPromptBox bizAssistPropertyBox = new KDBizPromptBox();
                SCMClientUtils.setAsstAttrInputF7((KDBizPromptBox)bizAssistPropertyBox, (MaterialInfo)materialInfo, (IUIObject)this);
                bizAssistPropertyBox.setDisplayFormat("$number$");
                this.kdtEntry.getRow(rowIndex).getCell(TB_ASSISTANATTR).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)bizAssistPropertyBox));
                this.kdtEntry.getRow(rowIndex).getCell(TB_ASSISTANATTR).getStyleAttributes().setLocked(false);
                SCMClientUtils.setNecessColorInCells((KDTable)this.kdtEntry, (String)TB_ASSISTANATTR, (int)rowIndex, (boolean)true);
            } else {
                this.kdtEntry.getRow(rowIndex).getCell(TB_ASSISTANATTR).getStyleAttributes().setLocked(true);
                SCMClientUtils.setNecessColorInCells((KDTable)this.kdtEntry, (String)TB_ASSISTANATTR, (int)rowIndex, (boolean)false);
            }
        }
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("bizType"));
        selector.add(new SelectorItemInfo("fiVouchered"));
        selector.add(new SelectorItemInfo("isSysBill"));
        selector.add(new SelectorItemInfo("number"));
        selector.add(new SelectorItemInfo("bizDate"));
        selector.add(new SelectorItemInfo("baseStatus"));
        selector.add(new SelectorItemInfo("totalStandardCost"));
        selector.add(new SelectorItemInfo("totalActualCost"));
        selector.add(new SelectorItemInfo("isReversed"));
        selector.add(new SelectorItemInfo("auditTime"));
        selector.add(new SelectorItemInfo("modificationTime"));
        selector.add(new SelectorItemInfo("createTime"));
        selector.add(new SelectorItemInfo("description"));
        selector.add(new SelectorItemInfo("isInitBill"));
        selector.addObjectCollection((IObjectCollection)SCMSelectorFactory.getTransactionTypeSelector((boolean)true));
        selector.add(new SelectorItemInfo("costCenterOrgUnit.id"));
        selector.add(new SelectorItemInfo("costCenterOrgUnit.number"));
        selector.add(new SelectorItemInfo("costCenterOrgUnit.name"));
        selector.add(new SelectorItemInfo("bizType.id"));
        selector.add(new SelectorItemInfo("bizType.number"));
        selector.add(new SelectorItemInfo("bizType.name"));
        selector.add(new SelectorItemInfo("issueCompanyOrgUnit.id"));
        selector.add(new SelectorItemInfo("issueCompanyOrgUnit.number"));
        selector.add(new SelectorItemInfo("issueCompanyOrgUnit.name"));
        selector.add(new SelectorItemInfo("receiptCompanyOrgUnit.id"));
        selector.add(new SelectorItemInfo("receiptCompanyOrgUnit.number"));
        selector.add(new SelectorItemInfo("receiptCompanyOrgUnit.name"));
        selector.add(new SelectorItemInfo("storageOrgUnit.id"));
        selector.add(new SelectorItemInfo("storageOrgUnit.number"));
        selector.add(new SelectorItemInfo("storageOrgUnit.name"));
        selector.add(new SelectorItemInfo("storageOrgUnit.CU.id"));
        selector.add(new SelectorItemInfo("storageOrgUnit.CU.name"));
        selector.add(new SelectorItemInfo("storageOrgUnit.CU.number"));
        selector.add(new SelectorItemInfo("sourceBillType.id"));
        selector.add(new SelectorItemInfo("sourceBillType.number"));
        selector.add(new SelectorItemInfo("sourceBillType.name"));
        selector.add(new SelectorItemInfo("receiptStorageOrgUnit.id"));
        selector.add(new SelectorItemInfo("receiptStorageOrgUnit.number"));
        selector.add(new SelectorItemInfo("receiptStorageOrgUnit.name"));
        selector.add(new SelectorItemInfo("auditor.id"));
        selector.add(new SelectorItemInfo("auditor.number"));
        selector.add(new SelectorItemInfo("auditor.name"));
        selector.add(new SelectorItemInfo("modifier.id"));
        selector.add(new SelectorItemInfo("modifier.number"));
        selector.add(new SelectorItemInfo("modifier.name"));
        selector.add(new SelectorItemInfo("creator.id"));
        selector.add(new SelectorItemInfo("creator.number"));
        selector.add(new SelectorItemInfo("creator.name"));
        selector.add(new SelectorItemInfo("adminOrgUnit.id"));
        selector.add(new SelectorItemInfo("adminOrgUnit.number"));
        selector.add(new SelectorItemInfo("adminOrgUnit.name"));
        selector.add(new SelectorItemInfo("billType.id"));
        selector.add(new SelectorItemInfo("billType.number"));
        selector.add(new SelectorItemInfo("billType.name"));
        selector.add(new SelectorItemInfo("entry.stockTransferBillNum"));
        selector.add(new SelectorItemInfo("entry.qty"));
        selector.add(new SelectorItemInfo("entry.amount"));
        selector.add(new SelectorItemInfo("entry.price"));
        selector.add(new SelectorItemInfo("entry.unitStandardCost"));
        selector.add(new SelectorItemInfo("entry.standardCost"));
        selector.add(new SelectorItemInfo("entry.assistQty"));
        selector.add(new SelectorItemInfo("entry.unitActualCost"));
        selector.add(new SelectorItemInfo("entry.reverseQty"));
        selector.add(new SelectorItemInfo("entry.baseQty"));
        selector.add(new SelectorItemInfo("entry.actualCost"));
        selector.add(new SelectorItemInfo("entry.stockTransferBillEntrySeq"));
        selector.add(new SelectorItemInfo("entry.exp"));
        selector.add(new SelectorItemInfo("entry.isPresent"));
        selector.add(new SelectorItemInfo("entry.remark"));
        selector.add(new SelectorItemInfo("entry.mfg"));
        selector.add(new SelectorItemInfo("entry.lot"));
        selector.add(new SelectorItemInfo("entry.totalInWarehsQty"));
        selector.add(new SelectorItemInfo("entry.canInwarehsBaseQty"));
        selector.add(new SelectorItemInfo("entry.sourceBillId"));
        selector.add(new SelectorItemInfo("entry.sourceBillNumber"));
        selector.add(new SelectorItemInfo("entry.sourceBillEntryId"));
        selector.add(new SelectorItemInfo("entry.sourceBillEntrySeq"));
        selector.add(new SelectorItemInfo("entry.companyOrgUnit.id"));
        selector.add(new SelectorItemInfo("entry.companyOrgUnit.number"));
        selector.add(new SelectorItemInfo("entry.companyOrgUnit.name"));
        selector.add(new SelectorItemInfo("entry.storageOrgUnit.id"));
        selector.add(new SelectorItemInfo("entry.storageOrgUnit.number"));
        selector.add(new SelectorItemInfo("entry.storageOrgUnit.name"));
        selector.add(new SelectorItemInfo("entry.material.id"));
        selector.add(new SelectorItemInfo("entry.material.number"));
        selector.add(new SelectorItemInfo("entry.material.name"));
        selector.add(new SelectorItemInfo("entry.material.model"));
        selector.add(new SelectorItemInfo("entry.material.pricePrecision"));
        selector.add(new SelectorItemInfo("entry.material.seqUnit.id"));
        selector.add(new SelectorItemInfo("entry.material.assistAttr.id"));
        selector.add(new SelectorItemInfo("entry.material.baseUnit.id"));
        selector.add(new SelectorItemInfo("entry.material.baseUnit.number"));
        selector.add(new SelectorItemInfo("entry.material.baseUnit.name"));
        selector.add(new SelectorItemInfo("entry.material.materialGroup.id"));
        selector.add(new SelectorItemInfo("entry.material.materialGroup.number"));
        selector.add(new SelectorItemInfo("entry.material.assistUnit.id"));
        selector.add(new SelectorItemInfo("entry.material.assistUnit.number"));
        selector.add(new SelectorItemInfo("entry.material.assistUnit.name"));
        selector.add(new SelectorItemInfo("entry.unit.id"));
        selector.add(new SelectorItemInfo("entry.unit.number"));
        selector.add(new SelectorItemInfo("entry.unit.name"));
        selector.add(new SelectorItemInfo("entry.warehouse.id"));
        selector.add(new SelectorItemInfo("entry.warehouse.number"));
        selector.add(new SelectorItemInfo("entry.warehouse.name"));
        selector.add(new SelectorItemInfo("entry.warehouse.hasLocation"));
        selector.add(new SelectorItemInfo("entry.warehouse.whman.id"));
        selector.add(new SelectorItemInfo("entry.warehouse.whman.name"));
        selector.add(new SelectorItemInfo("entry.warehouse.whman.number"));
        selector.add(new SelectorItemInfo("entry.location.id"));
        selector.add(new SelectorItemInfo("entry.location.name"));
        selector.add(new SelectorItemInfo("entry.location.number"));
        selector.add(new SelectorItemInfo("entry.stocker.id"));
        selector.add(new SelectorItemInfo("entry.stocker.name"));
        selector.add(new SelectorItemInfo("entry.stocker.number"));
        selector.add(new SelectorItemInfo("entry.baseUnit.id"));
        selector.add(new SelectorItemInfo("entry.baseUnit.number"));
        selector.add(new SelectorItemInfo("entry.baseUnit.name"));
        selector.add(new SelectorItemInfo("entry.assistProperty.id"));
        selector.add(new SelectorItemInfo("entry.assistProperty.name"));
        selector.add(new SelectorItemInfo("entry.assistProperty.number"));
        selector.add(new SelectorItemInfo("entry.assistUnit.id"));
        selector.add(new SelectorItemInfo("entry.assistUnit.number"));
        selector.add(new SelectorItemInfo("entry.assistUnit.name"));
        selector.add(new SelectorItemInfo("entry.project.id"));
        selector.add(new SelectorItemInfo("entry.project.number"));
        selector.add(new SelectorItemInfo("entry.project.name"));
        selector.add(new SelectorItemInfo("entry.trackNumber.id"));
        selector.add(new SelectorItemInfo("entry.trackNumber.number"));
        selector.add(new SelectorItemInfo("entry.trackNumber.name"));
        selector.add(new SelectorItemInfo("entry.storeType.id"));
        selector.add(new SelectorItemInfo("entry.storeType.number"));
        selector.add(new SelectorItemInfo("entry.storeType.name"));
        selector.add(new SelectorItemInfo("entry.customer.id"));
        selector.add(new SelectorItemInfo("entry.customer.number"));
        selector.add(new SelectorItemInfo("entry.customer.name"));
        selector.add(new SelectorItemInfo("entry.supplier.id"));
        selector.add(new SelectorItemInfo("entry.supplier.number"));
        selector.add(new SelectorItemInfo("entry.supplier.name"));
        selector.add(new SelectorItemInfo("entry.stockTransBillEntry.id"));
        selector.add(new SelectorItemInfo("entry.stockTransferBill.id"));
        selector.add(new SelectorItemInfo("entry.sourceBillType.id"));
        selector.add(new SelectorItemInfo("entry.sourceBillType.number"));
        selector.add(new SelectorItemInfo("entry.sourceBillType.name"));
        selector.addObjectCollection((IObjectCollection)SCMSelectorFactory.getInvUpdateTypeSelector((boolean)true, (String)this.getEntryName()));
        selector.add(new SelectorItemInfo("entry.reservationId"));
        selector.add(new SelectorItemInfo("entry.reservationBillObjectId"));
        selector.add(new SelectorItemInfo("entry.unVmiSettleBaseQty"));
        selector.add(new SelectorItemInfo("entry.totalVmiSettleBaseQty"));
        return selector;
    }

    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrint_actionPerformed(e);
        this.invokePrintFunction(true);
    }

    public void actionPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrintPreview_actionPerformed(e);
        this.invokePrintFunction(false);
    }

    protected IMetaDataPK getTDQueryPK() {
        return MetaDataPK.create((String)"com.kingdee.eas.scm.im.inv.MoveIssuePrintQuery");
    }

    protected String getTDFileName() {
        return "/SCM/IM/Issue/MoveIssueBilll";
    }

    public String getUITitle() {
        return InvClientUtils.getResource("MoveIssueBill");
    }

    protected void setColumnProperty(MaterialInfo materialInfo, int row, int col, boolean isOnload) throws Exception {
        StorageOrgUnitInfo storage = (StorageOrgUnitInfo)this.prmtStorageOrgUnit.getValue();
        this.initEntry(materialInfo, row, storage);
    }

    protected boolean isSplitLine() {
        return true;
    }

    protected List getSplitLineData(SCMBillEntryBaseInfo entryInfo, int splitNum, int splitType) {
        if (splitType == 1) {
            return this._getCopyLineData(entryInfo, splitNum, false);
        }
        ArrayList<MoveIssueBillEntryAgent> entryList = new ArrayList<MoveIssueBillEntryAgent>();
        MoveIssueBillEntryAgent aEntryInfo = null;
        for (int i = 1; i < splitNum; ++i) {
            aEntryInfo = MoveIssueBillEntryAgent.copyOvAsNewAgent((IObjectValue)entryInfo);
            aEntryInfo.setId(BOSUuid.create((BOSObjectType)entryInfo.getBOSType()));
            entryList.add(aEntryInfo);
        }
        return entryList;
    }

    private List _getCopyLineData(SCMBillEntryBaseInfo entryInfo, int splitNum, boolean needCleanQty) {
        ArrayList<MoveIssueBillEntryAgent> entryList = new ArrayList<MoveIssueBillEntryAgent>();
        MoveIssueBillEntryAgent aEntryInfo = null;
        for (int i = 0; i < splitNum - 1; ++i) {
            aEntryInfo = MoveIssueBillEntryAgent.copyOvAsNewAgent((IObjectValue)entryInfo);
            aEntryInfo.setId(BOSUuid.create((BOSObjectType)entryInfo.getBOSType()));
            if (needCleanQty) {
                aEntryInfo.setQty(InvClientUtils.ZERO);
                aEntryInfo.setBaseQty(InvClientUtils.ZERO);
                aEntryInfo.setAssistQty(InvClientUtils.ZERO);
                aEntryInfo.setReverseQty(InvClientUtils.ZERO);
                aEntryInfo.setCanInwarehsBaseQty(InvClientUtils.ZERO);
                aEntryInfo.setTotalInWarehsQty(InvClientUtils.ZERO);
                aEntryInfo.setStandardCost(InvClientUtils.ZERO);
                aEntryInfo.setActualCost(InvClientUtils.ZERO);
                aEntryInfo.setAmount(InvClientUtils.ZERO);
            }
            entryList.add(aEntryInfo);
        }
        return entryList;
    }

    protected void unLockUI() {
        super.unLockUI();
        this.prmtSourceBillType.setEnabled(false);
    }

    @Override
    public void setBtnHaidForCalQuery() throws Exception {
        super.setBtnHaidForCalQuery();
        this.actionOffset.setVisible(false);
        this.btnOffset.setVisible(false);
        this.menuItemOffset.setVisible(false);
        this.actionQuickAddLine.setVisible(false);
        this.btnQuickAddLine.setVisible(false);
        this.menuItemQuickAddLine.setVisible(false);
    }

    @Override
    public void setOnlyActualCostEditable() {
        if (this.isBillQuery()) {
            super.setOnlyActualCostEditable();
            this.prmtSourceBillType.setEnabled(false);
            this.prmtTransactionType.setEnabled(false);
            this.pkBizDate.setEnabled(false);
            this.prmtStorageOrgUnit.setEnabled(false);
            this.bizAdminOrg.setEnabled(false);
            this.prmtMoveInStorageOrgUnit.setEnabled(false);
            IRow curRow = null;
            for (int i = 0; i < this.getDetailTable().getRowCount3(); ++i) {
                curRow = this.getDetailTable().getRow(i);
                if (this.isBillEdit(curRow)) continue;
                InvClientUtils.setRowLock(this.getDetailTable(), i, new String[]{this.getFactCostName(), this.getUnitFactCostName()}, true);
            }
        }
    }

    public void editStarting(KDTEditEvent e) {
        KDTable table = this.getDetailTable();
        int rowIndex = e.getRowIndex();
        int colIndex = e.getColIndex();
        String fieldName = table.getColumnKey(colIndex);
        IRow row = table.getRow(rowIndex);
        if (this.getDetailTable().getColumnIndex(this.getEntryInvUpdateTypeColumnName()) == e.getColIndex()) {
            try {
                this.filterEntryInvUpdateType(e.getRowIndex());
            }
            catch (Exception e1) {
                this.handUIException(e1);
            }
        }
        if (TB_PRICE.equals(fieldName) || TB_AMOUNT.equals(fieldName)) {
            boolean isPresent = (Boolean)row.getCell(TB_ISPRESENT).getValue();
            if (isPresent) {
                e.setCancel(true);
                return;
            }
            if (row.getCell("id").getValue() == null) {
                return;
            }
            String id = row.getCell("id").getValue().toString();
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("sourceBillEntryId"));
            sic.add(new SelectorItemInfo("sourceBillType"));
            sic.add(new SelectorItemInfo("id"));
            try {
                if (!MoveIssueBillEntryFactory.getRemoteInstance().exists((IObjectPK)new ObjectUuidPK(id))) {
                    return;
                }
                MoveIssueBillEntryInfo entry = MoveIssueBillEntryFactory.getRemoteInstance().getMoveIssueBillEntryInfo((IObjectPK)new ObjectUuidPK(id), sic);
                if (entry.getSourceBillEntryId() != null && "50957179-0105-1000-e003-3152c0a812fd463ED552".equals(entry.getSourceBillType().getId().toString())) {
                    sic.clear();
                    sic.add(new SelectorItemInfo("id"));
                    sic.add(new SelectorItemInfo("isSalePrice"));
                    String transferBillEntryId = entry.getSourceBillEntryId();
                    StockTransferBillEntryInfo transferBillEntryInfo = StockTransferBillEntryFactory.getRemoteInstance().getStockTransferBillEntryInfo((IObjectPK)new ObjectUuidPK(transferBillEntryId), sic);
                    if (transferBillEntryInfo.isIsSalePrice()) {
                        row.getCell(colIndex).getStyleAttributes().setLocked(true);
                        e.setCancel(true);
                    } else {
                        row.getCell(colIndex).getStyleAttributes().setLocked(false);
                    }
                }
            }
            catch (Exception e1) {
                this.handleException(e1);
            }
        }
    }

    public void editStarted(KDTEditEvent e) {
    }

    public void editValueChanged(KDTEditEvent e) {
    }

    public void editStopping(KDTEditEvent e) {
    }

    public void editStopped(KDTEditEvent e) {
        try {
            this.tableValueChanged(e);
        }
        catch (Exception exc) {
            this.handUIException(exc);
        }
    }

    public void editCanceled(KDTEditEvent e) {
    }

    @Override
    protected KDBizPromptBox getTransacationTypeF7() {
        return this.prmtTransactionType;
    }

    @Override
    protected String getFactCostName() {
        return TB_FACTCOST;
    }

    @Override
    protected String getOffSetQtyName() {
        return TB_COUNTERQTY;
    }

    @Override
    protected String getUnitFactCostName() {
        return TB_UNITFACTCOST;
    }

    @Override
    protected void initWorkButton() {
        super.initWorkButton();
        this.menuItemOffset.setIcon(EASResource.getIcon((String)"imgTbtn_redclash"));
        this.menuItemQuickAddLine.setIcon(EASResource.getIcon((String)"imgTbtn_newaccountlist"));
        this.actionDiscard.setEnabled(true);
        this.actionDiscard.setVisible(true);
    }

    @Override
    protected void setSeparatorVisable(boolean isVisable) {
        super.setSeparatorVisable(isVisable);
    }

    protected KDBizPromptBox getMainBizOrg() {
        return this.prmtStorageOrgUnit;
    }

    @Override
    protected void initNeedMainOrgF7s() {
        super.initNeedMainOrgF7s();
        this.bizMaterialNumber = this.getBizMaterialF7(this.kdtEntry.getColumn(TB_MATERIAL), null);
        this.bizMaterialNumber.addChangeListener((ChangeListener)this);
        this.setDepartmentF7(this.bizAdminOrg);
        this.addNeedMainOrgF7s(new KDBizPromptBox[]{this.bizMaterialNumber, this.bizAdminOrg});
    }

    protected String getPermissionItem(String status) {
        if (status.equals("ADDNEW")) {
            return "moveissue_new";
        }
        return null;
    }

    @Override
    protected void initEditData(IObjectValue objectValue) {
        super.initEditData(objectValue);
        this.editData = (MoveIssueBillInfo)objectValue;
    }

    @Override
    protected void changeMainOrgUnit(PreChangeEvent pce) {
        this.moveOutStoragePreChanged(pce);
    }

    public KDBizPromptBox getprmtWarehouse() {
        if (this.prmtWarehouse == null) {
            this.prmtWarehouse = new KDBizPromptBox();
            this.prmtWarehouse.setEditable(true);
            this.prmtWarehouse.setQueryInfo("com.kingdee.eas.basedata.scm.im.inv.app.F7WarehouseQuery");
            this.prmtWarehouse.setDisplayFormat("$name$");
            this.prmtWarehouse.setEditFormat("$number$");
            this.prmtWarehouse.setCommitFormat("$number$");
        }
        return this.prmtWarehouse;
    }

    @Override
    protected void loadFieldsAfter() throws Exception {
        super.loadFieldsAfter();
        this.initEntrys();
        this.initBOTPControls();
        this.initSetOffControls();
    }

    @Override
    protected void loadFieldsBefore() throws Exception {
        super.loadFieldsBefore();
        this.setNegativeBill();
        this.initBOTPData();
        this.initReverseData();
    }

    @Override
    protected void storeFieldsAfter() throws Exception {
        super.storeFieldsAfter();
        this.initBOTPControls();
        this.initSetOffControls();
    }

    @Override
    protected void storeFieldsBefore() throws Exception {
        super.storeFieldsBefore();
        IRow curRow = null;
        for (int i = 0; i < this.kdtEntry.getRowCount(); ++i) {
            curRow = this.kdtEntry.getRow(i);
            InvClientUtils.inverseRowQty(curRow, NeedInverseQtyColumns, this.isNegativeBill, false);
        }
    }

    @Override
    protected void addListeners() {
        super.addListeners();
        this.kdtEntry.addKDTEditListener((KDTEditListener)this);
        this.prmtStorageOrgUnit.addPreChangeListener((PreChangeListener)this);
        this.prmtMoveInStorageOrgUnit.addPreChangeListener((PreChangeListener)this);
        this.prmtTransactionType.addDataChangeListener((DataChangeListener)this);
    }

    @Override
    protected void removeListeners() {
        super.removeListeners();
        this.kdtEntry.removeKDTEditListener((KDTEditListener)this);
        this.prmtStorageOrgUnit.removePreChangeListener((PreChangeListener)this);
        this.prmtMoveInStorageOrgUnit.removePreChangeListener((PreChangeListener)this);
        this.prmtTransactionType.removeDataChangeListener((DataChangeListener)this);
    }

    public void preChange(PreChangeEvent e) {
        Object source = e.getSource();
        if (e.getSource() == null) {
            return;
        }
        if (source.equals(this.prmtStorageOrgUnit)) {
            this.moveOutStoragePreChanged(e);
        } else if (source.equals(this.prmtMoveInStorageOrgUnit)) {
            this.moveInStoragePreChanged(e);
        }
    }

    private void setControl() {
        MoveIssueBillInfo info = null;
        info = this.editData != null ? this.editData : (MoveIssueBillInfo)this.dataBinder.getValueObject();
        if (info == null) {
            return;
        }
        boolean setoff = info.isIsReversed();
        if (info.getBaseStatus().getValue() == 4 || "VIEW".equals(this.getOprtState()) || "FINDVIEW".equals(this.getOprtState()) || setoff) {
            this.prmtTransactionType.setEnabled(false);
            this.prmtTransactionType.setEditable(false);
            this.prmtStorageOrgUnit.setEditable(false);
            this.prmtStorageOrgUnit.setAccessAuthority(1);
            this.pkBizDate.setEnabled(false);
        } else {
            this.prmtMoveInStorageOrgUnit.setEditable(false);
            this.prmtMoveInStorageOrgUnit.setAccessAuthority(1);
            this.pkBizDate.setEnabled(true);
        }
        if (info.getBaseStatus().getValue() != 4 && setoff) {
            this.pkBizDate.setEnabled(true);
        }
        this.setSerialNumberEnable(false);
        if (setoff) {
            this.getDetailTable().getColumn(TB_MATERIAL).getStyleAttributes().setLocked(true);
            InvClientUtils.setTableLock(this.getDetailTable(), new String[]{TB_QTY, TB_ASSISTQTY}, true);
            this.getDetailTable().getColumn(TB_QTY).getStyleAttributes().setFontColor(Color.RED);
            this.getDetailTable().getColumn(TB_BASEUNITQTY).getStyleAttributes().setFontColor(Color.RED);
            this.getDetailTable().getColumn(TB_ASSISTQTY).getStyleAttributes().setFontColor(Color.RED);
            InvClientUtils.setCellLock(this.getDetailTable(), TB_QTY, false);
            InvClientUtils.setCellLock(this.getDetailTable(), "remark", false);
            this.getDetailTable().getColumn("unVmiSettleBaseQty").getStyleAttributes().setFontColor(Color.RED);
            this.getDetailTable().getColumn("totalVmiSettleBaseQty").getStyleAttributes().setFontColor(Color.RED);
        } else {
            this.getDetailTable().getColumn(TB_QTY).getStyleAttributes().setFontColor(Color.BLACK);
            this.getDetailTable().getColumn(TB_BASEUNITQTY).getStyleAttributes().setFontColor(Color.BLACK);
            this.getDetailTable().getColumn(TB_ASSISTQTY).getStyleAttributes().setFontColor(Color.BLACK);
            this.getDetailTable().getColumn("unVmiSettleBaseQty").getStyleAttributes().setFontColor(Color.BLACK);
            this.getDetailTable().getColumn("totalVmiSettleBaseQty").getStyleAttributes().setFontColor(Color.BLACK);
        }
        this.txtAddFactCost.setPrecision(this.localAmtPrecision);
        this.txtAddStandardCost.setPrecision(this.localAmtPrecision);
        try {
            super.lockOrUnLockCostCell4Init(setoff);
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    @Override
    protected String getBatchName() {
        return TB_BATCH;
    }

    @Override
    protected String[] getColumnKeysForExtraUnvisible() {
        return new String[]{"lotFrame"};
    }

    @Override
    protected String getMaterialName() {
        return TB_MATERIAL;
    }

    private void initActions() {
        if (this.getActionManager().getAction("actionCalculateLot") != null && this.getActionManager().getAction("actionCalculateLot").getServices() != null) {
            this.actionCalculateDynQty.putValue("ShortDescription", null);
            this.actionCalculateLot.putValue("ShortDescription", null);
            if (this.ctnMain.getButtons().length <= 0) {
                this.ctnMain.add((Action)((Object)this.actionCalculateDynQty));
                this.ctnMain.add((Action)((Object)this.actionCalculateLot));
            }
            this.actionCalculateDynQty.setEnabled(true);
            this.actionCalculateLot.setEnabled(true);
        }
    }

    private void unitChanged(int rowIndex) throws EASBizException, BOSException, Exception {
        IRow curRow = this.kdtEntry.getRow(rowIndex);
        MeasureUnitInfo mulitInfo = (MeasureUnitInfo)this.kdtEntry.getRow(rowIndex).getCell(TB_UNIT).getValue();
        MaterialInfo materialInfo = (MaterialInfo)this.kdtEntry.getCell(rowIndex, TB_MATERIAL).getValue();
        if (mulitInfo != null && curRow.getCell(TB_MATERIAL).getValue() != null) {
            SCMClientUtils.changeCellPrecisionByMaterial((SCMFetchData)this.fetchData, (String[])QTYPRECISIONTAB, (IRow)curRow, (boolean)this.isNegativeBill);
        }
        this.changeSerialNumberEnable(curRow, mulitInfo, materialInfo);
        this.calEntryQty4UnitChanged(rowIndex);
        curRow.getCell(TB_UNITFACTCOST).setValue((Object)this.ZERO);
        this.calEntryCost4UnitChanged(rowIndex, this.localAmtPrecision);
        if (materialInfo != null) {
            BigDecimal qty = (BigDecimal)curRow.getCell(TB_QTY).getValue();
            BigDecimal amount = (BigDecimal)curRow.getCell(TB_AMOUNT).getValue();
            if (qty != null && BigDecimal.ZERO.compareTo(qty) != 0) {
                BigDecimal price = amount.divide(qty, materialInfo.getPricePrecision(), 4);
                curRow.getCell(TB_PRICE).setValue((Object)price);
            }
        }
    }

    private void qtyChanged(int rowIndex) throws EASBizException, BOSException, Exception {
        this.calEntryCost4QtyChanged(rowIndex, this.localAmtPrecision);
    }

    @Override
    public void actionCalculateLot_actionPerformed(ActionEvent e) throws Exception {
        super.actionCalculateLot_actionPerformed(e);
        super.actionCalculateLot();
    }

    @Override
    public void actionCalculateDynQty_actionPerformed(ActionEvent e) throws Exception {
        this.TB_BASEQTY = TB_BASEUNITQTY;
        ((AbstractMoveIssueBillEditUI)this).TB_ASSISTQTY = TB_ASSISTQTY;
        this.TB_ASSISTUNIT = TB_ASSISTANTUNIT;
        this.calculateDynQty();
    }

    @Override
    protected String getAssistPropertyName() {
        return TB_ASSISTANATTR;
    }

    @Override
    protected void beforeCalculateLot() {
        super.beforeCalculateLot();
    }

    @Override
    protected String getEntryBOSUuid() {
        return "0924D401";
    }

    @Override
    protected void afterQtyChanged(int row) throws Exception {
        this.qtyChanged(row);
    }

    @Override
    protected void afterUnitChanged(int row, MeasureUnitInfo oldUnit) throws Exception {
        this.unitChanged(row);
    }

    @Override
    protected InvBillBaseEntryInfo getCloneEntryInfo(InvBillBaseEntryInfo info) {
        return MoveIssueBillEntryAgent.copyOvAsNewAgent((IObjectValue)info);
    }

    @Override
    protected String getBaseQtyName() {
        return TB_BASEUNITQTY;
    }

    protected void setTableToSumField() {
        this.setTableToSumField(this.getDetailTable(), this.getSumColNames());
    }

    protected String[] getSumColNames() {
        return new String[]{TB_QTY, TB_BASEUNITQTY, TB_ASSISTQTY, TB_STANDARDCOST, TB_FACTCOST, TB_COUNTERQTY, TB_TOTALINWAREHSQTY, TB_AMOUNT};
    }

    @Override
    protected void tableSelectChanged(IRow curRow) throws Exception {
        MeasureUnitInfo unit = (MeasureUnitInfo)curRow.getCell(TB_UNIT).getValue();
        MaterialInfo material = (MaterialInfo)curRow.getCell(TB_MATERIAL).getValue();
        this.changeSerialNumberEnable(curRow, unit, material);
    }

    @Override
    protected InvBillBaseEntryInfo getCopyOvEntryAgent(InvBillBaseEntryInfo aInvBillBaseEntryInfo) {
        MoveIssueBillEntryInfo entryInfo = (MoveIssueBillEntryInfo)aInvBillBaseEntryInfo;
        MoveIssueBillEntryAgent aMoveIssueBillEntryAgent = MoveIssueBillEntryAgent.copyOvAsNewAgent((IObjectValue)entryInfo);
        aMoveIssueBillEntryAgent.setId(BOSUuid.create((BOSObjectType)entryInfo.getBOSType()));
        return aMoveIssueBillEntryAgent;
    }

    @Override
    public boolean isModify() {
        if ("VIEW".equals(this.getOprtState()) || "FINDVIEW".equals(this.getOprtState())) {
            return false;
        }
        return super.isModify();
    }

    protected EntityViewInfo buildTransactionTypeEntityView() {
        EntityViewInfo viewInfo = super.buildTransactionTypeEntityView();
        return viewInfo;
    }

    private TransactionTypeInfo getDefaultTransactionType() throws EASBizException, BOSException {
        return InvCommonUtils.getDefaultTransactionType(null, this.editData.getBillType().getId().toString(), this.editData.getBizType().getId().toString());
    }

    @Override
    protected KDPromptBox getPrmtCustomer() {
        if (this.prmtCustomer == null) {
            this.prmtCustomer = SCMClientUtils.createSimpleEntryF7(null);
        }
        return this.prmtCustomer;
    }

    @Override
    protected KDPromptBox getPrmtSupplier() {
        if (this.prmtSupplier == null) {
            this.prmtSupplier = SCMClientUtils.createSimpleEntryF7(null);
        }
        return this.prmtSupplier;
    }

    @Override
    protected Set getAutoFilledColNames() {
        Set colSet = super.getAutoFilledColNames();
        return colSet;
    }

    public void dataChanged(DataChangeEvent e) {
        if (e.getNewValue() != null && e.getNewValue().equals(e.getOldValue())) {
            return;
        }
        if (e.getSource().equals(this.getTransacationTypeF7())) {
            try {
                this.transactionTypeChanged(e);
            }
            catch (Exception e1) {
                this.handUIException(e1);
            }
        }
    }

    protected void transactionTypeChanged(DataChangeEvent e) throws Exception {
        this.isNegativeBill = InvClientUtils.isReturnRIType((TransactionTypeInfo)e.getNewValue());
        this.transactionTypeChanged(e, this.localAmtPrecision);
        ArrayList qtyCol = new ArrayList();
        Collections.addAll(qtyCol, QTYPRECISIONTAB);
        Collections.addAll(qtyCol, ASSQTY_PRECISION_TAB);
        Collections.addAll(qtyCol, BASEQTY_PRECISION_TAB);
        int count = this.getDetailTable().getRowCount();
        for (int i = 0; i < count; ++i) {
            IRow curRow = this.getDetailTable().getRow(i);
            this.changeQtyPrecision(curRow);
            if (!this.isNegativeBill) continue;
            for (int j = 0; j < qtyCol.size(); ++j) {
                Object qty = curRow.getCell((String)qtyCol.get(j)).getValue();
                if (qty == null) continue;
                curRow.getCell((String)qtyCol.get(j)).setValue((Object)((BigDecimal)qty).abs().negate());
            }
        }
    }

    protected TransactionTypeInfo getTransactionType() {
        return (TransactionTypeInfo)this.getTransacationTypeF7().getValue();
    }

    protected String getBillTypeId() {
        return "50957179-0105-1000-e000-016ec0a812fd463ED552";
    }

    @Override
    protected String getQtyName() {
        return TB_QTY;
    }

    @Override
    protected String getAssistQtyName() {
        return TB_ASSISTQTY;
    }

    @Override
    protected String getUnitName() {
        return TB_UNIT;
    }

    @Override
    protected String getAssistPropertyColName() {
        return TB_ASSISTANATTR;
    }

    @Override
    protected void initSCMBizDataVO(SCMBizDataVO vo) {
        if (this.isFirstLoading()) {
            vo.setOptionConfigNames(new String[]{"AssistForNumber", "NumberForAssist"});
            vo.setUiClassName(this.getMetaDataPK().getFullName());
        }
        super.initSCMBizDataVO(vo);
    }

    @Override
    protected boolean isSysBill() {
        return this.editData.isIsSysBill();
    }

    protected boolean isNeedSepcialParam() {
        return true;
    }

    @Override
    public boolean isPrepareInit() {
        return true;
    }

    @Override
    protected SCMFetchDataCondition getNormalCondtion() {
        SCMFetchDataCondition condition = super.getNormalCondtion();
        condition.setLoadSpecialParams(true);
        condition.setFecthAdminOrgUnitInfo(true);
        return condition;
    }

    @Override
    protected void setConditionContents(SCMFetchDataCondition condition) {
        super.setConditionContents(condition);
        String[] keys = new String[]{"isUseProjectTrack"};
        condition.setSpecialKeys(keys);
        if (this.editData != null && this.editData.getStorageOrgUnit() != null) {
            condition.setOrgIdForFecthAdminOrgUnitInfo(this.editData.getStorageOrgUnit().getId().toString());
        }
    }

    @Override
    protected boolean isSupportVoucher() {
        return true;
    }

    @Override
    protected String getGeneralVoucherPermissionName() {
        return "moveissue_generalVoucher";
    }

    @Override
    protected String getGeneralPCVoucherPermissionName() {
        return "moveissue_generalPcVoucher";
    }

    protected KDBizPromptBox getHeadTransactionTypeF7() {
        return this.prmtTransactionType;
    }

    protected KDBizPromptBox getHeadBizTypeF7() {
        return this.bizPrmtBizType;
    }

    @Override
    protected KDBizPromptBox getCostCenter() {
        return this.prmtCostCenter;
    }

    @Override
    protected KDBizPromptBox getDepartment() {
        return this.bizAdminOrg;
    }

    @Override
    protected KDBizPromptBox getBizInventory() {
        return this.bizInventory;
    }

    protected void initBatchActions() throws BOSException {
        this.actionManager.setClzIBizFactory(ActionLevelEnum.HEAD, MoveIssueBillFactory.class);
        this.actionManager.setClzIBizFactory(ActionLevelEnum.ENTRY, MoveIssueBillEntryFactory.class);
        this.getTableSelectionHelper().setTableProperty((ISupportBatchAction)this, this.getDetailTable(), "id", this.txtNumber, null);
        super.initBatchActions();
    }

    public boolean isSupportedBatchActions() {
        return true;
    }

    @Override
    protected String[] getNumberColumns() {
        return new String[]{TB_QTY, TB_BASEUNITQTY, TB_ASSISTQTY, TB_UNITSTANCOST, TB_STANDARDCOST, TB_UNITFACTCOST, TB_FACTCOST, TB_COUNTERQTY, TB_CANINWAREHSBASEQTY, TB_TOTALINWAREHSQTY, "unVmiSettleBaseQty", "totalVmiSettleBaseQty"};
    }

    @Override
    protected void afterInventoryF7Query(int rowIndex, int rowCount) throws Exception {
        super.afterInventoryF7Query(rowIndex, rowCount);
        for (int i = 0; i < rowCount; ++i) {
            this.calEntryCost4MaterialChanged(rowIndex + i, this.localAmtPrecision);
        }
    }

    @Override
    protected boolean isSupportPCVoucher() {
        return true;
    }

    protected void verifyQtyZero(String strTemp, int errorCount, StringBuffer error, int i) {
        strTemp = ResourceUtil.getMessage((String)this.invAddResource, (String)"QtyGreaterZero", (String[])new String[]{String.valueOf(i + 1)});
        errorCount = this.buildErrorString(error, strTemp, i, errorCount, TB_QTY);
    }
}

