/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.client;

import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.KDTableHelper;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.IMaterial;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.scm.common.EntryBaseStatusEnum;
import com.kingdee.eas.scm.common.SCMFetchDataCondition;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.im.inv.PlanOrderEntryInfo;
import com.kingdee.eas.scm.im.inv.PlanOrderFactory;
import com.kingdee.eas.scm.im.inv.client.AbstractPlanOrderEditUI;
import com.kingdee.eas.scm.im.inv.client.InvClientUtils;
import com.kingdee.eas.scm.im.inv.client.PlanOrderClientUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import javax.swing.JComboBox;
import javax.swing.JTextField;

public class PlanOrderEditUI
extends AbstractPlanOrderEditUI
implements KDTEditListener {
    IMaterial iMaterial = MaterialFactory.getRemoteInstance();
    StorageOrgUnitInfo storageOrgUnit = null;
    KDBizPromptBox prmtMaterial = null;
    KDBizPromptBox prmtUnit = new KDBizPromptBox();
    KDBizPromptBox prmtPlanner = new KDBizPromptBox();
    private static final String TB_MATERIAL = "material";
    private static final String TB_UNIT = "unit";
    private static final String TB_SAFETYSTORAGE = "safetyStorage";
    private static final String TB_INSTANTSTORAGE = "instantStorage";
    private static final String TB_PLANQTY = "planQty";
    private static final String TB_BASEUNIT = "baseUnit";
    private static final String TB_PLANBASEQTY = "planBaseqty";
    private static final String TB_PLANDATE = "planDate";
    private static final String TB_REQDATE = "reqDate";
    private static final String TB_TOTALREQQTY = "totalReqQty";
    private static final String TB_TOTALREQBASEQTY = "totalReqBaseQty";
    private static final String TB_CONVERTDATE = "convertDate";
    private static final String TB_ASSOCIATEQTY = "associateQty";
    private static final String TB_BASESTATUS = "baseStatus";
    private static final String[] TBS_QTY = new String[]{"safetyStorage", "instantStorage", "planQty", "totalReqQty"};
    private static final String[] TBS_BASEQTY = new String[]{"planBaseqty", "totalReqBaseQty", "associateQty"};
    private static final BigDecimal ZERO = new BigDecimal(0.0);
    private static final int DEFAULT_PRECISION = 2;

    protected ICoreBase getBizInterface() throws Exception {
        return PlanOrderFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext());
    }

    @Override
    public void loadFields() {
        try {
            this.loadFieldsBefore();
            super.loadFields();
            this.loadFieldsAfter();
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    @Override
    public void storeFields() {
        try {
            this.storeFieldsBefore();
            super.storeFields();
            this.storeFieldsAfter();
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    public void onLoad() throws Exception {
        this.getDetailTable().checkParsed();
        this.initHeadBeforeOnLoad();
        this.initEntryBeforeOnLoad();
        super.onLoad();
        this.actionAddNew.setEnabled(false);
        this.btnAddNew.setVisible(false);
        this.menuItemAddNew.setVisible(false);
        this.actionCopy.setEnabled(false);
        this.btnCopy.setVisible(false);
        this.menuItemCopy.setVisible(false);
        this.actionSave.setEnabled(false);
        this.btnSave.setVisible(false);
        this.menuItemSave.setVisible(false);
        this.actionAudit.setEnabled(false);
        this.btnAudit.setVisible(false);
        this.menuItemAudit.setVisible(false);
        this.actionUnAudit.setEnabled(false);
        this.btnUnAudit.setVisible(false);
        this.menuItemUnAudit.setVisible(false);
        this.actionAddLine.setEnabled(false);
        this.btnAddLine.setVisible(false);
        this.menuItemAddLine.setVisible(false);
        this.actionInsertLine.setEnabled(false);
        this.btnInsertLine.setVisible(false);
        this.menuItemInsertLine.setVisible(false);
        this.actionCopyLine.setEnabled(false);
        this.btnCopyLine.setVisible(false);
        this.menuItemCopyLine.setVisible(false);
        KDTableHelper.downArrowAutoAddRow((KDTable)this.kdtEntry, (boolean)false, null);
        KDTableHelper.updateEnterWithTab((KDTable)this.getDetailTable(), (boolean)false);
        this.menuItemInvBillOptin.setVisible(false);
        this.menuItemInvBillOptin.setEnabled(false);
    }

    protected void beforeStoreFields(ActionEvent e) throws Exception {
        super.beforeStoreFields(e);
        KDTable table = this.getDetailTable();
        if (table.getRowCount() == 0) {
            MsgBox.showError((Component)((Object)this), (String)PlanOrderClientUtils.getResource("entryCountIsZero"));
            SysUtil.abort();
        }
        for (int i = 0; i < table.getRowCount(); ++i) {
            Date reqDate;
            EntryBaseStatusEnum entryStatus = (EntryBaseStatusEnum)table.getCell(i, TB_BASESTATUS).getValue();
            if (EntryBaseStatusEnum.RELEASED.equals((Object)entryStatus)) continue;
            BigDecimal planQty = (BigDecimal)table.getCell(i, TB_PLANQTY).getValue();
            if (planQty == null || planQty.compareTo(ZERO) <= 0) {
                MsgBox.showError((Component)((Object)this), (String)PlanOrderClientUtils.getResource("qtyIsZero"));
                table.getEditManager().editCellAt(i, table.getColumnIndex(TB_PLANQTY));
                SysUtil.abort();
            }
            if ((reqDate = (Date)table.getCell(i, TB_REQDATE).getValue()) == null) {
                MsgBox.showError((Component)((Object)this), (String)PlanOrderClientUtils.getResource("deliveryDateIsNull"));
                table.getEditManager().editCellAt(i, table.getColumnIndex(TB_REQDATE));
                SysUtil.abort();
            }
            Date now = SCMClientUtils.getServerDate2();
            now.setHours(0);
            now.setMinutes(0);
            now.setSeconds(0);
            if (reqDate.compareTo(now) >= 0) continue;
            MsgBox.showError((Component)((Object)this), (String)PlanOrderClientUtils.getResource("deliveryDateCantBefore"));
            table.getEditManager().editCellAt(i, table.getColumnIndex(TB_REQDATE));
            SysUtil.abort();
        }
    }

    private void initHeadBeforeOnLoad() throws Exception {
        this.prmtCreator.setEnabled(false);
        this.prmtCreator.setEditable(false);
        this.prmtLastUpdateUser.setEnabled(false);
        this.prmtLastUpdateUser.setEditable(false);
        this.pkCreateTime.setEnabled(false);
        this.pkCreateTime.setEditable(false);
        this.pkLastUpdateTime.setEnabled(false);
        this.pkLastUpdateTime.setEditable(false);
    }

    private void initEntryBeforeOnLoad() throws Exception {
        KDFormattedTextField txtDecimal = new KDFormattedTextField(1);
        KDTDefaultCellEditor editorDecimal = new KDTDefaultCellEditor((JTextField)txtDecimal);
        txtDecimal.setHorizontalAlignment(4);
        txtDecimal.setPrecision(2);
        PlanOrderClientUtils.setDefaultDecimalEditor(txtDecimal, editorDecimal, this.kdtEntry, TB_SAFETYSTORAGE);
        PlanOrderClientUtils.setDefaultDecimalEditor(txtDecimal, editorDecimal, this.kdtEntry, TB_INSTANTSTORAGE);
        PlanOrderClientUtils.setDefaultDecimalEditor(txtDecimal, editorDecimal, this.kdtEntry, TB_PLANQTY);
        PlanOrderClientUtils.setDefaultDecimalEditor(txtDecimal, editorDecimal, this.kdtEntry, TB_PLANBASEQTY);
        PlanOrderClientUtils.setDefaultDecimalEditor(txtDecimal, editorDecimal, this.kdtEntry, TB_TOTALREQQTY);
        PlanOrderClientUtils.setDefaultDecimalEditor(txtDecimal, editorDecimal, this.kdtEntry, TB_TOTALREQBASEQTY);
        PlanOrderClientUtils.setDefaultDecimalEditor(txtDecimal, editorDecimal, this.kdtEntry, TB_ASSOCIATEQTY);
        KDDatePicker datePicker = new KDDatePicker();
        KDTDefaultCellEditor editorDate = new KDTDefaultCellEditor(datePicker);
        this.kdtEntry.getColumn(TB_PLANDATE).setEditor((ICellEditor)editorDate);
        this.kdtEntry.getColumn(TB_PLANDATE).getStyleAttributes().setNumberFormat(SCMClientUtils.strDateFormat);
        this.kdtEntry.getColumn(TB_REQDATE).setEditor((ICellEditor)editorDate);
        this.kdtEntry.getColumn(TB_REQDATE).getStyleAttributes().setNumberFormat(SCMClientUtils.strDateFormat);
        this.kdtEntry.getColumn(TB_CONVERTDATE).setEditor((ICellEditor)editorDate);
        this.kdtEntry.getColumn(TB_CONVERTDATE).getStyleAttributes().setNumberFormat(SCMClientUtils.strDateFormat);
        KDComboBox cbEntryStatus = new KDComboBox();
        cbEntryStatus.addItems(EntryBaseStatusEnum.getEnumList().toArray());
        this.kdtEntry.getColumn(TB_BASESTATUS).setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)cbEntryStatus));
    }

    private void loadFieldsBefore() throws Exception {
        this.initFetchData();
        this.kdtEntry.removeKDTEditListener((KDTEditListener)this);
    }

    private void loadFieldsAfter() throws Exception {
        if (this.editData == null) {
            return;
        }
        this.storageOrgUnit = this.editData.getStorageOrgUnit();
        for (int i = 0; i < this.editData.getEntry().size(); ++i) {
            this.setColumnControl(i, true);
        }
        this.syncOldData((IObjectValue)this.editData);
        this.kdtEntry.addKDTEditListener((KDTEditListener)this);
    }

    private void storeFieldsBefore() throws Exception {
    }

    private void storeFieldsAfter() throws Exception {
        if (this.editData != null && this.editData.getEntry() != null) {
            for (int i = this.editData.getEntry().size() - 1; i > 0; --i) {
                if (this.editData.getEntry().get(i).getMaterial() != null) continue;
                this.editData.getEntry().removeObject(i);
            }
        }
    }

    protected KDBizPromptBox getMainBizOrg() {
        return this.prmtStorageOrgUnit;
    }

    public KDBizPromptBox getMainOrgUnit() {
        return this.prmtStorageOrgUnit;
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Storage;
    }

    protected int getDefaultOrgMask() {
        return 18;
    }

    protected void initNeedMainOrgF7s() {
        this.prmtMaterial = this.getBizMaterialF7(this.getDetailTable().getColumn(TB_MATERIAL), null);
        this.setNeedMainOrgF7s(new KDBizPromptBox[]{this.prmtMaterial});
    }

    protected KDTable getDetailTable() {
        return this.kdtEntry;
    }

    public KDTextField getNumTextField() {
        return this.txtNumber;
    }

    private void setColumnControl(int rowIndex, boolean isOnload) throws Exception {
        KDTable table = this.getDetailTable();
        MaterialInfo material = (MaterialInfo)table.getCell(rowIndex, TB_MATERIAL).getValue();
        if (material == null) {
            return;
        }
        int baseQtyPrecision = 2;
        int qtyPrecision = 2;
        MeasureUnitInfo baseUnit = (MeasureUnitInfo)table.getCell(rowIndex, TB_BASEUNIT).getValue();
        MeasureUnitInfo unit = (MeasureUnitInfo)table.getCell(rowIndex, TB_UNIT).getValue();
        if (baseUnit != null) {
            baseQtyPrecision = this.fetchData.getUnitPrecision(material.getId().toString(), baseUnit.getId().toString());
        }
        PlanOrderClientUtils.changePrecision(this.kdtEntry, rowIndex, TBS_BASEQTY, baseQtyPrecision);
        if (unit != null) {
            qtyPrecision = this.fetchData.getUnitPrecision(material.getId().toString(), unit.getId().toString());
        }
        PlanOrderClientUtils.changePrecision(this.kdtEntry, rowIndex, TBS_QTY, qtyPrecision);
        EntryBaseStatusEnum entryStatus = (EntryBaseStatusEnum)this.kdtEntry.getCell(rowIndex, TB_BASESTATUS).getValue();
        if (EntryBaseStatusEnum.RELEASED.equals((Object)entryStatus) || EntryBaseStatusEnum.CLOSED.equals((Object)entryStatus)) {
            InvClientUtils.setRowLock(this.kdtEntry, rowIndex, null, true);
        }
    }

    protected void setColumnProperty(MaterialInfo materialInfo, int rowIndex, int colIndex, boolean isOnload) throws Exception {
        this.setColumnControl(rowIndex, isOnload);
    }

    protected HashMap getQueryCondition() throws Exception {
        HashMap<String, Object> hm = new HashMap<String, Object>();
        StorageOrgUnitInfo sou = (StorageOrgUnitInfo)this.prmtStorageOrgUnit.getData();
        if (sou != null) {
            hm.put("STORAGEORGUNIT", sou);
        }
        boolean isTableFocus = SCMClientUtils.isTableFocus((KDTable)this.kdtEntry);
        hm.put("TABLEHASFOCUS", isTableFocus);
        KDTSelectBlock selectBlock = this.kdtEntry.getSelectManager().get();
        if (selectBlock != null) {
            int rowIndex = selectBlock.getTop();
            IRow row = this.kdtEntry.getRow(rowIndex);
            if (row == null) {
                return hm;
            }
            ICell cell = row.getCell(TB_MATERIAL);
            MaterialInfo material = (MaterialInfo)cell.getValue();
            hm.put("MATERIAL", material);
            cell = row.getCell(TB_UNIT);
            MeasureUnitInfo aMeasureUnitInfo = (MeasureUnitInfo)cell.getValue();
            if (aMeasureUnitInfo != null && aMeasureUnitInfo.getId() != null) {
                hm.put("UNIT", aMeasureUnitInfo.getId().toString());
            }
            hm.put("TABLEHASFOCUS", this.kdtEntry.hasFocus());
        }
        return hm;
    }

    protected String getEntryMaterialFieldName() {
        return TB_MATERIAL;
    }

    protected SCMFetchDataCondition buildCondition() {
        SCMFetchDataCondition condition = new SCMFetchDataCondition();
        if (this.editData == null || this.editData.getEntry() == null) {
            return condition;
        }
        condition.setFetchID(true);
        condition.setFetchNumber(true);
        condition.setFetchName(true);
        condition.setFetchBaseUnit(true);
        condition.setFetchAssistUnit(true);
        condition.setFetchAsstAttrType(true);
        condition.setFetchPricePrecision(true);
        condition.setFetchSou(true);
        condition.setFetchIsNegative(true);
        condition.setFetchInventoryUnit(true);
        condition.setFetchUnitPrecision(true);
        condition.setFetchBaseUnitPrecision(true);
        String[] materialPKs = new String[this.editData.getEntry().size()];
        String[] unitPKs = new String[this.editData.getEntry().size()];
        String[] baseUnitPKs = new String[this.editData.getEntry().size()];
        for (int i = 0; i < this.editData.getEntry().size(); ++i) {
            MeasureUnitInfo baseUnit;
            MaterialInfo material = this.editData.getEntry().get(i).getMaterial();
            if (material != null) {
                materialPKs[i] = material.getId().toString();
            } else if (this.editData.getEntry().size() == 1) {
                materialPKs = null;
            }
            MeasureUnitInfo unit = this.editData.getEntry().get(i).getUnit();
            if (unit != null) {
                unitPKs[i] = unit.getId().toString();
            }
            if ((baseUnit = this.editData.getEntry().get(i).getBaseUnit()) == null) continue;
            baseUnitPKs[i] = baseUnit.getId().toString();
        }
        condition.setMaterialPKs(materialPKs);
        condition.setUnitPKs(unitPKs);
        condition.setBaseUnitPKs(baseUnitPKs);
        condition.setSou(this.editData.getStorageOrgUnit());
        return condition;
    }

    private void planQtyChanged(int rowIndex) {
        MaterialInfo material = (MaterialInfo)this.kdtEntry.getCell(rowIndex, TB_MATERIAL).getValue();
        MeasureUnitInfo unit = (MeasureUnitInfo)this.kdtEntry.getCell(rowIndex, TB_UNIT).getValue();
        MeasureUnitInfo baseUnit = (MeasureUnitInfo)this.kdtEntry.getCell(rowIndex, TB_BASEUNIT).getValue();
        if (material == null) {
            return;
        }
        BigDecimal planQty = (BigDecimal)this.kdtEntry.getCell(rowIndex, TB_PLANQTY).getValue();
        if (planQty == null) {
            planQty = ZERO;
        }
        if (material != null && unit != null && baseUnit != null) {
            BigDecimal planBaseQty = InvClientUtils.getBaseUnitQty(unit, material, planQty);
            this.kdtEntry.getCell(rowIndex, TB_PLANBASEQTY).setValue((Object)planBaseQty);
        }
    }

    private void tableValueChanged(KDTEditEvent e) throws Exception {
        KDTable table = (KDTable)e.getSource();
        Object oldValue = e.getOldValue();
        Object newValue = e.getValue();
        if (oldValue == null && newValue == null || oldValue != null && oldValue.equals(newValue)) {
            return;
        }
        int selectRow = e.getRowIndex();
        int selectCol = e.getColIndex();
        String selectColName = table.getColumnKey(selectCol);
        if (TB_PLANQTY.equals(selectColName)) {
            this.planQtyChanged(selectRow);
        }
    }

    public void editStarting(KDTEditEvent e) {
    }

    public void editStarted(KDTEditEvent e) {
    }

    public void editValueChanged(KDTEditEvent e) {
    }

    public void editStopping(KDTEditEvent e) {
    }

    public void editStopped(KDTEditEvent e) {
        try {
            this.tableValueChanged(e);
        }
        catch (Exception ex) {
            this.handUIException(ex);
        }
    }

    public void editCanceled(KDTEditEvent e) {
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        if (this.editData == null) {
            return;
        }
        super.actionSubmit_actionPerformed(e);
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        int n = this.editData.getEntry().size();
        for (int i = 0; i < n; ++i) {
            if (!EntryBaseStatusEnum.RELEASED.equals((Object)this.editData.getEntry().get(i).getBaseStatus()) && !EntryBaseStatusEnum.CLOSED.equals((Object)this.editData.getEntry().get(i).getBaseStatus())) continue;
            MsgBox.showError((Component)((Object)this), (String)PlanOrderClientUtils.getResource("BillCantRemove"));
            SysUtil.abort();
        }
        super.actionRemove_actionPerformed(e);
    }

    public void actionRemoveLine_actionPerformed(ActionEvent e) throws Exception {
        super.actionRemoveLine_actionPerformed(e);
    }

    protected void beforeRemoveLine(KDTable talbe, IObjectValue detailData) {
        PlanOrderEntryInfo entry;
        if (detailData != null && (EntryBaseStatusEnum.RELEASED.equals((Object)(entry = (PlanOrderEntryInfo)detailData).getBaseStatus()) || EntryBaseStatusEnum.CLOSED.equals((Object)entry.getBaseStatus()))) {
            MsgBox.showError((Component)((Object)this), (String)PlanOrderClientUtils.getResource("BillCantRemove"));
            SysUtil.abort();
        }
    }

    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        if (this.editData == null) {
            return;
        }
        this.invokePrintFunction(e, true);
    }

    public void actionPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        if (this.editData == null) {
            return;
        }
        this.invokePrintFunction(e, false);
    }

    protected void invokePrintFunction(ActionEvent e, boolean noPreview) throws Exception {
        this.invokePrintFunction(noPreview);
    }

    protected IMetaDataPK getTDQueryPK() {
        return new MetaDataPK("com.kingdee.eas.scm.im.inv.PlanOrdrPrintQuery");
    }

    protected String getTDFileName() {
        return "/SCM/IM/StoragePlan/PlanOrdrBill";
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("bizDate"));
        return sic;
    }
}

