/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.client;

import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.scm.common.EntryBaseStatusEnum;
import com.kingdee.eas.scm.common.client.ISCMBillStatusControl;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.filter.ColConnFilterElement;
import com.kingdee.eas.scm.common.filter.CompositeFilterElement;
import com.kingdee.eas.scm.common.filter.FilterElement;
import com.kingdee.eas.scm.common.filter.RangeFilterElement;
import com.kingdee.eas.scm.common.filter.SingleFilterElement;
import com.kingdee.eas.scm.common.util.SCMQueryFormat;
import com.kingdee.eas.scm.common.verify.VerifyItem;
import com.kingdee.eas.scm.common.verify.VerifyType;
import com.kingdee.eas.scm.im.inv.client.AbstractPlanOrderFilterUI;
import com.kingdee.eas.scm.im.inv.client.InvClientUtils;
import com.kingdee.eas.scm.im.inv.client.PlanOrderClientUtils;
import java.awt.Component;
import org.apache.log4j.Logger;

public class PlanOrderFilterUI
extends AbstractPlanOrderFilterUI
implements ISCMBillStatusControl,
DataChangeListener {
    private static final long serialVersionUID = 5191530863029962103L;
    private static final Logger logger = CoreUIObject.getLogger(PlanOrderFilterUI.class);

    public PlanOrderFilterUI() throws Exception {
        SCMQueryFormat.formatBillStatus((ISCMBillStatusControl)this, (KDComboBox)this.cbxEntryStatus);
        this.getElementsInfo();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.setF7Filter();
        this.setDefaultValue();
        if (this.getMainBizOrgF7().getText() != null) {
            this.mainOrgChanged();
        }
        this.prmtStorageOrgUnit.setEnabledMultiSelection(true);
        this.prmtStorageOrgUnit.addDataChangeListener((DataChangeListener)this);
    }

    private void getElementsInfo() {
        CompositeFilterElement elements = new CompositeFilterElement(0);
        elements.add((FilterElement)new RangeFilterElement("number", (Component)this.prmtNumberFrom, (Component)this.prmtNumberTo));
        elements.add((FilterElement)new RangeFilterElement("material.number", (Component)this.prmtMaterialFrom, (Component)this.prmtMaterialTo));
        CompositeFilterElement dateElements = new CompositeFilterElement(0);
        dateElements.add((FilterElement)new RangeFilterElement("entry.planDate", (Component)this.pkPlanDateFrom, (Component)this.pkPlanDateTo));
        dateElements.addVerifyItem(new VerifyItem(VerifyType.LESS_EQUAL_TYPE, SCMClientUtils.getResource((String)"CompareDate")));
        elements.add((FilterElement)dateElements);
        ColConnFilterElement mainOrgElement = new ColConnFilterElement("storageOrgUnit.id", (Component)this.prmtStorageOrgUnit);
        mainOrgElement.addVerifyItem(new VerifyItem(VerifyType.REQUIRED_TYPE, PlanOrderClientUtils.getResource("storageIsNull")));
        elements.add((FilterElement)mainOrgElement);
        elements.add((FilterElement)new SingleFilterElement("planner.name", (Component)this.prmtPlanner));
        elements.add((FilterElement)new SingleFilterElement("entry.baseStatus", (Component)this.cbxEntryStatus, (Object)EntryBaseStatusEnum.NULL));
        this.getFilterManager().setElement((FilterElement)elements);
        this.getFilterManager().setMainOrgElement((FilterElement)mainOrgElement, "storageOrgUnit.id");
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Storage;
    }

    public KDBizPromptBox getMainBizOrgF7() {
        return this.prmtStorageOrgUnit;
    }

    protected String getViewPermission() {
        return "planOrder_view";
    }

    protected String getPropertyOfMainBizOrg() {
        return "storageOrgUnit.id";
    }

    private void setF7Filter() throws Exception {
        this.setBizMaterialF7(this.prmtMaterialFrom, false, null);
        this.setBizMaterialF7(this.prmtMaterialTo, false, null);
        EntityViewInfo viewNumber = InvClientUtils.getBizStorageFilter();
        this.prmtNumberFrom.setEntityViewInfo(viewNumber);
        this.prmtNumberTo.setEntityViewInfo(viewNumber);
        this.setNeedMainOrgF7s(new KDBizPromptBox[]{this.prmtMaterialFrom, this.prmtMaterialTo});
        this.setBillNumberF7s(new KDBizPromptBox[]{this.prmtNumberFrom, this.prmtNumberTo});
    }

    protected void setDefaultValue() {
        SCMQueryFormat.formatStartTime((KDDatePicker)this.pkPlanDateFrom);
        SCMQueryFormat.formatEndTime((KDDatePicker)this.pkPlanDateTo);
    }

    public Object[] getUnVisibleBillStatus() {
        return new Object[]{EntryBaseStatusEnum.VERSION, EntryBaseStatusEnum.ALTERING, EntryBaseStatusEnum.ADD, EntryBaseStatusEnum.TEMPORARILYSAVED, EntryBaseStatusEnum.SUBMITED, EntryBaseStatusEnum.DELETED, EntryBaseStatusEnum.AUDITED, EntryBaseStatusEnum.BLOCKED};
    }

    public Object[] getAdditiveBillStatus() {
        return null;
    }

    public void dataChanged(DataChangeEvent e) {
        if (e.getOldValue() != null && e.getOldValue().equals(e.getNewValue())) {
            return;
        }
    }
}

