/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.eas.base.commonquery.client.CustomerQueryPanel;
import com.kingdee.eas.basedata.framework.util.KDTableUtil;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.batchaction.ActionLevelEnum;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.framework.client.CoreBillListUI;
import com.kingdee.eas.scm.common.EntryBaseStatusEnum;
import com.kingdee.eas.scm.common.action.ActionProxy;
import com.kingdee.eas.scm.common.action.ActionProxyFactory;
import com.kingdee.eas.scm.im.inv.PlanOrderEntryFactory;
import com.kingdee.eas.scm.im.inv.PlanOrderFactory;
import com.kingdee.eas.scm.im.inv.client.AbstractPlanOrderListUI;
import com.kingdee.eas.scm.im.inv.client.InvClientUtils;
import com.kingdee.eas.scm.im.inv.client.PlanOrderClientUtils;
import com.kingdee.eas.scm.im.inv.client.PlanOrderFilterUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import javax.swing.AbstractButton;
import org.apache.log4j.Logger;

public class PlanOrderListUI
extends AbstractPlanOrderListUI {
    private static final long serialVersionUID = -4383756669310523464L;
    private static final Logger logger = CoreUIObject.getLogger(PlanOrderListUI.class);
    private static final String TB_ID = "id";
    private static final String TB_NUMBER = "number";
    private static final String TB_STORAGEORGUNIT_NAME = "storageOrgUnit.name";
    private static final String TB_ENTRY_ID = "entry.id";
    private static final String TB_ENTRY_SAFETYSTORAGE = "entry.safetyStorage";
    private static final String TB_ENTRY_INSTANTSTORAGE = "entry.instantStorage";
    private static final String TB_ENTRY_PLANQTY = "entry.planQty";
    private static final String TB_ENTRY_PLANBASEQTY = "entry.planBaseQty";
    private static final String TB_ENTRY_TOTALREQQTY = "entry.totalReqQty";
    private static final String TB_ENTRY_TOTALREQBASEQTY = "entry.totalReqBaseQty";
    private static final String TB_ENTRY_ASSOCIATEQTY = "entry.associateQty";
    private static final String TB_ENTRY_BASESTATUS = "entry.baseStatus";
    private static final String TB_CREATOR_NAME = "creator.name";
    private static final String TB_CREATETIME = "createTime";
    private static final String TB_LASTUPDATEUSER_NAME = "lastUpdateUser.name";
    private static final String TB_LASTUPDATETIME = "lastUpdateTime";
    PlanOrderFilterUI filterUI = null;

    protected OrgType getMainBizOrgType() {
        return OrgType.Storage;
    }

    protected String getEditUIName() {
        return "com.kingdee.eas.scm.im.inv.client.PlanOrderEditUI";
    }

    protected ICoreBase getBizInterface() throws Exception {
        return PlanOrderFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext());
    }

    public String getEntriesPKName() {
        return TB_ENTRY_ID;
    }

    public String[] getMergeColumnKeys() {
        return new String[]{TB_ID, TB_NUMBER, TB_STORAGEORGUNIT_NAME, TB_LASTUPDATEUSER_NAME, TB_LASTUPDATETIME, TB_CREATOR_NAME, TB_CREATETIME};
    }

    protected CustomerQueryPanel getFilterUI() throws Exception {
        if (this.filterUI == null) {
            this.filterUI = new PlanOrderFilterUI();
        }
        return this.filterUI;
    }

    protected String getKeyFieldName() {
        return TB_ID;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.actionAddNew.setEnabled(false);
        this.btnAddNew.setVisible(false);
        this.menuItemAddNew.setVisible(false);
        this.actionAudit.setEnabled(false);
        this.btnAudit.setVisible(false);
        this.menuItemAudit.setVisible(false);
        this.actionUnAudit.setEnabled(false);
        this.btnUnAudit.setVisible(false);
        this.menuItemUnAudit.setVisible(false);
        this.actionVoucher.setEnabled(false);
        this.btnVoucher.setVisible(false);
        this.menuItemVoucher.setVisible(false);
        this.actionDelVoucher.setEnabled(false);
        this.btnDelVoucher.setVisible(false);
        this.menuItemDelVoucher.setVisible(false);
    }

    protected String[] getQtyColumns() throws Exception {
        return new String[]{TB_ENTRY_SAFETYSTORAGE, TB_ENTRY_INSTANTSTORAGE, TB_ENTRY_PLANQTY, TB_ENTRY_PLANBASEQTY, TB_ENTRY_TOTALREQQTY, TB_ENTRY_TOTALREQBASEQTY, TB_ENTRY_ASSOCIATEQTY};
    }

    protected String getPropertyOfBizOrg(OrgType orgType) {
        return "storageOrgUnit.id";
    }

    protected boolean initDefaultFilter() {
        return this.getUIContext().get("BillQuery") == null;
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnRelease.setIcon(EASResource.getIcon((String)"imgTbtn_makeknown"));
        this.menuItemRelease.setIcon(EASResource.getIcon((String)"imgTbtn_makeknown"));
        this.btnUnRelease.setIcon(EASResource.getIcon((String)"imgTbtn_fmakeknown"));
        this.menuItemUnRelease.setIcon(EASResource.getIcon((String)"imgTbtn_fmakeknown"));
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String[] entryStatus = KDTableUtil.getSelectRowFieldValue((KDTable)this.tblMain, (String)TB_ENTRY_BASESTATUS);
        if (entryStatus != null) {
            int n = entryStatus.length;
            for (int i = 0; i < n; ++i) {
                if (!EntryBaseStatusEnum.RELEASED.toString().equals(entryStatus[i]) && !EntryBaseStatusEnum.CLOSED.toString().equals(entryStatus[i])) continue;
                MsgBox.showError((Component)((Object)this), (String)PlanOrderClientUtils.getResource("BillCantRemove"));
                SysUtil.abort();
            }
        }
        super.actionRemove_actionPerformed(e);
    }

    @Override
    public void actionRelease_actionPerformed(ActionEvent e) throws Exception {
        super.actionRelease_actionPerformed(e);
        String[] entryIDs = KDTableUtil.getSelectRowFieldValue((KDTable)this.tblMain, (String)TB_ENTRY_ID);
        if (entryIDs == null) {
            return;
        }
        ArrayList<String> entryIDList = new ArrayList<String>();
        for (int i = 0; i < entryIDs.length; ++i) {
            entryIDList.add(entryIDs[i]);
        }
        PlanOrderEntryFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext()).release(entryIDList);
        this.refresh(null);
        MsgBox.showInfo((Component)((Object)this), (String)PlanOrderClientUtils.getResource("ReleaseComplete"));
    }

    @Override
    public void actionUnRelease_actionPerformed(ActionEvent e) throws Exception {
        super.actionUnRelease_actionPerformed(e);
        String[] entryIDs = KDTableUtil.getSelectRowFieldValue((KDTable)this.tblMain, (String)TB_ENTRY_ID);
        if (entryIDs == null) {
            return;
        }
        ArrayList<String> entryIDList = new ArrayList<String>();
        for (int i = 0; i < entryIDs.length; ++i) {
            entryIDList.add(entryIDs[i]);
        }
        PlanOrderEntryFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext()).unRelease(entryIDList);
        this.refresh(null);
        MsgBox.showInfo((Component)((Object)this), (String)PlanOrderClientUtils.getResource("UnReleaseComplete"));
    }

    public boolean isSupportedBatchActions() {
        return true;
    }

    public void initBatchActions() throws BOSException {
        this.actionManager.setClzIBizFactory(ActionLevelEnum.HEAD, PlanOrderFactory.class);
        this.actionManager.setClzIBizFactory(ActionLevelEnum.ENTRY, PlanOrderEntryFactory.class);
        this.getTableSelectionHelper().setTableProperty((CoreBillListUI)this, this.mainQueryPK, this.tblMain, TB_ID, TB_ENTRY_ID, TB_NUMBER, "entry.seq", "storageOrgUnit.id");
        ActionProxy actionProxy = ActionProxyFactory.createActionProxy((BatchActionEnum)BatchActionEnum.ENTRYRELEASE, (ItemAction)this.actionRelease, (String)"release");
        this.actionManager.registerBatchAction(actionProxy, "actionRelease");
        actionProxy.bindTo((AbstractButton)this.btnRelease);
        actionProxy.bindTo((AbstractButton)this.menuItemRelease);
        actionProxy = ActionProxyFactory.createActionProxy((BatchActionEnum)BatchActionEnum.ENTRYUNRELEASE, (ItemAction)this.actionUnRelease, (String)"unRelease");
        this.actionManager.registerBatchAction(actionProxy, "actionUnRelease");
        actionProxy.bindTo((AbstractButton)this.btnUnRelease);
        actionProxy.bindTo((AbstractButton)this.menuItemUnRelease);
        super.initBatchActions();
    }

    public SelectorItemCollection getBOTPSelectors() {
        SelectorItemCollection sic = super.getBOTPSelectors();
        return sic;
    }

    protected FilterInfo getBOTPFilterByBillType(String BillTypeId, OrgType destType, String destOrgId) {
        FilterInfo filter = null;
        try {
            String billTypeId;
            HashMap botpMap;
            if (this.getBOTPViewStatus() == 1 && (botpMap = this.getBOTPMap()) != null && botpMap.containsKey("DESTBILLTYPE.ID") && !"MmEE6VBsR0KaUDQmebwhP0Y+1VI=".equals(billTypeId = botpMap.get("DESTBILLTYPE.ID").toString()) && "510b6503-0105-1000-e000-0107c0a812fd463ED552".equals(billTypeId)) {
                filter = new FilterInfo();
                CompanyOrgUnitInfo destCom = (CompanyOrgUnitInfo)botpMap.get("MAINBIZORG");
                OrgUnitCollection sous = InvClientUtils.getStorageUnitInfo(destCom);
                HashSet<String> souIDs = new HashSet<String>();
                for (int i = 0; i < sous.size(); ++i) {
                    souIDs.add(sous.get(i).getId().toString());
                }
                if (souIDs.size() > 0) {
                    filter.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", souIDs, CompareType.INCLUDE));
                }
            }
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        return filter;
    }

    protected IMetaDataPK getTDQueryPK() {
        return new MetaDataPK("com.kingdee.eas.scm.im.inv.PlanOrdrPrintQuery");
    }

    protected String getTDFileName() {
        return "/SCM/IM/StoragePlan/PlanOrdrBill";
    }

    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrint_actionPerformed(e);
    }

    public void actionPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrintPreview_actionPerformed(e);
    }

    protected boolean isSupportDynQuery() {
        return true;
    }

    public String getsourceBillEntryId() {
        return "entry.sourceBillEntryId";
    }
}

