/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IBlock;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTCell;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDTabbedPane;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.IItemAction;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.ui.util.IUIActionPostman;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.CustomerQueryPanel;
import com.kingdee.eas.base.dap.client.DAPFromMultiBillTypeEditUI;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.base.param.ParamSimpleInfo;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolCollection;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolFactory;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.PurchaseOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.framework.FrameWorkException;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.framework.batchaction.ActionLevelEnum;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.framework.batchaction.BatchSelectionEntries;
import com.kingdee.eas.framework.batchaction.BatchSelectionEntry;
import com.kingdee.eas.framework.client.CoreBillListUI;
import com.kingdee.eas.framework.client.IIDList;
import com.kingdee.eas.framework.query.QuickFilteringSupportItems;
import com.kingdee.eas.scm.cal.IWriteOffGroup;
import com.kingdee.eas.scm.cal.WriteOffGroupFactory;
import com.kingdee.eas.scm.common.ISCMBillCommonFacade;
import com.kingdee.eas.scm.common.SCMBillCommonFacadeFactory;
import com.kingdee.eas.scm.common.client.CCRelationBillListImpl;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.util.SCMConstant;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.framework.writeoff.IWriteOffCommonFacade;
import com.kingdee.eas.scm.framework.writeoff.WriteOffCommonFacadeFactory;
import com.kingdee.eas.scm.im.inv.IPurInWarehsBill;
import com.kingdee.eas.scm.im.inv.IPurInWarehsEntry;
import com.kingdee.eas.scm.im.inv.IRelationOfChildAndParentFacade;
import com.kingdee.eas.scm.im.inv.MaterialReqBillInfo;
import com.kingdee.eas.scm.im.inv.PurInWarehsBillCollection;
import com.kingdee.eas.scm.im.inv.PurInWarehsBillFactory;
import com.kingdee.eas.scm.im.inv.PurInWarehsBillInfo;
import com.kingdee.eas.scm.im.inv.PurInWarehsEntryCollection;
import com.kingdee.eas.scm.im.inv.PurInWarehsEntryFactory;
import com.kingdee.eas.scm.im.inv.PurInWarehsEntryInfo;
import com.kingdee.eas.scm.im.inv.RelationOfChildAndParentFacadeFactory;
import com.kingdee.eas.scm.im.inv.client.AbstractPurInWarehsBillListUI;
import com.kingdee.eas.scm.im.inv.client.InvClientUtils;
import com.kingdee.eas.scm.im.inv.client.MergeSplitedBillUIHelper;
import com.kingdee.eas.scm.im.inv.client.PurInWarehsFilterUI;
import com.kingdee.eas.scm.im.inv.client.SplitBillDateUI;
import com.kingdee.eas.scm.sm.pur.CheckPriceResult;
import com.kingdee.eas.scm.sm.pur.IPurServiceFacade;
import com.kingdee.eas.scm.sm.pur.PurPriceParam;
import com.kingdee.eas.scm.sm.pur.PurPriceParamCollection;
import com.kingdee.eas.scm.sm.pur.PurServiceFacadeFactory;
import com.kingdee.eas.scm.util.SCMSelectorFactory;
import com.kingdee.eas.scm.util.collection.CollectionUtil;
import com.kingdee.eas.tools.datatask.DatataskParameter;
import com.kingdee.eas.tools.datatask.client.DatataskCaller;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;

public class PurInWarehsBillListUI
extends AbstractPurInWarehsBillListUI {
    private static final long serialVersionUID = 6031564893219017533L;
    public static final String RES_InvUI = "com.kingdee.eas.basedata.scm.im.inv.client.InvResource";
    public static final String MER_InvUI = "com.kingdee.eas.scm.im.inv.client.InvResource";
    private PurInWarehsFilterUI filterUI = null;
    private boolean tag = false;
    private List<String> writeOffRPurInIdList = null;
    private static final String Resource_subContract = "com.kingdee.eas.scm.sm.sc.SubContractResource";
    private String[] subColumn = new String[]{"scWrittenOffQty", "scWrittenOffBaseQty", "scUnWrittenOffQty", "scUnWrittenOffBaseQty", "unitMaterialCost", "materialCost"};
    private QuickFilteringSupportItems qfsi = new QuickFilteringSupportItems(true, true);

    public void actionCreateTo_actionPerformed(ActionEvent e) throws Exception {
        this.getUIContext().put("TransferOrderBillType", "transferOrderBill");
        super.actionCreateTo_actionPerformed(e);
    }

    public void actionDelVoucher_actionPerformed(ActionEvent e) throws Exception {
        ArrayList list = this.getSelectedIdValues();
        if (list.isEmpty()) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            return;
        }
        String[] ids = null;
        Object[] obj = list.toArray();
        int length = obj.length;
        ids = new String[length];
        System.arraycopy(obj, 0, ids, 0, length);
        IWriteOffGroup iw = WriteOffGroupFactory.getRemoteInstance();
        CompanyOrgUnitInfo cou = this.getCompanyOrgUnitInfo();
        if (cou != null) {
            iw.validateWriteOffVoucher(ids, cou.getId().toString(), "103");
        }
        super.actionDelVoucher_actionPerformed(e);
    }

    @Override
    public void actionDirectMaterialBill_actionPerformed(ActionEvent e) throws Exception {
        this.tag = true;
        if (this.getUIContext() != null) {
            this.getUIContext().put("UIClassParam", "isSCMBill");
        }
        super.actionCreateTo_actionPerformed(e);
        this.tag = false;
    }

    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        super.actionQuery_actionPerformed(e);
        if (!this.isSubContractBill()) {
            SCMClientUtils.hideColumns((KDTable)this.tblMain, (String[])this.subColumn, (boolean)true);
        }
    }

    @Override
    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        if (this.getUIContext().get("BillQuery") != null) {
            for (int i = 0; i < this.tblMain.getSelectManager().size(); ++i) {
                KDTSelectBlock sb = this.tblMain.getSelectManager().get(i);
                for (int j = sb.getTop(); j <= sb.getBottom(); ++j) {
                    boolean isVouchered = (Boolean)this.tblMain.getCell(j, "isVouchered").getValue();
                    boolean isReversed = (Boolean)this.tblMain.getCell(j, "isReversed").getValue();
                    if (isVouchered) {
                        MsgBox.showInfo((Component)((Object)this), (String)InvClientUtils.getResource("CANT_EDIT_IF_VOUCHERED"));
                        SysUtil.abort();
                    }
                    if (!isReversed) continue;
                    MsgBox.showInfo((Component)((Object)this), (String)InvClientUtils.getResource("CANT_EDIT_IF_ISREVERSED"));
                    SysUtil.abort();
                }
            }
        }
        super.actionEdit_actionPerformed(e);
    }

    public void actionMultiPrint_actionPerformed(ActionEvent arg0) throws Exception {
        super.actionMultiPrint_actionPerformed(arg0);
    }

    public void actionMultiPrintPreview_actionPerformed(ActionEvent arg0) throws Exception {
        super.actionMultiPrintPreview_actionPerformed(arg0);
    }

    @Override
    public void actionSplitBillByHand_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList ids = super.getSelectedIdValues();
        if (ids.size() != 1) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.invAddResource, (String)"MUST_ONE_BILL_BYSPLIT_BYHAND"));
            return;
        }
        HashMap param = new HashMap();
        IPurInWarehsBill iPurInWarehsBill = (IPurInWarehsBill)this.getBizInterface();
        HashMap msgHm = iPurInWarehsBill.splitBillByHandByWrittenOffQty(new String[]{ids.get(0).toString()}, param);
        if (msgHm.get("error") != null) {
            MsgBox.showError((String)msgHm.get("error").toString());
            return;
        }
        String[] billIds = SCMClientUtils.getSelectRowFieldValue((KDTable)this.tblMain, (String)"id");
        this.checkNextPeriod(billIds);
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ID", (Object)this.getSelectedKeyValue());
        uiContext.put((Object)"SplitBill", (Object)"SplitBill");
        uiContext.put((Object)"HandMotherBillID", (Object)ids.get(0).toString());
        IUIWindow uiWindow = null;
        uiWindow = SwingUtilities.getWindowAncestor((Component)((Object)this)) != null && SwingUtilities.getWindowAncestor((Component)((Object)this)) instanceof JDialog ? UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(this.getEditUIName(), (Map)uiContext, null, OprtState.EDIT) : UIFactory.createUIFactory((String)this.getEditUIModal()).create(this.getEditUIName(), (Map)uiContext, null, OprtState.EDIT);
        uiWindow.show();
    }

    @Override
    public void actionSplitBill_actionPerformed(ActionEvent e) throws Exception {
        boolean isBillSplitChangeDate;
        this.checkSelected();
        String storageUnitID = this.getOrgPK(null).toString();
        ArrayList bizDateList = this.getSelectedFieldValues("bizDate");
        Date billBizDate = new Date();
        if (bizDateList != null && bizDateList.size() > 0) {
            SimpleDateFormat myFormDate = new SimpleDateFormat("yyyy-MM-dd");
            billBizDate = myFormDate.parse((String)bizDateList.get(0));
        }
        String[] orgIDs = com.kingdee.eas.basedata.framework.util.KDTableUtil.getSelectRowFieldValue((KDTable)this.tblMain, (String)"storageOrgUnit.id");
        String[] ids = SCMClientUtils.getSelectRowFieldValue((KDTable)this.tblMain, (String)"id");
        this.checkAllBillHasSamePeriod(ids);
        this.checkAllSouHasSamePeriod(orgIDs);
        CompanyOrgUnitInfo companyInfo = InvClientUtils.getCompanyInfo(storageUnitID);
        PeriodInfo billPeriodInfo = PeriodUtils.getPeriodInfo(null, (Date)billBizDate, (CompanyOrgUnitInfo)companyInfo);
        PeriodInfo currentPeriodinfo = SystemStatusCtrolUtils.getCurrentPeriod(null, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)companyInfo);
        Date bizDate = null;
        if (!billPeriodInfo.getBeginDate().before(currentPeriodinfo.getBeginDate()) && (isBillSplitChangeDate = this.getAllSouParamForSplitChangeDate(orgIDs))) {
            bizDate = this.confirmSplitBill("50957179-0105-1000-e000-015fc0a812fd463ED552", storageUnitID);
        }
        HashMap<String, Date> param = new HashMap<String, Date>();
        IPurInWarehsBill iPurInWarehsBill = (IPurInWarehsBill)this.getBizInterface();
        param.put("SplitDate", bizDate);
        HashMap msgHm = iPurInWarehsBill.checkForSplitBill(ids, param);
        if (msgHm != null && msgHm.size() > 0) {
            PurInWarehsBillCollection collection;
            if (msgHm.get("collection") != null && (collection = (PurInWarehsBillCollection)((Object)msgHm.get("collection"))) != null && collection.size() > 0) {
                if (bizDate != null) {
                    param.put("SplitDate", bizDate);
                }
                iPurInWarehsBill.splitBill(collection, param);
            }
            if (msgHm.get("NotSplitMsg") != null) {
                String succMsg = (String)msgHm.get("NotSplitMsg");
                String successInfo = EASResource.getString((String)this.invAddResource, (String)"Msg_Split_NotSuccess");
                String splitNotSuccess = EASResource.getString((String)this.invAddResource, (String)"SplitNotSuccessList");
                MsgBox.showDetailAndOK((Component)((Object)this), (String)successInfo, (String)(splitNotSuccess + "\n" + succMsg), (int)1);
            } else {
                String splitSuccess = EASResource.getString((String)this.invAddResource, (String)"Msg_Split_AllSuccess");
                MsgBox.showInfo((Component)((Object)this), (String)splitSuccess);
            }
        }
    }

    public void actionTraceUp_actionPerformed(ActionEvent e) throws Exception {
        this.getUIContext().put("TransferOrderBillType", "transferOrderBill");
        super.actionTraceUp_actionPerformed(e);
    }

    @Override
    public void actionUniteBill_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList ids = super.getSelectedIdValues();
        if (ids.size() > 1) {
            MsgBox.showInfo((String)EASResource.getString((String)MER_InvUI, (String)"onlyOne"));
            return;
        }
        String id = ids.get(0).toString();
        IRelationOfChildAndParentFacade iRelationOfChildAndParentFacade = RelationOfChildAndParentFacadeFactory.getRemoteInstance();
        iRelationOfChildAndParentFacade.judgeCanMerge(id, "783061E3");
        Map UIContext2 = this.getUIContext();
        String bosType = this.getBOSType().toString();
        MergeSplitedBillUIHelper.showMergeSplitBillUI(UIContext2, "com.kingdee.eas.scm.im.inv.client.PurInWarehsBillListUI", bosType, id);
        super.actionRefresh_actionPerformed(e);
    }

    @Override
    public void actionViewWriteOffRecord_actionPerformed(ActionEvent e) throws Exception {
        CoreBillBaseCollection bills = this.getNewBillList();
        CCRelationBillListImpl billList = new CCRelationBillListImpl((CoreBillListUI)this);
        billList.traceDown(bills, this.getEntriesPKName(), this.getUIContext());
    }

    public void actionVoucher_actionPerformed(ActionEvent e) throws Exception {
        int result;
        int i;
        this.checkSelected();
        ArrayList idList = this.getSelectedIdValues();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("storageOrgUnit.id"));
        sic.add(new SelectorItemInfo("isInitBill"));
        sic.add(new SelectorItemInfo("entry.companyOrgUnit"));
        filter.getFilterItems().add(new FilterItemInfo("id", new HashSet(idList), CompareType.INCLUDE));
        view.setFilter(filter);
        view.setSelector(sic);
        PurInWarehsBillCollection coll = PurInWarehsBillFactory.getRemoteInstance().getPurInWarehsBillCollection(view);
        String[] orgIDs = new String[coll.size()];
        String[] isCreateVoucher = new String[coll.size()];
        boolean hasInitBill = false;
        boolean hasNomalBill = false;
        for (i = 0; i < coll.size(); ++i) {
            orgIDs[i] = coll.get(i).getStorageOrgUnit().getId().toString();
            isCreateVoucher[i] = Boolean.toString(coll.get(i).isIsInitBill());
        }
        if (!InvClientUtils.checkStorageConsignSameCompany(orgIDs)) {
            return;
        }
        for (i = 0; i < isCreateVoucher.length; ++i) {
            if (!isCreateVoucher[i].equals("true")) continue;
            hasInitBill = true;
            break;
        }
        for (i = 0; i < isCreateVoucher.length; ++i) {
            if (!isCreateVoucher[i].equals("false")) continue;
            hasNomalBill = true;
            break;
        }
        IParamControl ipc = ParamControlFactory.getRemoteInstance();
        String dischargeType = ipc.getParamValue((IObjectPK)new ObjectUuidPK(coll.get(0).getEntry().get(0).getCompanyOrgUnit().getId()), "SCM_CAL_001");
        if (hasInitBill && hasNomalBill || hasInitBill && !dischargeType.equals("1")) {
            String isSelectInitBill = EASResource.getString((String)this.invAddResource, (String)"isInitBill");
            MsgBox.showInfo((String)isSelectInitBill);
            this.abort();
        }
        if (hasInitBill && !hasNomalBill && 2 == (result = MsgBox.showConfirm2((String)EASResource.getString((String)this.invAddResource, (String)"InitPurInVourcherInfo")))) {
            this.abort();
        }
        HashSet<String> set = new HashSet<String>();
        int size = orgIDs.length;
        for (int i2 = 0; i2 < size; ++i2) {
            set.add(orgIDs[i2]);
        }
        Object[] orgIDs2 = set.toArray();
        try {
            IPermission iPer = PermissionFactory.getRemoteInstance();
            UserInfo userInfo = SysContext.getSysContext().getCurrentUserInfo();
            ObjectUuidPK userPK = new ObjectUuidPK(userInfo.getId());
            String tempOrgID = "";
            for (int index = 0; index < orgIDs2.length; ++index) {
                if (tempOrgID.equals(orgIDs2[index].toString())) continue;
                iPer.checkFunctionPermission((IObjectPK)userPK, (IObjectPK)new ObjectUuidPK(BOSUuid.read((String)orgIDs2[index].toString())), "purinwarehs_generalVoucher");
                tempOrgID = orgIDs2[index].toString();
            }
        }
        catch (Exception ex) {
            this.handUIException(ex);
            return;
        }
        OrgUnitInfo orgUnitInfo = new OrgUnitInfo();
        orgUnitInfo.setId(BOSUuid.read((String)orgIDs[0]));
        this.getUIContext().put(this.getMainBizOrgType(), orgUnitInfo);
        super.actionVoucher_actionPerformed(e);
    }

    public String[] getAmountColumns() {
        return new String[]{"writtenOffAmount", "unWriteOffAmount", "localAmount", "tax", "localTax", "standardCost", "actualCost", "totalStandardCost", "totalActualCost", "receiveAmount", "imputedCost", "amount", "totalAmount", "totalLocalAmount", "purchaseCost", "taxAmount", "localTaxAmount"};
    }

    @Override
    public SelectorItemCollection getBOTPSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("creator.*"));
        sic.add(new SelectorItemInfo("lastUpdateUser.*"));
        sic.add(new SelectorItemInfo("CU.*"));
        sic.add(new SelectorItemInfo("handler.*"));
        sic.add(new SelectorItemInfo("auditor.*"));
        sic.add(new SelectorItemInfo("sourceBillType.*"));
        sic.add(new SelectorItemInfo("modifier.*"));
        sic.add(new SelectorItemInfo("stocker.*"));
        sic.add(new SelectorItemInfo("voucher.*"));
        sic.add(new SelectorItemInfo("entry.sourceBillType.*"));
        sic.add(new SelectorItemInfo("entry.reasonCode.*"));
        sic.add(new SelectorItemInfo("entry.storageOrgUnit.*"));
        sic.add(new SelectorItemInfo("entry.project.*"));
        sic.add(new SelectorItemInfo("entry.trackNumber.*"));
        sic.add(new SelectorItemInfo("entry.balanceSupplier.*"));
        sic.add(new SelectorItemInfo("entry.receiveStorageOrgUnit.*"));
        sic.add(new SelectorItemInfo("entry.customer.*"));
        sic.add(new SelectorItemInfo("entry.outWarehouse.*"));
        sic.add(new SelectorItemInfo("entry.outLocation.*"));
        sic.add(new SelectorItemInfo("paymentType.*"));
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("bizDate"));
        sic.add(new SelectorItemInfo("supplier.id"));
        sic.add(new SelectorItemInfo("supplier.number"));
        sic.add(new SelectorItemInfo("supplier.name"));
        sic.add(new SelectorItemInfo("supplier.isInternalCompany"));
        sic.add(new SelectorItemInfo("billType.id"));
        sic.add(new SelectorItemInfo("billType.number"));
        sic.add(new SelectorItemInfo("billType.name"));
        sic.add(new SelectorItemInfo("bizType.id"));
        sic.add(new SelectorItemInfo("bizType.number"));
        sic.add(new SelectorItemInfo("bizType.name"));
        sic.add(new SelectorItemInfo("transactionType.id"));
        sic.add(new SelectorItemInfo("transactionType.number"));
        sic.add(new SelectorItemInfo("transactionType.name"));
        sic.add(new SelectorItemInfo("adminOrgUnit.id"));
        sic.add(new SelectorItemInfo("adminOrgUnit.number"));
        sic.add(new SelectorItemInfo("adminOrgUnit.name"));
        sic.add(new SelectorItemInfo("entry.*"));
        sic.add(new SelectorItemInfo("entry.companyOrgUnit.id"));
        sic.add(new SelectorItemInfo("entry.companyOrgUnit.name"));
        sic.add(new SelectorItemInfo("entry.companyOrgUnit.number"));
        sic.add(new SelectorItemInfo("entry.material.id"));
        sic.add(new SelectorItemInfo("entry.material.number"));
        sic.add(new SelectorItemInfo("entry.material.name"));
        sic.add(new SelectorItemInfo("entry.material.model"));
        sic.add(new SelectorItemInfo("entry.material.pricePrecision"));
        sic.add(new SelectorItemInfo("entry.material.assistUnit.id"));
        sic.add(new SelectorItemInfo("entry.material.assistUnit.number"));
        sic.add(new SelectorItemInfo("entry.material.assistUnit.name"));
        sic.add(new SelectorItemInfo("entry.baseUnit.id"));
        sic.add(new SelectorItemInfo("entry.baseUnit.number"));
        sic.add(new SelectorItemInfo("entry.baseUnit.name"));
        sic.add(new SelectorItemInfo("entry.unit.id"));
        sic.add(new SelectorItemInfo("entry.unit.number"));
        sic.add(new SelectorItemInfo("entry.unit.name"));
        sic.add(new SelectorItemInfo("entry.assistUnit.id"));
        sic.add(new SelectorItemInfo("entry.assistUnit.name"));
        sic.add(new SelectorItemInfo("entry.assistUnit.number"));
        sic.add(new SelectorItemInfo("entry.stocker.id"));
        sic.add(new SelectorItemInfo("entry.stocker.number"));
        sic.add(new SelectorItemInfo("entry.stocker.name"));
        sic.add(new SelectorItemInfo("entry.location.id"));
        sic.add(new SelectorItemInfo("entry.location.number"));
        sic.add(new SelectorItemInfo("entry.location.name"));
        sic.add(new SelectorItemInfo("entry.qty"));
        sic.add(new SelectorItemInfo("entry.amount"));
        sic.add(new SelectorItemInfo("entry.baseQty"));
        sic.add(new SelectorItemInfo("entry.price"));
        sic.add(new SelectorItemInfo("entry.assistProperty.id"));
        sic.add(new SelectorItemInfo("entry.assistProperty.name"));
        sic.add(new SelectorItemInfo("entry.assistProperty.number"));
        sic.add(new SelectorItemInfo("entry.purOrder"));
        sic.add(new SelectorItemInfo("entry.purOrderEntry"));
        sic.add(new SelectorItemInfo("entry.coreBillType.id"));
        sic.add(new SelectorItemInfo("entry.coreBillType.name"));
        sic.add(new SelectorItemInfo("entry.coreBillType.number"));
        sic.add(new SelectorItemInfo("entry.totalMoveQty"));
        sic.add(new SelectorItemInfo("storageOrgUnit.id"));
        sic.add(new SelectorItemInfo("storageOrgUnit.number"));
        sic.add(new SelectorItemInfo("storageOrgUnit.name"));
        sic.add(new SelectorItemInfo("storageOrgUnit.cu.id"));
        sic.add(new SelectorItemInfo("entry.warehouse.id"));
        sic.add(new SelectorItemInfo("entry.warehouse.number"));
        sic.add(new SelectorItemInfo("entry.warehouse.name"));
        sic.add(new SelectorItemInfo("entry.warehouse.hasLocation"));
        sic.add(new SelectorItemInfo("entry.warehouse.whman.number"));
        sic.add(new SelectorItemInfo("entry.warehouse.whman.name"));
        sic.add(new SelectorItemInfo("entry.location.id"));
        sic.add(new SelectorItemInfo("entry.location.number"));
        sic.add(new SelectorItemInfo("entry.location.name"));
        sic.add(new SelectorItemInfo("currency.id"));
        sic.add(new SelectorItemInfo("currency.number"));
        sic.add(new SelectorItemInfo("currency.name"));
        sic.add(new SelectorItemInfo("currency.precision"));
        sic.add(new SelectorItemInfo("exchangeRate"));
        sic.add(new SelectorItemInfo("receiptAmount"));
        sic.add(new SelectorItemInfo("entry.purchaseOrgUnit.id"));
        sic.add(new SelectorItemInfo("entry.purchaseOrgUnit.number"));
        sic.add(new SelectorItemInfo("entry.purchaseOrgUnit.name"));
        sic.add(new SelectorItemInfo("entry.purchaseGroup.id"));
        sic.add(new SelectorItemInfo("entry.purchaseGroup.number"));
        sic.add(new SelectorItemInfo("entry.purchaseGroup.name"));
        sic.add(new SelectorItemInfo("entry.purchasePerson.id"));
        sic.add(new SelectorItemInfo("entry.purchasePerson.number"));
        sic.add(new SelectorItemInfo("entry.purchasePerson.name"));
        sic.add(new SelectorItemInfo("entry.canDirectReqQty"));
        sic.add(new SelectorItemInfo("entry.canDirectReqBaseQty"));
        return sic;
    }

    public List getDestBosTypeForBotp(CoreBillBaseCollection srcBillInfos, List destBosTypeList) {
        if (this.tag) {
            destBosTypeList.clear();
            String materialReqBillType = new MaterialReqBillInfo().getBOSType().toString();
            destBosTypeList.add(materialReqBillType);
            return destBosTypeList;
        }
        if (destBosTypeList != null && destBosTypeList.size() != 0 && this.isSubContractBill()) {
            destBosTypeList.remove("256D05E2");
        }
        return super.getDestBosTypeForBotp(srcBillInfos, destBosTypeList);
    }

    public List getDestBosTypeForBotpByID(String[] srcIdList, String[] entryNames, List entriesIDList, List destBosTypeList) {
        if (this.tag) {
            destBosTypeList.clear();
            String materialReqBillType = new MaterialReqBillInfo().getBOSType().toString();
            destBosTypeList.add(materialReqBillType);
            return destBosTypeList;
        }
        if (destBosTypeList != null && destBosTypeList.size() != 0 && this.isSubContractBill()) {
            destBosTypeList.remove("256D05E2");
            destBosTypeList.remove("5C2A1F0C");
            destBosTypeList.remove("CC3E933B");
            destBosTypeList.remove("500AB75E");
            destBosTypeList.remove("2239F30A");
        }
        return super.getDestBosTypeForBotpByID(srcIdList, entryNames, entriesIDList, destBosTypeList);
    }

    public String getEntriesName() {
        return "entry";
    }

    public String getEntriesPKName() {
        return "entry.id";
    }

    public String[] getMergeColumnKeys() {
        String[] strMergeColKeys = new String[]{"id", "billStaus", "number", "sourceBillType", "transactionType", "bizDate", "supplier", "adminOrgUnit", "isInitBill", "receiveAmount", "isReversed", "isVouchered", "voucherNumber", "currency", "exchangeRate", "creator", "createTime", "modifier", "modifyTime", "auditor", "auditTime", "storageOrgUnitID", "isGenBizAP", "bizType", "paymentType", "pcVouchered", "pcVoucherNumber", "description", "processNode"};
        return strMergeColKeys;
    }

    public String getUITitle() {
        if (this.isSubContractBill()) {
            return EASResource.getString((String)MER_InvUI, (String)"SubContractInWarehsBill");
        }
        return EASResource.getString((String)MER_InvUI, (String)"PurInWarehsBill");
    }

    public String getBOTPBillUITitleByID(String id) {
        String title = null;
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("purchaseType");
        if (null == id) {
            return null;
        }
        try {
            int type = PurInWarehsBillFactory.getRemoteInstance().getPurInWarehsBillInfo((IObjectPK)new ObjectUuidPK(id), sic).getPurchaseType().getValue();
            title = type == 1 ? EASResource.getString((String)MER_InvUI, (String)"SubContractInWarehsBill") : EASResource.getString((String)MER_InvUI, (String)"PurInWarehsBill");
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        return title;
    }

    @Override
    public void initBatchActions() throws BOSException {
        this.actionManager.setClzIBizFactory(ActionLevelEnum.HEAD, PurInWarehsBillFactory.class);
        this.actionManager.setClzIBizFactory(ActionLevelEnum.ENTRY, PurInWarehsEntryFactory.class);
        this.getTableSelectionHelper().setTableProperty((CoreBillListUI)this, this.mainQueryPK, this.tblMain, "id", "entry.id", "number", "entry.seq", "storageOrgUnit.id");
        super.initBatchActions();
    }

    public void initFormatTable() throws Exception {
        CurrencyInfo baseCurrInfo;
        InvClientUtils.fmtTableAmt(this.tblMain, "taxRate", 2);
        CompanyOrgUnitInfo ficompanyOrgInfo = SysContext.getSysContext().getCurrentFIUnit();
        if (ficompanyOrgInfo != null && (baseCurrInfo = ficompanyOrgInfo.getBaseCurrency()) != null) {
            baseCurrInfo = CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)new ObjectUuidPK(ficompanyOrgInfo.getBaseCurrency().getId()));
        }
        String[] fields = new String[]{"totalStandardCost", "totalActualCost", "standardCost", "actualCost", "writtenOffAmount", "unWriteOffAmount", "receiveAmount", "tax", "localTax", "localAmount"};
        for (int i = 0; i < fields.length; ++i) {
            this.tblMain.getColumn(fields[i]).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        }
    }

    @Override
    public boolean isPrepareActionAddNew() {
        return true;
    }

    public boolean isPrepareActionAudit() {
        return false;
    }

    public boolean isPrepareActionCreateTo() {
        return false;
    }

    @Override
    public boolean isPrepareActionEdit() {
        return false;
    }

    public boolean isPrepareActionMultiPrintPreview() {
        return false;
    }

    public boolean isPrepareActionQuery() {
        return false;
    }

    @Override
    public boolean isPrepareActionRemove() {
        return false;
    }

    public boolean isPrepareActionTraceDown() {
        return false;
    }

    public boolean isPrepareActionTraceUp() {
        return false;
    }

    public boolean isPrepareActionView() {
        return true;
    }

    @Override
    public boolean isPrepareActionViewWriteOffRecord() {
        return false;
    }

    public boolean isPrepareActionVoucher() {
        return false;
    }

    @Override
    public boolean isPrepareInit() {
        return true;
    }

    @Override
    public boolean isSupportedBatchActions() {
        return true;
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.menuItemExportData.setVisible(true);
        this.menuItemImportData.setVisible(true);
        this.menuItemImportData.setEnabled(true);
        this.btnViewWriteOffRecord.setIcon(EASResource.getIcon((String)"imgTbtn_seegather"));
        this.btnSplitBillByHand.setIcon(EASResource.getIcon((String)"imgTbtn_split"));
        this.menuItemSplitBillByHand.setIcon(EASResource.getIcon((String)"imgTbtn_split"));
        this.menuItemMultiapprove.setVisible(false);
        this.btnMultiapprove.setVisible(false);
        this.btnSplitBill.setIcon(EASResource.getIcon((String)"imgTbtn_split"));
        this.menuItemSplitBill.setIcon(EASResource.getIcon((String)"imgTbtn_split"));
        this.btnDirectMaterialBill.setIcon(EASResource.getIcon((String)"imgTbtn_autocreate"));
        this.menuItemDirectMaterialBill.setIcon(EASResource.getIcon((String)"imgTbtn_autocreate"));
        this.btnDirectMaterialBill.setEnabled(true);
        this.actionDirectMaterialBill.setEnabled(true);
        boolean enableSubmit = isBatchSubmitOn;
        this.btnSubmit.setVisible(enableSubmit);
        this.menuItemSubmit.setVisible(enableSubmit);
        this.actionDiscard.setEnabled(true);
        this.actionDiscard.setVisible(true);
        if (this.isSubContractBill()) {
            this.menuItemSingleMergeDown.setVisible(false);
            this.btnUniteBill.setVisible(false);
        }
        this.btnUniteBill.setIcon(EASResource.getIcon((String)"imgTbtn_unite"));
        this.menuItemSingleMergeDown.setIcon(EASResource.getIcon((String)"imgTbtn_unite"));
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.initColumnTable();
        if (this.getUIContext().get("BillMainQuery") != null) {
            this.setQueryPreference(true);
            this.tHelper = null;
            this.initHelper();
        }
    }

    @Override
    public RequestContext prepareActionAddNew(IItemAction itemAction) throws Exception {
        return super.prepareActionAddNew(itemAction);
    }

    public RequestContext prepareActionAudit(IItemAction itemAction) throws Exception {
        return super.prepareActionAudit(itemAction);
    }

    public RequestContext prepareActionCreateTo(IItemAction itemAction) throws Exception {
        return super.prepareActionCreateTo(itemAction);
    }

    @Override
    public RequestContext prepareActionEdit(IItemAction itemAction) throws Exception {
        return super.prepareActionEdit(itemAction);
    }

    public RequestContext prepareActionMultiPrintPreview(IItemAction itemAction) throws Exception {
        return super.prepareActionMultiPrintPreview(itemAction);
    }

    public RequestContext prepareActionQuery(IItemAction itemAction) throws Exception {
        return super.prepareActionQuery(itemAction);
    }

    @Override
    public RequestContext prepareActionRemove(IItemAction itemAction) throws Exception {
        return super.prepareActionRemove(itemAction);
    }

    public RequestContext prepareActionTraceDown(IItemAction itemAction) throws Exception {
        return super.prepareActionTraceDown(itemAction);
    }

    public RequestContext prepareActionTraceUp(IItemAction itemAction) throws Exception {
        return super.prepareActionTraceUp(itemAction);
    }

    public RequestContext prepareActionView(IItemAction itemAction) throws Exception {
        return super.prepareActionView(itemAction);
    }

    @Override
    public RequestContext prepareActionViewWriteOffRecord(IItemAction itemAction) throws Exception {
        RequestContext request = new RequestContext();
        request.setClassName("com.kingdee.eas.scm.im.inv.app.PurInWarehsBillListUIHandler");
        request.setMethodName("handleActionViewWriteOffRecord");
        request.put("IDS_LISTUI_SELECTED", (Object)this.getSelectedIdValues());
        return request;
    }

    public RequestContext prepareActionVoucher(IItemAction itemAction) throws Exception {
        RequestContext request = super.prepareActionVoucher(itemAction);
        request.setClassName("com.kingdee.eas.scm.im.inv.app.PurInWarehsBillListUIHandler");
        request.put("IDS_LISTUI_SELECTED", (Object)this.getSelectedIdValues());
        request.put("BOTP_SELECTOR", (Object)this.getBOTPSelectors());
        request.put("IS_CAN_VOUCHAR", (Object)Boolean.TRUE);
        return request;
    }

    @Override
    public IUIActionPostman prepareInit() {
        IUIActionPostman clientHanlder = super.prepareInit();
        if (clientHanlder != null) {
            RequestContext request = new RequestContext();
            request.setClassName("com.kingdee.eas.scm.im.inv.app.PurInWarehsBillListUIHandler");
            clientHanlder.setRequestContext((Serializable)request);
        }
        return clientHanlder;
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return PurInWarehsBillFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext());
    }

    protected FilterInfo getBOTPFilterByBillType(String BillTypeId, OrgType destType, String destOrgId) {
        return super.getBOTPFilterByBillType(BillTypeId, destType, destOrgId);
    }

    protected CompanyOrgUnitInfo getCompanyOrgUnitInfo() throws Exception {
        KDTSelectBlock selectBlock = this.tblMain.getSelectManager().get();
        if (selectBlock != null) {
            ICell cell;
            Object keyValue;
            int rowIndex = selectBlock.getTop();
            IRow row = this.tblMain.getRow(rowIndex);
            String entryID = this.getEntriesPKName();
            if (entryID != null && (keyValue = (cell = row.getCell(entryID)).getValue()) != null) {
                IPurInWarehsEntry ipe = PurInWarehsEntryFactory.getRemoteInstance();
                PurInWarehsEntryInfo pie = ipe.getPurInWarehsEntryInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)keyValue.toString())));
                return pie.getCompanyOrgUnit();
            }
        }
        return null;
    }

    protected FilterInfo getDefaultFilterForQuery() {
        FilterInfo filterInfo = super.getDefaultFilterForQuery();
        boolean isCreateTo = false;
        if (this.getUIContext().get("BTPCreateMode") != null) {
            isCreateTo = Integer.valueOf("0").equals(this.getUIContext().get("BTPCreateMode"));
        }
        if (!isCreateTo && this.getBOTPViewStatus() == 1) {
            return filterInfo;
        }
        if (!(filterInfo == null || this.getUIContext().get("Owner") != null && this.getUIContext().get("Owner") instanceof DAPFromMultiBillTypeEditUI)) {
            if (this.isSubContractBill()) {
                filterInfo.getFilterItems().add(new FilterItemInfo("purchaseType", (Object)new Integer(1)));
            } else {
                filterInfo.getFilterItems().add(new FilterItemInfo("purchaseType", (Object)new Integer(0)));
            }
        }
        return filterInfo;
    }

    @Override
    protected String getEditUIName() {
        return "com.kingdee.eas.scm.im.inv.client.PurInWarehsBillEditUI";
    }

    protected String[] getExColumns() throws Exception {
        return new String[]{"exchangeRate"};
    }

    protected CustomerQueryPanel getFilterUI() throws Exception {
        if (this.filterUI == null) {
            this.filterUI = this.isSubContractBill() ? new PurInWarehsFilterUI(true) : new PurInWarehsFilterUI();
        }
        return this.filterUI;
    }

    protected String[] getPriceColumns() throws Exception {
        return new String[]{"price", "localPrice", "unitStandardCost", "unitActualCost", "unitPurchaseCost", "taxPrice", "actualPrice", "actualTaxPrice", "unitMaterialCost", "materialCost"};
    }

    protected String[] getQtyColumns() throws Exception {
        return new String[]{"qty", "reverseQty", "returnsQty", "writtenOffQty", "drewQty", "drewBaseQty", "totalQty", "unWriteOffQty", "associateQty", "assistQty", "scWrittenOffQty", "scWrittenOffBaseQty", "scUnWrittenOffQty", "scUnWrittenOffBaseQty", "baseQty"};
    }

    protected String[] getTaxRateColumns() {
        return new String[]{"taxRate", "discountRate"};
    }

    protected void getRowSetBeforeFillTable(IRowSet rowSet) {
        if (this.isSwitchView()) {
            return;
        }
        int exchangeRateprec = 2;
        int localAmountprc = 2;
        String[] UNIT_COLUMNS = new String[]{"entry.qty", "entry.reverseQty", "entry.returnsQty", "totalQty", "entry.drewQty", "entry.writtenOffQty", "entry.unWriteOffQty"};
        String[] BASEUNIT_COLUMNS = new String[]{"entry.baseQty"};
        String[] ASSISTUNIT_COLUMNS = new String[]{"entry.assistQty"};
        String[] PIRCE_COLUMNS = new String[]{"entry.price", "entry.localPrice", "entry.unitStandardCost", "entry.unitActualCost", "entry.unitPurchaseCost", "entry.unitMaterialCost"};
        String[] TAX_COLUMNS = new String[]{"entry.tax", "receiptAmount", "totalAmount", "entry.amount", "entry.taxAmount"};
        String[] LOCALAMOUNT_COLUMNS = new String[]{"entry.localAmount", "totalLocalAmount", "entry.localTax", "entry.standardCost", "entry.actualCost", "totalStandardCost", "totalActualCost", "entry.writtenOffAmount", "entry.unWriteOffAmount", "entry.imputedCost", "entry.purchaseCost", "entry.purchaseFee", "entry.materialCost"};
        try {
            rowSet.beforeFirst();
            Map colMap = null;
            int priPrecision = 2;
            while (rowSet.next()) {
                priPrecision = rowSet.getInt("material.pricePrecision");
                if (rowSet.getInt("currency.precision") > 0) {
                    exchangeRateprec = rowSet.getInt("currency.precision");
                }
                if (rowSet.getInt("currency2.precision") > 0) {
                    localAmountprc = rowSet.getInt("currency2.precision");
                }
                if (colMap == null) {
                    colMap = SCMClientUtils.getColumnsByRowSet((IRowSet)rowSet);
                }
                SCMClientUtils.iniColumnsPrecision((int)this.qtyPrecision, (String[])UNIT_COLUMNS, (IRowSet)rowSet, (Map)colMap);
                SCMClientUtils.iniColumnsPrecision((int)this.qtyPrecision, (String[])BASEUNIT_COLUMNS, (IRowSet)rowSet, (Map)colMap);
                SCMClientUtils.iniColumnsPrecision((int)this.qtyPrecision, (String[])ASSISTUNIT_COLUMNS, (IRowSet)rowSet, (Map)colMap);
                SCMClientUtils.iniColumnsPrecision((int)priPrecision, (String[])PIRCE_COLUMNS, (IRowSet)rowSet, (Map)colMap);
                SCMClientUtils.iniColumnsPrecision((int)exchangeRateprec, (String[])TAX_COLUMNS, (IRowSet)rowSet, (Map)colMap);
                SCMClientUtils.iniColumnsPrecision((int)localAmountprc, (String[])LOCALAMOUNT_COLUMNS, (IRowSet)rowSet, (Map)colMap);
            }
            if (!this.isSubContractBill()) {
                SCMClientUtils.hideColumns((KDTable)this.tblMain, (String[])this.subColumn, (boolean)true);
            }
        }
        catch (Exception ex) {
            this.handUIException(ex);
        }
    }

    protected String getTDFileName() {
        if (this.isSubContractBill()) {
            return "/SCM/SM/SubContract/SubContractInWarehs";
        }
        return "/SCM/IM/InWarehs/PurInWarehsBill";
    }

    protected IMetaDataPK getTDQueryPK() {
        return MetaDataPK.create((String)"com.kingdee.eas.scm.im.inv.PurInwarehsPrintQuery");
    }

    protected boolean initDefaultFilter() {
        return this.getUIContext().get("BillMainQuery") == null;
    }

    public boolean isSupportDynQuery() {
        return true;
    }

    private void changeHeaderTitle(String columnNumber, String destColumnTitle) {
        KDTCell cell = this.tblMain.getHead().getRow(0).getCell(this.tblMain.getColumnIndex(columnNumber));
        if (cell != null) {
            cell.setValue((Object)destColumnTitle);
        }
    }

    private void initPurInWarehsUI() {
        this.tblMain.getColumn("materialCost").setWidth(0);
        this.tblMain.getColumn("materialCost").setResizeable(false);
        this.tblMain.getColumn("unitMaterialCost").setWidth(0);
        this.tblMain.getColumn("unitMaterialCost").setResizeable(false);
        this.tblMain.getColumn("productTaskNumber").setWidth(0);
        this.tblMain.getColumn("productTaskNumber").setResizeable(false);
        this.tblMain.getColumn("scWrittenOffQty").setWidth(0);
        this.tblMain.getColumn("scWrittenOffQty").setResizeable(false);
        this.tblMain.getColumn("scWrittenOffBaseQty").setWidth(0);
        this.tblMain.getColumn("scWrittenOffBaseQty").setResizeable(false);
        this.tblMain.getColumn("scUnWrittenOffQty").setWidth(0);
        this.tblMain.getColumn("scUnWrittenOffQty").setResizeable(false);
        this.tblMain.getColumn("scUnWrittenOffBaseQty").setWidth(0);
        this.tblMain.getColumn("scUnWrittenOffBaseQty").setResizeable(false);
    }

    private void initSubContractInWarehsUI() {
        this.changeHeaderTitle("unitPurchaseCost", EASResource.getString((String)Resource_subContract, (String)"SubContractInWarehs_UnitProcessFee"));
        this.changeHeaderTitle("purchaseCost", EASResource.getString((String)Resource_subContract, (String)"SubContractInWarehs_ProcessFee"));
        this.changeHeaderTitle("purchaseFee", EASResource.getString((String)Resource_subContract, (String)"SubContractInWarehs_OtherFee"));
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("currency.precision"));
        sic.add(new SelectorItemInfo("currency2.precision"));
        sic.add(new SelectorItemInfo("entry.baseQty"));
        sic.add(new SelectorItemInfo("material.pricePrecision"));
        sic.addObjectCollection((IObjectCollection)SCMSelectorFactory.getInvUpdateTypeSelector((boolean)true, (String)this.getEntriesName()));
        return sic;
    }

    @Override
    public OrgType getMainBizOrgType() {
        return super.getMainBizOrgType();
    }

    public String getSelectedKeyValue() {
        return super.getSelectedKeyValue();
    }

    public IIDList getSelectedKeyValues() {
        return super.getSelectedKeyValues();
    }

    public void getBillIdList(List idList, List entriesList) {
        block7: {
            block6: {
                int mode = 0;
                ArrayList blockList = this.tblMain.getSelectManager().getBlocks();
                if (blockList != null && blockList.size() == 1) {
                    mode = ((IBlock)this.tblMain.getSelectManager().getBlocks().get(0)).getMode();
                }
                if (mode != 8) break block6;
                List selectIdList = this.getQueryPkList();
                if (selectIdList == null) break block7;
                for (Object[] idObj : selectIdList) {
                    if (idObj == null) continue;
                    if (!idList.contains(idObj[0].toString())) {
                        idList.add(idObj[0].toString());
                    }
                    if (idObj.length != 2 || idObj[1] == null) continue;
                    entriesList.add(idObj[1]);
                }
                break block7;
            }
            ArrayList blocks = this.tblMain.getSelectManager().getBlocks();
            for (KDTSelectBlock block : blocks) {
                int top = block.getTop();
                int bottom = block.getBottom();
                for (int rowIndex = top; rowIndex <= bottom; ++rowIndex) {
                    ICell cell = this.tblMain.getRow(rowIndex).getCell(this.getKeyFieldName());
                    if (this.tblMain.getRow(rowIndex).getCell(this.getEntriesPKName()) != null && this.tblMain.getRow(rowIndex).getCell(this.getEntriesPKName()).getValue() != null) {
                        entriesList.add(this.tblMain.getRow(rowIndex).getCell(this.getEntriesPKName()).getValue().toString());
                    }
                    if (idList.contains(cell.getValue())) continue;
                    idList.add(cell.getValue());
                }
            }
        }
    }

    public ArrayList getSelectedIdValues() {
        return super.getSelectedIdValues();
    }

    protected String[] getQueryShowField() {
        return new String[]{"number", "billStaus", "bizDate", "supplier", "storageOrgUnitID", "materialNumber", "materialName", "model", "transactionType", "unit", "qty", "warehouse", "location", "unitActualCost", "actualCost"};
    }

    protected String[] getQueryHideField() {
        return new String[]{"number", "isInitBill", "bizDate", "isVouchered", "isReversed", "storageOrgUnit.id"};
    }

    protected boolean isLazyMode() {
        return !Boolean.TRUE.equals(this.getUIContext().get("isFromWorkflowMultiapprove"));
    }

    public String getsourceBillEntryId() {
        return "entry.sourceBillEntryId";
    }

    protected CommonQueryDialog initCommonQueryDialog() {
        this.commonQueryDialog = super.initCommonQueryDialog();
        this.commonQueryDialog.setHeight(380);
        return this.commonQueryDialog;
    }

    public void actionImportData_actionPerformed(ActionEvent e) throws Exception {
        this.getMainOrgContext().put((Object)"isSubContractBill", (Object)new Boolean(this.isSubContractBill()));
        super.actionImportData_actionPerformed(e);
    }

    public void actionExportData_actionPerformed(ActionEvent e) throws Exception {
        ArrayList para = this.getExportParam();
        if (para == null || para.size() <= 0) {
            throw new FrameWorkException(FrameWorkException.EXPORTDATAPARANULL);
        }
        DatataskCaller task = new DatataskCaller();
        task.setParentComponent((Component)((Object)this));
        task.setMainOrgContext(this.getMainOrgContext());
        task.invoke(para, 1);
    }

    protected ArrayList getImportParam() {
        String solutionName;
        DatataskParameter param = new DatataskParameter();
        param.solutionName = solutionName = "eas.30im.purInWarehs";
        param.alias = this.isSubContractBill() ? EASResource.getString((String)RES_InvUI, (String)"SUBCONTRACTINWAREHSBILL") : EASResource.getString((String)RES_InvUI, (String)"PURINWAREHSBILL");
        ArrayList<DatataskParameter> paramList = new ArrayList<DatataskParameter>();
        paramList.add(param);
        return paramList;
    }

    protected ArrayList getExportParam() {
        DatataskParameter param = new DatataskParameter();
        param.solutionName = "eas.30im.purInWarehs";
        param.datataskMode = 1;
        param.alias = this.isSubContractBill() ? EASResource.getString((String)RES_InvUI, (String)"SUBCONTRACTINWAREHSBILL") : EASResource.getString((String)RES_InvUI, (String)"PURINWAREHSBILL");
        param.varList = new ArrayList();
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        hashtable.put("filter", this.mainQuery.getFilter());
        EntityViewInfo viewInfo = (EntityViewInfo)this.mainQuery.clone();
        viewInfo.setSelector(null);
        SorterItemCollection sorter = new SorterItemCollection();
        sorter.add(new SorterItemInfo("number"));
        viewInfo.setSorter(sorter);
        viewInfo.setRemoveEntry(false);
        hashtable.put("mainQuery", viewInfo);
        param.setContextParam(hashtable);
        ArrayList<DatataskParameter> paramList = new ArrayList<DatataskParameter>();
        paramList.add(param);
        return paramList;
    }

    protected QuickFilteringSupportItems getQuickFilteringSupport() {
        if (this.getUIContext().get("BillQuery") != null) {
            return super.getQuickFilteringSupport();
        }
        return this.qfsi;
    }

    protected boolean isSupportBatchSubmitAction() {
        return true;
    }

    private void initColumnTable() {
        String[] fields = new String[]{"standardCost", "returnsQty", "actualCost", "writtenOffAmount", "unWriteOffAmount", "receiveAmount", "tax", "localTax", "localAmount", "purchaseCost", "purchaseFee", "unitPurchaseCost"};
        for (int i = 0; i < fields.length; ++i) {
            this.tblMain.getColumn(fields[i]).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        }
        this.menuItemMultiapprove.setVisible(false);
        this.btnMultiapprove.setVisible(false);
        this.btnSplitBill.setIcon(EASResource.getIcon((String)"imgTbtn_split"));
        this.menuItemSplitBill.setIcon(EASResource.getIcon((String)"imgTbtn_split"));
        this.btnDirectMaterialBill.setIcon(EASResource.getIcon((String)"imgTbtn_autocreate"));
        this.tblMain.getColumn("createTime").setEditor((ICellEditor)new KDTDefaultCellEditor(new KDDatePicker()));
        this.tblMain.getColumn("createTime").getStyleAttributes().setNumberFormat(SCMClientUtils.strTimeFormat);
        this.tblMain.getColumn("modifyTime").setEditor((ICellEditor)new KDTDefaultCellEditor(new KDDatePicker()));
        this.tblMain.getColumn("modifyTime").getStyleAttributes().setNumberFormat(SCMClientUtils.strTimeFormat);
        this.tblMain.getColumn("auditTime").setEditor((ICellEditor)new KDTDefaultCellEditor(new KDDatePicker()));
        this.tblMain.getColumn("auditTime").getStyleAttributes().setNumberFormat(SCMClientUtils.strTimeFormat);
        this.tblMain.getColumn("mfg").setEditor((ICellEditor)new KDTDefaultCellEditor(new KDDatePicker()));
        this.tblMain.getColumn("mfg").getStyleAttributes().setNumberFormat(SCMClientUtils.strDateFormat);
        this.tblMain.getColumn("exp").setEditor((ICellEditor)new KDTDefaultCellEditor(new KDDatePicker()));
        this.tblMain.getColumn("exp").getStyleAttributes().setNumberFormat(SCMClientUtils.strDateFormat);
        int freezeCol = this.tblMain.getColumnIndex("number");
        this.tblMain.getViewManager().setFreezeView(-1, freezeCol + 1);
        this.btnDirectMaterialBill.setEnabled(true);
        this.actionDirectMaterialBill.setEnabled(true);
        if (this.isSubContractBill()) {
            this.initSubContractInWarehsUI();
        } else {
            this.initPurInWarehsUI();
        }
    }

    public void actionTraceDown_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        IRow row = KDTableUtil.getSelectedRow((KDTable)this.tblMain);
        Object numberO = row.getCell("number").getValue();
        if (numberO != null && numberO.toString().contains("_C")) {
            this.getUIContext().put("igornEntryRelation", true);
        }
        super.actionTraceDown_actionPerformed(e);
        this.getUIContext().put("igornEntryRelation", null);
    }

    @Override
    public boolean beforeAction(BatchActionEnum bizAction, BatchSelectionEntries selectionEntries, ActionEvent event) {
        boolean result = super.beforeAction(bizAction, selectionEntries, event);
        if (bizAction.equals((Object)BatchActionEnum.SUBMIT)) {
            super.checkSelected();
            this.checkTopPrice();
        }
        if (bizAction.equals((Object)BatchActionEnum.UNAUDIT)) {
            List pur = selectionEntries.getEntries();
            HashSet<String> idSet = new HashSet<String>();
            for (int i = 0; i < pur.size(); ++i) {
                BatchSelectionEntry batchSelectionEntry = (BatchSelectionEntry)pur.get(i);
                String id = batchSelectionEntry.getId().toString();
                idSet.add(id);
            }
            Map resultMap = null;
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("idSet", idSet);
            map.put("bosType", SCMConstant.BOSTYPE_PURINWAREHS);
            try {
                IRelationOfChildAndParentFacade iRelationOfChildAndParentFacade = RelationOfChildAndParentFacadeFactory.getRemoteInstance();
                resultMap = iRelationOfChildAndParentFacade.queryInfoByMap(map);
            }
            catch (Exception e) {
                this.handUIException(e);
                return false;
            }
            List idList = (List)resultMap.get("idList");
            if (idList.isEmpty()) {
                return result;
            }
            if (!idList.isEmpty()) {
                String s = (String)resultMap.get("childinfo");
                StringBuffer bs = new StringBuffer();
                bs.append(EASResource.getString((String)MER_InvUI, (String)"MotherNumber"));
                bs.append("                                             ");
                bs.append(EASResource.getString((String)MER_InvUI, (String)"ChildNumber"));
                bs.append("\n");
                bs.append(s);
                int flag = MsgBox.showConfirm3a((Component)((Object)this), (String)EASResource.getString((String)MER_InvUI, (String)"ConfirmWhetherToOpenTheBill"), (String)bs.toString());
                if (0 != flag) {
                    for (int j = pur.size() - 1; j >= 0; --j) {
                        BatchSelectionEntry batchSelectionEntry = (BatchSelectionEntry)pur.get(j);
                        String id = batchSelectionEntry.getId().toString();
                        if (!idList.contains(id)) continue;
                        pur.remove(j);
                    }
                }
            }
        }
        if (bizAction.equals((Object)BatchActionEnum.UNAUDIT) && result) {
            List idList = this.getSelectedIds(selectionEntries);
            try {
                IWriteOffCommonFacade iWrite = WriteOffCommonFacadeFactory.getRemoteInstance();
                idList = iWrite.getRedPurInIds(idList);
                if (idList != null && idList.size() > 0) {
                    this.writeOffRPurInIdList = iWrite.getPurInIdsByWOffRecord("103", idList, false);
                }
            }
            catch (EASBizException e) {
                this.handUIException(e);
            }
            catch (BOSException e) {
                this.handUIException(e);
            }
        }
        return result;
    }

    private void checkTopPrice() {
        String[] strID = com.kingdee.eas.basedata.framework.util.KDTableUtil.getSelectRowFieldValue((KDTable)this.tblMain, (String)"id");
        IObjectPK[] pks = SCMUtils.convertStringToObjectPK((String[])strID);
        HashSet<String> idSet = new HashSet<String>();
        int len = pks.length;
        for (int i = 0; i < len; ++i) {
            idSet.add(pks[i].toString());
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
        view.setFilter(filter);
        try {
            PurInWarehsBillCollection col = PurInWarehsBillFactory.getRemoteInstance().getPurInWarehsBillCollection(view);
            PurInWarehsBillInfo bill = null;
            IPurServiceFacade iPurService = PurServiceFacadeFactory.getRemoteInstance();
            int size = col.size();
            for (int i = 0; i < size; ++i) {
                bill = col.get(i);
                PurPriceParamCollection paramCol = this.getParamCol4FetchStrategy((IObjectValue)bill);
                CheckPriceResult checkResult = iPurService.topPriceCtrl(paramCol);
                if (!checkResult.hasErrorMsg()) continue;
                if (checkResult.getMessageType() == 2) {
                    MsgBox.showInfo((String)MessageFormat.format(EASResource.getString((String)this.invAddResource, (String)"MSG_TOPPRICE"), bill.getNumber()));
                    SysUtil.abort();
                    continue;
                }
                MsgBox.showInfo((String)MessageFormat.format(EASResource.getString((String)this.invAddResource, (String)"ERROR_TOPPRICE"), bill.getNumber()));
                SysUtil.abort();
            }
        }
        catch (Exception e) {
            super.handUIExceptionAndAbort(e);
        }
    }

    private PurPriceParamCollection getParamCol4FetchStrategy(IObjectValue model) {
        PurInWarehsBillInfo pr = (PurInWarehsBillInfo)model;
        PurPriceParamCollection paramCol = new PurPriceParamCollection();
        paramCol.setBillTypeId(pr.getBillType() != null ? pr.getBillType().getId().toString() : null);
        paramCol.setBizTypeId(pr.getBizType() != null ? pr.getBizType().getId().toString() : null);
        PurInWarehsEntryCollection col = pr.getEntry();
        if (CollectionUtil.isEmpty((AbstractObjectCollection)col)) {
            return null;
        }
        int size = col.size();
        PurInWarehsEntryInfo entry = null;
        for (int i = 0; i < size; ++i) {
            entry = col.get(i);
            if (!this.isHasParam((IObjectValue)entry)) continue;
            PurPriceParam param = this.getParam4FetchStrategy((IObjectValue)pr, (IObjectValue)entry);
            paramCol.addPurPriceParam(param);
        }
        return paramCol;
    }

    public PurPriceParam getParam4FetchStrategy(IObjectValue billModel, IObjectValue entryModel) {
        PurInWarehsBillInfo bill = (PurInWarehsBillInfo)billModel;
        PurInWarehsEntryInfo entry = (PurInWarehsEntryInfo)entryModel;
        PurPriceParam param = new PurPriceParam();
        param.setMaterialPurchaseType(this.isSubContractBill() ? 1 : 0);
        String billTypeId = bill.getBillType() == null ? null : bill.getBillType().getId().toString();
        param.setBillTypeId(billTypeId);
        param.setSeq(entry.getSeq());
        PurchaseOrgUnitInfo purOrgO = entry.getPurchaseOrgUnit();
        param.setPurOrgUnitId(purOrgO != null ? purOrgO.getId().toString() : null);
        CurrencyInfo currencyO = bill.getCurrency();
        param.setCurrencyId(currencyO != null ? currencyO.getId().toString() : null);
        MaterialInfo material = entry.getMaterial();
        param.setMaterialId(material != null ? material.getId().toString() : null);
        MeasureUnitInfo unit = entry.getUnit();
        param.setUnitId(unit != null ? unit.getId().toString() : null);
        BigDecimal actualPrice = entry.getActualPrice();
        param.setActualPrice(actualPrice);
        BigDecimal actualTaxPrice = entry.getActualTaxPrice();
        param.setActualTaxPrice(actualTaxPrice);
        param.setBizTypeId(bill.getBizType() == null ? null : bill.getBizType().getId().toString());
        return param;
    }

    protected boolean isHasParam(IObjectValue model) {
        PurInWarehsEntryInfo entry = (PurInWarehsEntryInfo)model;
        return entry.getMaterial() != null;
    }

    private void checkAllBillHasSamePeriod(String[] ids) throws Exception {
        if (ids.length <= 1) {
            return;
        }
        HashSet<String> set = new HashSet<String>(ids.length);
        for (int i = 0; i < ids.length; ++i) {
            set.add(ids[i]);
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", set, CompareType.INCLUDE));
        view.setFilter(filter);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("period"));
        selector.add(new SelectorItemInfo("year"));
        view.setSelector(selector);
        PurInWarehsBillCollection collection = ((IPurInWarehsBill)this.getBizInterface()).getPurInWarehsBillCollection(view);
        if (collection != null && collection.size() <= 1) {
            return;
        }
        HashSet<Integer> yearSet = new HashSet<Integer>();
        HashSet<Integer> periodSet = new HashSet<Integer>();
        for (int i = 0; i < collection.size(); ++i) {
            yearSet.add(collection.get(i).getYear());
            periodSet.add(collection.get(i).getPeriod());
        }
        if (yearSet.size() > 1 || periodSet.size() > 1) {
            String errHeadStr = EASResource.getString((String)"com.kingdee.eas.scm.im.inv.SplitBillResource", (String)"allBillHasNotSamePeriod");
            MsgBox.showInfo((String)errHeadStr);
            SysUtil.abort();
        }
    }

    private void checkNextPeriod(String[] ids) throws Exception {
        if (ids.length < 1) {
            return;
        }
        HashSet<String> set = new HashSet<String>(ids.length);
        for (int i = 0; i < ids.length; ++i) {
            set.add(ids[i]);
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", set, CompareType.INCLUDE));
        view.setFilter(filter);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("storageOrgUnit.id"));
        selector.add(new SelectorItemInfo("storageOrgUnit.number"));
        selector.add(new SelectorItemInfo("bizDate"));
        selector.add(new SelectorItemInfo("isInitBill"));
        view.setSelector(selector);
        PurInWarehsBillCollection collection = ((IPurInWarehsBill)this.getBizInterface()).getPurInWarehsBillCollection(view);
        if (collection != null && collection.size() < 1) {
            return;
        }
        for (int i = 0; i < collection.size(); ++i) {
            PurInWarehsBillInfo info = collection.get(i);
            CompanyOrgUnitInfo ficompanyOrgInfo = SCMClientUtils.getCompanyInfo((BOSUuid)info.getStorageOrgUnit().getId());
            if (!InvClientUtils.isInWarehsBillSplitChangeDate(info.getStorageOrgUnit().getId().toString()) || info.isIsInitBill()) continue;
            PeriodInfo periodInfo = SystemStatusCtrolUtils.getCurrentPeriod(null, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)ficompanyOrgInfo);
            PeriodInfo pInfo = PeriodUtils.getPeriodInfo(null, (Date)info.getBizDate(), (CompanyOrgUnitInfo)ficompanyOrgInfo);
            if (pInfo.getNumber() < periodInfo.getNumber()) continue;
            PeriodInfo nextPeriodInfo = PeriodUtils.getNextPeriodInfo((PeriodInfo)pInfo);
            if (nextPeriodInfo == null) {
                MsgBox.showInfo((String)InvClientUtils.getResource("nextAccountingPeriod"));
                SysUtil.abort();
            }
            if (!nextPeriodInfo.isIsAdjustPeriod() || PeriodUtils.getNextPeriodInfo((PeriodInfo)nextPeriodInfo) != null) continue;
            MsgBox.showInfo((String)InvClientUtils.getResource("nextAccountingPeriod"));
            SysUtil.abort();
        }
    }

    private void checkAllSouHasSamePeriod(String[] orgIDs) throws Exception {
        if (orgIDs != null && orgIDs.length > 1) {
            int size = orgIDs.length;
            BOSUuid[] bosIDs = new BOSUuid[size];
            for (int index = 0; index < size; ++index) {
                if (orgIDs[index] == null) continue;
                bosIDs[index] = BOSUuid.read((String)orgIDs[index]);
            }
            ISCMBillCommonFacade iScmBillCommon = SCMBillCommonFacadeFactory.getRemoteInstance();
            Map map = iScmBillCommon.getCompanyInfos(bosIDs);
            HashMap compareMap = new HashMap();
            HashSet<String> couSet = new HashSet<String>();
            if (map != null) {
                Set set = map.keySet();
                for (String id : set) {
                    CompanyOrgUnitInfo company;
                    if (map.get(id) == null || (company = (CompanyOrgUnitInfo)map.get(id)) == null) continue;
                    couSet.add(company.getId().toString());
                }
                EntityViewInfo view = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("company.id", couSet, CompareType.INCLUDE));
                filter.getFilterItems().add(new FilterItemInfo("systemStatus.name", (Object)SystemEnum.INVENTORYMANAGEMENT));
                view.setFilter(filter);
                SystemStatusCtrolCollection coll = SystemStatusCtrolFactory.getRemoteInstance().getSystemStatusCtrolCollection(view);
                HashSet<String> periodIdSet = new HashSet<String>();
                for (int i = 0; i < coll.size(); ++i) {
                    periodIdSet.add(coll.get(i).getCurrentPeriod() == null ? null : coll.get(i).getCurrentPeriod().getId().toString());
                }
                if (periodIdSet.size() > 1) {
                    String errHeadStr = EASResource.getString((String)"com.kingdee.eas.scm.im.inv.SplitBillResource", (String)"allCouHasNotSamePeriod");
                    MsgBox.showInfo((String)errHeadStr);
                    SysUtil.abort();
                }
            }
        }
    }

    protected IObjectPK[] changetToPKs(String[] ids) {
        HashSet<String> pkSet = new HashSet<String>();
        for (int i = 0; i < ids.length; ++i) {
            pkSet.add(ids[i]);
        }
        Object[] pks = pkSet.toArray();
        IObjectPK[] pkIDs = new IObjectPK[pks.length];
        for (int i = 0; i < pks.length; ++i) {
            pkIDs[i] = new ObjectStringPK((String)pks[i]);
        }
        return pkIDs;
    }

    private boolean getAllSouParamForSplitChangeDate(String[] orgIDs) throws Exception {
        ArrayList<String> orgIdStrList = new ArrayList<String>();
        ArrayList<String> paramNumberList = new ArrayList<String>();
        paramNumberList.add("INM101");
        for (int i = 0; i < orgIDs.length; ++i) {
            String orgId = orgIDs[i];
            if (orgIdStrList.contains(orgId)) continue;
            orgIdStrList.add(orgId);
        }
        ArrayList paramList = ParamControlFactory.getRemoteInstance().getParamHashMapBatch(paramNumberList, orgIdStrList);
        ParamSimpleInfo paramInfo = null;
        HashSet<String> paramSet = new HashSet<String>();
        for (int i = 0; i < paramList.size(); ++i) {
            paramInfo = (ParamSimpleInfo)paramList.get(i);
            paramSet.add(paramInfo.getParamValue());
        }
        if (paramSet.size() > 1) {
            String errHeadStr = EASResource.getString((String)"com.kingdee.eas.scm.im.inv.SplitBillResource", (String)"not_same_paramForPurInWarehsBillSplitChangeDate");
            MsgBox.showInfo((String)errHeadStr);
            SysUtil.abort();
        }
        return paramInfo == null ? false : paramInfo.getParamValue().equals(Boolean.TRUE.toString());
    }

    @Override
    protected Date confirmSplitBill(String billType, String storageUnitID) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"BILL_TYPE_ID", (Object)billType);
        uiContext.put((Object)"STORAGE_ORGUNIT_ID", (Object)storageUnitID);
        ArrayList bizDateList = this.getSelectedFieldValues("bizDate");
        Date billBizDate = new Date();
        if (bizDateList != null && bizDateList.size() > 0) {
            SimpleDateFormat myFormDate = new SimpleDateFormat("yyyy-MM-dd");
            billBizDate = myFormDate.parse((String)bizDateList.get(0));
        }
        PeriodInfo pInfo = PeriodUtils.getPeriodInfo(null, (Date)billBizDate, (CompanyOrgUnitInfo)InvClientUtils.getCompanyInfo(storageUnitID));
        uiContext.put((Object)"period", (Object)pInfo);
        uiContext.put((Object)"bizDate", (Object)billBizDate);
        IUIWindow splitBillDateUIWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create("com.kingdee.eas.scm.im.inv.client.SplitBillDateUI", (Map)uiContext, null, OprtState.EDIT);
        SplitBillDateUI aSplitBillDateUI = (SplitBillDateUI)splitBillDateUIWindow.getUIObject();
        aSplitBillDateUI.initData(billType, storageUnitID);
        splitBillDateUIWindow.show();
        if (aSplitBillDateUI.isCancel()) {
            SysUtil.abort();
        }
        return aSplitBillDateUI.getChildBillDate();
    }

    protected String getReturnMsg(HashMap hm) {
        if (hm == null) {
            return "";
        }
        StringBuffer ReturnMsg = new StringBuffer();
        if (hm.size() > 0) {
            ReturnMsg.append(EASResource.getString((String)"com.kingdee.eas.scm.im.inv.InvAddResource", (String)"billNO")).append("\r\n");
        }
        for (Map.Entry entry : hm.entrySet()) {
            ReturnMsg.append(entry.getKey());
            ReturnMsg.append(entry.getValue());
            ReturnMsg.append("\r\n");
        }
        return ReturnMsg.toString();
    }

    protected boolean isPCVoucherVisible() {
        return true;
    }

    @Override
    protected String getGeneralPCVoucherPermission() {
        return "purinwarehs_generalPcVoucher";
    }

    @Override
    protected String getStorageColName() {
        return "storageOrgUnit.id";
    }

    @Override
    protected void checkOtherForPCVoucher() throws Exception {
        super.checkOtherForPCVoucher();
        String[] isCreateVoucher = com.kingdee.eas.basedata.framework.util.KDTableUtil.getSelectRowFieldValue((KDTable)this.tblMain, (String)"isInitBill");
        for (int i = 0; i < isCreateVoucher.length; ++i) {
            if (!isCreateVoucher[i].equals("true")) continue;
            String isSelectInitBill = EASResource.getString((String)this.invAddResource, (String)"isInitBill");
            MsgBox.showInfo((String)isSelectInitBill);
            this.abort();
        }
    }

    protected BOSObjectType getBOSType() {
        return new PurInWarehsBillInfo().getBOSType();
    }

    public void onShow() throws Exception {
        if (this.getParent().getParent() instanceof KDTabbedPane) {
            KDTabbedPane tabbPane = (KDTabbedPane)this.getParent().getParent();
            if (this.isSubContractBill()) {
                for (int i = 0; i < tabbPane.getTabCount(); ++i) {
                    tabbPane.setTitleAt(i, this.transmitSubTitle(tabbPane.getTitleAt(i)));
                }
            }
        }
        super.onShow();
    }

    private String transmitSubTitle(String title) {
        String resultTitle = title;
        if (title.equals(EASResource.getString((String)MER_InvUI, (String)"PurInWarehsBill"))) {
            resultTitle = EASResource.getString((String)MER_InvUI, (String)"SubContractInWarehsBill");
        }
        if (title.equals(EASResource.getString((String)MER_InvUI, (String)"MaterialReqBill"))) {
            resultTitle = EASResource.getString((String)MER_InvUI, (String)"SubContractMatReqBill");
        }
        if (title.equals(EASResource.getString((String)MER_InvUI, (String)"PurReceivalBill"))) {
            resultTitle = EASResource.getString((String)MER_InvUI, (String)"SubContractReceivalBill");
        }
        return resultTitle;
    }

    public void setUITitle(String title) {
        this.windowTitle = this.isSubContractBill() ? EASResource.getString((String)MER_InvUI, (String)"SubContractInWarehsBill") : EASResource.getString((String)MER_InvUI, (String)"PurInWarehsBill");
        super.setUITitle(title);
    }

    @Override
    public void afterAction(BatchActionEnum bizAction, BatchSelectionEntries selectionEntries, int countSuccess) {
        super.afterAction(bizAction, selectionEntries, countSuccess);
        if (bizAction.equals((Object)BatchActionEnum.UNAUDIT) && this.writeOffRPurInIdList != null && this.writeOffRPurInIdList.size() > 0) {
            try {
                List purIdList;
                IWriteOffCommonFacade iWrite = WriteOffCommonFacadeFactory.getRemoteInstance();
                List idList = this.getSelectedIds(selectionEntries);
                idList = iWrite.getRedPurInIds(idList);
                if (idList != null && idList.size() > 0 && ((purIdList = iWrite.getPurInIdsByWOffRecord("103", idList, false)) == null || purIdList.size() < this.writeOffRPurInIdList.size())) {
                    this.writeOffRPurInIdList.removeAll(purIdList);
                    iWrite.synUnWriteOffQty(this.writeOffRPurInIdList);
                }
            }
            catch (EASBizException e) {
                this.handUIException(e);
            }
            catch (BOSException e) {
                this.handUIException(e);
            }
        }
    }

    private List<String> getSelectedIds(BatchSelectionEntries selectionEntries) {
        ArrayList<String> idList = new ArrayList<String>();
        List entryList = selectionEntries.getEntries();
        for (int i = 0; i < entryList.size(); ++i) {
            idList.add(((BatchSelectionEntry)entryList.get(i)).getId());
        }
        return idList;
    }
}

