/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.client;

import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.master.material.AsstAttrValueInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.scm.common.BizCategoryInfo;
import com.kingdee.eas.basedata.scm.common.BizTypeInfo;
import com.kingdee.eas.scm.im.inv.PurInWarehsEntryFactory;
import com.kingdee.eas.scm.im.inv.PurInWarehsEntryInfo;
import com.kingdee.eas.scm.im.inv.util.PurInwarehsUiHandlingHelper;
import com.kingdee.eas.scm.sm.pur.PurPriceInfo;
import com.kingdee.eas.scm.sm.pur.PurPriceInfoCollection;
import com.kingdee.eas.scm.sm.pur.PurPriceParam;
import com.kingdee.eas.scm.sm.pur.client.PurPriceCtrlStrategy;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;

public class PurPriceCtrlStrategyForPurInwhs
extends PurPriceCtrlStrategy {
    protected KDBizPromptBox prmtStorage = null;
    protected PurInwarehsUiHandlingHelper purInUiHelper = null;
    protected ExchangeRateInfo exchangeRateinfo = null;
    protected ArrayList<String> CenterPur = new ArrayList();
    protected static String TB_PURCHASECOST = "purchaseCost";
    protected static String TB_UNITPURCHASECOST = "unitPurchaseCost";

    public PurPriceCtrlStrategyForPurInwhs(KDTable table) {
        super(table);
    }

    public PurPriceParam getParamInfo(int rowIndex) {
        String bizCategoryId;
        PurPriceParam param = new PurPriceParam();
        IRow row = this.table.getRow(rowIndex);
        BizCategoryInfo categoryInfo = ((BizTypeInfo)this.prmtBizType.getValue()).getBizCategory();
        if (categoryInfo != null && ((bizCategoryId = categoryInfo.getId().toString()).equals("+f4mYqj4xUGaNf69/HWRdqk4kCA=") || bizCategoryId.equals("6LFeB81CJ0mD3wyAekUV7Kk4kCA="))) {
            param.setMaterialPurchaseType(1);
        }
        param.setBillTypeId(this.billTypeId);
        param.setSeq(rowIndex);
        if (this.chkIsInTax != null && this.chkIsInTax.isSelected()) {
            param.setInTax(true);
        }
        param.setBizDate((Date)this.pkBizDate.getValue());
        MaterialInfo material = null;
        Object obj = row.getCell(this.TB_MATERIAL).getValue();
        material = obj != null && obj instanceof Object[] ? (MaterialInfo)((Object[])obj)[0] : (MaterialInfo)obj;
        param.setMaterialId(material != null ? material.getId().toString() : null);
        Object unitO = row.getCell(this.TB_UNIT).getValue();
        param.setUnitId(unitO != null ? ((MeasureUnitInfo)unitO).getId().toString() : null);
        Object baseUnitO = row.getCell(this.TB_BASEUNIT).getValue();
        param.setBaseUnitId(baseUnitO != null ? ((MeasureUnitInfo)baseUnitO).getId().toString() : null);
        BigDecimal qty = (BigDecimal)row.getCell(this.TB_QTY).getValue();
        param.setQty(qty != null ? qty.abs() : qty);
        Object assistPropertyO = row.getCell(this.TB_ASSISTPROPERTY).getValue();
        param.setAssistPropertyId(assistPropertyO != null ? ((AsstAttrValueInfo)assistPropertyO).getId().toString() : null);
        param.setBizTypeId(this.getBizTypeId());
        Object currencyO = this.prmtCurrency.getValue();
        param.setCurrencyId(currencyO != null ? ((CurrencyInfo)currencyO).getId().toString() : null);
        Object purchaseOrgUnitO = row.getCell(this.TB_PURORGUNIT).getValue();
        param.setPurOrgUnitId(purchaseOrgUnitO != null ? ((OrgUnitInfo)purchaseOrgUnitO).getId().toString() : null);
        Object supplierO = this.prmtSupplier.getValue();
        param.setSupplierId(supplierO != null ? ((SupplierInfo)supplierO).getId().toString() : null);
        Object recOrg = this.prmtStorage.getValue();
        param.setRecOrgUnitId(recOrg != null ? ((StorageOrgUnitInfo)recOrg).getId().toString() : null);
        param.setDeliveryDate((Date)this.pkBizDate.getValue());
        return param;
    }

    public PurPriceParam getParam4FetchStrategy(int rowIndex) {
        PurPriceParam param = new PurPriceParam();
        IRow row = this.table.getRow(rowIndex);
        param.setMaterialPurchaseType(this.materialPurchaseType.getValue());
        param.setBillTypeId(this.billTypeId);
        param.setSeq(rowIndex + 1);
        Object purOrgO = row.getCell(this.TB_PURORGUNIT).getValue();
        param.setPurOrgUnitId(purOrgO != null ? ((OrgUnitInfo)purOrgO).getId().toString() : null);
        Object currencyO = this.prmtCurrency.getValue();
        param.setCurrencyId(currencyO != null ? ((CurrencyInfo)currencyO).getId().toString() : null);
        MaterialInfo material = null;
        Object obj = row.getCell(this.TB_MATERIAL).getValue();
        material = obj != null && obj instanceof Object[] ? (MaterialInfo)((Object[])obj)[0] : (MaterialInfo)obj;
        param.setMaterialId(material != null ? material.getId().toString() : null);
        MeasureUnitInfo unit = (MeasureUnitInfo)row.getCell(this.TB_UNIT).getValue();
        param.setUnitId(unit != null ? unit.getId().toString() : null);
        BigDecimal actualPrice = (BigDecimal)row.getCell(this.TB_ACTUALPRICE).getValue();
        param.setActualPrice(actualPrice);
        BigDecimal actualTaxPrice = (BigDecimal)row.getCell(this.TB_ACTUALTAXPRICE).getValue();
        param.setActualTaxPrice(actualTaxPrice);
        param.setBizTypeId(this.getBizTypeId());
        return param;
    }

    public void setCtrlStatusByIsInTax(IRow row) {
        if (this.chkIsInTax != null && this.chkIsInTax.isSelected()) {
            this.setLockStatus(row, new String[]{this.TB_PRICE, this.TB_AMOUNT}, true);
            this.setLockStatus(row, new String[]{this.TB_TAXPRICE, this.TB_TAXAMOUNT}, false);
        } else {
            this.setLockStatus(row, new String[]{this.TB_TAXPRICE, this.TB_TAXAMOUNT}, true);
            this.setLockStatus(row, new String[]{this.TB_PRICE, this.TB_AMOUNT}, false);
        }
        this.setLockStatus(row, new String[]{this.TB_DISCOUNTAMOUNT}, false);
        this.setLockStatus(row, new String[]{this.TB_DISCOUNTRATE}, false);
    }

    protected void setPrice(PurPriceInfoCollection priceInfoCol, int rowIndex) {
        IRow row = this.table.getRow(rowIndex);
        PurPriceInfo priceInfo = priceInfoCol.getPurPriceInfoBySeq(rowIndex);
        row.getCell(this.TB_PRICE).setUserObject(null);
        if (priceInfo == null) {
            return;
        }
        PurInWarehsEntryInfo entryInfo = this.getEntryInfo(row);
        if (entryInfo != null && entryInfo.isIsCenterBalance() && entryInfo.isIsBetweenCompanySend()) {
            this.CenterPur.add(entryInfo.getId().toString());
            return;
        }
        if (priceInfo != null && row.getCell(this.TB_EDITCTRL) != null) {
            row.getCell(this.TB_EDITCTRL).setValue((Object)priceInfo.getEditCtrl());
            this.setCtrlStatusByIsInTax(row);
            this.setCtrlStatus(row);
        }
        if (priceInfo != null && priceInfo.getTaxRate() != null && priceInfo.isHasPriceProvider()) {
            row.getCell(this.TB_TAXRATE).setValue((Object)priceInfo.getTaxRate().setScale(2));
        }
        if (priceInfo.getPrice() == null) {
            if ("currency".equals(priceInfo.getSource()) || "unit".equals(priceInfo.getSource()) || !priceInfo.isHasPriceProvider() || "bizDate".equalsIgnoreCase(priceInfo.getSource())) {
                return;
            }
            priceInfo.setPrice(this.zero.setScale(priceInfo.getPricePrecision(), 4));
        }
        row.getCell(this.TB_DISCOUNTRATE).setValue((Object)priceInfo.getDiscountRate());
        if (this.chkIsInTax != null && this.chkIsInTax.isSelected()) {
            if (!priceInfo.isInTaxPrice()) {
                BigDecimal price = priceInfo.getPrice();
                row.getCell(this.TB_PRICE).setValue((Object)price);
                this.purInUiHelper.calTaxPricebyPrice(rowIndex, 0);
                this.purInUiHelper.calByEntryTaxPriceForManual(rowIndex, 0, this.exchangeRateinfo);
            } else {
                row.getCell(this.TB_TAXPRICE).setValue((Object)priceInfo.getPrice());
                this.purInUiHelper.calByEntryTaxPrice(rowIndex, 0, this.exchangeRateinfo);
            }
        } else if (priceInfo.isInTaxPrice()) {
            BigDecimal taxPrice = priceInfo.getPrice();
            row.getCell(this.TB_TAXPRICE).setValue((Object)taxPrice);
            this.purInUiHelper.calPriceByTaxPrice(rowIndex, 0);
            this.purInUiHelper.calByPriceForManual(rowIndex, 0, this.exchangeRateinfo);
        } else {
            row.getCell(this.TB_PRICE).setValue((Object)priceInfo.getPrice());
            this.purInUiHelper.calByPrice(rowIndex, 0, this.exchangeRateinfo);
        }
        row.getCell(this.TB_PRICE).setUserObject((Object)priceInfo);
    }

    private PurInWarehsEntryInfo getEntryInfo(IRow row) {
        PurInWarehsEntryInfo entryInfo = null;
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("isCenterBalance"));
        selector.add(new SelectorItemInfo("isBetweenCompanySend"));
        if (((PurInWarehsEntryInfo)row.getUserObject()).getId() == null) {
            return null;
        }
        String entryId = ((PurInWarehsEntryInfo)row.getUserObject()).getId().toString();
        try {
            entryInfo = PurInWarehsEntryFactory.getRemoteInstance().getPurInWarehsEntryInfo((IObjectPK)new ObjectUuidPK(entryId), selector);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return entryInfo;
    }

    protected boolean isHasParam(int rowIndex) {
        boolean result = this.isUsePriceStragey();
        if (!result) {
            return result;
        }
        result = super.isHasParam(rowIndex);
        IRow row = this.table.getRow(rowIndex);
        if (row.getCell(this.TB_PURORGUNIT).getValue() == null) {
            return false;
        }
        return result;
    }

    private boolean isUsePriceStragey() {
        String bizTypeId;
        Object bizTypeO = this.prmtBizType.getValue();
        String string = bizTypeId = bizTypeO != null ? ((BizTypeInfo)bizTypeO).getId().toString() : null;
        if ("d8e80652-0117-1000-e000-04c5c0a812202407435C".equalsIgnoreCase(bizTypeId) || "ltQJK8kihHPgQKjAYj1jAyQHQ1w=".equalsIgnoreCase(bizTypeId)) {
            return false;
        }
        if ("LyS5ouN3YEPgQAB/AQBJsCQHQ1w=".equalsIgnoreCase(bizTypeId) || "ltQJdddQMebgQKjAYj1j1yQHQ1w=".equalsIgnoreCase(bizTypeId)) {
            return false;
        }
        if ("LyS5ouN4YEPgQAB/AQBJsCQHQ1w=".equalsIgnoreCase(bizTypeId) || "ltQJ0s1RqWzgQKjAYj1j3CQHQ1w=".equalsIgnoreCase(bizTypeId)) {
            return false;
        }
        return !"nhvcdx82RzuTw48FSlV79CQHQ1w=".equalsIgnoreCase(bizTypeId);
    }

    public void registerColumn(Map<String, String> columns) {
        super.registerColumn(columns);
        this.editCtrlFields.add(TB_PURCHASECOST);
        this.editCtrlFields.add(TB_UNITPURCHASECOST);
    }

    public KDBizPromptBox getPrmtStorage() {
        return this.prmtStorage;
    }

    public void setPrmtStorage(KDBizPromptBox prmtStorage) {
        this.prmtStorage = prmtStorage;
    }

    public PurInwarehsUiHandlingHelper getPurInUiHelper() {
        return this.purInUiHelper;
    }

    public void setPurInUiHelper(PurInwarehsUiHandlingHelper purInUiHelper) {
        this.purInUiHelper = purInUiHelper;
    }

    public ExchangeRateInfo getExchangeRateinfo() {
        return this.exchangeRateinfo;
    }

    public void setExchangeRateinfo(ExchangeRateInfo exchangeRateinfo) {
        this.exchangeRateinfo = exchangeRateinfo;
    }

    public ArrayList<String> getCenterPur() {
        return this.CenterPur;
    }
}

