/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.client;

import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.extendcontrols.ext.CommonF7KDTableListener;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.framework.util.FilterUtility;
import com.kingdee.eas.mm.common.client.UIHelper;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.client.ISCMBillStatusControl;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.client.SCMCommonF7KDTableListener;
import com.kingdee.eas.scm.common.filter.ColConnFilterElement;
import com.kingdee.eas.scm.common.filter.CompositeFilterElement;
import com.kingdee.eas.scm.common.filter.FilterElement;
import com.kingdee.eas.scm.common.filter.RangeFilterElement;
import com.kingdee.eas.scm.common.filter.SingleFilterElement;
import com.kingdee.eas.scm.common.util.SCMQueryFormat;
import com.kingdee.eas.scm.common.verify.VerifyItem;
import com.kingdee.eas.scm.common.verify.VerifyType;
import com.kingdee.eas.scm.im.inv.client.AbstractPurRecBillFilterUI;
import com.kingdee.eas.scm.im.inv.client.InvClientUtils;
import java.awt.Component;

public class PurRecBillFilterUI
extends AbstractPurRecBillFilterUI
implements ISCMBillStatusControl {
    private static final long serialVersionUID = -2710301735858218772L;
    private CompanyOrgUnitInfo cou = null;
    private boolean isSubContract = false;

    public PurRecBillFilterUI() throws Exception {
        this.getElementsInfo();
    }

    public PurRecBillFilterUI(boolean isSubContract) throws Exception {
        this();
        this.isSubContract = isSubContract;
    }

    private void getElementsInfo() {
        CompositeFilterElement elements = new CompositeFilterElement(0);
        elements.add((FilterElement)new RangeFilterElement("number", (Component)this.txtBillNumberFrom, (Component)this.txtBillNumberTo));
        elements.add((FilterElement)new RangeFilterElement("transactionType.number", (Component)this.bizTransactionFrom, (Component)this.bizTransactionTo));
        elements.add((FilterElement)new RangeFilterElement("sourceBillType.number", (Component)this.bizSorceBillTypeFrom, (Component)this.bizSorceBillTypeTo));
        elements.add((FilterElement)new RangeFilterElement("supplier.number", (Component)this.bizSupplyerFrom, (Component)this.bizSupplyerTo));
        elements.add((FilterElement)new RangeFilterElement("entry.purOrderNum", (Component)this.txtSourceBillFrom, (Component)this.txtSourceBillTo));
        elements.add((FilterElement)new RangeFilterElement("entry.material.number", (Component)this.bizMaterialNumberFrom, (Component)this.bizMaterialNumberTo));
        elements.add((FilterElement)new RangeFilterElement("entry.warehouse.number", (Component)this.bizStorageFrom, (Component)this.bizStorageTo));
        elements.add((FilterElement)new RangeFilterElement("project.number", (Component)this.prmtProjectNumFrom, (Component)this.prmtProjectNumTo));
        elements.add((FilterElement)new RangeFilterElement("trackNumber.number", (Component)this.prmtTrackNumFrom, (Component)this.prmtTrackNumTo));
        RangeFilterElement dateElements = new RangeFilterElement("bizDate", (Component)this.dateTranDateFrom, (Component)this.dateTranDateTo);
        dateElements.addVerifyItem(new VerifyItem(VerifyType.LESS_EQUAL_TYPE, SCMClientUtils.getResource((String)"CompareDate")));
        elements.add((FilterElement)dateElements);
        ColConnFilterElement mainOrgElement = new ColConnFilterElement("storageOrgUnit.id", (Component)this.bizStorageOrgFrom);
        mainOrgElement.addVerifyItem(new VerifyItem(VerifyType.REQUIRED_TYPE, InvClientUtils.getResource("StorageOrgUnitNotNull")));
        elements.add((FilterElement)mainOrgElement);
        elements.add((FilterElement)new SingleFilterElement("baseStatus", (Component)this.comboStatus, (Object)BillBaseStatusEnum.NULL));
        this.getFilterManager().setElement((FilterElement)elements);
        this.getFilterManager().setMainOrgElement((FilterElement)mainOrgElement, "storageOrgUnit.id");
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Storage;
    }

    private void setF7Filter() throws Exception {
        this.setBizMaterialF7(this.bizMaterialNumberFrom, false, null);
        this.setBizMaterialF7(this.bizMaterialNumberTo, false, null);
        this.bizSupplyerFrom.setDisplayFormat("$number$");
        this.bizSupplyerTo.setDisplayFormat("$number$");
        this.setBizSupplierF7(this.bizSupplyerFrom, null);
        this.setBizSupplierF7(this.bizSupplyerTo, null);
        this.bizSupplyerFrom.setDisplayFormat("$number$");
        this.bizSupplyerFrom.setCommitFormat("$number$;$mnemonicCode$;$name$");
        this.bizSupplyerTo.setDisplayFormat("$number$");
        this.bizSupplyerTo.setCommitFormat("$number$;$mnemonicCode$;$name$");
        this.f7Manager.registerContextChangeF7(this.txtBillNumberFrom, this.getPropertyOfMainBizOrg());
        this.f7Manager.registerContextChangeF7(this.txtBillNumberTo, this.getPropertyOfMainBizOrg());
        if (!this.isSubContract) {
            this.appendF7Filter(this.txtBillNumberFrom, this.getBillFilter(false));
            this.appendF7Filter(this.txtBillNumberTo, this.getBillFilter(false));
        }
        this.f7Manager.registerContextChangeF7(this.bizStorageFrom, this.getPropertyOfMainBizOrg());
        this.f7Manager.registerContextChangeF7(this.bizStorageTo, this.getPropertyOfMainBizOrg());
        this.txtBillNumberFrom.addCommonF7KDTableListener((CommonF7KDTableListener)new SCMCommonF7KDTableListener("baseStatus"));
        this.txtBillNumberTo.addCommonF7KDTableListener((CommonF7KDTableListener)new SCMCommonF7KDTableListener("baseStatus"));
        this.setNeedMainOrgF7s(new KDBizPromptBox[]{this.bizMaterialNumberFrom, this.bizMaterialNumberTo});
        this.setBillNumberF7s(new KDBizPromptBox[]{this.txtBillNumberFrom, this.txtBillNumberTo});
        UIHelper.registerProjectF7ForFilter((KDBizPromptBox)this.getMainBizOrgF7(), (KDBizPromptBox)this.prmtProjectNumFrom);
        UIHelper.registerProjectF7ForFilter((KDBizPromptBox)this.getMainBizOrgF7(), (KDBizPromptBox)this.prmtProjectNumTo);
        UIHelper.registerTrackNumberF7ForFilter((KDBizPromptBox)this.getMainBizOrgF7(), (KDBizPromptBox)this.prmtTrackNumFrom);
        UIHelper.registerTrackNumberF7ForFilter((KDBizPromptBox)this.getMainBizOrgF7(), (KDBizPromptBox)this.prmtTrackNumTo);
        InvClientUtils.setFilterForTransactionType(this.bizTransactionFrom, "101", this.isSubContract);
        InvClientUtils.setFilterForTransactionType(this.bizTransactionTo, "101", this.isSubContract);
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.setF7Filter();
        this.setDefaultValue();
        if (this.getMainBizOrgF7().getText() != null) {
            this.mainOrgChanged();
        }
    }

    protected void setDefaultValue() {
        SCMQueryFormat.formatStartTime((KDDatePicker)this.dateTranDateFrom);
        SCMQueryFormat.formatEndTime((KDDatePicker)this.dateTranDateTo);
        SCMQueryFormat.formatBillStatus((ISCMBillStatusControl)this, (KDComboBox)this.comboStatus);
    }

    public Object[] getUnVisibleBillStatus() {
        return new Object[]{BillBaseStatusEnum.RELEASED, BillBaseStatusEnum.BLOCKED};
    }

    public Object[] getAdditiveBillStatus() {
        return null;
    }

    public KDBizPromptBox getMainBizOrgF7() {
        return this.bizStorageOrgFrom;
    }

    protected String getViewPermission() {
        return "purreceival_view";
    }

    protected String getPropertyOfMainBizOrg() {
        return "storageOrgUnit.id";
    }

    public void afterMainOrgChanged(String ids) {
        if (this.bizStorageOrgFrom.getValue() != null) {
            EntityViewInfo evi;
            if (this.bizStorageOrgFrom.getValue() instanceof FullOrgUnitInfo) {
                StorageOrgUnitInfo sou = new StorageOrgUnitInfo();
                FullOrgUnitInfo fou = (FullOrgUnitInfo)this.bizStorageOrgFrom.getValue();
                sou.setId(fou.getId());
                this.cou = InvClientUtils.getCompanyInfo(sou);
            } else if (this.bizStorageOrgFrom.getValue() instanceof Object[]) {
                Object[] sous = (Object[])this.bizStorageOrgFrom.getValue();
                if (sous[0] instanceof FullOrgUnitInfo) {
                    StorageOrgUnitInfo sou = new StorageOrgUnitInfo();
                    FullOrgUnitInfo fou = (FullOrgUnitInfo)sous[0];
                    sou.setId(fou.getId());
                    this.cou = InvClientUtils.getCompanyInfo(sou);
                } else {
                    this.cou = InvClientUtils.getCompanyInfo((StorageOrgUnitInfo)sous[0]);
                }
            } else {
                this.cou = InvClientUtils.getCompanyInfo((StorageOrgUnitInfo)this.bizStorageOrgFrom.getValue());
            }
            if (this.cou != null) {
                this.bizSupplyerFrom.setCurrentMainBizOrgUnit((OrgUnitInfo)this.cou, OrgType.Storage);
                this.bizSupplyerTo.setCurrentMainBizOrgUnit((OrgUnitInfo)this.cou, OrgType.Storage);
                evi = new EntityViewInfo();
                FilterInfo fi = new FilterInfo();
                fi.getFilterItems().add(new FilterItemInfo("companyOrgUnit.id", (Object)this.cou.getId().toString(), CompareType.EQUALS));
                evi.setFilter(fi);
                this.bizSupplyerFrom.setEntityViewInfo(evi);
                this.bizSupplyerTo.setEntityViewInfo(evi);
            } else {
                evi = new EntityViewInfo();
                this.bizSupplyerFrom.setEntityViewInfo(evi);
                this.bizSupplyerTo.setEntityViewInfo(evi);
            }
        }
        if (this.isSubContract) {
            this.setSubContractF7Filters();
        }
    }

    private void appendF7Filter(KDBizPromptBox bizMaterialBox, FilterInfo filterInfo) {
        if (bizMaterialBox != null) {
            EntityViewInfo entityViewInfo = bizMaterialBox.getEntityViewInfo();
            if (entityViewInfo == null || !FilterUtility.hasFilterItem((FilterInfo)entityViewInfo.getFilter())) {
                entityViewInfo = new EntityViewInfo();
                entityViewInfo.setFilter(filterInfo);
            } else {
                try {
                    entityViewInfo.getFilter().mergeFilter(filterInfo, "AND");
                }
                catch (Exception e) {
                    this.handUIException(e);
                }
            }
            bizMaterialBox.setEntityViewInfo(entityViewInfo);
        }
    }

    private FilterInfo getSupplierFilter(boolean isSubContract) {
        FilterInfo filterInfo = new FilterInfo();
        FilterItemInfo info = null;
        info = isSubContract ? new FilterItemInfo("isOuter", (Object)new Integer(1)) : new FilterItemInfo("isOuter", (Object)new Integer(0));
        filterInfo.getFilterItems().add(info);
        return filterInfo;
    }

    private FilterInfo getBillFilter(boolean isSubContract) {
        FilterInfo filterInfo = new FilterInfo();
        FilterItemInfo info = null;
        info = isSubContract ? new FilterItemInfo("purchaseType", (Object)new Integer(1)) : new FilterItemInfo("purchaseType", (Object)new Integer(0));
        filterInfo.getFilterItems().add(info);
        return filterInfo;
    }

    private FilterInfo getMaterialFilter(boolean isSubContract) {
        FilterInfo filterInfo = new FilterInfo();
        if (isSubContract) {
            filterInfo.getFilterItems().add(new FilterItemInfo("isOutsourcedPart", (Object)new Integer(1)));
        }
        return filterInfo;
    }

    private void setSubContractF7Filters() {
        this.appendF7Filter(this.txtBillNumberFrom, this.getBillFilter(this.isSubContract));
        this.appendF7Filter(this.txtBillNumberTo, this.getBillFilter(this.isSubContract));
        this.appendF7Filter(this.bizSupplyerFrom, this.getSupplierFilter(this.isSubContract));
        this.appendF7Filter(this.bizSupplyerTo, this.getSupplierFilter(this.isSubContract));
        this.appendF7Filter(this.bizMaterialNumberFrom, this.getMaterialFilter(this.isSubContract));
        this.appendF7Filter(this.bizMaterialNumberTo, this.getMaterialFilter(this.isSubContract));
    }

    @Override
    public boolean isPrepareInit() {
        return true;
    }
}

