/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.dao.query.BizEnumValueDTO;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.CustomerQueryPanel;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.scm.im.inv.MaterialSNInventoryFactory;
import com.kingdee.eas.scm.im.inv.SerialNumberException;
import com.kingdee.eas.scm.im.inv.client.AbstractSerialNumberInventoryListUI;
import com.kingdee.eas.scm.im.inv.client.MaterialSNInventoryFilterUI;
import com.kingdee.eas.tools.datatask.DatataskParameter;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class SerialNumberInventoryListUI
extends AbstractSerialNumberInventoryListUI {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = CoreUIObject.getLogger(SerialNumberInventoryListUI.class);
    private static final String SN_RESOURCE = "com.kingdee.eas.scm.im.inv.SerialNumberResource";
    private CommonQueryDialog queryDialog = null;
    private MaterialSNInventoryFilterUI userPanel = null;

    public SerialNumberInventoryListUI() throws Exception {
        this.tblMain.checkParsed();
        this.tblMain.setEditable(false);
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.btnAddNew.setVisible(false);
        this.btnView.setVisible(false);
        this.btnEdit.setVisible(false);
        this.btnLocate.setVisible(false);
        this.btnCreateTo.setVisible(false);
        this.btnTraceUp.setVisible(false);
        this.btnTraceDown.setVisible(false);
        this.btnWorkFlowG.setVisible(false);
        this.btnAttachment.setVisible(false);
        this.btnAuditResult.setVisible(false);
        this.menuItemAddNew.setVisible(false);
        this.MenuItemAttachment.setVisible(false);
        this.menuItemEdit.setVisible(false);
        this.menuItemCreateTo.setVisible(false);
        this.menuItemCopyTo.setVisible(false);
        this.menuItemView.setVisible(false);
        this.menuItemLocate.setVisible(false);
        this.menuItemTraceUp.setVisible(false);
        this.menuItemTraceDown.setVisible(false);
        this.menuWorkFlow.setVisible(false);
        this.menuItemImportData.setVisible(true);
        this.btnSNImport.setIcon(EASResource.getIcon((String)"imgTbtn_input"));
        this.tblMain.setColumnMoveable(true);
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        if (MsgBox.isYes((int)MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Confirm_Delete")))) {
            ArrayList list = new ArrayList();
            KDTSelectBlock selectBlock = null;
            int mSize = this.tblMain.getSelectManager().size();
            for (int p = mSize - 1; p >= 0; --p) {
                selectBlock = this.tblMain.getSelectManager().get(p);
                if (selectBlock == null) continue;
                for (int i = selectBlock.getEndRow(); i >= selectBlock.getTop(); --i) {
                    HashMap<String, String> dataMap = new HashMap<String, String>();
                    IRow row = this.tblMain.getRow(i);
                    BizEnumValueDTO snStatus = (BizEnumValueDTO)row.getCell("snStatus").getValue();
                    if (Integer.parseInt(snStatus.getValue().toString()) != 4) {
                        throw new SerialNumberException(SerialNumberException.CANNOTDELETE_WAITIN);
                    }
                    String materialID = row.getCell("material.id").getValue().toString();
                    String serialNumber = row.getCell("serialNumber").getValue().toString();
                    dataMap.put("materialID", materialID);
                    dataMap.put("serialNumber", serialNumber);
                    list.add(dataMap);
                }
            }
            if (list.size() > 0) {
                MaterialSNInventoryFactory.getRemoteInstance().deleteMaterialSNInventory(list);
                this.actionRefresh_actionPerformed(e);
            }
        }
    }

    protected ArrayList getImportParam() {
        String solutionName;
        DatataskParameter param = new DatataskParameter();
        param.solutionName = solutionName = "eas.30im.MaterialSNInventory";
        param.alias = EASResource.getString((String)SN_RESOURCE, (String)"SNInventoryImport");
        ArrayList<DatataskParameter> paramList = new ArrayList<DatataskParameter>();
        paramList.add(param);
        return paramList;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return MaterialSNInventoryFactory.getRemoteInstance();
    }

    public void actionQuery4Inventory() {
        this.toolBar.setVisible(false);
    }

    protected CommonQueryDialog initCommonQueryDialog() {
        if (this.queryDialog != null) {
            return this.queryDialog;
        }
        this.queryDialog = super.initCommonQueryDialog();
        try {
            this.queryDialog.addUserPanel((KDPanel)this.getUserPanel());
            this.queryDialog.setUiObject(null);
            this.queryDialog.setHeight(200);
            this.queryDialog.setWidth(450);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
            this.handUIException(e);
        }
        return this.queryDialog;
    }

    protected CustomerQueryPanel getUserPanel() throws Exception {
        if (this.userPanel == null) {
            this.userPanel = new MaterialSNInventoryFilterUI();
        }
        return this.userPanel;
    }

    protected boolean isIgnoreCUFilter() {
        return true;
    }

    protected boolean initDefaultFilter() {
        return true;
    }

    protected boolean innerCheckPartSum() {
        return false;
    }

    public int getMaxReturnRowCount() {
        return -1;
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.ControlUnit;
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
    }
}

