/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.SQLExecutor;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.netctrl.MutexLockType;
import com.kingdee.eas.base.netctrl.MutexParameter;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.DelegationPartsEnum;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.IOrgUnitRelation;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.org.client.f7.OrgUnitDelegationF7;
import com.kingdee.eas.basedata.scm.im.inv.ISOAccreditWH;
import com.kingdee.eas.basedata.scm.im.inv.SOAccreditWHFactory;
import com.kingdee.eas.basedata.scm.im.inv.SOAccreditWHInfo;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.scm.common.ISCMInitialization;
import com.kingdee.eas.scm.common.SCMInitializationFactory;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.client.SCMGroupClientUtils;
import com.kingdee.eas.scm.common.service.SCMServiceFactory;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.common.util.SortUtil;
import com.kingdee.eas.scm.common.util.StringUtil;
import com.kingdee.eas.scm.im.inv.client.AbstractStartSCMGuideUI;
import com.kingdee.eas.scm.im.inv.client.InvClientUtils;
import com.kingdee.eas.util.client.ComponentUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.Uuid;
import com.kingdee.util.db.SQLUtils;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class StartSCMGuideUI
extends AbstractStartSCMGuideUI
implements ChangeListener,
ActionListener,
Runnable {
    private static final Logger logger = CoreUIObject.getLogger(StartSCMGuideUI.class);
    private boolean isInvSystem;
    private String companyID = "";
    private String storageID = "";
    private String warehouseID = "";
    private String calType = "";
    private boolean isProcessing;
    private static String closing;
    private PeriodInfo curPeriod = null;
    private PeriodInfo startPeriod = null;
    private OrgUnitInfo[] mainOrgs = null;
    private int idxDefaultMainOrg = -1;
    private OrgUnitCollection authorizedMainOrgs = null;

    public boolean destroyWindow() {
        if (this.isProcessing) {
            MsgBox.showInfo((Component)((Object)this), (String)closing);
            return false;
        }
        return super.destroyWindow();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        String uiParam = null;
        uiParam = this.getUIContext().get("UIClassParam") != null ? this.getUIContext().get("UIClassParam").toString() : "inv";
        this.isInvSystem = uiParam.equalsIgnoreCase("inv");
        UserInfo user = SysContext.getSysContext().getCurrentUserInfo();
        FullOrgUnitCollection fullOrgUnitCollection = SCMGroupClientUtils.getAuthOrgByPermItem((IObjectPK)new ObjectUuidPK(user.getId()), (OrgType)OrgType.Company, (String)"inventorycheckaccount_end");
        this.pmtCompany.setEntityViewInfo(this.getCommpanyEntityViewInfo(fullOrgUnitCollection));
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)this.pmtCompany.getValue();
        if (company != null) {
            OrgUnitCollection orgUnitCollection = SCMGroupClientUtils.getOrgsByRelation((OrgType)OrgType.Company, (OrgType)OrgType.Storage, (BOSUuid)company.getId());
            this.pmtStorage.setEntityViewInfo(InvClientUtils.getOrgEntityViewInfo(orgUnitCollection));
        }
        this.kDScrollPane1.setLocation(140, 32);
        this.kDScrollPane1.setSize(305, 91);
        this.kDScrollPane1.setAutoscrolls(true);
        this.kDScrollPane1.setVerticalScrollBarPolicy(20);
        this.pmtCompany.addChangeListener((ChangeListener)this);
        this.pmtStorage.addChangeListener((ChangeListener)this);
        this.btnHelp.addActionListener((ActionListener)this);
        this.rdBtnStart.setSelected(true);
        this.kdtExplain.setWrapStyleWord(false);
        this.kdtExplain.setText("        " + InvClientUtils.getResource("StartSCMSystemExplain"));
        this.lblImage.setIcon(EASResource.getIcon((String)"imgGuide_pic260"));
        this.isProcessing = false;
        closing = InvClientUtils.getResource("CLOSING");
        if (!this.isInvSystem) {
            this.kDLabelContainer2.setVisible(false);
            this.kDLabelContainer3.setVisible(false);
        }
        this.btnHelp.setVisible(false);
        OrgUnitInfo aOrgUnitInfo = this.getDefaultMainBizOrg();
        this.getMainBizOrg().setValue((Object)aOrgUnitInfo);
        this.pmtWarehouse.setEnabled(false);
        this.pmtWarehouse.setEditable(false);
        this.kdtExplain.setWrapStyleWord(true);
        this.kdtExplain.setLineWrap(true);
    }

    public String getUITitle() {
        return InvClientUtils.getResource("StartSCMSystem");
    }

    private boolean checkData() throws BOSException, EASBizException {
        Object co = this.pmtCompany.getValue();
        Object st = this.pmtStorage.getValue();
        Object wh = this.pmtWarehouse.getValue();
        if (co == null) {
            MsgBox.showInfo((Component)((Object)this), (String)InvClientUtils.getResource("CompanyIsNull"));
            return false;
        }
        this.companyID = ((CompanyOrgUnitInfo)co).getId().toString();
        if (st == null && wh != null) {
            MsgBox.showInfo((Component)((Object)this), (String)InvClientUtils.getResource("StorageOrgUnitNotNull"));
            return false;
        }
        this.storageID = st != null ? ((StorageOrgUnitInfo)this.pmtStorage.getValue()).getId().toString() : "";
        this.warehouseID = wh != null ? ((WarehouseInfo)this.pmtWarehouse.getValue()).getId().toString() : "";
        IParamControl ipc = ParamControlFactory.getRemoteInstance();
        ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)this.companyID));
        this.calType = ipc.getParamValue((IObjectPK)pk, "SCM_CAL_002");
        if (this.calType.length() <= 0) {
            MsgBox.showInfo((Component)((Object)this), (String)InvClientUtils.getResource("calTypeIsNull"));
            return false;
        }
        return true;
    }

    private boolean isHasInitBill() throws EASBizException, BOSException {
        int count;
        String storageIds = "";
        if (this.storageID != null && this.storageID.trim().length() > 0) {
            storageIds = "'" + this.storageID + "'";
        } else {
            IOrgUnitRelation iOrgUnitRelation = OrgUnitRelationFactory.getRemoteInstance();
            OrgUnitCollection coll = iOrgUnitRelation.getFromUnit(this.companyID, 1, 4);
            count = coll.size();
            if (coll != null && count > 0) {
                for (int i = 0; i < count; ++i) {
                    IObjectValue value = coll.getObject(i);
                    storageIds = storageIds + "'" + value.get("id").toString() + "'";
                    if (i == count - 1) continue;
                    storageIds = storageIds + ",";
                }
            }
        }
        StringBuffer sql = new StringBuffer();
        sql.append("select count(1) nums from T_IM_InventoryInitBill bill ");
        sql.append("left join T_IM_InventoryInitEntry entry on bill.FID = entry.FParentID ");
        sql.append("where bill.FCompanyOrgUnitID = '" + this.companyID + "'");
        if (!StringUtil.isEmpty((String)storageIds.toString())) {
            sql.append("and bill.FStorageOrgUnitID in (" + storageIds + ") ");
        }
        if (!StringUtil.isEmpty((String)this.warehouseID)) {
            sql.append("and entry.FWarehouseID = '" + this.warehouseID + "'");
        }
        IRowSet rs = new SQLExecutor(sql.toString()).executeSQL();
        try {
            if (rs.next() && rs.getInt("nums") > 0) {
                count = 1;
                return count != 0;
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((ResultSet)rs);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void finishInit() throws EASBizException, BOSException {
        String complete;
        Window window;
        block16: {
            block15: {
                block14: {
                    window = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
                    ComponentUtil.setWindowsCursorOfWair((Window)window);
                    complete = null;
                    if (!this.checkData()) {
                        ComponentUtil.setWindowCursorOfDefault((Window)window);
                        this.btnExit.setEnabled(true);
                        return;
                    }
                    this.btnExit.setEnabled(false);
                    this.btnStart.setEnabled(false);
                    this.isProcessing = true;
                    try {
                        ISCMInitialization iSCMInitialize = SCMInitializationFactory.getRemoteInstanceWithObjectContext((Context)this.getMainOrgContext());
                        HashMap<String, Serializable> hm = new HashMap<String, Serializable>();
                        HashMap<String, String> hmEntry = new HashMap<String, String>();
                        hmEntry.put("CompanyID", this.companyID);
                        hmEntry.put("StorageID", this.storageID);
                        hmEntry.put("WarehouseID", this.warehouseID);
                        hmEntry.put("calType", this.calType);
                        hm.put("STOCK", hmEntry);
                        hm.put("isInit", new Boolean(true));
                        if (this.isInvSystem) {
                            String beforeClsoe = InvClientUtils.getResource("BEFORECLOSE");
                            String closing = InvClientUtils.getResource("CLOSING");
                            complete = InvClientUtils.getResource("StartSCMSystemComplete");
                            this.progressBar.setStringPainted(true);
                            this.progressBar.setString(beforeClsoe);
                            this.progressBar.setIndeterminate(true);
                            if (iSCMInitialize.isClosed(hm) == null) {
                                this.progressBar.setVisible(false);
                                this.btnExit.setEnabled(true);
                                ComponentUtil.setWindowCursorOfDefault((Window)window);
                                String ret = InvClientUtils.getResource("NotInitObject");
                                MsgBox.showInfo((Component)((Object)this), (String)ret);
                                ComponentUtil.setWindowCursorOfDefault((Window)window);
                                break block14;
                            }
                            this.progressBar.setVisible(true);
                            if (!this.isHasInitBill()) {
                                this.progressBar.setIndeterminate(false);
                                String ret = InvClientUtils.getResource("ISHASINITBILLS");
                                int retVal = MsgBox.showConfirm3((Component)((Object)this), (String)ret);
                                if (!MsgBox.isYes((int)retVal)) {
                                    this.progressBar.setVisible(false);
                                    this.btnExit.setEnabled(true);
                                    ComponentUtil.setWindowCursorOfDefault((Window)window);
                                    break block15;
                                }
                                this.progressBar.setIndeterminate(true);
                            }
                            this.progressBar.setString(closing);
                            iSCMInitialize.invEndInitialize(hm);
                        } else if (!SystemStatusCtrolUtils.isStart(null, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)((CompanyOrgUnitInfo)this.pmtCompany.getData()))) {
                            iSCMInitialize.endInitialize(hm);
                        }
                        this.setWarehouseFilter();
                        ComponentUtil.setWindowCursorOfDefault((Window)window);
                        break block16;
                    }
                    catch (Exception exception) {
                        this.isProcessing = false;
                        this.progressBar.setIndeterminate(false);
                        this.progressBar.setValue(this.progressBar.getMaximum());
                        this.progressBar.setVisible(false);
                        this.handUIException(exception);
                        return;
                    }
                }
                this.btnExit.setEnabled(true);
                this.btnStart.setEnabled(true);
                this.progressBar.setIndeterminate(false);
                this.progressBar.setValue(this.progressBar.getMaximum());
                this.progressBar.setString(complete);
                this.isProcessing = false;
                return;
            }
            this.btnExit.setEnabled(true);
            this.btnStart.setEnabled(true);
            this.progressBar.setIndeterminate(false);
            this.progressBar.setValue(this.progressBar.getMaximum());
            this.progressBar.setString(complete);
            this.isProcessing = false;
            return;
        }
        this.btnExit.setEnabled(true);
        this.btnStart.setEnabled(true);
        this.progressBar.setIndeterminate(false);
        this.progressBar.setValue(this.progressBar.getMaximum());
        this.progressBar.setString(complete);
        this.isProcessing = false;
        return;
        finally {
            ComponentUtil.setWindowCursorOfDefault((Window)window);
            this.btnExit.setEnabled(true);
            this.btnStart.setEnabled(true);
            this.progressBar.setIndeterminate(false);
            this.progressBar.setValue(this.progressBar.getMaximum());
            this.progressBar.setString(complete);
            this.isProcessing = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unFinishInit() throws EASBizException, BOSException {
        Window window = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
        ComponentUtil.setWindowsCursorOfWair((Window)window);
        String complete = null;
        if (!this.checkData()) {
            ComponentUtil.setWindowCursorOfDefault((Window)window);
            this.btnExit.setEnabled(true);
            return;
        }
        this.btnExit.setEnabled(false);
        this.btnStart.setEnabled(false);
        this.isProcessing = true;
        try {
            HashMap<String, Serializable> hm = new HashMap<String, Serializable>();
            HashMap<String, String> hmEntry = new HashMap<String, String>();
            hmEntry.put("CompanyID", this.companyID);
            hmEntry.put("StorageID", this.storageID);
            hmEntry.put("WarehouseID", this.warehouseID);
            hmEntry.put("calType", this.calType);
            hm.put("STOCK", hmEntry);
            hm.put("isInvSystem", new Boolean(this.isInvSystem));
            String resource = "com.kingdee.eas.scm.im.inv.InvAddResource";
            if (!SystemStatusCtrolUtils.isStart(null, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)((CompanyOrgUnitInfo)this.pmtCompany.getData()))) {
                String ret = EASResource.getString((String)resource, (String)"NotHasInitBill");
                MsgBox.showInfo((Component)((Object)this), (String)ret);
                return;
            }
            complete = EASResource.getString((String)resource, (String)"UNStartSCMSystemComplete");
            this.progressBar.setStringPainted(true);
            this.progressBar.setIndeterminate(true);
            this.progressBar.setVisible(true);
            ISCMInitialization iSCMInitialize = SCMInitializationFactory.getRemoteInstanceWithObjectContext((Context)this.getMainOrgContext());
            HashMap msgHm = iSCMInitialize.unInitialize(hm);
            Boolean successAllCompany = (Boolean)msgHm.get("SuccessAllCompany");
            StringBuffer unInitSuccess = new StringBuffer(EASResource.getString((String)resource, (String)"Msg_UnInit_Success"));
            if (successAllCompany.booleanValue()) {
                unInitSuccess.append("\n").append(EASResource.getString((String)resource, (String)"AllCompanyUnInit"));
            }
            if (msgHm.get("SuccMsg") != null) {
                String succMsg = (String)msgHm.get("SuccMsg");
                String whInitSuccess = EASResource.getString((String)resource, (String)"WareHousSuccessList");
                MsgBox.showDetailAndOK((Component)((Object)this), (String)unInitSuccess.toString(), (String)(whInitSuccess + "\n" + succMsg), (int)1);
            }
            this.progressBar.setString(complete);
            this.setWarehouseFilter();
        }
        catch (Exception exception) {
            this.isProcessing = false;
            this.progressBar.setIndeterminate(false);
            this.progressBar.setValue(this.progressBar.getMaximum());
            this.progressBar.setVisible(false);
            this.handUIException(exception);
        }
        finally {
            ComponentUtil.setWindowCursorOfDefault((Window)window);
            this.btnExit.setEnabled(true);
            this.btnStart.setEnabled(true);
            this.progressBar.setIndeterminate(false);
            this.progressBar.setValue(this.progressBar.getMaximum());
            this.isProcessing = false;
        }
    }

    private IObjectPK[] getRecordNumber(boolean isClosed) throws EASBizException, BOSException {
        ISOAccreditWH iso = SOAccreditWHFactory.getRemoteInstance();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("COMPANY", (Object)this.companyID, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("ISSTARTED", (Object)isClosed, CompareType.NOTEQUALS));
        if (this.storageID.length() > 0) {
            filter.getFilterItems().add(new FilterItemInfo("STORAGEORG", (Object)this.storageID, CompareType.EQUALS));
        }
        return iso.getPKList(filter, null);
    }

    @Override
    protected void btnStart_actionPerformed(ActionEvent e) throws Exception {
        Thread t = new Thread(this);
        t.setName("Thread for StartSCMGuideUI");
        t.start();
    }

    @Override
    protected void rdBtnStart_actionPerformed(ActionEvent e) throws Exception {
        this.pmtWarehouse.setValue(null);
        this.setWarehouseFilter();
    }

    @Override
    protected void rdBtnINStart_actionPerformed(ActionEvent e) throws Exception {
        this.pmtWarehouse.setValue(null);
        this.setWarehouseFilter();
    }

    private void setWarehouseFilter() throws Exception {
        StorageOrgUnitInfo sou = (StorageOrgUnitInfo)this.pmtStorage.getValue();
        if (sou != null) {
            this.pmtWarehouse.setEditable(true);
            this.pmtWarehouse.setEnabled(true);
            if (this.rdBtnStart.isSelected()) {
                this.pmtWarehouse.setEntityViewInfo(InvClientUtils.getWarehouseFilter(sou, 0));
            } else {
                PeriodInfo curPeriod = this.getCurPeriod();
                this.pmtWarehouse.setEntityViewInfo(InvClientUtils.getWarehouseFilter(sou, curPeriod, 1));
            }
        } else {
            this.pmtWarehouse.setEnabled(false);
            this.pmtWarehouse.setEditable(false);
        }
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    private void setStorageFilter(CompanyOrgUnitInfo cou) {
        if (cou != null) {
            OrgUnitDelegationF7 oudf7 = new OrgUnitDelegationF7(this.pmtStorage, DelegationPartsEnum.THE_FROM_UNIT, OrgType.Storage);
            oudf7.setTheGivenOrgUnit(cou.getId().toString(), OrgType.Company);
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (((KDBizPromptBox)e.getSource()).equals(this.pmtCompany) && this.pmtCompany.getValue() != null) {
            this.pmtStorage.setValue(null);
            this.setStorageFilter((CompanyOrgUnitInfo)this.pmtCompany.getValue());
        } else if (((KDBizPromptBox)e.getSource()).equals(this.pmtStorage)) {
            try {
                if (this.pmtStorage.getValue() != null) {
                    this.pmtWarehouse.setValue(null);
                    StorageOrgUnitInfo sou = (StorageOrgUnitInfo)this.pmtStorage.getValue();
                    CompanyOrgUnitInfo cou = InvClientUtils.getCompanyInfo(sou);
                    ChangeListener changeListeners = this.pmtCompany.getChangeListeners()[0];
                    this.pmtCompany.removeChangeListener(changeListeners);
                    this.pmtCompany.setValue((Object)cou);
                    this.pmtCompany.addChangeListener(changeListeners);
                }
                this.setWarehouseFilter();
            }
            catch (Exception e1) {
                this.handUIException(e1);
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        int rows = 0;
        Uuid[] mutextIDs = null;
        Uuid mutexUuid = null;
        try {
            ISOAccreditWH iso = SOAccreditWHFactory.getRemoteInstance();
            IObjectPK[] pks = this.getRecordNumber(false);
            rows = pks.length;
            mutextIDs = new Uuid[rows];
            String mutextStorageID = null;
            for (int i = 0; i < rows; ++i) {
                SOAccreditWHInfo so = iso.getSOAccreditWHInfo(pks[i]);
                if (so == null) continue;
                mutextStorageID = so.getStorageOrg();
                mutexUuid = Uuid.create();
                String actionName = "FinishInitAction";
                MutexParameter tempMutext = SCMClientUtils.setMutexParameter((Uuid)mutexUuid, (String)mutextStorageID, (String)actionName, (MutexLockType)MutexLockType.EXCLUSIVE_LOCK);
                SCMUtils.requestMutex((MutexParameter)tempMutext);
            }
            if (this.rdBtnStart.isSelected()) {
                this.finishInit();
            } else {
                this.unFinishInit();
            }
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            this.handUIException(e);
        }
        catch (EASBizException e) {
            this.handUIException(e);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        finally {
            if (mutextIDs != null && rows > 0) {
                try {
                    for (int i = 0; i < rows; ++i) {
                        mutexUuid = mutextIDs[i];
                        if (mutexUuid == null) continue;
                        SCMUtils.releaseMutex((Uuid)mutexUuid);
                    }
                }
                catch (EASBizException e) {
                    this.handUIException(e);
                }
                catch (BOSException e) {
                    this.handUIException(e);
                }
            }
        }
    }

    public PeriodInfo getCurPeriod() throws Exception {
        if (this.curPeriod == null && (CompanyOrgUnitInfo)this.pmtCompany.getData() != null) {
            this.curPeriod = SystemStatusCtrolUtils.getCurrentPeriod(null, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)((CompanyOrgUnitInfo)this.pmtCompany.getData()));
        }
        return this.curPeriod;
    }

    public PeriodInfo getStartPeriod() throws Exception {
        if (this.startPeriod == null && (CompanyOrgUnitInfo)this.pmtCompany.getData() != null) {
            this.startPeriod = SystemStatusCtrolUtils.getStartPeriod(null, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)((CompanyOrgUnitInfo)this.pmtCompany.getData()));
        }
        return this.startPeriod;
    }

    protected KDBizPromptBox getMainBizOrg() {
        return this.pmtCompany;
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Company;
    }

    protected final OrgUnitInfo getDefaultMainBizOrg() {
        OrgUnitInfo currentMainOrg;
        if (this.idxDefaultMainOrg > -1) {
            return this.mainOrgs[this.idxDefaultMainOrg];
        }
        if (this.mainOrgs == null) {
            this.gainAuthMainBizOrgs();
        }
        if ((currentMainOrg = SysContext.getSysContext().getCurrentOrgUnit(this.getMainBizOrgType())) != null && this.mainOrgs.length > 0) {
            for (int i = 0; i < this.mainOrgs.length; ++i) {
                if (!currentMainOrg.getId().toString().equals(this.mainOrgs[i].getId().toString()) || currentMainOrg.isIsOUSealUp()) continue;
                this.idxDefaultMainOrg = i;
                return currentMainOrg;
            }
        }
        if (this.mainOrgs.length > 0) {
            this.idxDefaultMainOrg = 0;
            return this.mainOrgs[0];
        }
        return null;
    }

    private void gainAuthMainBizOrgs() {
        if (this.mainOrgs == null) {
            try {
                if (this.authorizedMainOrgs == null) {
                    this.mainOrgs = SCMServiceFactory.getPermissionService().getAuthorizedBizOrgUnits((IObjectPK)new ObjectStringPK(SysContext.getSysContext().getCurrentUserInfo().getId().toString()), this.getMainBizOrgType(), this.getViewPermission());
                } else {
                    int size = this.authorizedMainOrgs.size();
                    this.mainOrgs = new OrgUnitInfo[size];
                    if (size > 0) {
                        Object[] objects = this.authorizedMainOrgs.toArray();
                        System.arraycopy(objects, 0, this.mainOrgs, 0, size);
                    }
                }
                if (this.mainOrgs == null) {
                    this.mainOrgs = new OrgUnitInfo[0];
                }
                if (this.mainOrgs.length > 0) {
                    ArrayList<OrgUnitInfo> tempOrgArray = new ArrayList<OrgUnitInfo>();
                    for (int i = 0; i < this.mainOrgs.length; ++i) {
                        if (this.mainOrgs[i].isIsOUSealUp()) continue;
                        tempOrgArray.add(this.mainOrgs[i]);
                    }
                    this.mainOrgs = tempOrgArray.toArray(new OrgUnitInfo[tempOrgArray.size()]);
                    if (this.mainOrgs.length > 0) {
                        this.mainOrgs = (OrgUnitInfo[])SortUtil.sortDataByNumber((DataBaseInfo[])this.mainOrgs, (boolean)true);
                    }
                }
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        }
    }

    protected String getViewPermission() {
        return "inventorycheckaccount_end";
    }

    protected EntityViewInfo getCommpanyEntityViewInfo(FullOrgUnitCollection collcetion) throws BOSException, EASBizException {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        CompanyOrgUnitInfo cou = new CompanyOrgUnitInfo();
        StringBuffer stringBuffer = new StringBuffer();
        String companyOrgUnitIDs = null;
        for (int i = 0; i < collcetion.size(); ++i) {
            cou.setId(collcetion.get(i).getId());
            if (cou == null || cou.getId() == null) continue;
            stringBuffer.append(cou.getId().toString());
            stringBuffer.append(",");
        }
        companyOrgUnitIDs = stringBuffer.toString();
        if (companyOrgUnitIDs.length() > 0) {
            companyOrgUnitIDs = companyOrgUnitIDs.substring(0, companyOrgUnitIDs.length() - 1);
            fi.getFilterItems().add(new FilterItemInfo("id", (Object)companyOrgUnitIDs, CompareType.INCLUDE));
            fi.getFilterItems().add(new FilterItemInfo("isBizUnit", (Object)Boolean.TRUE, CompareType.EQUALS));
        } else {
            fi.getFilterItems().add(new FilterItemInfo("id", (Object)"NOTEXISTID", CompareType.INCLUDE));
        }
        evi.setFilter(fi);
        return evi;
    }
}

