/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.appframework.databinding.DataBinder;
import com.kingdee.bos.ctrl.extendcontrols.BizDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.IDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.render.ObjectValueRender;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDTabbedPane;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.bot.BOTMappingInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IItemAction;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.util.IUIActionPostman;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.MeasureUnitFactory;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.master.material.AsstAttrTypeInfo;
import com.kingdee.eas.basedata.master.material.AsstAttrValueInfo;
import com.kingdee.eas.basedata.master.material.IMaterial;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MaterialInventoryInfo;
import com.kingdee.eas.basedata.master.material.MaterialPlanInfo;
import com.kingdee.eas.basedata.master.material.MaterialPurchasingInfo;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitFactory;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.client.AsstAttrPromptBox;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.IOrgUnitRelation;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.basedata.org.PurchaseOrgUnitInfo;
import com.kingdee.eas.basedata.org.SaleOrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.scm.common.BizTypeInfo;
import com.kingdee.eas.basedata.scm.common.util.SCMBaseCommonUtil;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.ObjectBaseInfo;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.framework.batchaction.ActionLevelEnum;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.framework.batchaction.BatchSelectionEntries;
import com.kingdee.eas.mm.basedata.TrackNumberInfo;
import com.kingdee.eas.mm.common.client.UIHelper;
import com.kingdee.eas.mm.project.ProjectInfo;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.EntryBaseStatusEnum;
import com.kingdee.eas.scm.common.ISCMBotpFacade;
import com.kingdee.eas.scm.common.SCMBotpFacadeFactory;
import com.kingdee.eas.scm.common.SCMFetchData;
import com.kingdee.eas.scm.common.SCMFetchDataCondition;
import com.kingdee.eas.scm.common.SCMFetchDataFacadeFactory;
import com.kingdee.eas.scm.common.action.ISupportBatchAction;
import com.kingdee.eas.scm.common.botputils.SCMBotpUtils;
import com.kingdee.eas.scm.common.botputils.client.SCMBotpClientUtils;
import com.kingdee.eas.scm.common.client.BillOptionsHelper;
import com.kingdee.eas.scm.common.client.SCMBillEditUI;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.loadmass.InvBizDataVO;
import com.kingdee.eas.scm.common.loadmass.SCMBizDataVO;
import com.kingdee.eas.scm.common.util.SCMConstant;
import com.kingdee.eas.scm.framework.client.SCMPasteHelper;
import com.kingdee.eas.scm.im.inv.BizRoleTypeEnum;
import com.kingdee.eas.scm.im.inv.IStockReqFacade;
import com.kingdee.eas.scm.im.inv.InventoryInfo;
import com.kingdee.eas.scm.im.inv.StockReqAgent;
import com.kingdee.eas.scm.im.inv.StockReqEntryAgent;
import com.kingdee.eas.scm.im.inv.StockReqEntryFactory;
import com.kingdee.eas.scm.im.inv.StockReqEntryInfo;
import com.kingdee.eas.scm.im.inv.StockReqFacadeFactory;
import com.kingdee.eas.scm.im.inv.StockReqFactory;
import com.kingdee.eas.scm.im.inv.StockReqInfo;
import com.kingdee.eas.scm.im.inv.StockTypeEnum;
import com.kingdee.eas.scm.im.inv.client.AbstractStockReqEditUI;
import com.kingdee.eas.scm.im.inv.client.InvClientUtils;
import com.kingdee.eas.scm.im.inv.client.StockReqClientUtils;
import com.kingdee.eas.scm.im.inv.client.SupplyRelationClientUtils;
import com.kingdee.eas.scm.sd.sale.SaleOrderEntryInfo;
import com.kingdee.eas.scm.sd.sale.SaleOrderFactory;
import com.kingdee.eas.scm.sd.sale.SaleOrderInfo;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class StockReqEditUI
extends AbstractStockReqEditUI
implements DataChangeListener,
KDTEditListener,
KDTSelectListener,
SelectorListener,
FocusListener {
    protected static final Logger logger = CoreUIObject.getLogger(StockReqEditUI.class);
    private static final long serialVersionUID = -32223334988333L;
    protected IMaterial iMaterial = MaterialFactory.getRemoteInstance();
    protected StorageOrgUnitInfo reqStorage = null;
    protected CompanyOrgUnitInfo reqCompany = null;
    protected StorageOrgUnitInfo supplyStorage = null;
    protected CompanyOrgUnitInfo supplyCompany = null;
    protected KDBizPromptBox prmtMaterial = null;
    protected KDBizPromptBox prmtAsstAttr = new KDBizPromptBox();
    protected AsstAttrPromptBox prmtAsstAttrInner = new AsstAttrPromptBox((IUIObject)this);
    protected KDBizPromptBox prmtUnit = new KDBizPromptBox();
    protected KDBizPromptBox prmtPurchaseOrgUnit = new KDBizPromptBox();
    protected KDBizPromptBox prmtSupplier = new KDBizPromptBox();
    protected KDBizPromptBox prmtSaleOrgUnit = new KDBizPromptBox();
    protected KDBizPromptBox prmtCustomer = new KDBizPromptBox();
    protected KDBizPromptBox prmtReceiveStorage = new KDBizPromptBox();
    protected KDBizPromptBox prmtReceiveWarehouse = new KDBizPromptBox();
    protected KDBizPromptBox prmtSaleOrder = new KDBizPromptBox();
    protected EntityViewInfo saleOrderView = new EntityViewInfo();
    private static final String TB_MATERIAL = "material";
    private static final String TB_MATERIALNAME = "materialName";
    private static final String TB_MODEL = "model";
    private static final String TB_ASSISTPROPERTY = "assistProperty";
    private static final String TB_UNIT = "unit";
    private static final String TB_QTY = "qty";
    private static final String TB_AUDITQTY = "auditQty";
    private static final String TB_BASEUNIT = "baseUnit";
    private static final String TB_BASEQTY = "baseQty";
    private static final String TB_AUDITBASEQTY = "auditBaseQty";
    private static final String TB_ASSISTUNIT = "assistUnit";
    private static final String TB_ASSISTQTY = "assistQty";
    private static final String TB_APPROVEDASSITQTY = "approvedAssitQty";
    private static final String TB_STOCKTYPE = "stockType";
    private static final String TB_PURCHASEORGUNIT = "purchaseOrgUnit";
    private static final String TB_SUPPLIER = "supplier";
    private static final String TB_SUPPLIERNAME = "supplierName";
    private static final String TB_SALEORGUNIT = "saleOrgUnit";
    private static final String TB_CUSTOMER = "customer";
    private static final String TB_CUSTOMERNAME = "customerName";
    private static final String TB_RECEIVESTORAGE = "receiveStorage";
    private static final String TB_RECEIVECOMPANY = "receiveCompany";
    private static final String TB_RECEIVEWAREHOUSE = "receiveWarehouse";
    private static final String TB_DELIVERYDATE = "deliveryDate";
    private static final String TB_REQDATEFROM = "reqDateFrom";
    private static final String TB_REQDATETO = "reqDateTo";
    private static final String TB_TOTALSTOCKQTY = "totalStockQty";
    private static final String TB_TOTALSTOCKBASEQTY = "totalStockBaseQty";
    private static final String TB_ASSOCIATEQTY = "associateQty";
    private static final String TB_ENTRYSTATUS = "entryStatus";
    private static final String TB_SALEORDER = "saleOrder";
    private static final String TB_SALEORDERENTRY = "saleOrderEntry";
    private static final String TB_PROJECTNUM = "projectNumCol";
    private static final String TB_TRACKNUM = "trackNumCol";
    private static final String TB_DELIVERYCUSTOMER = "deliveryCustomer";
    private static final String TB_ISUNCONTROLQTY = "isUnControlQty";
    private static final String TB_LESSDELIVERYRATE = "lessDeliveryRate";
    private static final String TB_OVERDELIVERYRATE = "overDeliveryRate";
    private static final String TB_REMARK = "entry.remark";
    private static final String[] TBS_QTY = new String[]{"qty", "auditQty", "totalStockQty"};
    private static final String[] TBS_BASEQTY = new String[]{"baseQty", "auditBaseQty", "totalStockBaseQty", "associateQty"};
    private static final String[] TBS_ASSTQTY = new String[]{"assistQty", "approvedAssitQty"};
    private static final BigDecimal ZERO = SysConstant.BIGZERO;
    private static final int DEFAULT_PRECISION = 2;
    public static final int RATE_DEFAULT_PRECISION = 4;
    protected IUIWindow storeStateTotalViewWindow = null;
    private HashMap hsMaterialWarehouse = new HashMap(0);
    private int curIndex;
    boolean isUseWarehsRelation = false;
    public SCMPasteHelper kdtEntryPasteHelper;

    @Override
    protected IObjectValue createNewData() {
        StockReqAgent info = null;
        try {
            info = StockReqAgent.create();
            this.reqStorage = (StorageOrgUnitInfo)this.getDefaultMainBizOrg();
            this.reqCompany = InvClientUtils.getCompanyInfo(this.reqStorage);
            BizTypeInfo bizType = SCMBaseCommonUtil.getDefaultBizTypeInfo(null, (String)"P6/avnd3QEeGPCqlUsZnjyQHQ1w=", (String)"MmEE6VBsR0KaUDQmebwhP0Y+1VI=");
            info.setBizType(bizType);
            info.setBillType(SCMClientUtils.getBillType((String)"MmEE6VBsR0KaUDQmebwhP0Y+1VI="));
            Date now = SCMClientUtils.getServerDate2();
            UserInfo user = SysContext.getSysContext().getCurrentUserInfo();
            info.setProposer(user.getPerson());
            info.setCreator(user);
            info.setBizDate(now);
            info.setReqStorage(this.reqStorage);
            info.setReqCompany(this.reqCompany);
            info.setBaseStatus(BillBaseStatusEnum.ADD);
            StockReqEntryInfo entry = (StockReqEntryInfo)this.createNewDetailData(this.kdtEntry);
            info.getEntry().add(entry);
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        return info;
    }

    protected void appendFootRow(KDTable table, String columnKey) {
        if (this.kdtEntryPasteHelper != null && this.kdtEntryPasteHelper.isPasteing()) {
            return;
        }
        super.appendFootRow(table, columnKey);
    }

    protected IObjectValue createNewDetailData(KDTable table) {
        StockReqEntryAgent entry = null;
        try {
            entry = StockReqEntryAgent.create();
            entry.setQty(ZERO);
            entry.setAuditQty(ZERO);
            entry.setBaseQty(ZERO);
            entry.setAuditBaseQty(ZERO);
            entry.setAssistQty(ZERO);
            entry.setStockType(StockTypeEnum.STOCK);
            entry.setTotalStockQty(ZERO);
            entry.setTotalStockBaseQty(ZERO);
            entry.setAssociateQty(ZERO);
            entry.setDeliveryDate((Date)this.pkBizDate.getValue());
            entry.setReceiveStorage(this.reqStorage);
            entry.setReceiveCompany(this.reqCompany);
            entry.setIsUnControlQty(true);
            entry.setLessDeliveryRate(ZERO);
            entry.setOverDeliveryRate(ZERO);
            if (table.getRowCount() > 0) {
                entry.setReceiveWarehouse((WarehouseInfo)table.getCell(0, TB_RECEIVEWAREHOUSE).getValue());
                entry.setReqDateFrom((Date)table.getCell(0, TB_REQDATEFROM).getValue());
                entry.setReqDateTo((Date)table.getCell(0, TB_REQDATETO).getValue());
            } else {
                Calendar reqDateFrom = StockReqClientUtils.getReqDateFrom();
                Calendar reqDateTo = (Calendar)reqDateFrom.clone();
                reqDateTo.add(5, 6);
                entry.setReqDateFrom(reqDateFrom.getTime());
                entry.setReqDateTo(reqDateTo.getTime());
            }
            entry.setBaseStatus(EntryBaseStatusEnum.ADD);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        return entry;
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return StockReqFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext());
    }

    @Override
    public void loadFields() {
        try {
            this.loadFieldsBefore();
            super.loadFields();
            this.loadFieldsAfter();
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    @Override
    public boolean isPrepareInit() {
        return true;
    }

    @Override
    public void storeFields() {
        try {
            this.storeFieldsBefore();
            super.storeFields();
            this.storeFieldsAfter();
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    public void onLoad() throws Exception {
        this.getDetailTable().checkParsed();
        this.initHeadBeforeOnLoad();
        this.initEntryBeforeOnLoad();
        super.onLoad();
        this.initTotalAfterOnLoad();
        this.pnlEntry.putClientProperty((Object)"OriginalBounds", (Object)new Rectangle(0, 0, 978, 435));
        this.pnlTotal.putClientProperty((Object)"OriginalBounds", (Object)new Rectangle(0, 0, 978, 435));
        Object isFromWorkflow = this.getUIContext().get("isFromWorkflow");
        if (isFromWorkflow != null && "true".equalsIgnoreCase(isFromWorkflow.toString())) {
            this.getNumTextField().setAccessAuthority(1);
            this.pkBizDate.setEnabled(false);
            this.prmtSupplyStorage.setEnabled(false);
            int n = this.kdtEntry.getRowCount();
            for (int i = 0; i < n; ++i) {
                InvClientUtils.setRowLock(this.kdtEntry, i, new String[]{TB_AUDITQTY}, true);
            }
        }
        this.actionCopyLine.setVisible(false);
        this.actionCopyLine.setEnabled(false);
        this.kdtEntry.getColumn(TB_PROJECTNUM).setEditor(null);
        UIHelper.registerProjectF7((KDBizPromptBox)this.getMainOrgUnit(), null, (KDTable)this.kdtEntry, (String)TB_PROJECTNUM);
        UIHelper.registerTrackNumberF7((KDBizPromptBox)this.getMainOrgUnit(), null, (KDTable)this.kdtEntry, (String)TB_PROJECTNUM, (String)TB_TRACKNUM, (boolean)false);
        if (this.getSCMBizDataVO() != null) {
            this.menuItemInvBillOptin.setVisible(true);
            this.menuItemInvBillOptin.setEnabled(true);
            this.assistForNumber = BillOptionsHelper.takeConfigType((HashMap)this.getSCMBizDataVO().getOptionConfigMap(), (String)"AssistForNumber", (boolean)true);
            this.numberForAssist = BillOptionsHelper.takeConfigType((HashMap)this.getSCMBizDataVO().getOptionConfigMap(), (String)"NumberForAssist", (boolean)false);
            this.batchCarryWarehouseLocation = BillOptionsHelper.takeConfigType((HashMap)this.getSCMBizDataVO().getOptionConfigMap(), (String)"batchCarryWarehouseLocation", (boolean)true);
        }
    }

    protected void beforeStoreFields(ActionEvent e) throws Exception {
        StorageOrgUnitInfo supplyStorage;
        Date bizDate;
        StorageOrgUnitInfo reqStorage;
        BizTypeInfo bizType;
        super.beforeStoreFields(e);
        if (e == null || e.getSource() == this.btnSave || e.getSource() == this.menuItemSave) {
            return;
        }
        if (StringUtils.isEmpty((String)this.txtNumber.getText())) {
            this.txtNumber.requestFocus();
        }
        if ((bizType = (BizTypeInfo)this.prmtBizType.getValue()) == null) {
            MsgBox.showError((Component)((Object)this), (String)StockReqClientUtils.getResource("bizTypeIsNull"));
            this.prmtBizType.requestFocus();
            SysUtil.abort();
        }
        if ((reqStorage = (StorageOrgUnitInfo)this.prmtReqStorage.getValue()) == null) {
            MsgBox.showError((Component)((Object)this), (String)StockReqClientUtils.getResource("reqStorageIsNull"));
            this.prmtReqStorage.requestFocus();
            SysUtil.abort();
        }
        if ((bizDate = (Date)this.pkBizDate.getValue()) == null) {
            MsgBox.showError((Component)((Object)this), (String)StockReqClientUtils.getResource("bizDateIsNull"));
            this.pkBizDate.requestFocus();
            SysUtil.abort();
        }
        if ((supplyStorage = (StorageOrgUnitInfo)this.prmtSupplyStorage.getValue()) == null) {
            MsgBox.showError((Component)((Object)this), (String)StockReqClientUtils.getResource("supplyStorageIsNull"));
            this.prmtSupplyStorage.requestFocus();
            SysUtil.abort();
        }
        KDTable table = this.getDetailTable();
        int rowCount = table.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            if (!InvClientUtils.isRowBlankOnTable(table, i, new String[]{TB_MATERIAL})) continue;
            this.removeLine(table, i);
            --i;
            --rowCount;
        }
        rowCount = table.getRowCount();
        if (table.getRowCount() == 0) {
            MsgBox.showError((Component)((Object)this), (String)StockReqClientUtils.getResource("entryCountIsZero"));
            this.addLine(table);
            SysUtil.abort();
        }
        for (int i = 0; i < rowCount; ++i) {
            SaleOrgUnitInfo saleOrgUnitInfo;
            StockTypeEnum stockType;
            BigDecimal qty;
            MeasureUnitInfo unit;
            AsstAttrValueInfo asstAttr;
            IRow row = table.getRow(i);
            MaterialInfo material = (MaterialInfo)row.getCell(TB_MATERIAL).getValue();
            if (material == null) {
                MsgBox.showError((Component)((Object)this), (String)StockReqClientUtils.getResource("materialIsNull"));
                table.getEditManager().editCellAt(i, table.getColumnIndex(TB_MATERIAL));
                SysUtil.abort();
                continue;
            }
            if (material.getAssistAttr() != null && (asstAttr = (AsstAttrValueInfo)row.getCell(TB_ASSISTPROPERTY).getValue()) == null) {
                MsgBox.showError((Component)((Object)this), (String)StockReqClientUtils.getResource("asstAttrIsNull"));
                table.getEditManager().editCellAt(i, table.getColumnIndex(TB_ASSISTPROPERTY));
                SysUtil.abort();
            }
            if ((unit = (MeasureUnitInfo)row.getCell(TB_UNIT).getValue()) == null) {
                MsgBox.showError((Component)((Object)this), (String)StockReqClientUtils.getResource("unitIsNull"));
                table.getEditManager().editCellAt(i, table.getColumnIndex(TB_UNIT));
                SysUtil.abort();
            }
            if ((qty = (BigDecimal)row.getCell(TB_AUDITQTY).getValue()) == null || qty.compareTo(ZERO) <= 0) {
                MsgBox.showError((Component)((Object)this), (String)StockReqClientUtils.getResource("auditQtyIsZero"));
                table.getEditManager().editCellAt(i, table.getColumnIndex(TB_AUDITQTY));
                SysUtil.abort();
            }
            if ((stockType = (StockTypeEnum)((Object)row.getCell(TB_STOCKTYPE).getValue())) == null) {
                MsgBox.showError((Component)((Object)this), (String)StockReqClientUtils.getResource("stockTypeIsNull"));
                table.getEditManager().editCellAt(i, table.getColumnIndex(TB_STOCKTYPE));
                SysUtil.abort();
            }
            if (row.getCell(TB_DELIVERYDATE).getValue() == null) {
                MsgBox.showError((Component)((Object)this), (String)StockReqClientUtils.getResource("deliveryDateIsNull"));
                table.getEditManager().editCellAt(i, table.getColumnIndex(TB_DELIVERYDATE));
                SysUtil.abort();
            }
            if (stockType.equals((Object)StockTypeEnum.DIRECTDELIVERY) && row.getCell(TB_SALEORDER).getValue() == null && row.getCell(TB_CUSTOMER).getValue() == null) {
                MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.scm.im.IMAutoGenerateResource", (String)"61_StockReqEditUI"));
                table.getEditManager().editCellAt(i, table.getColumnIndex(TB_SALEORDER));
                SysUtil.abort();
                continue;
            }
            if (stockType.equals((Object)StockTypeEnum.PURCHASE)) {
                PurchaseOrgUnitInfo purchaseOrgUnitInfo = (PurchaseOrgUnitInfo)row.getCell(TB_PURCHASEORGUNIT).getValue();
                if (purchaseOrgUnitInfo != null) continue;
                MsgBox.showError((Component)((Object)this), (String)StockReqClientUtils.getResource("purchaseOrgIsNull"));
                table.getEditManager().editCellAt(i, table.getColumnIndex(TB_PURCHASEORGUNIT));
                SysUtil.abort();
                continue;
            }
            if (!stockType.equals((Object)StockTypeEnum.SALE) || (saleOrgUnitInfo = (SaleOrgUnitInfo)row.getCell(TB_SALEORGUNIT).getValue()) != null) continue;
            MsgBox.showError((Component)((Object)this), (String)StockReqClientUtils.getResource("saleOrgIsNull"));
            table.getEditManager().editCellAt(i, table.getColumnIndex(TB_SALEORGUNIT));
            SysUtil.abort();
        }
    }

    private void initHeadBeforeOnLoad() throws Exception {
        this.prmtBizType.setEntityViewInfo(InvClientUtils.getBizTypeFromBill("170"));
        this.prmtCreator.setDisplayFormat("$name$");
        this.prmtLastUpdateUser.setDisplayFormat("$name$");
        this.prmtAuditor.setDisplayFormat("$name$");
    }

    private void initTotalAfterOnLoad() throws Exception {
        this.kdtTotal.setEditable(false);
        this.txtDescription.setMaxLength(255);
        this.kDTabbedPane1.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                KDTabbedPane source = (KDTabbedPane)e.getSource();
                if (StockReqEditUI.this.pnlTotal == source.getSelectedComponent()) {
                    try {
                        StockReqEditUI.this.calculateTotal();
                    }
                    catch (Exception ex) {
                        StockReqEditUI.this.handUIException(ex);
                    }
                    StockReqEditUI.this.actionMaterialView.setEnabled(false);
                } else {
                    StockReqEditUI.this.actionMaterialView.setEnabled(true);
                }
            }
        });
    }

    private void initEntryBeforeOnLoad() throws Exception {
        KDFormattedTextField txtDecimal = new KDFormattedTextField(1);
        KDTDefaultCellEditor editorDecimal = new KDTDefaultCellEditor((JTextField)txtDecimal);
        txtDecimal.setHorizontalAlignment(4);
        txtDecimal.setPrecision(2);
        txtDecimal.setSupportedEmpty(true);
        txtDecimal.setNegatived(false);
        StockReqClientUtils.setDefaultDecimalEditor(txtDecimal, editorDecimal, this.kdtEntry, TB_QTY);
        StockReqClientUtils.setDefaultDecimalEditor(txtDecimal, editorDecimal, this.kdtEntry, TB_AUDITQTY);
        StockReqClientUtils.setDefaultDecimalEditor(txtDecimal, editorDecimal, this.kdtEntry, TB_BASEQTY);
        StockReqClientUtils.setDefaultDecimalEditor(txtDecimal, editorDecimal, this.kdtEntry, TB_AUDITBASEQTY);
        StockReqClientUtils.setDefaultDecimalEditor(txtDecimal, editorDecimal, this.kdtEntry, TB_ASSISTQTY);
        StockReqClientUtils.setDefaultDecimalEditor(txtDecimal, editorDecimal, this.kdtEntry, TB_APPROVEDASSITQTY);
        StockReqClientUtils.setDefaultDecimalEditor(txtDecimal, editorDecimal, this.kdtEntry, TB_TOTALSTOCKQTY);
        StockReqClientUtils.setDefaultDecimalEditor(txtDecimal, editorDecimal, this.kdtEntry, TB_TOTALSTOCKBASEQTY);
        StockReqClientUtils.setDefaultDecimalEditor(txtDecimal, editorDecimal, this.kdtEntry, TB_ASSOCIATEQTY);
        KDFormattedTextField rateDecimal = new KDFormattedTextField(1);
        KDTDefaultCellEditor rateEditorDecimal = new KDTDefaultCellEditor((JTextField)rateDecimal);
        rateDecimal.setHorizontalAlignment(4);
        rateDecimal.setPrecision(4);
        rateDecimal.setSupportedEmpty(true);
        rateDecimal.setNegatived(false);
        rateDecimal.setMaximumValue((Comparable)SCMConstant.BIGDECIMAL_ONEHUNDRED);
        StockReqClientUtils.setDefaultDecimalEditor(rateDecimal, rateEditorDecimal, this.kdtEntry, TB_LESSDELIVERYRATE);
        StockReqClientUtils.setDefaultDecimalEditor(rateDecimal, rateEditorDecimal, this.kdtEntry, TB_OVERDELIVERYRATE);
        StockReqClientUtils.setDefaultDecimalEditor(txtDecimal, editorDecimal, this.kdtTotal, TB_QTY);
        StockReqClientUtils.setDefaultDecimalEditor(txtDecimal, editorDecimal, this.kdtTotal, TB_ASSISTQTY);
        StockReqClientUtils.setDefaultDecimalEditor(txtDecimal, editorDecimal, this.kdtTotal, TB_APPROVEDASSITQTY);
        StockReqClientUtils.setDefaultF7Editor(this.prmtAsstAttr, "com.kingdee.eas.basedata.master.material.app.F7AsstAttrValueQuery", this.kdtEntry, TB_ASSISTPROPERTY);
        StockReqClientUtils.setDefaultF7Editor(this.prmtUnit, "com.kingdee.eas.basedata.master.material.app.F7MultiMeasureUnitQuery", this.kdtEntry, TB_UNIT);
        StockReqClientUtils.setDefaultF7Editor(this.prmtPurchaseOrgUnit, "com.kingdee.eas.basedata.org.app.PurchaseOrgUnitQuery", this.kdtEntry, TB_PURCHASEORGUNIT);
        ObjectValueRender avr = new ObjectValueRender();
        avr.setFormat((IDataFormat)new BizDataFormat("$number$"));
        StockReqClientUtils.setDefaultF7Editor(this.prmtSupplier, "com.kingdee.eas.basedata.master.cssp.app.F7SupplierPurchasingQuery", this.kdtEntry, TB_SUPPLIER);
        this.prmtSupplier.setDisplayFormat("$number$");
        this.kdtEntry.getColumn(TB_SUPPLIER).setRenderer((IBasicRender)avr);
        StockReqClientUtils.setDefaultF7Editor(this.prmtSaleOrgUnit, "com.kingdee.eas.basedata.org.app.SaleOrgUnitQuery", this.kdtEntry, TB_SALEORGUNIT);
        StockReqClientUtils.setDefaultF7Editor(this.prmtCustomer, "com.kingdee.eas.basedata.master.cssp.app.F7CustomerSaleQueryWithDefaultStandard", this.kdtEntry, TB_CUSTOMER);
        this.prmtCustomer.setDisplayFormat("$number$");
        this.kdtEntry.getColumn(TB_CUSTOMER).setRenderer((IBasicRender)avr);
        StockReqClientUtils.setDefaultF7Editor(this.prmtReceiveStorage, "com.kingdee.eas.basedata.org.app.StorageOrgUnitQuery", this.kdtEntry, TB_RECEIVESTORAGE);
        StockReqClientUtils.setDefaultF7Editor(this.prmtReceiveWarehouse, "com.kingdee.eas.basedata.scm.im.inv.app.F7WarehouseQuery", this.kdtEntry, TB_RECEIVEWAREHOUSE);
        StockReqClientUtils.setSaleOrderF7Editor(this.prmtSaleOrder, "com.kingdee.eas.scm.im.inv.F7SaleOrder4StockReqQuery", this.kdtEntry, TB_SALEORDER);
        StockReqClientUtils.setSaleOrderEntryF7Editor(new KDBizPromptBox(), null, this.kdtEntry, TB_SALEORDERENTRY);
        KDComboBox cbStockType = new KDComboBox();
        cbStockType.addItems(StockTypeEnum.getEnumList().toArray());
        cbStockType.removeItem((Object)StockTypeEnum.Null);
        this.kdtEntry.getColumn(TB_STOCKTYPE).setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)cbStockType));
        KDDatePicker datePicker = new KDDatePicker();
        KDTDefaultCellEditor editorDate = new KDTDefaultCellEditor(datePicker);
        this.kdtEntry.getColumn(TB_DELIVERYDATE).setEditor((ICellEditor)editorDate);
        this.kdtEntry.getColumn(TB_DELIVERYDATE).getStyleAttributes().setNumberFormat(SCMClientUtils.strDateFormat);
        this.kdtEntry.getColumn(TB_REQDATEFROM).setEditor((ICellEditor)editorDate);
        this.kdtEntry.getColumn(TB_REQDATEFROM).getStyleAttributes().setNumberFormat(SCMClientUtils.strDateFormat);
        this.kdtEntry.getColumn(TB_REQDATETO).setEditor((ICellEditor)editorDate);
        this.kdtEntry.getColumn(TB_REQDATETO).getStyleAttributes().setNumberFormat(SCMClientUtils.strDateFormat);
        KDComboBox cbEntryStatus = new KDComboBox();
        cbEntryStatus.addItems(EntryBaseStatusEnum.getEnumList().toArray());
        this.kdtEntry.getColumn(TB_ENTRYSTATUS).setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)cbEntryStatus));
        SCMClientUtils.setEntriesTableStrLength((KDTable)this.kdtEntry, (String[])new String[]{TB_REMARK}, (int)255);
        this.kdtEntryPasteHelper = new SCMPasteHelper(this.getDetailTable()){

            public String[] getDateFieldColumns() {
                return new String[]{StockReqEditUI.TB_DELIVERYDATE, StockReqEditUI.TB_REQDATEFROM, StockReqEditUI.TB_REQDATETO};
            }

            public String[] getCheckBoxFieldColumns() {
                return new String[]{StockReqEditUI.TB_ISUNCONTROLQTY};
            }

            public void insertRow(int row) {
                StockReqEditUI.this.insertLine(row);
            }

            protected void pasteAfterProcess() {
                StockReqEditUI.this.appendFootRow(StockReqEditUI.this.getDetailTable(), null);
            }

            public String[] getTextFieldColumns() {
                return new String[]{StockReqEditUI.TB_REMARK};
            }
        };
    }

    private void loadFieldsBefore() throws Exception {
        this.initFetchData();
        if (this.isBotpBill()) {
            int entrySize = this.editData.getEntry().size();
            for (int i = 0; i < entrySize; ++i) {
                StockReqEntryInfo entry = this.editData.getEntry().get(i);
                if (entry.getStockType() == null) {
                    entry.setStockType(StockTypeEnum.PURCHASE);
                }
                if (entry.getBaseStatus() != null) continue;
                entry.setBaseStatus(EntryBaseStatusEnum.ADD);
            }
        }
        this.removeListeners();
    }

    private void loadFieldsAfter() throws Exception {
        this.reqStorage = this.editData.getReqStorage();
        this.reqCompany = this.editData.getReqCompany();
        this.supplyStorage = this.editData.getSupplyStorage();
        this.supplyCompany = this.editData.getSupplyCompany();
        if (this.editData.getBaseStatus().equals((Object)BillBaseStatusEnum.AUDITED)) {
            this.setAddLineStatus(false);
            this.setRemoveLineStatus(false);
        }
        for (int i = 0; i < this.editData.getEntry().size(); ++i) {
            this.setColumnControl(i, true);
            this.setColumnControlByIsUnControlQty(i);
        }
        if (this.kdtEntry.getRowCount() == 0) {
            this.addLine(this.kdtEntry);
        }
        this.initBotpControl();
        this.setActionEnableByTransType();
        this.calculateTotal();
        this.syncOldData((IObjectValue)this.editData);
        this.addListeners();
        if (this.prmtReqStorage.getValue() == null) {
            this.prmtSupplyStorage.setEnabled(false);
        } else {
            this.prmtSupplyStorage.setEnabled(true);
            this.setSupplyStorageFilter();
        }
    }

    private void initBotpControl() throws Exception {
        if (!this.isBotpBill()) {
            this.kdtEntry.getColumn(TB_MATERIAL).getStyleAttributes().setLocked(false);
            return;
        }
        String srcObjectID = this.editData.getSourceBillId();
        if (srcObjectID != null && this.editData.getId() != null) {
            String destObjectID = this.editData.getId().toString();
            ISCMBotpFacade ibf = SCMBotpFacadeFactory.getRemoteInstance();
            BOTMappingInfo mapping = ibf.getBOTMappingInfo(srcObjectID, destObjectID);
            if (mapping != null) {
                List canList = SCMBotpUtils.getBillPropertiesCanModify((BOTMappingInfo)mapping);
                List cannotList = SCMBotpUtils.getBillPropertiesCannotModify((BOTMappingInfo)mapping);
                SCMBotpClientUtils.setEditableByList((SCMBillEditUI)this, (DataBinder)this.dataBinder, (List)cannotList, (List)canList);
            }
            this.kdtEntry.getColumn(TB_AUDITQTY).getStyleAttributes().setLocked(false);
            this.kdtEntry.getColumn(TB_MATERIAL).getStyleAttributes().setLocked(true);
        }
    }

    private void storeFieldsBefore() throws Exception {
    }

    private void storeFieldsAfter() throws Exception {
        if (this.editData != null && this.editData.getEntry() != null) {
            for (int i = this.editData.getEntry().size() - 1; i > 0; --i) {
                if (this.editData.getEntry().get(i).getMaterial() != null) continue;
                this.editData.getEntry().removeObject(i);
            }
        }
    }

    private void removeListeners() {
        this.getDetailTable().removeKDTEditListener((KDTEditListener)this);
        this.getDetailTable().removeKDTSelectListener((KDTSelectListener)this);
        this.prmtMaterial.removeDataChangeListener((DataChangeListener)this);
        this.prmtBizType.removeDataChangeListener((DataChangeListener)this);
        this.prmtReqStorage.removeDataChangeListener((DataChangeListener)this);
        this.prmtSupplyStorage.removeDataChangeListener((DataChangeListener)this);
        this.bizInventory.removeDataChangeListener((DataChangeListener)this);
        this.prmtSupplyStorage.removeSelectorListener((SelectorListener)this);
        this.prmtSaleOrder.removeDataChangeListener((DataChangeListener)this);
    }

    private void addListeners() {
        this.getDetailTable().addKDTEditListener((KDTEditListener)this);
        this.getDetailTable().addKDTSelectListener((KDTSelectListener)this);
        this.prmtMaterial.addDataChangeListener((DataChangeListener)this);
        this.prmtBizType.addDataChangeListener((DataChangeListener)this);
        this.prmtReqStorage.addDataChangeListener((DataChangeListener)this);
        this.prmtSupplyStorage.addDataChangeListener((DataChangeListener)this);
        this.bizInventory.addDataChangeListener((DataChangeListener)this);
        this.prmtSupplyStorage.addSelectorListener((SelectorListener)this);
        this.prmtSaleOrder.addDataChangeListener((DataChangeListener)this);
    }

    protected KDBizPromptBox getMainBizOrg() {
        return this.prmtReqStorage;
    }

    public KDBizPromptBox getMainOrgUnit() {
        return this.prmtReqStorage;
    }

    @Override
    protected OrgType getMainBizOrgType() {
        return OrgType.Storage;
    }

    protected int getDefaultOrgMask() {
        return 18;
    }

    protected void initNeedMainOrgF7s() {
        this.prmtMaterial = this.getBizMaterialF7(this.getDetailTable().getColumn(TB_MATERIAL), null);
        this.setNeedMainOrgF7s(new KDBizPromptBox[]{this.prmtMaterial});
    }

    @Override
    protected KDTable getDetailTable() {
        return this.kdtEntry;
    }

    public KDTextField getNumTextField() {
        return this.txtNumber;
    }

    private void bizTypeChanged(DataChangeEvent e) throws Exception {
        this.setControlByBizType();
    }

    private void reqStorageChanged() throws Exception {
        this.reqStorage = (StorageOrgUnitInfo)this.prmtReqStorage.getValue();
        this.reqCompany = InvClientUtils.getCompanyInfo(this.reqStorage);
        this.editData.setReqCompany(this.reqCompany);
        this.prmtSupplyStorage.setValue(null);
        this.setSupplyStorageFilter();
        for (int i = 0; i < this.kdtEntry.getRowCount(); ++i) {
            this.kdtEntry.getCell(i, TB_RECEIVESTORAGE).setValue((Object)this.reqStorage);
            this.kdtEntry.getCell(i, TB_RECEIVECOMPANY).setValue((Object)this.reqCompany);
        }
        this.tableSelectChanged(null);
    }

    private void supplyStorageChanged(DataChangeEvent e) throws Exception {
        this.supplyStorage = (StorageOrgUnitInfo)e.getNewValue();
        this.supplyCompany = InvClientUtils.getCompanyInfo(this.supplyStorage);
        this.editData.setSupplyCompany(this.supplyCompany);
        int n = this.kdtEntry.getRowCount();
        for (int i = 0; i < n; ++i) {
            this.kdtEntry.getCell(i, TB_PURCHASEORGUNIT).setValue(null);
            this.kdtEntry.getCell(i, TB_SUPPLIER).setValue(null);
            this.kdtEntry.getCell(i, TB_SUPPLIERNAME).setValue(null);
        }
        this.tableSelectChanged(null);
    }

    private void unitChanged(int rowIndex) throws Exception {
        MaterialInfo material = (MaterialInfo)this.kdtEntry.getCell(rowIndex, TB_MATERIAL).getValue();
        MeasureUnitInfo unit = (MeasureUnitInfo)this.kdtEntry.getCell(rowIndex, TB_UNIT).getValue();
        if (material != null && unit != null) {
            int qtyPrecision = 2;
            if (this.fetchData.getUnitPrecision(material.getId().toString(), unit.getId().toString()) == null) {
                MultiMeasureUnitInfo mmuUnit = MultiMeasureUnitFactory.getRemoteInstance().getMultiUnit(material.getId().toString(), unit.getId().toString());
                if (mmuUnit != null) {
                    qtyPrecision = mmuUnit.getQtyPrecision();
                    this.fetchData.putUnitPrecision(material.getId().toString(), unit.getId().toString(), mmuUnit.getQtyPrecision());
                }
            } else {
                qtyPrecision = this.fetchData.getUnitPrecision(material.getId().toString(), unit.getId().toString());
            }
            StockReqClientUtils.changePrecision(this.kdtEntry, rowIndex, TBS_QTY, qtyPrecision);
        }
        if (this.isBotpBill()) {
            this.baseQtyChanged(rowIndex);
            this.auditBaseQtyChanged(rowIndex);
        } else {
            BigDecimal oldAuditQty = (BigDecimal)this.kdtEntry.getCell(rowIndex, TB_AUDITQTY).getValue();
            this.qtyChanged(rowIndex);
            this.kdtEntry.getCell(rowIndex, TB_AUDITQTY).setValue((Object)oldAuditQty);
            this.auditQtyChanged(rowIndex);
        }
    }

    private void baseQtyChanged(int rowIndex) throws Exception {
        MaterialInfo material = (MaterialInfo)this.kdtEntry.getCell(rowIndex, TB_MATERIAL).getValue();
        MeasureUnitInfo unit = (MeasureUnitInfo)this.kdtEntry.getCell(rowIndex, TB_UNIT).getValue();
        MeasureUnitInfo baseUnit = (MeasureUnitInfo)this.kdtEntry.getCell(rowIndex, TB_BASEUNIT).getValue();
        if (material == null) {
            return;
        }
        BigDecimal baseQty = (BigDecimal)this.kdtEntry.getCell(rowIndex, TB_BASEQTY).getValue();
        if (baseQty == null) {
            baseQty = ZERO;
        }
        if (material != null && unit != null && baseUnit != null) {
            BigDecimal qty = InvClientUtils.getUnitQty(unit, material, baseQty);
            this.kdtEntry.getCell(rowIndex, TB_QTY).setValue((Object)qty);
        }
    }

    private void qtyChanged(int rowIndex) throws Exception {
        MaterialInfo material = (MaterialInfo)this.kdtEntry.getCell(rowIndex, TB_MATERIAL).getValue();
        MeasureUnitInfo unit = (MeasureUnitInfo)this.kdtEntry.getCell(rowIndex, TB_UNIT).getValue();
        MeasureUnitInfo baseUnit = (MeasureUnitInfo)this.kdtEntry.getCell(rowIndex, TB_BASEUNIT).getValue();
        MeasureUnitInfo asstUnit = (MeasureUnitInfo)this.kdtEntry.getCell(rowIndex, TB_ASSISTUNIT).getValue();
        if (material == null) {
            return;
        }
        BigDecimal qty = (BigDecimal)this.kdtEntry.getCell(rowIndex, TB_QTY).getValue();
        if (qty == null) {
            qty = ZERO;
        }
        if (material != null && unit != null && baseUnit != null) {
            BigDecimal baseQty = InvClientUtils.getBaseUnitQty(unit, material, qty);
            this.kdtEntry.getCell(rowIndex, TB_BASEQTY).setValue((Object)baseQty);
            if (asstUnit != null) {
                BigDecimal asstQty = InvClientUtils.getAssUnitQty(asstUnit, material, baseQty);
                this.kdtEntry.getCell(rowIndex, TB_ASSISTQTY).setValue((Object)asstQty);
            }
            this.kdtEntry.getCell(rowIndex, TB_AUDITQTY).setValue((Object)qty);
            this.kdtEntry.getCell(rowIndex, TB_AUDITBASEQTY).setValue((Object)baseQty);
        }
    }

    private void auditBaseQtyChanged(int rowIndex) throws Exception {
        MaterialInfo material = (MaterialInfo)this.kdtEntry.getCell(rowIndex, TB_MATERIAL).getValue();
        MeasureUnitInfo unit = (MeasureUnitInfo)this.kdtEntry.getCell(rowIndex, TB_UNIT).getValue();
        MeasureUnitInfo baseUnit = (MeasureUnitInfo)this.kdtEntry.getCell(rowIndex, TB_BASEUNIT).getValue();
        if (material == null) {
            return;
        }
        BigDecimal auditBaseQty = (BigDecimal)this.kdtEntry.getCell(rowIndex, TB_AUDITBASEQTY).getValue();
        if (auditBaseQty == null) {
            auditBaseQty = ZERO;
        }
        if (material != null && unit != null && baseUnit != null) {
            BigDecimal auditQty = InvClientUtils.getUnitQty(unit, material, auditBaseQty);
            this.kdtEntry.getCell(rowIndex, TB_AUDITQTY).setValue((Object)auditQty);
        }
    }

    private void auditQtyChanged(int rowIndex) throws Exception {
        MaterialInfo material = (MaterialInfo)this.kdtEntry.getCell(rowIndex, TB_MATERIAL).getValue();
        MeasureUnitInfo unit = (MeasureUnitInfo)this.kdtEntry.getCell(rowIndex, TB_UNIT).getValue();
        MeasureUnitInfo baseUnit = (MeasureUnitInfo)this.kdtEntry.getCell(rowIndex, TB_BASEUNIT).getValue();
        if (material == null) {
            return;
        }
        BigDecimal auditQty = (BigDecimal)this.kdtEntry.getCell(rowIndex, TB_AUDITQTY).getValue();
        if (auditQty == null) {
            auditQty = ZERO;
        }
        if (material != null && unit != null && baseUnit != null) {
            BigDecimal auditBaseQty = InvClientUtils.getBaseUnitQty(unit, material, auditQty);
            this.kdtEntry.getCell(rowIndex, TB_AUDITBASEQTY).setValue((Object)auditBaseQty);
        }
    }

    private void tableValueChanged(KDTEditEvent e) throws Exception {
        KDTable table = (KDTable)e.getSource();
        Object oldValue = e.getOldValue();
        Object newValue = e.getValue();
        if (oldValue == null && newValue == null || oldValue != null && oldValue.equals(newValue)) {
            return;
        }
        int selectRow = e.getRowIndex();
        int selectCol = e.getColIndex();
        String selectColName = table.getColumnKey(selectCol);
        IRow curRow = this.kdtEntry.getRow(selectRow);
        if (TB_MATERIAL.equals(selectColName)) {
            InvClientUtils.setCellValueNull(this.kdtEntry, new String[]{TB_ASSISTPROPERTY, TB_QTY, TB_AUDITQTY, TB_BASEQTY, TB_AUDITBASEQTY, TB_ASSISTQTY, TB_APPROVEDASSITQTY, TB_PURCHASEORGUNIT, TB_SALEORGUNIT, TB_CUSTOMER, TB_CUSTOMERNAME, TB_SALEORDER, TB_SALEORDERENTRY, TB_DELIVERYCUSTOMER}, selectRow, false, null);
            return;
        }
        KDTable kDTable = (KDTable)e.getSource();
        String colName = kDTable.getColumnKey(e.getColIndex());
        if (TB_PROJECTNUM.equals(colName) && e.getValue() != null && !e.getValue().equals(e.getOldValue())) {
            this.kdtEntry.getCell(selectRow, this.kdtEntry.getColumnIndex(TB_TRACKNUM)).setValue(null);
            UIHelper.registerTrackNumberF7((KDBizPromptBox)this.getMainOrgUnit(), null, (KDTable)this.kdtEntry, (String)TB_PROJECTNUM, (String)TB_TRACKNUM, (boolean)false);
        }
        if (TB_UNIT.equals(selectColName)) {
            this.unitChanged(selectRow);
        }
        if (TB_QTY.equals(selectColName)) {
            // empty if block
        }
        if (TB_AUDITQTY.equals(selectColName)) {
            // empty if block
        }
        if (TB_STOCKTYPE.equals(selectColName)) {
            this.setColumnControlByStockType(curRow);
            this.setColumnDataByStockType(curRow);
        }
        if (TB_PURCHASEORGUNIT.equals(selectColName)) {
            this.setColumnControlByPurchaseOrg(selectRow);
            this.setColumnDataByPurchaseOrg(selectRow);
        }
        if (TB_SUPPLIER.equals(selectColName)) {
            SupplierInfo supplier = (SupplierInfo)curRow.getCell(TB_SUPPLIER).getValue();
            if (supplier == null) {
                curRow.getCell(TB_SUPPLIERNAME).setValue(null);
            } else {
                curRow.getCell(TB_SUPPLIERNAME).setValue((Object)supplier.getName());
            }
        }
        if (TB_SALEORGUNIT.equals(selectColName)) {
            this.setColumnControlBySaleOrg(selectRow);
            this.setColumnDataBySaleOrg(selectRow);
        }
        if (TB_CUSTOMER.equals(selectColName)) {
            CustomerInfo customer = (CustomerInfo)newValue;
            boolean isDirect = StockTypeEnum.DIRECTDELIVERY.equals(curRow.getCell(TB_STOCKTYPE).getValue());
            curRow.getCell(TB_CUSTOMERNAME).setValue((Object)(customer == null ? null : customer.getName()));
            curRow.getCell(TB_DELIVERYCUSTOMER).setValue(isDirect ? customer : null);
            SCMClientUtils.setBgColor4Cells((IRow)curRow, (String[])new String[]{TB_SALEORDER}, (isDirect && customer == null ? 1 : 0) != 0);
            SCMClientUtils.setBgColor4Cells((IRow)curRow, (String[])new String[]{TB_CUSTOMER}, (boolean)isDirect);
            SCMClientUtils.clearCells((IRow)curRow, (String[])new String[]{TB_SALEORDER, TB_SALEORDERENTRY}, (boolean)isDirect);
        }
        if (TB_RECEIVEWAREHOUSE.equals(selectColName) && selectRow == 0 && this.batchCarryWarehouseLocation) {
            WarehouseInfo receiveWarehouse = (WarehouseInfo)curRow.getCell(TB_RECEIVEWAREHOUSE).getValue();
            StorageOrgUnitInfo receiveStorage = (StorageOrgUnitInfo)curRow.getCell(TB_RECEIVESTORAGE).getValue();
            if (receiveWarehouse != null && receiveStorage != null) {
                int n = this.kdtEntry.getRowCount();
                for (int i = 1; i < n; ++i) {
                    WarehouseInfo curReceiveWarehouse = (WarehouseInfo)this.kdtEntry.getCell(i, TB_RECEIVEWAREHOUSE).getValue();
                    StorageOrgUnitInfo curReceiveStorage = (StorageOrgUnitInfo)this.kdtEntry.getCell(i, TB_RECEIVESTORAGE).getValue();
                    if (curReceiveWarehouse != null || curReceiveStorage == null || !receiveStorage.getId().equals((Object)curReceiveStorage.getId())) continue;
                    this.kdtEntry.getCell(i, TB_RECEIVEWAREHOUSE).setValue((Object)receiveWarehouse);
                }
            }
        }
        if (TB_ISUNCONTROLQTY.equals(selectColName)) {
            this.setColumnControlByIsUnControlQty(selectRow);
        }
        if (TB_SALEORDER.equals(selectColName) && this.kdtEntryPasteHelper.isPasteing()) {
            SaleOrderEntryInfo entryInfo = (SaleOrderEntryInfo)newValue;
            if (entryInfo != null && entryInfo.getParent() != null) {
                SaleOrderInfo billInfo = SaleOrderFactory.getRemoteInstance().getSaleOrderInfo("select id,number,orderCustomer.id,orderCustomer.name,orderCustomer.number where id = '" + entryInfo.getParent().getId().toString() + "'");
                curRow.getCell(TB_SALEORDER).setValue((Object)billInfo);
                curRow.getCell(TB_CUSTOMER).setValue((Object)billInfo.getOrderCustomer());
                curRow.getCell(TB_CUSTOMERNAME).setValue((Object)billInfo.getOrderCustomer().getName());
                curRow.getCell(TB_DELIVERYCUSTOMER).setValue((Object)entryInfo.getDeliveryCustomer());
                curRow.getCell(TB_SALEORDERENTRY).setValue((Object)entryInfo);
            } else {
                curRow.getCell(TB_SALEORDERENTRY).setValue(null);
            }
        }
        this.setQtyBaseQtyAssisQty(this.getDetailTable(), selectRow, selectCol);
    }

    public void setQtyBaseQtyAssisQty(KDTable kdTable, int row, int col) throws EASBizException, BOSException {
        super.setQtyBaseQtyAssisQty(kdTable, row, col);
        if (kdTable.getCell(row, TB_MATERIAL).getColumnIndex() == col || kdTable.getCell(row, TB_QTY).getColumnIndex() == col || kdTable.getCell(row, TB_AUDITQTY).getColumnIndex() == col) {
            try {
                BigDecimal qty = (BigDecimal)kdTable.getCell(row, TB_QTY).getValue();
                BigDecimal baseQty = (BigDecimal)kdTable.getCell(row, TB_BASEQTY).getValue();
                if (kdTable.getCell(row, TB_AUDITQTY).getColumnIndex() == col) {
                    this.auditQtyChanged(row);
                } else {
                    kdTable.getCell(row, TB_AUDITQTY).setValue((Object)qty);
                    kdTable.getCell(row, TB_AUDITBASEQTY).setValue((Object)baseQty);
                }
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        }
    }

    protected void materialChanged(String materialFieldname, DataChangeEvent e) {
    }

    private void materialChanged(int rowIndex, Object o) throws Exception {
        KDTable table = this.getDetailTable();
        if (o == null) {
            return;
        }
        MaterialInfo[] materials = null;
        if (o instanceof MaterialInfo) {
            materials = new MaterialInfo[]{(MaterialInfo)o};
        } else if (o instanceof Object[]) {
            int length = ((Object[])o).length;
            materials = new MaterialInfo[length];
            System.arraycopy(o, 0, materials, 0, length);
        } else {
            return;
        }
        for (int i = 0; i < materials.length; ++i) {
            MaterialInfo material = materials[i];
            int curIndex = rowIndex + i;
            table.getCell(curIndex, TB_MATERIAL).setValue((Object)material);
            this.setColumnProperty(null, curIndex, 0, false);
            SCMClientUtils.lockCells((IRow)this.kdtEntry.getRow(curIndex), (String[])new String[]{TB_MATERIAL, TB_RECEIVEWAREHOUSE, TB_AUDITQTY}, (boolean)false);
            if (i >= materials.length - 1) continue;
            this.insertLine(curIndex + 1);
        }
    }

    private void setColumnData(int rowIndex, boolean isOnload) throws Exception {
        IRow row = this.getDetailTable().getRow(rowIndex);
        MaterialInfo material = (MaterialInfo)row.getCell(TB_MATERIAL).getValue();
        StorageOrgUnitInfo sou = (StorageOrgUnitInfo)this.prmtReqStorage.getValue();
        MaterialPlanInfo matPlanInfo = null;
        if (sou != null && sou.getId() != null && material != null && material.getId() != null) {
            matPlanInfo = this.fetchData.getMaterialPlan(material.getId().toString(), sou.getId().toString());
        }
        SCMClientUtils.setProjectTrackEditable((KDTable)this.getDetailTable(), (boolean)this.isBotpBill(), (!isOnload ? 1 : 0) != 0, (int)rowIndex, matPlanInfo, (String)TB_PROJECTNUM, (String)TB_TRACKNUM);
        if (material == null) {
            row.getCell(TB_QTY).setValue((Object)ZERO);
            row.getCell(TB_AUDITQTY).setValue((Object)ZERO);
            row.getCell(TB_BASEQTY).setValue((Object)ZERO);
            row.getCell(TB_AUDITBASEQTY).setValue((Object)ZERO);
            row.getCell(TB_ASSISTQTY).setValue((Object)ZERO);
            row.getCell(TB_APPROVEDASSITQTY).setValue((Object)ZERO);
            SCMClientUtils.clearCells((IRow)row, (String[])new String[]{TB_MATERIALNAME, TB_MODEL, TB_ASSISTPROPERTY, TB_UNIT, TB_BASEUNIT, TB_ASSISTUNIT, TB_PURCHASEORGUNIT, TB_SALEORGUNIT, TB_CUSTOMER, TB_CUSTOMERNAME, TB_RECEIVEWAREHOUSE, TB_SALEORDER, TB_SALEORDERENTRY, TB_PROJECTNUM, TB_TRACKNUM});
            return;
        }
        row.getCell(TB_MATERIALNAME).setValue((Object)material.getName());
        row.getCell(TB_MODEL).setValue((Object)material.getModel());
        if (!isOnload) {
            MaterialInventoryInfo matInvInfo = this.fetchData.getMaterialInventory(material.getId().toString(), sou.getId().toString());
            if (material.getBaseUnit() != null) {
                MeasureUnitInfo baseUnit = MeasureUnitFactory.getRemoteInstance().getMeasureUnitInfo((IObjectPK)new ObjectUuidPK(material.getBaseUnit().getId()));
                material.setBaseUnit(baseUnit);
            }
            if (material.getAssistUnit() != null) {
                MeasureUnitInfo asstUnit = MeasureUnitFactory.getRemoteInstance().getMeasureUnitInfo((IObjectPK)new ObjectUuidPK(material.getAssistUnit().getId()));
                material.setAssistUnit(asstUnit);
            }
            if (matInvInfo != null) {
                row.getCell(TB_UNIT).setValue((Object)matInvInfo.getUnit());
            }
            row.getCell(TB_BASEUNIT).setValue((Object)material.getBaseUnit());
            row.getCell(TB_ASSISTUNIT).setValue((Object)material.getAssistUnit());
            row.getCell(TB_QTY).setValue((Object)ZERO);
            row.getCell(TB_AUDITQTY).setValue((Object)ZERO);
            row.getCell(TB_BASEQTY).setValue((Object)ZERO);
            row.getCell(TB_AUDITBASEQTY).setValue((Object)ZERO);
            row.getCell(TB_ASSISTQTY).setValue((Object)ZERO);
            row.getCell(TB_APPROVEDASSITQTY).setValue((Object)ZERO);
            SCMClientUtils.clearCells((IRow)row, (String[])new String[]{TB_ASSISTPROPERTY, TB_PURCHASEORGUNIT, TB_CUSTOMER, TB_SALEORGUNIT, TB_CUSTOMERNAME, TB_DELIVERYCUSTOMER, TB_RECEIVEWAREHOUSE, TB_SALEORDER, TB_SALEORDERENTRY, TB_PROJECTNUM, TB_TRACKNUM});
            if (this.fetchData.getPurchaseOrgUnitInfo() == null) {
                row.getCell(TB_ISUNCONTROLQTY).setValue((Object)true);
                row.getCell(TB_LESSDELIVERYRATE).setValue((Object)ZERO);
                row.getCell(TB_OVERDELIVERYRATE).setValue((Object)ZERO);
            } else {
                MaterialPurchasingInfo purchasingInfo = this.fetchData.getMaterialPurchasing(material.getId().toString(), this.fetchData.getPurchaseOrgUnitInfo().getId().toString());
                if (purchasingInfo != null) {
                    row.getCell(TB_ISUNCONTROLQTY).setValue((Object)purchasingInfo.isIsNotControlQty());
                    row.getCell(TB_LESSDELIVERYRATE).setValue((Object)purchasingInfo.getReceiveBottomRatio());
                    row.getCell(TB_OVERDELIVERYRATE).setValue((Object)purchasingInfo.getReceiveTopRatio());
                }
            }
        }
        if (row.getCell(TB_RECEIVESTORAGE).getValue() != null) {
            StorageOrgUnitInfo storage = (StorageOrgUnitInfo)row.getCell(TB_RECEIVESTORAGE).getValue();
            this.isUseWarehsRelation = InvClientUtils.isUseWarehsRelation(storage.getId().toString());
            if (this.isUseWarehsRelation) {
                InvClientUtils.setWarehouseFitlerByMSRelation(storage, material, this.getDetailTable(), rowIndex, TB_RECEIVEWAREHOUSE, -1);
            } else {
                InvClientUtils.setWarehouseFitler(storage, this.getDetailTable(), TB_RECEIVEWAREHOUSE, -1);
            }
            if (storage != null) {
                WarehouseInfo defaultwi;
                WarehouseInfo wi = (WarehouseInfo)row.getCell(TB_RECEIVEWAREHOUSE).getValue();
                if (wi == null) {
                    if (!this.isCoay && (!isOnload || this.isBotpBill() && this.editData.getBaseStatus().equals((Object)BillBaseStatusEnum.ADD))) {
                        String strkey = material + storage.getId().toString();
                        if (this.hsMaterialWarehouse.get(strkey) == null) {
                            wi = this.fetchData.getDefaultWarehouse(material.getId().toString(), storage.getId().toString());
                            if (wi != null) {
                                this.hsMaterialWarehouse.put(strkey, wi);
                            }
                        } else {
                            wi = (WarehouseInfo)this.hsMaterialWarehouse.get(strkey);
                        }
                        row.getCell(TB_RECEIVEWAREHOUSE).setValue((Object)wi);
                    }
                } else if (!(this.isCoay || isOnload || this.isBotpBill() || (defaultwi = this.fetchData.getDefaultWarehouse(material.getId().toString(), sou.getId().toString())) == null || defaultwi.getId().equals((Object)wi.getId()) || this.isBotpBill())) {
                    wi = defaultwi;
                    row.getCell(TB_RECEIVEWAREHOUSE).setValue((Object)wi);
                }
            }
        }
    }

    private void setColumnControl(int rowIndex, boolean isOnload) throws Exception {
        IRow row = this.getDetailTable().getRow(rowIndex);
        SCMClientUtils.lockCells((IRow)row, (String[])new String[]{TB_MATERIAL, TB_UNIT, TB_QTY, TB_AUDITQTY, TB_STOCKTYPE, TB_RECEIVEWAREHOUSE, TB_DELIVERYDATE, TB_REQDATEFROM, TB_REQDATETO}, (boolean)false);
        this.setColumnControlByStockType(row);
        MaterialInfo material = (MaterialInfo)row.getCell(TB_MATERIAL).getValue();
        if (material == null) {
            return;
        }
        int qtyPrecision = 2;
        int baseQtyPrecision = 2;
        int asstQtyPrecision = 2;
        if (material != null) {
            if (material.getAssistAttr() != null) {
                row.getCell(TB_ASSISTPROPERTY).getStyleAttributes().setLocked(false);
                SCMClientUtils.setNecessColorInCells((KDTable)this.kdtEntry, (String)TB_ASSISTPROPERTY, (int)rowIndex, (boolean)true);
            } else {
                row.getCell(TB_ASSISTPROPERTY).getStyleAttributes().setLocked(true);
                SCMClientUtils.setNecessColorInCells((KDTable)this.kdtEntry, (String)TB_ASSISTPROPERTY, (int)rowIndex, (boolean)false);
            }
        }
        MeasureUnitInfo unit = null;
        MeasureUnitInfo baseUnit = null;
        MeasureUnitInfo asstUnit = null;
        unit = (MeasureUnitInfo)row.getCell(TB_UNIT).getValue();
        baseUnit = (MeasureUnitInfo)row.getCell(TB_BASEUNIT).getValue();
        asstUnit = (MeasureUnitInfo)row.getCell(TB_ASSISTUNIT).getValue();
        if (unit != null) {
            if (this.fetchData.getUnitPrecision(material.getId().toString(), unit.getId().toString()) == null) {
                MultiMeasureUnitInfo mmuUnit = MultiMeasureUnitFactory.getRemoteInstance().getMultiUnit(material.getId().toString(), unit.getId().toString());
                this.fetchData.putUnitPrecision(material.getId().toString(), unit.getId().toString(), mmuUnit.getQtyPrecision());
                qtyPrecision = mmuUnit.getQtyPrecision();
            } else {
                qtyPrecision = this.fetchData.getUnitPrecision(material.getId().toString(), unit.getId().toString());
            }
        }
        StockReqClientUtils.changePrecision(this.kdtEntry, rowIndex, TBS_QTY, qtyPrecision);
        if (baseUnit != null) {
            if (this.fetchData.getUnitPrecision(material.getId().toString(), baseUnit.getId().toString()) == null) {
                MultiMeasureUnitInfo mmuBaseUnit = MultiMeasureUnitFactory.getRemoteInstance().getMultiUnit(material.getId().toString(), baseUnit.getId().toString());
                this.fetchData.putUnitPrecision(material.getId().toString(), baseUnit.getId().toString(), mmuBaseUnit.getQtyPrecision());
                baseQtyPrecision = mmuBaseUnit.getQtyPrecision();
            } else {
                baseQtyPrecision = this.fetchData.getUnitPrecision(material.getId().toString(), baseUnit.getId().toString());
            }
        }
        StockReqClientUtils.changePrecision(this.kdtEntry, rowIndex, TBS_BASEQTY, baseQtyPrecision);
        if (asstUnit != null) {
            if (this.fetchData.getUnitPrecision(material.getId().toString(), asstUnit.getId().toString()) == null) {
                MultiMeasureUnitInfo mmuAsstUnit = MultiMeasureUnitFactory.getRemoteInstance().getMultiUnit(material.getId().toString(), asstUnit.getId().toString());
                this.fetchData.putUnitPrecision(material.getId().toString(), asstUnit.getId().toString(), mmuAsstUnit.getQtyPrecision());
                asstQtyPrecision = mmuAsstUnit.getQtyPrecision();
            } else {
                asstQtyPrecision = this.fetchData.getUnitPrecision(material.getId().toString(), asstUnit.getId().toString());
            }
        }
        StockReqClientUtils.changePrecision(this.kdtEntry, rowIndex, TBS_ASSTQTY, asstQtyPrecision);
        if (material.getAssistUnit() == null) {
            row.getCell(TB_ASSISTQTY).getStyleAttributes().setLocked(true);
            row.getCell(TB_APPROVEDASSITQTY).getStyleAttributes().setLocked(true);
        } else {
            row.getCell(TB_ASSISTQTY).getStyleAttributes().setLocked(false);
            row.getCell(TB_APPROVEDASSITQTY).getStyleAttributes().setLocked(false);
        }
        StorageOrgUnitInfo sou = (StorageOrgUnitInfo)this.prmtReqStorage.getValue();
        MaterialPlanInfo matPlanInfo = null;
        if (sou != null && sou.getId() != null && material != null && material.getId() != null) {
            matPlanInfo = this.fetchData.getMaterialPlan(material.getId().toString(), sou.getId().toString());
        }
        SCMClientUtils.setProjectTrackEditable((KDTable)this.getDetailTable(), (boolean)this.isBotpBill(), (!isOnload ? 1 : 0) != 0, (int)rowIndex, matPlanInfo, (String)TB_PROJECTNUM, (String)TB_TRACKNUM);
        if (row.getCell(TB_ISUNCONTROLQTY).getValue() != null) {
            boolean qtyControl = (Boolean)row.getCell(TB_ISUNCONTROLQTY).getValue();
            if (qtyControl) {
                row.getCell(TB_LESSDELIVERYRATE).getStyleAttributes().setLocked(true);
                row.getCell(TB_OVERDELIVERYRATE).getStyleAttributes().setLocked(true);
            } else {
                row.getCell(TB_LESSDELIVERYRATE).getStyleAttributes().setLocked(false);
                row.getCell(TB_OVERDELIVERYRATE).getStyleAttributes().setLocked(false);
            }
        } else {
            row.getCell(TB_LESSDELIVERYRATE).getStyleAttributes().setLocked(true);
            row.getCell(TB_OVERDELIVERYRATE).getStyleAttributes().setLocked(true);
        }
    }

    private void setControlByBizType() {
        BizTypeInfo bizType = (BizTypeInfo)this.prmtBizType.getValue();
        if (bizType == null || "3DWHgByZ4UWYgUFme/EhOyQHQ1w=".equals(bizType.getId().toString())) {
            InvClientUtils.setTableLock(this.kdtEntry, new String[]{TB_QTY}, true);
        } else if ("P6/avnd3QEeGPCqlUsZnjyQHQ1w=".equals(bizType.getId().toString())) {
            InvClientUtils.setTableLock(this.kdtEntry, new String[]{TB_QTY}, false);
        }
    }

    private void setColumnControlByStockType(IRow curRow) {
        StockTypeEnum stockType = (StockTypeEnum)((Object)curRow.getCell(TB_STOCKTYPE).getValue());
        boolean isDelivery = StockTypeEnum.DIRECTDELIVERY.equals((Object)stockType);
        if (StockTypeEnum.PURCHASE.equals((Object)stockType)) {
            SCMClientUtils.lockCells((IRow)curRow, (String[])new String[]{TB_SALEORGUNIT, TB_CUSTOMER}, (boolean)true);
            SCMClientUtils.lockCells((IRow)curRow, (String[])new String[]{TB_PURCHASEORGUNIT, TB_SUPPLIER}, (boolean)false);
            SCMClientUtils.setBgColor4Cells((IRow)curRow, (String[])new String[]{TB_CUSTOMER, TB_SALEORDER, TB_SALEORGUNIT}, (boolean)false);
            SCMClientUtils.setBgColor4Cells((IRow)curRow, (String[])new String[]{TB_PURCHASEORGUNIT}, (boolean)true);
        } else if (StockTypeEnum.STOCK.equals((Object)stockType)) {
            SCMClientUtils.lockCells((IRow)curRow, (String[])new String[]{TB_PURCHASEORGUNIT, TB_SUPPLIER, TB_SALEORGUNIT, TB_CUSTOMER}, (boolean)true);
            SCMClientUtils.setBgColor4Cells((IRow)curRow, (String[])new String[]{TB_PURCHASEORGUNIT, TB_SALEORGUNIT, TB_CUSTOMER, TB_SALEORDER}, (boolean)false);
        } else if (StockTypeEnum.SALE.equals((Object)stockType)) {
            SCMClientUtils.lockCells((IRow)curRow, (String[])new String[]{TB_SALEORGUNIT, TB_CUSTOMER}, (boolean)false);
            SCMClientUtils.lockCells((IRow)curRow, (String[])new String[]{TB_PURCHASEORGUNIT, TB_SUPPLIER}, (boolean)true);
            SCMClientUtils.setBgColor4Cells((IRow)curRow, (String[])new String[]{TB_CUSTOMER, TB_SALEORDER, TB_PURCHASEORGUNIT}, (boolean)false);
            SCMClientUtils.setBgColor4Cells((IRow)curRow, (String[])new String[]{TB_SALEORGUNIT}, (boolean)true);
        } else {
            SCMClientUtils.lockCells((IRow)curRow, (String[])new String[]{TB_PURCHASEORGUNIT, TB_SUPPLIER, TB_SALEORGUNIT}, (boolean)true);
            curRow.getCell(TB_CUSTOMER).getStyleAttributes().setLocked(false);
            Object customer = curRow.getCell(TB_CUSTOMER).getValue();
            Object saleOrder = curRow.getCell(TB_SALEORDER).getValue();
            if (customer == null && saleOrder == null) {
                SCMClientUtils.setBgColor4Cells((IRow)curRow, (String[])new String[]{TB_CUSTOMER, TB_SALEORDER}, (boolean)true);
            } else {
                SCMClientUtils.setBgColor4Cells((IRow)curRow, (String[])new String[]{TB_CUSTOMER}, (customer != null ? 1 : 0) != 0);
                SCMClientUtils.setBgColor4Cells((IRow)curRow, (String[])new String[]{TB_SALEORDER}, (saleOrder != null ? 1 : 0) != 0);
            }
            SCMClientUtils.setBgColor4Cells((IRow)curRow, (String[])new String[]{TB_PURCHASEORGUNIT, TB_SALEORGUNIT}, (boolean)false);
        }
        curRow.getCell(TB_SALEORDER).getStyleAttributes().setLocked(!isDelivery);
    }

    private void setColumnDataByStockType(IRow curRow) {
        StockTypeEnum stockType = (StockTypeEnum)((Object)curRow.getCell(TB_STOCKTYPE).getValue());
        if (StockTypeEnum.PURCHASE.equals((Object)stockType)) {
            SCMClientUtils.clearCells((IRow)curRow, (String[])new String[]{TB_SALEORGUNIT, TB_CUSTOMER, TB_CUSTOMERNAME, TB_DELIVERYCUSTOMER, TB_SALEORDERENTRY, TB_SALEORDER});
        } else if (StockTypeEnum.SALE.equals((Object)stockType)) {
            SCMClientUtils.clearCells((IRow)curRow, (String[])new String[]{TB_PURCHASEORGUNIT, TB_SUPPLIER, TB_SUPPLIERNAME, TB_SALEORDERENTRY, TB_SALEORDER});
        } else if (StockTypeEnum.STOCK.equals((Object)stockType)) {
            SCMClientUtils.clearCells((IRow)curRow, (String[])new String[]{TB_SALEORGUNIT, TB_CUSTOMER, TB_CUSTOMERNAME, TB_DELIVERYCUSTOMER, TB_PURCHASEORGUNIT, TB_SUPPLIER, TB_SALEORDERENTRY, TB_SALEORDER, TB_SUPPLIERNAME});
        } else if (StockTypeEnum.DIRECTDELIVERY.equals((Object)stockType)) {
            SCMClientUtils.clearCells((IRow)curRow, (String[])new String[]{TB_SALEORGUNIT, TB_CUSTOMER, TB_CUSTOMERNAME, TB_DELIVERYCUSTOMER, TB_PURCHASEORGUNIT, TB_SUPPLIER, TB_SALEORDERENTRY, TB_SALEORDER, TB_SUPPLIERNAME});
        }
    }

    private void setColumnControlBySaleOrg(int rowIndex) {
        SaleOrgUnitInfo saleou = (SaleOrgUnitInfo)this.kdtEntry.getCell(rowIndex, TB_SALEORGUNIT).getValue();
        if (saleou == null) {
            this.kdtEntry.getCell(rowIndex, TB_CUSTOMER).getStyleAttributes().setLocked(true);
        } else {
            this.kdtEntry.getCell(rowIndex, TB_CUSTOMER).getStyleAttributes().setLocked(false);
        }
    }

    private void setColumnDataBySaleOrg(int rowIndex) {
        SCMClientUtils.clearCells((IRow)this.kdtEntry.getRow(rowIndex), (String[])new String[]{TB_CUSTOMER, TB_CUSTOMERNAME, TB_DELIVERYCUSTOMER});
    }

    private void setColumnControlByPurchaseOrg(int rowIndex) {
        PurchaseOrgUnitInfo pou = (PurchaseOrgUnitInfo)this.kdtEntry.getCell(rowIndex, TB_PURCHASEORGUNIT).getValue();
        if (pou == null) {
            this.kdtEntry.getCell(rowIndex, TB_SUPPLIER).getStyleAttributes().setLocked(true);
        } else {
            this.kdtEntry.getCell(rowIndex, TB_SUPPLIER).getStyleAttributes().setLocked(false);
        }
    }

    private void setColumnDataByPurchaseOrg(int rowIndex) {
        SCMClientUtils.clearCells((IRow)this.kdtEntry.getRow(rowIndex), (String[])new String[]{TB_SUPPLIER, TB_SUPPLIERNAME});
    }

    private void setColumnControlByIsUnControlQty(int rowIndex) {
        IRow curRow = this.kdtEntry.getRow(rowIndex);
        boolean isUnControlQty = (Boolean)this.kdtEntry.getCell(rowIndex, TB_ISUNCONTROLQTY).getValue();
        if (isUnControlQty) {
            curRow.getCell(TB_LESSDELIVERYRATE).getStyleAttributes().setLocked(true);
            curRow.getCell(TB_OVERDELIVERYRATE).getStyleAttributes().setLocked(true);
            curRow.getCell(TB_LESSDELIVERYRATE).setValue((Object)ZERO);
            curRow.getCell(TB_OVERDELIVERYRATE).setValue((Object)ZERO);
        } else {
            curRow.getCell(TB_LESSDELIVERYRATE).getStyleAttributes().setLocked(false);
            curRow.getCell(TB_OVERDELIVERYRATE).getStyleAttributes().setLocked(false);
            BigDecimal lessDeliveryRate = (BigDecimal)curRow.getCell(TB_LESSDELIVERYRATE).getValue();
            BigDecimal overDeliveryRate = (BigDecimal)curRow.getCell(TB_OVERDELIVERYRATE).getValue();
            if (lessDeliveryRate == null) {
                this.editData.getEntry().get(rowIndex).setLessDeliveryRate(ZERO);
                curRow.getCell(TB_LESSDELIVERYRATE).setValue((Object)ZERO);
            }
            if (overDeliveryRate == null) {
                this.editData.getEntry().get(rowIndex).setOverDeliveryRate(ZERO);
                curRow.getCell(TB_OVERDELIVERYRATE).setValue((Object)ZERO);
            }
        }
    }

    protected void setColumnProperty(MaterialInfo materialInfo, int rowIndex, int colIndex, boolean isOnload) throws Exception {
        this.setColumnData(rowIndex, isOnload);
        this.setColumnControl(rowIndex, isOnload);
    }

    public void dataChanged(DataChangeEvent e) {
        Object source = e.getSource();
        if (e.getOldValue() != null && e.getOldValue().equals(e.getNewValue())) {
            return;
        }
        try {
            if (source.equals(this.prmtMaterial)) {
                MaterialInfo[] o = this.prmtMaterial.getValue();
                if (o == null) {
                    o = new MaterialInfo[]{null};
                }
                if (!(o instanceof MaterialInfo[]) && !(o instanceof Object[])) {
                    return;
                }
                KDTSelectBlock ksb = this.kdtEntry.getSelectManager().get();
                int beginRow = ksb == null ? 0 : ksb.getBeginRow();
                this.materialChanged(beginRow, o);
            } else if (source.equals(this.prmtBizType)) {
                this.bizTypeChanged(e);
            } else if (source.equals(this.prmtReqStorage)) {
                if (e.getNewValue() == null) {
                    this.prmtReqStorage.removeDataChangeListener((DataChangeListener)this);
                    this.prmtReqStorage.setValue(e.getOldValue());
                    this.prmtReqStorage.addDataChangeListener((DataChangeListener)this);
                    return;
                }
                this.prmtSupplyStorage.setEnabled(true);
                StorageOrgUnitInfo newSou = (StorageOrgUnitInfo)e.getNewValue();
                StorageOrgUnitInfo oldSou = (StorageOrgUnitInfo)e.getOldValue();
                if (!StockReqClientUtils.equalsID((ObjectBaseInfo)newSou, (ObjectBaseInfo)oldSou)) {
                    if (!this.checkEntryIsBlank(this.kdtEntry)) {
                        int ret = MsgBox.showConfirm2((String)StockReqClientUtils.getResource("ConfirmModifyReqStorage"));
                        if (ret == 2) {
                            this.prmtReqStorage.removeDataChangeListener((DataChangeListener)this);
                            this.prmtReqStorage.setValue((Object)oldSou);
                            this.prmtReqStorage.addDataChangeListener((DataChangeListener)this);
                            return;
                        }
                        this.cleanEntry();
                        this.addLine(this.kdtEntry);
                    }
                    if (e.getNewValue() != null && !e.getNewValue().equals(e.getOldValue())) {
                        for (int i = 0; i < this.kdtEntry.getRowCount(); ++i) {
                            this.kdtEntry.getCell(i, this.kdtEntry.getColumnIndex(TB_PROJECTNUM)).setValue(null);
                            UIHelper.registerProjectF7((KDBizPromptBox)this.getMainOrgUnit(), null, (KDTable)this.kdtEntry, (String)TB_PROJECTNUM);
                            this.kdtEntry.getCell(i, this.kdtEntry.getColumnIndex(TB_TRACKNUM)).setValue(null);
                            UIHelper.registerTrackNumberF7((KDBizPromptBox)this.getMainOrgUnit(), null, (KDTable)this.kdtEntry, (String)TB_PROJECTNUM, (String)TB_TRACKNUM, (boolean)false);
                        }
                    }
                    this.reqStorageChanged();
                }
            } else if (source.equals(this.prmtSupplyStorage)) {
                this.supplyStorageChanged(e);
            } else if (source.equals(this.bizInventory)) {
                this.bizInventoryChanged(e);
            } else if (source.equals(this.prmtSaleOrder)) {
                this.saleOrderChanged(e);
            }
        }
        catch (Exception ex) {
            this.handUIException(ex);
        }
    }

    private void saleOrderChanged(DataChangeEvent e) throws Exception {
        Object newValue = e.getNewValue();
        IRow curRow = this.kdtEntry.getRow(this.curIndex);
        if (newValue instanceof SaleOrderEntryInfo) {
            SaleOrderEntryInfo entryInfo = (SaleOrderEntryInfo)newValue;
            SaleOrderInfo billInfo = (SaleOrderInfo)curRow.getCell(TB_SALEORDER).getValue();
            curRow.getCell(TB_SALEORDERENTRY).setValue((Object)entryInfo);
            if (billInfo != null && billInfo.getId().equals((Object)entryInfo.getParent().getId())) {
                curRow.getCell(TB_SALEORDER).setValue(newValue);
                curRow.getCell(TB_SALEORDER).setValue((Object)billInfo);
                return;
            }
            if (!this.kdtEntryPasteHelper.isPasteing()) {
                billInfo = SaleOrderFactory.getRemoteInstance().getSaleOrderInfo("select id,number,orderCustomer.id,orderCustomer.name,orderCustomer.number where id = '" + entryInfo.getParent().getId().toString() + "'");
                curRow.getCell(TB_SALEORDER).setValue((Object)billInfo);
                curRow.getCell(TB_CUSTOMER).setValue((Object)billInfo.getOrderCustomer());
                curRow.getCell(TB_CUSTOMERNAME).setValue((Object)billInfo.getOrderCustomer().getName());
                curRow.getCell(TB_DELIVERYCUSTOMER).setValue((Object)entryInfo.getDeliveryCustomer());
            }
        }
        boolean isDirect = StockTypeEnum.DIRECTDELIVERY.equals(curRow.getCell(TB_STOCKTYPE).getValue());
        SCMClientUtils.setBgColor4Cells((IRow)curRow, (String[])new String[]{TB_SALEORDER}, (boolean)isDirect);
        SCMClientUtils.clearCells((IRow)curRow, (String[])new String[]{TB_CUSTOMER, TB_CUSTOMERNAME, TB_SALEORDERENTRY, TB_DELIVERYCUSTOMER}, (isDirect && newValue == null ? 1 : 0) != 0);
    }

    public void editStarting(KDTEditEvent e) {
        this.curIndex = e.getRowIndex();
        if (this.kdtEntry.getColumnIndex(TB_SALEORDER) == e.getColIndex()) {
            this.setSaleOrderFilter();
        }
    }

    public void editStarted(KDTEditEvent e) {
    }

    public void editValueChanged(KDTEditEvent e) {
    }

    public void editStopping(KDTEditEvent e) {
    }

    public void editStopped(KDTEditEvent e) {
        try {
            Object oldValue = e.getOldValue();
            Object newValue = e.getValue();
            if (oldValue == null && newValue != null || oldValue != null && !oldValue.equals(newValue)) {
                this.tableValueChanged(e);
            }
        }
        catch (Exception e1) {
            this.handUIException(e1);
        }
    }

    public void editCanceled(KDTEditEvent e) {
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("baseStatus"));
        sic.add(new SelectorItemInfo("year"));
        sic.add(new SelectorItemInfo("period"));
        sic.add(new SelectorItemInfo("bizDate"));
        sic.add(new SelectorItemInfo("sourceBillId"));
        sic.add(new SelectorItemInfo("CU.id"));
        sic.add(new SelectorItemInfo("reqCompany.id"));
        sic.add(new SelectorItemInfo("reqCompany.number"));
        sic.add(new SelectorItemInfo("reqCompany.name"));
        sic.add(new SelectorItemInfo("supplyCompany.id"));
        sic.add(new SelectorItemInfo("supplyCompany.number"));
        sic.add(new SelectorItemInfo("supplyCompany.name"));
        sic.add(new SelectorItemInfo("entry.id"));
        sic.remove(new SelectorItemInfo("entry.material.*"));
        sic.add(new SelectorItemInfo("entry.material.id"));
        sic.add(new SelectorItemInfo("entry.material.number"));
        sic.add(new SelectorItemInfo("entry.material.name"));
        sic.add(new SelectorItemInfo("entry.material.model"));
        sic.add(new SelectorItemInfo("entry.material.baseUnit.name"));
        sic.add(new SelectorItemInfo("entry.material.baseUnit.number"));
        sic.add(new SelectorItemInfo("entry.material.assistUnit.id"));
        sic.add(new SelectorItemInfo("entry.material.assistUnit.name"));
        sic.add(new SelectorItemInfo("entry.material.assistUnit.number"));
        sic.add(new SelectorItemInfo("entry.material.pricePrecision"));
        sic.add(new SelectorItemInfo("entry.material.assistAttr"));
        sic.add(new SelectorItemInfo("entry.material.seqUnit"));
        sic.remove(new SelectorItemInfo("entry.unit.*"));
        sic.add(new SelectorItemInfo("entry.unit.id"));
        sic.add(new SelectorItemInfo("entry.unit.number"));
        sic.add(new SelectorItemInfo("entry.unit.name"));
        sic.add(new SelectorItemInfo("entry.unit.qtyPrecision"));
        sic.add(new SelectorItemInfo("entry.unit.coefficient"));
        sic.add(new SelectorItemInfo("entry.unit.isBaseUnit"));
        sic.remove(new SelectorItemInfo("entry.baseUnit.*"));
        sic.add(new SelectorItemInfo("entry.baseUnit.id"));
        sic.add(new SelectorItemInfo("entry.baseUnit.number"));
        sic.add(new SelectorItemInfo("entry.baseUnit.name"));
        sic.add(new SelectorItemInfo("entry.baseUnit.qtyPrecision"));
        sic.add(new SelectorItemInfo("entry.baseUnit.coefficient"));
        sic.add(new SelectorItemInfo("entry.baseUnit.isBaseUnit"));
        sic.remove(new SelectorItemInfo("entry.assistUnit.*"));
        sic.add(new SelectorItemInfo("entry.assistUnit.id"));
        sic.add(new SelectorItemInfo("entry.assistUnit.number"));
        sic.add(new SelectorItemInfo("entry.assistUnit.name"));
        sic.add(new SelectorItemInfo("entry.assistUnit.qtyPrecision"));
        sic.add(new SelectorItemInfo("entry.assistUnit.coefficient"));
        sic.add(new SelectorItemInfo("entry.assistUnit.isBaseUnit"));
        sic.remove(new SelectorItemInfo("entry.assistProperty.*"));
        sic.add(new SelectorItemInfo("entry.assistProperty.id"));
        sic.add(new SelectorItemInfo("entry.assistProperty.number"));
        sic.add(new SelectorItemInfo("entry.assistProperty.name"));
        sic.add(new SelectorItemInfo("entry.receiveStorage.number"));
        sic.add(new SelectorItemInfo("entry.receiveStorage.name"));
        sic.remove(new SelectorItemInfo("creator.*"));
        sic.add(new SelectorItemInfo("creator.id"));
        sic.add(new SelectorItemInfo("creator.number"));
        sic.add(new SelectorItemInfo("creator.name"));
        sic.remove(new SelectorItemInfo("modifier.*"));
        sic.add(new SelectorItemInfo("modifier.id"));
        sic.add(new SelectorItemInfo("modifier.number"));
        sic.add(new SelectorItemInfo("modifier.name"));
        sic.remove(new SelectorItemInfo("auditor.*"));
        sic.add(new SelectorItemInfo("auditor.id"));
        sic.add(new SelectorItemInfo("auditor.number"));
        sic.add(new SelectorItemInfo("auditor.name"));
        sic.remove(new SelectorItemInfo("bizType.*"));
        sic.add(new SelectorItemInfo("bizType.id"));
        sic.add(new SelectorItemInfo("bizType.name"));
        sic.add(new SelectorItemInfo("bizType.number"));
        sic.add(new SelectorItemInfo("bizType.isDefault"));
        sic.add(new SelectorItemInfo("bizType.billBizType.*"));
        sic.remove(new SelectorItemInfo("sourceBillType.*"));
        sic.add(new SelectorItemInfo("sourceBillType.id"));
        sic.add(new SelectorItemInfo("sourceBillType.name"));
        sic.add(new SelectorItemInfo("sourceBillType.number"));
        sic.add(new SelectorItemInfo("sourceBillType.billTypeGroup"));
        sic.remove(new SelectorItemInfo("proposer.*"));
        sic.add(new SelectorItemInfo("proposer.id"));
        sic.add(new SelectorItemInfo("proposer.name"));
        sic.add(new SelectorItemInfo("proposer.number"));
        sic.remove(new SelectorItemInfo("entry.project.*"));
        sic.add(new SelectorItemInfo("entry.project.id"));
        sic.add(new SelectorItemInfo("entry.project.number"));
        sic.add(new SelectorItemInfo("entry.project.name"));
        sic.remove(new SelectorItemInfo("entry.trackNumber.*"));
        sic.add(new SelectorItemInfo("entry.trackNumber.id"));
        sic.add(new SelectorItemInfo("entry.trackNumber.number"));
        sic.add(new SelectorItemInfo("entry.trackNumber.name"));
        sic.remove(new SelectorItemInfo("entry.supplier.*"));
        sic.add(new SelectorItemInfo("entry.supplier.id"));
        sic.add(new SelectorItemInfo("entry.supplier.number"));
        sic.add(new SelectorItemInfo("entry.supplier.name"));
        sic.remove(new SelectorItemInfo("entry.customer.*"));
        sic.add(new SelectorItemInfo("entry.customer.id"));
        sic.add(new SelectorItemInfo("entry.customer.number"));
        sic.add(new SelectorItemInfo("entry.customer.name"));
        sic.remove(new SelectorItemInfo("entry.deliveryCustomer.*"));
        sic.add(new SelectorItemInfo("entry.deliveryCustomer.id"));
        sic.add(new SelectorItemInfo("entry.deliveryCustomer.number"));
        sic.add(new SelectorItemInfo("entry.deliveryCustomer.name"));
        sic.remove(new SelectorItemInfo("entry.receiveWarehouse.*"));
        sic.add(new SelectorItemInfo("entry.receiveWarehouse.id"));
        sic.add(new SelectorItemInfo("entry.receiveWarehouse.number"));
        sic.add(new SelectorItemInfo("entry.receiveWarehouse.name"));
        sic.add(new SelectorItemInfo("entry.receiveWarehouse.hasLocation"));
        sic.remove(new SelectorItemInfo("entry.receiveCompany.*"));
        sic.add(new SelectorItemInfo("entry.receiveCompany.id"));
        sic.add(new SelectorItemInfo("entry.receiveCompany.number"));
        sic.add(new SelectorItemInfo("entry.receiveCompany.name"));
        sic.remove(new SelectorItemInfo("entry.purchaseOrgUnit.*"));
        sic.add(new SelectorItemInfo("entry.purchaseOrgUnit.id"));
        sic.add(new SelectorItemInfo("entry.purchaseOrgUnit.number"));
        sic.add(new SelectorItemInfo("entry.purchaseOrgUnit.name"));
        sic.remove(new SelectorItemInfo("entry.saleOrgUnit.*"));
        sic.add(new SelectorItemInfo("entry.saleOrgUnit.id"));
        sic.add(new SelectorItemInfo("entry.saleOrgUnit.number"));
        sic.add(new SelectorItemInfo("entry.saleOrgUnit.name"));
        sic.remove(new SelectorItemInfo("entry.saleOrderEntry.*"));
        sic.add(new SelectorItemInfo("entry.saleOrderEntry.id"));
        sic.add(new SelectorItemInfo("entry.saleOrderEntry.seq"));
        sic.remove(new SelectorItemInfo("entry.saleOrder.*"));
        sic.add(new SelectorItemInfo("entry.saleOrder.id"));
        sic.add(new SelectorItemInfo("entry.saleOrder.number"));
        sic.add(new SelectorItemInfo("entry.saleOrder.bizDate"));
        sic.add(new SelectorItemInfo("entry.saleOrder.bizType.id"));
        sic.add(new SelectorItemInfo("entry.saleOrder.bizType.number"));
        sic.add(new SelectorItemInfo("entry.saleOrder.billType.id"));
        sic.add(new SelectorItemInfo("entry.saleOrder.billType.number"));
        sic.add(new SelectorItemInfo("entry.saleOrder.billType.name"));
        sic.add(new SelectorItemInfo("billType.id"));
        sic.add(new SelectorItemInfo("billType.number"));
        sic.add(new SelectorItemInfo("billType.name"));
        return sic;
    }

    public void tableSelectChanged(KDTSelectEvent e) {
        if (this.kdtEntry.getSelectManager().get() == null) {
            return;
        }
        int beginRow = this.kdtEntry.getSelectManager().get().getBeginRow();
        int beginCol = this.kdtEntry.getSelectManager().get().getBeginCol();
        if (beginRow < 0 || beginRow > this.kdtEntry.getRowCount() || beginCol < 0) {
            return;
        }
        KDTable table = this.getDetailTable();
        String beginColName = table.getColumnKey(beginCol);
        MaterialInfo material = (MaterialInfo)this.kdtEntry.getCell(beginRow, TB_MATERIAL).getValue();
        try {
            FilterInfo filter;
            EntityViewInfo view;
            IStockReqFacade isrf;
            if (TB_UNIT.equals(beginColName)) {
                if (material == null) {
                    this.prmtUnit.setEntityViewInfo(SCMClientUtils.getNullView());
                } else {
                    SCMClientUtils.setF7MeasureUnit((KDBizPromptBox)this.prmtUnit, (String)material.getId().toString());
                }
            }
            if (TB_ASSISTPROPERTY.equals(beginColName)) {
                if (material == null || material.getAssistAttr() == null) {
                    this.prmtAsstAttr.setEntityViewInfo(SCMClientUtils.getNullView());
                } else {
                    AsstAttrTypeInfo asst = material.getAssistAttr();
                    if (asst != null) {
                        SCMClientUtils.setAsstAttrInputF7((KDBizPromptBox)this.prmtAsstAttr, (MaterialInfo)material, (IUIObject)this);
                    }
                }
            }
            if (TB_PURCHASEORGUNIT.equals(beginColName)) {
                StorageOrgUnitInfo receiveStorage = (StorageOrgUnitInfo)this.kdtEntry.getCell(beginRow, TB_RECEIVESTORAGE).getValue();
                CompanyOrgUnitInfo supplyCompany = this.supplyCompany;
                if (receiveStorage == null || supplyCompany == null) {
                    this.prmtPurchaseOrgUnit.setEntityViewInfo(SCMClientUtils.getNullView());
                } else {
                    isrf = StockReqFacadeFactory.getRemoteInstance();
                    this.prmtPurchaseOrgUnit.setEntityViewInfo(isrf.getPouFilterByReceiveStorageAndSupplyCompany(receiveStorage.getId().toString(), supplyCompany.getId().toString()));
                }
            }
            if (TB_SUPPLIER.equals(beginColName)) {
                PurchaseOrgUnitInfo pou = (PurchaseOrgUnitInfo)this.kdtEntry.getCell(beginRow, TB_PURCHASEORGUNIT).getValue();
                if (pou == null) {
                    this.prmtSupplier.setEntityViewInfo(SCMClientUtils.getNullView());
                } else {
                    view = new EntityViewInfo();
                    filter = new FilterInfo();
                    filter.getFilterItems().add(new FilterItemInfo("purchaseOrgUnit.id", (Object)pou.getId().toString()));
                    filter.getFilterItems().add(new FilterItemInfo("usedStatus", (Object)new Integer(1)));
                    filter.getFilterItems().add(new FilterItemInfo("browseGroup.groupStandard", (Object)"00000000-0000-0000-0000-000000000001BC122A7F"));
                    view.setFilter(filter);
                    this.prmtSupplier.setEntityViewInfo(view);
                }
            }
            if (TB_SALEORGUNIT.equals(beginColName)) {
                StorageOrgUnitInfo supplyStorage = (StorageOrgUnitInfo)this.prmtSupplyStorage.getValue();
                CompanyOrgUnitInfo receiveCompany = (CompanyOrgUnitInfo)this.kdtEntry.getCell(beginRow, TB_RECEIVECOMPANY).getValue();
                if (supplyStorage == null || receiveCompany == null) {
                    this.prmtSaleOrgUnit.setEntityViewInfo(SCMClientUtils.getNullView());
                } else {
                    isrf = StockReqFacadeFactory.getRemoteInstance();
                    this.prmtSaleOrgUnit.setEntityViewInfo(isrf.getSaleouFilterByReceiveStorageAndReceiveCompany(supplyStorage.getId().toString(), receiveCompany.getId().toString()));
                }
            }
            if (TB_CUSTOMER.equals(beginColName)) {
                SaleOrgUnitInfo saleou = (SaleOrgUnitInfo)this.kdtEntry.getCell(beginRow, TB_SALEORGUNIT).getValue();
                if (StockTypeEnum.DIRECTDELIVERY.equals(this.kdtEntry.getCell(beginRow, TB_STOCKTYPE).getValue())) {
                    OrgUnitInfo orgInfo = null;
                    if (this.getMainOrgContext() != null) {
                        orgInfo = (OrgUnitInfo)this.getMainOrgContext().get((Object)OrgType.Company);
                    }
                    this.f7Manager.registerBizCustomerF7(this.prmtCustomer, null, null, orgInfo, OrgType.Company, true);
                } else {
                    this.prmtCustomer = new KDBizPromptBox();
                    StockReqClientUtils.setDefaultF7Editor(this.prmtCustomer, "com.kingdee.eas.basedata.master.cssp.app.F7CustomerSaleQueryWithDefaultStandard", this.kdtEntry, TB_CUSTOMER);
                    view = new EntityViewInfo();
                    filter = new FilterInfo();
                    filter.getFilterItems().clear();
                    filter.getFilterItems().add(new FilterItemInfo("usedStatus", (Object)new Integer(1)));
                    filter.getFilterItems().add(new FilterItemInfo("browseGroup.groupStandard", (Object)"00000000-0000-0000-0000-000000000002BC122A7F"));
                    if (saleou == null) {
                        this.prmtCustomer.setEntityViewInfo(SCMClientUtils.getNullView());
                    } else {
                        filter.getFilterItems().add(new FilterItemInfo("saleOrgUnit.id", (Object)saleou.getId().toString()));
                    }
                    view.setFilter(filter);
                    this.prmtCustomer.setEntityViewInfo(view);
                }
            }
            if (TB_RECEIVEWAREHOUSE.equals(beginColName)) {
                StorageOrgUnitInfo receiveSou = (StorageOrgUnitInfo)this.kdtEntry.getCell(beginRow, TB_RECEIVESTORAGE).getValue();
                if (receiveSou == null) {
                    this.prmtReceiveWarehouse.setEntityViewInfo(SCMClientUtils.getNullView());
                } else {
                    view = new EntityViewInfo();
                    filter = new FilterInfo();
                    filter.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)receiveSou.getId().toString()));
                    filter.getFilterItems().add(new FilterItemInfo("whState", (Object)"1"));
                    view.setFilter(filter);
                    this.prmtReceiveWarehouse.setEntityViewInfo(view);
                }
            }
        }
        catch (Exception ex) {
            this.handUIException(ex);
        }
    }

    @Override
    protected void setFieldsNull(AbstractObjectValue arg0) {
        super.setFieldsNull(arg0);
        if (arg0 == null) {
            return;
        }
        StockReqInfo info = (StockReqInfo)arg0;
        info.setBaseStatus(BillBaseStatusEnum.ADD);
        StockReqEntryInfo entryInfo = null;
        for (int i = 0; i < info.getEntry().size(); ++i) {
            entryInfo = info.getEntry().get(i);
            entryInfo.setTotalStockQty(ZERO);
            entryInfo.setTotalStockBaseQty(ZERO);
            entryInfo.setAssociateQty(ZERO);
            entryInfo.setBaseStatus(EntryBaseStatusEnum.ADD);
            entryInfo.setSaleOrder(null);
            entryInfo.setSaleOrderEntry(null);
        }
    }

    protected String getPermissionItem(String status) {
        if (status.equals("ADDNEW")) {
            return "stockReq_new";
        }
        return null;
    }

    protected boolean checkValid() {
        return true;
    }

    protected HashMap getQueryCondition() throws Exception {
        HashMap<String, Object> hm = new HashMap<String, Object>();
        StorageOrgUnitInfo sou = (StorageOrgUnitInfo)this.prmtReqStorage.getData();
        if (sou != null) {
            hm.put("STORAGEORGUNIT", sou);
        }
        boolean isTableFocus = SCMClientUtils.isTableFocus((KDTable)this.kdtEntry);
        hm.put("TABLEHASFOCUS", isTableFocus);
        KDTSelectBlock selectBlock = this.kdtEntry.getSelectManager().get();
        if (selectBlock != null) {
            TrackNumberInfo trackNumberInfo;
            MeasureUnitInfo aMeasureUnitInfo;
            int rowIndex = selectBlock.getTop();
            IRow row = this.kdtEntry.getRow(rowIndex);
            if (row == null) {
                return hm;
            }
            ICell cell = row.getCell(TB_MATERIAL);
            MaterialInfo material = (MaterialInfo)cell.getValue();
            hm.put("MATERIAL", material);
            cell = row.getCell(TB_ASSISTPROPERTY);
            AsstAttrValueInfo assistantAttr = (AsstAttrValueInfo)cell.getValue();
            if (assistantAttr != null && assistantAttr.getId() != null) {
                hm.put("ASSISTANTATTR", assistantAttr.getId().toString());
            }
            if ((aMeasureUnitInfo = (MeasureUnitInfo)(cell = row.getCell(TB_UNIT)).getValue()) != null && aMeasureUnitInfo.getId() != null) {
                hm.put("UNIT", aMeasureUnitInfo.getId().toString());
            }
            hm.put("TABLEHASFOCUS", this.kdtEntry.hasFocus());
            cell = row.getCell(TB_PROJECTNUM);
            ProjectInfo projectInfo = (ProjectInfo)cell.getValue();
            if (projectInfo != null && projectInfo.getId() != null) {
                hm.put("PROJECT", projectInfo.getId().toString());
            }
            if ((trackNumberInfo = (TrackNumberInfo)(cell = row.getCell(TB_TRACKNUM)).getValue()) != null && trackNumberInfo.getId() != null) {
                hm.put("TRACKNUM", trackNumberInfo.getId().toString());
            }
        }
        return hm;
    }

    protected String getEntryMaterialFieldName() {
        return TB_MATERIAL;
    }

    protected SCMFetchDataCondition buildCondition() {
        SCMFetchDataCondition condition = new SCMFetchDataCondition();
        condition.setFetchSou(true);
        condition.setFetchIsNegative(true);
        condition.setFetchInventoryUnit(true);
        condition.setFetchCompany(true);
        condition.setFetchCompanyStatus(true);
        condition.setFetchUnitPrecision(true);
        condition.setFetchBaseUnitPrecision(true);
        condition.setFetchAsstUnitPrecision(true);
        String[] materialPKs = new String[this.editData.getEntry().size()];
        String[] unitPKs = new String[this.editData.getEntry().size()];
        String[] baseUnitPKs = new String[this.editData.getEntry().size()];
        String[] asstUnitPKs = new String[this.editData.getEntry().size()];
        for (int i = 0; i < this.editData.getEntry().size(); ++i) {
            MeasureUnitInfo asstUnit;
            MeasureUnitInfo baseUnit;
            MaterialInfo material = this.editData.getEntry().get(i).getMaterial();
            if (material != null) {
                materialPKs[i] = material.getId().toString();
            } else if (this.editData.getEntry().size() == 1) {
                materialPKs = null;
            }
            MeasureUnitInfo unit = this.editData.getEntry().get(i).getUnit();
            if (unit != null) {
                unitPKs[i] = unit.getId().toString();
            }
            if ((baseUnit = this.editData.getEntry().get(i).getBaseUnit()) != null) {
                baseUnitPKs[i] = baseUnit.getId().toString();
            }
            if ((asstUnit = this.editData.getEntry().get(i).getAssistUnit()) == null) continue;
            asstUnitPKs[i] = asstUnit.getId().toString();
        }
        condition.setCou(this.editData.getReqCompany());
        condition.setMaterialPKs(materialPKs);
        condition.setUnitPKs(unitPKs);
        condition.setBaseUnitPKs(baseUnitPKs);
        condition.setAsstUnitPKs(asstUnitPKs);
        condition.setSou(this.editData.getReqStorage());
        condition.setfetchMaterialPlan(true);
        condition.setFetchParamValue(true);
        condition.setFetchAuthorg(Boolean.valueOf(true));
        return condition;
    }

    public void actionAudit_actionPerformed(ActionEvent e) throws Exception {
        super.actionAudit_actionPerformed(e);
        if (this.editData.getSourceBillType() != null || this.editData.getEntry().get(0).getSourceBillId() != null) {
            this.btnCopy.setEnabled(false);
        }
    }

    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrint_actionPerformed(e);
        this.invokePrintFunction(e, true);
    }

    public void actionPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrintPreview_actionPerformed(e);
        this.invokePrintFunction(e, false);
    }

    protected void invokePrintFunction(ActionEvent e, boolean noPreview) throws Exception {
        this.invokePrintFunction(noPreview);
    }

    @Override
    public void actionQuickAdd_actionPerformed(ActionEvent e) throws Exception {
        super.actionQuickAdd_actionPerformed(e);
        if (this.isBotpBill()) {
            return;
        }
        this.inventoryAdaptor();
    }

    protected void setAddLineStatus(boolean status) {
        super.setAddLineStatus(status);
        this.actionQuickAdd.setEnabled(status);
    }

    private void inventoryAdaptor() throws Exception {
        if (this.prmtReqStorage.getValue() == null) {
            MsgBox.showError((Component)((Object)this), (String)StockReqClientUtils.getResource("reqStorageIsNull"));
            SysUtil.abort();
        }
        if (this.prmtBizType.getValue() == null) {
            MsgBox.showError((Component)((Object)this), (String)StockReqClientUtils.getResource("bizTypeIsNull"));
            SysUtil.abort();
        }
        this.actionInventoryF7Query();
    }

    private void bizInventoryChanged(DataChangeEvent e) {
        if (e.getNewValue() == null) {
            return;
        }
        InventoryInfo[] Inventory0 = (InventoryInfo[])e.getNewValue();
        int sRowIndex = this.kdtEntry.getRowCount();
        if (sRowIndex == 0) {
            this.addLine(this.kdtEntry);
        }
        if (sRowIndex == 1 && this.kdtEntry.getCell(0, TB_MATERIAL).getValue() == null) {
            sRowIndex = 0;
        }
        for (int i = 0; i < Inventory0.length; ++i) {
            if (sRowIndex != 0) {
                this.addLine(this.kdtEntry);
            }
            InventoryInfo sInventory = Inventory0[i];
            if (sRowIndex == -1) continue;
            try {
                if (sInventory.getMaterial() != null) {
                    this.kdtEntry.getRow(sRowIndex).getCell(TB_MATERIAL).setValue((Object)sInventory.getMaterial());
                    this.materialChanged(sRowIndex, sInventory.getMaterial());
                }
                if (sInventory.getCurStoreQty() != null) {
                    this.kdtEntry.getRow(sRowIndex).getCell(TB_QTY).setValue((Object)sInventory.getCurStoreQty());
                    this.kdtEntry.getRow(sRowIndex).getCell(TB_AUDITQTY).setValue((Object)sInventory.getCurStoreQty());
                }
                this.kdtEntry.getRow(sRowIndex).getCell(TB_UNIT).setValue((Object)sInventory.getUnit());
                Integer scale = this.fetchData.getUnitPrecision(sInventory.getMaterial().getId().toString(), sInventory.getUnit().getId().toString());
                StockReqClientUtils.changePrecision(this.kdtEntry, sRowIndex, TBS_QTY, scale == null ? 0 : scale);
                if (sInventory.getCurStoreQty() != null) {
                    BigDecimal baseQty = InvClientUtils.getBaseUnitQty(sInventory.getUnit(), sInventory.getMaterial(), sInventory.getCurStoreQty());
                    this.kdtEntry.getRow(sRowIndex).getCell(TB_BASEQTY).setValue((Object)baseQty);
                    this.kdtEntry.getRow(sRowIndex).getCell(TB_AUDITBASEQTY).setValue((Object)baseQty);
                }
                if (sInventory.getAssistUnit() != null) {
                    this.kdtEntry.getRow(sRowIndex).getCell(TB_ASSISTUNIT).setValue((Object)sInventory.getAssistUnit());
                    if (sInventory.getCurStoreAssistQty() != null) {
                        this.kdtEntry.getRow(sRowIndex).getCell(TB_ASSISTQTY).setValue((Object)sInventory.getCurStoreAssistQty());
                    }
                }
                if (sInventory.getAssistProperty() != null) {
                    this.kdtEntry.getRow(sRowIndex).getCell(TB_ASSISTPROPERTY).setValue((Object)sInventory.getAssistProperty());
                    this.kdtEntry.getRow(i).getCell(TB_ASSISTPROPERTY).getStyleAttributes().setLocked(false);
                }
                if (sInventory.getProject() != null) {
                    this.kdtEntry.getRow(sRowIndex).getCell(TB_PROJECTNUM).setValue((Object)sInventory.getProject());
                }
                if (sInventory.getTrackNumber() != null) {
                    this.kdtEntry.getRow(sRowIndex).getCell(TB_TRACKNUM).setValue((Object)sInventory.getTrackNumber());
                }
                ++sRowIndex;
                continue;
            }
            catch (Exception e2) {
                this.handUIException(e2);
            }
        }
    }

    private void calculateTotal() throws Exception {
        HashMap<String, StockReqEntryInfo> map = new HashMap<String, StockReqEntryInfo>();
        LinkedList<String> keyList = new LinkedList<String>();
        int n = this.kdtEntry.getRowCount();
        for (int i = 0; i < n; ++i) {
            StockReqEntryInfo entry;
            MaterialInfo material = (MaterialInfo)this.kdtEntry.getCell(i, TB_MATERIAL).getValue();
            if (material == null) continue;
            AsstAttrValueInfo asstAttr = (AsstAttrValueInfo)this.kdtEntry.getCell(i, TB_ASSISTPROPERTY).getValue();
            MeasureUnitInfo unit = (MeasureUnitInfo)this.kdtEntry.getCell(i, TB_UNIT).getValue();
            MeasureUnitInfo baseUnit = (MeasureUnitInfo)this.kdtEntry.getCell(i, TB_BASEUNIT).getValue();
            BigDecimal auditQty = (BigDecimal)this.kdtEntry.getCell(i, TB_AUDITQTY).getValue();
            BigDecimal qty = (BigDecimal)this.kdtEntry.getCell(i, TB_QTY).getValue();
            if (auditQty == null) {
                auditQty = ZERO;
            }
            if (qty == null) {
                qty = ZERO;
            }
            StockTypeEnum stockType = (StockTypeEnum)((Object)this.kdtEntry.getCell(i, TB_STOCKTYPE).getValue());
            MeasureUnitInfo assistUnit = (MeasureUnitInfo)this.kdtEntry.getCell(i, TB_ASSISTUNIT).getValue();
            BigDecimal auditBaseQty = null;
            BigDecimal baseQty = null;
            if (baseUnit != null && unit != null) {
                auditBaseQty = InvClientUtils.getConvsBaseQty(auditQty, this.fetchData.getUnitbaseConvsRate(material.getId().toString(), unit.getId().toString()), this.fetchData.getUnitPrecision(material.getId().toString(), material.getBaseUnit().getId().toString()));
                baseQty = InvClientUtils.getConvsBaseQty(qty, this.fetchData.getUnitbaseConvsRate(material.getId().toString(), unit.getId().toString()), this.fetchData.getUnitPrecision(material.getId().toString(), material.getBaseUnit().getId().toString()));
            }
            BigDecimal assistQty = null;
            BigDecimal approvedAssitQty = null;
            if (assistUnit != null) {
                assistQty = InvClientUtils.getConvsAssQty(auditBaseQty, this.fetchData.getUnitbaseConvsRate(material.getId().toString(), assistUnit.getId().toString()), this.fetchData.getUnitPrecision(material.getId().toString(), assistUnit.getId().toString()));
                approvedAssitQty = InvClientUtils.getConvsAssQty(baseQty, this.fetchData.getUnitbaseConvsRate(material.getId().toString(), assistUnit.getId().toString()), this.fetchData.getUnitPrecision(material.getId().toString(), assistUnit.getId().toString()));
            }
            if (assistQty == null) {
                assistQty = ZERO;
            }
            if (approvedAssitQty == null) {
                approvedAssitQty = ZERO;
            }
            if (stockType == null) {
                stockType = StockTypeEnum.Null;
            }
            String materialID = material.getId().toString();
            String asstAttrID = asstAttr == null ? null : asstAttr.getId().toString();
            String unitID = unit == null ? null : unit.getId().toString();
            String key = materialID + asstAttrID + unitID + stockType.getValue();
            if (keyList.contains(key)) {
                entry = (StockReqEntryInfo)map.get(key);
                entry.setAuditQty(entry.getAuditQty().add(auditQty));
                entry.setAssistQty(entry.getAssistQty().add(assistQty));
                entry.setApprovedAssitQty(entry.getApprovedAssitQty().add(approvedAssitQty));
                continue;
            }
            entry = new StockReqEntryInfo();
            entry.setMaterial(material);
            entry.setAssistProperty(asstAttr);
            entry.setUnit(unit);
            entry.setBaseUnit(baseUnit);
            entry.setAuditQty(auditQty);
            entry.setStockType(stockType);
            entry.setAssistUnit(assistUnit);
            entry.setAssistQty(assistQty);
            entry.setApprovedAssitQty(approvedAssitQty);
            map.put(key, entry);
            keyList.add(key);
        }
        this.kdtTotal.removeRows();
        Iterator keyIter = keyList.iterator();
        while (keyIter.hasNext()) {
            IRow row = this.kdtTotal.addRow();
            StockReqEntryInfo entry = (StockReqEntryInfo)map.get(keyIter.next());
            row.getCell(TB_MATERIAL).setValue((Object)entry.getMaterial().getNumber());
            row.getCell(TB_MATERIALNAME).setValue((Object)entry.getMaterial().getName());
            row.getCell(TB_MODEL).setValue((Object)entry.getMaterial().getModel());
            if (entry.getAssistProperty() != null) {
                row.getCell(TB_ASSISTPROPERTY).setValue((Object)entry.getAssistProperty().getName());
            }
            if (entry.getUnit() != null) {
                int qtyPrecision;
                row.getCell(TB_UNIT).setValue((Object)entry.getUnit().getName());
                if (this.fetchData.getUnitPrecision(entry.getMaterial().getId().toString(), entry.getUnit().getId().toString()) == null) {
                    MultiMeasureUnitInfo mmuUnit = MultiMeasureUnitFactory.getRemoteInstance().getMultiUnit(entry.getMaterial().getId().toString(), entry.getUnit().getId().toString());
                    this.fetchData.putUnitPrecision(entry.getMaterial().getId().toString(), entry.getUnit().getId().toString(), mmuUnit.getQtyPrecision());
                    qtyPrecision = mmuUnit.getQtyPrecision();
                } else {
                    qtyPrecision = this.fetchData.getUnitPrecision(entry.getMaterial().getId().toString(), entry.getUnit().getId().toString());
                }
                StockReqClientUtils.changePrecision(this.kdtTotal, row.getRowIndex(), new String[]{TB_QTY}, qtyPrecision);
            }
            row.getCell(TB_QTY).setValue((Object)entry.getAuditQty());
            row.getCell(TB_STOCKTYPE).setValue((Object)entry.getStockType());
            if (entry.getAssistUnit() != null) {
                int asstQtyPrecision;
                row.getCell(TB_ASSISTUNIT).setValue((Object)entry.getAssistUnit().getName());
                if (this.fetchData.getUnitPrecision(entry.getMaterial().getId().toString(), entry.getAssistUnit().getId().toString()) == null) {
                    MultiMeasureUnitInfo mmuAsstUnit = MultiMeasureUnitFactory.getRemoteInstance().getMultiUnit(entry.getMaterial().getId().toString(), entry.getAssistUnit().getId().toString());
                    this.fetchData.putUnitPrecision(entry.getMaterial().getId().toString(), entry.getAssistUnit().getId().toString(), mmuAsstUnit.getQtyPrecision());
                    asstQtyPrecision = mmuAsstUnit.getQtyPrecision();
                } else {
                    asstQtyPrecision = this.fetchData.getUnitPrecision(entry.getMaterial().getId().toString(), entry.getAssistUnit().getId().toString());
                }
                StockReqClientUtils.changePrecision(this.kdtTotal, row.getRowIndex(), TBS_ASSTQTY, asstQtyPrecision);
            }
            row.getCell(TB_ASSISTQTY).setValue((Object)entry.getAssistQty());
            row.getCell(TB_APPROVEDASSITQTY).setValue((Object)entry.getApprovedAssitQty());
        }
    }

    public void onShow() throws Exception {
        super.onShow();
        if (this.txtNumber.isEditable()) {
            this.txtNumber.requestFocus();
        } else {
            this.prmtReqStorage.requestFocus();
        }
    }

    protected IMetaDataPK getTDQueryPK() {
        return MetaDataPK.create((String)"com.kingdee.eas.scm.im.inv.StockReqEditPrintQuery");
    }

    protected String getTDFileName() {
        return "/SCM/IM/ReqBill/StockReqBill";
    }

    private boolean checkEntryIsBlank(KDTable table) {
        int rows = table.getRowCount();
        if (rows > 0) {
            for (int i = 0; i < rows; ++i) {
                if (table.getRow(i).getCell(table.getColumnIndex(TB_MATERIAL)).getValue() == null) continue;
                return false;
            }
            return true;
        }
        return true;
    }

    protected void setActionEnableByTransType() {
        if ("VIEW".equals(this.getOprtState()) || "FINDVIEW".equals(this.getOprtState())) {
            return;
        }
        if (this.isHasSourceBill()) {
            this.actionCopy.setEnabled(false);
            this.actionAddLine.setEnabled(false);
            this.actionInsertLine.setEnabled(false);
            this.actionTraceDown.setEnabled(true);
            this.actionTraceUp.setEnabled(true);
        } else {
            this.actionCopy.setEnabled(true);
            this.actionAddLine.setEnabled(true);
            this.actionInsertLine.setEnabled(true);
        }
    }

    protected boolean isHasSourceBill() {
        return this.prmtSourceBillType.getValue() != null;
    }

    @Override
    public void focusGained(FocusEvent e) {
        Object f7 = e.getSource();
        if (f7.equals(this.prmtSupplyStorage.getEditor())) {
            this.setSupplyStorageFilter();
        }
    }

    @Override
    public void focusLost(FocusEvent e) {
    }

    public void willShow(SelectorEvent e) {
        Object f7 = e.getSource();
        if (f7.equals(this.prmtSupplyStorage)) {
            this.setSupplyStorageFilter();
        }
    }

    public void setSaleOrderFilter() {
        IRow row = this.kdtEntry.getRow(this.curIndex);
        MaterialInfo material = (MaterialInfo)row.getCell(TB_MATERIAL).getValue();
        StorageOrgUnitInfo souInfo = (StorageOrgUnitInfo)row.getCell(TB_RECEIVESTORAGE).getValue();
        this.prmtSaleOrder.setEntityViewInfo(StockReqClientUtils.getSaleOrderView(this.saleOrderView, material, souInfo));
    }

    private void setSupplyStorageFilter() {
        String reqCompanyID;
        String mainOrgID = this.reqStorage == null ? null : this.reqStorage.getId().toString();
        String string = reqCompanyID = this.reqCompany == null ? null : this.reqCompany.getId().toString();
        if (this.fetchData.getMapParamValue().get(mainOrgID + "INM007") == null) {
            EntityViewInfo evi = SupplyRelationClientUtils.getStorageOrgUnitViewBySupplyRelation(mainOrgID, null, new String[]{mainOrgID}, new String[]{reqCompanyID}, new BizRoleTypeEnum[]{BizRoleTypeEnum.RequireSide}, BizRoleTypeEnum.SupplySide, "stockReq_new");
            if (evi == null) {
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("id", (Object)"NotExist"));
                EntityViewInfo nullView = new EntityViewInfo();
                nullView.setFilter(filter);
                this.prmtSupplyStorage.setEntityViewInfo(nullView);
            } else {
                this.prmtSupplyStorage.setEntityViewInfo(evi);
            }
        } else {
            String param = this.fetchData.getMapParamValue().get(mainOrgID + "INM007").toString();
            Map authOrg = this.fetchData.getFetchAuthorg();
            EntityViewInfo evi = SupplyRelationClientUtils.getStorageOrgUnitViewBySupplyRelation(mainOrgID, null, new String[]{mainOrgID}, new String[]{reqCompanyID}, new BizRoleTypeEnum[]{BizRoleTypeEnum.RequireSide}, BizRoleTypeEnum.SupplySide, "stockReq_new", null, authOrg, param);
            if (evi == null) {
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("id", (Object)"NotExist"));
                EntityViewInfo nullView = new EntityViewInfo();
                nullView.setFilter(filter);
                this.prmtSupplyStorage.setEntityViewInfo(nullView);
            } else {
                this.prmtSupplyStorage.setEntityViewInfo(evi);
            }
        }
        if (this.isBotpBill()) {
            EntityViewInfo ev = this.prmtSupplyStorage.getEntityViewInfo();
            Set idSet = InvClientUtils.getStoragesIDSet(this.reqCompany);
            IRow row = null;
            int rowCount = this.kdtEntry.getRowCount();
            for (int i = 0; i < rowCount; ++i) {
                row = this.kdtEntry.getRow(i);
                CompanyOrgUnitInfo couInfo = (CompanyOrgUnitInfo)row.getCell(TB_RECEIVECOMPANY).getValue();
                idSet.addAll(InvClientUtils.getStoragesIDSet(couInfo));
            }
            FilterInfo filterInfo = ev.getFilter();
            if (idSet.size() > 0) {
                filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.NOTINCLUDE));
            }
            this.prmtSupplyStorage.setEntityViewInfo(ev);
        }
        this.prmtSupplyStorage.getQueryAgent().resetRuntimeEntityView();
    }

    @Override
    public IUIActionPostman prepareInit() {
        IUIActionPostman handler = super.prepareInit();
        if (handler != null) {
            RequestContext request = new RequestContext();
            this.prepareHandlerParam(request);
            request.setClassName(this.getUIHandlerClassName());
            handler.setRequestContext((Serializable)request);
        }
        return handler;
    }

    @Override
    public boolean isPrepareActionSubmit() {
        return false;
    }

    @Override
    public RequestContext prepareActionSubmit(IItemAction itemAction) throws Exception {
        RequestContext request = super.prepareActionSubmit(itemAction);
        this.prepareHandlerParam(request);
        return request;
    }

    protected void prepareHandlerParam(RequestContext request) {
        request.put("_SCMMAINORG", (Object)((StorageOrgUnitInfo)this.getDefaultMainBizOrg()));
        request.put("DEFAULT_BIZ_TYPE_ID", (Object)"P6/avnd3QEeGPCqlUsZnjyQHQ1w=");
        request.put("CURRENT_USER_ID", (Object)SysContext.getSysContext().getCurrentUserInfo());
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.menuItemQuickAddLine.setIcon(EASResource.getIcon((String)"imgTbtn_newaccountlist"));
        this.btnQuickAdd.setIcon(EASResource.getIcon((String)"imgTbtn_newaccountlist"));
        this.actionDiscard.setEnabled(true);
        this.actionDiscard.setVisible(true);
    }

    protected String getMaterialName() {
        return TB_MATERIAL;
    }

    protected String getQtyName() {
        return TB_QTY;
    }

    protected String getBaseQtyName() {
        return TB_BASEQTY;
    }

    protected String getUnitName() {
        return TB_UNIT;
    }

    protected void initSCMBizDataVO(SCMBizDataVO vo) {
        if (this.isFirstLoading()) {
            vo.setOptionConfigNames(new String[]{"AssistForNumber", "NumberForAssist"});
            vo.setUiClassName(this.getMetaDataPK().getFullName());
        }
        if (this.isFirstLoading() && vo != null && vo.getOptionConfigNames() != null && vo.getOptionConfigNames().length > 0) {
            String[] optionConfigNames = vo.getOptionConfigNames();
            boolean isContainBatchCarryWarehouseLocation = false;
            int len = optionConfigNames.length;
            for (int i = 0; i < len; ++i) {
                if (!"batchCarryWarehouseLocation".equals(optionConfigNames[i])) continue;
                isContainBatchCarryWarehouseLocation = true;
                break;
            }
            if (!isContainBatchCarryWarehouseLocation) {
                String[] newParams = new String[optionConfigNames.length + 1];
                System.arraycopy(optionConfigNames, 0, newParams, 0, optionConfigNames.length);
                newParams[optionConfigNames.length] = "batchCarryWarehouseLocation";
                vo.setOptionConfigNames(newParams);
            }
        }
        super.initSCMBizDataVO(vo);
    }

    protected void setLotAndAssistProperty(ArrayList alResult) {
        int selectRow = this.getDetailTable().getSelectManager().getActiveRowIndex();
        int size = alResult.size();
        for (int i = 0; i < size; ++i) {
            HashMap hmResult;
            if (i == 0) {
                hmResult = (HashMap)alResult.get(0);
                this.setLotAndAssistProperty(hmResult, selectRow);
                continue;
            }
            this.addLine(this.getDetailTable(), selectRow, selectRow + i);
            hmResult = (HashMap)alResult.get(i);
            this.setLotAndAssistProperty(hmResult, selectRow + i);
        }
    }

    protected void addLine(KDTable table, int selectRow, int rowIndex) {
        if (table == null) {
            return;
        }
        IObjectValue detailData = this.createNewDetailData(table);
        IObjectValue copyData = (IObjectValue)table.getRow(selectRow).getUserObject();
        detailData.putAll(copyData);
        detailData.put(TB_QTY, null);
        detailData.put("id", null);
        if (detailData != null) {
            IRow row = table.addRow(rowIndex);
            this.getUILifeCycleHandler().fireOnAddNewLine((Object)table, detailData);
            this.loadLineFields(table, row, detailData);
            this.afterAddLine(table, detailData);
        }
    }

    protected void setLotAndAssistProperty(HashMap hmResult, int selectRow) {
        if ("ADDNEW".equals(this.getOprtState()) || "EDIT".equals(this.getOprtState())) {
            this.setAdditionalProperty(selectRow, hmResult);
        }
    }

    private void setAdditionalProperty(int selectRow, HashMap hmResult) {
        MaterialInfo materialInfo = (MaterialInfo)hmResult.get(TB_MATERIAL);
        int colMaterial = this.getDetailTable().getColumnIndex(this.getMaterialName());
        if (materialInfo != null) {
            this.getDetailTable().getCell(selectRow, colMaterial).setValue((Object)materialInfo);
            try {
                this.materialChanged(selectRow, materialInfo);
                this.setColumnProperty(materialInfo, selectRow, colMaterial, false);
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        }
        int colQty = this.getDetailTable().getColumnIndex(this.getQtyName());
        int colUnit = this.getDetailTable().getColumnIndex(this.getUnitName());
        MeasureUnitInfo unitInfo = (MeasureUnitInfo)hmResult.get(TB_UNIT);
        if (colUnit > -1 && unitInfo != null) {
            this.getDetailTable().getRow(selectRow).getCell(colUnit).setValue((Object)unitInfo);
        }
        ICell muBaseCell = this.getDetailTable().getRow(selectRow).getCell(TB_UNIT);
        ICell aMaterialCell = this.getDetailTable().getRow(selectRow).getCell(TB_MATERIAL);
        MeasureUnitInfo muBase = null;
        if (muBaseCell != null) {
            muBase = (MeasureUnitInfo)muBaseCell.getValue();
        }
        MaterialInfo aMaterialInfo = null;
        if (aMaterialCell != null) {
            aMaterialInfo = (MaterialInfo)aMaterialCell.getValue();
        }
        if (hmResult.get("asstAttrValue") != null) {
            this.getDetailTable().getRow(selectRow).getCell(TB_ASSISTPROPERTY).setValue(hmResult.get("asstAttrValue"));
        }
        try {
            BigDecimal qty = (BigDecimal)hmResult.get("fqty");
            if (qty != null && colQty > -1 && qty.compareTo(SysConstant.BIGZERO) > 0 && muBase != null && aMaterialInfo != null && (this.getDetailTable().getRow(selectRow).getCell(colQty).getValue() == null || ((BigDecimal)this.getDetailTable().getRow(selectRow).getCell(colQty).getValue()).compareTo(SysConstant.BIGZERO) == 0)) {
                qty = InvClientUtils.getUnitQty(muBase, aMaterialInfo, (BigDecimal)hmResult.get("fBaseQty"));
                this.getDetailTable().getRow(selectRow).getCell(colQty).setValue((Object)qty);
                this.getDetailTable().getRow(selectRow).getCell(TB_AUDITQTY).setValue((Object)qty);
                if (this.getUnitName() != null && this.getDetailTable().getCell(selectRow, this.getUnitName()).getValue() != null) {
                    MeasureUnitInfo unit = (MeasureUnitInfo)this.getDetailTable().getCell(selectRow, this.getUnitName()).getValue();
                    BigDecimal baseQty = InvClientUtils.ZERO;
                    baseQty = InvClientUtils.getConvsBaseQty(qty, this.fetchData.getUnitbaseConvsRate(aMaterialInfo.getId().toString(), unit.getId().toString()), this.fetchData.getUnitPrecision(aMaterialInfo.getId().toString(), aMaterialInfo.getBaseUnit().getId().toString()));
                    if (this.getBaseQtyName() != null && this.getDetailTable().getCell(selectRow, this.getBaseQtyName()).getValue() != null) {
                        this.getDetailTable().getCell(selectRow, this.getBaseQtyName()).setValue((Object)baseQty);
                        this.getDetailTable().getRow(selectRow).getCell(TB_AUDITBASEQTY).setValue((Object)baseQty);
                    }
                }
                int colAssistQty = this.getDetailTable().getColumnIndex(this.getAssistQtyName());
                BigDecimal fAssitQty = (BigDecimal)hmResult.get("fAssitQty");
                if (fAssitQty != null && colAssistQty > -1) {
                    this.getDetailTable().getCell(selectRow, colAssistQty).setValue((Object)fAssitQty);
                }
            }
            int colProject = this.getDetailTable().getColumnIndex(TB_PROJECTNUM);
            ProjectInfo projectInfo = (ProjectInfo)hmResult.get("project");
            if (projectInfo != null && colProject > -1 && this.getDetailTable().getRow(selectRow).getCell(colProject).getValue() == null) {
                this.getDetailTable().getRow(selectRow).getCell(colProject).setValue((Object)projectInfo);
            }
            int colTrackNum = this.getDetailTable().getColumnIndex(TB_TRACKNUM);
            TrackNumberInfo trackNumInfo = (TrackNumberInfo)hmResult.get("trackNum");
            if (trackNumInfo != null && colTrackNum > -1 && this.getDetailTable().getRow(selectRow).getCell(colTrackNum).getValue() == null) {
                this.getDetailTable().getRow(selectRow).getCell(colTrackNum).setValue((Object)trackNumInfo);
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
    }

    public boolean destroyWindow() {
        return super.destroyWindow();
    }

    protected void setTableToSumField() {
        this.setTableToSumField(this.getDetailTable(), this.getSumColNames());
    }

    protected String[] getSumColNames() {
        return new String[]{TB_QTY, TB_BASEQTY, TB_AUDITQTY, TB_AUDITBASEQTY, TB_ASSISTQTY, TB_APPROVEDASSITQTY, TB_TOTALSTOCKQTY, TB_TOTALSTOCKBASEQTY, TB_ASSOCIATEQTY};
    }

    protected boolean isNeedSepcialParam() {
        return true;
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddNew_actionPerformed(e);
        this.initControlNew();
    }

    public void actionCopy_actionPerformed(ActionEvent e) throws Exception {
        super.actionCopy_actionPerformed(e);
        this.editData.setBillType(SCMClientUtils.getBillType((String)"MmEE6VBsR0KaUDQmebwhP0Y+1VI="));
        IRow row = null;
        StorageOrgUnitInfo storage = null;
        MaterialInfo material = null;
        int size = this.getDetailTable().getRowCount();
        for (int i = 0; i < size; ++i) {
            row = this.getDetailTable().getRow(i);
            if (row.getCell(TB_MATERIAL).getValue() == null || row.getCell(TB_RECEIVESTORAGE).getValue() == null) continue;
            material = (MaterialInfo)row.getCell(TB_MATERIAL).getValue();
            storage = (StorageOrgUnitInfo)row.getCell(TB_RECEIVESTORAGE).getValue();
            this.isUseWarehsRelation = InvClientUtils.isUseWarehsRelation(storage.getId().toString());
            if (this.isUseWarehsRelation) {
                InvClientUtils.setWarehouseFitlerByMSRelation(storage, material, this.getDetailTable(), i, TB_RECEIVEWAREHOUSE, -1);
                continue;
            }
            InvClientUtils.setWarehouseFitler(storage, this.getDetailTable(), TB_RECEIVEWAREHOUSE, -1);
        }
    }

    private void initControlNew() throws EASBizException, BOSException, Exception {
        this.prmtReqStorage.setEditable(true);
        this.prmtReqStorage.setEnabled(true);
        this.prmtReqStorage.setReadOnly(false);
    }

    protected String getApproQtyName() {
        return TB_AUDITQTY;
    }

    protected String getApproAssistQtyName() {
        return TB_ASSISTQTY;
    }

    protected String getAssistQtyName() {
        return TB_APPROVEDASSITQTY;
    }

    protected String getApproBaseQtyName() {
        return TB_AUDITBASEQTY;
    }

    protected void initFetchData() throws Exception {
        SCMFetchDataCondition condition = this.buildCondition();
        if (condition == null) {
            return;
        }
        HashMap<String, SCMFetchDataCondition> initFetchPara = new HashMap<String, SCMFetchDataCondition>();
        initFetchPara.put("Condition", condition);
        SCMFetchData newFetchData = SCMFetchDataFacadeFactory.getRemoteInstance().fetchData(new InvBizDataVO(condition.toEntiryView(), initFetchPara));
        this.fetchData.put(newFetchData);
    }

    public boolean isSupportedBatchActions() {
        return true;
    }

    protected void initBatchActions() throws BOSException {
        this.actionManager.setClzIBizFactory(ActionLevelEnum.HEAD, StockReqFactory.class);
        this.actionManager.setClzIBizFactory(ActionLevelEnum.ENTRY, StockReqEntryFactory.class);
        this.getTableSelectionHelper().setTableProperty((ISupportBatchAction)this, this.getDetailTable(), "id", this.txtNumber, null);
        super.initBatchActions();
    }

    public boolean beforeAction(BatchActionEnum bizAction, BatchSelectionEntries selectionEntries, ActionEvent event) {
        return super.beforeAction(bizAction, selectionEntries, event);
    }

    protected boolean isSupportF12() {
        return true;
    }

    protected HashMap getMaterialQueryConditions() {
        KDTSelectBlock selectBlock;
        HashMap<String, Object> conditions = new HashMap<String, Object>();
        StorageOrgUnitInfo sou = (StorageOrgUnitInfo)this.prmtReqStorage.getData();
        if (sou != null) {
            conditions.put("STORAGEORGUNIT", sou);
        }
        if ((selectBlock = this.kdtEntry.getSelectManager().get()) != null) {
            int rowIndex = selectBlock.getTop();
            IRow row = this.kdtEntry.getRow(rowIndex);
            if (row == null) {
                return conditions;
            }
            ICell cell = row.getCell(TB_MATERIAL);
            MaterialInfo material = (MaterialInfo)cell.getValue();
            conditions.put("MATERIAL", material);
        }
        return conditions;
    }

    protected void afterQueryByMaterial(int rowIndex, int rowCount) throws Exception {
        super.afterQueryByMaterial(rowIndex, rowCount);
        int colQty = -1;
        if (this.getDetailTable().getColumn(this.getQtyName()) != null) {
            colQty = this.getDetailTable().getColumn(this.getQtyName()).getColumnIndex();
        }
        for (int i = 0; i < rowCount; ++i) {
            if (colQty <= -1) continue;
            Object qty = this.getDetailTable().getRow(rowIndex + i).getCell(colQty).getValue();
            this.setKDTEditListener(null, qty, rowIndex + i, colQty);
        }
    }

    protected UIContext getInvF7UIContext() throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        StorageOrgUnitInfo sou = (StorageOrgUnitInfo)this.prmtSupplyStorage.getValue();
        if (sou != null) {
            uiContext.put((Object)"storageOrgID", (Object)sou.getId().toString());
        } else {
            String strTemp = InvClientUtils.getResource("StorageOrgUnitNotNull");
            MsgBox.showInfo((String)strTemp);
            this.abort();
        }
        return uiContext;
    }

    protected void afterInventoryF7Query(int rowIndex, int rowCount) throws Exception {
        super.afterInventoryF7Query(rowIndex, rowCount);
        int colQty = -1;
        if (this.getDetailTable().getColumn(this.getQtyName()) != null) {
            colQty = this.getDetailTable().getColumn(this.getQtyName()).getColumnIndex();
        }
        for (int i = 0; i < rowCount; ++i) {
            if (colQty <= -1) continue;
            Object qty = this.getDetailTable().getRow(rowIndex + i).getCell(colQty).getValue();
            this.setKDTEditListener(null, qty, rowIndex + i, colQty);
        }
    }

    protected void afterMainOrgChanged(String arg0, String arg1) {
        super.afterMainOrgChanged(arg0, arg1);
        StorageOrgUnitInfo sou = this.editData.getReqStorage();
        PurchaseOrgUnitInfo purchaseInfo = this.fetchData.getPurchaseOrgUnitInfo();
        if (purchaseInfo == null) {
            try {
                IOrgUnitRelation iUnitRel = OrgUnitRelationFactory.getRemoteInstance();
                PurchaseOrgUnitInfo aPurchaseOrgUnitInfo = (PurchaseOrgUnitInfo)iUnitRel.getDefaultToUnit(sou.getId().toString(), 4, 3);
                this.fetchData.setPurchaseOrgUnitInfo(aPurchaseOrgUnitInfo);
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
            catch (EASBizException e) {
                e.printStackTrace();
            }
        }
    }
}

