/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.commonquery.client.CustomerQueryPanel;
import com.kingdee.eas.basedata.framework.util.KDTableUtil;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.TransportOrgUnitInfo;
import com.kingdee.eas.basedata.scm.common.ReasonCodeInfo;
import com.kingdee.eas.basedata.scm.common.client.ReasonF7Until;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.framework.FrameWorkException;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.batchaction.ActionLevelEnum;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.framework.client.CoreBillListUI;
import com.kingdee.eas.framework.query.QuickFilteringSupportItems;
import com.kingdee.eas.scm.common.SCMBillBaseInfo;
import com.kingdee.eas.scm.common.SCMBillEntryBaseInfo;
import com.kingdee.eas.scm.common.action.ActionProxy;
import com.kingdee.eas.scm.common.action.ActionProxyFactory;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.util.PrecisionUtil;
import com.kingdee.eas.scm.common.util.ResourceUtils;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.im.dt.util.DtUtils;
import com.kingdee.eas.scm.im.inv.IStockTransferBill;
import com.kingdee.eas.scm.im.inv.IStockTransferBillEntry;
import com.kingdee.eas.scm.im.inv.InvBizException;
import com.kingdee.eas.scm.im.inv.StockTransferBillEntryCollection;
import com.kingdee.eas.scm.im.inv.StockTransferBillEntryFactory;
import com.kingdee.eas.scm.im.inv.StockTransferBillFactory;
import com.kingdee.eas.scm.im.inv.client.AbstractStockTransferBillListUI;
import com.kingdee.eas.scm.im.inv.client.InvClientUtils;
import com.kingdee.eas.scm.im.inv.client.StockTransferFilterUI;
import com.kingdee.eas.scm.util.SCMSelectorFactory;
import com.kingdee.eas.tools.datatask.DatataskParameter;
import com.kingdee.eas.tools.datatask.client.DatataskCaller;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;

public class StockTransferBillListUI
extends AbstractStockTransferBillListUI {
    private static final long serialVersionUID = -2677770189002624449L;
    private static final String TB_ID = "id";
    private static final String TB_ENRYID = "entry.id";
    private boolean isViewInventory = false;
    private boolean isCreateFromPurInWhs = false;
    StockTransferFilterUI filterUI = null;
    private QuickFilteringSupportItems qfsi = new QuickFilteringSupportItems(true, true);

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        InvClientUtils.setFreezeCol(this.tblMain, "baseStatus");
        this.btnClose.setIcon(EASResource.getIcon((String)"imgTbtn_close"));
        this.tblMain.getColumn("amount").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.menuItemMultiapprove.setVisible(false);
        this.btnMultiapprove.setVisible(false);
        this.actionAudit.setEnabled(true);
        this.tblMain.getColumn("invQty").getStyleAttributes().setHided(true);
        this.tblMain.getColumn("invQty").setWidth(-1);
        this.btnVoucher.setVisible(false);
        this.btnDelVoucher.setVisible(false);
        this.btnAuditResult.setVisible(false);
        this.tblMain.getColumn("creatTime").setEditor((ICellEditor)new KDTDefaultCellEditor(new KDDatePicker()));
        this.tblMain.getColumn("creatTime").getStyleAttributes().setNumberFormat(SCMClientUtils.strTimeFormat);
        this.tblMain.getColumn("modifyTime").setEditor((ICellEditor)new KDTDefaultCellEditor(new KDDatePicker()));
        this.tblMain.getColumn("modifyTime").getStyleAttributes().setNumberFormat(SCMClientUtils.strTimeFormat);
        this.tblMain.getColumn("auditTime").setEditor((ICellEditor)new KDTDefaultCellEditor(new KDDatePicker()));
        this.tblMain.getColumn("auditTime").getStyleAttributes().setNumberFormat(SCMClientUtils.strTimeFormat);
        this.tblMain.getColumn("moveInPlanDate").setEditor((ICellEditor)new KDTDefaultCellEditor(new KDDatePicker()));
        this.tblMain.getColumn("moveInPlanDate").getStyleAttributes().setNumberFormat(SCMClientUtils.strDateFormat);
        this.tblMain.getColumn("issuePlanDate").setEditor((ICellEditor)new KDTDefaultCellEditor(new KDDatePicker()));
        this.tblMain.getColumn("issuePlanDate").getStyleAttributes().setNumberFormat(SCMClientUtils.strDateFormat);
        this.tblMain.getColumn("quarityOverRate").getStyleAttributes().setNumberFormat(PrecisionUtil.getFormatString((int)2));
        this.tblMain.getColumn("quarityArreRate").getStyleAttributes().setNumberFormat(PrecisionUtil.getFormatString((int)2));
        this.tblMain.getColumn("quarityOverRate").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblMain.getColumn("quarityArreRate").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.menuItemImportData.setVisible(true);
        this.menuItemExportData.setVisible(true);
    }

    protected boolean initDefaultFilter() {
        return true;
    }

    @Override
    protected String getEditUIName() {
        return "com.kingdee.eas.scm.im.inv.client.StockTransferBillEditUI";
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return StockTransferBillFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext());
    }

    public String[] getMergeColumnKeys() {
        String[] strMergeColKeys = new String[]{TB_ID, "number", "baseStatus", "bizType", "bizdate", "moveOutStorageOrgUnit", "storageOrgUnit", "moveOutDepartment", "moveInDepartment", "isInitBill", "creator", "creatTime", "modifier", "modifyTime", "auditor", "auditTime", "processNode", "version"};
        return strMergeColKeys;
    }

    protected String[] getQtyColumns() throws Exception {
        return new String[]{"qty", "baseQty", "assistantQty", "totalMoveOutQty", "totalMoveInQty", "entry.planDeliveryQty"};
    }

    protected String[] getPriceColumns() throws Exception {
        return new String[]{"unitPrice"};
    }

    public String[] getAmountColumns() {
        return new String[]{"amount"};
    }

    protected void getRowSetBeforeFillTable(IRowSet rowSet) {
        int amountPre = 2;
        String[] QTY_COLUMNS = new String[]{"entry.qty", "entry.issueQty", "entry.receiptQty", "entry.baseQty", "entry.assistQty"};
        String[] PRICE_COLUMNS = new String[]{"entry.price"};
        String[] amount = new String[]{"entry.amount"};
        try {
            rowSet.beforeFirst();
            Map colMap = SCMClientUtils.getColumnsByRowSet((IRowSet)rowSet);
            while (rowSet.next()) {
                amountPre = rowSet.getInt("baseCurrency.precision");
                SCMClientUtils.iniColumnsPrecision((int)this.qtyPrecision, (String[])QTY_COLUMNS, (IRowSet)rowSet, (Map)colMap);
                SCMClientUtils.iniColumnsPrecision((int)this.pricePrecision, (String[])PRICE_COLUMNS, (IRowSet)rowSet, (Map)colMap);
                SCMClientUtils.iniColumnsPrecision((int)amountPre, (String[])amount, (IRowSet)rowSet, (Map)colMap);
            }
        }
        catch (SQLException ex) {
            this.handUIException(ex);
        }
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("baseCurrency.precision"));
        return sic;
    }

    protected boolean isSupportDynQuery() {
        return true;
    }

    @Override
    public SelectorItemCollection getBOTPSelectors() {
        SelectorItemCollection sic = super.getBOTPSelectors();
        sic.addObjectCollection((IObjectCollection)SCMSelectorFactory.getSCMBillBaseSelector((boolean)true));
        sic.add(new SelectorItemInfo("exchangeRate"));
        sic.add(new SelectorItemInfo("isShipment"));
        sic.add(new SelectorItemInfo("isInitBill"));
        sic.add(new SelectorItemInfo("isInTax"));
        sic.add(new SelectorItemInfo("currency.id"));
        sic.add(new SelectorItemInfo("currency.number"));
        sic.add(new SelectorItemInfo("currency.name"));
        sic.add(new SelectorItemInfo("receiptStorageOrgUnit.id"));
        sic.add(new SelectorItemInfo("receiptStorageOrgUnit.number"));
        sic.add(new SelectorItemInfo("receiptStorageOrgUnit.name"));
        sic.add(new SelectorItemInfo("issueStorageOrgUnit.id"));
        sic.add(new SelectorItemInfo("issueStorageOrgUnit.number"));
        sic.add(new SelectorItemInfo("issueStorageOrgUnit.name"));
        sic.add(new SelectorItemInfo("receiptCompanyOrgUnit.id"));
        sic.add(new SelectorItemInfo("receiptCompanyOrgUnit.number"));
        sic.add(new SelectorItemInfo("receiptCompanyOrgUnit.name"));
        sic.add(new SelectorItemInfo("issueCompanyOrgUnit.id"));
        sic.add(new SelectorItemInfo("issueCompanyOrgUnit.number"));
        sic.add(new SelectorItemInfo("issueCompanyOrgUnit.name"));
        sic.add(new SelectorItemInfo("issueAdminOrgUnit.id"));
        sic.add(new SelectorItemInfo("issueAdminOrgUnit.number"));
        sic.add(new SelectorItemInfo("issueAdminOrgUnit.name"));
        sic.add(new SelectorItemInfo("receiptAdminOrgUnit.id"));
        sic.add(new SelectorItemInfo("receiptAdminOrgUnit.number"));
        sic.add(new SelectorItemInfo("receiptAdminOrgUnit.name"));
        sic.add(new SelectorItemInfo("entry.issueWarehouse.id"));
        sic.add(new SelectorItemInfo("entry.issueWarehouse.number"));
        sic.add(new SelectorItemInfo("entry.issueWarehouse.name"));
        sic.add(new SelectorItemInfo("entry.issueWarehouse.hasLocation"));
        sic.add(new SelectorItemInfo("entry.issueWarehouse.whman.id"));
        sic.add(new SelectorItemInfo("entry.issueWarehouse.whman.name"));
        sic.add(new SelectorItemInfo("entry.issueWarehouse.whman.number"));
        sic.add(new SelectorItemInfo("entry.receiptWarehouse.id"));
        sic.add(new SelectorItemInfo("entry.receiptWarehouse.number"));
        sic.add(new SelectorItemInfo("entry.receiptWarehouse.name"));
        sic.add(new SelectorItemInfo("entry.receiptWarehouse.hasLocation"));
        sic.add(new SelectorItemInfo("entry.receiptWarehouse.whman.id"));
        sic.add(new SelectorItemInfo("entry.receiptWarehouse.whman.name"));
        sic.add(new SelectorItemInfo("entry.receiptWarehouse.whman.number"));
        sic.add(new SelectorItemInfo("entry.receiptLocation.id"));
        sic.add(new SelectorItemInfo("entry.receiptLocation.name"));
        sic.add(new SelectorItemInfo("entry.receiptLocation.number"));
        sic.add(new SelectorItemInfo("entry.issueLocation.id"));
        sic.add(new SelectorItemInfo("entry.issueLocation.name"));
        sic.add(new SelectorItemInfo("entry.issueLocation.number"));
        sic.add(new SelectorItemInfo("entry.qty"));
        sic.add(new SelectorItemInfo("entry.lot"));
        sic.add(new SelectorItemInfo("entry.assistProperty.id"));
        sic.add(new SelectorItemInfo("entry.assistProperty.name"));
        sic.add(new SelectorItemInfo("entry.assistProperty.number"));
        sic.add(new SelectorItemInfo("entry.assistQty"));
        sic.add(new SelectorItemInfo("entry.price"));
        sic.add(new SelectorItemInfo("entry.issueQty"));
        sic.add(new SelectorItemInfo("entry.receiptQty"));
        sic.add(new SelectorItemInfo("entry.associateQty"));
        return sic;
    }

    @Override
    public void actionClose_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String[] selIDs = this.getBillEntryIDs();
        String[] billIDs = KDTableUtil.getSelectRowFieldValue((KDTable)this.tblMain, (String)TB_ID);
        if (billIDs == null && selIDs == null) {
            this.handleException((Exception)((Object)new InvBizException(InvBizException.MUST_SELECT_ENTRY)));
            return;
        }
        IObjectCollection entryCol = null;
        IStockTransferBillEntry entry = StockTransferBillEntryFactory.getRemoteInstance();
        IObjectPK[] pks = SCMUtils.convertStringToObjectPK((String[])selIDs);
        boolean refresh = true;
        String errorMsg = null;
        try {
            Object reasonCodeInfo = ReasonF7Until.getReason((IUIWindow)ReasonF7Until.showClosedReasonUI((Map)this.getUIContext(), (IUIWindow)this.getUIWindow()));
            if (reasonCodeInfo == null) {
                SysUtil.abort();
            } else {
                String reason = null;
                if (reasonCodeInfo instanceof IObjectValue) {
                    reason = ((ReasonCodeInfo)reasonCodeInfo).getName(this.currentLocale);
                } else if (reasonCodeInfo instanceof String && (reason = (String)reasonCodeInfo).length() > 80) {
                    reason = reason.substring(0, 80);
                }
                entryCol = billIDs.length == 1 ? entry.handleCloseOneBill(pks, reason) : entry.handleClose(pks, reason);
                if (entryCol.size() > 0) {
                    errorMsg = this.getErrorMsg(entryCol, "ERROR_NOT_AUDITED_CAN_CLOSE");
                    if (entryCol.size() == pks.length) {
                        refresh = false;
                    }
                    throw new InvBizException(InvBizException.CLOSE_ERROR, new Object[]{new Integer(pks.length), new Integer(entryCol.size()), ""});
                }
                this.showSuccessMsg("CLOSE_SUCCESS");
            }
        }
        catch (InvBizException exp) {
            MsgBox.showDetailAndOK(null, (String)exp.getLocalizedMessage(), errorMsg, (int)8188);
        }
        catch (EASBizException ex) {
            this.handleException((Exception)((Object)ex));
        }
        if (refresh) {
            this.actionRefresh_actionPerformed(null);
        }
    }

    private String getErrorMsg(IObjectCollection entryCol, String resName) {
        if (entryCol.size() > 0) {
            String msg = InvClientUtils.getResource(resName);
            String tab = "\t";
            StringBuffer errorMsg = new StringBuffer(InvClientUtils.getResource("BILL_NUMBER"));
            errorMsg.append(tab).append(InvClientUtils.getResource("ENTRY_SEQ"));
            errorMsg.append(tab).append(InvClientUtils.getResource("FAILURE_REASION")).append("\n");
            int size = entryCol.size();
            for (int i = 0; i < size; ++i) {
                SCMBillEntryBaseInfo entryInfo = (SCMBillEntryBaseInfo)entryCol.getObject(i);
                errorMsg.append(((SCMBillBaseInfo)entryInfo.get("parent")).getNumber()).append(tab);
                errorMsg.append(entryInfo.getSeq()).append(tab);
                errorMsg.append(msg).append("\n");
            }
            return errorMsg.toString();
        }
        return null;
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.menuItemClose.setIcon(EASResource.getIcon((String)"imgTbtn_close"));
        this.menuItemUnClose.setIcon(EASResource.getIcon((String)"imgTbtn_fclose"));
        this.btnUnClose.setIcon(EASResource.getIcon((String)"imgTbtn_fclose"));
        this.btnViewInventory.setVisible(false);
        this.menuItemViewInventory.setVisible(false);
        this.actionViewInventory.setEnabled(false);
        this.actionDiscard.setEnabled(true);
        this.actionDiscard.setVisible(true);
        this.btnAutoTransfer.setIcon(EASResource.getIcon((String)"imgTbtn_autocreate"));
        this.btnAlter.setIcon(EASResource.getIcon((String)"imgTbtn_assetchangeinfo"));
        this.btnAlter.setEnabled(true);
        this.menuItemViewVersion.setIcon(EASResource.getIcon((String)"imgTable_task"));
        this.menuItemViewVersion.setEnabled(true);
    }

    protected CustomerQueryPanel getFilterUI() throws Exception {
        if (this.filterUI == null) {
            this.filterUI = new StockTransferFilterUI();
        }
        return this.filterUI;
    }

    @Override
    protected String getPropertyOfBizOrg(OrgType orgType) {
        if (OrgType.Transport.equals((Object)orgType)) {
            return null;
        }
        if (this.isCreateFromPurInWhs) {
            this.isCreateFromPurInWhs = false;
            return "moveInStorageOrgUnit.id";
        }
        return "moveOutStorageOrgUnit.id";
    }

    protected FilterInfo getBOTPFilterByBillType(String BillTypeId, OrgType destType, String destOrgId) {
        String billTypeId;
        HashMap botpMap;
        if ("50957179-0105-1000-e000-015fc0a812fd463ED552".equals(BillTypeId) || "50957179-0105-1000-e000-0172c0a812fd463ED552".equals(BillTypeId)) {
            this.isCreateFromPurInWhs = true;
        }
        FilterInfo filter = null;
        if (this.getBOTPViewStatus() == 1 && (botpMap = this.getBOTPMap()) != null && botpMap.containsKey("DESTBILLTYPE.ID") && "18b7FpLNSrmaD8V9SPcOhkY+1VI=".equals(billTypeId = botpMap.get("DESTBILLTYPE.ID").toString())) {
            OrgUnitInfo org = (OrgUnitInfo)botpMap.get("MAINBIZORG");
            TransportOrgUnitInfo transport = new TransportOrgUnitInfo();
            transport.setId(org.getId());
            OrgUnitCollection sous = DtUtils.getStorageCollection(null, transport);
            LinkedHashSet<String> souIDs = new LinkedHashSet<String>();
            for (int i = 0; i < sous.size(); ++i) {
                souIDs.add(sous.get(i).getId().toString());
            }
            filter = new FilterInfo();
            if (souIDs != null && souIDs.size() > 0) {
                filter.getFilterItems().add(new FilterItemInfo("issueStorageOrgUnit.id", souIDs, CompareType.INCLUDE));
            } else {
                filter.getFilterItems().add(new FilterItemInfo(TB_ID, (Object)"NotExist"));
            }
        }
        return filter;
    }

    @Override
    public boolean isSupportedBatchActions() {
        return true;
    }

    @Override
    public void initBatchActions() throws BOSException {
        this.actionManager.setClzIBizFactory(ActionLevelEnum.HEAD, StockTransferBillFactory.class);
        this.actionManager.setClzIBizFactory(ActionLevelEnum.ENTRY, StockTransferBillEntryFactory.class);
        this.getTableSelectionHelper().setTableProperty((CoreBillListUI)this, this.mainQueryPK, this.tblMain, TB_ID, TB_ENRYID, "number", "entry.seq", "issueStorageOrgUnit.id");
        ActionProxy actionProxy = ActionProxyFactory.createActionProxy((BatchActionEnum)BatchActionEnum.TRANSFORM, (ItemAction)this.actionAutoTransfer, (String)"autoTransfer");
        this.actionManager.registerBatchAction(actionProxy, "actionAutoTransfer");
        actionProxy.bindTo((AbstractButton)this.btnAutoTransfer);
        super.initBatchActions();
    }

    public void actionMultiPrint_actionPerformed(ActionEvent arg0) throws Exception {
        super.actionMultiPrint_actionPerformed(arg0);
    }

    public void actionMultiPrintPreview_actionPerformed(ActionEvent arg0) throws Exception {
        super.actionMultiPrintPreview_actionPerformed(arg0);
    }

    protected IMetaDataPK getTDQueryPK() {
        return MetaDataPK.create((String)"com.kingdee.eas.scm.im.inv.StockTransferPrintQuery");
    }

    protected String getTDFileName() {
        return "/SCM/IM/InvMove/StockTransferBill";
    }

    protected FilterInfo getDefaultFilterForQuery() {
        FilterInfo filterInfo = super.getDefaultFilterForQuery();
        FilterInfo newFitlerInfo = new FilterInfo();
        if (filterInfo != null) {
            newFitlerInfo.getFilterItems().add(new FilterItemInfo("bizType.number", (Object)"310", CompareType.NOTEQUALS));
            newFitlerInfo.getFilterItems().add(new FilterItemInfo("bizType.number", (Object)"370", CompareType.NOTEQUALS));
            newFitlerInfo.getFilterItems().add(new FilterItemInfo("bizType.number", (Object)"380", CompareType.NOTEQUALS));
            newFitlerInfo.getFilterItems().add(new FilterItemInfo("bizType.number", null, CompareType.EQUALS));
            newFitlerInfo.setMaskString("#0 and #1 and #2 or #3");
            try {
                filterInfo.mergeFilter(newFitlerInfo, "AND");
            }
            catch (BOSException e) {
                super.handleException((Exception)((Object)e));
            }
        }
        return filterInfo;
    }

    public List getDestBosTypeForBotp(CoreBillBaseCollection srcBillInfos, List destBosTypeList) {
        for (int i = destBosTypeList.size() - 1; i >= 0; --i) {
            String bosType = (String)destBosTypeList.get(i);
            if (!"8B07BBDB".equals(bosType)) continue;
            destBosTypeList.remove(i);
        }
        return super.getDestBosTypeForBotp(srcBillInfos, destBosTypeList);
    }

    public List getDestBosTypeForBotpByID(String[] srcIdList, String[] entryNames, List entriesIDList, List destBosTypeList) {
        for (int i = destBosTypeList.size() - 1; i >= 0; --i) {
            String bosType = (String)destBosTypeList.get(i);
            if (!"8B07BBDB".equals(bosType)) continue;
            destBosTypeList.remove(i);
        }
        return super.getDestBosTypeForBotpByID(srcIdList, entryNames, entriesIDList, destBosTypeList);
    }

    @Override
    protected OrgType getMainBizOrgType() {
        return OrgType.Storage;
    }

    @Override
    public void actionViewInventory_actionPerformed(ActionEvent e) throws Exception {
        this.isViewInventory = !this.isViewInventory;
        this.tblMain.getColumn("invQty").getStyleAttributes().setHided(!this.isViewInventory);
        this.tblMain.getColumn("creator").getStyleAttributes().setHided(!this.tblMain.getColumn("invQty").getStyleAttributes().isHided());
        this.tblMain.getColumn("modifier").getStyleAttributes().setHided(!this.tblMain.getColumn("invQty").getStyleAttributes().isHided());
        this.tblMain.getColumn("auditor").getStyleAttributes().setHided(!this.tblMain.getColumn("invQty").getStyleAttributes().isHided());
        this.refreshList();
    }

    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        this.isViewInventory = false;
        super.actionQuery_actionPerformed(e);
        this.tblMain.getColumn("invQty").getStyleAttributes().setHided(true);
    }

    @Override
    public void actionUnClose_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        super.actionUnClose_actionPerformed(e);
        String[] ids = KDTableUtil.getSelectRowFieldValue((KDTable)this.tblMain, (String)TB_ID);
        String[] entryIDs = this.getBillEntryIDs();
        boolean refresh = true;
        if (ids == null || entryIDs == null) {
            return;
        }
        ArrayList<String> idList = new ArrayList<String>();
        for (int i = 0; i < ids.length; ++i) {
            idList.add(ids[i]);
        }
        ArrayList<String> entryIDList = new ArrayList<String>();
        for (int i = 0; i < entryIDs.length; ++i) {
            entryIDList.add(entryIDs[i]);
        }
        IStockTransferBillEntry isre = StockTransferBillEntryFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext());
        StockTransferBillEntryCollection entryCol = isre.handleUnClose(entryIDList, idList);
        String errorMsg = null;
        try {
            if (entryCol.size() > 0) {
                errorMsg = this.getErrorMsg((IObjectCollection)entryCol, "ERROR_NOT_CLOSED_CAN_UNCLOSE");
                if (entryCol.size() == ids.length) {
                    refresh = false;
                }
                throw new InvBizException(InvBizException.UNCLOSE_ERROR, new Object[]{new Integer(ids.length), new Integer(entryCol.size()), ""});
            }
            this.showSuccessMsg("UNCLOSE_SUCCESS");
        }
        catch (InvBizException exp) {
            MsgBox.showDetailAndOK(null, (String)exp.getLocalizedMessage(), (String)errorMsg, (int)8188);
        }
        if (refresh) {
            this.refresh(null);
        }
    }

    protected void showSuccessMsg(String key) {
        this.setMessageText(InvClientUtils.getResource(key));
        this.showMessage();
    }

    protected String[] getQueryShowField() {
        return new String[]{"number", "baseStatus", "bizType", "bizdate", "moveOutStorageOrgUnit", "storageOrgUnit", "materialNum", "materialName", "model", "storeType", "unit", "qty", "moveOutWarehouse", "moveInWarehouse"};
    }

    protected boolean isLazyMode() {
        return !Boolean.TRUE.equals(this.getUIContext().get("isFromWorkflowMultiapprove"));
    }

    @Override
    public boolean isPrepareInit() {
        return true;
    }

    public String getsourceBillEntryId() {
        return "entry.sourceBillEntryId";
    }

    protected QuickFilteringSupportItems getQuickFilteringSupport() {
        return this.qfsi;
    }

    protected boolean isSupportBatchSubmitAction() {
        return true;
    }

    public void actionImportData_actionPerformed(ActionEvent e) throws Exception {
        super.actionImportData_actionPerformed(e);
    }

    protected ArrayList getImportParam() {
        String solutionName;
        DatataskParameter param = new DatataskParameter();
        param.solutionName = solutionName = "eas.30im.StockTransferBill";
        param.alias = ResourceUtils.getMessage((String)"com.kingdee.eas.scm.im.SCM_IMResource", (String)"stockTransferOrderBill");
        ArrayList<DatataskParameter> paramList = new ArrayList<DatataskParameter>();
        paramList.add(param);
        return paramList;
    }

    public void actionExportData_actionPerformed(ActionEvent e) throws Exception {
        ArrayList para = this.getExportParam();
        if (para == null || para.size() <= 0) {
            throw new FrameWorkException(FrameWorkException.EXPORTDATAPARANULL);
        }
        DatataskCaller task = new DatataskCaller();
        task.setParentComponent((Component)((Object)this));
        task.setMainOrgContext(this.getMainOrgContext());
        task.invoke(para, 1);
    }

    protected ArrayList getExportParam() {
        DatataskParameter param = new DatataskParameter();
        param.solutionName = "eas.30im.StockTransferBill";
        param.datataskMode = 1;
        param.alias = ResourceUtils.getMessage((String)"com.kingdee.eas.scm.im.SCM_IMResource", (String)"stockTransferOrderBill");
        param.varList = new ArrayList();
        Hashtable<String, FilterInfo> hashtable = new Hashtable<String, FilterInfo>();
        try {
            hashtable.put("filter", this.mainQuery.getFilter());
        }
        catch (Exception exception) {
            // empty catch block
        }
        param.setContextParam(hashtable);
        ArrayList<DatataskParameter> paramList = new ArrayList<DatataskParameter>();
        paramList.add(param);
        return paramList;
    }

    @Override
    public void actionAutoTransfer_actionPerformed(ActionEvent e) throws Exception {
    }

    @Override
    protected String getMainOrgUnitColumnKey() {
        return "issueStorageOrgUnit.id";
    }

    protected String[] getQueryHideField() {
        return new String[]{"issueStorageOrgUnit.id"};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionAlter_actionPerformed(ActionEvent e) throws Exception {
        super.actionAlter_actionPerformed(e);
        this.checkSelected();
        ArrayList selectedIds = super.getSelectedIdValues();
        IStockTransferBill stockTransferBill = (IStockTransferBill)this.getBizInterface();
        try {
            this.setOprtState("REVOKE");
            this.pubFireVOChangeListener(selectedIds.get(0).toString());
            stockTransferBill.checkAlter((IObjectPK)new ObjectUuidPK(selectedIds.get(0).toString()));
            this.showAlertUI(e);
        }
        catch (EASBizException ex) {
            this.handleException((Exception)((Object)ex));
        }
        catch (Throwable t) {
            this.handUIException(t);
        }
        finally {
            this.setOprtState("RELEASEALL");
            try {
                this.pubFireVOChangeListener(null);
            }
            catch (Throwable t) {
                this.handUIException(t);
            }
        }
    }

    private void showAlertUI(ActionEvent e) throws Exception {
        IUIWindow uiWindow = this.getAlertUI(e);
        uiWindow.show();
        if (this.isDoRefresh(uiWindow)) {
            this.refresh(e);
        }
    }

    private IUIWindow getAlertUI(ActionEvent e) throws Exception {
        this.checkSelected();
        this.checkDataExists();
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ID", (Object)this.getSelectedKeyValue());
        this.prepareUIContext(uiContext, e);
        IUIWindow uiWindow = SwingUtilities.getWindowAncestor((Component)((Object)this)) != null && SwingUtilities.getWindowAncestor((Component)((Object)this)) instanceof JDialog ? UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(this.getEditUIName(), (Map)uiContext, null, "ALERT") : UIFactory.createUIFactory((String)this.getEditUIModal()).create(this.getEditUIName(), (Map)uiContext, null, "ALERT");
        return uiWindow;
    }

    @Override
    public void actionViewVersion_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String[] selIds = KDTableUtil.getSelectRowFieldValue((KDTable)this.tblMain, (String)TB_ID);
        if (selIds == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            SysUtil.abort();
        }
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"BillID", (Object)SCMUtils.convertStringToObjectPK((String[])selIds));
        uiContext.put((Object)"mainOrgId", this.getUIContext().get(this.getMainBizOrgType()));
        IUIFactory uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
        IUIWindow window = uiFactory.create("com.kingdee.eas.scm.im.inv.client.StockTransferBillVersionUI", (Map)uiContext, null);
        window.show();
    }

    protected String[] getRateColumns() {
        return new String[]{"quarityOverRate", "quarityArreRate"};
    }
}

