/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.client;

import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.extendcontrols.ext.CommonF7KDTableListener;
import com.kingdee.bos.ctrl.extendcontrols.ext.IFilterInfoProducer;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.org.client.f7.NewOrgUnitFilterInfoProducer;
import com.kingdee.eas.mm.common.client.UIHelper;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.client.ISCMBillStatusControl;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.client.SCMCommonF7KDTableListener;
import com.kingdee.eas.scm.common.filter.ColConnFilterElement;
import com.kingdee.eas.scm.common.filter.CompositeFilterElement;
import com.kingdee.eas.scm.common.filter.FilterElement;
import com.kingdee.eas.scm.common.filter.MultiF7FilterElement;
import com.kingdee.eas.scm.common.filter.RangeFilterElement;
import com.kingdee.eas.scm.common.filter.SingleFilterElement;
import com.kingdee.eas.scm.common.util.SCMQueryFormat;
import com.kingdee.eas.scm.common.verify.VerifyItem;
import com.kingdee.eas.scm.common.verify.VerifyType;
import com.kingdee.eas.scm.im.inv.client.AbstractStockTransferFilterUI;
import com.kingdee.eas.scm.im.inv.client.InvClientUtils;
import java.awt.Component;
import java.lang.reflect.Field;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.event.ChangeEvent;
import org.apache.log4j.Logger;

public class StockTransferFilterUI
extends AbstractStockTransferFilterUI
implements ISCMBillStatusControl {
    private static final Logger logger = CoreUIObject.getLogger(StockTransferFilterUI.class);
    private boolean isMoveInBotp = false;

    public StockTransferFilterUI() throws Exception {
        this.getElementsInfo();
    }

    private void getElementsInfo() {
        CompositeFilterElement elements = new CompositeFilterElement(0);
        elements.add((FilterElement)new RangeFilterElement("number", (Component)this.txtNumberFrom, (Component)this.txtNumberTo));
        elements.add((FilterElement)new RangeFilterElement("bizType.number", (Component)this.bizBizTypeFrom, (Component)this.bizBizTypeTo));
        elements.add((FilterElement)new RangeFilterElement("material.number", (Component)this.bizMaterialNumberFrom, (Component)this.bizMaterialNumberTo));
        elements.add((FilterElement)new RangeFilterElement("moveOutWarehouse.number", (Component)this.bizMoveOutWarehouseFrom, (Component)this.bizMoveOutWarehouseTo));
        elements.add((FilterElement)new RangeFilterElement("moveInWarehouse.number", (Component)this.bizMoveInWarehouseFrom, (Component)this.bizMoveInWarehouseTo));
        elements.add((FilterElement)new RangeFilterElement("project.number", (Component)this.prmtProjectNumFrom, (Component)this.prmtProjectNumTo));
        elements.add((FilterElement)new RangeFilterElement("trackNumber.number", (Component)this.prmtTrackNumFrom, (Component)this.prmtTrackNumTo));
        CompositeFilterElement dateElements = new CompositeFilterElement(0);
        dateElements.add((FilterElement)new RangeFilterElement("bizDate", (Component)this.bizDateFrom, (Component)this.bizDateTo));
        dateElements.setId("bizDate");
        dateElements.addVerifyItem(new VerifyItem(VerifyType.LESS_EQUAL_TYPE, SCMClientUtils.getResource((String)"CompareDate")));
        elements.add((FilterElement)dateElements);
        CompositeFilterElement planDateElements = new CompositeFilterElement(0);
        planDateElements.add((FilterElement)new RangeFilterElement("entry.receiptPlanDate", (Component)this.bizMoveInPlanDateFrom, (Component)this.bizMoveInPlanDateTo));
        planDateElements.setId("entry.receiptPlanDate");
        planDateElements.addVerifyItem(new VerifyItem(VerifyType.LESS_EQUAL_TYPE, SCMClientUtils.getResource((String)"CompareDate")));
        elements.add((FilterElement)planDateElements);
        ColConnFilterElement mainOrgElement = new ColConnFilterElement("moveOutStorageOrgUnit.id", (Component)this.bizStoreOutOrgFrom);
        mainOrgElement.addVerifyItem(new VerifyItem(VerifyType.REQUIRED_TYPE, InvClientUtils.getResource("TransOutStorageNotNull")));
        elements.add((FilterElement)mainOrgElement);
        elements.add((FilterElement)new MultiF7FilterElement("moveInStorageOrgUnit.id", this.bizStoreInOrgFrom));
        elements.add((FilterElement)new SingleFilterElement("baseStatus", (Component)this.comboxBillStatus, (Object)BillBaseStatusEnum.NULL));
        this.getFilterManager().setElement((FilterElement)elements);
        this.getFilterManager().setMainOrgElement((FilterElement)mainOrgElement, "moveOutStorageOrgUnit.id");
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Storage;
    }

    private void setF7Filter() throws Exception {
        this.setBizMaterialF7(this.bizMaterialNumberFrom, false, null);
        this.setBizMaterialF7(this.bizMaterialNumberTo, false, null);
        this.f7Manager.registerContextChangeF7(this.txtNumberFrom, "issueStorageOrgUnit.id");
        this.f7Manager.registerContextChangeF7(this.txtNumberTo, "issueStorageOrgUnit.id");
        SCMCommonF7KDTableListener commonF7KDTableListener = new SCMCommonF7KDTableListener("baseStatus");
        this.txtNumberFrom.addCommonF7KDTableListener((CommonF7KDTableListener)commonF7KDTableListener);
        this.txtNumberTo.addCommonF7KDTableListener((CommonF7KDTableListener)commonF7KDTableListener);
        EntityViewInfo viewBizType = InvClientUtils.getBizTypeFromBill("140");
        this.bizBizTypeFrom.setEntityViewInfo(viewBizType);
        this.bizBizTypeTo.setEntityViewInfo(viewBizType);
        this.setNeedMainOrgF7s(new KDBizPromptBox[]{this.bizMaterialNumberFrom, this.bizMaterialNumberTo});
        this.bizStoreInOrgFrom.setCommitFormat("$number$");
        this.bizStoreOutOrgFrom.setCommitFormat("$number$");
        this.f7Manager.registerContextChangeF7(this.bizMoveOutWarehouseFrom, "storageOrgUnit.id");
        this.f7Manager.registerContextChangeF7(this.bizMoveOutWarehouseTo, "storageOrgUnit.id");
        this.bizStoreInOrgFrom.setFilterInfoProducer((IFilterInfoProducer)this.getProducer());
        this.bizStoreOutOrgFrom.setFilterInfoProducer((IFilterInfoProducer)this.getProducer());
        UIHelper.registerProjectF7ForFilter((KDBizPromptBox)this.getMainBizOrgF7(), (KDBizPromptBox)this.prmtProjectNumFrom);
        UIHelper.registerProjectF7ForFilter((KDBizPromptBox)this.getMainBizOrgF7(), (KDBizPromptBox)this.prmtProjectNumTo);
        UIHelper.registerTrackNumberF7ForFilter((KDBizPromptBox)this.getMainBizOrgF7(), (KDBizPromptBox)this.prmtTrackNumFrom);
        UIHelper.registerTrackNumberF7ForFilter((KDBizPromptBox)this.getMainBizOrgF7(), (KDBizPromptBox)this.prmtTrackNumTo);
    }

    @Override
    protected void bizStoreInOrgFrom_stateChanged(ChangeEvent e) throws Exception {
        Object obj = this.bizStoreInOrgFrom.getData();
        if (obj instanceof Object[]) {
            Object[] sou = (Object[])obj;
            HashSet<String> ids = new HashSet<String>();
            OrgUnitInfo unitInfo = null;
            int len = sou.length;
            for (int i = 0; i < len; ++i) {
                unitInfo = (OrgUnitInfo)sou[i];
                if (unitInfo == null) continue;
                ids.add(unitInfo.getId().toString());
            }
            this.setSouEntityView(this.bizMoveInWarehouseFrom, ids);
            this.setSouEntityView(this.bizMoveInWarehouseTo, ids);
        }
    }

    private void setSouEntityView(KDBizPromptBox f7, Set ids) {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)ids, CompareType.INCLUDE));
        viewInfo.setFilter(filter);
        f7.setEntityViewInfo(viewInfo);
    }

    private NewOrgUnitFilterInfoProducer getProducer() {
        NewOrgUnitFilterInfoProducer iProducer = null;
        try {
            Field producer = this.getMainBizOrgF7().getClass().getDeclaredField("ifip");
            producer.setAccessible(true);
            iProducer = (NewOrgUnitFilterInfoProducer)producer.get(this.getMainBizOrgF7());
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        if (iProducer == null) {
            iProducer = new NewOrgUnitFilterInfoProducer(this.getMainBizOrgType());
            if (this.getViewPermission() != null) {
                iProducer.getModel().setPermissionItem(this.getViewPermission());
            }
        }
        if (iProducer != null && iProducer.getModel() != null) {
            iProducer.getModel().setNeedAddSealUp(false);
        }
        return iProducer;
    }

    protected void setMainBizF7(KDBizPromptBox bizOrgUnitBox) {
        bizOrgUnitBox.setCommitFormat("$number$");
        NewOrgUnitFilterInfoProducer iProducer = new NewOrgUnitFilterInfoProducer(this.getMainBizOrgType());
        String permissionItem = this.getViewPermission();
        if (permissionItem != null) {
            iProducer.getModel().setPermissionItem(permissionItem);
        }
        bizOrgUnitBox.setFilterInfoProducer((IFilterInfoProducer)iProducer);
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.setF7Filter();
        this.setDefaultValue();
        if (this.getMainBizOrgF7().getText() != null) {
            this.mainOrgChanged();
        }
        if (this.isMoveInBotp) {
            this.setMainBizF7(this.bizStoreOutOrgFrom);
        }
    }

    protected void setDefaultValue() {
        this.bizStoreInOrgFrom.setEnabledMultiSelection(true);
        SCMQueryFormat.formatStartTime((KDDatePicker)this.bizDateFrom);
        SCMQueryFormat.formatEndTime((KDDatePicker)this.bizDateTo);
        SCMQueryFormat.formatBillStatus((ISCMBillStatusControl)this, (KDComboBox)this.comboxBillStatus);
    }

    public Object[] getUnVisibleBillStatus() {
        return new Object[]{BillBaseStatusEnum.ADD, BillBaseStatusEnum.RELEASED, BillBaseStatusEnum.BLOCKED};
    }

    public Object[] getAdditiveBillStatus() {
        return new Object[]{BillBaseStatusEnum.ALTERING};
    }

    public KDBizPromptBox getMainBizOrgF7() {
        return this.bizStoreOutOrgFrom;
    }

    @Override
    protected void bizStoreOutOrgFrom_stateChanged(ChangeEvent e) throws Exception {
    }

    protected String getViewPermission() {
        return "stocktransfer_view";
    }

    protected String getPropertyOfMainBizOrg() {
        return "issueStorageOrgUnit.id";
    }

    protected void setOrgInBOTP(Map botpMap) {
        this.isMoveInBotp = false;
        if (botpMap != null) {
            String billType = (String)botpMap.get("DESTBILLTYPE.ID");
            OrgUnitInfo destOrg = (OrgUnitInfo)botpMap.get("MAINBIZORG");
            if ("50957179-0105-1000-e000-0172c0a812fd463ED552".equals(billType) || "50957179-0105-1000-e000-015fc0a812fd463ED552".equals(billType)) {
                Object outOrg = this.getMainBizOrgF7().getData();
                if (outOrg instanceof StorageOrgUnitInfo && destOrg.getId().equals((Object)((StorageOrgUnitInfo)outOrg).getId())) {
                    this.getMainBizOrgF7().setData(null);
                }
                this.getMainBizOrgF7().setEnabled(true);
                if (this.bizStoreInOrgFrom.getData() == null) {
                    this.bizStoreInOrgFrom.setData((Object)new Object[]{destOrg});
                }
                this.bizStoreInOrgFrom.setEnabled(false);
                this.isMoveInBotp = true;
            } else if ("18b7FpLNSrmaD8V9SPcOhkY+1VI=".equals(billType)) {
                super.setOrgInBOTP(botpMap);
                this.bizStoreOutOrgFrom.setEnabled(true);
                this.bizStoreOutOrgFrom.setEditable(true);
            } else {
                super.setOrgInBOTP(botpMap);
            }
        }
    }
}

