/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.invconfig.client;

import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.query.SQLExecutor;
import com.kingdee.eas.scm.framework.balance.BalanceFieldModelCollection;
import com.kingdee.eas.scm.framework.balance.BalanceFieldModelInfo;
import com.kingdee.eas.scm.framework.balance.BalanceModelInfo;
import com.kingdee.eas.scm.framework.balance.BizDataTypeEnum;
import com.kingdee.eas.scm.framework.balance.DataTypeEnum;
import com.kingdee.eas.scm.framework.client.CommonFilterPanelUtil;
import com.kingdee.eas.scm.im.inv.CountingTableEntryInfo;
import com.kingdee.eas.scm.im.inv.InventoryCollection;
import com.kingdee.eas.scm.im.inv.InventoryInfo;
import com.kingdee.eas.scm.im.inv.invconfig.BillInventoryConfigEntryCollection;
import com.kingdee.eas.scm.im.inv.invconfig.BillInventoryConfigEntryInfo;
import com.kingdee.eas.scm.im.inv.invconfig.BillInventoryConfigInfo;
import com.kingdee.eas.scm.im.inv.invconfig.client.InventoryHelper;
import com.kingdee.eas.scm.im.inv.invconfig.util.BalanceCfgUtil;
import com.kingdee.eas.scm.util.collection.CollectionUtil;
import com.kingdee.eas.scm.util.datetime.DateTimeUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;

public class CountingTableHelper
extends InventoryHelper {
    private static Map f7 = new HashMap();

    private static Map getMap() throws Exception {
        HashMap<String, BillInventoryConfigEntryInfo> extendMap = new HashMap<String, BillInventoryConfigEntryInfo>();
        BillInventoryConfigInfo info = CountingTableHelper.getConfigInfo("D9D2CA5D");
        BillInventoryConfigEntryCollection coll = info.getEntry();
        BillInventoryConfigEntryInfo entryInfo = null;
        Set<String> defaultProperty = CountingTableHelper.getDefaultProperty();
        String invField = null;
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            entryInfo = coll.get(i);
            invField = entryInfo.getInvField();
            if (invField == null || defaultProperty.contains(invField)) continue;
            extendMap.put(invField, entryInfo);
        }
        return extendMap;
    }

    public static List getCompList() throws Exception {
        BalanceModelInfo balanceModelInfo = BalanceCfgUtil.getBalanceModelInfo(null);
        BalanceFieldModelCollection coll = balanceModelInfo.getEntry();
        BalanceFieldModelInfo fieldModeInfo = null;
        Set<String> defaultProperty = CountingTableHelper.getDefaultProperty();
        String invField = null;
        ArrayList<KDLabelContainer> compList = new ArrayList<KDLabelContainer>();
        String name = null;
        String text = null;
        String bosType = null;
        KDLabelContainer lc = null;
        KDBizPromptBox editor = null;
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            fieldModeInfo = coll.get(i);
            invField = fieldModeInfo.getFieldName();
            if (fieldModeInfo.getBizDataType() == BizDataTypeEnum.AssistInfo || invField == null || defaultProperty.contains(invField)) continue;
            name = invField;
            text = fieldModeInfo.getAlias();
            editor = null;
            if (DataTypeEnum.BOSUuid.equals((Object)fieldModeInfo.getDataType())) {
                bosType = fieldModeInfo.getBaseDataBOSType().toString();
                editor = CommonFilterPanelUtil.createF7WithBosType((String)bosType);
                f7.put(name, editor);
            } else if (DataTypeEnum.String.equals((Object)fieldModeInfo.getDataType())) {
                editor = CountingTableHelper.getTextField(name);
            } else if (DataTypeEnum.Date.equals((Object)fieldModeInfo.getDataType())) {
                editor = CountingTableHelper.getDatePicker(name);
            } else if (DataTypeEnum.Amount.equals((Object)fieldModeInfo.getDataType()) || DataTypeEnum.Integer.equals((Object)fieldModeInfo.getDataType()) || DataTypeEnum.Qty.equals((Object)fieldModeInfo.getDataType())) {
                editor = CountingTableHelper.getNumericEditor(name);
            } else if (DataTypeEnum.Boolean.equals((Object)fieldModeInfo.getDataType())) {
                editor = CountingTableHelper.getCheckBox(name);
            }
            if (editor == null) continue;
            lc = CountingTableHelper.buildlabelContainer(name, text, (JComponent)editor);
            compList.add(lc);
        }
        return compList;
    }

    private static KDCheckBox getCheckBox(String name) {
        KDCheckBox cb = new KDCheckBox();
        cb.setName(name);
        return cb;
    }

    private static KDLabelContainer buildlabelContainer(String name, String text, JComponent editor) {
        KDLabelContainer lc = new KDLabelContainer();
        if (editor instanceof KDCheckBox) {
            ((KDCheckBox)editor).setText(text);
            lc.setBoundEditor(editor);
            lc.setName(name);
            return lc;
        }
        lc.setName(name);
        lc.setBoundLabelText(text);
        lc.setBoundLabelLength(99);
        lc.setBoundLabelUnderline(true);
        lc.setBounds(new Rectangle(10, 155, 270, 19));
        lc.setBoundEditor(editor);
        return lc;
    }

    private static KDFormattedTextField getNumericEditor(String name) {
        KDFormattedTextField formatEditor = new KDFormattedTextField();
        formatEditor.setName(name);
        formatEditor.setPrecision(8);
        return formatEditor;
    }

    private static KDDatePicker getDatePicker(String name) {
        KDDatePicker datePicker = new KDDatePicker();
        datePicker.setName(name);
        return datePicker;
    }

    private static KDTextField getTextField(String name) {
        KDTextField textField = new KDTextField();
        textField.setName(name);
        return textField;
    }

    public static InventoryCollection buildInventoryColl(List compList, InventoryCollection coll) throws Exception {
        InventoryCollection invCol = new InventoryCollection();
        if (CollectionUtil.isEmpty((Collection)compList) || CollectionUtil.isEmpty((AbstractObjectCollection)coll)) {
            return coll;
        }
        HashMap<String, InventoryInfo> infoMap = new HashMap<String, InventoryInfo>();
        InventoryInfo info = null;
        StringBuffer sqlWhere = new StringBuffer();
        sqlWhere.append(" where fid in ('88888888'");
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            info = coll.get(i);
            sqlWhere.append(", '").append(info.getId().toString()).append("'");
            infoMap.put(info.getId().toString(), info);
        }
        sqlWhere.append(") ");
        JComponent editor = null;
        KDLabelContainer lc = null;
        String invField = null;
        Object obj = null;
        String id = null;
        StringBuffer sql = new StringBuffer(" select top 1 fid");
        int size2 = compList.size();
        for (int i = 0; i < size2; ++i) {
            lc = (KDLabelContainer)compList.get(i);
            invField = lc.getName();
            editor = lc.getBoundEditor();
            sql.append(",").append(invField);
            if (editor instanceof KDBizPromptBox) {
                obj = ((KDBizPromptBox)editor).getValue();
                if (obj != null) {
                    id = ((IObjectValue)obj).getString("id");
                }
            } else if (editor instanceof KDTextField) {
                obj = ((KDTextField)editor).getText();
                if (obj != null && obj.toString().length() > 0) {
                    id = obj.toString();
                }
            } else if (editor instanceof KDFormattedTextField) {
                obj = ((KDFormattedTextField)editor).getText();
                if (obj != null && obj.toString().length() > 0) {
                    id = obj.toString();
                }
            } else if (editor instanceof KDDatePicker) {
                obj = ((KDDatePicker)editor).getValue();
                if (obj != null) {
                    id = DateTimeUtil.getFmtDate((Date)((Date)obj));
                }
            } else if (editor instanceof KDCheckBox && (obj = Boolean.valueOf(((KDCheckBox)editor).isSelected())) != null) {
                obj = (Boolean)obj != false ? "1" : "0";
                id = obj.toString();
            }
            if (id != null) {
                sqlWhere.append(" and ").append(invField).append(" = '");
                sqlWhere.append(id).append("' ");
                continue;
            }
            sqlWhere.append(" and ").append(invField).append(" is null ");
        }
        sql.append(" from t_im_inventory ").append(sqlWhere);
        IRowSet rs = new SQLExecutor(sql.toString()).executeSQL();
        while (rs.next()) {
            String fid = rs.getString("fid");
            info = (InventoryInfo)infoMap.get(fid);
            invCol.add(info);
        }
        return invCol;
    }

    public static void buildExtendValue(CountingTableEntryInfo ctEntryInfo, List compList) throws Exception {
        BillInventoryConfigInfo info = CountingTableHelper.getConfigInfo("D9D2CA5D");
        BillInventoryConfigEntryInfo entryInfo = null;
        HashMap<String, String> mapping = new HashMap<String, String>();
        for (int i = 0; i < info.getEntry().size(); ++i) {
            entryInfo = info.getEntry().get(i);
            mapping.put(entryInfo.getInvField(), entryInfo.getBillProperty());
        }
        if (CollectionUtil.isEmpty((Collection)compList)) {
            return;
        }
        JComponent editor = null;
        KDLabelContainer lc = null;
        String invField = null;
        Object obj = null;
        int size = compList.size();
        for (int i = 0; i < size; ++i) {
            lc = (KDLabelContainer)compList.get(i);
            invField = lc.getName();
            editor = lc.getBoundEditor();
            if (editor instanceof KDBizPromptBox) {
                obj = ((KDBizPromptBox)editor).getValue();
            } else if (editor instanceof KDTextField) {
                obj = ((KDTextField)editor).getText();
            } else if (editor instanceof KDCheckBox) {
                obj = ((KDCheckBox)editor).isSelected();
            } else if (editor instanceof KDFormattedTextField) {
                obj = ((KDFormattedTextField)editor).getValue();
            } else if (editor instanceof KDDatePicker) {
                obj = ((KDDatePicker)editor).getValue();
            }
            String billProperty = (String)mapping.get(invField);
            if (billProperty == null || billProperty.indexOf(".") <= -1) continue;
            String[] str = billProperty.split("\\.");
            ctEntryInfo.put(str[1], obj);
        }
    }
}

