/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.invconfig.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.SQLExecutor;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.scm.framework.balance.BalanceFieldModelCollection;
import com.kingdee.eas.scm.framework.balance.BalanceFieldModelInfo;
import com.kingdee.eas.scm.framework.balance.BalanceModelInfo;
import com.kingdee.eas.scm.framework.balance.DataTypeEnum;
import com.kingdee.eas.scm.framework.balance.client.CommonBalanceFilterPanel;
import com.kingdee.eas.scm.im.inv.invconfig.BillInvConfigFacadeFactory;
import com.kingdee.eas.scm.im.inv.invconfig.BillInventoryConfigCollection;
import com.kingdee.eas.scm.im.inv.invconfig.BillInventoryConfigEntryInfo;
import com.kingdee.eas.scm.im.inv.invconfig.BillInventoryConfigFactory;
import com.kingdee.eas.scm.im.inv.invconfig.BillInventoryConfigInfo;
import com.kingdee.eas.scm.im.inv.invconfig.InventoryServerHelper;
import com.kingdee.eas.scm.im.inv.invconfig.util.BalanceCfgUtil;
import com.kingdee.eas.scm.util.collection.CollectionUtil;
import com.kingdee.eas.scm.util.filehandle.ResourceUtil;
import com.kingdee.eas.scm.util.string.StringUtil;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LocaleUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class InventoryHelper
extends InventoryServerHelper {
    private static Map<String, BillInventoryConfigInfo> configMap = new HashMap<String, BillInventoryConfigInfo>();

    public static void insertEntryData(IObjectValue billEntryInfo, String bosType, String invID) throws Exception {
        BillInventoryConfigInfo cfgInfo = null;
        if (configMap.get(bosType) == null) {
            cfgInfo = InventoryHelper.getConfigInfo(bosType);
        }
        if (cfgInfo == null) {
            return;
        }
        Set<String> property = InventoryHelper.getDefaultProperty();
        BillInventoryConfigEntryInfo cfgEntryInfo = null;
        String invField = null;
        HashMap<String, String> dataMap = new HashMap<String, String>();
        StringBuilder invFieldStr = new StringBuilder();
        int size = cfgInfo.getEntry().size();
        for (int i = 0; i < size; ++i) {
            cfgEntryInfo = cfgInfo.getEntry().get(i);
            invField = cfgEntryInfo.getInvField();
            if (invField == null || property.contains(invField) || StringUtil.isEmpty((String)cfgEntryInfo.getBillProperty())) continue;
            invFieldStr.append(invField).append(", ");
            dataMap.put(invField, cfgEntryInfo.getBillProperty());
        }
        if (dataMap.size() == 0) {
            return;
        }
        invFieldStr.setLength(invFieldStr.length() - 2);
        StringBuilder sql = new StringBuilder();
        sql.append(" select ").append(invFieldStr.toString()).append(" from t_im_inventory where fid = '").append(invID).append("' ");
        IRowSet rs = new SQLExecutor(sql.toString()).executeSQL();
        while (rs.next()) {
            Set keySet = dataMap.keySet();
            Iterator it = keySet.iterator();
            String key = null;
            String billProperty = null;
            Object value = null;
            while (it.hasNext()) {
                key = (String)it.next();
                billProperty = (String)dataMap.get(key);
                value = rs.getObject(key);
                InventoryHelper.putData(billProperty, billEntryInfo, key, value);
            }
        }
    }

    private static void putData(String billProperty, IObjectValue billEntryInfo, String invField, Object value) throws BOSException, EASBizException {
        if (billProperty == null || billProperty.indexOf(".") == -1) {
            return;
        }
        Object obj = value;
        String key = invField;
        if (key.toLowerCase(Locale.ENGLISH).endsWith("id") && value != null) {
            BOSObjectType bosObjectType = BOSUuid.read((String)value.toString()).getType();
            ICoreBase coreBase = (ICoreBase)BOSObjectFactory.createRemoteBOSObject((BOSObjectType)bosObjectType, ICoreBase.class);
            obj = coreBase.getValue((IObjectPK)new ObjectUuidPK(value.toString()));
        }
        String[] str = billProperty.split("\\.");
        if (billProperty.startsWith("__src")) {
            billEntryInfo.put(str[2], obj);
        } else {
            billEntryInfo.put(str[1], obj);
        }
    }

    protected static Set<String> getDefaultProperty() {
        String[] fields = new String[]{"FID", "FControlUnitID", "FLastUpdateTime", "FLastUpdateUserID", "FCreateTime", "FCreatorID", "FAssistPropertyID", "FExp", "FBaseUnitID", "FAmount", "FBaseQty", "FCurStoreAssistQty", "FAssistUnitID", "FCurStoreQty", "FUnitID", "FTrackNumberID", "FProjectID", "FLot", "FMaterialID", "FCustomerID", "FSupplierID", "FStoreStatusID", "FStoreTypeID", "FLocationID", "FWarehouseID", "FStorageOrgUnitID", "FCompanyOrgUnitID"};
        return new HashSet<String>(Arrays.asList(fields));
    }

    protected static BillInventoryConfigInfo getConfigInfo(String bosType) throws BOSException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("bosType", (Object)bosType, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("status", (Object)1, CompareType.EQUALS));
        SorterItemCollection sic = new SorterItemCollection();
        sic.add(new SorterItemInfo("number"));
        viewInfo.setFilter(filter);
        viewInfo.setSorter(sic);
        BillInventoryConfigCollection col = BillInventoryConfigFactory.getRemoteInstance().getBillInventoryConfigCollection(viewInfo);
        return col.get(0);
    }

    public static CommonBalanceFilterPanel getFilterPanel() throws Exception {
        BalanceModelInfo balanceModelInfo = BalanceCfgUtil.getBalanceModelInfo(null);
        InventoryHelper.addDynBalanceFilerFiled(balanceModelInfo);
        CommonBalanceFilterPanel commonFilterPanel = new CommonBalanceFilterPanel(balanceModelInfo, null, 455, 300, 10);
        String panleName = EASResource.getString((String)"com.kingdee.eas.base.commonquery.client.CommonFilterPanel", (String)"panelName");
        commonFilterPanel.setPanelName(panleName);
        return commonFilterPanel;
    }

    private static void addDynBalanceFilerFiled(BalanceModelInfo balanceModelInfo) {
        Locale local = SysContext.getSysContext().getLocale();
        String loc = LocaleUtils.getLocaleString((Locale)local);
        BalanceFieldModelCollection dynFiledColl = new BalanceFieldModelCollection();
        BalanceFieldModelInfo bFiledInfo = null;
        BalanceFieldModelCollection coll = balanceModelInfo.getEntry();
        coll.sort("seq");
        int num = 2;
        for (int i = 0; i < coll.size(); ++i) {
            num = 2;
            bFiledInfo = coll.get(i);
            if (StringUtil.isEmpty((String)bFiledInfo.getBaseDataBOSType())) continue;
            InventoryHelper.addDynBalanceFiled(loc, dynFiledColl, bFiledInfo);
            if (bFiledInfo.getBaseDataBOSType() != null && bFiledInfo.getBaseDataBOSType().equals("4409E7F0")) {
                BalanceFieldModelInfo dynFiledInfo = new BalanceFieldModelInfo();
                dynFiledInfo.setName(bFiledInfo.getName() + ".model");
                dynFiledInfo.setAlias(bFiledInfo.getAlias() + ResourceUtil.getMessage((String)"com.kingdee.eas.scm.im.inv.invconfig.BillInventoryResource", (String)"model"));
                dynFiledInfo.setSeq(bFiledInfo.getSeq() + 3);
                InventoryHelper.setCommonProperty(bFiledInfo, dynFiledInfo);
                dynFiledColl.add(dynFiledInfo);
                num = 3;
                dynFiledInfo = new BalanceFieldModelInfo();
                dynFiledInfo.setName(bFiledInfo.getName() + ".shortName");
                dynFiledInfo.setAlias(ResourceUtil.getMessage((String)"com.kingdee.eas.scm.im.inv.invconfig.BillInventoryResource", (String)"shortName"));
                dynFiledInfo.setSeq(bFiledInfo.getSeq() + 4);
                InventoryHelper.setCommonProperty(bFiledInfo, dynFiledInfo);
                dynFiledColl.add(dynFiledInfo);
                num = 4;
                dynFiledInfo = new BalanceFieldModelInfo();
                dynFiledInfo.setName(bFiledInfo.getName() + ".HelpCode");
                dynFiledInfo.setAlias(bFiledInfo.getAlias() + ResourceUtil.getMessage((String)"com.kingdee.eas.scm.im.inv.invconfig.BillInventoryResource", (String)"MaterialHelpCode"));
                dynFiledInfo.setSeq(bFiledInfo.getSeq() + 5);
                InventoryHelper.setCommonProperty(bFiledInfo, dynFiledInfo);
                dynFiledColl.add(dynFiledInfo);
                num = 5;
            }
            for (int j = i + 1; j < coll.size(); ++j) {
                coll.get(j).setSeq(coll.get(j).getSeq() + num);
            }
        }
        coll.addCollection(dynFiledColl);
    }

    private static void addDynBalanceFiled(String loc, BalanceFieldModelCollection dynFiledColl, BalanceFieldModelInfo bFiledInfo) {
        BalanceFieldModelInfo dynFiledInfo = new BalanceFieldModelInfo();
        dynFiledInfo.setName(bFiledInfo.getName() + ".number");
        dynFiledInfo.setAlias(bFiledInfo.getAlias() + ResourceUtil.getMessage((String)"com.kingdee.eas.scm.im.inv.invconfig.BillInventoryResource", (String)"number"));
        dynFiledInfo.setSeq(bFiledInfo.getSeq() + 1);
        InventoryHelper.setCommonProperty(bFiledInfo, dynFiledInfo);
        dynFiledColl.add(dynFiledInfo);
        dynFiledInfo = new BalanceFieldModelInfo();
        dynFiledInfo.setName(bFiledInfo.getName() + ".name_" + loc);
        dynFiledInfo.setAlias(bFiledInfo.getAlias() + ResourceUtil.getMessage((String)"com.kingdee.eas.scm.im.inv.invconfig.BillInventoryResource", (String)"name"));
        dynFiledInfo.setSeq(bFiledInfo.getSeq() + 2);
        InventoryHelper.setCommonProperty(bFiledInfo, dynFiledInfo);
        dynFiledColl.add(dynFiledInfo);
    }

    private static void setCommonProperty(BalanceFieldModelInfo bFiledInfo, BalanceFieldModelInfo dynFiledInfo) {
        dynFiledInfo.setDataType(DataTypeEnum.String);
        dynFiledInfo.setDynFileds(true);
        dynFiledInfo.setIsScheduled(bFiledInfo.isIsScheduled());
    }

    public static Map<String, Map<String, Object>> getExtendValue(String bosType, Set<String> ids) throws Exception {
        if (ids.size() == 0) {
            return null;
        }
        BillInventoryConfigInfo cfgInfo = InventoryHelper.getConfigInfo(bosType);
        Set<String> property = InventoryHelper.getDefaultProperty();
        BillInventoryConfigEntryInfo cfgEntryInfo = null;
        String invField = null;
        StringBuilder sql = new StringBuilder(" select fid ");
        HashMap<String, String> mapping = new HashMap<String, String>();
        ArrayList<String> invFields = new ArrayList<String>();
        int size = cfgInfo.getEntry().size();
        for (int i = 0; i < size; ++i) {
            cfgEntryInfo = cfgInfo.getEntry().get(i);
            invField = cfgEntryInfo.getInvField();
            if (invField == null || property.contains(invField) || StringUtil.isEmpty((String)cfgEntryInfo.getBillProperty())) continue;
            invFields.add(invField);
            mapping.put(invField, cfgEntryInfo.getBillProperty());
            sql.append(invField).append(", ");
        }
        if (mapping.size() == 0) {
            return null;
        }
        ArrayList<String> idList = new ArrayList<String>(ids);
        sql.append(" from t_im_inventory where fid in '").append(CollectionUtil.convertList2String(idList)).append("' ");
        IRowSet rs = new SQLExecutor(sql.toString()).executeSQL();
        HashMap entryMap = null;
        HashMap<String, Map<String, Object>> result = new HashMap<String, Map<String, Object>>();
        while (rs.next()) {
            entryMap = new HashMap();
            int size2 = invFields.size();
            for (int i = 0; i < size2; ++i) {
                invField = (String)invFields.get(i);
                if (invField == null) continue;
                if (invField.toLowerCase(Locale.ENGLISH).endsWith("id")) {
                    String id = rs.getString(invField);
                    BOSObjectType bosObjectType = BOSUuid.read((String)id).getType();
                    ICoreBase coreBase = (ICoreBase)BOSObjectFactory.createRemoteBOSObject((BOSObjectType)bosObjectType, ICoreBase.class);
                    CoreBaseInfo obj = coreBase.getValue((IObjectPK)new ObjectUuidPK(id));
                    entryMap.put(mapping.get(invField), obj);
                    continue;
                }
                entryMap.put(mapping.get(invField), rs.getObject(invField));
            }
            result.put(rs.getString("fid"), entryMap);
        }
        return result;
    }

    @Override
    protected void buildConfigMapping(String bosType, String billEntryBosType, IObjectValue billInfo, IObjectValue billEntryInfo, int filterType) throws Exception {
        HashMap<String, String> bosType2EntryName = new HashMap<String, String>();
        BillInventoryConfigInfo configInfo = BalanceCfgUtil.getConfigInfo(null, bosType, billEntryBosType, billInfo, bosType2EntryName);
        if (configInfo == null) {
            String msg = ResourceUtil.getMessage((String)"com.kingdee.eas.scm.im.inv.invconfig.BillInventoryResource", (String)"configInfoInvalid");
            MsgBox.showConfirm2((String)msg);
            SysUtil.abort();
        }
        this.mapping = new HashMap();
        BillInventoryConfigEntryInfo entryInfo = null;
        int size = configInfo.getEntry().size();
        for (int i = 0; i < size; ++i) {
            entryInfo = configInfo.getEntry().get(i);
            if (entryInfo == null || !entryInfo.isIsAssign() || entryInfo.getInvField() == null || entryInfo.getBillProperty() == null) continue;
            String propertyStr = entryInfo.getBillProperty();
            if (propertyStr.indexOf("__src") != -1) {
                propertyStr = propertyStr.substring("__src".length() + 1);
            }
            this.mapping.put(entryInfo.getInvField(), propertyStr);
        }
        if (bosType2EntryName.get(billEntryBosType) != null) {
            this.entryName = (String)bosType2EntryName.get(billEntryBosType);
        }
        this.propMap = BillInvConfigFacadeFactory.getRemoteInstance().evalBillInventoryConfigValue(billInfo, billEntryInfo, this.entryName, configInfo, false, filterType);
    }
}

