/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.invconfig.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.SQLExecutor;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.IMaterialInventory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MaterialInventoryFactory;
import com.kingdee.eas.basedata.master.material.MaterialInventoryInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.scm.common.RIEnum;
import com.kingdee.eas.basedata.scm.common.TransactionTypeInfo;
import com.kingdee.eas.basedata.scm.im.inv.RecIssueTypeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.CoreBillEntryBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.scm.common.SCMBillCommonFacadeFactory;
import com.kingdee.eas.scm.common.client.MaterialQueryListUI;
import com.kingdee.eas.scm.common.client.config.MaterialQueryConditionInfo;
import com.kingdee.eas.scm.common.util.StringUtil;
import com.kingdee.eas.scm.framework.balance.BalanceFieldModelCollection;
import com.kingdee.eas.scm.framework.balance.BalanceFieldModelInfo;
import com.kingdee.eas.scm.framework.balance.BizDataTypeEnum;
import com.kingdee.eas.scm.framework.balance.DataTypeEnum;
import com.kingdee.eas.scm.im.inv.BizDirectionEnum;
import com.kingdee.eas.scm.im.inv.InvBizException;
import com.kingdee.eas.scm.im.inv.TransferOrderBillInfo;
import com.kingdee.eas.scm.im.inv.client.InvClientUtils;
import com.kingdee.eas.scm.im.inv.invconfig.client.InventoryHelper;
import com.kingdee.eas.scm.im.inv.invconfig.util.BalanceCfgUtil;
import com.kingdee.eas.scm.sd.sale.PostRequisitionInfo;
import com.kingdee.eas.scm.util.array.ArrayUtil;
import com.kingdee.eas.scm.util.collection.CollectionUtil;
import com.kingdee.eas.scm.util.filehandle.ResourceUtil;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class MaterialQueryHelper
extends InventoryHelper {
    private StorageOrgUnitInfo sou = null;
    protected boolean isUpdateByBaseUnit = false;
    private Component owner = null;
    protected String permissionSQL = null;
    protected String permissionJoinSQL = null;
    private boolean isIssue = false;
    private String materialID = null;
    protected MaterialQueryConditionInfo materialQueryConditionInfo = null;
    private HashMap<String, String> billPropertys = new HashMap();

    public MaterialQueryHelper(MaterialQueryConditionInfo materialQueryConditionInfo) {
        this.materialQueryConditionInfo = materialQueryConditionInfo;
    }

    public int actionMaterialQuery() throws Exception {
        UIContext uiContext = this.materialQueryConditionInfo.getUiContex();
        uiContext.put((Object)"canResize", (Object)"true");
        TransactionTypeInfo tti = this.materialQueryConditionInfo.getTransactionTypeInfo();
        IObjectValue billInfo = this.materialQueryConditionInfo.getBillInfo();
        IObjectValue billEntryInfo = this.materialQueryConditionInfo.getBillEntryInfo();
        this.owner = (Component)uiContext.get((Object)"Owner");
        if (billInfo instanceof PostRequisitionInfo) {
            this.isIssue = true;
        } else if (tti != null) {
            this.transactionTypeID = tti.getId().toString();
            this.setIsIssue(tti);
        }
        this.entryName = (String)uiContext.get((Object)"entryName");
        String bosType = billInfo.getBOSType().toString();
        this.setIsIssue(billInfo);
        String billEntryBosType = billEntryInfo.getBOSType().toString();
        this.buildConfigMapping(bosType, billEntryBosType, billInfo, billEntryInfo, 0);
        this.sou = (StorageOrgUnitInfo)uiContext.get((Object)"STORAGEORGUNIT");
        if (this.sou == null) {
            this.sou = (StorageOrgUnitInfo)this.propMap.get("FStorageOrgUnitID");
        }
        this.setParam(uiContext);
        String sql = this.getQuerySQL(bosType, billInfo, billEntryInfo);
        Object materialInfo = this.propMap.get("FMaterialID");
        if (materialInfo instanceof IObjectValue) {
            this.materialID = ((IObjectValue)materialInfo).get("id").toString();
        }
        String defalutSql = sql + "order by FLot asc";
        IRowSet rs = new SQLExecutor(defalutSql).executeSQL();
        IUIWindow materialWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create("com.kingdee.eas.scm.common.client.MaterialQueryListUI", (Map)uiContext, null, OprtState.EDIT);
        MaterialQueryListUI aMaterialQueryListUI = (MaterialQueryListUI)materialWindow.getUIObject();
        boolean isSetAndBackButtonVisable = (Boolean)uiContext.get((Object)"isSetAndBackButtonVisable");
        aMaterialQueryListUI.setSetAndBackButtonVisiable(isSetAndBackButtonVisable);
        this.resMap.put("query_materialInfo", materialInfo);
        this.resMap.put("query_storageOrgInfo", this.sou);
        aMaterialQueryListUI.setFromF12(true);
        aMaterialQueryListUI.actionQuery(this.tableHeadKeyList, this.resMap, rs, sql);
        materialWindow.show();
        if (!aMaterialQueryListUI.isCancelled()) {
            List results = aMaterialQueryListUI.getResults();
            List<CoreBillEntryBaseInfo> entryInfoList = this.fetchData(results, billEntryInfo);
            CoreBillEntryBaseInfo coreEntryInfo = null;
            if (this.entryName == null) {
                return 0;
            }
            AbstractObjectCollection coreEntryCol = (AbstractObjectCollection)this.materialQueryConditionInfo.getParentInfo().get(this.entryName);
            int insertIndex = coreEntryCol.indexOf(billEntryInfo);
            int size = entryInfoList.size();
            for (int i = 1; i < size; ++i) {
                coreEntryInfo = entryInfoList.get(i);
                coreEntryCol.insertObject(insertIndex++, (IObjectValue)coreEntryInfo);
            }
            billInfo.put("entryInfoList", entryInfoList);
            return entryInfoList.size();
        }
        return 0;
    }

    private void setIsIssue(IObjectValue billInfo) {
        String[] bosTypes;
        List<String> bosTypeList;
        TransferOrderBillInfo transferOrder;
        String bosType = billInfo.getBOSType().toString();
        if ("5C2A1F0C".equals(bosType) && (transferOrder = (TransferOrderBillInfo)billInfo).getBizDirection() == BizDirectionEnum.POSITIVE) {
            this.isIssue = true;
        }
        if ((bosTypeList = Arrays.asList(bosTypes = new String[]{"2239F30A", "A4D04D25"})).contains(bosType)) {
            this.isIssue = true;
        }
    }

    protected void setParam(UIContext uiContext) {
        if (uiContext.get((Object)"isUpdateByBaseUnit") == null) {
            if (this.sou != null) {
                this.isUpdateByBaseUnit = InvClientUtils.isUpdateInvByBaseUnit(this.sou.getId().toString());
            }
        } else {
            this.isUpdateByBaseUnit = (Boolean)uiContext.get((Object)"isUpdateByBaseUnit");
        }
    }

    private List<CoreBillEntryBaseInfo> fetchData(List<HashMap<String, Object>> results, IObjectValue billEntryInfo) throws BOSException, EASBizException {
        BigDecimal baseQty;
        ArrayList<CoreBillEntryBaseInfo> entryList = new ArrayList<CoreBillEntryBaseInfo>();
        HashMap<String, Object> hmResult = null;
        CoreBillEntryBaseInfo value = (CoreBillEntryBaseInfo)billEntryInfo;
        CoreBillEntryBaseInfo cloneValue = (CoreBillEntryBaseInfo)((CoreBillEntryBaseInfo)billEntryInfo).clone();
        String qtyProperty = (String)this.mapping.get("FCurStoreQty");
        String assistQtyProperty = (String)this.mapping.get("FCurStoreAssistQty");
        String baseQtyProperty = (String)this.mapping.get("FBaseQty");
        String realBaseQtyProperty = "";
        String realQtyProperty = "";
        String realAssistQtyProperty = "";
        if (!StringUtil.isEmpty((String)baseQtyProperty) && baseQtyProperty.indexOf(".") > -1) {
            realBaseQtyProperty = baseQtyProperty.substring(baseQtyProperty.lastIndexOf(".") + 1);
        }
        if (!StringUtil.isEmpty((String)qtyProperty) && qtyProperty.indexOf(".") > -1) {
            realQtyProperty = qtyProperty.substring(qtyProperty.lastIndexOf(".") + 1);
        }
        if (!StringUtil.isEmpty((String)assistQtyProperty) && assistQtyProperty.indexOf(".") > -1) {
            realAssistQtyProperty = assistQtyProperty.substring(qtyProperty.lastIndexOf(".") + 1);
        }
        if (StringUtil.isEmpty((String)realBaseQtyProperty) || StringUtil.isEmpty((String)realQtyProperty)) {
            return entryList;
        }
        BigDecimal zero = BigDecimal.ZERO;
        boolean isQtyEnough = false;
        BigDecimal totalBaseQty = BigDecimal.ZERO;
        BigDecimal curRowBaseQty = BigDecimal.ZERO;
        BigDecimal curRowQty = BigDecimal.ZERO;
        BigDecimal curRowAssistQty = BigDecimal.ZERO;
        BigDecimal rowBaseQty = baseQty = billEntryInfo.getBigDecimal(realBaseQtyProperty) == null ? BigDecimal.ZERO : billEntryInfo.getBigDecimal(realBaseQtyProperty);
        BigDecimal rowQty = billEntryInfo.getBigDecimal(realQtyProperty) == null ? BigDecimal.ZERO : billEntryInfo.getBigDecimal(realQtyProperty);
        boolean isQtyRemain = !this.isIssue && baseQty.compareTo(BigDecimal.ZERO) != 0;
        baseQty = baseQty.abs();
        BigDecimal qty = billEntryInfo.getBigDecimal(realQtyProperty) == null ? BigDecimal.ZERO : billEntryInfo.getBigDecimal(realQtyProperty).abs();
        BigDecimal assistQty = billEntryInfo.getBigDecimal(realAssistQtyProperty) == null ? BigDecimal.ZERO : billEntryInfo.getBigDecimal(realAssistQtyProperty).abs();
        BigDecimal realBaseQty = BigDecimal.ZERO;
        BigDecimal realQty = BigDecimal.ZERO;
        int size = results.size();
        for (int index = 0; index < size; ++index) {
            MeasureUnitInfo assistUnit;
            if (index != 0) {
                value = (CoreBillEntryBaseInfo)cloneValue.clone();
                if (billEntryInfo.getBOSType() != null) {
                    BOSUuid id = BOSUuid.create((String)billEntryInfo.getBOSType().toString());
                    value.put("id", (Object)id);
                }
            }
            hmResult = results.get(index);
            curRowBaseQty = BigDecimal.ZERO;
            if (hmResult.get("FBaseQty") instanceof BigDecimal) {
                curRowBaseQty = (BigDecimal)hmResult.get("FBaseQty");
            }
            if (curRowBaseQty.compareTo(BigDecimal.ZERO) < 0) {
                curRowBaseQty = BigDecimal.ZERO;
            }
            curRowQty = BigDecimal.ZERO;
            if (hmResult.get("FCurStoreQty") instanceof BigDecimal) {
                curRowQty = (BigDecimal)hmResult.get("FCurStoreQty");
            }
            if (curRowQty.compareTo(BigDecimal.ZERO) < 0) {
                curRowQty = BigDecimal.ZERO;
            }
            if ((assistUnit = (MeasureUnitInfo)billEntryInfo.get("assistunit")) != null) {
                if (baseQty.compareTo(zero) == 0) {
                    curRowAssistQty = (BigDecimal)hmResult.get("FCurStoreAssistQty");
                } else if (this.isIssue) {
                    curRowAssistQty = assistQty.compareTo(zero) != 0 && results.size() == 1 && curRowBaseQty.compareTo(baseQty) >= 0 ? assistQty : (totalBaseQty.add(curRowBaseQty).compareTo(baseQty) > 0 ? this.getQtyFromBaseQty(this.materialID, assistUnit.getId().toString(), baseQty.subtract(totalBaseQty)) : (BigDecimal)hmResult.get("FCurStoreAssistQty"));
                } else {
                    curRowAssistQty = assistQty;
                    if (assistQty.compareTo(zero) == 0) {
                        curRowAssistQty = this.getQtyFromBaseQty(this.materialID, assistUnit.getId().toString(), baseQty);
                    }
                }
                if (curRowBaseQty.compareTo(zero) == 0 && (this.isIssue || assistQty.compareTo(zero) <= 0)) {
                    curRowAssistQty = BigDecimal.ZERO;
                }
            }
            if (baseQty.compareTo(BigDecimal.ZERO) > 0 && totalBaseQty.add(curRowBaseQty).compareTo(baseQty) >= 0) {
                isQtyEnough = true;
                curRowBaseQty = baseQty.subtract(totalBaseQty);
            } else {
                realBaseQty = baseQty.subtract(totalBaseQty);
                totalBaseQty = totalBaseQty.add(curRowBaseQty);
                realQty = this.getQtyFromBaseQty(this.materialID, (String)hmResult.get("FUnitIDpk_hide"), realBaseQty);
            }
            curRowQty = this.getQtyFromBaseQty(this.materialID, (String)hmResult.get("FUnitIDpk_hide"), curRowBaseQty);
            Set<String> f12InvFileds = this.getNotReturnValueFileds();
            String invField = null;
            String billProperty = null;
            int hsize = this.tableHeadKeyList.size();
            for (int i = 0; i < hsize; ++i) {
                invField = (String)this.tableHeadKeyList.get(i);
                billProperty = (String)this.mapping.get(invField);
                if (f12InvFileds.contains(invField) && index == 0) {
                    value.put("f12Inv", hmResult);
                    this.billPropertys.put(invField, billProperty);
                    continue;
                }
                this.putData(billProperty, invField, hmResult, (IObjectValue)value);
            }
            this.setInvUpdateType((IObjectValue)value);
            value.put(realBaseQtyProperty, (Object)curRowBaseQty);
            value.put(realQtyProperty, (Object)curRowQty);
            value.put(realAssistQtyProperty, (Object)curRowAssistQty);
            if (isQtyRemain) {
                value.put(realBaseQtyProperty, (Object)rowBaseQty);
                value.put(realQtyProperty, (Object)rowQty);
            }
            entryList.add(value);
            if (isQtyEnough || !this.isIssue) break;
        }
        if (this.isIssue) {
            if (baseQty.compareTo(BigDecimal.ZERO) <= 0) {
                isQtyEnough = true;
            }
            this.confirmSetAndBack(isQtyEnough, entryList, realBaseQty, realQty, assistQty, realBaseQtyProperty, realQtyProperty, realAssistQtyProperty);
        }
        return entryList;
    }

    private void confirmSetAndBack(boolean isQtyEnough, List<CoreBillEntryBaseInfo> entryList, BigDecimal realBaseQty, BigDecimal realQty, BigDecimal realAssistQty, String baseQtyProperty, String qtyProperty, String realAssistQtyProperty) {
        if (CollectionUtil.isEmpty(entryList)) {
            return;
        }
        if (isQtyEnough) {
            return;
        }
        int ret = MsgBox.showConfirm2((Component)this.owner, (String)ResourceUtil.getMessage((String)"com.kingdee.eas.scm.im.inv.InvAddResource", (String)"InvQty_Confirm"));
        if (ret != 0) {
            HashMap hmResult;
            int index = entryList.size() - 1;
            CoreBillEntryBaseInfo entryInfo = entryList.get(index);
            entryInfo.put(baseQtyProperty, (Object)realBaseQty);
            entryInfo.put(qtyProperty, (Object)realQty);
            entryInfo.put(realAssistQtyProperty, (Object)realAssistQty);
            Object hmResultO = entryInfo.get("f12Inv");
            HashMap hashMap = hmResult = hmResultO == null ? null : (HashMap)hmResultO;
            if (hmResult != null) {
                Set<String> fieldsSet = this.getNotReturnValueFileds();
                Iterator<String> it = fieldsSet.iterator();
                String f12Filed = null;
                while (it.hasNext()) {
                    f12Filed = it.next();
                    entryInfo.put(this.billPropertys.get(f12Filed), hmResult.get(f12Filed));
                }
            }
        }
    }

    private void putData(String billProperty, String invField, Map<String, Object> hmResult, IObjectValue billEntryInfo) throws BOSException, EASBizException {
        if (billProperty == null || billProperty.indexOf(".") == -1 || invField == null) {
            return;
        }
        boolean isInvUpdateType = this.isInvUpdateType();
        Object obj = null;
        String key = invField + "pk_hide";
        if (hmResult.get(key) != null) {
            if (isInvUpdateType && (invField.equals("FStoreTypeID") || invField.equals("FStoreStatusID"))) {
                billEntryInfo.put(invField, hmResult.get(key));
            } else {
                String id = hmResult.get(key).toString();
                ICoreBase coreBase = this.getICoreBase(invField, id);
                try {
                    obj = coreBase.getValue((IObjectPK)new ObjectUuidPK(id));
                }
                catch (BOSException e) {
                    BOSObjectType bosObjectType = null;
                    bosObjectType = this.linkPropBosTypeMap.get(invField) != null ? BOSObjectType.create((String)((String)this.linkPropBosTypeMap.get(invField))) : BOSUuid.read((String)id).getType();
                    obj = DynamicObjectFactory.getRemoteInstance().getValue(bosObjectType, (IObjectPK)new ObjectUuidPK(id));
                }
                catch (EASBizException e) {
                    BOSObjectType bosObjectType = null;
                    bosObjectType = this.linkPropBosTypeMap.get(invField) != null ? BOSObjectType.create((String)((String)this.linkPropBosTypeMap.get(invField))) : BOSUuid.read((String)id).getType();
                    obj = DynamicObjectFactory.getRemoteInstance().getValue(bosObjectType, (IObjectPK)new ObjectUuidPK(id));
                }
            }
        } else {
            BigDecimal qty;
            obj = hmResult.get(invField);
            if (invField.equals("FCurStoreQty") && obj instanceof BigDecimal && BigDecimal.ZERO.compareTo(qty = (BigDecimal)obj) > 0) {
                obj = BigDecimal.ZERO;
            }
        }
        if (billProperty.startsWith("__src")) {
            billProperty = billProperty.substring(billProperty.indexOf(".") + 1);
        }
        String[] str = billProperty.split("\\.");
        if (this.entryName == null) {
            this.entryName = str[0];
        }
        if (str.length > 2) {
            if (!"invUpdateType".equals(str[str.length - 1]) && obj != null) {
                billEntryInfo.put(str[str.length - 1], obj);
            }
        } else if (!"invUpdateType".equals(str[1]) && obj != null) {
            billEntryInfo.put(str[1], obj);
        }
    }

    @Override
    protected String getQuerySQL(String bosType, IObjectValue billInfo, IObjectValue billEntryInfo) throws Exception {
        this.initDefaultProperty();
        MaterialInfo materialInfo = (MaterialInfo)billEntryInfo.get("material");
        boolean isTrack = false;
        boolean isProject = false;
        String invField = null;
        String val = null;
        StringBuilder sqlSelect = this.getDefaultSelectSQL();
        StringBuilder sqlFrom = this.getDefaultFromSQL();
        StringBuilder sqlWhere = this.getDefaultWhereSQL();
        StringBuilder supplierBuffer = new StringBuilder();
        StringBuilder customerBuffer = new StringBuilder();
        String linkTable = null;
        String tableAlias = null;
        BalanceFieldModelCollection coll = this.getBalanceFieldModelCollInOrder();
        BalanceFieldModelInfo fieldInfo = null;
        this.tableHeadKeyList.clear();
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            fieldInfo = coll.get(i);
            if (fieldInfo.getBizDataType() == BizDataTypeEnum.AssistInfo && !fieldInfo.isIsSPvisible()) continue;
            invField = fieldInfo.getFieldName();
            if (DataTypeEnum.Boolean.equals((Object)fieldInfo.getDataType())) {
                this.boolPropSet.add(invField);
            } else if (DataTypeEnum.BOSUuid.equals((Object)fieldInfo.getDataType())) {
                this.linkPropBosTypeMap.put(invField, fieldInfo.getBaseDataBOSType());
            }
            if (this.defaultProperty.contains(invField)) {
                if (invField.equalsIgnoreCase("FMaterialID")) {
                    this.tableHeadKeyList.add("materialHelpCode");
                    this.tableHeadKeyList.add(invField);
                    this.resMap.put("materialHelpCode", ResourceUtil.getMessage((String)"com.kingdee.eas.scm.im.inv.invconfig.BillInventoryResource", (String)"MaterialHelpCode"));
                    this.resMap.put(invField, fieldInfo.getAlias());
                } else if (invField.equalsIgnoreCase("FLot")) {
                    this.tableHeadKeyList.add(invField);
                    this.tableHeadKeyList.add("FMfg");
                    this.tableHeadKeyList.add("FExp");
                    this.resMap.put(invField, fieldInfo.getAlias());
                    this.resMap.put("FMfg", ResourceUtil.getMessage((String)"com.kingdee.eas.scm.im.inv.invconfig.BillInventoryResource", (String)"mfg"));
                    this.resMap.put("FExp", ResourceUtil.getMessage((String)"com.kingdee.eas.scm.im.inv.invconfig.BillInventoryResource", (String)"exp"));
                } else {
                    this.tableHeadKeyList.add(invField);
                    this.resMap.put(invField, fieldInfo.getAlias());
                    if (DataTypeEnum.BOSUuid.equals((Object)fieldInfo.getDataType()) && fieldInfo.getBaseDataBOSType() != null) {
                        this.tableHeadKeyList.add(invField + "pk_hide");
                    }
                }
            } else {
                tableAlias = "t" + i;
                this.tableHeadKeyList.add(invField);
                this.resMap.put(invField, fieldInfo.getAlias());
                if (DataTypeEnum.BOSUuid.equals((Object)fieldInfo.getDataType())) {
                    sqlSelect.append(", ").append(tableAlias).append(".fname_").append(this.loc).append(" as ").append(invField).append(" \r\n");
                    sqlSelect.append(", ").append(tableAlias).append(".fid as ").append(invField + "pk_hide").append(" \r\n");
                    IMetaDataLoader imeataLoader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
                    IMetaDataPK pk = imeataLoader.getEntityObjectPK(BOSObjectType.create((String)fieldInfo.getBaseDataBOSType()));
                    EntityObjectInfo entityObjInfo = imeataLoader.getEntity(pk);
                    linkTable = entityObjInfo.getTable().getName();
                    sqlFrom.append(" left join ").append(linkTable).append(" as ").append(tableAlias).append(" on inventory.").append(invField).append("=").append(tableAlias).append(".fid \r\n");
                    this.tableHeadKeyList.add(invField + "pk_hide");
                } else {
                    sqlSelect.append(", INVENTORY.").append(invField);
                }
            }
            Object propValue = this.propMap.get(invField);
            val = this.getPropStringValue(propValue);
            if (StringUtil.isEmpty((String)val)) continue;
            if (invField.equals("FSupplierID")) {
                supplierBuffer.append(" and inventory.").append(invField).append("='").append(val).append("'");
                continue;
            }
            if (invField.equals("FCustomerID")) {
                customerBuffer.append(" and inventory.").append(invField).append("='").append(val).append("'");
                continue;
            }
            if (propValue instanceof Date) {
                sqlWhere.append(" and inventory.").append(invField).append("= to_date('").append(val).append("')");
                continue;
            }
            if (invField.equals("FUnitID") || invField.equals("FBaseUnitID")) {
                if ((!invField.equals("FBaseUnitID") || !this.isUpdateByBaseUnit) && (!invField.equals("FUnitID") || this.isUpdateByBaseUnit)) continue;
                sqlWhere.append(" and inventory.").append(invField).append("='").append(val).append("'");
                continue;
            }
            if (invField.equals("FTrackNumberID")) {
                if (!invField.equals("FTrackNumberID") || !isTrack) continue;
                sqlWhere.append(" and inventory.").append(invField).append("='").append(val).append("'");
                continue;
            }
            if (invField.equals("FProjectID")) {
                if (!invField.equals("FProjectID") || !isProject) continue;
                sqlWhere.append(" and inventory.").append(invField).append("='").append(val).append("'");
                continue;
            }
            if (invField.equals("FStorageOrgUnitID")) {
                isTrack = this.isTrackNumberOrProjectNumberFilter(materialInfo, "FTrackNumber", val);
                isProject = this.isTrackNumberOrProjectNumberFilter(materialInfo, "FProjectNumber", val);
                sqlWhere.append(" and inventory.").append(invField).append("='").append(this.sou == null ? val : this.sou.getId().toString()).append("'");
                continue;
            }
            val = StringUtils.replace((String)val, (String)"'", (String)"''");
            sqlWhere.append(" and inventory.").append(invField).append("='").append(val).append("'");
        }
        this.tableHeadKeyList.remove("FCompanyOrgUnitID");
        this.tableHeadKeyList.remove("FCompanyOrgUnitIDpk_hide");
        this.tableHeadKeyList.remove("FMaterialID");
        this.tableHeadKeyList.remove("FMaterialIDpk_hide");
        this.tableHeadKeyList.remove("FBaseUnitID");
        this.tableHeadKeyList.remove("FBaseUnitIDpk_hide");
        this.tableHeadKeyList.remove("FAmount");
        this.tableHeadKeyList.remove("FLockAssistQty");
        this.tableHeadKeyList.remove("FID");
        this.tableHeadKeyList.remove("FBillEntryID");
        this.tableHeadKeyList.add("FReservationQty");
        this.tableHeadKeyList.add("FReservationBaseQty");
        this.tableHeadKeyList.add("FReservationAssistQty");
        this.tableHeadKeyList.remove("FEntrySeq");
        this.resMap.put("FReservationQty", ResourceUtil.getMessage((String)"com.kingdee.eas.scm.im.inv.invconfig.BillInventoryResource", (String)"reservationQty"));
        this.resMap.put("FReservationBaseQty", ResourceUtil.getMessage((String)"com.kingdee.eas.scm.im.inv.invconfig.BillInventoryResource", (String)"reservationBaseQty"));
        this.resMap.put("FReservationAssistQty", ResourceUtil.getMessage((String)"com.kingdee.eas.scm.im.inv.invconfig.BillInventoryResource", (String)"reservationAssistQty"));
        this.resMap.put("FCurStoreQty", ResourceUtil.getMessage((String)"com.kingdee.eas.scm.im.inv.invconfig.BillInventoryResource", (String)"realQty"));
        this.resMap.put("FCurStoreAssistQty", ResourceUtil.getMessage((String)"com.kingdee.eas.scm.im.inv.invconfig.BillInventoryResource", (String)"realAssistQty"));
        this.resMap.put("FBaseQty", ResourceUtil.getMessage((String)"com.kingdee.eas.scm.im.inv.invconfig.BillInventoryResource", (String)"realBaseQty"));
        this.resMap.put("boolFieldSet", this.boolPropSet);
        StringBuilder sb = this.getSupCustomerWhereSQL(supplierBuffer, customerBuffer, billEntryInfo);
        if (sb.length() > 0) {
            sqlWhere.append((CharSequence)sb);
        }
        StringBuilder sql = new StringBuilder();
        this.initPermissionSQL();
        sql.append((CharSequence)sqlSelect).append((CharSequence)sqlFrom);
        if (!StringUtil.isEmpty((String)this.permissionJoinSQL)) {
            sql.append(this.permissionJoinSQL);
        }
        sql.append((CharSequence)sqlWhere);
        if (!StringUtil.isEmpty((String)this.permissionSQL)) {
            this.permissionSQL = this.permissionSQL.replaceAll("\"T6\".\"FNUMBER\"", "warehouse.fnumber");
            this.permissionSQL = this.permissionSQL.replaceAll("\"T7\".\"FNUMBER\"", "location.fnumber");
            this.permissionSQL = this.permissionSQL.replaceAll("\"T12\".\"FNUMBER\"", "material.fnumber");
            sql.append(" and ").append(this.permissionSQL);
        }
        return sql.toString();
    }

    protected boolean isTrackNumberOrProjectNumberFilter(MaterialInfo materialInfo, String trOrPr, String val) throws EASBizException, BOSException {
        if (materialInfo == null) {
            return false;
        }
        IMaterialInventory iMaterialInventory = MaterialInventoryFactory.getRemoteInstance();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("where material.id = '").append(materialInfo.getId().toString()).append("' and orgUnit.id = '").append(val).append("'").append(" and STATUS = 1");
        if (!iMaterialInventory.exists(stringBuffer.toString())) {
            throw new InvBizException(InvBizException.COMMON, new Object[]{ResourceUtil.getMessage((String)"com.kingdee.eas.scm.im.inv.WarehsManageResource", (String)"materialInventoryNotMaintenance") + "\n" + materialInfo.getNumber()});
        }
        MaterialInventoryInfo inventoryInfo = iMaterialInventory.getMaterialInventoryInfo(stringBuffer.toString());
        if (trOrPr.equals("FTrackNumber")) {
            return inventoryInfo.isIsTrackingNumber();
        }
        if (trOrPr.equals("FProjectNumber")) {
            return inventoryInfo.isIsProjectNumber();
        }
        return false;
    }

    @Override
    protected StringBuilder getDefaultSelectSQL() {
        StringBuilder sb = new StringBuilder();
        sb.append(" SELECT INVENTORY.FID AS FID, \r\n");
        sb.append(" MATERIAL.FAssistAttr AS MATERIALASSISTATTR,  \r\n");
        sb.append(" STORAGEORGUNIT.FID AS FStorageOrgUnitIDpk_hide, \r\n");
        sb.append(" STORAGEORGUNIT.FName_").append(this.loc).append(" AS FStorageOrgUnitID,  \r\n");
        sb.append(" WAREHOUSE.FName_").append(this.loc).append(" AS FWarehouseID, \r\n");
        sb.append(" LOCATION.FName_").append(this.loc).append(" AS FLocationID,  \r\n");
        sb.append(" STORETYPE.FName_").append(this.loc).append(" AS FStoreTypeID,  \r\n");
        sb.append(" UNIT.FName_").append(this.loc).append(" AS FUnitID, \r\n");
        sb.append(" UNIT.FID AS FUnitIDpk_hide, \r\n");
        sb.append(" ASSISTUNIT.FName_").append(this.loc).append(" AS FAssistUnitID,  \r\n");
        sb.append(" ASSISTUNIT.FID AS FAssistUnitIDpk_hide,  \r\n");
        sb.append(" ROUND(INVENTORY.FCurStoreQty ");
        sb.append(" - ");
        sb.append(" ISNULL(DECIMAL((RESERVATION.FReservationBaseQty / MULTIUNIT.FBaseConvsRate), 21, 8), 0), MULTIUNIT.FQtyPrecision) ");
        sb.append(" AS FCurStoreQty,  \r\n");
        sb.append(" ROUND(INVENTORY.FCurStoreAssistQty - ISNULL(RESERVATION.FReservationAssistQty, 0), ISNULL(MULTIASSISTUNIT.FQtyPrecision,0)) AS FCurStoreAssistQty,  \r\n");
        sb.append(" ROUND(INVENTORY.FBaseQty - ISNULL(RESERVATION.FReservationBaseQty, 0), ISNULL(MULTIBASEUNIT.FQtyPrecision,0)) AS FBaseQty,   \r\n");
        sb.append(" MATERIAL.FModel AS MATERIALMODEL,   \r\n");
        sb.append(" STORESTATUS.FNumber AS STORESTATUSNUMBER,  \r\n");
        sb.append(" STORESTATUS.FName_").append(this.loc).append(" AS FStoreStatusID,   \r\n");
        sb.append(" MATERIAL.FName_").append(this.loc).append(" AS MATERIALNAME,   \r\n");
        sb.append(" MATERIAL.FNumber AS MATERIALNUMBER,  \r\n");
        sb.append(" MATERIAL.FHelpCode AS materialHelpCode, \r\n");
        sb.append(" INVENTORY.FMaterialID AS MATERIALID,   \r\n");
        sb.append(" FBASEUNIT.FName_").append(this.loc).append(" AS FBaseUnitID, \r\n");
        sb.append(" MULTIBASEUNIT.FQtyPrecision AS MULTIBASEUNITQTYPRECISION,   \r\n");
        sb.append(" MULTIASSISTUNIT.FQtyPrecision AS MULTIASSISTUNITQTYPRECISION,   \r\n");
        sb.append(" MULTIUNIT.FQtyPrecision AS MULTIUNITQTYPRECISION,   \r\n");
        sb.append(" CASE  WHEN INVENTORY.FLot = '").append("YNi0IQEOEADgBT3mfwAAAcznrtQ=").append("' THEN NULL ELSE INVENTORY.FLot END AS FLot,    \r\n");
        sb.append(" PROJECT.FNumber AS FProjectID,   \r\n");
        sb.append(" TRACKNUMBER.FNumber AS FTrackNumberID,    \r\n");
        sb.append(" CASE  WHEN INVENTORY.FAssistPropertyID = '").append("EgkAAAA5EWALxvQu").append("' THEN NULL ELSE INVENTORY.FAssistPropertyID END AS FAssistPropertyIDpk_hide,   \r\n");
        sb.append(" ASSISTPROPERTY.FNumber AS ASSISTPROPERTYNUMBER,    \r\n");
        sb.append(" ASSISTPROPERTY.FName_").append(this.loc).append(" AS FAssistPropertyID,    \r\n");
        sb.append(" SUPPLIER.FName_").append(this.loc).append(" AS FSupplierID,    \r\n");
        sb.append(" CUSTOMER.FName_").append(this.loc).append(" AS FCustomerID,    \r\n");
        sb.append(" ISNULL(ROUND(RESERVATION.FReservationQty, MULTIUNIT.FQtyPrecision), 0) AS FReservationQty,   \r\n");
        sb.append(" ISNULL(ROUND(RESERVATION.FReservationBaseQty, MULTIBASEUNIT.FQtyPrecision), 0) AS FReservationBaseQty,   \r\n");
        sb.append(" ISNULL(ROUND(RESERVATION.FReservationAssistQty, MULTIBASEUNIT.FQtyPrecision), 0) AS FReservationAssistQty,   \r\n");
        sb.append(" CASE  WHEN INVENTORY.FLocationID = '").append("EgkAAABc3XMgX/hq").append("' THEN NULL ELSE INVENTORY.FLocationID END AS FLocationIDpk_hide,   \r\n");
        sb.append(" CASE  WHEN INVENTORY.FWarehouseID = '").append("EgkAAABc3XG76fiu").append("' THEN NULL ELSE INVENTORY.FWarehouseID END AS FWarehouseIDpk_hide,    \r\n");
        sb.append(" WAREHOUSE.FHasLocation AS WAREHOUSEHASLOCATION,    \r\n");
        sb.append(" CASE  WHEN INVENTORY.FSupplierID = '").append("EgkAAABc3Xo3xn38").append("' THEN NULL ELSE INVENTORY.FSupplierID END AS FSupplierIDpk_hide,    \r\n");
        sb.append(" CASE  WHEN INVENTORY.FCustomerID = '").append("EgkAAABc3Xu/DAQO").append("' THEN NULL ELSE INVENTORY.FCustomerID END AS FCustomerIDpk_hide,   \r\n");
        sb.append(" INVENTORY.FUnitID AS FUnitIDpk_hide,    \r\n");
        sb.append(" INVENTORY.FStoreTypeID AS FStoreTypeIDpk_hide,     \r\n");
        sb.append(" INVENTORY.FStoreStatusID AS FStoreStatusIDpk_hide,    \r\n");
        sb.append(" CASE  WHEN INVENTORY.FProjectID = '").append("EgkAAABc3Xza3gXu").append("' THEN NULL ELSE INVENTORY.FProjectID END AS FProjectIDpk_hide,     \r\n");
        sb.append(" CASE  WHEN INVENTORY.FTrackNumberID = '").append("EgkAAABc3X0Ibpg9").append("' THEN NULL ELSE INVENTORY.FTrackNumberID END AS FTrackNumberIDpk_hide,    \r\n");
        sb.append(" ROUND(DECIMAL((INVENTORY.FBaseQty / MULTIINVENTORYUNIT.FBaseConvsRate), 21, 8), MULTIINVENTORYUNIT.FQtyPrecision) AS CURMATSTOREQTY,      \r\n");
        sb.append(" MULTIINVENTORYUNIT.FQtyPrecision AS MULTIINVENTORYUNITQTYPRECIS43,    \r\n");
        sb.append(" DATEOFMINDURABILITY.FMfg AS FMFG,     \r\n");
        sb.append(" DATEOFMINDURABILITY.FExp AS FEXP    \r\n");
        return sb;
    }

    @Override
    protected StringBuilder getDefaultFromSQL() {
        StringBuilder sb = new StringBuilder();
        sb.append(" FROM T_IM_Inventory AS INVENTORY \r\n");
        sb.append(" LEFT OUTER JOIN T_BD_Supplier AS SUPPLIER ON INVENTORY.FSupplierID = SUPPLIER.FID \r\n");
        sb.append(" LEFT OUTER JOIN T_IM_STORESTATE AS STORESTATUS ON INVENTORY.FStoreStatusID = STORESTATUS.FID \r\n");
        sb.append(" LEFT OUTER JOIN T_IM_STORETYPE AS STORETYPE ON INVENTORY.FStoreTypeID = STORETYPE.FID \r\n");
        sb.append(" LEFT OUTER JOIN T_DB_LOCATION AS LOCATION ON INVENTORY.FLocationID = LOCATION.FID \r\n");
        sb.append(" LEFT OUTER JOIN T_DB_WAREHOUSE AS WAREHOUSE ON INVENTORY.FWarehouseID = WAREHOUSE.FID \r\n");
        sb.append(" INNER JOIN T_ORG_Storage AS STORAGEORGUNIT ON INVENTORY.FStorageOrgUnitID = STORAGEORGUNIT.FID \r\n");
        sb.append(" INNER JOIN T_ORG_Company AS COMPANYORGUNIT ON INVENTORY.FCompanyOrgUnitID = COMPANYORGUNIT.FID \r\n");
        sb.append(" LEFT OUTER JOIN T_BD_Material AS MATERIAL ON INVENTORY.FMaterialID = MATERIAL.FID \r\n");
        sb.append(" LEFT OUTER JOIN T_BD_MeasureUnit AS UNIT ON INVENTORY.FUnitID = UNIT.FID \r\n");
        sb.append(" LEFT OUTER JOIN T_BD_MeasureUnit AS ASSISTUNIT ON INVENTORY.FAssistUnitID = ASSISTUNIT.FID \r\n");
        sb.append(" LEFT OUTER JOIN T_BD_MultiMeasureUnit AS MULTIBASEUNIT ON INVENTORY.FMaterialID = MULTIBASEUNIT.FMaterialID AND INVENTORY.FBaseUnitID = MULTIBASEUNIT.FMeasureUnitID \r\n");
        sb.append(" LEFT OUTER JOIN T_BD_MultiMeasureUnit AS MULTIASSISTUNIT ON INVENTORY.FMaterialID = MULTIASSISTUNIT.FMaterialID AND INVENTORY.FAssistUnitID = MULTIASSISTUNIT.FMeasureUnitID \r\n");
        sb.append(" LEFT OUTER JOIN T_BD_MultiMeasureUnit AS MULTIUNIT ON INVENTORY.FMaterialID = MULTIUNIT.FMaterialID AND INVENTORY.FUnitID = MULTIUNIT.FMeasureUnitID \r\n");
        sb.append(" LEFT OUTER JOIN T_BD_AsstAttrValue AS ASSISTPROPERTY ON INVENTORY.FAssistPropertyID = ASSISTPROPERTY.FID \r\n");
        sb.append(" LEFT OUTER JOIN T_BD_Customer AS CUSTOMER ON INVENTORY.FCustomerID = CUSTOMER.FID \r\n");
        sb.append(" LEFT OUTER JOIN T_MM_Project AS PROJECT ON INVENTORY.FProjectID = PROJECT.FID \r\n");
        sb.append(" LEFT OUTER JOIN T_MM_TrackNumber AS TRACKNUMBER ON INVENTORY.FTrackNumberID = TRACKNUMBER.FID \r\n");
        sb.append(" LEFT OUTER JOIN T_BD_MaterialInventory AS MATLINVENTORY ON INVENTORY.FStorageOrgUnitID = MATLINVENTORY.FOrgUnit AND INVENTORY.FMaterialID = MATLINVENTORY.FMaterialID \r\n");
        sb.append(" LEFT OUTER JOIN T_IM_DateOfMinDurability AS DATEOFMINDURABILITY ON INVENTORY.FStorageOrgUnitID = DATEOFMINDURABILITY.FStorageOrgUnitID AND INVENTORY.FMaterialID = DATEOFMINDURABILITY.FMaterialID AND INVENTORY.FLot = DATEOFMINDURABILITY.FLot \r\n");
        sb.append(" LEFT OUTER JOIN T_BD_MeasureUnit AS FBASEUNIT ON MATERIAL.FBaseUnit = FBASEUNIT.FID \r\n");
        sb.append(" LEFT OUTER JOIN T_BD_MeasureUnit AS INVENTORYUNIT ON MATLINVENTORY.FUnitID = INVENTORYUNIT.FID \r\n");
        sb.append(" LEFT OUTER JOIN T_BD_MultiMeasureUnit AS MULTIINVENTORYUNIT ON MATLINVENTORY.FMaterialID = MULTIINVENTORYUNIT.FMaterialID AND MATLINVENTORY.FUnitID = MULTIINVENTORYUNIT.FMeasureUnitID \r\n");
        sb.append((CharSequence)this.getReservationSQL());
        return sb;
    }

    @Override
    protected StringBuilder getDefaultWhereSQL() {
        StringBuilder sb = new StringBuilder();
        sb.append(" WHERE (ROUND(INVENTORY.FCurStoreQty  -  ISNULL(DECIMAL((RESERVATION.FReservationBaseQty / MULTIUNIT.FBaseConvsRate), 21, 8), 0), MULTIUNIT.FQtyPrecision) <> 0) ");
        return sb;
    }

    protected void initPermissionSQL() throws BOSException {
        if (this.sou == null) {
            return;
        }
        HashSet<String> ids = new HashSet<String>();
        ids.add(this.sou.getId().toString());
        Map permMap = SCMBillCommonFacadeFactory.getRemoteInstance().getPermissionEntityViewMap(ids, null);
        this.permissionSQL = (String)permMap.get("PERM_WHERE");
        this.permissionJoinSQL = (String)permMap.get("PERM_JOIN");
    }

    private void setIsIssue(TransactionTypeInfo transTypeInfo) {
        RecIssueTypeInfo riType = transTypeInfo.getRiType();
        if (riType == null || riType.getRI() == null || riType.getBizDirection() == null) {
            return;
        }
        RIEnum ri = riType.getRI();
        if (ri == null || ri == RIEnum.NoRI) {
            ri = transTypeInfo.getRI();
        }
        com.kingdee.eas.basedata.scm.im.inv.BizDirectionEnum bizDirection = riType.getBizDirection();
        if (ri == RIEnum.Receive && bizDirection == com.kingdee.eas.basedata.scm.im.inv.BizDirectionEnum.back || ri == RIEnum.Issue && bizDirection == com.kingdee.eas.basedata.scm.im.inv.BizDirectionEnum.normal) {
            this.isIssue = true;
        }
    }

    private Set<String> getNotReturnValueFileds() {
        String[] fields = new String[]{"FCurStoreAssistQty"};
        return new HashSet<String>(Arrays.asList(fields));
    }

    @Override
    protected BalanceFieldModelCollection getBalanceFieldModelCollInOrder() throws Exception {
        BalanceFieldModelCollection coll = BalanceCfgUtil.getBalanceFieldModelColl(null);
        BalanceFieldModelCollection orderColl = new BalanceFieldModelCollection();
        Object[] orderFields = this.getMaterialQueryOrderFields();
        if (ArrayUtil.isEmpty((Object[])orderFields)) {
            orderColl = coll;
        } else {
            Object field2 = null;
            BalanceFieldModelInfo fieldInfo = null;
            for (Object field2 : orderFields) {
                fieldInfo = this.getBalanceFieldModelInfo(coll, (String)field2);
                if (fieldInfo == null) continue;
                orderColl.add(fieldInfo);
                coll.remove(fieldInfo);
            }
            if (!CollectionUtil.isEmpty((AbstractObjectCollection)coll)) {
                orderColl.addCollection(coll);
            }
        }
        return orderColl;
    }

    private BalanceFieldModelInfo getBalanceFieldModelInfo(BalanceFieldModelCollection coll, String fieldName) {
        BalanceFieldModelInfo fieldInfo = null;
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            fieldInfo = coll.get(i);
            if (!fieldName.equals(fieldInfo.getFieldName())) continue;
            return fieldInfo;
        }
        return null;
    }

    protected String[] getMaterialQueryOrderFields() {
        String[] orderFields = new String[]{"FID", "FCompanyOrgUnitID", "FStorageOrgUnitID", "FWarehouseID", "FLocationID", "FLot", "FStoreTypeID", "FStoreStatusID", "FSupplierID", "FCustomerID", "FMaterialID", "FUnitID", "FBaseUnitID", "FCurStoreQty", "FBaseQty", "FAssistUnitID", "FCurStoreAssistQty", "FAssistPropertyID", "FProjectID", "FTrackNumberID", "FBillEntryID", "FEntrySeq"};
        return orderFields;
    }
}

