/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.invconfig.client;

import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.query.SQLExecutor;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.scm.common.SCMBillBaseInfo;
import com.kingdee.eas.scm.common.SCMBillEntryBaseInfo;
import com.kingdee.eas.scm.common.client.config.MaterialQueryConditionInfo;
import com.kingdee.eas.scm.common.util.StringUtil;
import com.kingdee.eas.scm.framework.balance.BalanceFieldModelCollection;
import com.kingdee.eas.scm.framework.balance.BalanceFieldModelInfo;
import com.kingdee.eas.scm.framework.balance.BizDataTypeEnum;
import com.kingdee.eas.scm.framework.balance.DataTypeEnum;
import com.kingdee.eas.scm.im.inv.MaterialSerialNumberCollection;
import com.kingdee.eas.scm.im.inv.MaterialSerialNumberFactory;
import com.kingdee.eas.scm.im.inv.MaterialSerialNumberInfo;
import com.kingdee.eas.scm.im.inv.client.SerialNumberSelectUI;
import com.kingdee.eas.scm.im.inv.invconfig.client.MaterialQueryHelper;
import com.kingdee.eas.scm.util.filehandle.ResourceUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class SerialNumberHelper
extends MaterialQueryHelper {
    private static final String resFile = "com.kingdee.eas.scm.im.inv.MaterialSNResource";

    public SerialNumberHelper(MaterialQueryConditionInfo materialQueryConditionInfo) {
        super(materialQueryConditionInfo);
    }

    public String actionMaterialQuery4SerialNumber(int snStatus) throws Exception {
        List<String> serialNumberList;
        String errorMessage = null;
        IObjectValue billInfo = this.materialQueryConditionInfo.getBillInfo();
        IObjectValue billEntryInfo = this.materialQueryConditionInfo.getBillEntryInfo();
        SCMBillBaseInfo scmBillBaseInfo = (SCMBillBaseInfo)billInfo;
        SCMBillEntryBaseInfo scmBillEntryBaseInfo = (SCMBillEntryBaseInfo)billEntryInfo;
        String billID = scmBillBaseInfo.getId().toString();
        String billEntryID = scmBillEntryBaseInfo.getId().toString();
        String materialID = scmBillEntryBaseInfo.getMaterial().getId().toString();
        int maxQty = ((BigDecimal)scmBillEntryBaseInfo.get("qty")).abs().intValue();
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("billID", (Object)billID));
        filter.getFilterItems().add(new FilterItemInfo("billEntryID", (Object)billEntryID));
        filter.getFilterItems().add(new FilterItemInfo("material.id", (Object)materialID));
        ev.setFilter(filter);
        ev.getSelector().add(new SelectorItemInfo("snQty"));
        ev.getSelector().add(new SelectorItemInfo("entry.serialNumber"));
        MaterialSerialNumberCollection snColl = MaterialSerialNumberFactory.getRemoteInstance().getMaterialSerialNumberCollection(ev);
        if (snColl != null && snColl.size() > 0) {
            MaterialSerialNumberInfo snInfo = snColl.get(0);
            int snQty = snInfo.getSnQty().intValue();
            maxQty -= snQty;
        }
        String notInSelectSQL = null;
        if (!(StringUtil.isEmpty((String)billID) || StringUtil.isEmpty((String)billEntryID) || StringUtil.isEmpty((String)materialID))) {
            notInSelectSQL = "select t2.fserialnumber as fserialnumber from t_iv_materialserialnumber t1 left outer join t_iv_materialserialnumberentry t2 on t1.fid = t2.fparentid where t1.fbillid = '" + billID + "' and t1.fbillentryid = '" + billEntryID + "' and t1.fmaterialid = '" + materialID + "'";
        }
        if (maxQty <= 0) {
            errorMessage = ResourceUtil.getMessage((String)resFile, (String)"INPUT_COMPLETE");
            return errorMessage;
        }
        String inventoryID = null;
        if (snStatus == 1 || snStatus == 3) {
            String bosType = billInfo.getBOSType().toString();
            String billEntryBosType = billEntryInfo.getBOSType().toString();
            this.buildConfigMapping(bosType, billEntryBosType, billInfo, billEntryInfo, 0);
            String sql = this.getQuerySQL(bosType, billInfo, billEntryInfo);
            IRowSet rs = new SQLExecutor(sql).executeSQL();
            if (rs == null || rs.size() == 0) {
                errorMessage = ResourceUtil.getMessage((String)resFile, (String)"CANNOT_NAVSELECT_NOINVENTORYID");
            } else if (rs.size() > 1) {
                errorMessage = ResourceUtil.getMessage((String)resFile, (String)"CANNOT_NAVSELECT_MOREINVENTORYID");
            } else if (rs.next() && (inventoryID = rs.getString("FID")) == null) {
                errorMessage = "inventoryID is null.";
            }
            if (errorMessage != null && errorMessage.length() > 0) {
                return errorMessage;
            }
        }
        UIContext uiContext = new UIContext((Object)this);
        IUIWindow invUIWin = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(SerialNumberSelectUI.class.getName(), (Map)uiContext, null, OprtState.EDIT);
        SerialNumberSelectUI snListUI = (SerialNumberSelectUI)invUIWin.getUIObject();
        snListUI.actionQuery(inventoryID, materialID, maxQty, notInSelectSQL, snStatus);
        invUIWin.show();
        if (!snListUI.isCanceled() && (serialNumberList = snListUI.getResults()) != null && serialNumberList.size() > 0) {
            MaterialSerialNumberFactory.getRemoteInstance().saveSelectedMaterialSN((SCMBillBaseInfo)billInfo, (SCMBillEntryBaseInfo)billEntryInfo, serialNumberList);
        }
        return errorMessage;
    }

    @Override
    protected String getQuerySQL(String bosType, IObjectValue billInfo, IObjectValue billEntryInfo) throws Exception {
        this.initDefaultProperty();
        String invField = null;
        String val = null;
        boolean isTrack = false;
        boolean isProject = false;
        MaterialInfo materialInfo = (MaterialInfo)billEntryInfo.get("material");
        StringBuilder sqlSelect = this.getDefaultSelectSQL();
        StringBuilder sqlFrom = this.getDefaultFromSQL();
        StringBuilder sqlWhere = this.getDefaultWhereSQL();
        StringBuilder supplierBuffer = new StringBuilder();
        StringBuilder customerBuffer = new StringBuilder();
        String linkTable = null;
        String tableAlias = null;
        BalanceFieldModelCollection coll = this.getBalanceFieldModelCollInOrder();
        BalanceFieldModelInfo fieldInfo = null;
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            Object propValue;
            fieldInfo = coll.get(i);
            if (fieldInfo.getBizDataType() == BizDataTypeEnum.AssistInfo && !fieldInfo.isIsSPvisible()) continue;
            invField = fieldInfo.getFieldName();
            if (!this.defaultProperty.contains(invField)) {
                tableAlias = "t" + i;
                if (DataTypeEnum.BOSUuid.equals((Object)fieldInfo.getDataType())) {
                    IMetaDataLoader imeataLoader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
                    IMetaDataPK pk = imeataLoader.getEntityObjectPK(BOSObjectType.create((String)fieldInfo.getBaseDataBOSType()));
                    EntityObjectInfo entityObjInfo = imeataLoader.getEntity(pk);
                    linkTable = entityObjInfo.getTable().getName();
                    sqlFrom.append(" left join ").append(linkTable).append(" as ").append(tableAlias).append(" on inventory.").append(invField).append("=").append(tableAlias).append(".fid \r\n");
                }
            }
            if (StringUtil.isEmpty((String)(val = this.getPropStringValue(propValue = this.propMap.get(invField))))) continue;
            if (invField.equals("FSupplierID")) {
                supplierBuffer.append(" and inventory.").append(invField).append("='").append(val).append("'");
                continue;
            }
            if (invField.equals("FCustomerID")) {
                customerBuffer.append(" and inventory.").append(invField).append("='").append(val).append("'");
                continue;
            }
            if (propValue instanceof Date) {
                sqlWhere.append(" and inventory.").append(invField).append("= to_date('").append(val).append("')");
                continue;
            }
            if (invField.equals("FUnitID") || invField.equals("FBaseUnitID")) {
                if ((!invField.equals("FBaseUnitID") || !this.isUpdateByBaseUnit) && (!invField.equals("FUnitID") || this.isUpdateByBaseUnit)) continue;
                sqlWhere.append(" and inventory.").append(invField).append("='").append(val).append("'");
                continue;
            }
            if (invField.equals("FTrackNumberID")) {
                if (!invField.equals("FTrackNumberID") || !isTrack) continue;
                sqlWhere.append(" and inventory.").append(invField).append("='").append(val).append("'");
                continue;
            }
            if (invField.equals("FProjectID")) {
                if (!invField.equals("FProjectID") || !isProject) continue;
                sqlWhere.append(" and inventory.").append(invField).append("='").append(val).append("'");
                continue;
            }
            if (invField.equals("FStorageOrgUnitID")) {
                isTrack = this.isTrackNumberOrProjectNumberFilter(materialInfo, "FTrackNumber", val);
                isProject = this.isTrackNumberOrProjectNumberFilter(materialInfo, "FProjectNumber", val);
                sqlWhere.append(" and inventory.").append(invField).append("='").append(val).append("'");
                continue;
            }
            sqlWhere.append(" and inventory.").append(invField).append("='").append(val).append("'");
        }
        StringBuilder sb = this.getSupCustomerWhereSQL(supplierBuffer, customerBuffer, billEntryInfo);
        if (sb.length() > 0) {
            sqlWhere.append((CharSequence)sb);
        }
        StringBuilder sql = new StringBuilder();
        this.initPermissionSQL();
        sql.append((CharSequence)sqlSelect).append((CharSequence)sqlFrom);
        if (!StringUtil.isEmpty((String)this.permissionJoinSQL)) {
            sql.append(this.permissionJoinSQL);
        }
        sql.append((CharSequence)sqlWhere);
        if (!StringUtil.isEmpty((String)this.permissionSQL)) {
            this.permissionSQL = this.permissionSQL.replaceAll("\"T6\".\"FNUMBER\"", "warehouse.fnumber");
            this.permissionSQL = this.permissionSQL.replaceAll("\"T7\".\"FNUMBER\"", "location.fnumber");
            this.permissionSQL = this.permissionSQL.replaceAll("\"T12\".\"FNUMBER\"", "material.fnumber");
            sql.append(" and ").append(this.permissionSQL);
        }
        return sql.toString();
    }

    @Override
    protected StringBuilder getDefaultSelectSQL() {
        StringBuilder sb = new StringBuilder();
        sb.append(" SELECT INVENTORY.FID AS FID ");
        return sb;
    }
}

