/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.invconfig.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.CardinalityType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.RelationshipInfo;
import com.kingdee.bos.metadata.entity.RelationshipType;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.scm.framework.balance.BalanceFieldModelCollection;
import com.kingdee.eas.scm.framework.balance.BalanceModelFactory;
import com.kingdee.eas.scm.framework.balance.BalanceModelInfo;
import com.kingdee.eas.scm.framework.balance.IBalanceModel;
import com.kingdee.eas.scm.im.inv.invconfig.BillInventoryConfigCollection;
import com.kingdee.eas.scm.im.inv.invconfig.BillInventoryConfigEntryCollection;
import com.kingdee.eas.scm.im.inv.invconfig.BillInventoryConfigEntryInfo;
import com.kingdee.eas.scm.im.inv.invconfig.BillInventoryConfigFactory;
import com.kingdee.eas.scm.im.inv.invconfig.BillInventoryConfigInfo;
import com.kingdee.eas.scm.im.inv.invconfig.IBillInventoryConfig;
import com.kingdee.eas.scm.util.collection.CollectionUtil;
import com.kingdee.eas.scm.util.string.StringUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class BalanceCfgUtil {
    private static IMetaDataLoader loader = null;
    private static Map<String, EntityObjectInfo> entityObjectMap = new HashMap<String, EntityObjectInfo>();

    public static BillInventoryConfigInfo getConfigInfo(Context ctx, String bosType, IObjectValue billInfo) throws BOSException {
        BillInventoryConfigCollection coll = BalanceCfgUtil.getConfigColl(ctx, bosType);
        BillInventoryConfigInfo configInfo = null;
        int size = coll.size();
        for (int i = 0; i < size && !BalanceCfgUtil.isMatch(configInfo = coll.get(i), billInfo); ++i) {
        }
        return configInfo;
    }

    public static BillInventoryConfigInfo getConfigInfo(Context ctx, String bosType, String billEntryBosType, IObjectValue billInfo) throws BOSException {
        HashMap<String, String> bosType2EntryName = new HashMap<String, String>();
        return BalanceCfgUtil.getConfigInfo(ctx, bosType, billEntryBosType, billInfo, bosType2EntryName);
    }

    public static BillInventoryConfigInfo getConfigInfo(Context ctx, String bosType, String billEntryBosType, IObjectValue billInfo, Map<String, String> bosType2EntryName) throws BOSException {
        BillInventoryConfigInfo configInfo = BalanceCfgUtil.getConfigInfo(ctx, bosType, billInfo);
        List<String> billEntryBosTypeList = BalanceCfgUtil.getEntryBosTypeList(ctx, bosType, bosType2EntryName);
        if (billEntryBosTypeList.size() > 1) {
            BalanceCfgUtil.processConfigInfo(configInfo, billEntryBosType);
        }
        return configInfo;
    }

    public static void processConfigInfo(BillInventoryConfigInfo configInfo, String billEntryBosType) {
        if (configInfo == null) {
            return;
        }
        BillInventoryConfigEntryCollection newEntryColl = new BillInventoryConfigEntryCollection();
        BillInventoryConfigEntryInfo entryInfo = null;
        int size = configInfo.getEntry().size();
        for (int i = 0; i < size; ++i) {
            entryInfo = configInfo.getEntry().get(i);
            if (entryInfo.getBillEntryBosType() == null || !entryInfo.getBillEntryBosType().equals(billEntryBosType)) continue;
            newEntryColl.add(entryInfo);
        }
        if (newEntryColl.size() > 0) {
            configInfo.put("entry", (Object)newEntryColl);
        }
    }

    public static Map<String, BillInventoryConfigInfo> getConfigInfoMap(Context ctx, CoreBaseCollection billInfoColl, String entryName) throws BOSException {
        if (CollectionUtil.isEmpty((AbstractObjectCollection)billInfoColl)) {
            return null;
        }
        CoreBaseInfo objValue = billInfoColl.get(0);
        String bosType = objValue.getBOSType().toString();
        AbstractObjectCollection objColl = (AbstractObjectCollection)objValue.get(entryName);
        if (objColl == null || objColl.size() == 0) {
            return null;
        }
        String billEntryBosType = objColl.getObject(0).getBOSType().toString();
        List<String> billEntryBosTypeList = BalanceCfgUtil.getEntryBosTypeList(ctx, bosType);
        boolean isNeedProcess = billEntryBosTypeList.size() > 1;
        BillInventoryConfigCollection configColl = BalanceCfgUtil.getConfigColl(ctx, bosType);
        BillInventoryConfigInfo configInfo = null;
        HashMap<String, BillInventoryConfigInfo> configInfoMap = new HashMap<String, BillInventoryConfigInfo>();
        String key = null;
        IObjectValue billInfo = null;
        int isize = billInfoColl.size();
        block0: for (int i = 0; i < isize; ++i) {
            billInfo = billInfoColl.getObject(i);
            int jsize = configColl.size();
            for (int j = 0; j < jsize; ++j) {
                configInfo = configColl.get(j);
                if (!BalanceCfgUtil.isMatch(configInfo, billInfo)) continue;
                key = billInfo.get("id").toString();
                if (isNeedProcess) {
                    BalanceCfgUtil.processConfigInfo(configInfo, billEntryBosType);
                }
                configInfoMap.put(key, configInfo);
                continue block0;
            }
        }
        return configInfoMap;
    }

    public static BillInventoryConfigCollection getConfigColl(Context ctx, String bosType) throws BOSException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("bosType", (Object)bosType, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("status", (Object)1, CompareType.EQUALS));
        SorterItemCollection sic = new SorterItemCollection();
        sic.add(new SorterItemInfo("number"));
        viewInfo.setFilter(filter);
        viewInfo.setSorter(sic);
        IBillInventoryConfig iBillInventoryConfig = ctx == null ? BillInventoryConfigFactory.getRemoteInstance() : BillInventoryConfigFactory.getLocalInstance(ctx);
        BillInventoryConfigCollection coll = iBillInventoryConfig.getBillInventoryConfigCollection(viewInfo);
        return coll;
    }

    private static boolean isMatch(BillInventoryConfigInfo info, IObjectValue billInfo) throws BOSException {
        if (info == null) {
            return false;
        }
        if (StringUtil.isEmpty((String)info.getFilter())) {
            return true;
        }
        return true;
    }

    public static CoreBaseCollection getBillInfoColl(Set<String> idSet, SelectorItemCollection selector) throws BOSException {
        if (CollectionUtil.isEmpty(idSet)) {
            return null;
        }
        String id = idSet.iterator().next();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
        view.setSelector(selector);
        view.setFilter(filter);
        BOSObjectType bosObjectType = BOSUuid.read((String)id).getType();
        ICoreBase coreBase = (ICoreBase)BOSObjectFactory.createRemoteBOSObject((BOSObjectType)bosObjectType, ICoreBase.class);
        return coreBase.getCollection(view);
    }

    private static SelectorItemCollection getBalanceModelSelector() {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("*"));
        selector.add(new SelectorItemInfo("entry.*"));
        return selector;
    }

    public static BalanceModelInfo getBalanceModelInfo(Context ctx) throws Exception {
        IBalanceModel iBalanceModel = ctx == null ? BalanceModelFactory.getRemoteInstance() : BalanceModelFactory.getLocalInstance((Context)ctx);
        BalanceModelInfo balanceModelInfo = iBalanceModel.getBalanceModelInfo((IObjectPK)new ObjectUuidPK("SOYjDrxMRamtGGENYUm98SPUYjI="), BalanceCfgUtil.getBalanceModelSelector());
        return balanceModelInfo;
    }

    public static BalanceFieldModelCollection getBalanceFieldModelColl(Context ctx) throws Exception {
        BalanceModelInfo balanceModelInfo = BalanceCfgUtil.getBalanceModelInfo(ctx);
        BalanceFieldModelCollection coll = balanceModelInfo.getEntry();
        coll.sort("seq");
        return coll;
    }

    private static void initLoader(Context ctx) {
        if (loader == null) {
            loader = MetaDataLoaderFactory.getMetaDataLoader((Context)ctx);
        }
    }

    public static List<String> getEntryBosTypeList(Context ctx, String bosType) {
        HashMap<String, String> bosType2EntryName = new HashMap<String, String>();
        return BalanceCfgUtil.getEntryBosTypeList(ctx, bosType, bosType2EntryName);
    }

    public static List<String> getEntryBosTypeList(Context ctx, String bosType, Map<String, String> bosType2EntryName) {
        ArrayList<String> entryBosTypeList = new ArrayList<String>();
        if (StringUtil.isEmpty((String)bosType)) {
            return entryBosTypeList;
        }
        BalanceCfgUtil.initLoader(ctx);
        EntityObjectInfo parentEntityObjInfo = null;
        if (entityObjectMap.get(bosType) != null) {
            parentEntityObjInfo = entityObjectMap.get(bosType);
        } else {
            parentEntityObjInfo = loader.getEntity(BOSObjectType.create((String)bosType));
            if (parentEntityObjInfo != null) {
                entityObjectMap.put(bosType, parentEntityObjInfo);
            }
        }
        BalanceCfgUtil.getEntityInfoByRecursionCall(parentEntityObjInfo, entryBosTypeList, bosType2EntryName);
        return entryBosTypeList;
    }

    public static void putEntityObject(EntityObjectInfo entityObjInfo) {
        if (entityObjInfo == null) {
            return;
        }
        entityObjectMap.put(entityObjInfo.getString("bosType"), entityObjInfo);
    }

    public static EntityObjectInfo getEntityObject(Context ctx, String bosType) {
        EntityObjectInfo entityObj = entityObjectMap.get(bosType);
        if (entityObj == null) {
            entityObj = loader.getEntity(BOSObjectType.create((String)bosType));
            entityObjectMap.put(bosType, entityObj);
        }
        return entityObj;
    }

    private static void getEntityInfoByRecursionCall(EntityObjectInfo parentEntityObjInfo, List<String> entryBosTypeList, Map<String, String> bosType2EntryName) {
        PropertyInfo property = null;
        PropertyCollection col = parentEntityObjInfo.getEntityProperties();
        if (CollectionUtil.isEmpty((AbstractObjectCollection)col)) {
            return;
        }
        int size = col.size();
        for (int i = 0; i < size; ++i) {
            property = col.get(i);
            if (!BalanceCfgUtil.isEntryProperty(parentEntityObjInfo, property)) continue;
            RelationshipInfo relation = ((LinkPropertyInfo)property).getRelationship();
            EntityObjectInfo entryEntityObjInfo = relation.getSupplierObject();
            entryBosTypeList.add(entryEntityObjInfo.getString("bosType"));
            bosType2EntryName.put(entryEntityObjInfo.getString("bosType"), property.getName());
            BalanceCfgUtil.getEntityInfoByRecursionCall(entryEntityObjInfo, entryBosTypeList, bosType2EntryName);
        }
    }

    private static boolean isEntryProperty(EntityObjectInfo parent, PropertyInfo property) {
        RelationshipInfo relation;
        return !(parent == null || property == null || !(property instanceof LinkPropertyInfo) || (relation = ((LinkPropertyInfo)property).getRelationship()).getType() != RelationshipType.COMPOSITION && !Boolean.TRUE.toString().equalsIgnoreCase(property.getExtendedProperty("isEntries")) || !relation.getClientObject().getFullName().equals(parent.getFullName()) || relation.getSupplierCardinality() != CardinalityType.ONE_TO_UNBOUNDED && relation.getSupplierCardinality() != CardinalityType.ZERO_TO_UNBOUNDED);
    }
}

