/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.util.DBUtil;
import com.kingdee.eas.scm.common.SCMBillBaseInfo;
import com.kingdee.eas.scm.common.app.BillTypeUtils;
import java.util.ArrayList;
import java.util.List;

public final class AccountViewUtil {
    public static void updateAccountView(Context ctx, IObjectCollection billCol) throws BOSException, EASBizException {
        SCMBillBaseInfo billInfo = null;
        String billTableName = null;
        String entryTableName = null;
        ArrayList<String> billList = new ArrayList<String>();
        String billType = null;
        for (int i = 0; i < billCol.size(); ++i) {
            billInfo = (SCMBillBaseInfo)billCol.getObject(i);
            billList.add(billInfo.getId().toString());
            if (i != 0) continue;
            billTableName = BillTypeUtils.getBillHeadTableName((Context)ctx, (String)billInfo.getBillType().getId().toString());
            entryTableName = BillTypeUtils.getBillEntryTableName((Context)ctx, (String)billInfo.getBillType().getId().toString());
            billType = billInfo.getBOSType().toString();
        }
        if ("8FA62986".equals(billType)) {
            AccountViewUtil.updateAccountViewForCostAjd(ctx, billTableName, entryTableName, billList);
        } else {
            AccountViewUtil.updateAccountViwForInv(ctx, billTableName, entryTableName, billList);
        }
    }

    public static void updateAccountViwForInv(Context ctx, String billTableName, String entryTableName, List<String> billIds) throws BOSException {
        if (billIds.isEmpty()) {
            return;
        }
        StringBuffer sql = new StringBuffer();
        sql.append("update " + entryTableName + " T\r\n");
        sql.append("set (FaccountviewInId,FaccountviewOutId) = \r\n");
        sql.append("(select \r\n");
        sql.append("case T3.FExistingQty when 1 then \r\n");
        sql.append("   (case T4.FStatus when 1 then \r\n");
        sql.append("\t(case T4.FIsPriority when 1 then T4.FWareAccountViewID\r\n");
        sql.append("\telse  (case when T5.FActId is not null then T5.FActId else T4.FWareAccountViewID end) end)\r\n");
        sql.append("   else  T5.FActId end)\r\n");
        sql.append("else  '' end as FActInId,\r\n");
        sql.append("case T3.FExistingQtyPre when 1 then\r\n");
        sql.append("  (case T4.FStatus when 1 then \r\n");
        sql.append("\t(case T4.FIsPriority when 1 then T4.FIssueAccountViewID\r\n");
        sql.append("\telse   (case when T5.FActId is not null then T5.FActId else T4.FIssueAccountViewID end) end)\r\n");
        sql.append("   else T5.FActId end)\r\n");
        sql.append("else  '' end as FActOutId\r\n");
        sql.append(" from " + entryTableName + " T0\r\n");
        sql.append("left outer join " + billTableName + " T1 on T0.fparentid = T1.fid\r\n");
        sql.append("left outer join T_IM_InvUpdateType T3 on T0.FInvUpdateTypeID = T3.fid\r\n");
        sql.append("left outer join T_CL_LotAccountContrast T4 on T1.FTransactionTypeID = T4.FTransactionTypeID \r\n");
        sql.append("and T1.FbillTypeId=T4.FbillTypeId and T0.FInvUpdateTypeID = T4.FUpdateTypeID and t1.FBIZTYPEID  = t4.FBIZTYPEID \r\n");
        sql.append("and T0.Fcompanyorgunitid = T4.FCompanyOrgUnitID and T4.FStatus = 1 \r\n  ");
        sql.append("left outer join  (select T6.fmaterialId as fmaterialId,T6.FCompanyId as FCompanyId,T7.FAccountlinkID as FActId\r\n");
        sql.append("\tfrom  T_BD_MaterialCompanyInfo T6\r\n");
        sql.append("\tinner join T_BD_KAClassificationDetail T7 on T6.FKAClassID = T7.FKaclassficlink\r\n");
        sql.append("\tinner join T_BD_KAccountItem T8 on T8.FID=T7.FAccountitemlinkID\r\n");
        sql.append("\twhere T8.FNumber = '1001'\r\n");
        sql.append("\t)T5 on T5.fmaterialId = T0.FmaterialId and T0.FCompanyOrgUnitID = T5.FcompanyId\r\n");
        sql.append("where T0.fid=T.FID)\r\n");
        sql.append("where T.FparentId in (" + AccountViewUtil.getIdCondition(billIds) + ")\r\n");
        DBUtil.executeUpdate((Context)ctx, (String)sql.toString(), null);
    }

    public static void updateAccountViewForCostAjd(Context ctx, String billTableName, String entryTableName, List<String> billIds) throws BOSException {
        if (billIds.isEmpty()) {
            return;
        }
        StringBuffer sql = new StringBuffer();
        sql.append("update " + entryTableName + " T\r\n");
        sql.append("set (FaccountviewInId,FaccountviewOutId) = \r\n");
        sql.append("(select \r\n");
        sql.append("case T5.FCalculateKind when 0 then T4.FId else '' end as FAccountViewInId,\r\n");
        sql.append("case T5.FCalculateKind when 1 then T4.FId else '' end as FAccountViewOutId \r\n");
        sql.append("from T_CL_CostAdjustBillentry T0\r\n");
        sql.append("inner join T_CL_CostAdjustBill T5 on T0.fparentid= T5.FId\r\n");
        sql.append("inner join T_BD_MaterialCompanyInfo T1 on T0.Fmaterialid = T1.Fmaterialid and T0.FcompanyOrgUnitId = T1.fcompanyId\r\n");
        sql.append("inner join T_BD_KAClassificationDetail T2 on T1.FKAClassID = T2.FKaclassficlink\r\n");
        sql.append("INNER JOIN T_BD_KAccountItem T3 on T2.FAccountitemlinkID = T3.FID\r\n");
        sql.append("INNER JOIN T_BD_AccountView T4  ON T2.FAccountlinkID = T4.FID\r\n");
        sql.append("where T3.Fnumber='1001' and T0.FId = T.FID)\r\n");
        sql.append("where T.FparentId in (" + AccountViewUtil.getIdCondition(billIds) + ")\r\n");
        DBUtil.executeUpdate((Context)ctx, (String)sql.toString(), null);
    }

    public static String getIdCondition(List<String> idList) {
        StringBuffer ids = new StringBuffer();
        int size = idList.size();
        for (int i = 0; i < size; ++i) {
            if (i == 0) {
                ids.append("'" + idList.get(i) + "'");
                continue;
            }
            ids.append(",'" + idList.get(i) + "'");
        }
        return ids.toString();
    }
}

