/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.eas.basedata.assistant.ConvertModeEnum;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.scm.common.SCMFetchData;
import com.kingdee.eas.scm.common.client.SCMBillEditUI;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.client.helper.InvUiHandlingHelper;
import com.kingdee.eas.scm.common.util.CalculateUtils;
import com.kingdee.eas.scm.common.util.SCMConstant;
import com.kingdee.eas.scm.im.inv.client.InvClientUtils;
import com.kingdee.util.BaseException;
import java.math.BigDecimal;

public class PurInwarehsUiHandlingHelper
extends InvUiHandlingHelper {
    public PurInwarehsUiHandlingHelper(OrgType mainBizOrgType, SCMBillEditUI editUi) {
        super(mainBizOrgType, editUi);
    }

    public void calByPrice(int rowIndex, int colIndex, ExchangeRateInfo exchangeRateinfo) {
        this.calAmount(rowIndex, colIndex);
        this.calTaxPricebyPrice(rowIndex, colIndex);
        this.calTax(rowIndex, colIndex);
        this.calLocalTax(rowIndex, exchangeRateinfo);
        this.calActualPrice(rowIndex, colIndex);
        this.calTaxAmountByTaxPrice(rowIndex, colIndex);
        this.calDiscountAmountByTaxPrice(rowIndex, colIndex);
        this.calActualTaxPrice(rowIndex, colIndex);
        this.calLocalTaxAmount(rowIndex, exchangeRateinfo);
        this.calPurchaseCostByPrice(rowIndex, exchangeRateinfo);
        this.calUnitPurchaseCostByAmount(rowIndex, exchangeRateinfo);
        this.calActualCost(rowIndex);
        this.calUnitActualCost(rowIndex);
    }

    public void calByEntryTaxPrice(int rowIndex, int colIndex, ExchangeRateInfo exchangeRateinfo) {
        this.calDiscountAmountByTaxPrice(rowIndex, colIndex);
        this.calPriceByTaxPrice(rowIndex, colIndex);
        this.calTaxAmountByTaxPrice(rowIndex, colIndex);
        this.calTax(rowIndex, colIndex);
        this.calLocalTaxAmount(rowIndex, exchangeRateinfo);
        this.calAmount(rowIndex, colIndex);
        this.calLocalTax(rowIndex, exchangeRateinfo);
        this.calActualTaxPrice(rowIndex, colIndex);
        this.calActualPrice(rowIndex, colIndex);
        this.calPurchaseCost(rowIndex, exchangeRateinfo);
        this.calUnitPurchaseCost(rowIndex, exchangeRateinfo);
        this.calActualCost(rowIndex);
        this.calUnitActualCost(rowIndex);
    }

    public void calByEntryTaxRate(int rowIndex, int colIndex, ExchangeRateInfo exchangeRateinfo) {
        if (this.cbIsInTax.isSelected()) {
            this.calPriceByTaxPrice(rowIndex, colIndex);
            this.calTax(rowIndex, colIndex);
            this.calLocalTax(rowIndex, exchangeRateinfo);
            this.calAmount(rowIndex, colIndex);
            this.calActualPrice(rowIndex, colIndex);
            this.calPurchaseCost(rowIndex, exchangeRateinfo);
            this.calUnitPurchaseCost(rowIndex, exchangeRateinfo);
            this.calActualCost(rowIndex);
            this.calUnitActualCost(rowIndex);
        } else {
            this.calTaxPricebyPrice(rowIndex, colIndex);
            this.calTax(rowIndex, colIndex);
            this.calLocalTax(rowIndex, exchangeRateinfo);
            this.calTaxAmountByTaxPrice(rowIndex, colIndex);
            this.calDiscountAmountByTaxPrice(rowIndex, colIndex);
            this.calActualTaxPrice(rowIndex, colIndex);
            this.calLocalTaxAmount(rowIndex, exchangeRateinfo);
        }
    }

    public void calByEntryDiscountRate(int rowIndex, int colIndex, ExchangeRateInfo exchangeRateinfo) {
        if (this.cbIsInTax.isSelected()) {
            this.calDiscountAmountByTaxPrice(rowIndex, colIndex);
            this.calTaxAmountByTaxPrice(rowIndex, colIndex);
            this.calTax(rowIndex, colIndex);
            this.calLocalTaxAmount(rowIndex, exchangeRateinfo);
            this.calLocalTax(rowIndex, exchangeRateinfo);
            this.calAmount(rowIndex, colIndex);
            this.calActualTaxPrice(rowIndex, colIndex);
            this.calActualPrice(rowIndex, colIndex);
            this.calPurchaseCost(rowIndex, exchangeRateinfo);
            this.calUnitPurchaseCost(rowIndex, exchangeRateinfo);
            this.calActualCost(rowIndex);
            this.calUnitActualCost(rowIndex);
        } else {
            this.calAmount(rowIndex, colIndex);
            this.calDiscountAmountByTaxPrice(rowIndex, colIndex);
            this.calTax(rowIndex, colIndex);
            this.calTaxAmountByTaxPrice(rowIndex, colIndex);
            this.calLocalTax(rowIndex, exchangeRateinfo);
            this.calActualPrice(rowIndex, colIndex);
            this.calActualTaxPrice(rowIndex, colIndex);
            this.calLocalTaxAmount(rowIndex, exchangeRateinfo);
            this.calPurchaseCostByPrice(rowIndex, exchangeRateinfo);
            this.calUnitPurchaseCostByAmount(rowIndex, exchangeRateinfo);
            this.calActualCost(rowIndex);
            this.calUnitActualCost(rowIndex);
        }
    }

    public void calByExchangeRate(int rowIndex, int colIndex, ExchangeRateInfo exchangeRateinfo) {
        this.calLocalTax(rowIndex, exchangeRateinfo);
        this.calLocalTaxAmount(rowIndex, exchangeRateinfo);
        this.calPurchaseCostByPrice(rowIndex, exchangeRateinfo);
        this.calUnitPurchaseCostByAmount(rowIndex, exchangeRateinfo);
        this.calActualCost(rowIndex);
        this.calUnitActualCost(rowIndex);
    }

    public void calByAmount(int rowIndex, int colIndex, ExchangeRateInfo exchangeRateinfo) {
        this.calPriceByPurchaseCost(rowIndex, colIndex);
        this.calTaxPrice(rowIndex, colIndex);
        this.calTax(rowIndex, colIndex);
        this.calLocalTax(rowIndex, exchangeRateinfo);
        this.calTaxAmountByTaxPrice(rowIndex, colIndex);
        this.calLocalTaxAmount(rowIndex, exchangeRateinfo);
        this.calActualPrice(rowIndex, colIndex);
        this.calActualTaxPrice(rowIndex, colIndex);
        this.calDiscountAmountByTaxPrice(rowIndex, colIndex);
        this.calPurchaseCostByAmount(rowIndex, exchangeRateinfo);
        this.calUnitPurchaseCostByAmount(rowIndex, exchangeRateinfo);
        this.calActualCost(rowIndex);
        this.calUnitActualCost(rowIndex);
    }

    public void calByTaxAmount(int rowIndex, int colIndex, ExchangeRateInfo exchangeRateinfo) {
        this.calLocalTaxAmount(rowIndex, exchangeRateinfo);
        this.calTax(rowIndex, colIndex);
        this.calTaxPrice(rowIndex, colIndex);
        this.calActualTaxPrice(rowIndex, colIndex);
        this.calAmount(rowIndex, colIndex);
        this.calPriceByTaxPrice(rowIndex, colIndex);
        this.calActualPrice(rowIndex, colIndex);
        this.calDiscountAmountByTaxPrice(rowIndex, colIndex);
        this.calLocalTax(rowIndex, exchangeRateinfo);
        this.calPurchaseCost(rowIndex, exchangeRateinfo);
        this.calUnitPurchaseCost(rowIndex, exchangeRateinfo);
        this.calActualCost(rowIndex);
        this.calUnitActualCost(rowIndex);
    }

    public void calByTax(int rowIndex, int colIndex, ExchangeRateInfo exchangeRateinfo) {
        if (this.cbIsInTax.isSelected()) {
            this.calAmount(rowIndex, colIndex);
            this.calLocalTax(rowIndex, exchangeRateinfo);
            this.calPurchaseCost(rowIndex, exchangeRateinfo);
            this.calUnitPurchaseCostForTax(rowIndex, exchangeRateinfo);
            this.calActualCost(rowIndex);
            this.calUnitActualCost(rowIndex);
        } else {
            this.calLocalTax(rowIndex, exchangeRateinfo);
            this.calTaxAmountByTaxPrice(rowIndex, colIndex);
            this.calLocalTaxAmount(rowIndex, exchangeRateinfo);
        }
    }

    public void calByQty(int rowIndex, int colIndex, ExchangeRateInfo exchangeRateinfo) {
        if (this.cbIsInTax.isSelected()) {
            this.calDiscountAmountByTaxPrice(rowIndex, colIndex);
            this.calTaxAmountByTaxPrice(rowIndex, colIndex);
            this.calLocalTaxAmount(rowIndex, exchangeRateinfo);
            this.calTax(rowIndex, colIndex);
            this.calLocalTax(rowIndex, exchangeRateinfo);
            this.calPriceByTaxPrice(rowIndex, colIndex);
            this.calAmount(rowIndex, colIndex);
            this.calActualTaxPrice(rowIndex, colIndex);
            this.calActualPrice(rowIndex, colIndex);
            this.calPurchaseCost(rowIndex, exchangeRateinfo);
            this.calUnitPurchaseCost(rowIndex, exchangeRateinfo);
            this.calMaterialCost(rowIndex);
            this.calActualCost(rowIndex);
            this.calUnitActualCost(rowIndex);
        } else {
            this.calAmount(rowIndex, colIndex);
            this.calTax(rowIndex, colIndex);
            this.calLocalTax(rowIndex, exchangeRateinfo);
            this.calTaxAmountByTaxPrice(rowIndex, colIndex);
            this.calLocalTaxAmount(rowIndex, exchangeRateinfo);
            this.calActualPrice(rowIndex, colIndex);
            this.calActualTaxPrice(rowIndex, colIndex);
            this.calDiscountAmountByTaxPrice(rowIndex, colIndex);
            this.calPurchaseCostByPrice(rowIndex, exchangeRateinfo);
            this.calUnitPurchaseCostByAmount(rowIndex, exchangeRateinfo);
            this.calMaterialCost(rowIndex);
            this.calActualCost(rowIndex);
            this.calUnitActualCost(rowIndex);
            try {
                this.calBaseQty(rowIndex);
                this.calAssistQty(rowIndex, colIndex);
            }
            catch (Exception e) {
                this.editUi.handUIException((Throwable)e);
            }
        }
    }

    public void calByQtyChanged(KDTEditEvent e, ExchangeRateInfo exchangeRateinfo) {
        int rowIndex = e.getRowIndex();
        int colIndex = e.getColIndex();
        if (this.getDetailTable() == null) {
            return;
        }
        if (rowIndex < 0 || colIndex < 0) {
            return;
        }
        if (this.getDetailTable().getRow(rowIndex) == null) {
            return;
        }
        String fieldName = this.getDetailTable().getColumnKey(colIndex);
        if (this.TB_QTY != null && this.TB_QTY.equalsIgnoreCase(fieldName)) {
            if (this.cbIsInTax.isSelected()) {
                this.calDiscountAmountByTaxPrice(rowIndex, colIndex);
                this.calTaxAmountByTaxPrice(rowIndex, colIndex);
                this.calLocalTaxAmount(rowIndex, exchangeRateinfo);
                this.calTax(rowIndex, colIndex);
                this.calLocalTax(rowIndex, exchangeRateinfo);
                this.calPriceByTaxPrice(rowIndex, colIndex);
                this.calAmount(rowIndex, colIndex);
                this.calActualTaxPrice(rowIndex, colIndex);
                this.calActualPrice(rowIndex, colIndex);
                this.calPurchaseCost(rowIndex, exchangeRateinfo);
                this.calUnitPurchaseCost(rowIndex, exchangeRateinfo);
                this.calMaterialCost(rowIndex);
                this.calActualCost(rowIndex);
                this.calUnitActualCost(rowIndex);
            } else {
                this.calAmount(rowIndex, colIndex);
                this.calTax(rowIndex, colIndex);
                this.calLocalTax(rowIndex, exchangeRateinfo);
                this.calTaxAmountByTaxPrice(rowIndex, colIndex);
                this.calLocalTaxAmount(rowIndex, exchangeRateinfo);
                this.calActualPrice(rowIndex, colIndex);
                this.calActualTaxPrice(rowIndex, colIndex);
                this.calDiscountAmountByTaxPrice(rowIndex, colIndex);
                this.calPurchaseCostByPrice(rowIndex, exchangeRateinfo);
                this.calUnitPurchaseCostByAmount(rowIndex, exchangeRateinfo);
                this.calMaterialCost(rowIndex);
                this.calActualCost(rowIndex);
                this.calUnitActualCost(rowIndex);
            }
        }
    }

    public void calByUnit(int rowIndex, int colIndex, ExchangeRateInfo exchangeRateinfo) {
        if (this.cbIsInTax.isSelected()) {
            try {
                this.calQty(rowIndex);
            }
            catch (Exception e) {
                this.editUi.handUIException((Throwable)e);
            }
            this.calTaxPrice(rowIndex, colIndex);
            this.calPriceByTaxPrice(rowIndex, colIndex);
            this.calActualPrice(rowIndex, colIndex);
            this.calActualTaxPrice(rowIndex, colIndex);
            this.calUnitPurchaseCost(rowIndex, exchangeRateinfo);
            this.calUnitActualCost(rowIndex);
            this.calUnitMaterialCost(rowIndex);
        } else {
            try {
                this.calQty(rowIndex);
            }
            catch (Exception e) {
                this.editUi.handUIException((Throwable)e);
            }
            this.calUnitMaterialCost(rowIndex);
            this.calPriceByPurchaseCost(rowIndex, colIndex);
            this.calActualPrice(rowIndex, colIndex);
            this.calUnitPurchaseCostByAmount(rowIndex, exchangeRateinfo);
            this.calUnitActualCost(rowIndex);
            this.calTaxPrice(rowIndex, colIndex);
            this.calActualTaxPrice(rowIndex, colIndex);
        }
    }

    public void calByPurchaseCost(int rowIndex, int colIndex, ExchangeRateInfo exchangeRateinfo) {
        if (this.chkIsPriceInTax != null && !this.chkIsPriceInTax.isSelected()) {
            this.calUnitPurchaseCostByPurchaseCost(rowIndex);
            this.calActualCost(rowIndex);
            this.calLocalTaxAmountByPurchaseCost(rowIndex);
            this.calAmountByPurchaseCost(rowIndex, exchangeRateinfo);
            this.calLocalTaxByPurchaseCost(rowIndex);
            this.calTaxAmountByCurrency(rowIndex, exchangeRateinfo);
            this.calTaxByPurchaseCost(rowIndex, colIndex);
            this.calDiscountAmountByPurchaseCost(rowIndex, colIndex);
            this.calPriceByPurchaseCost(rowIndex, colIndex);
            this.calTaxPriceByPurchaseCost(rowIndex, colIndex);
            this.calActualPrice(rowIndex, colIndex);
            this.calActualTaxPrice(rowIndex, colIndex);
            this.calUnitActualCost(rowIndex);
        } else {
            this.calUnitPurchaseCostByPurchaseCost(rowIndex);
            this.calActualCost(rowIndex);
            this.calAmountByPurchaseCost(rowIndex, exchangeRateinfo);
            this.calLocalTaxByCost(rowIndex);
            this.calTaxByCost(rowIndex, exchangeRateinfo);
            this.calTaxAmountByPurchaseCost(rowIndex, colIndex);
            this.calLocalTaxAmountByCost(rowIndex, colIndex);
            this.calDiscountAmountByPurchaseCost(rowIndex, colIndex);
            this.calTaxPriceByPurchaseCost(rowIndex, colIndex);
            this.calPriceByPurchaseCost(rowIndex, colIndex);
            this.calActualPrice(rowIndex, colIndex);
            this.calActualTaxPrice(rowIndex, colIndex);
            this.calUnitActualCost(rowIndex);
        }
    }

    public void calByUnitPurchaseCost(int rowIndex, int colIndex, ExchangeRateInfo exchangeRateinfo) {
        if (this.chkIsPriceInTax != null && !this.chkIsPriceInTax.isSelected()) {
            this.calPurchaseCostByUnitCost(rowIndex);
            this.calActualCost(rowIndex);
            this.calUnitActualCost(rowIndex, exchangeRateinfo);
            this.calPriceByUnitPurchaseCost(rowIndex, exchangeRateinfo);
            this.calAmountByUnitPurchaseCost(rowIndex, exchangeRateinfo);
            this.calLocalTaxAmountByUnitPurchaseCost(rowIndex);
            this.calLocalTaxByPurchaseCost(rowIndex);
            this.calTaxByCost(rowIndex, exchangeRateinfo);
            this.calTaxAmountByCurrency(rowIndex, exchangeRateinfo);
            this.calActualPriceByUnitPurchase(rowIndex, exchangeRateinfo);
            this.calTaxPricebyPrice(rowIndex, colIndex);
            this.calActualTaxPriceByUnitPurchaseCost(rowIndex, colIndex);
            this.calDiscountAmountByTaxPrice(rowIndex, colIndex);
        } else {
            this.calPurchaseCostByUnitCost(rowIndex);
            this.calActualCost(rowIndex);
            this.calUnitActualCost(rowIndex, exchangeRateinfo);
            this.calPriceByUnitPurchaseCost(rowIndex, exchangeRateinfo);
            this.calActualPriceByUnitPurchase(rowIndex, exchangeRateinfo);
            this.calTaxPricebyPrice(rowIndex, colIndex);
            this.calActualTaxPriceByUnitPurchaseCost(rowIndex, colIndex);
            this.calAmountByUnitPurchaseCost(rowIndex, exchangeRateinfo);
            this.calLocalTaxByUnitPurchaseCost(rowIndex);
            this.calTaxByCost(rowIndex, exchangeRateinfo);
            this.calLocalTaxAmountByCost(rowIndex, colIndex);
            this.calTaxAmountByPurchaseCost(rowIndex, colIndex);
            this.calDiscountAmountByTaxPrice(rowIndex, colIndex);
        }
    }

    public void calByActualCost(int rowIndex, int colIndex, ExchangeRateInfo exchangeRateinfo) {
        if (this.cbIsInTax.isSelected()) {
            this.calPurchaseCostByActualCost(rowIndex);
            this.calAmountByPurchaseCost(rowIndex, exchangeRateinfo);
            this.calTaxByPurchaseCost(rowIndex, colIndex);
            this.calTaxAmountByPurchaseCost(rowIndex, colIndex);
            this.calLocalTax(rowIndex, exchangeRateinfo);
            this.calLocalTaxAmount(rowIndex, exchangeRateinfo);
            this.calPriceByPurchaseCost(rowIndex, colIndex);
            this.calTaxPricebyPrice(rowIndex, colIndex);
            this.calActualPrice(rowIndex, colIndex);
            this.calActualTaxPrice(rowIndex, colIndex);
            this.calUnitPurchaseCost(rowIndex, exchangeRateinfo);
            this.calUnitActualCost(rowIndex);
            this.calDiscountAmountByTaxPrice(rowIndex, colIndex);
        } else {
            this.calPurchaseCostByActualCost(rowIndex);
            this.calAmountByPurchaseCost(rowIndex, exchangeRateinfo);
            this.calTaxByPurchaseCost(rowIndex, colIndex);
            this.calLocalTax(rowIndex, exchangeRateinfo);
            this.calTaxAmountByPurchaseCost(rowIndex, colIndex);
            this.calPriceByPurchaseCost(rowIndex, colIndex);
            this.calTaxPricebyPrice(rowIndex, colIndex);
            this.calActualPrice(rowIndex, colIndex);
            this.calActualTaxPrice(rowIndex, colIndex);
            this.calDiscountAmountByTaxPrice(rowIndex, colIndex);
            this.calLocalTaxAmount(rowIndex, exchangeRateinfo);
            this.calUnitPurchaseCost(rowIndex, exchangeRateinfo);
            this.calUnitActualCost(rowIndex);
        }
    }

    public void calByUnitActualCost(int rowIndex, int colIndex, ExchangeRateInfo exchangeRateinfo) {
        if (this.cbIsInTax.isSelected()) {
            this.calActualCostByUnitCost(rowIndex);
            this.calPurchaseCostByActualCost(rowIndex);
            this.calPriceByUnitPurchaseCost(rowIndex, exchangeRateinfo);
            this.calTaxPricebyPrice(rowIndex, colIndex);
            this.calDiscountAmountByTaxPrice(rowIndex, colIndex);
            this.calTaxAmountByTaxPrice(rowIndex, colIndex);
            this.calTax(rowIndex, colIndex);
            this.calAmount(rowIndex, colIndex);
            this.calActualTaxPrice(rowIndex, colIndex);
            this.calActualPrice(rowIndex, colIndex);
            this.calUnitPurchaseCost(rowIndex, exchangeRateinfo);
            this.calLocalTax(rowIndex, exchangeRateinfo);
            this.calLocalTaxAmount(rowIndex, exchangeRateinfo);
        } else {
            this.calActualCostByUnitCost(rowIndex);
            this.calPurchaseCostByActualCost(rowIndex);
            this.calUnitPurchaseCost(rowIndex, exchangeRateinfo);
            this.calPriceByUnitPurchaseCost(rowIndex, exchangeRateinfo);
            this.calTaxPricebyPrice(rowIndex, colIndex);
            this.calAmountByUnitCost(rowIndex, colIndex);
            this.calDiscountAmountByTaxPrice(rowIndex, colIndex);
            this.calTaxByPurchaseCost(rowIndex, colIndex);
            this.calLocalTax(rowIndex, exchangeRateinfo);
            this.calTaxAmountByPurchaseCost(rowIndex, colIndex);
            this.calLocalTaxAmount(rowIndex, exchangeRateinfo);
            this.calActualPrice(rowIndex, colIndex);
            this.calActualTaxPrice(rowIndex, colIndex);
        }
    }

    public void calByUnitPurchaseFee(int rowIndex, int colIndex, ExchangeRateInfo exchangeRateinfo) {
        this.calActualCost(rowIndex);
        this.calUnitActualCost(rowIndex);
    }

    public void calByUnitMaterialCost(int rowIndex, int colIndex, ExchangeRateInfo exchangeRateinfo) {
        this.calMaterialCost(rowIndex);
        this.calActualCost(rowIndex);
        this.calUnitActualCost(rowIndex);
    }

    public void calByMaterialCost(int rowIndex, int colIndex, ExchangeRateInfo exchangeRateinfo) {
        this.calUnitMaterialCost(rowIndex);
        this.calActualCost(rowIndex);
        this.calUnitActualCost(rowIndex);
    }

    public void calByCurrency(int rowIndex, int colIndex, ExchangeRateInfo exchangeRateinfo) {
        if (this.cbIsInTax.isSelected()) {
            this.calTaxAmountByCurrency(rowIndex, exchangeRateinfo);
            this.calTax(rowIndex, colIndex);
            this.calAmount(rowIndex, colIndex);
            this.calTaxPrice(rowIndex, colIndex);
            this.calActualTaxPrice(rowIndex, colIndex);
            this.calPriceByTaxPrice(rowIndex, colIndex);
            this.calActualPrice(rowIndex, colIndex);
            this.calDiscountAmountByTaxPrice(rowIndex, colIndex);
        } else {
            this.calAmountByPurchaseCost(rowIndex, exchangeRateinfo);
            this.calPriceByPurchaseCost(rowIndex, colIndex);
            this.calTaxByPurchaseCost(rowIndex, colIndex);
            this.calTaxAmountByPurchaseCost(rowIndex, colIndex);
            this.calTaxPricebyPrice(rowIndex, colIndex);
            this.calDiscountAmountByTaxPrice(rowIndex, colIndex);
            this.calActualPrice(rowIndex, colIndex);
            this.calActualTaxPrice(rowIndex, colIndex);
        }
    }

    public void calDiscountAmountByTaxPrice(int rowIndex, int colIndex) {
        if (this.TB_AMOUNT == null || this.TB_TAXPRICE == null || this.TB_QTY == null || this.getDetailTable().getRow(rowIndex).getCell("discountRate") == null || this.TB_DISCOUNTAMOUNT == null) {
            return;
        }
        int scale = this.getDetailTable().getRow(rowIndex).getCell(this.TB_AMOUNT).getEditor() == null ? 6 : ((KDFormattedTextField)this.getDetailTable().getRow(rowIndex).getCell(this.TB_AMOUNT).getEditor().getComponent()).getPrecision();
        BigDecimal taxPrice = (BigDecimal)this.getDetailTable().getRow(rowIndex).getCell(this.TB_TAXPRICE).getValue();
        BigDecimal qty = (BigDecimal)this.getDetailTable().getRow(rowIndex).getCell(this.TB_QTY).getValue();
        BigDecimal discountRate = (BigDecimal)this.getDetailTable().getRow(rowIndex).getCell("discountRate").getValue();
        BigDecimal oneHundred = new BigDecimal("100.0");
        taxPrice = this.validateNullValue(taxPrice);
        qty = this.validateNullValue(qty);
        discountRate = this.validateNullValue(discountRate);
        BigDecimal discountAmount = taxPrice.multiply(qty).multiply(discountRate.divide(oneHundred, 10, 4)).setScale(scale, 4);
        this.getDetailTable().getRow(rowIndex).getCell(this.TB_DISCOUNTAMOUNT).setValue((Object)discountAmount);
    }

    public void calDiscountAmountByPurchaseCost(int rowIndex, int colIndex) {
        if (this.TB_AMOUNT == null || this.TB_TAXPRICE == null || this.getDetailTable().getRow(rowIndex).getCell("discountRate") == null || this.TB_DISCOUNTAMOUNT == null) {
            return;
        }
        int scale = this.getDetailTable().getRow(rowIndex).getCell(this.TB_AMOUNT).getEditor() == null ? 6 : ((KDFormattedTextField)this.getDetailTable().getRow(rowIndex).getCell(this.TB_AMOUNT).getEditor().getComponent()).getPrecision();
        BigDecimal taxAmount = (BigDecimal)this.getDetailTable().getRow(rowIndex).getCell(this.TB_TAXAMOUNT).getValue();
        BigDecimal discountRate = (BigDecimal)this.getDetailTable().getRow(rowIndex).getCell("discountRate").getValue();
        BigDecimal oneHundred = new BigDecimal("100.0");
        BigDecimal one = new BigDecimal("1.0");
        taxAmount = this.validateNullValue(taxAmount);
        discountRate = this.validateNullValue(discountRate);
        discountRate = discountRate.divide(oneHundred, 10, 4);
        BigDecimal discountAmount = taxAmount.multiply(discountRate).divide(one.subtract(discountRate), 10, 4).setScale(scale, 4);
        this.getDetailTable().getRow(rowIndex).getCell(this.TB_DISCOUNTAMOUNT).setValue((Object)discountAmount);
    }

    public void calTaxPriceByPurchaseCost(int rowIndex, int colIndex) {
        if (this.TB_AMOUNT == null || this.TB_TAXPRICE == null || this.TB_QTY == null || this.getDetailTable().getRow(rowIndex).getCell("discountRate") == null || this.TB_DISCOUNTAMOUNT == null) {
            return;
        }
        int scale = this.getDetailTable().getRow(rowIndex).getCell(this.TB_TAXPRICE).getEditor() == null ? 6 : ((KDFormattedTextField)this.getDetailTable().getRow(rowIndex).getCell(this.TB_TAXPRICE).getEditor().getComponent()).getPrecision();
        BigDecimal taxAmount = (BigDecimal)this.getDetailTable().getRow(rowIndex).getCell(this.TB_TAXAMOUNT).getValue();
        BigDecimal qty = (BigDecimal)this.getDetailTable().getRow(rowIndex).getCell(this.TB_QTY).getValue();
        BigDecimal discountRate = (BigDecimal)this.getDetailTable().getRow(rowIndex).getCell("discountRate").getValue();
        BigDecimal oneHundred = new BigDecimal("100.0");
        BigDecimal one = new BigDecimal("1.0");
        taxAmount = this.validateNullValue(taxAmount);
        qty = this.validateNullValue(qty);
        discountRate = this.validateNullValue(discountRate);
        discountRate = discountRate.divide(oneHundred, 10, 4);
        if (qty != null && qty.compareTo(ZERO) != 0) {
            BigDecimal taxPrice = taxAmount.divide(qty, 10, 4).divide(one.subtract(discountRate), 10, 4).setScale(scale, 4);
            this.getDetailTable().getRow(rowIndex).getCell(this.TB_TAXPRICE).setValue((Object)taxPrice);
        }
    }

    public void calPriceByTaxPrice(int rowIndex, int colIndex) {
        if (this.TB_TAXPRICE == null || this.TB_TAXRATE == null || this.TB_PRICE == null) {
            return;
        }
        BigDecimal taxPrice = (BigDecimal)this.getDetailTable().getRow(rowIndex).getCell(this.TB_TAXPRICE).getValue();
        BigDecimal taxRate = (BigDecimal)this.getDetailTable().getRow(rowIndex).getCell(this.TB_TAXRATE).getValue();
        taxPrice = this.validateNullValue(taxPrice);
        taxRate = this.validateNullValue(taxRate);
        taxPrice = taxPrice.abs();
        int scale = this.getDetailTable().getRow(rowIndex).getCell(this.TB_PRICE).getEditor() == null ? 6 : ((KDFormattedTextField)this.getDetailTable().getRow(rowIndex).getCell(this.TB_PRICE).getEditor().getComponent()).getPrecision();
        BigDecimal price = CalculateUtils.calPrice((BigDecimal)taxPrice, (BigDecimal)taxRate, (int)scale);
        if (this.chkIsPriceInTax != null && !this.chkIsPriceInTax.isSelected()) {
            price = CalculateUtils.calPriceIsPriceInTax((BigDecimal)taxRate, (BigDecimal)taxPrice, (int)scale);
        }
        this.getDetailTable().getRow(rowIndex).getCell(this.TB_PRICE).setValue((Object)price);
    }

    public void calPriceByUnitPurchaseCost(int rowIndex, ExchangeRateInfo exchangeRateinfo) {
        if (this.TB_UNITPURCHASECOST == null || this.TB_PRICE == null || "discountRate" == null) {
            return;
        }
        BigDecimal unitPurchaseCost = (BigDecimal)this.getDetailTable().getRow(rowIndex).getCell(this.TB_UNITPURCHASECOST).getValue();
        BigDecimal discountRate = (BigDecimal)this.getDetailTable().getRow(rowIndex).getCell("discountRate").getValue();
        int scale = this.getDetailTable().getRow(rowIndex).getCell(this.TB_PRICE).getEditor() == null ? 6 : ((KDFormattedTextField)this.getDetailTable().getRow(rowIndex).getCell(this.TB_PRICE).getEditor().getComponent()).getPrecision();
        unitPurchaseCost = this.validateNullValue(unitPurchaseCost);
        discountRate = this.validateNullValue(discountRate);
        BigDecimal exchangerate = this.txtExchangeRate.getBigDecimalValue();
        exchangerate = this.validateNullValue(exchangerate);
        BigDecimal oneHundred = new BigDecimal("100.0");
        BigDecimal one = new BigDecimal("1.0");
        discountRate = discountRate.divide(oneHundred, 10, 4);
        if (exchangeRateinfo != null && exchangerate.compareTo(ZERO) != 0) {
            if (exchangeRateinfo.getExchangeAux().getConvertMode() == ConvertModeEnum.DIRECTEXCHANGERATE) {
                this.getDetailTable().getRow(rowIndex).getCell(this.TB_PRICE).setValue((Object)unitPurchaseCost.divide(one.subtract(discountRate), 10, 4).divide(exchangerate, scale, 4));
            } else {
                this.getDetailTable().getRow(rowIndex).getCell(this.TB_PRICE).setValue((Object)unitPurchaseCost.divide(one.subtract(discountRate), 10, 4).multiply(exchangerate).setScale(scale, 4));
            }
        } else {
            this.getDetailTable().getRow(rowIndex).getCell(this.TB_PRICE).setValue((Object)unitPurchaseCost.divide(one.subtract(discountRate), 10, 4));
        }
    }

    public void calTaxAmountByTaxPrice(int rowIndex, int colIndex) {
        int scale;
        if (this.TB_AMOUNT == null || this.TB_TAXPRICE == null || this.TB_QTY == null || this.TB_DISCOUNTAMOUNT == null || this.TB_TAXAMOUNT == null || this.TB_TAX == null) {
            return;
        }
        int n = scale = this.getDetailTable().getRow(rowIndex).getCell(this.TB_AMOUNT).getEditor() == null ? 6 : ((KDFormattedTextField)this.getDetailTable().getRow(rowIndex).getCell(this.TB_AMOUNT).getEditor().getComponent()).getPrecision();
        if (this.cbIsInTax.isSelected()) {
            BigDecimal taxPrice = (BigDecimal)this.getDetailTable().getRow(rowIndex).getCell(this.TB_TAXPRICE).getValue();
            BigDecimal qty = (BigDecimal)this.getDetailTable().getRow(rowIndex).getCell(this.TB_QTY).getValue();
            BigDecimal discountAmount = (BigDecimal)this.getDetailTable().getRow(rowIndex).getCell(this.TB_DISCOUNTAMOUNT).getValue();
            taxPrice = this.validateNullValue(taxPrice);
            qty = this.validateNullValue(qty);
            discountAmount = this.validateNullValue(discountAmount);
            BigDecimal taxAmount = taxPrice.multiply(qty).subtract(discountAmount);
            taxAmount = taxAmount.setScale(scale, 4);
            this.getDetailTable().getRow(rowIndex).getCell(this.TB_TAXAMOUNT).setValue((Object)taxAmount);
        } else {
            BigDecimal amount = (BigDecimal)this.getDetailTable().getRow(rowIndex).getCell(this.TB_AMOUNT).getValue();
            BigDecimal tax = (BigDecimal)this.getDetailTable().getRow(rowIndex).getCell(this.TB_TAX).getValue();
            amount = this.validateNullValue(amount);
            tax = this.validateNullValue(tax);
            BigDecimal taxAmount = amount.add(tax);
            taxAmount = taxAmount.setScale(scale, 4);
            this.getDetailTable().getRow(rowIndex).getCell(this.TB_TAXAMOUNT).setValue((Object)taxAmount);
        }
    }

    public void calTaxAmountByPurchaseCost(int rowIndex, int colIndex) {
        if (this.TB_AMOUNT == null || this.TB_TAX == null || this.TB_TAXRATE == null || this.TB_TAXAMOUNT == null) {
            return;
        }
        int scale = this.getDetailTable().getRow(rowIndex).getCell(this.TB_AMOUNT).getEditor() == null ? 6 : ((KDFormattedTextField)this.getDetailTable().getRow(rowIndex).getCell(this.TB_AMOUNT).getEditor().getComponent()).getPrecision();
        BigDecimal amount = (BigDecimal)this.getDetailTable().getRow(rowIndex).getCell(this.TB_AMOUNT).getValue();
        BigDecimal tax = (BigDecimal)this.getDetailTable().getRow(rowIndex).getCell(this.TB_TAX).getValue();
        amount = this.validateNullValue(amount);
        tax = this.validateNullValue(tax);
        BigDecimal taxAmount = amount.add(tax);
        BigDecimal taxRate = (BigDecimal)this.getDetailTable().getRow(rowIndex).getCell(this.TB_TAXRATE).getValue();
        BigDecimal oneHundred = new BigDecimal("100.0");
        BigDecimal one = new BigDecimal("1.0");
        taxRate = this.validateNullValue(taxRate);
        if (this.chkIsPriceInTax != null && !this.chkIsPriceInTax.isSelected()) {
            taxRate = taxRate.divide(oneHundred, 10, 4);
            taxAmount = amount.divide(one.subtract(taxRate), 10, 4);
        }
        taxAmount = taxAmount.setScale(scale, 4);
        this.getDetailTable().getRow(rowIndex).getCell(this.TB_TAXAMOUNT).setValue((Object)taxAmount);
    }

    public void calTaxAmountByCurrency(int rowIndex, ExchangeRateInfo exchangeRateinfo) {
        if (this.TB_TAXAMOUNT == null || this.TB_LOCALTAXAMOUNT == null || this.TB_TAXAMOUNT == null) {
            return;
        }
        int scale = this.getDetailTable().getRow(rowIndex).getCell(this.TB_TAXAMOUNT).getEditor() == null ? 6 : ((KDFormattedTextField)this.getDetailTable().getRow(rowIndex).getCell(this.TB_TAXAMOUNT).getEditor().getComponent()).getPrecision();
        BigDecimal localTaxAmount = (BigDecimal)this.getDetailTable().getCell(rowIndex, this.TB_LOCALTAXAMOUNT).getValue();
        BigDecimal exchangerate = this.txtExchangeRate.getBigDecimalValue();
        localTaxAmount = this.validateNullValue(localTaxAmount);
        exchangerate = this.validateNullValue(exchangerate);
        if (exchangeRateinfo != null && exchangerate.compareTo(ZERO) != 0) {
            if (exchangeRateinfo.getExchangeAux().getConvertMode() == ConvertModeEnum.DIRECTEXCHANGERATE) {
                this.getDetailTable().getRow(rowIndex).getCell(this.TB_TAXAMOUNT).setValue((Object)localTaxAmount.divide(exchangerate, scale, 4));
            } else {
                this.getDetailTable().getRow(rowIndex).getCell(this.TB_TAXAMOUNT).setValue((Object)localTaxAmount.multiply(exchangerate).setScale(scale, 4));
            }
        } else {
            this.getDetailTable().getRow(rowIndex).getCell(this.TB_TAXAMOUNT).setValue((Object)localTaxAmount);
        }
    }

    public void calTax(int rowIndex, int colIndex) {
        int scale;
        if (this.TB_AMOUNT == null || this.TB_TAXAMOUNT == null || this.TB_TAXRATE == null || this.TB_TAX == null) {
            return;
        }
        int n = scale = this.getDetailTable().getRow(rowIndex).getCell(this.TB_AMOUNT).getEditor() == null ? 6 : ((KDFormattedTextField)this.getDetailTable().getRow(rowIndex).getCell(this.TB_AMOUNT).getEditor().getComponent()).getPrecision();
        if (this.cbIsInTax.isSelected()) {
            BigDecimal one = new BigDecimal("1.0");
            BigDecimal taxAmount = (BigDecimal)this.getDetailTable().getRow(rowIndex).getCell(this.TB_TAXAMOUNT).getValue();
            BigDecimal taxRate = (BigDecimal)this.getDetailTable().getRow(rowIndex).getCell(this.TB_TAXRATE).getValue();
            taxAmount = this.validateNullValue(taxAmount);
            taxRate = this.validateNullValue(taxRate);
            BigDecimal tax = SysConstant.BIGZERO;
            BigDecimal oneHundred = new BigDecimal("100.0");
            if (taxAmount != null && taxRate != null) {
                taxRate = taxRate.divide(oneHundred, 10, 4);
                tax = taxAmount.divide(taxRate.add(one), 10, 4).multiply(taxRate);
                if (this.chkIsPriceInTax != null && !this.chkIsPriceInTax.isSelected()) {
                    tax = taxAmount.multiply(taxRate);
                }
                tax = tax.setScale(scale, 4);
            }
            this.getDetailTable().getRow(rowIndex).getCell(this.TB_TAX).setValue((Object)tax);
        } else {
            BigDecimal amount = (BigDecimal)this.getDetailTable().getRow(rowIndex).getCell(this.TB_AMOUNT).getValue();
            amount = this.validateNullValue(amount);
            BigDecimal taxRate = (BigDecimal)this.getDetailTable().getRow(rowIndex).getCell(this.TB_TAXRATE).getValue();
            BigDecimal tax = CalculateUtils.calTax((BigDecimal)amount, (BigDecimal)(taxRate = this.validateNullValue(taxRate)), (int)scale);
            if (tax != null) {
                this.getDetailTable().getRow(rowIndex).getCell(this.TB_TAX).setValue((Object)tax);
            } else {
                this.getDetailTable().getRow(rowIndex).getCell(this.TB_TAX).setValue((Object)SysConstant.BIGZERO);
            }
        }
    }

    public void calTaxByPurchaseCost(int rowIndex, int colIndex) {
        if (this.TB_AMOUNT == null || this.TB_TAXAMOUNT == null || this.TB_TAXRATE == null || this.TB_TAX == null) {
            return;
        }
        int scale = this.getDetailTable().getRow(rowIndex).getCell(this.TB_AMOUNT).getEditor() == null ? 6 : ((KDFormattedTextField)this.getDetailTable().getRow(rowIndex).getCell(this.TB_AMOUNT).getEditor().getComponent()).getPrecision();
        BigDecimal amount = (BigDecimal)this.getDetailTable().getRow(rowIndex).getCell(this.TB_AMOUNT).getValue();
        BigDecimal taxRate = (BigDecimal)this.getDetailTable().getRow(rowIndex).getCell(this.TB_TAXRATE).getValue();
        BigDecimal taxAmount = (BigDecimal)this.getDetailTable().getRow(rowIndex).getCell(this.TB_TAXAMOUNT).getValue();
        amount = this.validateNullValue(amount);
        taxRate = this.validateNullValue(taxRate);
        taxAmount = this.validateNullValue(taxAmount);
        BigDecimal tax = SysConstant.BIGZERO;
        BigDecimal oneHundred = new BigDecimal("100.0");
        if (amount != null && taxRate != null) {
            taxRate = taxRate.divide(oneHundred, 10, 4);
            tax = amount.multiply(taxRate);
            if (this.chkIsPriceInTax != null && taxAmount != null && !this.chkIsPriceInTax.isSelected()) {
                tax = taxAmount.subtract(amount);
            }
            tax = tax.setScale(scale, 4);
            this.getDetailTable().getRow(rowIndex).getCell(this.TB_TAX).setValue((Object)tax);
        }
        this.getDetailTable().getRow(rowIndex).getCell(this.TB_TAX).setValue((Object)tax);
    }

    public void calTaxByCost(int rowIndex, ExchangeRateInfo exchangeRateinfo) {
        if (this.TB_TAX == null || this.TB_LOCALTAX == null || this.TB_AMOUNT == null) {
            return;
        }
        int scale = this.getDetailTable().getRow(rowIndex).getCell(this.TB_AMOUNT).getEditor() == null ? 6 : ((KDFormattedTextField)this.getDetailTable().getRow(rowIndex).getCell(this.TB_AMOUNT).getEditor().getComponent()).getPrecision();
        BigDecimal localTax = (BigDecimal)this.getDetailTable().getCell(rowIndex, this.TB_LOCALTAX).getValue();
        BigDecimal exchangerate = this.txtExchangeRate.getBigDecimalValue();
        localTax = this.validateNullValue(localTax);
        exchangerate = this.validateNullValue(exchangerate);
        if (exchangeRateinfo != null && exchangerate.compareTo(ZERO) != 0) {
            if (exchangeRateinfo.getExchangeAux().getConvertMode() == ConvertModeEnum.DIRECTEXCHANGERATE) {
                this.getDetailTable().getRow(rowIndex).getCell(this.TB_TAX).setValue((Object)localTax.divide(exchangerate, scale, 4));
            } else {
                this.getDetailTable().getRow(rowIndex).getCell(this.TB_TAX).setValue((Object)localTax.multiply(exchangerate).setScale(scale, 4));
            }
        } else {
            this.getDetailTable().getRow(rowIndex).getCell(this.TB_TAX).setValue((Object)localTax);
        }
    }

    public void calLocalTaxAmount(int rowIndex, ExchangeRateInfo exchangeRateinfo) {
        if (this.TB_LOCALTAXAMOUNT == null || this.TB_TAXAMOUNT == null) {
            return;
        }
        int scale = this.getDetailTable().getRow(rowIndex).getCell(this.TB_LOCALTAXAMOUNT).getEditor() == null ? 6 : ((KDFormattedTextField)this.getDetailTable().getRow(rowIndex).getCell(this.TB_LOCALTAXAMOUNT).getEditor().getComponent()).getPrecision();
        BigDecimal taxAmount = (BigDecimal)this.getDetailTable().getCell(rowIndex, this.TB_TAXAMOUNT).getValue();
        BigDecimal exchangerate = this.txtExchangeRate.getBigDecimalValue();
        taxAmount = this.validateNullValue(taxAmount);
        exchangerate = this.validateNullValue(exchangerate);
        if (exchangeRateinfo != null && exchangerate.compareTo(ZERO) != 0) {
            if (exchangeRateinfo.getExchangeAux().getConvertMode() == ConvertModeEnum.DIRECTEXCHANGERATE) {
                this.getDetailTable().getRow(rowIndex).getCell(this.TB_LOCALTAXAMOUNT).setValue((Object)taxAmount.multiply(exchangerate).setScale(scale, 4));
            } else {
                this.getDetailTable().getRow(rowIndex).getCell(this.TB_LOCALTAXAMOUNT).setValue((Object)taxAmount.divide(exchangerate, scale, 4));
            }
        } else if (exchangeRateinfo == null && exchangerate.compareTo(ZERO) != 0) {
            this.getDetailTable().getRow(rowIndex).getCell(this.TB_LOCALTAXAMOUNT).setValue((Object)taxAmount.multiply(exchangerate).setScale(scale, 4));
        } else {
            this.getDetailTable().getRow(rowIndex).getCell(this.TB_LOCALTAXAMOUNT).setValue((Object)taxAmount);
        }
    }

    public void calLocalTaxAmountByPurchaseCost(int rowIndex) {
        if (this.TB_LOCALTAXAMOUNT == null || this.TB_PURCHASECOST == null || this.TB_TAXRATE == null) {
            return;
        }
        int scale = this.getDetailTable().getRow(rowIndex).getCell(this.TB_LOCALTAXAMOUNT).getEditor() == null ? 6 : ((KDFormattedTextField)this.getDetailTable().getRow(rowIndex).getCell(this.TB_LOCALTAXAMOUNT).getEditor().getComponent()).getPrecision();
        BigDecimal purchaseCost = (BigDecimal)this.getDetailTable().getCell(rowIndex, this.TB_PURCHASECOST).getValue();
        BigDecimal taxRate = (BigDecimal)this.getDetailTable().getCell(rowIndex, this.TB_TAXRATE).getValue();
        purchaseCost = this.validateNullValue(purchaseCost);
        taxRate = this.validateNullValue(taxRate);
        BigDecimal oneHundred = new BigDecimal("100.0");
        BigDecimal one = new BigDecimal("1.0");
        taxRate = taxRate.divide(oneHundred, 10, 4);
        BigDecimal localTaxAmount = purchaseCost.divide(one.subtract(taxRate), 10, 4);
        localTaxAmount = localTaxAmount.setScale(scale, 4);
        this.getDetailTable().getRow(rowIndex).getCell(this.TB_LOCALTAXAMOUNT).setValue((Object)localTaxAmount);
    }

    public void calLocalTaxAmountByUnitPurchaseCost(int rowIndex) {
        if (this.TB_LOCALTAXAMOUNT == null || this.TB_PURCHASECOST == null || this.TB_TAXRATE == null || this.TB_QTY == null) {
            return;
        }
        int scale = this.getDetailTable().getRow(rowIndex).getCell(this.TB_LOCALTAXAMOUNT).getEditor() == null ? 6 : ((KDFormattedTextField)this.getDetailTable().getRow(rowIndex).getCell(this.TB_LOCALTAXAMOUNT).getEditor().getComponent()).getPrecision();
        BigDecimal unitPurchaseCost = (BigDecimal)this.getDetailTable().getCell(rowIndex, this.TB_UNITPURCHASECOST).getValue();
        BigDecimal qty = (BigDecimal)this.getDetailTable().getCell(rowIndex, this.TB_QTY).getValue();
        BigDecimal taxRate = (BigDecimal)this.getDetailTable().getCell(rowIndex, this.TB_TAXRATE).getValue();
        unitPurchaseCost = this.validateNullValue(unitPurchaseCost);
        qty = this.validateNullValue(qty);
        taxRate = this.validateNullValue(taxRate);
        BigDecimal oneHundred = new BigDecimal("100.0");
        BigDecimal one = new BigDecimal("1.0");
        taxRate = taxRate.divide(oneHundred, 10, 4);
        BigDecimal localTaxAmount = unitPurchaseCost.multiply(qty).divide(one.subtract(taxRate), 10, 4);
        localTaxAmount = localTaxAmount.setScale(scale, 4);
        this.getDetailTable().getRow(rowIndex).getCell(this.TB_LOCALTAXAMOUNT).setValue((Object)localTaxAmount);
    }

    public void calLocalTaxAmountByCost(int rowIndex, int colIndex) {
        if (this.TB_LOCALTAXAMOUNT == null || this.TB_PURCHASECOST == null || this.TB_LOCALTAX == null) {
            return;
        }
        int scale = this.getDetailTable().getRow(rowIndex).getCell(this.TB_LOCALTAXAMOUNT).getEditor() == null ? 6 : ((KDFormattedTextField)this.getDetailTable().getRow(rowIndex).getCell(this.TB_LOCALTAXAMOUNT).getEditor().getComponent()).getPrecision();
        BigDecimal purchaseCost = (BigDecimal)this.getDetailTable().getRow(rowIndex).getCell(this.TB_PURCHASECOST).getValue();
        BigDecimal localTax = (BigDecimal)this.getDetailTable().getRow(rowIndex).getCell(this.TB_LOCALTAX).getValue();
        purchaseCost = this.validateNullValue(purchaseCost);
        localTax = this.validateNullValue(localTax);
        BigDecimal localTaxAmount = purchaseCost.add(localTax);
        localTaxAmount = localTaxAmount.setScale(scale, 4);
        this.getDetailTable().getRow(rowIndex).getCell(this.TB_LOCALTAXAMOUNT).setValue((Object)localTaxAmount);
    }

    public void calAmount(int rowIndex, int colIndex) {
        int scale;
        if (this.TB_AMOUNT == null || this.TB_TAXAMOUNT == null || this.TB_TAX == null || this.TB_PRICE == null || this.TB_QTY == null || this.getDetailTable().getRow(rowIndex).getCell("discountRate") == null) {
            return;
        }
        int n = scale = this.getDetailTable().getRow(rowIndex).getCell(this.TB_AMOUNT).getEditor() == null ? 6 : ((KDFormattedTextField)this.getDetailTable().getRow(rowIndex).getCell(this.TB_AMOUNT).getEditor().getComponent()).getPrecision();
        if (this.cbIsInTax.isSelected()) {
            BigDecimal taxAmount = (BigDecimal)this.getDetailTable().getRow(rowIndex).getCell(this.TB_TAXAMOUNT).getValue();
            BigDecimal tax = (BigDecimal)this.getDetailTable().getRow(rowIndex).getCell(this.TB_TAX).getValue();
            taxAmount = this.validateNullValue(taxAmount);
            tax = this.validateNullValue(tax);
            this.getDetailTable().getRow(rowIndex).getCell(this.TB_AMOUNT).setValue((Object)SysConstant.BIGZERO);
            if (taxAmount != null && tax != null) {
                BigDecimal actualTaxPrice = taxAmount.subtract(tax);
                actualTaxPrice = actualTaxPrice.setScale(scale, 4);
                this.getDetailTable().getRow(rowIndex).getCell(this.TB_AMOUNT).setValue((Object)actualTaxPrice);
            }
        } else {
            BigDecimal price = (BigDecimal)this.getDetailTable().getRow(rowIndex).getCell(this.TB_PRICE).getValue();
            BigDecimal discountRate = (BigDecimal)this.getDetailTable().getRow(rowIndex).getCell("discountRate").getValue();
            BigDecimal qty = (BigDecimal)this.getDetailTable().getRow(rowIndex).getCell(this.TB_QTY).getValue();
            BigDecimal one = new BigDecimal("1.0");
            BigDecimal oneHundred = new BigDecimal("100.0");
            price = this.validateNullValue(price);
            discountRate = this.validateNullValue(discountRate);
            qty = this.validateNullValue(qty);
            BigDecimal amount = qty.multiply(price).multiply(one.subtract(discountRate.divide(oneHundred, 10, 4)));
            amount = amount.setScale(scale, 4);
            this.getDetailTable().getRow(rowIndex).getCell(this.TB_AMOUNT).setValue((Object)amount);
        }
    }

    public void calAmountByUnitCost(int rowIndex, int colIndex) {
        if (this.TB_AMOUNT == null || this.TB_PRICE == null || this.TB_QTY == null || this.getDetailTable().getRow(rowIndex).getCell("discountRate") == null) {
            return;
        }
        int scale = this.getDetailTable().getRow(rowIndex).getCell(this.TB_AMOUNT).getEditor() == null ? 6 : ((KDFormattedTextField)this.getDetailTable().getRow(rowIndex).getCell(this.TB_AMOUNT).getEditor().getComponent()).getPrecision();
        BigDecimal price = (BigDecimal)this.getDetailTable().getRow(rowIndex).getCell(this.TB_PRICE).getValue();
        BigDecimal qty = (BigDecimal)this.getDetailTable().getRow(rowIndex).getCell(this.TB_QTY).getValue();
        BigDecimal discountRate = (BigDecimal)this.getDetailTable().getRow(rowIndex).getCell("discountRate").getValue();
        price = this.validateNullValue(price);
        qty = this.validateNullValue(qty);
        discountRate = this.validateNullValue(discountRate);
        BigDecimal amount = CalculateUtils.calAmountByDiscountPercent((BigDecimal)qty, (BigDecimal)price, (BigDecimal)discountRate, (int)scale);
        this.getDetailTable().getRow(rowIndex).getCell(this.TB_AMOUNT).setValue((Object)amount);
    }

    public void calAmountByPurchaseCost(int rowIndex, ExchangeRateInfo exchangeRateinfo) {
        if (this.TB_AMOUNT == null || this.TB_PURCHASECOST == null) {
            return;
        }
        int scale = this.getDetailTable().getRow(rowIndex).getCell(this.TB_AMOUNT).getEditor() == null ? 6 : ((KDFormattedTextField)this.getDetailTable().getRow(rowIndex).getCell(this.TB_AMOUNT).getEditor().getComponent()).getPrecision();
        BigDecimal purchaseCost = (BigDecimal)this.getDetailTable().getCell(rowIndex, this.TB_PURCHASECOST).getValue();
        BigDecimal exchangerate = this.txtExchangeRate.getBigDecimalValue();
        purchaseCost = this.validateNullValue(purchaseCost);
        exchangerate = this.validateNullValue(exchangerate);
        if (exchangeRateinfo != null && exchangerate.compareTo(ZERO) != 0) {
            if (exchangeRateinfo.getExchangeAux().getConvertMode() == ConvertModeEnum.DIRECTEXCHANGERATE) {
                this.getDetailTable().getRow(rowIndex).getCell(this.TB_AMOUNT).setValue((Object)purchaseCost.divide(exchangerate, scale, 4));
            } else {
                this.getDetailTable().getRow(rowIndex).getCell(this.TB_AMOUNT).setValue((Object)purchaseCost.multiply(exchangerate).setScale(scale, 4));
            }
        } else {
            this.getDetailTable().getRow(rowIndex).getCell(this.TB_AMOUNT).setValue((Object)purchaseCost);
        }
    }

    public void calAmountByUnitPurchaseCost(int rowIndex, ExchangeRateInfo exchangeRateinfo) {
        if (this.TB_AMOUNT == null || this.TB_UNITPURCHASECOST == null) {
            return;
        }
        int scale = this.getDetailTable().getRow(rowIndex).getCell(this.TB_AMOUNT).getEditor() == null ? 6 : ((KDFormattedTextField)this.getDetailTable().getRow(rowIndex).getCell(this.TB_AMOUNT).getEditor().getComponent()).getPrecision();
        BigDecimal unitPurchaseCost = (BigDecimal)this.getDetailTable().getCell(rowIndex, this.TB_UNITPURCHASECOST).getValue();
        BigDecimal qty = (BigDecimal)this.getDetailTable().getCell(rowIndex, this.TB_QTY).getValue();
        BigDecimal exchangerate = this.txtExchangeRate.getBigDecimalValue();
        unitPurchaseCost = this.validateNullValue(unitPurchaseCost);
        qty = this.validateNullValue(qty);
        exchangerate = this.validateNullValue(exchangerate);
        if (exchangeRateinfo != null && exchangerate.compareTo(ZERO) != 0) {
            if (exchangeRateinfo.getExchangeAux().getConvertMode() == ConvertModeEnum.DIRECTEXCHANGERATE) {
                this.getDetailTable().getRow(rowIndex).getCell(this.TB_AMOUNT).setValue((Object)unitPurchaseCost.multiply(qty).divide(exchangerate, scale, 4));
            } else {
                this.getDetailTable().getRow(rowIndex).getCell(this.TB_AMOUNT).setValue((Object)unitPurchaseCost.multiply(qty).multiply(exchangerate).setScale(scale, 4));
            }
        } else {
            this.getDetailTable().getRow(rowIndex).getCell(this.TB_AMOUNT).setValue((Object)unitPurchaseCost.multiply(qty).setScale(scale, 4));
        }
    }

    public void calActualPriceByUnitPurchase(int rowIndex, ExchangeRateInfo exchangeRateinfo) {
        if (this.TB_PRICE == null || this.TB_UNITPURCHASECOST == null || this.TB_ACTUALPRICE == null || this.getDetailTable().getRow(rowIndex).getCell("discountRate") == null) {
            return;
        }
        BigDecimal discountRate = (BigDecimal)this.getDetailTable().getRow(rowIndex).getCell("discountRate").getValue();
        int scale = this.getDetailTable().getRow(rowIndex).getCell(this.TB_PRICE).getEditor() == null ? 6 : ((KDFormattedTextField)this.getDetailTable().getRow(rowIndex).getCell(this.TB_PRICE).getEditor().getComponent()).getPrecision();
        BigDecimal unitPurchaseCost = (BigDecimal)this.getDetailTable().getCell(rowIndex, this.TB_UNITPURCHASECOST).getValue();
        BigDecimal exchangerate = this.txtExchangeRate.getBigDecimalValue();
        unitPurchaseCost = this.validateNullValue(unitPurchaseCost);
        exchangerate = this.validateNullValue(exchangerate);
        if (discountRate == null || discountRate.compareTo(ZERO) == 0) {
            BigDecimal price = (BigDecimal)this.getDetailTable().getRow(rowIndex).getCell(this.TB_PRICE).getValue();
            this.getDetailTable().getRow(rowIndex).getCell(this.TB_ACTUALPRICE).setValue((Object)price);
        } else if (exchangeRateinfo != null && exchangerate.compareTo(ZERO) != 0) {
            if (exchangeRateinfo.getExchangeAux().getConvertMode() == ConvertModeEnum.DIRECTEXCHANGERATE) {
                this.getDetailTable().getRow(rowIndex).getCell(this.TB_ACTUALPRICE).setValue((Object)unitPurchaseCost.divide(exchangerate, scale, 4));
            } else {
                this.getDetailTable().getRow(rowIndex).getCell(this.TB_ACTUALPRICE).setValue((Object)unitPurchaseCost.multiply(exchangerate).setScale(scale, 4));
            }
        } else {
            this.getDetailTable().getRow(rowIndex).getCell(this.TB_ACTUALPRICE).setValue((Object)unitPurchaseCost.setScale(scale, 4));
        }
    }

    public void calLocalTax(int rowIndex, ExchangeRateInfo exchangeRateinfo) {
        if (this.TB_LOCALTAXAMOUNT == null || this.TB_TAX == null || this.TB_LOCALTAX == null) {
            return;
        }
        int scale = this.getDetailTable().getRow(rowIndex).getCell(this.TB_LOCALTAXAMOUNT).getEditor() == null ? 6 : ((KDFormattedTextField)this.getDetailTable().getRow(rowIndex).getCell(this.TB_LOCALTAXAMOUNT).getEditor().getComponent()).getPrecision();
        BigDecimal tax = (BigDecimal)this.getDetailTable().getCell(rowIndex, this.TB_TAX).getValue();
        BigDecimal exchangerate = this.txtExchangeRate.getBigDecimalValue();
        tax = this.validateNullValue(tax);
        exchangerate = this.validateNullValue(exchangerate);
        if (exchangeRateinfo != null && exchangerate.compareTo(ZERO) != 0) {
            if (exchangeRateinfo.getExchangeAux().getConvertMode() == ConvertModeEnum.DIRECTEXCHANGERATE) {
                this.getDetailTable().getRow(rowIndex).getCell(this.TB_LOCALTAX).setValue((Object)tax.multiply(exchangerate).setScale(scale, 4));
            } else {
                this.getDetailTable().getRow(rowIndex).getCell(this.TB_LOCALTAX).setValue((Object)tax.divide(exchangerate, scale, 4));
            }
        } else if (exchangeRateinfo == null && exchangerate.compareTo(ZERO) != 0) {
            this.getDetailTable().getRow(rowIndex).getCell(this.TB_LOCALTAX).setValue((Object)tax.multiply(exchangerate).setScale(scale, 4));
        } else {
            this.getDetailTable().getRow(rowIndex).getCell(this.TB_LOCALTAX).setValue((Object)tax);
        }
    }

    public void calLocalTaxByCost(int rowIndex) {
        if (this.TB_LOCALTAXAMOUNT == null || this.TB_PURCHASECOST == null || this.TB_TAXRATE == null) {
            return;
        }
        int scale = this.getDetailTable().getRow(rowIndex).getCell(this.TB_LOCALTAXAMOUNT).getEditor() == null ? 6 : ((KDFormattedTextField)this.getDetailTable().getRow(rowIndex).getCell(this.TB_LOCALTAXAMOUNT).getEditor().getComponent()).getPrecision();
        BigDecimal purchaseCost = (BigDecimal)this.getDetailTable().getCell(rowIndex, this.TB_PURCHASECOST).getValue();
        BigDecimal taxRate = (BigDecimal)this.getDetailTable().getCell(rowIndex, this.TB_TAXRATE).getValue();
        purchaseCost = this.validateNullValue(purchaseCost);
        taxRate = this.validateNullValue(taxRate);
        BigDecimal oneHundred = new BigDecimal("100.0");
        taxRate = taxRate.divide(oneHundred, 10, 4);
        this.getDetailTable().getRow(rowIndex).getCell(this.TB_LOCALTAX).setValue((Object)purchaseCost.multiply(taxRate).setScale(scale, 4));
    }

    public void calLocalTaxByUnitPurchaseCost(int rowIndex) {
        if (this.TB_LOCALTAXAMOUNT == null || this.TB_UNITPURCHASECOST == null || this.TB_TAXRATE == null || this.TB_QTY == null) {
            return;
        }
        int scale = this.getDetailTable().getRow(rowIndex).getCell(this.TB_LOCALTAXAMOUNT).getEditor() == null ? 6 : ((KDFormattedTextField)this.getDetailTable().getRow(rowIndex).getCell(this.TB_LOCALTAXAMOUNT).getEditor().getComponent()).getPrecision();
        BigDecimal unitPurchaseCost = (BigDecimal)this.getDetailTable().getCell(rowIndex, this.TB_UNITPURCHASECOST).getValue();
        BigDecimal qty = (BigDecimal)this.getDetailTable().getCell(rowIndex, this.TB_QTY).getValue();
        BigDecimal taxRate = (BigDecimal)this.getDetailTable().getCell(rowIndex, this.TB_TAXRATE).getValue();
        unitPurchaseCost = this.validateNullValue(unitPurchaseCost);
        qty = this.validateNullValue(qty);
        taxRate = this.validateNullValue(taxRate);
        BigDecimal oneHundred = new BigDecimal("100.0");
        taxRate = taxRate.divide(oneHundred, 10, 4);
        this.getDetailTable().getRow(rowIndex).getCell(this.TB_LOCALTAX).setValue((Object)unitPurchaseCost.multiply(qty).multiply(taxRate).setScale(scale, 4));
    }

    public void calLocalTaxByPurchaseCost(int rowIndex) {
        if (this.TB_LOCALTAXAMOUNT == null || this.TB_LOCALTAX == null || this.TB_PURCHASECOST == null) {
            return;
        }
        int scale = this.getDetailTable().getRow(rowIndex).getCell(this.TB_LOCALTAXAMOUNT).getEditor() == null ? 6 : ((KDFormattedTextField)this.getDetailTable().getRow(rowIndex).getCell(this.TB_LOCALTAXAMOUNT).getEditor().getComponent()).getPrecision();
        BigDecimal localTaxAmount = (BigDecimal)this.getDetailTable().getRow(rowIndex).getCell(this.TB_LOCALTAXAMOUNT).getValue();
        BigDecimal purchaseCost = (BigDecimal)this.getDetailTable().getRow(rowIndex).getCell(this.TB_PURCHASECOST).getValue();
        localTaxAmount = this.validateNullValue(localTaxAmount);
        purchaseCost = this.validateNullValue(purchaseCost);
        BigDecimal localTax = SysConstant.BIGZERO;
        localTax = localTaxAmount.subtract(purchaseCost);
        localTax = localTax.setScale(scale, 4);
        this.getDetailTable().getRow(rowIndex).getCell(this.TB_LOCALTAX).setValue((Object)localTax);
    }

    public void calActualTaxPrice(int rowIndex, int colIndex) {
        int scale;
        if (this.TB_PRICE == null || this.TB_TAXPRICE == null || this.TB_ACTUALTAXPRICE == null || this.TB_TAXAMOUNT == null || this.TB_QTY == null || this.getDetailTable().getRow(rowIndex).getCell("discountRate") == null) {
            return;
        }
        BigDecimal discountRate = (BigDecimal)this.getDetailTable().getRow(rowIndex).getCell("discountRate").getValue();
        BigDecimal zero = new BigDecimal("0.0");
        int n = scale = this.getDetailTable().getRow(rowIndex).getCell(this.TB_PRICE).getEditor() == null ? 6 : ((KDFormattedTextField)this.getDetailTable().getRow(rowIndex).getCell(this.TB_PRICE).getEditor().getComponent()).getPrecision();
        if (discountRate == null || discountRate.compareTo(ZERO) == 0) {
            BigDecimal taxPrice = (BigDecimal)this.getDetailTable().getRow(rowIndex).getCell(this.TB_TAXPRICE).getValue();
            taxPrice = this.validateNullValue(taxPrice);
            this.getDetailTable().getRow(rowIndex).getCell(this.TB_ACTUALTAXPRICE).setValue((Object)taxPrice.abs());
        } else {
            BigDecimal taxAmount = (BigDecimal)this.getDetailTable().getRow(rowIndex).getCell(this.TB_TAXAMOUNT).getValue();
            BigDecimal qty = (BigDecimal)this.getDetailTable().getRow(rowIndex).getCell(this.TB_QTY).getValue();
            taxAmount = this.validateNullValue(taxAmount);
            qty = this.validateNullValue(qty);
            BigDecimal actualTaxPrice = SysConstant.BIGZERO;
            if (taxAmount != null && qty != null && qty.compareTo(zero) != 0) {
                actualTaxPrice = taxAmount.divide(qty, scale, 4);
                this.getDetailTable().getRow(rowIndex).getCell(this.TB_ACTUALTAXPRICE).setValue((Object)actualTaxPrice);
            }
        }
    }

    public void calActualPrice(int rowIndex, int colIndex) {
        if (this.TB_PRICE == null || this.TB_AMOUNT == null || this.TB_QTY == null || this.TB_ACTUALPRICE == null || this.TB_PRICE == null || this.getDetailTable().getRow(rowIndex).getCell("discountRate") == null) {
            return;
        }
        BigDecimal zero = new BigDecimal("0.0");
        int scale = this.getDetailTable().getRow(rowIndex).getCell(this.TB_PRICE).getEditor() == null ? 6 : ((KDFormattedTextField)this.getDetailTable().getRow(rowIndex).getCell(this.TB_PRICE).getEditor().getComponent()).getPrecision();
        BigDecimal amount = (BigDecimal)this.getDetailTable().getRow(rowIndex).getCell(this.TB_AMOUNT).getValue();
        BigDecimal qty = (BigDecimal)this.getDetailTable().getRow(rowIndex).getCell(this.TB_QTY).getValue();
        amount = this.validateNullValue(amount);
        qty = this.validateNullValue(qty);
        BigDecimal discountRate = (BigDecimal)this.getDetailTable().getRow(rowIndex).getCell("discountRate").getValue();
        if (discountRate == null || discountRate.compareTo(ZERO) == 0) {
            BigDecimal price = (BigDecimal)this.getDetailTable().getRow(rowIndex).getCell(this.TB_PRICE).getValue();
            this.getDetailTable().getRow(rowIndex).getCell(this.TB_ACTUALPRICE).setValue((Object)price);
        } else if (amount != null && qty != null && qty.compareTo(zero) != 0) {
            BigDecimal actualPrice = amount.divide(qty, scale, 4);
            this.getDetailTable().getRow(rowIndex).getCell(this.TB_ACTUALPRICE).setValue((Object)actualPrice);
        }
    }

    public void calPurchaseCost(int rowIndex, ExchangeRateInfo exchangeRateinfo) {
        int scale;
        if (this.TB_ACTUALCOST == null || this.TB_LOCALTAXAMOUNT == null || this.TB_LOCALTAX == null || this.TB_PURCHASECOST == null || this.TB_UNITPURCHASECOST == null || this.TB_QTY == null) {
            return;
        }
        int n = scale = this.getDetailTable().getRow(rowIndex).getCell(this.TB_ACTUALCOST).getEditor() == null ? 6 : ((KDFormattedTextField)this.getDetailTable().getRow(rowIndex).getCell(this.TB_ACTUALCOST).getEditor().getComponent()).getPrecision();
        if (this.cbIsInTax.isSelected()) {
            BigDecimal localTaxAmount = (BigDecimal)this.getDetailTable().getRow(rowIndex).getCell(this.TB_LOCALTAXAMOUNT).getValue();
            BigDecimal localTax = (BigDecimal)this.getDetailTable().getRow(rowIndex).getCell(this.TB_LOCALTAX).getValue();
            localTaxAmount = this.validateNullValue(localTaxAmount);
            localTax = this.validateNullValue(localTax);
            BigDecimal purchaseCost = SysConstant.BIGZERO;
            purchaseCost = localTaxAmount.subtract(localTax);
            purchaseCost = purchaseCost.setScale(scale, 4);
            this.getDetailTable().getRow(rowIndex).getCell(this.TB_PURCHASECOST).setValue((Object)purchaseCost);
        } else {
            BigDecimal unitPurchaseCost = (BigDecimal)this.getDetailTable().getRow(rowIndex).getCell(this.TB_UNITPURCHASECOST).getValue();
            BigDecimal qty = (BigDecimal)this.getDetailTable().getRow(rowIndex).getCell(this.TB_QTY).getValue();
            unitPurchaseCost = this.validateNullValue(unitPurchaseCost);
            qty = this.validateNullValue(qty);
            BigDecimal purchaseCost = SysConstant.BIGZERO;
            purchaseCost = unitPurchaseCost.multiply(qty);
            this.getDetailTable().getRow(rowIndex).getCell(this.TB_PURCHASECOST).setValue((Object)purchaseCost);
        }
    }

    public BigDecimal calPurchaseCostByUnitCost(int rowIndex, int scale, ExchangeRateInfo exchangeRateinfo) {
        if (this.TB_ACTUALCOST == null || this.TB_UNITPURCHASECOST == null || this.TB_QTY == null || this.TB_PURCHASECOST == null) {
            return SysConstant.BIGZERO;
        }
        BigDecimal unitPurchaseCost = (BigDecimal)this.getDetailTable().getRow(rowIndex).getCell(this.TB_UNITPURCHASECOST).getValue();
        BigDecimal qty = (BigDecimal)this.getDetailTable().getRow(rowIndex).getCell(this.TB_QTY).getValue();
        unitPurchaseCost = this.validateNullValue(unitPurchaseCost);
        qty = this.validateNullValue(qty);
        return unitPurchaseCost.multiply(qty).setScale(scale, 4);
    }

    public void calPurchaseCostByPrice(int rowIndex, ExchangeRateInfo exchangeRateinfo) {
        if (this.TB_ACTUALCOST == null || this.TB_LOCALTAXAMOUNT == null || this.TB_LOCALTAX == null || this.TB_PURCHASECOST == null || this.TB_UNITPURCHASECOST == null || this.TB_QTY == null) {
            return;
        }
        int scale = this.getDetailTable().getRow(rowIndex).getCell(this.TB_ACTUALCOST).getEditor() == null ? 6 : ((KDFormattedTextField)this.getDetailTable().getRow(rowIndex).getCell(this.TB_ACTUALCOST).getEditor().getComponent()).getPrecision();
        BigDecimal localTaxAmount = (BigDecimal)this.getDetailTable().getRow(rowIndex).getCell(this.TB_LOCALTAXAMOUNT).getValue();
        BigDecimal localTax = (BigDecimal)this.getDetailTable().getRow(rowIndex).getCell(this.TB_LOCALTAX).getValue();
        localTaxAmount = this.validateNullValue(localTaxAmount);
        localTax = this.validateNullValue(localTax);
        BigDecimal purchaseCost = SysConstant.BIGZERO;
        purchaseCost = localTaxAmount.subtract(localTax);
        purchaseCost = purchaseCost.setScale(scale, 4);
        this.getDetailTable().getRow(rowIndex).getCell(this.TB_PURCHASECOST).setValue((Object)purchaseCost);
    }

    public void calPurchaseCostByUnitCost(int rowIndex) {
        if (this.TB_ACTUALCOST == null || this.TB_UNITPURCHASECOST == null || this.TB_QTY == null || this.TB_PURCHASECOST == null) {
            return;
        }
        int scale = this.getDetailTable().getRow(rowIndex).getCell(this.TB_ACTUALCOST).getEditor() == null ? 6 : ((KDFormattedTextField)this.getDetailTable().getRow(rowIndex).getCell(this.TB_ACTUALCOST).getEditor().getComponent()).getPrecision();
        BigDecimal unitPurchaseCost = (BigDecimal)this.getDetailTable().getRow(rowIndex).getCell(this.TB_UNITPURCHASECOST).getValue();
        BigDecimal qty = (BigDecimal)this.getDetailTable().getRow(rowIndex).getCell(this.TB_QTY).getValue();
        unitPurchaseCost = this.validateNullValue(unitPurchaseCost);
        qty = this.validateNullValue(qty);
        BigDecimal purchaseCost = SysConstant.BIGZERO;
        purchaseCost = unitPurchaseCost.multiply(qty).setScale(scale, 4);
        this.getDetailTable().getRow(rowIndex).getCell(this.TB_PURCHASECOST).setValue((Object)purchaseCost);
    }

    public void calPurchaseCostByActualCost(int rowIndex) {
        if (this.TB_ACTUALCOST == null || this.TB_PURCHASEFEE == null || this.TB_MATERIALCOST == null || this.TB_PURCHASECOST == null) {
            return;
        }
        int scale = this.getDetailTable().getRow(rowIndex).getCell(this.TB_ACTUALCOST).getEditor() == null ? 6 : ((KDFormattedTextField)this.getDetailTable().getRow(rowIndex).getCell(this.TB_ACTUALCOST).getEditor().getComponent()).getPrecision();
        BigDecimal actualCost = (BigDecimal)this.getDetailTable().getRow(rowIndex).getCell(this.TB_ACTUALCOST).getValue();
        BigDecimal purchaseFee = (BigDecimal)this.getDetailTable().getRow(rowIndex).getCell(this.TB_PURCHASEFEE).getValue();
        BigDecimal materialCost = (BigDecimal)this.getDetailTable().getRow(rowIndex).getCell(this.TB_MATERIALCOST).getValue();
        actualCost = this.validateNullValue(actualCost);
        purchaseFee = this.validateNullValue(purchaseFee);
        materialCost = this.validateNullValue(materialCost);
        BigDecimal purchaseCost = SysConstant.BIGZERO;
        purchaseCost = actualCost.subtract(purchaseFee).subtract(materialCost);
        purchaseCost = purchaseCost.setScale(scale, 4);
        this.getDetailTable().getRow(rowIndex).getCell(this.TB_PURCHASECOST).setValue((Object)purchaseCost);
    }

    public void calPurchaseCostByAmount(int rowIndex, ExchangeRateInfo exchangeRateinfo) {
        if (this.TB_ACTUALCOST == null || this.TB_AMOUNT == null || this.TB_PURCHASECOST == null) {
            return;
        }
        int scale = this.getDetailTable().getRow(rowIndex).getCell(this.TB_ACTUALCOST).getEditor() == null ? 6 : ((KDFormattedTextField)this.getDetailTable().getRow(rowIndex).getCell(this.TB_ACTUALCOST).getEditor().getComponent()).getPrecision();
        BigDecimal exchangerate = this.txtExchangeRate.getBigDecimalValue();
        exchangerate = this.validateNullValue(exchangerate);
        BigDecimal amount = (BigDecimal)this.getDetailTable().getRow(rowIndex).getCell(this.TB_AMOUNT).getValue();
        amount = this.validateNullValue(amount);
        if (exchangeRateinfo != null && exchangerate.compareTo(ZERO) != 0) {
            if (exchangeRateinfo.getExchangeAux().getConvertMode() == ConvertModeEnum.DIRECTEXCHANGERATE) {
                this.getDetailTable().getRow(rowIndex).getCell(this.TB_PURCHASECOST).setValue((Object)amount.multiply(exchangerate).setScale(scale, 4));
            } else {
                this.getDetailTable().getRow(rowIndex).getCell(this.TB_PURCHASECOST).setValue((Object)amount.divide(exchangerate, scale, 4));
            }
        } else {
            this.getDetailTable().getRow(rowIndex).getCell(this.TB_PURCHASECOST).setValue((Object)amount);
        }
    }

    public void calUnitPurchaseCost(int rowIndex, ExchangeRateInfo exchangeRateinfo) {
        if (this.TB_PRICE == null || this.TB_QTY == null || this.TB_PURCHASECOST == null || this.TB_ACTUALPRICE == null || this.TB_UNITPURCHASECOST == null) {
            return;
        }
        int scale = this.getDetailTable().getRow(rowIndex).getCell(this.TB_PRICE).getEditor() == null ? 6 : ((KDFormattedTextField)this.getDetailTable().getRow(rowIndex).getCell(this.TB_PRICE).getEditor().getComponent()).getPrecision();
        BigDecimal exchangerate = this.txtExchangeRate.getBigDecimalValue();
        exchangerate = this.validateNullValue(exchangerate);
        if (this.cbIsInTax.isSelected()) {
            BigDecimal purchaseCost = (BigDecimal)this.getDetailTable().getRow(rowIndex).getCell(this.TB_PURCHASECOST).getValue();
            BigDecimal qty = (BigDecimal)this.getDetailTable().getRow(rowIndex).getCell(this.TB_QTY).getValue();
            BigDecimal actualPrice = (BigDecimal)this.getDetailTable().getRow(rowIndex).getCell(this.TB_ACTUALPRICE).getValue();
            BigDecimal unitPurchaseCost = SysConstant.BIGZERO;
            if (exchangerate.compareTo(ONE) == 0) {
                this.getDetailTable().getRow(rowIndex).getCell(this.TB_UNITPURCHASECOST).setValue((Object)actualPrice);
            } else if (purchaseCost != null && qty != null && qty.compareTo(ZERO) != 0) {
                unitPurchaseCost = purchaseCost.divide(qty, scale, 4);
                this.getDetailTable().getRow(rowIndex).getCell(this.TB_UNITPURCHASECOST).setValue((Object)unitPurchaseCost);
            }
        } else {
            BigDecimal actualPrice = (BigDecimal)this.getDetailTable().getRow(rowIndex).getCell(this.TB_ACTUALPRICE).getValue();
            actualPrice = this.validateNullValue(actualPrice);
            if (exchangeRateinfo != null && exchangerate.compareTo(ZERO) != 0) {
                if (exchangeRateinfo.getExchangeAux().getConvertMode() == ConvertModeEnum.DIRECTEXCHANGERATE) {
                    this.getDetailTable().getRow(rowIndex).getCell(this.TB_UNITPURCHASECOST).setValue((Object)actualPrice.multiply(exchangerate).setScale(scale, 4));
                } else {
                    this.getDetailTable().getRow(rowIndex).getCell(this.TB_UNITPURCHASECOST).setValue((Object)actualPrice.divide(exchangerate, scale, 4));
                }
            } else {
                this.getDetailTable().getRow(rowIndex).getCell(this.TB_UNITPURCHASECOST).setValue((Object)actualPrice);
            }
        }
    }

    public void calUnitPurchaseCostByAmount(int rowIndex, ExchangeRateInfo exchangeRateinfo) {
        if (this.TB_PRICE == null || this.TB_QTY == null || this.TB_PURCHASECOST == null || this.TB_ACTUALPRICE == null || this.TB_UNITPURCHASECOST == null) {
            return;
        }
        int scale = this.getDetailTable().getRow(rowIndex).getCell(this.TB_PRICE).getEditor() == null ? 6 : ((KDFormattedTextField)this.getDetailTable().getRow(rowIndex).getCell(this.TB_PRICE).getEditor().getComponent()).getPrecision();
        BigDecimal exchangerate = this.txtExchangeRate.getBigDecimalValue();
        exchangerate = this.validateNullValue(exchangerate);
        BigDecimal purchaseCost = (BigDecimal)this.getDetailTable().getRow(rowIndex).getCell(this.TB_PURCHASECOST).getValue();
        BigDecimal qty = (BigDecimal)this.getDetailTable().getRow(rowIndex).getCell(this.TB_QTY).getValue();
        BigDecimal actualPrice = (BigDecimal)this.getDetailTable().getRow(rowIndex).getCell(this.TB_ACTUALPRICE).getValue();
        purchaseCost = this.validateNullValue(purchaseCost);
        qty = this.validateNullValue(qty);
        actualPrice = this.validateNullValue(actualPrice);
        BigDecimal unitPurchaseCost = SysConstant.BIGZERO;
        if (exchangerate.compareTo(ONE) == 0) {
            this.getDetailTable().getRow(rowIndex).getCell(this.TB_UNITPURCHASECOST).setValue((Object)actualPrice);
        } else if (purchaseCost != null && qty != null && qty.compareTo(ZERO) != 0) {
            unitPurchaseCost = purchaseCost.divide(qty, scale, 4);
            this.getDetailTable().getRow(rowIndex).getCell(this.TB_UNITPURCHASECOST).setValue((Object)unitPurchaseCost);
        }
    }

    public void calUnitPurchaseCostByPurchaseCost(int rowIndex) {
        if (this.TB_QTY == null || this.TB_PURCHASECOST == null || this.TB_UNITPURCHASECOST == null) {
            return;
        }
        int scale = this.getDetailTable().getRow(rowIndex).getCell(this.TB_PRICE).getEditor() == null ? 6 : ((KDFormattedTextField)this.getDetailTable().getRow(rowIndex).getCell(this.TB_PRICE).getEditor().getComponent()).getPrecision();
        BigDecimal purchaseCost = (BigDecimal)this.getDetailTable().getRow(rowIndex).getCell(this.TB_PURCHASECOST).getValue();
        BigDecimal qty = (BigDecimal)this.getDetailTable().getRow(rowIndex).getCell(this.TB_QTY).getValue();
        purchaseCost = this.validateNullValue(purchaseCost);
        qty = this.validateNullValue(qty);
        BigDecimal unitPurchaseCost = SysConstant.BIGZERO;
        if (purchaseCost != null && qty != null && qty.compareTo(ZERO) != 0) {
            unitPurchaseCost = purchaseCost.divide(qty, scale, 4);
            this.getDetailTable().getRow(rowIndex).getCell(this.TB_UNITPURCHASECOST).setValue((Object)unitPurchaseCost);
        }
    }

    public void calActualCost(int rowIndex) {
        if (this.TB_ACTUALCOST == null || this.TB_PURCHASEFEE == null || this.TB_PURCHASECOST == null || this.TB_MATERIALCOST == null) {
            return;
        }
        int scale = this.getDetailTable().getRow(rowIndex).getCell(this.TB_ACTUALCOST).getEditor() == null ? 6 : ((KDFormattedTextField)this.getDetailTable().getRow(rowIndex).getCell(this.TB_ACTUALCOST).getEditor().getComponent()).getPrecision();
        BigDecimal purchaseCost = (BigDecimal)this.getDetailTable().getRow(rowIndex).getCell(this.TB_PURCHASECOST).getValue();
        BigDecimal purchaseFee = (BigDecimal)this.getDetailTable().getRow(rowIndex).getCell(this.TB_PURCHASEFEE).getValue();
        BigDecimal materialCost = (BigDecimal)this.getDetailTable().getRow(rowIndex).getCell(this.TB_MATERIALCOST).getValue();
        purchaseCost = this.validateNullValue(purchaseCost);
        purchaseFee = this.validateNullValue(purchaseFee);
        materialCost = this.validateNullValue(materialCost);
        this.getDetailTable().getRow(rowIndex).getCell(this.TB_ACTUALCOST).setValue((Object)purchaseCost.add(purchaseFee).add(materialCost).setScale(scale, 4));
    }

    public void calActualCostByUnitCost(int rowIndex) {
        if (this.TB_ACTUALCOST == null || this.TB_UNITACTUALCOST == null || this.TB_QTY == null) {
            return;
        }
        int scale = this.getDetailTable().getRow(rowIndex).getCell(this.TB_ACTUALCOST).getEditor() == null ? 6 : ((KDFormattedTextField)this.getDetailTable().getRow(rowIndex).getCell(this.TB_ACTUALCOST).getEditor().getComponent()).getPrecision();
        BigDecimal unitActualCost = (BigDecimal)this.getDetailTable().getRow(rowIndex).getCell(this.TB_UNITACTUALCOST).getValue();
        BigDecimal qty = (BigDecimal)this.getDetailTable().getRow(rowIndex).getCell(this.TB_QTY).getValue();
        unitActualCost = this.validateNullValue(unitActualCost);
        qty = this.validateNullValue(qty);
        this.getDetailTable().getRow(rowIndex).getCell(this.TB_ACTUALCOST).setValue((Object)unitActualCost.multiply(qty).setScale(scale, 4));
    }

    public void calUnitActualCost(int rowIndex, ExchangeRateInfo exchangeRateinfo) {
        if (this.TB_PRICE == null || this.TB_ACTUALCOST == null || this.TB_QTY == null || this.TB_UNITACTUALCOST == null) {
            return;
        }
        IRow row = this.getDetailTable().getRow(rowIndex);
        int scale = row.getCell(this.TB_PRICE).getEditor() == null ? 6 : ((KDFormattedTextField)row.getCell(this.TB_PRICE).getEditor().getComponent()).getPrecision();
        BigDecimal qty = (BigDecimal)row.getCell(this.TB_QTY).getValue();
        BigDecimal actualCost = null;
        BigDecimal purchaseFee = null == this.TB_PURCHASEFEE ? SysConstant.BIGZERO : (BigDecimal)row.getCell(this.TB_PURCHASEFEE).getValue();
        BigDecimal materialCost = null == this.TB_MATERIALCOST ? SysConstant.BIGZERO : (BigDecimal)row.getCell(this.TB_MATERIALCOST).getValue();
        BigDecimal purchaseCost = this.calPurchaseCostByUnitCost(rowIndex, scale + 2, exchangeRateinfo);
        qty = this.validateNullValue(qty);
        purchaseFee = this.validateNullValue(purchaseFee);
        materialCost = this.validateNullValue(materialCost);
        purchaseCost = this.validateNullValue(purchaseCost);
        actualCost = purchaseFee.add(materialCost).add(purchaseCost);
        if (qty.compareTo(SysConstant.BIGZERO) == 0) {
            row.getCell(this.TB_UNITACTUALCOST).setValue((Object)SysConstant.BIGZERO.setScale(scale));
        } else {
            row.getCell(this.TB_UNITACTUALCOST).setValue((Object)actualCost.divide(qty, scale, 4));
        }
    }

    public void calUnitActualCost(int rowIndex) {
        if (this.TB_PRICE == null || this.TB_ACTUALCOST == null || this.TB_QTY == null || this.TB_UNITACTUALCOST == null) {
            return;
        }
        BigDecimal zero = new BigDecimal("0.0");
        int scale = this.getDetailTable().getRow(rowIndex).getCell(this.TB_PRICE).getEditor() == null ? 6 : ((KDFormattedTextField)this.getDetailTable().getRow(rowIndex).getCell(this.TB_PRICE).getEditor().getComponent()).getPrecision();
        BigDecimal actualCost = null;
        BigDecimal unitPurchaseCost = (BigDecimal)this.getDetailTable().getRow(rowIndex).getCell(this.TB_UNITPURCHASECOST).getValue();
        BigDecimal purchaseFee = (BigDecimal)this.getDetailTable().getRow(rowIndex).getCell(this.TB_PURCHASEFEE).getValue();
        BigDecimal materialCost = (BigDecimal)this.getDetailTable().getRow(rowIndex).getCell(this.TB_MATERIALCOST).getValue();
        BigDecimal purchaseCost = (BigDecimal)this.getDetailTable().getRow(rowIndex).getCell(this.TB_PURCHASECOST).getValue();
        if (this.TB_PURCHASEFEE == null || this.TB_PURCHASECOST == null || this.TB_MATERIALCOST == null || purchaseCost != null && purchaseFee != null && materialCost != null && purchaseCost.compareTo(zero) == 0 && purchaseFee.compareTo(zero) == 0 && materialCost.compareTo(zero) == 0) {
            actualCost = (BigDecimal)this.getDetailTable().getRow(rowIndex).getCell(this.TB_ACTUALCOST).getValue();
        } else {
            int tempScale = this.getDetailTable().getRow(rowIndex).getCell(this.TB_ACTUALCOST).getEditor() == null ? 6 : ((KDFormattedTextField)this.getDetailTable().getRow(rowIndex).getCell(this.TB_ACTUALCOST).getEditor().getComponent()).getPrecision();
            purchaseCost = this.validateNullValue(purchaseCost);
            purchaseFee = this.validateNullValue(purchaseFee);
            materialCost = this.validateNullValue(materialCost);
            actualCost = purchaseCost.add(purchaseFee).add(materialCost).setScale(tempScale + 2, 4);
        }
        BigDecimal qty = (BigDecimal)this.getDetailTable().getRow(rowIndex).getCell(this.TB_QTY).getValue();
        qty = this.validateNullValue(qty);
        actualCost = this.validateNullValue(actualCost);
        if (purchaseFee.compareTo(zero) == 0 && materialCost.compareTo(zero) == 0 && unitPurchaseCost != null && unitPurchaseCost.compareTo(zero) != 0) {
            this.getDetailTable().getRow(rowIndex).getCell(this.TB_UNITACTUALCOST).setValue((Object)unitPurchaseCost);
        } else if (qty.compareTo(zero) != 0) {
            this.getDetailTable().getRow(rowIndex).getCell(this.TB_UNITACTUALCOST).setValue((Object)actualCost.divide(qty, scale, 4));
        }
    }

    public void calTaxPricebyPrice(int rowIndex, int colIndex) {
        if (this.TB_PRICE == null || this.TB_TAXRATE == null || this.TB_TAXPRICE == null) {
            return;
        }
        BigDecimal price = (BigDecimal)this.getDetailTable().getRow(rowIndex).getCell(this.TB_PRICE).getValue();
        BigDecimal taxRate = (BigDecimal)this.getDetailTable().getRow(rowIndex).getCell(this.TB_TAXRATE).getValue();
        price = this.validateNullValue(price);
        taxRate = this.validateNullValue(taxRate);
        int scale = this.getDetailTable().getRow(rowIndex).getCell(this.TB_TAXPRICE).getEditor() == null ? 6 : ((KDFormattedTextField)this.getDetailTable().getRow(rowIndex).getCell(this.TB_TAXPRICE).getEditor().getComponent()).getPrecision();
        BigDecimal taxPrice = CalculateUtils.calTaxPrice((BigDecimal)price, (BigDecimal)taxRate, (int)scale);
        if (this.chkIsPriceInTax != null && !this.chkIsPriceInTax.isSelected()) {
            taxPrice = CalculateUtils.calTaxPriceByPurchaseCost((BigDecimal)price, (BigDecimal)taxRate, (int)scale);
        }
        this.getDetailTable().getRow(rowIndex).getCell(this.TB_TAXPRICE).setValue((Object)taxPrice);
    }

    public void calActualTaxPriceByUnitPurchaseCost(int rowIndex, int colIndex) {
        if (this.TB_PRICE == null || this.TB_TAXRATE == null || this.TB_ACTUALPRICE == null || this.TB_ACTUALTAXPRICE == null) {
            return;
        }
        BigDecimal actualPrice = (BigDecimal)this.getDetailTable().getRow(rowIndex).getCell(this.TB_ACTUALPRICE).getValue();
        BigDecimal taxRate = (BigDecimal)this.getDetailTable().getRow(rowIndex).getCell(this.TB_TAXRATE).getValue();
        actualPrice = this.validateNullValue(actualPrice);
        taxRate = this.validateNullValue(taxRate);
        int scale = this.getDetailTable().getRow(rowIndex).getCell(this.TB_PRICE).getEditor() == null ? 6 : ((KDFormattedTextField)this.getDetailTable().getRow(rowIndex).getCell(this.TB_PRICE).getEditor().getComponent()).getPrecision();
        BigDecimal actualTaxPrice = CalculateUtils.calTaxPrice((BigDecimal)actualPrice, (BigDecimal)taxRate, (int)scale);
        if (this.chkIsPriceInTax != null && !this.chkIsPriceInTax.isSelected()) {
            actualTaxPrice = CalculateUtils.calTaxPriceByPurchaseCost((BigDecimal)actualPrice, (BigDecimal)taxRate, (int)scale);
        }
        this.getDetailTable().getRow(rowIndex).getCell(this.TB_ACTUALTAXPRICE).setValue((Object)actualTaxPrice);
    }

    public void calTaxPrice(int rowIndex, int colIndex) {
        if (this.TB_QTY == null || this.TB_TAXAMOUNT == null || this.TB_TAXPRICE == null || this.TB_PRICE == null || this.TB_TAXRATE == null || this.getDetailTable().getRow(rowIndex).getCell("discountRate") == null) {
            return;
        }
        BigDecimal discountRate = (BigDecimal)this.getDetailTable().getRow(rowIndex).getCell("discountRate").getValue();
        if (discountRate == null) {
            discountRate = new BigDecimal("0.00");
        }
        if (this.cbIsInTax.isSelected()) {
            BigDecimal qty = (BigDecimal)this.getDetailTable().getRow(rowIndex).getCell(this.TB_QTY).getValue();
            BigDecimal taxAmount = (BigDecimal)this.getDetailTable().getRow(rowIndex).getCell(this.TB_TAXAMOUNT).getValue();
            discountRate = this.validateNullValue(discountRate);
            qty = this.validateNullValue(qty);
            taxAmount = this.validateNullValue(taxAmount);
            taxAmount = taxAmount.abs();
            int scale = this.getDetailTable().getRow(rowIndex).getCell(this.TB_TAXPRICE).getEditor() == null ? 6 : ((KDFormattedTextField)this.getDetailTable().getRow(rowIndex).getCell(this.TB_TAXPRICE).getEditor().getComponent()).getPrecision();
            BigDecimal taxPrice = null;
            BigDecimal zero = new BigDecimal("0.0");
            if (qty != null && qty.compareTo(zero) != 0) {
                BigDecimal one = new BigDecimal("1.0");
                BigDecimal oneHundred = new BigDecimal("100.0");
                discountRate = one.subtract(discountRate.divide(oneHundred, 10, 4));
                if (taxAmount != null && qty != null) {
                    taxPrice = taxAmount.divide(qty, 10, 4);
                    if (discountRate.compareTo(ZERO) != 0) {
                        taxPrice = taxPrice.divide(discountRate, scale, 4);
                    }
                    this.getDetailTable().getRow(rowIndex).getCell(this.TB_TAXPRICE).setValue((Object)taxPrice.abs());
                }
            }
        } else {
            BigDecimal price = (BigDecimal)this.getDetailTable().getRow(rowIndex).getCell(this.TB_PRICE).getValue();
            BigDecimal taxRate = (BigDecimal)this.getDetailTable().getRow(rowIndex).getCell(this.TB_TAXRATE).getValue();
            price = this.validateNullValue(price);
            taxRate = this.validateNullValue(taxRate);
            int scale = this.getDetailTable().getRow(rowIndex).getCell(this.TB_TAXPRICE).getEditor() == null ? 6 : ((KDFormattedTextField)this.getDetailTable().getRow(rowIndex).getCell(this.TB_TAXPRICE).getEditor().getComponent()).getPrecision();
            BigDecimal taxPrice = CalculateUtils.calTaxPrice((BigDecimal)price, (BigDecimal)taxRate, (int)scale);
            this.getDetailTable().getRow(rowIndex).getCell(this.TB_TAXPRICE).setValue((Object)taxPrice.abs());
        }
        if (discountRate.compareTo(SCMConstant.BIGDECIMAL_ONEHUNDRED) == 0 || discountRate.compareTo(BigDecimal.ZERO) == 0) {
            this.getDetailTable().getRow(rowIndex).getCell("discountRate").setValue((Object)BigDecimal.ZERO);
        }
    }

    public void calPriceByPurchaseCost(int rowIndex, int colIndex) {
        if (this.TB_AMOUNT == null || this.TB_QTY == null || this.TB_PRICE == null || this.getDetailTable().getRow(rowIndex).getCell("discountRate") == null) {
            return;
        }
        BigDecimal amount = (BigDecimal)this.getDetailTable().getRow(rowIndex).getCell(this.TB_AMOUNT).getValue();
        BigDecimal qty = (BigDecimal)this.getDetailTable().getRow(rowIndex).getCell(this.TB_QTY).getValue();
        BigDecimal discountRate = (BigDecimal)this.getDetailTable().getRow(rowIndex).getCell("discountRate").getValue();
        amount = this.validateNullValue(amount);
        qty = this.validateNullValue(qty);
        discountRate = this.validateNullValue(discountRate);
        int scale = this.getDetailTable().getRow(rowIndex).getCell(this.TB_PRICE).getEditor() == null ? 6 : ((KDFormattedTextField)this.getDetailTable().getRow(rowIndex).getCell(this.TB_PRICE).getEditor().getComponent()).getPrecision();
        BigDecimal price = CalculateUtils.calPrice((BigDecimal)amount, (BigDecimal)qty, (BigDecimal)discountRate, (int)scale);
        this.getDetailTable().getRow(rowIndex).getCell(this.TB_PRICE).setValue((Object)(price == null ? BigDecimal.ZERO.setScale(scale, 4) : price));
    }

    private void calBaseQty(int rowIndex) throws EASBizException, BOSException {
        if (this.TB_MATERIAL == null || this.TB_BASEUNIT == null || this.TB_UNIT == null || this.TB_QTY == null || this.TB_BASEQTY == null) {
            return;
        }
        BigDecimal baseUnitQty = this.getQtyByConversion(rowIndex, this.TB_MATERIAL, this.TB_BASEUNIT, this.TB_UNIT, this.TB_QTY);
        if (baseUnitQty != null) {
            int scale = this.getDetailTable().getRow(rowIndex).getCell(this.TB_BASEQTY).getEditor() == null ? 6 : ((KDFormattedTextField)this.getDetailTable().getRow(rowIndex).getCell(this.TB_BASEQTY).getEditor().getComponent()).getPrecision();
            baseUnitQty = baseUnitQty.setScale(scale, 4);
        } else {
            baseUnitQty = new BigDecimal("0.00");
        }
        this.getDetailTable().getRow(rowIndex).getCell(this.TB_BASEQTY).setValue((Object)baseUnitQty);
    }

    public void calAssistQty(int rowIndex, int colIndex) throws EASBizException, BOSException {
        if (this.TB_MATERIAL == null || this.TB_ASSISTUNIT == null || this.TB_UNIT == null || this.TB_QTY == null || this.TB_ASSISTQTY == null) {
            return;
        }
        BigDecimal assistUnitQty = this.getQtyByConversion(rowIndex, this.TB_MATERIAL, this.TB_ASSISTUNIT, this.TB_UNIT, this.TB_QTY);
        if (assistUnitQty != null) {
            int scale = this.getDetailTable().getRow(rowIndex).getCell(this.TB_ASSISTQTY).getEditor() == null ? 6 : ((KDFormattedTextField)this.getDetailTable().getRow(rowIndex).getCell(this.TB_ASSISTQTY).getEditor().getComponent()).getPrecision();
            assistUnitQty = assistUnitQty.setScale(scale, 4);
        } else {
            assistUnitQty = new BigDecimal("0.00");
        }
        this.getDetailTable().getRow(rowIndex).getCell(this.TB_ASSISTQTY).setValue((Object)assistUnitQty);
    }

    public BigDecimal getQtyByConversion(int rowIndex, String material, String unit1, String unit2, String qty) throws EASBizException, BOSException {
        MeasureUnitInfo baseUnitInfo = (MeasureUnitInfo)this.getDetailTable().getRow(rowIndex).getCell(unit1).getValue();
        MeasureUnitInfo unitInfo = (MeasureUnitInfo)this.getDetailTable().getRow(rowIndex).getCell(unit2).getValue();
        BigDecimal orderQty = SCMClientUtils.castToBigDecimalForCell((KDTable)this.getDetailTable(), (int)rowIndex, (String)qty);
        MaterialInfo materialInfo = (MaterialInfo)this.getDetailTable().getRow(rowIndex).getCell(material).getValue();
        if (orderQty == null || baseUnitInfo == null || unitInfo == null || materialInfo == null) {
            return null;
        }
        return SCMClientUtils.getBaseUnitQty((KDTable)this.getDetailTable(), (int)rowIndex, (String)material, (String)unit1, (String)unit2, (String)qty);
    }

    public void calMaterialCost(int rowIndex) {
        if (this.TB_MATERIALCOST == null || this.TB_UNITMATERIALCOST == null || this.TB_QTY == null) {
            return;
        }
        int scale = this.getDetailTable().getRow(rowIndex).getCell(this.TB_MATERIALCOST).getEditor() == null ? 6 : ((KDFormattedTextField)this.getDetailTable().getRow(rowIndex).getCell(this.TB_MATERIALCOST).getEditor().getComponent()).getPrecision();
        BigDecimal zero = new BigDecimal("0.0");
        BigDecimal unitMaterialCost = (BigDecimal)this.getDetailTable().getRow(rowIndex).getCell(this.TB_UNITMATERIALCOST).getValue();
        BigDecimal qty = (BigDecimal)this.getDetailTable().getRow(rowIndex).getCell(this.TB_QTY).getValue();
        if (unitMaterialCost != null && qty != null) {
            this.getDetailTable().getRow(rowIndex).getCell(this.TB_MATERIALCOST).setValue((Object)unitMaterialCost.multiply(qty).setScale(scale, 4));
        } else {
            zero = zero.setScale(scale, 4);
            this.getDetailTable().getRow(rowIndex).getCell(this.TB_MATERIALCOST).setValue((Object)zero);
        }
    }

    private void calQty(int rowIndex) throws BaseException {
        if (this.TB_UNIT == null || this.TB_MATERIAL == null || this.TB_BASEQTY == null || this.TB_QTY == null) {
            return;
        }
        IRow curRow = this.getDetailTable().getRow(rowIndex);
        MeasureUnitInfo mulitInfo = (MeasureUnitInfo)curRow.getCell(this.TB_UNIT).getValue();
        MaterialInfo materialInfo = (MaterialInfo)curRow.getCell(this.TB_MATERIAL).getValue();
        BigDecimal baseQty = (BigDecimal)curRow.getCell(this.TB_BASEQTY).getValue();
        baseQty = this.validateNullValue(baseQty);
        if (mulitInfo != null && materialInfo != null) {
            BigDecimal unitQty = InvClientUtils.getUnitQty(mulitInfo, materialInfo, baseQty);
            curRow.getCell(this.TB_QTY).setValue((Object)unitQty);
        }
    }

    public void calUnitMaterialCost(int rowIndex) {
        if (this.TB_UNITMATERIALCOST == null || this.TB_MATERIALCOST == null || this.TB_QTY == null) {
            return;
        }
        int scale = this.getDetailTable().getRow(rowIndex).getCell(this.TB_UNITMATERIALCOST).getEditor() == null ? 6 : ((KDFormattedTextField)this.getDetailTable().getRow(rowIndex).getCell(this.TB_UNITMATERIALCOST).getEditor().getComponent()).getPrecision();
        BigDecimal materialCost = (BigDecimal)this.getDetailTable().getRow(rowIndex).getCell(this.TB_MATERIALCOST).getValue();
        materialCost = this.validateNullValue(materialCost);
        BigDecimal qty = (BigDecimal)this.getDetailTable().getRow(rowIndex).getCell(this.TB_QTY).getValue();
        if ((qty = this.validateNullValue(qty)).compareTo(ZERO) != 0) {
            this.getDetailTable().getRow(rowIndex).getCell(this.TB_UNITMATERIALCOST).setValue((Object)materialCost.divide(qty, scale, 4));
        }
    }

    public void tableChange_Cal(KDTEditEvent e, ExchangeRateInfo exchangeRateinfo) throws Exception {
        int rowIndex = e.getRowIndex();
        int colIndex = e.getColIndex();
        if (this.getDetailTable() == null) {
            return;
        }
        if (rowIndex < 0 || colIndex < 0) {
            return;
        }
        if (this.getDetailTable().getRow(rowIndex) == null) {
            return;
        }
        String fieldName = this.getDetailTable().getColumnKey(colIndex);
        if (this.TB_PRICE != null && this.TB_PRICE.equalsIgnoreCase(fieldName)) {
            this.calByPrice(rowIndex, colIndex, exchangeRateinfo);
        } else if (this.TB_TAXPRICE != null && this.TB_TAXPRICE.equalsIgnoreCase(fieldName)) {
            this.calByEntryTaxPrice(rowIndex, colIndex, exchangeRateinfo);
        } else if (this.TB_TAXRATE != null && this.TB_TAXRATE.equalsIgnoreCase(fieldName)) {
            this.calByEntryTaxRate(rowIndex, colIndex, exchangeRateinfo);
        } else if ("discountRate" != null && "discountRate".equalsIgnoreCase(fieldName)) {
            this.calByEntryDiscountRate(rowIndex, colIndex, exchangeRateinfo);
        } else if ("txtExchangeRate" != null && "txtExchangeRate".equalsIgnoreCase(fieldName)) {
            this.calByExchangeRate(rowIndex, colIndex, exchangeRateinfo);
        } else if (this.TB_AMOUNT != null && this.TB_AMOUNT.equalsIgnoreCase(fieldName)) {
            this.calByAmount(rowIndex, colIndex, exchangeRateinfo);
        } else if (this.TB_TAXAMOUNT != null && this.TB_TAXAMOUNT.equalsIgnoreCase(fieldName)) {
            this.calByTaxAmount(rowIndex, colIndex, exchangeRateinfo);
        } else if (this.TB_TAX != null && this.TB_TAX.equalsIgnoreCase(fieldName)) {
            this.calByTax(rowIndex, colIndex, exchangeRateinfo);
        } else if (this.TB_QTY != null && this.TB_QTY.equalsIgnoreCase(fieldName)) {
            this.calByQty(rowIndex, colIndex, exchangeRateinfo);
        } else if (this.TB_UNIT != null && this.TB_UNIT.equalsIgnoreCase(fieldName)) {
            this.calByUnit(rowIndex, colIndex, exchangeRateinfo);
        } else if (this.TB_PURCHASECOST != null && this.TB_PURCHASECOST.equalsIgnoreCase(fieldName)) {
            this.calByPurchaseCost(rowIndex, colIndex, exchangeRateinfo);
        } else if (this.TB_UNITPURCHASECOST != null && this.TB_UNITPURCHASECOST.equalsIgnoreCase(fieldName)) {
            this.calByUnitPurchaseCost(rowIndex, colIndex, exchangeRateinfo);
        } else if (this.TB_ACTUALCOST != null && this.TB_ACTUALCOST.equalsIgnoreCase(fieldName)) {
            this.calByActualCost(rowIndex, colIndex, exchangeRateinfo);
        } else if (this.TB_UNITACTUALCOST != null && this.TB_UNITACTUALCOST.equalsIgnoreCase(fieldName)) {
            this.calByUnitActualCost(rowIndex, colIndex, exchangeRateinfo);
        } else if (this.TB_PURCHASEFEE != null && this.TB_PURCHASEFEE.equalsIgnoreCase(fieldName)) {
            this.calByUnitPurchaseFee(rowIndex, colIndex, exchangeRateinfo);
        } else if (this.TB_UNITMATERIALCOST != null && this.TB_UNITMATERIALCOST.equalsIgnoreCase(fieldName)) {
            this.calByUnitMaterialCost(rowIndex, colIndex, exchangeRateinfo);
        } else if (this.TB_MATERIALCOST != null && this.TB_MATERIALCOST.equalsIgnoreCase(fieldName)) {
            this.calByMaterialCost(rowIndex, colIndex, exchangeRateinfo);
        } else if ("prmtCurrency" != null && "prmtCurrency".equalsIgnoreCase(fieldName)) {
            this.calByCurrency(rowIndex, colIndex, exchangeRateinfo);
        } else if (this.TB_DISCOUNTAMOUNT != null && this.TB_DISCOUNTAMOUNT.equalsIgnoreCase(fieldName)) {
            this.calByEntryDiscountAmount(rowIndex, colIndex, exchangeRateinfo);
        }
    }

    public void calUnitPurchaseCostForTax(int rowIndex, ExchangeRateInfo exchangeRateinfo) {
        if (this.TB_PRICE == null || this.TB_QTY == null || this.TB_PURCHASECOST == null || this.TB_ACTUALPRICE == null || this.TB_UNITPURCHASECOST == null) {
            return;
        }
        int scale = this.getDetailTable().getRow(rowIndex).getCell(this.TB_PRICE).getEditor() == null ? 2 : ((KDFormattedTextField)this.getDetailTable().getRow(rowIndex).getCell(this.TB_PRICE).getEditor().getComponent()).getPrecision();
        BigDecimal exchangerate = this.txtExchangeRate.getBigDecimalValue();
        exchangerate = this.validateNullValue(exchangerate);
        if (this.cbIsInTax.isSelected()) {
            BigDecimal purchaseCost = (BigDecimal)this.getDetailTable().getRow(rowIndex).getCell(this.TB_PURCHASECOST).getValue();
            BigDecimal qty = (BigDecimal)this.getDetailTable().getRow(rowIndex).getCell(this.TB_QTY).getValue();
            BigDecimal unitPurchaseCost = SysConstant.BIGZERO;
            if (purchaseCost != null && qty != null && qty.compareTo(ZERO) != 0) {
                unitPurchaseCost = purchaseCost.divide(qty, scale, 4);
                this.getDetailTable().getRow(rowIndex).getCell(this.TB_UNITPURCHASECOST).setValue((Object)unitPurchaseCost);
            }
        }
    }

    public void setExchangeRate(KDFormattedTextField txtExChangeRate) {
        this.txtExchangeRate = txtExChangeRate;
    }

    public void setCurrency(KDBizPromptBox bizPrmtCurrency) {
        this.prmtCurrency = bizPrmtCurrency;
    }

    public void setIsInTax(KDCheckBox cbIsInTax) {
        this.cbIsInTax = cbIsInTax;
    }

    public void setTaxPrice(KDCheckBox chkIsPriceInTax) {
        this.chkIsPriceInTax = chkIsPriceInTax;
    }

    public void calByEntryTaxPriceForManual(int rowIndex, int colIndex, ExchangeRateInfo exchangeRateinfo) {
        this.calDiscountAmountByTaxPrice(rowIndex, colIndex);
        this.calTaxAmountByTaxPrice(rowIndex, colIndex);
        this.calTax(rowIndex, colIndex);
        this.calLocalTaxAmount(rowIndex, exchangeRateinfo);
        this.calAmount(rowIndex, colIndex);
        this.calLocalTax(rowIndex, exchangeRateinfo);
        this.calActualTaxPrice(rowIndex, colIndex);
        this.calActualPrice(rowIndex, colIndex);
        this.calPurchaseCost(rowIndex, exchangeRateinfo);
        this.calUnitPurchaseCost(rowIndex, exchangeRateinfo);
        this.calActualCost(rowIndex);
        this.calUnitActualCost(rowIndex);
    }

    public void calByPriceForManual(int rowIndex, int colIndex, ExchangeRateInfo exchangeRateinfo) {
        this.calAmount(rowIndex, colIndex);
        this.calTax(rowIndex, colIndex);
        this.calLocalTax(rowIndex, exchangeRateinfo);
        this.calActualPrice(rowIndex, colIndex);
        this.calTaxAmountByTaxPrice(rowIndex, colIndex);
        this.calDiscountAmountByTaxPrice(rowIndex, colIndex);
        this.calActualTaxPrice(rowIndex, colIndex);
        this.calLocalTaxAmount(rowIndex, exchangeRateinfo);
        this.calPurchaseCostByPrice(rowIndex, exchangeRateinfo);
        this.calUnitPurchaseCostByAmount(rowIndex, exchangeRateinfo);
        this.calActualCost(rowIndex);
        this.calUnitActualCost(rowIndex);
    }

    public void calEntryActualCostByStadardCost(int rowIndex, SCMFetchData fetchedData) throws BOSException {
    }

    public void calByEntryDiscountAmount(int rowIndex, int colIndex, ExchangeRateInfo exchangeRateinfo) {
        if (this.cbIsInTax.isSelected()) {
            this.calDiscountTaxByTaxPrice(rowIndex, colIndex);
            this.calTaxAmountByTaxPrice(rowIndex, colIndex);
            this.calTax(rowIndex, colIndex);
            this.calLocalTaxAmount(rowIndex, exchangeRateinfo);
            this.calLocalTax(rowIndex, exchangeRateinfo);
            this.calAmount(rowIndex, colIndex);
            this.calActualTaxPrice(rowIndex, colIndex);
            this.calActualPrice(rowIndex, colIndex);
            this.calPurchaseCost(rowIndex, exchangeRateinfo);
            this.calUnitPurchaseCost(rowIndex, exchangeRateinfo);
            this.calActualCost(rowIndex);
            this.calUnitActualCost(rowIndex);
        } else {
            this.calAmountNoTax4DiscountAmountChanged(rowIndex, colIndex);
            this.calDiscountTaxByTaxPrice(rowIndex, colIndex);
            this.calTax(rowIndex, colIndex);
            this.calTaxAmountByTaxPrice(rowIndex, colIndex);
            this.calLocalTax(rowIndex, exchangeRateinfo);
            this.calActualPrice(rowIndex, colIndex);
            this.calActualTaxPrice(rowIndex, colIndex);
            this.calLocalTaxAmount(rowIndex, exchangeRateinfo);
            this.calPurchaseCostByPrice(rowIndex, exchangeRateinfo);
            this.calUnitPurchaseCostByAmount(rowIndex, exchangeRateinfo);
            this.calActualCost(rowIndex);
            this.calUnitActualCost(rowIndex);
        }
    }

    public void calAmountNoTax4DiscountAmountChanged(int rowIndex, int colIndex) {
        if (this.TB_AMOUNT == null || this.TB_TAXRATE == null || this.TB_PRICE == null || this.TB_QTY == null || this.getDetailTable().getRow(rowIndex).getCell(this.TB_DISCOUNTAMOUNT) == null) {
            return;
        }
        int scale = this.getDetailTable().getRow(rowIndex).getCell(this.TB_AMOUNT).getEditor() == null ? 6 : ((KDFormattedTextField)this.getDetailTable().getRow(rowIndex).getCell(this.TB_AMOUNT).getEditor().getComponent()).getPrecision();
        BigDecimal price = (BigDecimal)this.getDetailTable().getRow(rowIndex).getCell(this.TB_PRICE).getValue();
        BigDecimal discountAmount = (BigDecimal)this.getDetailTable().getRow(rowIndex).getCell(this.TB_DISCOUNTAMOUNT).getValue();
        BigDecimal qty = (BigDecimal)this.getDetailTable().getRow(rowIndex).getCell(this.TB_QTY).getValue();
        BigDecimal taxRate = (BigDecimal)this.getDetailTable().getRow(rowIndex).getCell(this.TB_TAXRATE).getValue();
        BigDecimal one = new BigDecimal("1.0");
        BigDecimal oneHundred = new BigDecimal("100.0");
        price = this.validateNullValue(price);
        discountAmount = this.validateNullValue(discountAmount);
        qty = this.validateNullValue(qty);
        taxRate = this.validateNullValue(taxRate);
        BigDecimal amount = qty.multiply(price).subtract(discountAmount.divide(one.add(taxRate.divide(oneHundred, 10, 4)), 10, 4));
        amount = amount.setScale(scale, 4);
        this.getDetailTable().getRow(rowIndex).getCell(this.TB_AMOUNT).setValue((Object)amount);
    }

    public void calDiscountTaxByTaxPrice(int rowIndex, int colIndex) {
        if (this.TB_TAXPRICE == null || this.TB_QTY == null || this.getDetailTable().getRow(rowIndex).getCell(this.TB_DISCOUNTAMOUNT) == null || "discountRate" == null) {
            return;
        }
        int scale = this.getDiscountRate();
        BigDecimal taxPrice = (BigDecimal)this.getDetailTable().getRow(rowIndex).getCell(this.TB_TAXPRICE).getValue();
        BigDecimal qty = (BigDecimal)this.getDetailTable().getRow(rowIndex).getCell(this.TB_QTY).getValue();
        BigDecimal discountAmount = (BigDecimal)this.getDetailTable().getRow(rowIndex).getCell(this.TB_DISCOUNTAMOUNT).getValue();
        BigDecimal oneHundred = new BigDecimal("100.0");
        taxPrice = this.validateNullValue(taxPrice);
        qty = this.validateNullValue(qty);
        discountAmount = this.validateNullValue(discountAmount);
        if (taxPrice.multiply(qty).compareTo(ZERO) == 0) {
            return;
        }
        BigDecimal discountRate = discountAmount.divide(taxPrice.multiply(qty), 10, 4).multiply(oneHundred).setScale(scale, 4);
        this.getDetailTable().getRow(rowIndex).getCell("discountRate").setValue((Object)discountRate);
    }
}

