/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.vmi.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.RealModeIDList;
import com.kingdee.eas.scm.cal.CostAdjustBillFactory;
import com.kingdee.eas.scm.cal.client.CostAdjustBillEditUI;
import com.kingdee.eas.scm.common.client.SCMGroupClientUtils;
import com.kingdee.eas.scm.im.inv.ManufactureRecBillFactory;
import com.kingdee.eas.scm.im.inv.MaterialReqBillFactory;
import com.kingdee.eas.scm.im.inv.MoveInWarehsBillFactory;
import com.kingdee.eas.scm.im.inv.MoveIssueBillFactory;
import com.kingdee.eas.scm.im.inv.MoveLocationBillFactory;
import com.kingdee.eas.scm.im.inv.OtherInWarehsBillFactory;
import com.kingdee.eas.scm.im.inv.OtherIssueBillFactory;
import com.kingdee.eas.scm.im.inv.PurInWarehsBillFactory;
import com.kingdee.eas.scm.im.inv.SaleIssueBillFactory;
import com.kingdee.eas.scm.im.inv.client.ManufactureRecBillEditUI;
import com.kingdee.eas.scm.im.inv.client.MaterialReqBillEditUI;
import com.kingdee.eas.scm.im.inv.client.MoveInWarehsBillEditUI;
import com.kingdee.eas.scm.im.inv.client.MoveIssueBillEditUI;
import com.kingdee.eas.scm.im.inv.client.MoveLocationBillEditUI;
import com.kingdee.eas.scm.im.inv.client.OtherInWarehsBillEditUI;
import com.kingdee.eas.scm.im.inv.client.OtherIssueBillEditUI;
import com.kingdee.eas.scm.im.inv.client.PurInWarehsBillEditUI;
import com.kingdee.eas.scm.im.inv.client.SaleIssueBillEditUI;
import com.kingdee.eas.scm.im.inv.vmi.IVMISettleOptFacade;
import com.kingdee.eas.scm.im.inv.vmi.VMISettleGroupFactory;
import com.kingdee.eas.scm.im.inv.vmi.VMISettleOptFacadeFactory;
import com.kingdee.eas.scm.im.inv.vmi.client.AbstractVMISettleReportUI;
import com.kingdee.eas.scm.im.inv.vmi.client.VMISettleReportConditionUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class VMISettleReportUI
extends AbstractVMISettleReportUI {
    private static final Logger logger = CoreUIObject.getLogger(VMISettleReportUI.class);
    private CommonQueryDialog commonQuerydialog;
    private VMISettleReportConditionUI instance;

    public String[] getMergeColumnKeys() {
        String[] strMergeColKeys = new String[]{"companyOrgUnit1.name", "number", "settleDate", "settleYear", "settlePeriod"};
        return strMergeColKeys;
    }

    @Override
    public void initUIMenuBarLayout() {
        super.initUIMenuBarLayout();
        this.menuItemAddNew.setVisible(false);
    }

    protected void beforeExcutQuery(EntityViewInfo ev) {
        super.beforeExcutQuery(ev);
        if (ev != null) {
            ev.getSorter().clear();
            SorterItemInfo itemInfo = new SorterItemInfo("number");
            itemInfo.setSortType(SortType.DESCEND);
            ev.getSorter().add(itemInfo);
            itemInfo = new SorterItemInfo("entry.seq");
            itemInfo.setSortType(SortType.ASCEND);
            ev.getSorter().add(itemInfo);
        }
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnVoucher.setVisible(true);
        this.btnDelVoucher.setVisible(true);
        this.btnLocate.setVisible(false);
        this.menuItemLocate.setVisible(false);
        this.btnAddNew.setVisible(false);
        this.btnEdit.setVisible(false);
        this.btnRemove.setVisible(false);
        this.btnCreateTo.setVisible(false);
        this.btnWFViewdoProccess.setVisible(false);
        this.btnWorkFlowG.setVisible(false);
        this.btnWorkFlowList.setVisible(false);
        this.btnAuditResult.setVisible(false);
        this.btnTraceDown.setVisible(false);
        this.btnTraceUp.setVisible(false);
        this.btnAuditResult.setVisible(false);
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.menuEdit.setVisible(false);
        this.btnAuditResult.setVisible(false);
        this.btnVoucher.setVisible(false);
        this.btnDelVoucher.setVisible(false);
        this.menuItemTraceDown.setVisible(false);
        this.menuItemTraceUp.setVisible(false);
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Company;
    }

    protected boolean isIgnoreCUFilter() {
        return true;
    }

    protected boolean initDefaultFilter() {
        return true;
    }

    protected boolean isAllowDefaultSolutionNull() {
        return false;
    }

    protected CommonQueryDialog initCommonQueryDialog() {
        if (this.commonQuerydialog == null) {
            if (this.mainQuery == null) {
                this.mainQuery = new EntityViewInfo();
            }
            this.commonQuerydialog = super.initCommonQueryDialog();
            this.commonQuerydialog.setWidth(495);
            this.commonQuerydialog.setHeight(320);
            this.commonQuerydialog.setShowSorter(true);
            this.commonQuerydialog.setShowFilter(true);
            try {
                this.instance = new VMISettleReportConditionUI(this);
                this.commonQuerydialog.addUserPanel((KDPanel)this.instance);
            }
            catch (Exception e) {
                this.handUIException(e);
                SysUtil.abort();
            }
        }
        return this.commonQuerydialog;
    }

    @Override
    public void unSettleAction_actionPerformed(ActionEvent e) throws Exception {
        ArrayList list = this.getSelectedIdValues();
        if (list.isEmpty()) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            return;
        }
        int unSettleCount = list.size();
        HashSet idSet = new HashSet(list);
        IVMISettleOptFacade vmiSettleOptFacade = VMISettleOptFacadeFactory.getRemoteInstance();
        Map resultMap = vmiSettleOptFacade.unSettleNew(idSet);
        StringBuffer errorMsg = (StringBuffer)resultMap.get("ERROR_MSG");
        int errorCount = (Integer)resultMap.get("ERROR_COUNT");
        if (errorCount == 0) {
            MsgBox.showInfo((String)this.getResource("UnSettleSuccess"));
            this.actionRefresh_actionPerformed(e);
        } else if (errorCount > 0 && errorCount < unSettleCount) {
            MsgBox.showDetailAndOK((Component)((Object)this), (String)this.getResource("UnSettlePartSuccess", new Object[]{unSettleCount - errorCount, errorCount}), (String)errorMsg.toString(), (int)8188);
            this.actionRefresh_actionPerformed(e);
        } else {
            MsgBox.showDetailAndOK((Component)((Object)this), (String)this.getResource("UnSettleFailure"), (String)errorMsg.toString(), (int)8188);
        }
    }

    private boolean isAuthoriedForOrg(String companyOrgUnit) throws EASBizException, BOSException {
        boolean isAuthoried = false;
        UserInfo user = SysContext.getSysContext().getCurrentUserInfo();
        if (null != companyOrgUnit) {
            FullOrgUnitCollection result = SCMGroupClientUtils.getAuthOrgByPermItem((IObjectPK)new ObjectUuidPK(user.getId().toString()), (OrgType)OrgType.Company, (String)this.getViewPermission());
            for (int i = 0; null != result && i < result.size(); ++i) {
                if (!result.get(i).getId().toString().equals(companyOrgUnit)) continue;
                isAuthoried = true;
                break;
            }
        }
        return isAuthoried;
    }

    protected String getViewPermission() {
        return "vmisettle_unsettle";
    }

    private String getResource(String key) {
        return EASResource.getString((String)"com.kingdee.eas.scm.im.inv.vmi.VMISettleResource", (String)key);
    }

    private String getResource(String key, Object[] params) {
        return EASResource.getString((String)"com.kingdee.eas.scm.im.inv.vmi.VMISettleResource", (String)key, (Object[])params);
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        if (!this.checkObjectExists()) {
            return;
        }
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ID", (Object)this.getSelectedDetailKeyValue());
        String storageOrgUnitId = this.getCellValue("storageOrgUnit.id");
        String editUIPermission = this.getDetailEditUIPermission();
        if (storageOrgUnitId != null && editUIPermission != null) {
            IPermission iPermission = PermissionFactory.getRemoteInstance();
            iPermission.checkFunctionPermission(this.getUserPk(), (IObjectPK)new ObjectUuidPK(storageOrgUnitId), editUIPermission);
        }
        this.prepareDetailUIContext(uiContext, e);
        IUIWindow uiWindow = null;
        uiWindow = SwingUtilities.getWindowAncestor((Component)((Object)this)) != null && SwingUtilities.getWindowAncestor((Component)((Object)this)) instanceof JDialog ? UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(this.getDetailEditUIName(), (Map)uiContext, null, OprtState.VIEW) : UIFactory.createUIFactory((String)this.getEditUIModal()).create(this.getDetailEditUIName(), (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
    }

    protected String getCellValue(String cellField) {
        KDTSelectBlock selectBlock = this.tblMain.getSelectManager().get();
        if (selectBlock != null) {
            Object keyValue;
            int rowIndex = selectBlock.getTop();
            IRow row = this.tblMain.getRow(rowIndex);
            if (row == null) {
                return null;
            }
            ICell cell = row.getCell(cellField);
            if (cell == null) {
                MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Error_KeyField_Fail"));
                SysUtil.abort();
            }
            if ((keyValue = cell.getValue()) != null) {
                return keyValue.toString();
            }
        }
        return null;
    }

    private boolean checkObjectExists() throws BOSException, EASBizException, Exception {
        if (this.getSelectedDetailKeyValue() == null) {
            return false;
        }
        if (!this.getDetailBizInterface().exists((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)this.getSelectedDetailKeyValue())))) {
            throw new EASBizException(EASBizException.CHECKEXIST);
        }
        return true;
    }

    protected void prepareDetailUIContext(UIContext uiContext, ActionEvent e) {
        RealModeIDList idList = new RealModeIDList();
        idList.add(this.getSelectedDetailKeyValue());
        uiContext.put((Object)"IDList", (Object)idList);
    }

    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        IObjectPK logPK = null;
        try {
            logPK = LogUtil.beginLog(null, (String)this.getResource("vmiSettle_settleRecordPrint"), (BOSObjectType)BOSObjectType.create((String)"5C1E1314"), null, null, (String)"vmiSettle_settleRecordPrint");
        }
        catch (Exception ex) {
            this.handUIExceptionAndAbort(ex);
        }
        super.actionPrint_actionPerformed(e);
        LogUtil.afterLog(null, (IObjectPK)logPK);
    }

    public void actionPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrintPreview_actionPerformed(e);
    }

    protected String getSelectedDetailKeyValue() {
        KDTSelectBlock selectBlock = this.tblMain.getSelectManager().get();
        if (selectBlock != null) {
            Object keyValue;
            int rowIndex = selectBlock.getTop();
            IRow row = this.tblMain.getRow(rowIndex);
            if (row == null) {
                return null;
            }
            ICell cell = row.getCell(this.getDetailKeyFieldName());
            if (cell == null) {
                MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Error_KeyField_Fail"));
                SysUtil.abort();
            }
            if (!((keyValue = cell.getValue()) == null || keyValue.equals("0") || keyValue.equals(" ") || keyValue.equals(""))) {
                return keyValue.toString();
            }
            return null;
        }
        return null;
    }

    protected String getKeyFieldName() {
        return "id";
    }

    protected String getDetailKeyFieldName() {
        return "entry.billID";
    }

    public void checkSelected() {
        if (this.tblMain.getSelectManager().size() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            SysUtil.abort();
        }
    }

    protected String getDetailEditUIModal() {
        return "com.kingdee.eas.base.uiframe.client.UINewFrameFactory";
    }

    protected String getDetailEditUIName() {
        String billType = this.getCellValue("billType.number");
        if (billType.equals("103")) {
            return PurInWarehsBillEditUI.class.getName();
        }
        if (billType.equals("105")) {
            return ManufactureRecBillEditUI.class.getName();
        }
        if (billType.equals("107")) {
            return MoveInWarehsBillEditUI.class.getName();
        }
        if (billType.equals("109")) {
            return OtherInWarehsBillEditUI.class.getName();
        }
        if (billType.equals("102")) {
            return SaleIssueBillEditUI.class.getName();
        }
        if (billType.equals("104")) {
            return MaterialReqBillEditUI.class.getName();
        }
        if (billType.equals("106")) {
            return MoveIssueBillEditUI.class.getName();
        }
        if (billType.equals("108")) {
            return OtherIssueBillEditUI.class.getName();
        }
        if (billType.equals("410")) {
            return CostAdjustBillEditUI.class.getName();
        }
        if (billType.equals("120")) {
            return MoveLocationBillEditUI.class.getName();
        }
        return null;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return VMISettleGroupFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext());
    }

    protected ICoreBase getDetailBizInterface() throws Exception {
        String billType = this.getCellValue("billType.number");
        if (billType.equals("103")) {
            return PurInWarehsBillFactory.getRemoteInstance();
        }
        if (billType.equals("105")) {
            return ManufactureRecBillFactory.getRemoteInstance();
        }
        if (billType.equals("107")) {
            return MoveInWarehsBillFactory.getRemoteInstance();
        }
        if (billType.equals("109")) {
            return OtherInWarehsBillFactory.getRemoteInstance();
        }
        if (billType.equals("102")) {
            return SaleIssueBillFactory.getRemoteInstance();
        }
        if (billType.equals("104")) {
            return MaterialReqBillFactory.getRemoteInstance();
        }
        if (billType.equals("106")) {
            return MoveIssueBillFactory.getRemoteInstance();
        }
        if (billType.equals("108")) {
            return OtherIssueBillFactory.getRemoteInstance();
        }
        if (billType.equals("410")) {
            return CostAdjustBillFactory.getRemoteInstance();
        }
        if (billType.equals("120")) {
            return MoveLocationBillFactory.getRemoteInstance();
        }
        return null;
    }

    protected String getDetailEditUIPermission() {
        String billType = this.getCellValue("billType.number");
        if (billType.equals("103")) {
            return "purinwarehs_view";
        }
        if (billType.equals("105")) {
            return "manufacturerec_view";
        }
        if (billType.equals("107")) {
            return "moveinwarehs_view";
        }
        if (billType.equals("109")) {
            return "otherinwarehs_view";
        }
        if (billType.equals("102")) {
            return "saleissue_view";
        }
        if (billType.equals("104")) {
            return "materialreq_view";
        }
        if (billType.equals("106")) {
            return "moveissue_view";
        }
        if (billType.equals("108")) {
            return "otherissue_view";
        }
        if (billType.equals("410")) {
            return "costadjust_view";
        }
        if (billType.equals("120")) {
            return "movelocation_view";
        }
        return null;
    }

    protected KDTable getTableForPrintSetting() {
        return this.tblMain;
    }
}

