/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.vmi.model;

import com.kingdee.bos.metadata.data.ColumnInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.eas.scm.im.inv.vmi.QueryTableDefInfo;
import com.kingdee.util.LocaleUtils;
import java.io.Serializable;
import java.util.Locale;

public class PropertyMeta
implements Serializable {
    private static final long serialVersionUID = 1L;
    private QueryTableDefInfo dataTable;
    private PropertyInfo property;
    private String fieldFullAlias;
    private int seq;

    public PropertyMeta(QueryTableDefInfo dataTable, PropertyInfo property, int seq) {
        this.dataTable = dataTable;
        this.property = property;
        this.seq = seq;
    }

    public String getName() {
        return this.property.getName();
    }

    public String getFullName() {
        return this.dataTable.getTableAlias() + "." + this.property.getName();
    }

    public String getAlias() {
        return this.property.getAlias();
    }

    public String getFullAlias() {
        return this.dataTable.getName() + "." + this.property.getAlias();
    }

    public String getAlias(Locale locale) {
        return this.property.getAlias(locale);
    }

    public String getFullAlias(Locale locale) {
        return this.dataTable.getName() + "." + this.property.getAlias(locale);
    }

    public String getFullSQLFieldName(Locale locale) {
        if (this.property.get("isMultilingual").equals("false")) {
            return this.dataTable.getTableAlias() + "." + this.property.getMappingField().getName();
        }
        return this.dataTable.getTableAlias() + "." + this.property.getMappingField().getName() + "_" + LocaleUtils.getShortCode((Locale)locale);
    }

    public String getFullSQLFieldName() {
        return this.dataTable.getTableAlias() + "." + this.property.getMappingField().getName();
    }

    public String getDescription() {
        return this.property.getDescription();
    }

    public String getDescription(Locale locale) {
        return this.property.getDescription(locale);
    }

    public ColumnInfo getMappingField() {
        return this.property.getMappingField();
    }

    public String getDataType() {
        String dataType = this.property.getString("dataType");
        if (this.property instanceof LinkPropertyInfo) {
            dataType = "F7";
        }
        return dataType;
    }

    public String getRelationBosType() {
        if (this.property instanceof LinkPropertyInfo) {
            return ((LinkPropertyInfo)this.property).getRelationship().getSupplierObject().getType().toString();
        }
        return null;
    }

    public String getEnumClassName() {
        return this.property.getString("metadataRef");
    }

    public String getFieldName() {
        String propertyName = null;
        propertyName = this.dataTable.isIsMainTable() ? this.property.getName() : this.dataTable.getTableAlias() + "." + this.property.getName();
        return propertyName;
    }

    public String getFieldAlias() {
        String propertyName = null;
        propertyName = this.dataTable.isIsMainTable() ? this.property.getAlias() : this.dataTable.getName() + "." + this.property.getAlias();
        return propertyName;
    }

    public String toString() {
        String propertyName = null;
        propertyName = this.dataTable.isIsMainTable() ? this.property.getName() + "(" + this.property.getAlias() + ")" : this.dataTable.getTableAlias() + "." + this.property.getName() + "(" + this.property.getAlias() + ")";
        return propertyName;
    }

    public int hashCode() {
        return this.property.hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof PropertyMeta) {
            return this.property.equals((Object)((PropertyMeta)o).property);
        }
        return false;
    }

    public QueryTableDefInfo getDataTable() {
        return this.dataTable;
    }

    public PropertyInfo getProperty() {
        return this.property;
    }

    public int getSeq() {
        return this.seq;
    }

    public void setSeq(int seq) {
        this.seq = seq;
    }

    public String getFieldFullAlias() {
        return this.fieldFullAlias;
    }

    public void setFieldFullAlias(String fieldFullAlias) {
        this.fieldFullAlias = fieldFullAlias;
    }
}

