/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.vmi.util;

import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.eas.scm.common.util.StringUtil;
import com.kingdee.eas.scm.im.inv.vmi.FieldDefInfo;
import com.kingdee.eas.scm.im.inv.vmi.FieldEntryDefInfo;
import com.kingdee.eas.scm.im.inv.vmi.QueryDefInfo;
import com.kingdee.eas.scm.im.inv.vmi.QueryTableDefCollection;
import com.kingdee.eas.scm.im.inv.vmi.QueryTableDefInfo;
import com.kingdee.eas.scm.im.inv.vmi.model.PropertyMeta;
import com.kingdee.eas.scm.im.inv.vmi.model.PropertyMetaUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.tree.MutableTreeNode;

public class QueryTreeUtil {
    public static DefaultKingdeeTreeNode getFieldSelectTree(QueryDefInfo query, FieldDefInfo fieldDefInfo) {
        HashMap<String, FieldEntryDefInfo> fieldEntryMap = new HashMap<String, FieldEntryDefInfo>();
        FieldEntryDefInfo fieldEntryDefInfo = null;
        int size = fieldDefInfo.getEntry().size();
        for (int i = 0; i < size; ++i) {
            fieldEntryDefInfo = fieldDefInfo.getEntry().get(i);
            fieldEntryMap.put(fieldEntryDefInfo.getFieldFullAlias(), fieldEntryDefInfo);
        }
        QueryTableDefInfo mainTable = query.getMainTable();
        DefaultKingdeeTreeNode root = QueryTreeUtil.addTreeNode(null, mainTable);
        QueryTreeUtil.fillChildrenNode(root, query, mainTable, fieldEntryMap);
        QueryTreeUtil.addTableFieldNode(root, mainTable, fieldEntryMap);
        return root;
    }

    private static void fillChildrenNode(DefaultKingdeeTreeNode root, QueryDefInfo query, QueryTableDefInfo table, Map<String, FieldEntryDefInfo> fieldEntryMap) {
        if (table == null) {
            return;
        }
        QueryTableDefCollection coll = table.getChildren(query.getEntry());
        QueryTableDefInfo queryTableDefInfo = null;
        for (int i = 0; i < coll.size(); ++i) {
            queryTableDefInfo = coll.get(i);
            DefaultKingdeeTreeNode node = QueryTreeUtil.addTreeNode(root, queryTableDefInfo);
            QueryTreeUtil.fillChildrenNode(node, query, queryTableDefInfo, fieldEntryMap);
            QueryTreeUtil.addTableFieldNode(node, queryTableDefInfo, fieldEntryMap);
        }
    }

    private static DefaultKingdeeTreeNode addTreeNode(DefaultKingdeeTreeNode parent, QueryTableDefInfo table) {
        if (table == null) {
            return null;
        }
        DefaultKingdeeTreeNode treeNode = null;
        treeNode = new DefaultKingdeeTreeNode((Object)table);
        treeNode.setText(table.getName() + "(" + table.getTableAlias() + ")");
        if (parent != null) {
            parent.add((MutableTreeNode)treeNode);
        }
        return treeNode;
    }

    private static void addTableFieldNode(DefaultKingdeeTreeNode parent, QueryTableDefInfo table, Map<String, FieldEntryDefInfo> fieldEntryMap) {
        if (table == null) {
            return;
        }
        try {
            String alias = null;
            PropertyMeta property = null;
            FieldEntryDefInfo fieldEntryDefInfo = null;
            List<PropertyMeta> fieldList = PropertyMetaUtil.getEntityProperty(table);
            for (int i = 0; i < fieldList.size(); ++i) {
                property = fieldList.get(i);
                alias = table.getTableFullAlias();
                alias = StringUtil.isEmpty((String)alias) ? property.getProperty().getName() : alias + "." + property.getProperty().getName();
                if (QueryTreeUtil.isLinkProperty(property)) continue;
                property.setFieldFullAlias(alias);
                fieldEntryDefInfo = fieldEntryMap.get(alias);
                if (fieldEntryDefInfo != null) continue;
                QueryTreeUtil.addOneFieldNode(parent, property);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static DefaultKingdeeTreeNode addOneFieldNode(DefaultKingdeeTreeNode parent, PropertyMeta property) {
        DefaultKingdeeTreeNode treeNode = new DefaultKingdeeTreeNode((Object)property);
        treeNode.setText(property.getName() + "(" + property.getAlias() + ")");
        parent.add((MutableTreeNode)treeNode);
        return treeNode;
    }

    public static DefaultKingdeeTreeNode insertNode(DefaultKingdeeTreeNode parent, PropertyMeta property, int childIndex) {
        DefaultKingdeeTreeNode treeNode = new DefaultKingdeeTreeNode((Object)property);
        treeNode.setText(property.getName() + "(" + property.getAlias() + ")");
        parent.insert((MutableTreeNode)treeNode, childIndex);
        return treeNode;
    }

    private static boolean isLinkProperty(PropertyMeta property) {
        return property.getProperty() instanceof LinkPropertyInfo;
    }
}

